/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import net.claribole.zvtm.lens.XLinearLens;

public class XGaussianLens
extends XLinearLens {
    protected double c = 0.0;
    protected double e = 0.0;

    public XGaussianLens() {
        this.a = Math.PI / (double)(this.LR1 - this.LR2);
        this.b = -Math.PI * (double)this.LR2 / (double)(this.LR1 - this.LR2);
        this.c = (this.MM - 1.0f) / 2.0f;
        this.e = (1.0f + this.MM) / 2.0f;
    }

    public XGaussianLens(float mm) {
        super(mm);
        this.a = Math.PI / (double)(this.LR1 - this.LR2);
        this.b = -Math.PI * (double)this.LR2 / (double)(this.LR1 - this.LR2);
        this.c = (this.MM - 1.0f) / 2.0f;
        this.e = (1.0f + this.MM) / 2.0f;
    }

    public XGaussianLens(float mm, float tc, float tf, int outerRadius, int innerRadius) {
        super(mm, tc, tf, outerRadius, innerRadius);
        this.a = Math.PI / (double)(this.LR1 - this.LR2);
        this.b = -Math.PI * (double)this.LR2 / (double)(this.LR1 - this.LR2);
        this.c = (this.MM - 1.0f) / 2.0f;
        this.e = (1.0f + this.MM) / 2.0f;
    }

    public XGaussianLens(float mm, float tc, float tf, int outerRadius, int innerRadius, int x, int y) {
        super(mm, tc, tf, outerRadius, innerRadius, x, y);
        this.a = Math.PI / (double)(this.LR1 - this.LR2);
        this.b = -Math.PI * (double)this.LR2 / (double)(this.LR1 - this.LR2);
        this.c = (this.MM - 1.0f) / 2.0f;
        this.e = (1.0f + this.MM) / 2.0f;
    }

    public void gf(float x, float y, float[] g) {
        this.dd = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        if (this.dd <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.dd <= (double)this.LR1) {
            g[0] = g[1] = (float)(this.c * Math.cos(this.a * this.dd + this.b) + this.e);
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }

    void computeDropoffFactors() {
        this.aT = (this.MMTc - this.MMTf) / (float)(this.LR1 - this.LR2);
        this.bT = (this.MMTf * (float)this.LR1 - this.MMTc * (float)this.LR2) / (float)(this.LR1 - this.LR2);
        this.a = Math.PI / (double)(this.LR1 - this.LR2);
        this.b = -Math.PI * (double)this.LR2 / (double)(this.LR1 - this.LR2);
        this.c = (this.MM - 1.0f) / 2.0f;
        this.e = (1.0f + this.MM) / 2.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void transformI(WritableRaster iwr, WritableRaster ewr) {
        XGaussianLens xGaussianLens = this;
        synchronized (xGaussianLens) {
            if (this.BMl == null) {
                SinglePixelPackedSampleModel SMl = (SinglePixelPackedSampleModel)ewr.getSampleModel();
                SinglePixelPackedSampleModel SMm = (SinglePixelPackedSampleModel)iwr.getSampleModel();
                this.BMl = SMl.getBitMasks();
                this.BMm = SMm.getBitMasks();
                this.BOl = SMl.getBitOffsets();
                this.BOm = SMm.getBitOffsets();
            }
            iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsI);
            ewr.getDataElements(0, 0, this.mbw, this.mbh, this.mPixelsI);
            if (this.BMl.length == 4) {
                for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
                    for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                        this.gf(x, y, this.gain);
                        this.tmPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.mPixelsI[Math.round(((float)(y - this.lurd[1]) * this.MM - (float)this.mbh / 2.0f) / this.gain[1] + (float)this.mbh / 2.0f) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - (float)this.mbw / 2.0f) / this.gain[0] + (float)this.mbw / 2.0f)];
                        this.toPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.oPixelsI[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
                        this.Pl = this.tmPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                        this.Rl = (this.Pl & this.BMl[0]) >>> this.BOl[0];
                        this.Gl = (this.Pl & this.BMl[1]) >>> this.BOl[1];
                        this.Bl = (this.Pl & this.BMl[2]) >>> this.BOl[2];
                        this.Pm = this.toPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                        this.Rm = (this.Pm & this.BMm[0]) >>> this.BOm[0];
                        this.Gm = (this.Pm & this.BMm[1]) >>> this.BOm[1];
                        this.Bm = (this.Pm & this.BMm[2]) >>> this.BOm[2];
                        this.Am = (this.Pm & this.BMm[3]) >>> this.BOm[3];
                        this.gfT(x, y, this.gainT);
                        this.Rr = Math.round((float)this.Rl * this.gainT[0] + (float)this.Rm * (1.0f - this.gainT[0]));
                        this.Gr = Math.round((float)this.Gl * this.gainT[0] + (float)this.Gm * (1.0f - this.gainT[0]));
                        this.Br = Math.round((float)this.Bl * this.gainT[0] + (float)this.Bm * (1.0f - this.gainT[0]));
                        this.tPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.Rr << this.BOm[0] | this.Gr << this.BOl[1] | this.Br << this.BOl[2] | this.Am << this.BOl[3];
                    }
                }
            } else {
                for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
                    for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                        this.gf(x, y, this.gain);
                        this.tmPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.mPixelsI[Math.round(((float)(y - this.lurd[1]) * this.MM - (float)this.mbh / 2.0f) / this.gain[1] + (float)this.mbh / 2.0f) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - (float)this.mbw / 2.0f) / this.gain[0] + (float)this.mbw / 2.0f)];
                        this.toPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.oPixelsI[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
                        this.Pl = this.tmPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                        this.Rl = (this.Pl & this.BMl[0]) >>> this.BOl[0];
                        this.Gl = (this.Pl & this.BMl[1]) >>> this.BOl[1];
                        this.Bl = (this.Pl & this.BMl[2]) >>> this.BOl[2];
                        this.Pm = this.toPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                        this.Rm = (this.Pm & this.BMm[0]) >>> this.BOm[0];
                        this.Gm = (this.Pm & this.BMm[1]) >>> this.BOm[1];
                        this.Bm = (this.Pm & this.BMm[2]) >>> this.BOm[2];
                        this.gfT(x, y, this.gainT);
                        this.Rr = Math.round((float)this.Rl * this.gainT[0] + (float)this.Rm * (1.0f - this.gainT[0]));
                        this.Gr = Math.round((float)this.Gl * this.gainT[0] + (float)this.Gm * (1.0f - this.gainT[0]));
                        this.Br = Math.round((float)this.Bl * this.gainT[0] + (float)this.Bm * (1.0f - this.gainT[0]));
                        this.tPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.Rr << this.BOm[0] | this.Gr << this.BOl[1] | this.Br << this.BOl[2];
                    }
                }
            }
            iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsI);
        }
    }

    synchronized void transformS(WritableRaster iwr, WritableRaster ewr) {
        System.err.println("Error: translucent lens: Sample model not supported yet");
    }

    synchronized void transformB(WritableRaster iwr, WritableRaster ewr) {
        System.err.println("Error: translucent lens: Sample model not supported yet");
    }
}

