/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyThread;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpUtil;

public class ProxyServer
implements Runnable {
    protected Thread thread = null;
    protected static final int PORT_TIME_OUT = 0;
    protected ServerSocket proxySocket = null;
    protected boolean isProxyRunning = false;
    protected ProxyParam proxyParam = new ProxyParam();
    protected ConnectionParam connectionParam = new ConnectionParam();
    protected Vector listenerList = new Vector();
    protected boolean serialize = false;
    protected boolean enableCacheProcessing = false;
    protected Vector cacheProcessingList = new Vector();

    public boolean isEnableCacheProcessing() {
        return this.enableCacheProcessing;
    }

    public void setEnableCacheProcessing(boolean bl) {
        this.enableCacheProcessing = bl;
        if (!bl) {
            this.cacheProcessingList.clear();
        }
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public void setProxyParam(ProxyParam proxyParam) {
        this.proxyParam = proxyParam;
    }

    public ProxyParam getProxyParam() {
        return this.proxyParam;
    }

    public void setConnectionParam(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
    }

    public ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    public synchronized int startServer(String string, int n, boolean bl) {
        if (this.isProxyRunning) {
            this.stopServer();
        }
        this.isProxyRunning = false;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setPriority(6);
        this.proxySocket = null;
        for (int i = 0; i < 20 && this.proxySocket == null; ++i) {
            try {
                this.proxySocket = this.createServerSocket(string, n);
                this.proxySocket.setSoTimeout(0);
                this.isProxyRunning = true;
                continue;
            }
            catch (Exception exception) {
                if (!bl) {
                    exception.printStackTrace();
                    return -1;
                }
                if (n >= 65535) continue;
                ++n;
            }
        }
        if (this.proxySocket == null) {
            return -1;
        }
        this.thread.start();
        return this.proxySocket.getLocalPort();
    }

    public synchronized boolean stopServer() {
        if (!this.isProxyRunning) {
            return false;
        }
        this.isProxyRunning = false;
        HttpUtil.closeServerSocket(this.proxySocket);
        try {
            this.thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.proxySocket = null;
        return true;
    }

    public void run() {
        Socket socket = null;
        ProxyThread proxyThread = null;
        while (this.isProxyRunning) {
            try {
                socket = this.proxySocket.accept();
                proxyThread = this.createProxyProcess(socket);
                proxyThread.start();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected ServerSocket createServerSocket(String string, int n) throws UnknownHostException, IOException {
        ServerSocket serverSocket = new ServerSocket(n, 400, InetAddress.getByName(string));
        return serverSocket;
    }

    protected ProxyThread createProxyProcess(Socket socket) {
        ProxyThread proxyThread = new ProxyThread(this, socket);
        return proxyThread;
    }

    protected void writeOutput(String string) {
    }

    public void addProxyListener(ProxyListener proxyListener) {
        this.listenerList.add(proxyListener);
    }

    public void removeProxyListener(ProxyListener proxyListener) {
        this.listenerList.remove(proxyListener);
    }

    synchronized List getListenerList() {
        return this.listenerList;
    }

    public boolean isAnyProxyThreadRunning() {
        return ProxyThread.isAnyProxyThreadRunning();
    }

    public void setSerialize(boolean bl) {
        this.serialize = bl;
    }

    public void addCacheProcessingList(CacheProcessingItem cacheProcessingItem) {
        this.cacheProcessingList.add(cacheProcessingItem);
    }

    Vector getCacheProcessingList() {
        return this.cacheProcessingList;
    }
}

