/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class ErrorPageErrorHandler
extends ErrorHandler
implements ErrorHandler.ErrorPageMapper {
    public static final String GLOBAL_ERROR_PAGE = "org.eclipse.jetty.server.error_page.global";
    protected ServletContext _servletContext;
    private final Map<String, String> _errorPages = new HashMap<String, String>();
    private final List<ErrorCodeRange> _errorPageList = new ArrayList<ErrorCodeRange>();

    @Override
    public String getErrorPage(HttpServletRequest request) {
        Integer code;
        String error_page = null;
        Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
        while (error_page == null && th != null) {
            Class<?> exClass = th.getClass();
            error_page = this._errorPages.get(exClass.getName());
            while (error_page == null && (exClass = exClass.getSuperclass()) != null) {
                error_page = this._errorPages.get(exClass.getName());
            }
            th = th instanceof ServletException ? ((ServletException)th).getRootCause() : null;
        }
        if (error_page == null && (code = (Integer)request.getAttribute("javax.servlet.error.status_code")) != null && (error_page = this._errorPages.get(Integer.toString(code))) == null && this._errorPageList != null) {
            for (int i = 0; i < this._errorPageList.size(); ++i) {
                ErrorCodeRange errCode = this._errorPageList.get(i);
                if (!errCode.isInRange(code)) continue;
                error_page = errCode.getUri();
                break;
            }
        }
        if (error_page == null) {
            error_page = this._errorPages.get(GLOBAL_ERROR_PAGE);
        }
        return error_page;
    }

    public Map<String, String> getErrorPages() {
        return this._errorPages;
    }

    public void setErrorPages(Map<String, String> errorPages) {
        this._errorPages.clear();
        if (errorPages != null) {
            this._errorPages.putAll(errorPages);
        }
    }

    public void addErrorPage(Class<? extends Throwable> exception, String uri) {
        this._errorPages.put(exception.getName(), uri);
    }

    public void addErrorPage(String exceptionClassName, String uri) {
        this._errorPages.put(exceptionClassName, uri);
    }

    public void addErrorPage(int code, String uri) {
        this._errorPages.put(Integer.toString(code), uri);
    }

    public void addErrorPage(int from, int to, String uri) {
        this._errorPageList.add(new ErrorCodeRange(from, to, uri));
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._servletContext = ContextHandler.getCurrentContext();
    }

    private class ErrorCodeRange {
        private int _from;
        private int _to;
        private String _uri;

        ErrorCodeRange(int from, int to, String uri) throws IllegalArgumentException {
            if (from > to) {
                throw new IllegalArgumentException("from>to");
            }
            this._from = from;
            this._to = to;
            this._uri = uri;
        }

        boolean isInRange(int value) {
            return value >= this._from && value <= this._to;
        }

        String getUri() {
            return this._uri;
        }

        public String toString() {
            return "from: " + this._from + ",to: " + this._to + ",uri: " + this._uri;
        }
    }
}

