/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class TokenType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid token value");
        }
        if (string.charAt(0) == ' ' || string.charAt(n - 1) == ' ') {
            throw new DatatypeException(0, "invalid token value");
        }
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == '\n' || c2 == '\r' || c2 == '\t') {
                throw new DatatypeException(n2, "invalid token value");
            }
            if (c2 == ' ' && c == ' ') {
                throw new DatatypeException(n2, "invalid token value");
            }
            c = c2;
            ++n2;
        }
    }

    TokenType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "token"), TypeLibrary.NORMALIZED_STRING);
    }
}

