/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSS;
import org.apache.tools.ant.types.Commandline;

public class MSVSSCREATE
extends MSVSS {
    private String m_AutoResponse = null;
    private String m_Name = null;
    private String m_Comment = "-";
    private boolean m_Quiet = false;
    private boolean m_FailOnError = true;

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        int result = 0;
        if (this.getVsspath() == null) {
            String msg = "vsspath attribute must be set!";
            throw new BuildException(msg, this.location);
        }
        commandLine.setExecutable(this.getSSCommand());
        commandLine.createArgument().setValue("Create");
        commandLine.createArgument().setValue(this.getVsspath());
        commandLine.createArgument().setValue("-C" + this.getComment());
        this.getAutoresponse(commandLine);
        this.getQuietCommand(commandLine);
        this.getLoginCommand(commandLine);
        result = this.run(commandLine);
        if (result != 0 && this.m_FailOnError) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    public void setComment(String comment) {
        this.m_Comment = comment.equals("") || comment.equals("null") ? "-" : comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public final void setQuiet(boolean quiet) {
        this.m_Quiet = quiet;
    }

    public void getQuietCommand(Commandline cmd) {
        if (this.m_Quiet) {
            cmd.createArgument().setValue("-O-");
        }
    }

    public final void setFailOnError(boolean failOnError) {
        this.m_FailOnError = failOnError;
    }

    public void setAutoresponse(String response) {
        this.m_AutoResponse = response.equals("") || response.equals("null") ? null : response;
    }

    public void getAutoresponse(Commandline cmd) {
        if (this.m_AutoResponse == null) {
            cmd.createArgument().setValue("-I-");
        } else if (this.m_AutoResponse.equalsIgnoreCase("Y")) {
            cmd.createArgument().setValue("-I-Y");
        } else if (this.m_AutoResponse.equalsIgnoreCase("N")) {
            cmd.createArgument().setValue("-I-N");
        } else {
            cmd.createArgument().setValue("-I-");
        }
    }
}

