/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.javac.Shared;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.arg.SourceLevel;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiContainer;
import com.google.gwt.tools.apichecker.ApiDiffGenerator;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.ToolBase;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.types.ZipScanner;

public class ApiCompatibilityChecker
extends ToolBase {
    public static final boolean API_SOURCE_COMPATIBILITY = true;
    public static boolean DEBUG = false;
    public static final boolean DEBUG_DUPLICATE_REMOVAL = false;
    public static final boolean FILTER_DUPLICATES = true;
    public static final boolean PRINT_COMPATIBLE = false;
    public static final boolean PRINT_COMPATIBLE_WITH = false;
    public static final boolean PROCESS_EXISTING_API = true;
    public static final boolean PROCESS_NEW_API = true;
    public static final boolean REMOVE_NON_SUBCLASSABLE_ABSTRACT_CLASS_FROM_API = true;
    private Properties configProperties;
    private JarFile[] extraSourceJars;
    private JarFile gwtDevJar;
    private JarFile gwtUserJar;
    private boolean printAllApi = false;
    private JarFile[] refJars;
    private TreeLogger.Type type = TreeLogger.WARN;
    private Set<String> whiteList;

    public static Collection<ApiChange> getApiDiff(ApiContainer newApi, ApiContainer existingApi, Set<String> whiteList) throws NotFoundException {
        ApiDiffGenerator apiDiff = new ApiDiffGenerator(newApi, existingApi);
        return ApiCompatibilityChecker.getApiDiff(apiDiff, whiteList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            ApiCompatibilityChecker checker = new ApiCompatibilityChecker();
            if (!checker.processArgs(args)) {
                System.exit(1);
            }
            ApiContainer newApi = null;
            ApiContainer existingApi = null;
            PrintWriterTreeLogger logger = new PrintWriterTreeLogger();
            logger.setMaxDetail(checker.type);
            logger.log(TreeLogger.INFO, "gwtDevJar = " + checker.gwtDevJar + ", userJar = " + checker.gwtUserJar + ", refjars = " + Arrays.toString(checker.refJars) + ", logLevel = " + checker.type + ", printAllApi = " + checker.printAllApi, null);
            Set<String> excludedPackages = checker.getSetOfExcludedPackages(checker.configProperties);
            HashSet<Object> resources = new HashSet<Resource>();
            resources.addAll(new SourceFileResources(checker.configProperties.getProperty("dirRoot_new"), checker.getConfigPropertyAsSet("sourceFiles_new"), checker.getConfigPropertyAsSet("excludedFiles_new"), (TreeLogger)logger).getResources());
            resources.addAll(checker.getJavaxValidationCompilationUnits((TreeLogger)logger));
            resources.addAll(checker.getGwtCompilationUnits((TreeLogger)logger));
            SourceLevel newSourceLevel = SourceLevel.fromString((String)checker.configProperties.getProperty("sourceLevel_new"));
            newApi = new ApiContainer(checker.configProperties.getProperty("name_new"), resources, excludedPackages, (TreeLogger)logger, newSourceLevel);
            if (checker.printAllApi) {
                logger.log(TreeLogger.INFO, newApi.getApiAsString());
            }
            resources = new HashSet();
            if (checker.refJars == null) {
                resources.addAll(new SourceFileResources(checker.configProperties.getProperty("dirRoot_old"), checker.getConfigPropertyAsSet("sourceFiles_old"), checker.getConfigPropertyAsSet("excludedFiles_old"), (TreeLogger)logger).getResources());
            } else {
                resources.addAll(new JarFileResources(checker.refJars, checker.getConfigPropertyAsSet("sourceFiles_old"), checker.getConfigPropertyAsSet("excludedFiles_old"), (TreeLogger)logger).getResources());
            }
            resources.addAll(checker.getJavaxValidationCompilationUnits((TreeLogger)logger));
            resources.addAll(checker.getGwtCompilationUnits((TreeLogger)logger));
            SourceLevel oldSourceLevel = SourceLevel.fromString((String)checker.configProperties.getProperty("sourceLevel_old"));
            existingApi = new ApiContainer(checker.configProperties.getProperty("name_old"), resources, excludedPackages, (TreeLogger)logger, oldSourceLevel);
            if (checker.printAllApi) {
                logger.log(TreeLogger.INFO, existingApi.getApiAsString());
            }
            Collection<ApiChange> apiDifferences = ApiCompatibilityChecker.getApiDiff(newApi, existingApi, checker.whiteList);
            for (ApiChange apiChange : apiDifferences) {
                System.out.println(apiChange);
            }
            if (apiDifferences.size() == 0) {
                System.out.println("API compatibility check SUCCESSFUL");
            } else {
                System.out.println("API compatibility check FAILED");
            }
            System.exit(apiDifferences.size() == 0 ? 0 : 1);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                System.err.println("To view the help for this tool, execute this tool without any arguments");
            }
            finally {
                System.exit(-1);
            }
        }
    }

    static Collection<ApiChange> getApiDiff(ApiDiffGenerator apiDiff, Set<String> whiteList, boolean removeDuplicates) throws NotFoundException {
        Collection<ApiChange> collection = apiDiff.getApiDiff();
        if (removeDuplicates) {
            collection = apiDiff.removeDuplicates(collection);
        }
        HashSet<String> matchedWhiteList = new HashSet<String>();
        ArrayList<ApiChange> prunedCollection = new ArrayList<ApiChange>();
        for (ApiChange apiChange : collection) {
            String apiChangeAsString = apiChange.getStringRepresentationWithoutMessage();
            if (whiteList.contains(apiChangeAsString = apiChangeAsString.trim())) {
                matchedWhiteList.add(apiChangeAsString);
                continue;
            }
            if (apiChange.getStatus().equals((Object)ApiChange.Status.COMPATIBLE) || apiChange.getStatus().equals((Object)ApiChange.Status.COMPATIBLE_WITH)) continue;
            prunedCollection.add(apiChange);
        }
        whiteList.removeAll(matchedWhiteList);
        if (whiteList.size() > 0) {
            ArrayList<String> al = new ArrayList<String>(whiteList);
            Collections.sort(al);
            System.err.println("ApiChanges [");
            for (String apiChange : al) {
                System.err.println(apiChange);
            }
            System.err.println("],  not found. Are you using a properly formatted configuration file?");
        }
        ArrayList<ApiChange> apiChangeList = new ArrayList<ApiChange>(prunedCollection);
        Collections.sort(apiChangeList);
        return apiChangeList;
    }

    protected ApiCompatibilityChecker() {
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "Path of the gwt dev jar";
            }

            public String getTag() {
                return "-gwtDevJar";
            }

            public String[] getTagArgs() {
                return new String[]{"gwt_dev_jar_path"};
            }

            public boolean setString(String str) {
                ApiCompatibilityChecker.this.gwtDevJar = ApiCompatibilityChecker.this.getJarFromString(str);
                return ApiCompatibilityChecker.this.gwtDevJar != null;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "Path of the gwt user jar";
            }

            public String getTag() {
                return "-gwtUserJar";
            }

            public String[] getTagArgs() {
                return new String[]{"gwt_user_jar_path"};
            }

            public boolean setString(String str) {
                ApiCompatibilityChecker.this.gwtUserJar = ApiCompatibilityChecker.this.getJarFromString(str);
                return ApiCompatibilityChecker.this.gwtUserJar != null;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "Path of the reference jar";
            }

            public String getTag() {
                return "-refJar";
            }

            public String[] getTagArgs() {
                return new String[]{"reference_jar_path"};
            }

            public boolean setString(String str) {
                String[] refJarStrings = str.split(System.getProperty("path.separator"));
                ApiCompatibilityChecker.access$202(ApiCompatibilityChecker.this, new JarFile[refJarStrings.length]);
                int count = 0;
                for (String refJarString : refJarStrings) {
                    ((ApiCompatibilityChecker)ApiCompatibilityChecker.this).refJars[count++] = ApiCompatibilityChecker.this.getJarFromString(refJarString);
                    if (ApiCompatibilityChecker.this.refJars[count - 1] != null) continue;
                    return false;
                }
                return ApiCompatibilityChecker.this.refJars != null;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "Sets the log level of the TreeLogger";
            }

            public String getTag() {
                return "-logLevel";
            }

            public String[] getTagArgs() {
                String[] values = new String[TreeLogger.Type.values().length];
                int count = 0;
                for (TreeLogger.Type tempType : TreeLogger.Type.values()) {
                    values[count++] = tempType.name();
                }
                return values;
            }

            public boolean setString(String str) {
                for (TreeLogger.Type tempType : TreeLogger.Type.values()) {
                    if (!tempType.name().equals(str)) continue;
                    ApiCompatibilityChecker.this.type = tempType;
                    return true;
                }
                return false;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerFlag(){

            public String getPurposeSnippet() {
                return "Prints all api.";
            }

            public String getLabel() {
                return "printAllApi";
            }

            public boolean setFlag(boolean enabled) {
                ApiCompatibilityChecker.this.printAllApi = enabled;
                return true;
            }

            public boolean getDefaultValue() {
                return ApiCompatibilityChecker.this.printAllApi;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "Path of the configuration file";
            }

            public String getTag() {
                return "-configFile";
            }

            public String[] getTagArgs() {
                return new String[]{"config_file_path"};
            }

            public boolean isRequired() {
                return true;
            }

            public boolean setString(String str) {
                ApiCompatibilityChecker.this.setPropertiesAndWhitelist(str);
                return ApiCompatibilityChecker.this.configProperties != null && ApiCompatibilityChecker.this.whiteList != null;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "The location of the javax.validation sources";
            }

            public String getTag() {
                return "-validationSourceJars";
            }

            public String[] getTagArgs() {
                return new String[]{"jar1.jar:jar2.jar"};
            }

            public boolean setString(String str) {
                boolean success = true;
                String[] parts = str.split(System.getProperty("path.separator"));
                ApiCompatibilityChecker.access$702(ApiCompatibilityChecker.this, new JarFile[parts.length]);
                int j = parts.length;
                for (int i = 0; i < j; ++i) {
                    ((ApiCompatibilityChecker)ApiCompatibilityChecker.this).extraSourceJars[i] = ApiCompatibilityChecker.this.getJarFromString(parts[i]);
                }
                return success;
            }
        });
    }

    public void printHelp() {
        super.printHelp();
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("The config file must specify two repositories of java source files: ");
        sb.append("'_old' and '_new', which are to be compared for API source compatibility.\n");
        sb.append("An optional whitelist is present at the end of ");
        sb.append("the config file. The format of the whitelist is same as the output of ");
        sb.append("the tool without the whitelist.\n");
        sb.append("Each repository is specified by the following four properties:\n");
        sb.append("name             specifies how the api should be refered to in the output\n");
        sb.append("dirRoot          optional argument that specifies the base directory of all other file/directory names\n");
        sb.append("sourceFiles      a colon-separated list of files/directories that specify the roots of the filesystem trees to be included.\n");
        sb.append("excludeFiles     a colon-separated lists of ant patterns to exclude");
        sb.append("sourceLevel      Java source level compatibility");
        sb.append("\n\n");
        sb.append("Example api.conf file:\n");
        sb.append("name_old         gwtEmulator");
        sb.append("\n");
        sb.append("dirRoot_old      ./");
        sb.append("\n");
        sb.append("sourceFiles_old  dev/core/super:user/super:user/src");
        sb.append("\n");
        sb.append("excludeFiles_old user/super/com/google/gwt/junit/*.java");
        sb.append("\n\n");
        sb.append("name_new         gwtEmulatorCopy");
        sb.append("\n");
        sb.append("dirRoot_new      ../gwt-14/");
        sb.append("\n");
        sb.append("sourceFiles_new  dev/core:user/super:user/src");
        sb.append("\n");
        sb.append("excludeFiles_new user/super/com/google/gwt/junit/*.java");
        sb.append("\n\n");
        System.err.println(sb.toString());
    }

    protected JarFile getJarFromString(String str) {
        try {
            return new JarFile(str);
        }
        catch (IOException ex) {
            System.err.println("exception in getting jar from fileName: " + str + ", message: " + ex.getMessage());
            return null;
        }
    }

    protected void setPropertiesAndWhitelist(String fileName) throws IllegalArgumentException {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.configProperties = new Properties();
            this.configProperties.load(fis);
            fis.close();
            FileReader fr = new FileReader(fileName);
            this.whiteList = this.readWhiteListFromFile(fr);
            fr.close();
        }
        catch (IOException ex) {
            System.err.println("Have you specified the path of the config file correctly?");
            throw new IllegalArgumentException(ex);
        }
    }

    private Set<String> getConfigPropertyAsSet(String key) {
        HashSet<String> set = new HashSet<String>();
        String propertyValue = this.configProperties.getProperty(key);
        if (propertyValue == null) {
            return set;
        }
        for (String element : propertyValue.split(":")) {
            element = element.trim();
            set.add(element);
        }
        return set;
    }

    private Set<Resource> getGwtCompilationUnits(TreeLogger logger) throws FileNotFoundException, IOException, NotFoundException, UnableToCompleteException {
        HashSet<Resource> resources = new HashSet<Resource>();
        if (this.gwtDevJar == null || this.gwtUserJar == null) {
            if (this.gwtDevJar != null) {
                System.err.println("Argument gwtUserJar must be provided for gwtDevJar to be used");
            }
            if (this.gwtUserJar != null) {
                System.err.println("Argument gwtDevJar must be provided for gwtUserJar to be used");
            }
            return resources;
        }
        HashSet<String> gwtIncludedPaths = new HashSet<String>(Arrays.asList("com/google/gwt", "com/google/web"));
        HashSet<String> gwtExcludedPaths = new HashSet<String>(Arrays.asList("com/google/gwt/benchmarks", "com/google/gwt/i18n/rebind", "com/google/gwt/i18n/tools", "com/google/gwt/json", "com/google/gwt/junit", "com/google/gwt/user/client/rpc/core/java/util/LinkedHashMap_CustomFieldSerializer.java", "com/google/gwt/user/rebind", "com/google/gwt/user/server", "com/google/gwt/user/tools"));
        JarFileResources cu = new JarFileResources(new JarFile[]{this.gwtUserJar}, gwtIncludedPaths, gwtExcludedPaths, logger);
        resources.addAll(((Resources)cu).getResources());
        gwtIncludedPaths = new HashSet<String>(Arrays.asList("com/google/gwt/core/client", "com/google/gwt/dev/jjs/intrinsic/com/google/gwt/lang", "com/google/gwt/lang"));
        cu = new JarFileResources(new JarFile[]{this.gwtDevJar}, gwtIncludedPaths, new HashSet<String>(), logger);
        resources.addAll(((Resources)cu).getResources());
        return resources;
    }

    private Set<Resource> getJavaxValidationCompilationUnits(TreeLogger logger) throws UnableToCompleteException, NotFoundException, IOException {
        HashSet<Resource> resources = new HashSet<Resource>();
        if (this.extraSourceJars != null) {
            JarFileResources extra = new JarFileResources(this.extraSourceJars, Collections.singleton(""), new HashSet<String>(Arrays.asList("javax/validation/Configuration.java", "javax/validation/MessageInterpolator.java", "javax/validation/Validation.java", "javax/validation/ValidatorContext.java", "javax/validation/ValidatorFactory.java", "javax/validation/ValidationProviderResolver.java", "javax/validation/bootstrap/GenericBootstrap.java", "javax/validation/bootstrap/ProviderSpecificBootstrap.java", "javax/validation/constraints/Pattern.java", "javax/validation/spi/BootstrapState.java", "javax/validation/spi/ConfigurationState.java", "javax/validation/spi/ValidationProvider.java")), logger);
            Set<Resource> loaded = ((Resources)extra).getResources();
            System.out.println("Found " + loaded.size() + " new resources");
            resources.addAll(loaded);
        }
        return resources;
    }

    private Set<String> getSetOfExcludedPackages(Properties config) {
        String allExcludedPackages = config.getProperty("excludedPackages");
        if (allExcludedPackages == null) {
            allExcludedPackages = "";
        }
        String[] excludedPackagesArray = allExcludedPackages.split(":");
        return new HashSet<String>(Arrays.asList(excludedPackagesArray));
    }

    private Set<String> readWhiteListFromFile(FileReader fr) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        BufferedReader br = new BufferedReader(fr);
        String str = null;
        while ((str = br.readLine()) != null) {
            String[] splits;
            if ((str = str.trim()).startsWith("#") || (splits = str.split(" ")).length <= 1 || !ApiChange.contains(splits[1])) continue;
            String identifier = splits[0] + " " + splits[1];
            hashSet.add(identifier.trim());
        }
        return hashSet;
    }

    static /* synthetic */ JarFile[] access$202(ApiCompatibilityChecker x0, JarFile[] x1) {
        x0.refJars = x1;
        return x1;
    }

    static /* synthetic */ JarFile[] access$702(ApiCompatibilityChecker x0, JarFile[] x1) {
        x0.extraSourceJars = x1;
        return x1;
    }

    private static class SourceFileResources
    extends Resources {
        private final ZipScanner excludeScanner;
        private final Set<File> includedPaths;
        private Set<Resource> units = null;

        SourceFileResources(String dirRoot, Set<String> includedPathsAsString, Set<String> excludedPathsAsString, TreeLogger logger) throws FileNotFoundException, IOException {
            super(logger);
            if (dirRoot == null) {
                dirRoot = "";
            }
            this.includedPaths = new HashSet<File>();
            for (String includedPath : includedPathsAsString) {
                this.includedPaths.add(this.getFileFromName("source file: ", dirRoot + includedPath));
            }
            String[] fullExcludedPaths = new String[excludedPathsAsString.size()];
            int count = 0;
            String dirRootAbsolutePath = this.getFileFromName("dirRoot: ", dirRoot).getAbsolutePath();
            for (String excludedPath : excludedPathsAsString) {
                fullExcludedPaths[count++] = dirRootAbsolutePath + "/" + excludedPath;
            }
            this.excludeScanner = new ZipScanner();
            if (fullExcludedPaths.length > 0) {
                this.excludeScanner.setIncludes(fullExcludedPaths);
            }
            this.excludeScanner.addDefaultExcludes();
            this.excludeScanner.setCaseSensitive(true);
            this.excludeScanner.init();
        }

        @Override
        public Set<Resource> getResources() throws NotFoundException, IOException, UnableToCompleteException {
            if (this.units != null) {
                return this.units;
            }
            this.units = new HashSet<Resource>();
            for (File sourceFile : this.includedPaths) {
                this.updateCompilationUnitsInPath(sourceFile);
            }
            return this.units;
        }

        private boolean isExcludedFile(String fileName) {
            String pattern = "file:";
            if (fileName.indexOf(pattern) == 0) {
                fileName = fileName.substring(pattern.length());
            }
            return this.excludeScanner.match(fileName);
        }

        private void updateCompilationUnitsInPath(File sourcePathEntry) throws NotFoundException, IOException, UnableToCompleteException {
            this.logger.log(TreeLogger.SPAM, "entering addCompilationUnitsInPath, file = " + sourcePathEntry, null);
            File[] files = sourcePathEntry.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                this.logger.log(TreeLogger.SPAM, "deciding the fate of file " + file, null);
                if (file.getName().startsWith(".") || file.getName().equals("CVS")) continue;
                if (this.isExcludedFile(file.getAbsolutePath())) {
                    this.logger.log(TreeLogger.DEBUG, "not traversing " + file.toURI().toURL(), null);
                    continue;
                }
                if (file.isFile()) {
                    String fileName = file.getName();
                    if (!file.getName().endsWith("java")) continue;
                    String className = file.getName().substring(0, fileName.length() - 5);
                    String pkgName = this.extractPackageName(new FileReader(file));
                    if (pkgName == null) {
                        this.logger.log(TreeLogger.WARN, "Not adding file = " + file.toString() + ", because packageName = null", null);
                        continue;
                    }
                    if (this.isValidPackage(pkgName, sourcePathEntry.toURI().toURL().toString())) {
                        String typeName = Shared.makeTypeName((String)pkgName, (String)className);
                        this.units.add(new FileResource(file, Shared.toPath((String)typeName)));
                        this.logger.log(TreeLogger.DEBUG, "adding pkgName = " + pkgName + ", file = " + file.toString(), null);
                        continue;
                    }
                    this.logger.log(TreeLogger.SPAM, " not adding file " + file.toURI().toURL(), null);
                    continue;
                }
                this.updateCompilationUnitsInPath(file);
            }
        }
    }

    private static abstract class Resources {
        protected final TreeLogger logger;

        Resources(TreeLogger logger) {
            this.logger = logger;
        }

        public abstract Set<Resource> getResources() throws NotFoundException, IOException, UnableToCompleteException;

        protected String extractPackageName(Reader reader) throws IOException {
            BufferedReader br = new BufferedReader(reader);
            String str = null;
            while ((str = br.readLine()) != null) {
                String[] parts;
                if (str.indexOf("package") != 0 || (parts = str.split("[\b\t\n\r ]+")).length != 2 || !parts[0].equals("package")) continue;
                return parts[1].substring(0, parts[1].length() - 1);
            }
            return null;
        }

        protected File getFileFromName(String tag, String pathName) throws FileNotFoundException {
            File file = new File(pathName);
            if (!file.exists()) {
                throw new FileNotFoundException(tag + "file " + pathName + " not found");
            }
            return file;
        }

        protected boolean isValidPackage(String packageName, String filePath) {
            this.logger.log(TreeLogger.SPAM, "packageName = " + packageName + ", filePath = " + filePath, null);
            if (packageName == null) {
                return false;
            }
            int lastSlashPosition = filePath.lastIndexOf("/");
            if (lastSlashPosition == -1) {
                return false;
            }
            String dirPath = filePath.substring(0, lastSlashPosition);
            String packageNameAsPath = packageName.replace('.', '/');
            this.logger.log(TreeLogger.SPAM, "packageNameAsPath " + packageNameAsPath + ", dirPath = " + dirPath, null);
            return dirPath.endsWith(packageNameAsPath);
        }
    }

    private static class JarFileResources
    extends Resources {
        private static final String MOCK_PREFIX = "/mock/";
        private static final int MOCK_PREFIX_LENGTH = "/mock/".length();
        private final ZipScanner excludeScanner;
        private final Set<String> includedPaths;
        private final JarFile[] jarFiles;
        private Set<Resource> resources = null;

        JarFileResources(JarFile[] jarFiles, Set<String> includedPaths, Set<String> excludedPaths, TreeLogger logger) {
            super(logger);
            this.jarFiles = jarFiles;
            this.includedPaths = includedPaths;
            this.excludeScanner = new ZipScanner();
            ArrayList<String> list = new ArrayList<String>(excludedPaths);
            this.excludeScanner.setIncludes(list.toArray(new String[list.size()]));
            this.excludeScanner.addDefaultExcludes();
            this.excludeScanner.setCaseSensitive(true);
            this.excludeScanner.init();
        }

        @Override
        public Set<Resource> getResources() throws IOException {
            if (this.resources != null) {
                return this.resources;
            }
            this.resources = new HashSet<Resource>();
            for (JarFile jarFile : this.jarFiles) {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String fileName = jarEntry.toString();
                    if (fileName.startsWith(MOCK_PREFIX)) {
                        fileName = fileName.substring(MOCK_PREFIX_LENGTH);
                    }
                    if (!fileName.endsWith(".java") || !this.isIncluded(fileName)) continue;
                    String fileContent = this.getFileContentsFromJar(jarFile, jarEntry);
                    String packageName = this.extractPackageName(new StringReader(fileContent));
                    if (packageName == null) {
                        this.logger.log(TreeLogger.WARN, "Not adding file = " + fileName + ", because packageName = null", null);
                        continue;
                    }
                    if (this.isValidPackage(packageName, fileName)) {
                        long lastModified = jarEntry.getTime();
                        if (lastModified < 0L) {
                            lastModified = System.currentTimeMillis();
                        }
                        this.resources.add(new StaticResource(packageName + "." + this.getClassName(fileName), fileContent, lastModified));
                        this.logger.log(TreeLogger.DEBUG, "adding pkgName = " + packageName + ", file = " + fileName, null);
                        continue;
                    }
                    this.logger.log(TreeLogger.SPAM, " not adding file " + fileName, null);
                }
            }
            return this.resources;
        }

        String getFileContentsFromJar(JarFile jarFile, JarEntry jarEntry) throws IOException {
            StringBuffer fileContent = new StringBuffer();
            InputStream is = jarFile.getInputStream(jarEntry);
            BufferedInputStream bis = new BufferedInputStream(is);
            int length = 500;
            byte[] buf = new byte[length];
            int count = 0;
            while ((count = bis.read(buf, 0, length)) != -1) {
                fileContent.append(new String(buf, 0, count));
                buf = new byte[length];
            }
            bis.close();
            is.close();
            return fileContent.toString();
        }

        private String getClassName(String fileName) {
            int index = fileName.lastIndexOf("/");
            int endOffset = 0;
            if (fileName.endsWith(".java")) {
                endOffset = 5;
            }
            return fileName.substring(index + 1, fileName.length() - endOffset);
        }

        private boolean isIncluded(String fileName) {
            if (this.excludeScanner.match(fileName)) {
                this.logger.log(TreeLogger.SPAM, fileName + " is excluded");
                return false;
            }
            for (String includedPath : this.includedPaths) {
                if (!fileName.startsWith(includedPath)) continue;
                this.logger.log(TreeLogger.SPAM, fileName + " is not excluded, and is included by " + includedPath);
                return true;
            }
            return false;
        }
    }

    static class StaticResource
    extends Resource {
        private final long lastModified;
        private final String source;
        private final String typeName;

        public StaticResource(String typeName, String source, long lastModified) {
            this.typeName = typeName;
            this.source = source;
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getLocation() {
            return "/mock/" + this.getPath();
        }

        public String getPath() {
            return Shared.toPath((String)this.typeName);
        }

        public InputStream openContents() {
            return new ByteArrayInputStream(Util.getBytes((String)this.source));
        }

        public boolean wasRerooted() {
            return false;
        }
    }

    static class FileResource
    extends Resource {
        private final File file;
        private final String path;

        public FileResource(File file, String path) {
            this.file = file;
            this.path = path;
            assert (path.endsWith(".java"));
            assert (file.getAbsolutePath().endsWith(path));
        }

        public long getLastModified() {
            return this.file.lastModified();
        }

        public String getLocation() {
            return this.file.getAbsolutePath();
        }

        public String getPath() {
            return this.path;
        }

        public InputStream openContents() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Unable to open file '" + this.file.getAbsolutePath() + "'", e);
            }
        }

        public boolean wasRerooted() {
            return false;
        }
    }
}

