		opt nolist
;
; Device type definition for PIC16F72
;

__progmem_size		equ	2048
__data_eeprom_size	equ	0

__config		set	0x3fff

			set_pic_type "PIC16F72", "14-bit"

__do_config	macro	; keyword, value

		if streqcase("\1", "osc") | streqcase("\1", "fosc")
			if streqcase("\2", "lp")
__config			set	__config & 0xfffc
				exitm
			endif
			if streqcase("\2", "xt")
__config			set	(__config & 0xfffc) | 0x01
				exitm
			endif
			if streqcase("\2", "hs")
__config			set	(__config & 0xfffc) | 0x02
				exitm
			endif
			if streqcase("\2", "rc")
__config			set	(__config & 0xfffc) | 0x03
				exitm
			endif
			error	"Invalid oscillator setting"
			exitm
		endif

		if streqcase("\1", "wdt") | streqcase("\1", "wdten")
			if streqcase("\2", "no") | streqcase("\2", "off")
__config			set	__config & 0xfffb
				exitm
			endif
			if streqcase("\2", "yes") | streqcase("\2", "on")
__config			set	__config | 0x0004
				exitm
			endif
			error	"Invalid WDT setting"
			exitm
		endif

		if streqcase("\1", "pwrt") | streqcase("\1", "pwrte")
			if streqcase("\2", "no") | streqcase("\2", "off")
__config			set	__config | 0x0008
				exitm
			endif
			if streqcase("\2", "yes") | streqcase("\2", "on")
__config			set	__config & 0xfff7
				exitm
			endif
			error	"Invalid PWRT setting"
			exitm
		endif

		if streqcase("\1", "cp")
			if streqcase("\2", "no") | streqcase("\2", "off")
__config			set	__config | 0x0010
				exitm
			endif
			if streqcase("\2", "yes") | streqcase("\2", "on")
__config			set	__config & 0xffef
				exitm
			endif
			error	"Invalid CP setting"
			exitm
		endif

		if streqcase("\1", "bor") | streqcase("\1", "boren") | streqcase("\1", "bod") | streqcase("\1", "boden")
			if streqcase("\2", "no") | streqcase("\2", "off")
__config			set	__config & 0xffbf
				exitm
			endif
			if streqcase("\2", "yes") | streqcase("\2", "on")
__config			set	__config | 0x0040
				exitm
			endif
			error	"Invalid BOR setting"
			exitm
		endif

		error	"Invalid configuration keyword"
		endm

		opt list
