/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GdkGlyphVector
extends GlyphVector {
    double[] extents;
    int[] codes;
    Font font;
    FontRenderContext fontRenderContext;
    Rectangle2D allLogical;
    Rectangle2D allVisual;

    public double[] getExtents() {
        return this.extents;
    }

    public int[] getCodes() {
        return this.codes;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public int getGlyphCharIndex(int glyphIndex) {
        return glyphIndex;
    }

    public int[] getGlyphCharIndices(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        int[] ix = codeReturn;
        if (ix == null) {
            ix = new int[numEntries];
        }
        int i = 0;
        while (i < numEntries) {
            ix[i] = this.getGlyphCharIndex(beginGlyphIndex + i);
            ++i;
        }
        return ix;
    }

    public int getGlyphCode(int glyphIndex) {
        return this.codes[glyphIndex];
    }

    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        if (codeReturn == null) {
            codeReturn = new int[numEntries];
        }
        System.arraycopy(this.codes, beginGlyphIndex, codeReturn, 0, numEntries);
        return codeReturn;
    }

    public Shape getGlyphLogicalBounds(int i) {
        return new Rectangle2D.Double(this.extents[8 * i], this.extents[8 * i + 1], this.extents[8 * i + 2], this.extents[8 * i + 3]);
    }

    public GlyphMetrics getGlyphMetrics(int i) {
        boolean is_horizontal = true;
        double advanceX = this.extents[8 * i + 2];
        double advanceY = 0.0;
        return new GlyphMetrics(is_horizontal, (float)advanceX, (float)advanceY, (Rectangle2D)this.getGlyphVisualBounds(i), 0);
    }

    public Shape getGlyphOutline(int glyphIndex) {
        throw new UnsupportedOperationException();
    }

    public Shape getGlyphOutline(int glyphIndex, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public Rectangle getGlyphPixelBounds(int i, FontRenderContext renderFRC, float x, float y) {
        return new Rectangle((int)x, (int)y, (int)this.extents[8 * i + 6], (int)this.extents[8 * i + 7]);
    }

    public Point2D getGlyphPosition(int i) {
        return new Point2D.Double(this.extents[10 * i + 8], this.extents[10 * i + 9]);
    }

    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        float[] fx = positionReturn;
        if (fx == null) {
            fx = new float[numEntries * 2];
        }
        int i = 0;
        while (i < numEntries) {
            fx[2 * i] = (float)this.extents[10 * i + 8];
            fx[2 * i + 1] = (float)this.extents[10 * i + 9];
            ++i;
        }
        return fx;
    }

    public AffineTransform getGlyphTransform(int glyphIndex) {
        return null;
    }

    public Shape getGlyphVisualBounds(int i) {
        return new Rectangle2D.Double(this.extents[8 * i + 4], this.extents[8 * i + 5], this.extents[8 * i + 6], this.extents[8 * i + 7]);
    }

    public int getLayoutFlags() {
        return 0;
    }

    public Rectangle2D getLogicalBounds() {
        return this.allLogical;
    }

    public int getNumGlyphs() {
        return this.codes.length;
    }

    public Shape getOutline() {
        throw new UnsupportedOperationException();
    }

    public Rectangle getPixelBounds(FontRenderContext renderFRC, float x, float y) {
        return new Rectangle((int)x, (int)y, (int)this.allVisual.getWidth(), (int)this.allVisual.getHeight());
    }

    public Rectangle2D getVisualBounds() {
        return this.allVisual;
    }

    public void performDefaultLayout() {
    }

    public void setGlyphPosition(int i, Point2D newPos) {
        this.extents[8 * i] = newPos.getX();
        this.extents[8 * i + 1] = newPos.getY();
        this.extents[8 * i + 4] = newPos.getX();
        this.extents[8 * i + 5] = newPos.getY();
    }

    public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(GlyphVector gv) {
        if (gv == null) {
            return false;
        }
        if (!(gv instanceof GdkGlyphVector)) {
            return false;
        }
        GdkGlyphVector ggv = (GdkGlyphVector)gv;
        if (ggv.codes.length != this.codes.length || ggv.extents.length != this.extents.length) {
            return false;
        }
        if (ggv.font == null && this.font != null || ggv.font != null && this.font == null || !ggv.font.equals(this.font)) {
            return false;
        }
        if (ggv.fontRenderContext == null && this.fontRenderContext != null || ggv.fontRenderContext != null && this.fontRenderContext == null || !ggv.fontRenderContext.equals(this.fontRenderContext)) {
            return false;
        }
        int i = 0;
        while (i < ggv.codes.length) {
            if (ggv.codes[i] != this.codes[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < ggv.extents.length) {
            if (ggv.extents[i] != this.extents[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int idx) {
        throw new UnsupportedOperationException();
    }

    public Shape getOutline(float x, float y) {
        throw new UnsupportedOperationException();
    }

    public GdkGlyphVector(double[] extents, int[] codes, Font font, FontRenderContext frc) {
        this.extents = extents;
        this.codes = codes;
        this.font = font;
        this.fontRenderContext = frc;
        this.allLogical = new Rectangle2D.Double();
        this.allVisual = new Rectangle2D.Double();
        int i = 0;
        while (i < codes.length) {
            this.allLogical.add(new Rectangle2D.Double(extents[10 * i] + extents[10 * i + 8], extents[10 * i + 1] + extents[10 * i + 9], extents[10 * i + 2], extents[10 * i + 3]));
            this.allVisual.add(new Rectangle2D.Double(extents[10 * i + 4] + extents[10 * i + 8], extents[10 * i + 5] + extents[10 * i + 9], extents[10 * i + 6], extents[10 * i + 7]));
            ++i;
        }
    }
}

