package TDS::Navigator::Partly;
# $Id: Partly.pm,v 1.3 2000/12/08 02:02:32 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $Template $HrefTemplateDynamic $HrefTemplateStatic);

use DateTime::Date;

use TDS::Navigator::Base;

@ISA = qw(TDS::Navigator::Base);

attributes qw();

{
    $HrefTemplateDynamic = "./?%year%0m%part";
    $HrefTemplateStatic = "d%year%0m%part.%suffix";
}

################################################################
sub AsFirst ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>1);

    return $self->AsHTML($label, $d->GetParams);
}
sub AsMiddle ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>15);
    return $self->AsHTML($label, $d->GetParams);
}
sub AsLast ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>28);
    return $self->AsHTML($label, $d->GetParams);
}

1;
