/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorLookUpTable;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.SrgbConverter;
import gnu.java.awt.color.ToneReproductionCurve;
import java.awt.color.ICC_ProfileRGB;
import java.awt.color.ProfileDataException;

public class RgbProfileConverter
implements ColorSpaceConverter {
    private static float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};
    private float[][] matrix;
    private float[][] inv_matrix;
    private ToneReproductionCurve rTRC;
    private ToneReproductionCurve gTRC;
    private ToneReproductionCurve bTRC;
    private ColorLookUpTable toPCS = null;
    private ColorLookUpTable fromPCS = null;

    public float[] toCIEXYZ(float[] in) {
        if (this.toPCS != null) {
            return this.toPCS.lookup(in);
        }
        float[] temp = new float[3];
        float[] out = new float[3];
        temp[0] = this.rTRC.lookup(in[0]);
        temp[1] = this.gTRC.lookup(in[1]);
        temp[2] = this.bTRC.lookup(in[2]);
        out[0] = this.matrix[0][0] * temp[0] + this.matrix[0][1] * temp[1] + this.matrix[0][2] * temp[2];
        out[1] = this.matrix[1][0] * temp[0] + this.matrix[1][1] * temp[1] + this.matrix[1][2] * temp[2];
        out[2] = this.matrix[2][0] * temp[0] + this.matrix[2][1] * temp[1] + this.matrix[2][2] * temp[2];
        return out;
    }

    public float[] toRGB(float[] in) {
        return SrgbConverter.XYZtoRGB(this.toCIEXYZ(in));
    }

    public float[] fromCIEXYZ(float[] in) {
        if (this.fromPCS != null) {
            return this.fromPCS.lookup(in);
        }
        float[] temp = new float[3];
        float[] out = new float[3];
        temp[0] = this.inv_matrix[0][0] * in[0] + this.inv_matrix[0][1] * in[1] + this.inv_matrix[0][2] * in[2];
        temp[1] = this.inv_matrix[1][0] * in[0] + this.inv_matrix[1][1] * in[1] + this.inv_matrix[1][2] * in[2];
        temp[2] = this.inv_matrix[2][0] * in[0] + this.inv_matrix[2][1] * in[1] + this.inv_matrix[2][2] * in[2];
        out[0] = this.rTRC.reverseLookup(temp[0]);
        out[1] = this.gTRC.reverseLookup(temp[1]);
        out[2] = this.bTRC.reverseLookup(temp[2]);
        return out;
    }

    public float[] fromRGB(float[] in) {
        return this.fromCIEXYZ(SrgbConverter.RGBtoXYZ(in));
    }

    private final float[][] invertMatrix(float[][] matrix) {
        float[][] out = new float[3][3];
        double determinant = matrix[0][0] * (matrix[1][1] * matrix[2][2] - matrix[2][1] * matrix[1][2]) - matrix[0][1] * (matrix[1][0] * matrix[2][2] - matrix[2][0] * matrix[1][2]) + matrix[0][2] * (matrix[1][0] * matrix[2][1] - matrix[2][0] * matrix[1][1]);
        if (determinant == 0.0) {
            throw new IllegalArgumentException("Can't invert conversion matrix.");
        }
        float invdet = (float)(1.0 / determinant);
        out[0][0] = invdet * (matrix[1][1] * matrix[2][2] - matrix[1][2] * matrix[2][1]);
        out[0][1] = invdet * (matrix[0][2] * matrix[2][1] - matrix[0][1] * matrix[2][2]);
        out[0][2] = invdet * (matrix[0][1] * matrix[1][2] - matrix[0][2] * matrix[1][1]);
        out[1][0] = invdet * (matrix[1][2] * matrix[2][0] - matrix[1][0] * matrix[2][2]);
        out[1][1] = invdet * (matrix[0][0] * matrix[2][2] - matrix[0][2] * matrix[2][0]);
        out[1][2] = invdet * (matrix[0][2] * matrix[1][0] - matrix[0][0] * matrix[1][2]);
        out[2][0] = invdet * (matrix[1][0] * matrix[2][1] - matrix[1][1] * matrix[2][0]);
        out[2][1] = invdet * (matrix[0][1] * matrix[2][0] - matrix[0][0] * matrix[2][1]);
        out[2][2] = invdet * (matrix[0][0] * matrix[1][1] - matrix[0][1] * matrix[1][0]);
        return out;
    }

    public RgbProfileConverter(ICC_ProfileRGB profile) {
        this.matrix = profile.getMatrix();
        try {
            this.rTRC = new ToneReproductionCurve(profile.getGamma(0));
        }
        catch (ProfileDataException e) {
            this.rTRC = new ToneReproductionCurve(profile.getTRC(0));
        }
        try {
            this.gTRC = new ToneReproductionCurve(profile.getGamma(1));
        }
        catch (ProfileDataException e) {
            this.gTRC = new ToneReproductionCurve(profile.getTRC(1));
        }
        try {
            this.bTRC = new ToneReproductionCurve(profile.getGamma(2));
        }
        catch (ProfileDataException e) {
            this.bTRC = new ToneReproductionCurve(profile.getTRC(2));
        }
        try {
            this.toPCS = new ColorLookUpTable(profile, 1093812784);
        }
        catch (Exception e) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(profile, 1110589744);
        }
        catch (Exception e) {
            this.fromPCS = null;
        }
        if (this.fromPCS == null) {
            this.inv_matrix = this.invertMatrix(this.matrix);
        } else {
            this.inv_matrix = new float[3][3];
            this.inv_matrix[2][2] = 1.0f;
            this.inv_matrix[1][1] = 1.0f;
            this.inv_matrix[0][0] = 1.0f;
        }
    }
}

