/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.igoweb.util.Config;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.JnlpIo;

public abstract class GuiUtil {
    public static Image loadImage(String name) {
        if (name.charAt(0) != '/') {
            name = "/" + name;
        }
        InputStream inStream = GuiUtil.class.getResourceAsStream(name);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] tmpData = new byte[1024];
        try {
            int amtRead;
            do {
                if ((amtRead = inStream.read(tmpData)) <= 0) continue;
                buffer.write(tmpData, 0, amtRead);
            } while (amtRead != -1);
            inStream.close();
        }
        catch (Throwable thrown) {
            throw new RuntimeException("Error loading image \"" + name + "\": " + thrown, thrown);
        }
        return Toolkit.getDefaultToolkit().createImage(buffer.toByteArray());
    }

    public static String makeStringFit(String s, Graphics g, int width) {
        return GuiUtil.makeStringFit(s, g.getFont(), ((Graphics2D)g).getFontRenderContext(), width);
    }

    public static String makeStringFit(String s, Font font, FontRenderContext frc, int width) {
        int showLen;
        if (font.getStringBounds(s, frc).getWidth() <= (double)width) {
            return s;
        }
        double ellipsisW = font.getStringBounds(Defs.getString(1436228509, ""), frc).getWidth();
        for (showLen = s.length() - 1; showLen > 0 && font.getStringBounds(s, 0, showLen, frc).getWidth() + ellipsisW > (double)width; --showLen) {
        }
        return Defs.getString(1436228509, s.substring(0, showLen));
    }

    public static final void loadHelp(String pageName) {
        String url = "http://" + Config.getRaw("webHost") + "/help/" + pageName;
        if (JnlpIo.isAvailable()) {
            try {
                JnlpIo.showUrl(new URL(url));
            }
            catch (MalformedURLException excep) {
                throw new RuntimeException();
            }
        } else {
            Defs.loadWebPage(url, "Help");
        }
    }
}

