/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ref;

import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.containers.Queue;
import sun.misc.Unsafe;

public class DebugReflectionUtil {
    private static final Map<Class, Field[]> allFields = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<Class>(){

        public int computeHashCode(Class aClass2) {
            return aClass2.getName().hashCode();
        }

        public boolean equals(Class o1, Class o2) {
            return o1 == o2;
        }
    });
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method Unsafe_shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Unsafe.class, "shouldBeInitialized", Class.class);
    private static final Key<Boolean> REPORTED_LEAKED = Key.create("REPORTED_LEAKED");

    private static Field @NotNull [] getAllFields(@NotNull Class<?> aClass2) {
        Field[] cached2;
        if (aClass2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(0);
        }
        if ((cached2 = allFields.get(aClass2)) == null) {
            try {
                Field[] declaredFields = aClass2.getDeclaredFields();
                ArrayList<Field> fields2 = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField2 : declaredFields) {
                    declaredField2.setAccessible(true);
                    Class<?> type2 = declaredField2.getType();
                    if (DebugReflectionUtil.isTrivial(type2)) continue;
                    fields2.add(declaredField2);
                }
                Class<?> superclass = aClass2.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields2.contains(sup)) continue;
                        fields2.add(sup);
                    }
                }
                cached2 = fields2.isEmpty() ? EMPTY_FIELD_ARRAY : fields2.toArray(new Field[0]);
            }
            catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException e) {
                cached2 = EMPTY_FIELD_ARRAY;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    cached2 = EMPTY_FIELD_ARRAY;
                }
                throw e;
            }
            allFields.put(aClass2, cached2);
        }
        if (cached2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(1);
        }
        return cached2;
    }

    private static boolean isTrivial(@NotNull Class<?> type2) {
        if (type2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(2);
        }
        return type2.isPrimitive() || type2 == String.class || type2 == Class.class || type2.isArray() && DebugReflectionUtil.isTrivial(type2.getComponentType());
    }

    private static boolean isInitialized(@NotNull Class<?> root2) {
        if (root2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(3);
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isInitialized = false;
        try {
            isInitialized = (Boolean)Unsafe_shouldBeInitialized.invoke((Object)AtomicFieldUpdater.getUnsafe(), root2) == false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInitialized;
    }

    public static boolean walkObjects(int maxDepth, @NotNull Map<Object, String> startRoots, @NotNull Class<?> lookFor, @NotNull Condition<Object> shouldExamineValue, @NotNull PairProcessor<Object, ? super BackLink> leakProcessor) {
        if (startRoots == null) {
            DebugReflectionUtil.$$$reportNull$$$0(4);
        }
        if (lookFor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(5);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(6);
        }
        if (leakProcessor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(7);
        }
        TIntHashSet visited2 = new TIntHashSet(100);
        Queue<2> toVisit = new Queue<2>(100);
        for (Map.Entry<Object, String> entry : startRoots.entrySet()) {
            Object startRoot = entry.getKey();
            final String description2 = entry.getValue();
            toVisit.addLast(new BackLink(startRoot, null, null){

                @Override
                @NotNull
                String print() {
                    String string2 = super.print() + " (from " + description2 + ")";
                    if (string2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil$2", "print"));
                }
            });
        }
        while (!toVisit.isEmpty()) {
            BackLink backLink = (BackLink)toVisit.pullFirst();
            if (backLink.depth > maxDepth) continue;
            Object value2 = backLink.value;
            if (lookFor.isAssignableFrom(value2.getClass()) && DebugReflectionUtil.markLeaked(value2) && !leakProcessor.process(value2, backLink)) {
                return false;
            }
            if (!visited2.add(System.identityHashCode(value2))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, value2, shouldExamineValue, backLink);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void queueStronglyReferencedValues(@NotNull Queue<? super BackLink> queue, @NotNull Object root2, @NotNull Condition<Object> shouldExamineValue, @NotNull BackLink backLink) {
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(8);
        }
        if (root2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(9);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(10);
        }
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(11);
        }
        Class<?> rootClass = root2.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            void value2;
            String fieldName = field.getName();
            if (root2 instanceof Reference && ("referent".equals(fieldName) || "discovered".equals(fieldName))) continue;
            try {
                Object value22 = field.get(root2);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            DebugReflectionUtil.queue(value2, field, backLink, queue, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root2) {
                    DebugReflectionUtil.queue(object, null, backLink, queue, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root2 instanceof Class && DebugReflectionUtil.isInitialized((Class)root2)) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root2)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value4 = field.get(null);
                    DebugReflectionUtil.queue(value4, field, backLink, queue, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(Object value2, Field field, @NotNull BackLink backLink, @NotNull Queue<? super BackLink> queue, @NotNull Condition<Object> shouldExamineValue) {
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(12);
        }
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(13);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(14);
        }
        if (value2 == null || DebugReflectionUtil.isTrivial(value2.getClass())) {
            return;
        }
        if (shouldExamineValue.value(value2)) {
            BackLink newBackLink = new BackLink(value2, field, backLink);
            queue.addLast(newBackLink);
        }
    }

    private static boolean markLeaked(Object leaked) {
        return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookFor";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExamineValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leakProcessor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTrivial";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "walkObjects";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queueStronglyReferencedValues";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BackLink {
        @NotNull
        private final Object value;
        private final Field field;
        private final BackLink backLink;
        private final int depth;

        BackLink(@NotNull Object value2, @Nullable Field field, @Nullable BackLink backLink) {
            if (value2 == null) {
                BackLink.$$$reportNull$$$0(0);
            }
            this.value = value2;
            this.field = field;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            String result2 = "";
            BackLink backLink = this;
            while (backLink != null) {
                String s = backLink.print();
                result2 = result2 + s;
                backLink = backLink.backLink;
            }
            return result2;
        }

        @NotNull
        String print() {
            String valueStr;
            Object value2 = this.value;
            try {
                valueStr = value2 instanceof FList ? "FList (size=" + ((FList)value2).size() + ")" : (value2 instanceof Collection ? "Collection (size=" + ((Collection)value2).size() + ")" : String.valueOf(value2));
                valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
            }
            catch (Throwable e) {
                valueStr = "(" + e.getMessage() + " while computing .toString())";
            }
            Field field = this.field;
            String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
            String string2 = "via '" + fieldName + "'; Value: '" + valueStr + "' of " + value2.getClass() + "\n";
            if (string2 == null) {
                BackLink.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil$BackLink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil$BackLink";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "print";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

