/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.base.Equivalence;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.Methods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.reflect.annotations.impl.DefaultPropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.impl.DefaultTypeAnnotationMetadata;

public class DefaultTypeAnnotationMetadataStore
implements TypeAnnotationMetadataStore {
    private static final TypeAnnotationMetadata EMPTY_TYPE_ANNOTATION_METADATA = new TypeAnnotationMetadata(){

        @Override
        public ImmutableSet<Annotation> getAnnotations() {
            return ImmutableSet.of();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return false;
        }

        @Override
        public ImmutableSortedSet<PropertyAnnotationMetadata> getPropertiesAnnotationMetadata() {
            return ImmutableSortedSet.of();
        }

        @Override
        public void visitValidationFailures(TypeValidationContext validationContext) {
        }
    };
    private final ImmutableSet<Class<? extends Annotation>> recordedTypeAnnotations;
    private final ImmutableSet<String> ignoredPackagePrefixes;
    private final ImmutableMap<Class<? extends Annotation>, AnnotationCategory> propertyAnnotationCategories;
    private final CrossBuildInMemoryCache<Class<?>, TypeAnnotationMetadata> cache;
    private final ImmutableSet<String> potentiallyIgnoredMethodNames;
    private final ImmutableSet<Equivalence.Wrapper<Method>> globallyIgnoredMethods;
    private final ImmutableSet<Class<?>> mutableNonFinalClasses;
    private final ImmutableSet<Class<? extends Annotation>> ignoredMethodAnnotations;
    private final Predicate<? super Method> generatedMethodDetector;

    public DefaultTypeAnnotationMetadataStore(Collection<Class<? extends Annotation>> recordedTypeAnnotations, Map<Class<? extends Annotation>, ? extends AnnotationCategory> propertyAnnotationCategories, Collection<String> ignoredPackagePrefixes, Collection<Class<?>> ignoredSuperTypes, Collection<Class<?>> ignoreMethodsFromTypes, Collection<Class<?>> mutableNonFinalClasses, Collection<Class<? extends Annotation>> ignoredMethodAnnotations, Predicate<? super Method> generatedMethodDetector, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.recordedTypeAnnotations = ImmutableSet.copyOf(recordedTypeAnnotations);
        this.ignoredPackagePrefixes = DefaultTypeAnnotationMetadataStore.collectIgnoredPackagePrefixes(ignoredPackagePrefixes);
        this.propertyAnnotationCategories = DefaultTypeAnnotationMetadataStore.allAnnotationCategories(propertyAnnotationCategories, ignoredMethodAnnotations);
        this.cache = DefaultTypeAnnotationMetadataStore.initCache(ignoredSuperTypes, cacheFactory);
        this.potentiallyIgnoredMethodNames = DefaultTypeAnnotationMetadataStore.allMethodNamesOf(ignoreMethodsFromTypes);
        this.globallyIgnoredMethods = DefaultTypeAnnotationMetadataStore.allMethodsOf(ignoreMethodsFromTypes);
        this.mutableNonFinalClasses = ImmutableSet.copyOf(mutableNonFinalClasses);
        this.ignoredMethodAnnotations = ImmutableSet.copyOf(ignoredMethodAnnotations);
        this.generatedMethodDetector = generatedMethodDetector;
    }

    private static ImmutableSet<String> collectIgnoredPackagePrefixes(Collection<String> ignoredPackagePrefixes) {
        return ImmutableSet.copyOf((Collection)ignoredPackagePrefixes.stream().map(prefix -> prefix + ".").collect(Collectors.toList()));
    }

    private static ImmutableMap<Class<? extends Annotation>, AnnotationCategory> allAnnotationCategories(Map<Class<? extends Annotation>, ? extends AnnotationCategory> propertyAnnotationCategories, Collection<Class<? extends Annotation>> ignoredMethodAnnotations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(propertyAnnotationCategories);
        builder.put(Inject.class, (Object)AnnotationCategory.TYPE);
        for (Class<? extends Annotation> ignoredMethodAnnotation : ignoredMethodAnnotations) {
            builder.put(ignoredMethodAnnotation, (Object)AnnotationCategory.TYPE);
        }
        return builder.build();
    }

    private static CrossBuildInMemoryCache<Class<?>, TypeAnnotationMetadata> initCache(Collection<Class<?>> ignoredSuperTypes, CrossBuildInMemoryCacheFactory cacheFactory) {
        CrossBuildInMemoryCache result = cacheFactory.newClassCache();
        for (Class<?> ignoredSuperType : ignoredSuperTypes) {
            result.put(ignoredSuperType, (Object)EMPTY_TYPE_ANNOTATION_METADATA);
        }
        return result;
    }

    private static ImmutableSet<String> allMethodNamesOf(Iterable<Class<?>> classes) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                methods.add((Object)method.getName());
            }
        }
        return methods.build();
    }

    private static ImmutableSet<Equivalence.Wrapper<Method>> allMethodsOf(Iterable<Class<?>> classes) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                methods.add((Object)Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method));
            }
        }
        return methods.build();
    }

    @Override
    public TypeAnnotationMetadata getTypeAnnotationMetadata(Class<?> type) {
        return (TypeAnnotationMetadata)this.cache.get(type, () -> this.createTypeAnnotationMetadata(type));
    }

    private TypeAnnotationMetadata createTypeAnnotationMetadata(Class<?> type) {
        ImmutableSortedSet propertiesMetadata;
        if (type.isPrimitive() || type.isArray() || type.isAnnotation()) {
            return EMPTY_TYPE_ANNOTATION_METADATA;
        }
        Package typePackage = type.getPackage();
        if (typePackage != null) {
            String typePackageName = typePackage.getName();
            if (this.ignoredPackagePrefixes.stream().anyMatch(typePackageName::startsWith)) {
                return EMPTY_TYPE_ANNOTATION_METADATA;
            }
        }
        ImmutableSet.Builder typeAnnotations = ImmutableSet.builder();
        for (Annotation typeAnnotation : type.getDeclaredAnnotations()) {
            if (!this.recordedTypeAnnotations.contains(typeAnnotation.annotationType())) continue;
            typeAnnotations.add((Object)typeAnnotation);
        }
        HashMap<String, PropertyAnnotationMetadataBuilder> methodBuilders = new HashMap<String, PropertyAnnotationMetadataBuilder>();
        TypeValidationContext.ReplayingTypeValidationContext validationContext = new TypeValidationContext.ReplayingTypeValidationContext();
        this.inheritMethods(type, validationContext, methodBuilders);
        if (!type.isSynthetic()) {
            propertiesMetadata = this.extractPropertiesFrom(type, methodBuilders, validationContext);
        } else {
            ImmutableSortedSet.Builder propertiesMetadataBuilder = ImmutableSortedSet.naturalOrder();
            for (PropertyAnnotationMetadataBuilder propertyMetadataBuilder : methodBuilders.values()) {
                propertiesMetadataBuilder.add((Object)propertyMetadataBuilder.build());
            }
            propertiesMetadata = propertiesMetadataBuilder.build();
        }
        return new DefaultTypeAnnotationMetadata((Iterable<? extends Annotation>)typeAnnotations.build(), (Iterable<? extends PropertyAnnotationMetadata>)propertiesMetadata, validationContext);
    }

    private void inheritMethods(Class<?> type, TypeValidationContext validationContext, Map<String, PropertyAnnotationMetadataBuilder> methodBuilders) {
        this.visitSuperTypes(type, (superType, metadata) -> {
            for (PropertyAnnotationMetadata property : metadata.getPropertiesAnnotationMetadata()) {
                this.getOrCreateBuilder(property.getPropertyName(), property.getMethod(), validationContext, methodBuilders).inheritAnnotations(superType.isInterface(), property);
            }
        });
    }

    private PropertyAnnotationMetadataBuilder getOrCreateBuilder(String propertyName, Method getter, TypeValidationContext validationContext, Map<String, PropertyAnnotationMetadataBuilder> propertyBuilders) {
        return propertyBuilders.computeIfAbsent(getter.getName(), methodName -> new PropertyAnnotationMetadataBuilder(propertyName, getter, validationContext));
    }

    private ImmutableSortedSet<PropertyAnnotationMetadata> extractPropertiesFrom(Class<?> type, Map<String, PropertyAnnotationMetadataBuilder> methodBuilders, TypeValidationContext validationContext) {
        Method[] methods = type.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method method : methods) {
            this.processMethodAnnotations(method, methodBuilders, validationContext);
        }
        ImmutableList<PropertyAnnotationMetadataBuilder> propertyBuilders = this.convertMethodToPropertyBuilders(methodBuilders);
        ImmutableMap<String, ImmutableMap<Class<? extends Annotation>, Annotation>> fieldAnnotationsByPropertyName = this.collectFieldAnnotations(type);
        return this.mergePropertiesAndFieldMetadata(type, propertyBuilders, fieldAnnotationsByPropertyName, validationContext);
    }

    private ImmutableList<PropertyAnnotationMetadataBuilder> convertMethodToPropertyBuilders(Map<String, PropertyAnnotationMetadataBuilder> methodBuilders) {
        LinkedHashMap<String, PropertyAnnotationMetadataBuilder> propertyBuilders = new LinkedHashMap<String, PropertyAnnotationMetadataBuilder>();
        List metadataBuilders = Ordering.from(Comparator.comparing(metadataBuilder -> metadataBuilder.getMethod().getName())).sortedCopy(methodBuilders.values());
        for (PropertyAnnotationMetadataBuilder metadataBuilder2 : metadataBuilders) {
            String propertyName = metadataBuilder2.getPropertyName();
            PropertyAnnotationMetadataBuilder previouslySeenBuilder = propertyBuilders.putIfAbsent(propertyName, metadataBuilder2);
            if (previouslySeenBuilder == null || this.generatedMethodDetector.test(metadataBuilder2.method) || this.ignoredMethodAnnotations.stream().anyMatch(metadataBuilder2::hasAnnotation)) continue;
            if (this.ignoredMethodAnnotations.stream().anyMatch(previouslySeenBuilder::hasAnnotation)) {
                propertyBuilders.put(propertyName, metadataBuilder2);
                continue;
            }
            previouslySeenBuilder.recordProblem(String.format("has redundant getters: '%s()' and '%s()'", previouslySeenBuilder.method.getName(), metadataBuilder2.method.getName()));
        }
        return ImmutableList.copyOf(propertyBuilders.values());
    }

    private ImmutableMap<String, ImmutableMap<Class<? extends Annotation>, Annotation>> collectFieldAnnotations(Class<?> type) {
        ImmutableMap.Builder fieldAnnotationsByPropertyName = ImmutableMap.builder();
        for (Field declaredField : type.getDeclaredFields()) {
            if (declaredField.isSynthetic()) continue;
            fieldAnnotationsByPropertyName.put((Object)declaredField.getName(), this.collectRelevantAnnotations(declaredField));
        }
        return fieldAnnotationsByPropertyName.build();
    }

    private ImmutableSortedSet<PropertyAnnotationMetadata> mergePropertiesAndFieldMetadata(Class<?> type, ImmutableList<PropertyAnnotationMetadataBuilder> propertyBuilders, ImmutableMap<String, ImmutableMap<Class<? extends Annotation>, Annotation>> fieldAnnotationsByPropertyName, TypeValidationContext validationContext) {
        ImmutableSortedSet.Builder propertiesMetadataBuilder = ImmutableSortedSet.naturalOrder();
        ImmutableSet.Builder fieldsSeenBuilder = ImmutableSet.builderWithExpectedSize((int)fieldAnnotationsByPropertyName.size());
        for (PropertyAnnotationMetadataBuilder metadataBuilder : propertyBuilders) {
            String propertyName = metadataBuilder.getPropertyName();
            ImmutableMap fieldAnnotations = (ImmutableMap)fieldAnnotationsByPropertyName.get((Object)propertyName);
            if (fieldAnnotations != null) {
                fieldsSeenBuilder.add((Object)propertyName);
                for (Annotation annotation : fieldAnnotations.values()) {
                    metadataBuilder.declareAnnotation(annotation);
                }
            }
            propertiesMetadataBuilder.add((Object)metadataBuilder.build());
        }
        ImmutableSortedSet propertiesMetadata = propertiesMetadataBuilder.build();
        ImmutableSet fieldsSeen = fieldsSeenBuilder.build();
        if (fieldsSeen.size() != fieldAnnotationsByPropertyName.size()) {
            fieldAnnotationsByPropertyName.entrySet().stream().filter(entry -> {
                String fieldName = (String)entry.getKey();
                ImmutableMap fieldAnnotations = (ImmutableMap)entry.getValue();
                return !fieldAnnotations.isEmpty() && !fieldsSeen.contains((Object)fieldName) && !fieldAnnotations.containsKey(Inject.class);
            }).forEach(entry -> {
                String fieldName = (String)entry.getKey();
                ImmutableMap fieldAnnotations = (ImmutableMap)entry.getValue();
                validationContext.visitTypeProblem(TypeValidationContext.Severity.WARNING, type, String.format("field '%s' without corresponding getter has been annotated with %s", fieldName, DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(fieldAnnotations.keySet().stream())));
            });
        }
        return propertiesMetadata;
    }

    private void processMethodAnnotations(Method method, Map<String, PropertyAnnotationMetadataBuilder> methodBuilders, TypeValidationContext validationContext) {
        if (method.isSynthetic()) {
            return;
        }
        if (method.isBridge()) {
            return;
        }
        if (this.potentiallyIgnoredMethodNames.contains((Object)method.getName()) && this.globallyIgnoredMethods.contains((Object)Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method))) {
            return;
        }
        ImmutableMap<Class<? extends Annotation>, Annotation> annotations = this.collectRelevantAnnotations(method);
        if (Modifier.isStatic(method.getModifiers())) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotated("static", method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            return;
        }
        PropertyAccessorType accessorType = PropertyAccessorType.of(method);
        if (accessorType == null) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotated("non-property", method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            return;
        }
        String propertyName = accessorType.propertyNameFor(method);
        if (accessorType == PropertyAccessorType.SETTER) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotated("setter", method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            this.validateSetterForMutableType(method, accessorType, validationContext, propertyName);
            return;
        }
        boolean privateGetter = Modifier.isPrivate(method.getModifiers());
        if (privateGetter && annotations.isEmpty()) {
            return;
        }
        PropertyAnnotationMetadataBuilder metadataBuilder = this.getOrCreateBuilder(propertyName, method, validationContext, methodBuilders);
        metadataBuilder.overrideMethod(method);
        if (privateGetter) {
            metadataBuilder.recordProblem(String.format("is private and annotated with %s", DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotations.keySet().stream())));
        }
        for (Annotation annotation : annotations.values()) {
            metadataBuilder.declareAnnotation(annotation);
        }
    }

    private void validateSetterForMutableType(Method setterMethod, PropertyAccessorType setterAccessorType, TypeValidationContext validationContext, String propertyName) {
        Class<?> setterType = setterAccessorType.propertyTypeFor(setterMethod);
        if (this.isSetterProhibitedForType(setterType)) {
            validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyName, String.format("of mutable type '%s' is writable. Properties of this type should be read-only and mutated via the value itself", setterType.getName()));
        }
    }

    private boolean isSetterProhibitedForType(Class<?> setter) {
        return this.mutableNonFinalClasses.stream().anyMatch(prohibited -> prohibited.isAssignableFrom(setter));
    }

    private void visitSuperTypes(Class<?> type, TypeAnnotationMetadataVisitor visitor) {
        Arrays.stream(type.getInterfaces()).forEach(superInterface -> visitor.visitType((Class<?>)superInterface, this.getTypeAnnotationMetadata((Class<?>)superInterface)));
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            visitor.visitType(superclass, this.getTypeAnnotationMetadata(superclass));
        }
    }

    private static void validateNotAnnotated(String methodKind, Method method, Set<Class<? extends Annotation>> annotationTypes, TypeValidationContext validationContext) {
        if (!annotationTypes.isEmpty()) {
            validationContext.visitTypeProblem(TypeValidationContext.Severity.WARNING, method.getDeclaringClass(), String.format("%s method '%s()' should not be annotated with: %s", methodKind, method.getName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationTypes.stream())));
        }
    }

    private static String simpleAnnotationNames(Stream<Class<? extends Annotation>> annotationTypes) {
        return annotationTypes.map(annotationType -> "@" + annotationType.getSimpleName()).collect(Collectors.joining(", "));
    }

    private ImmutableMap<Class<? extends Annotation>, Annotation> collectRelevantAnnotations(AnnotatedElement element) {
        Annotation[] annotations = element.getDeclaredAnnotations();
        if (annotations.length == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder relevantAnnotations = ImmutableMap.builderWithExpectedSize((int)annotations.length);
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.propertyAnnotationCategories.containsKey(annotationType)) continue;
            relevantAnnotations.put(annotationType, (Object)annotation);
        }
        return relevantAnnotations.build();
    }

    private class PropertyAnnotationMetadataBuilder
    implements Comparable<PropertyAnnotationMetadataBuilder> {
        private final String propertyName;
        private Method method;
        private final ListMultimap<AnnotationCategory, Annotation> declaredAnnotations = ArrayListMultimap.create();
        private final SetMultimap<AnnotationCategory, Annotation> inheritedInterfaceAnnotations = HashMultimap.create();
        private final SetMultimap<AnnotationCategory, Annotation> inheritedSuperclassAnnotations = HashMultimap.create();
        private final TypeValidationContext validationContext;

        public PropertyAnnotationMetadataBuilder(String propertyName, Method method, TypeValidationContext validationContext) {
            this.propertyName = propertyName;
            this.method = method;
            this.validationContext = validationContext;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Method getMethod() {
            return this.method;
        }

        public void overrideMethod(Method method) {
            this.method = method;
        }

        public void declareAnnotation(Annotation annotation) {
            AnnotationCategory category = (AnnotationCategory)DefaultTypeAnnotationMetadataStore.this.propertyAnnotationCategories.get(annotation.annotationType());
            this.declaredAnnotations.put((Object)category, (Object)annotation);
        }

        public void inheritAnnotations(boolean fromInterface, PropertyAnnotationMetadata superProperty) {
            superProperty.getAnnotations().forEach((arg_0, arg_1) -> (fromInterface ? this.inheritedInterfaceAnnotations : this.inheritedSuperclassAnnotations).put(arg_0, arg_1));
        }

        public void recordProblem(String problem) {
            this.validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, this.propertyName, problem);
        }

        public PropertyAnnotationMetadata build() {
            return new DefaultPropertyAnnotationMetadata(this.propertyName, this.method, this.resolveAnnotations());
        }

        private ImmutableMap<AnnotationCategory, Annotation> resolveAnnotations() {
            List declaredTypes = this.declaredAnnotations.get((Object)AnnotationCategory.TYPE);
            for (Annotation declaredType : declaredTypes) {
                Class<? extends Annotation> ignoredMethodAnnotation = declaredType.annotationType();
                if (!DefaultTypeAnnotationMetadataStore.this.ignoredMethodAnnotations.contains(ignoredMethodAnnotation)) continue;
                if (this.declaredAnnotations.values().size() > 1) {
                    this.recordProblem(String.format("annotated with @%s should not be also annotated with %s", ignoredMethodAnnotation.getSimpleName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(this.declaredAnnotations.values().stream().map(Annotation::annotationType).filter(annotationType -> !annotationType.equals(ignoredMethodAnnotation)))));
                }
                return ImmutableMap.of((Object)AnnotationCategory.TYPE, (Object)declaredType);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AnnotationCategory category : this.allAnnotationCategories()) {
                Annotation resolvedAnnotation;
                List declaredAnnotationsForCategory = this.declaredAnnotations.get((Object)category);
                if (!declaredAnnotationsForCategory.isEmpty()) {
                    resolvedAnnotation = this.resolveAnnotation("declared", category, declaredAnnotationsForCategory);
                } else {
                    Set interfaceAnnotations = this.inheritedInterfaceAnnotations.get((Object)category);
                    if (!interfaceAnnotations.isEmpty()) {
                        resolvedAnnotation = this.resolveAnnotation("inherited (from interface)", category, interfaceAnnotations);
                    } else {
                        Set superclassAnnotations = this.inheritedSuperclassAnnotations.get((Object)category);
                        resolvedAnnotation = this.resolveAnnotation("inherited (from superclass)", category, superclassAnnotations);
                    }
                }
                builder.put((Object)category, (Object)resolvedAnnotation);
            }
            return builder.build();
        }

        private ImmutableSet<AnnotationCategory> allAnnotationCategories() {
            return ImmutableSet.builder().addAll((Iterable)this.declaredAnnotations.keySet()).addAll((Iterable)this.inheritedInterfaceAnnotations.keySet()).addAll((Iterable)this.inheritedSuperclassAnnotations.keySet()).build();
        }

        private Annotation resolveAnnotation(String source, AnnotationCategory category, Collection<Annotation> annotationsForCategory) {
            Iterator<Annotation> iDeclaredAnnotationForCategory = annotationsForCategory.iterator();
            Annotation declaredAnnotationForCategory = iDeclaredAnnotationForCategory.next();
            if (iDeclaredAnnotationForCategory.hasNext()) {
                this.recordProblem(String.format("has conflicting %s annotations %s: %s; assuming @%s", category.getDisplayName(), source, DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationsForCategory.stream().map(Annotation::annotationType)), declaredAnnotationForCategory.annotationType().getSimpleName()));
            }
            return declaredAnnotationForCategory;
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            Iterable allAnnotations = Iterables.concat((Iterable)this.declaredAnnotations.values(), (Iterable)this.inheritedInterfaceAnnotations.values(), (Iterable)this.inheritedSuperclassAnnotations.values());
            for (Annotation annotation : allAnnotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(PropertyAnnotationMetadataBuilder o) {
            return this.propertyName.compareTo(o.propertyName);
        }
    }

    @FunctionalInterface
    private static interface TypeAnnotationMetadataVisitor {
        public void visitType(Class<?> var1, TypeAnnotationMetadata var2);
    }
}

