/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Optional;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.ReadOnlyFileSystemNode;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractFileSystemLocationSnapshot
implements FileSystemLocationSnapshot {
    private final String absolutePath;
    private final String name;
    private final FileMetadata.AccessType accessType;

    public AbstractFileSystemLocationSnapshot(String absolutePath, String name, FileMetadata.AccessType accessType) {
        this.absolutePath = absolutePath;
        this.name = name;
        this.accessType = accessType;
    }

    protected static MissingFileSnapshot missingSnapshotForAbsolutePath(String filePath) {
        return new MissingFileSnapshot(filePath, FileMetadata.AccessType.DIRECT);
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileMetadata.AccessType getAccessType() {
        return this.accessType;
    }

    public String getPathToParent() {
        return this.getName();
    }

    @Override
    public FileSystemLocationSnapshot store(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, MetadataSnapshot snapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
        return this;
    }

    @Override
    public void accept(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        snapshotVisitor.visitSnapshotRoot(this);
    }

    @Override
    public boolean hasDescendants() {
        return true;
    }

    @Override
    public FileSystemNode asFileSystemNode() {
        return this;
    }

    @Override
    public Optional<MetadataSnapshot> getSnapshot() {
        return Optional.of(this);
    }

    @Override
    public Optional<MetadataSnapshot> getSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return this.getChildSnapshot(relativePath, caseSensitivity);
    }

    protected Optional<MetadataSnapshot> getChildSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return Optional.of(AbstractFileSystemLocationSnapshot.missingSnapshotForAbsolutePath(relativePath.getAbsolutePath()));
    }

    @Override
    public ReadOnlyFileSystemNode getNode(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return this.getChildNode(relativePath, caseSensitivity);
    }

    protected ReadOnlyFileSystemNode getChildNode(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return AbstractFileSystemLocationSnapshot.missingSnapshotForAbsolutePath(relativePath.getAbsolutePath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileSystemLocationSnapshot that = (AbstractFileSystemLocationSnapshot)o;
        if (this.accessType != that.accessType) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.absolutePath.equals(that.absolutePath)) {
            return false;
        }
        return this.getHash().equals((Object)that.getHash());
    }

    public int hashCode() {
        int result = this.absolutePath.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.accessType.hashCode();
        result = 31 * result + this.getHash().hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

