/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.tools.shared;

public class StringUtils {
    public static char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void hex4(char c, StringBuffer sb) {
        sb.append(HEX_CHARS[(c & 0xF000) >> 12]);
        sb.append(HEX_CHARS[(c & 0xF00) >> 8]);
        sb.append(HEX_CHARS[(c & 0xF0) >> 4]);
        sb.append(HEX_CHARS[c & 0xF]);
    }

    public static String javaScriptString(String value) {
        char[] chars = value.toCharArray();
        int n = chars.length;
        int quoteCount = 0;
        int aposCount = 0;
        block14: for (int i = 0; i < n; ++i) {
            switch (chars[i]) {
                case '\"': {
                    ++quoteCount;
                    continue block14;
                }
                case '\'': {
                    ++aposCount;
                }
            }
        }
        StringBuffer result = new StringBuffer(value.length() + 16);
        char quoteChar = quoteCount < aposCount ? (char)'\"' : '\'';
        result.append(quoteChar);
        for (int i = 0; i < n; ++i) {
            int hexSize;
            char c = chars[i];
            if (' ' <= c && c <= '~' && c != quoteChar && c != '\\') {
                result.append(c);
                continue;
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case '\'': {
                    escape = 39;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                result.append('\\');
                result.append((char)escape);
                continue;
            }
            if (c < ' ' && (i == n - 1 || chars[i + 1] < '0' || chars[i + 1] > '9')) {
                result.append('\\');
                if (c > '\u0007') {
                    result.append((char)(48 + (7 & c >> 3)));
                }
                result.append((char)(48 + (7 & c)));
                continue;
            }
            if (c < '\u0100') {
                result.append("\\x");
                hexSize = 2;
            } else {
                result.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                result.append(HEX_CHARS[digit]);
            }
        }
        result.append(quoteChar);
        StringUtils.escapeClosingTags(result);
        String resultString = result.toString();
        return resultString;
    }

    public static String toHexString(byte[] bytes) {
        char[] hexString = new char[2 * bytes.length];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            hexString[j++] = HEX_CHARS[(bytes[i] & 0xF0) >> 4];
            hexString[j++] = HEX_CHARS[bytes[i] & 0xF];
        }
        return new String(hexString);
    }

    private static void escapeClosingTags(StringBuffer str) {
        if (str == null) {
            return;
        }
        int index = 0;
        while ((index = str.indexOf("</", index)) != -1) {
            str.insert(index + 1, '\\');
        }
    }
}

