/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    static final long serialVersionUID = 3288129636638950196L;
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList;
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel;
    protected int selectionMode;
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow;
    static /* synthetic */ Class class$javax$swing$event$TreeSelectionListener;

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public String toString() {
        return null;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setRowMapper(RowMapper rowMapper) {
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionPath(TreePath treePath) {
        this.selection = new TreePath[]{treePath};
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
    }

    public void addSelectionPath(TreePath treePath) {
        if (!this.isPathSelected(treePath)) {
            if (this.isSelectionEmpty()) {
                this.setSelectionPath(treePath);
            } else {
                TreePath[] treePathArray = new TreePath[this.selection.length + 1];
                System.arraycopy(this.selection, 0, treePathArray, 0, this.selection.length);
                treePathArray[treePathArray.length - 1] = treePath;
                this.selection = new TreePath[treePathArray.length];
                System.arraycopy(treePathArray, 0, this.selection, 0, treePathArray.length);
            }
            this.leadPath = treePath;
            this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, true, this.leadPath, treePath));
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            TreePath treePath = null;
            int n = 0;
            while (n < treePathArray.length) {
                treePath = treePathArray[n];
                if (!this.isPathSelected(treePath)) {
                    if (this.isSelectionEmpty()) {
                        this.setSelectionPath(treePath);
                    } else {
                        TreePath[] treePathArray2 = new TreePath[this.selection.length + 1];
                        System.arraycopy(this.selection, 0, treePathArray2, 0, this.selection.length);
                        treePathArray2[treePathArray2.length - 1] = treePath;
                        this.selection = new TreePath[treePathArray2.length];
                        System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
                    }
                    this.leadPath = treePathArray[treePathArray.length - 1];
                    this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, true, this.leadPath, treePathArray[0]));
                }
                ++n;
            }
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        int n = -1;
        if (this.isPathSelected(treePath)) {
            int n2 = 0;
            while (n2 < this.selection.length) {
                if (this.selection[n2].equals(treePath)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            TreePath[] treePathArray = new TreePath[this.selection.length - 1];
            System.arraycopy(this.selection, 0, treePathArray, 0, n);
            System.arraycopy(this.selection, n + 1, treePathArray, n, this.selection.length - n - 1);
            this.selection = new TreePath[treePathArray.length];
            System.arraycopy(treePathArray, 0, this.selection, 0, treePathArray.length);
            this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, false, this.leadPath, treePath));
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            int n = -1;
            TreePath treePath = null;
            int n2 = 0;
            while (n2 < treePathArray.length) {
                treePath = treePathArray[n2];
                if (this.isPathSelected(treePath)) {
                    int n3 = 0;
                    while (n3 < this.selection.length) {
                        if (this.selection[n2].equals(treePath)) {
                            n = n3;
                            break;
                        }
                        ++n3;
                    }
                    TreePath[] treePathArray2 = new TreePath[this.selection.length - 1];
                    System.arraycopy(this.selection, 0, treePathArray2, 0, n);
                    System.arraycopy(this.selection, n + 1, treePathArray2, n, this.selection.length - n - 1);
                    this.selection = new TreePath[treePathArray2.length];
                    System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
                    this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, false, this.leadPath, treePathArray[0]));
                }
                ++n2;
            }
        }
    }

    public TreePath getSelectionPath() {
        if (this.selection == null || this.selection.length == 0) {
            return null;
        }
        return this.selection[0];
    }

    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public boolean isPathSelected(TreePath treePath) {
        if (this.selection == null) {
            return false;
        }
        int n = 0;
        while (n < this.selection.length) {
            if (this.selection[n].equals(treePath)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        boolean bl = false;
        if (this.selection == null || this.selection.length == 0) {
            bl = true;
        }
        return bl;
    }

    public void clearSelection() {
        this.leadPath = null;
        this.selection = null;
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.add(clazz, treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.remove(clazz, treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        return (TreeSelectionListener[])this.getListeners(clazz);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionListener[] treeSelectionListenerArray = this.getTreeSelectionListeners();
        int n = 0;
        while (n < treeSelectionListenerArray.length) {
            treeSelectionListenerArray[n].valueChanged(treeSelectionEvent);
            ++n;
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public int[] getSelectionRows() {
        if (this.rowMapper == null) {
            return null;
        }
        return this.rowMapper.getRowsForPaths(this.selection);
    }

    public int getMinSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = Math.min(n, nArray[n2]);
            ++n2;
        }
        return n;
    }

    public int getMaxSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        int n = -1;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = Math.max(n, nArray[n2]);
            ++n2;
        }
        return n;
    }

    public boolean isRowSelected(int n) {
        return false;
    }

    public void resetRowSelection() {
    }

    public int getLeadSelectionRow() {
        if (this.rowMapper == null || this.leadPath == null) {
            return -1;
        }
        return this.rowMapper.getRowsForPaths(new TreePath[]{this.leadPath})[0];
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        return false;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        return false;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        return false;
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
    }

    protected void updateLeadIndex() {
    }

    protected void insureUniqueness() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DefaultTreeSelectionModel() {
        this.setSelectionMode(4);
        this.listenerList = new EventListenerList();
    }
}

