/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.claribole.zvtm.engine.ObservedRegionListener;
import net.claribole.zvtm.engine.TrailingCameraPortalST;

public class TrailingOverview
extends TrailingCameraPortalST {
    AlphaComposite orST = AlphaComposite.getInstance(3, 0.5f);
    Camera observedRegionCamera;
    View observedRegionView;
    long[] observedRegion;
    float orcoef;
    Timer borderTimer;
    ObservedRegionListener observedRegionListener;

    public TrailingOverview(int x, int y, int w, int h, Camera pc, Camera orc, float a, int xo, int yo) {
        super(x, y, w, h, pc, a, xo, yo);
        this.observedRegionCamera = orc;
        this.observedRegionView = orc.getOwningView();
        this.observedRegion = new long[4];
        this.borderTimer = new Timer();
        this.borderTimer.scheduleAtFixedRate((TimerTask)new BorderTimer(this), 40L, 40L);
    }

    public void setTransparencyValue(float a) {
        block3: {
            if (a < 0.0f) {
                a = 0.0f;
            }
            try {
                this.acST = AlphaComposite.getInstance(3, a);
                this.alpha = a;
                this.orST = AlphaComposite.getInstance(3, a / 2.0f);
            }
            catch (IllegalArgumentException ex) {
                if (!VirtualSpaceManager.debugModeON()) break block3;
                System.err.println("Error animating translucency of " + this.toString() + ": " + a);
            }
        }
    }

    public boolean coordInsideObservedRegion(int cx, int cy) {
        return cx >= this.x + this.w / 2 + Math.round((float)(this.observedRegion[0] - this.camera.posx) * this.orcoef) && cy >= this.y + this.h / 2 + Math.round((float)(this.camera.posy - this.observedRegion[1]) * this.orcoef) && cx <= this.x + this.w / 2 + Math.round((float)(this.observedRegion[2] - this.camera.posx) * this.orcoef) && cy <= this.y + this.h / 2 + Math.round((float)(this.camera.posy - this.observedRegion[3]) * this.orcoef);
    }

    public void setObservedRegionListener(ObservedRegionListener orl) {
        this.observedRegionListener = orl;
    }

    void observedRegionIntersects(long[] wnes) {
        if (this.observedRegionListener != null) {
            this.observedRegionListener.intersectsParentRegion(wnes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        g2d.setClip(this.x, this.y, this.w, this.h);
        g2d.setComposite(this.acST);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        Vector vector = this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = (long)((float)this.camera.posx - (float)(this.w / 2) * this.uncoef);
            this.viewNC = (long)((float)this.camera.posy + (float)(this.h / 2) * this.uncoef);
            this.viewEC = (long)((float)this.camera.posx + (float)(this.w / 2) * this.uncoef);
            this.viewSC = (long)((float)this.camera.posy - (float)(this.h / 2) * this.uncoef);
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                    }
                    continue;
                }
            }
        }
        this.observedRegion = this.observedRegionView.getVisibleRegion(this.observedRegionCamera, this.observedRegion);
        g2d.setColor(Color.GREEN);
        g2d.setComposite(this.orST);
        this.orcoef = this.camera.focal / (this.camera.focal + this.camera.altitude);
        g2d.fillRect(this.x + this.w / 2 + Math.round((float)(this.observedRegion[0] - this.camera.posx) * this.orcoef), this.y + this.h / 2 - Math.round((float)(this.observedRegion[1] - this.camera.posy) * this.orcoef), Math.round((float)(this.observedRegion[2] - this.observedRegion[0]) * this.orcoef), Math.round((float)(this.observedRegion[1] - this.observedRegion[3]) * this.orcoef));
        g2d.setComposite(this.acST);
        g2d.drawRect(this.x + this.w / 2 + Math.round((float)(this.observedRegion[0] - this.camera.posx) * this.orcoef), this.y + this.h / 2 - Math.round((float)(this.observedRegion[1] - this.camera.posy) * this.orcoef), Math.round((float)(this.observedRegion[2] - this.observedRegion[0]) * this.orcoef), Math.round((float)(this.observedRegion[1] - this.observedRegion[3]) * this.orcoef));
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
        g2d.setComposite(acO);
    }

    public void dispose() {
        super.dispose();
        this.borderTimer.cancel();
    }

    protected class BorderTimer
    extends TimerTask {
        TrailingOverview portal;
        long[] portalRegion = new long[4];
        long[] intersection = new long[4];

        BorderTimer(TrailingOverview p) {
            this.portal = p;
        }

        public void run() {
            this.portal.getVisibleRegion(this.portalRegion);
            this.intersection[0] = this.portal.observedRegion[0] - this.portalRegion[0];
            this.intersection[1] = this.portal.observedRegion[1] - this.portalRegion[1];
            this.intersection[2] = this.portal.observedRegion[2] - this.portalRegion[2];
            this.intersection[3] = this.portal.observedRegion[3] - this.portalRegion[3];
            this.portal.observedRegionIntersects(this.intersection);
        }
    }
}

