--[[ Copyright (c) 2010 Manuel "Roujin" Wolf
Copyright (c) 2012 Henrique Poyatos
Copyright (c) 2014 Leonardo Malaman (LeonardoGamer)
Copyright (c) 2017-2024 Altieres Lima da Silva
Copyright (c) 2020 Henrique Poyatos

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

Language("Português Brasileiro", "Brazilian Portuguese", "pt_br", "br")
Inherit("English")
Encoding(utf8)

--Note: All strings should use a single space after full-stops. Only exception is level descriptions.
-------------------------------  OVERRIDE  ----------------------------------
adviser.warnings.money_low = "Você está ficando sem dinheiro!" -- Funny. Exists in German translation, but not existent in english?
tooltip.graphs.reputation = "Alternar reputaçäo" -- Incorrectly said "toggle hospital value"
tooltip.status.close = "Fechar janela de status" -- Incorrectly said "close overview window"

-- tooltip.staff_list.next_person, prev_person is rather next/prev page (also in german, maybe more languages?)
tooltip.staff_list.next_person = "Mostrar a página seguinte"
tooltip.staff_list.prev_person = "Mostrar a página anterior"
tooltip.status.reputation = "Sua Reputaçäo näo deve ser menor que %d. Atualmente está em %d"
tooltip.status.balance = "Seu saldo bancário näo deve ser menor que %d. Atualmente está em %d"

-- The originals of these two contain one space too much
fax.emergency.cure_not_possible_build = "Você precisará construir um(a) %s"
fax.emergency.cure_not_possible_build_and_employ = "Você precisará construir um(a) %s e contratar um(a)"
fax.emergency.num_disease = "Existem %d pessoas com %s e precisam ser atendidas imediatamente."
adviser.goals.lose.kill = "Mate mais %d pacientes para perder o nível!"

-- Improve tooltips in staff window to mention hidden features
tooltip.staff_window.face = "Rosto da pessoa - clique para abrir a tela de gerenciamento."
tooltip.staff_window.center_view = "Clique esquerdo para fixar-se na pessoa, botäo direito para rodar entre os funcionários."

-- These strings are missing in some versions of TH (unpatched?)
confirmation.restart_level = "Você tem certeza de que deseja reiniciar o nível?"
-- TODO adviser.multiplayer.objective_completed
-- TODO adviser.multiplayer.objective_failed

-- Replace Billy Savile
-- this is only relevant to the English game so does not need adding
-- in other language files
vip_names = {
 [6] = "O Presidente da Cruz Vermelha",
}

-- An override for the squits becoming the the squits see issue 1646
adviser.research.drug_improved_1 = "Seu Centro de Pesquisa melhorou o medicamento para %s"

-- Disease overrides where there are typos
golf_stones.cure = "Cura - Dois cirurgiöes operam para extrair os cálculos."
ruptured_nodules.cure = "Cura - Dois cirurgiöes qualificados colocam certas partes com mäos firmes."
slack_tongue.cause = "Causa - Fazer muita fofoca."
slack_tongue.cure = "Cura - Coloca-se a língua no corta-línguas e elimina-se de forma rápida, eficaz e dolorosa."
the_squits.cure = "Cura - Uma mistura pegajosa de substâncias viscosas preparada na farmácia solidifica as tripas do paciente."
bloaty_head.cure = "Cura - Fura-se a cabeça inflada, em seguida, volta-se a inflar até o tamanho correto com uma máquina inteligente."

-- Rooms overrides where there are typos
inflation[2] = "Os pacientes que sofrem a dolorosa doença de terem a cabeça inflada devem ir à sala de inflatoterapia, será desinflada sua cabeça e em seguida vota a ser inflada à pressäo correta.//"
staff_room[2] = "Os seus funcionários se cansam quando realizam o seu trabalho. Precisam desta sala para descansar e se refrescar. Os funcionários cansados säo mais lentos, pedem mais dinheiro e por fim väo embora. Também cometem mais erros. Vale a pena construir uma sala que tenham muitos passatempos. Assegure-se de que há lugar para vários funcionários ao mesmo tempo. "

-- Staff description overrides where there are typos
staff_descriptions.bad[14] = "Pessoa ardilosa, matreira e subversiva. "
staff_descriptions.misc[11] = "Destila uísque. "

-- Correction to a pay rise prompt with typos
pay_rise.regular[1] = "Estou esgotado. Preciso de umas boas férias, mais um aumento de %d, se näo quiser deixo este maldito emprego."

-- Level description overrides where there are typos. Note: This is the only portion of the game that SHOULD use double space after fullstops etc.
introduction_texts.level17 = "Um último aviso.  Fique de olho na sua Reputaçäo, é o que atrairá pacientes ao seu estabelecimento.  Se näo matar muitas pessoas e as mantiver razoavelmente felizes näo deverá ter muitos problemas com este nível!//Agora é com você, boa sorte."
introduction_texts.level11 = "Tem a oportunidade de construir o hospital definitivo.  Esta é uma área de enorme prestígio e o Ministério quer que este seja o melhor hospital.  Esperamos que ganhe muito dinheiro, alcance uma excelente reputaçäo e que se encarregue de todos os casos que sejam apresentados.  Este é um trabalho importante.  Terá que ser muito hábil para completá-lo.  Também deve ter em conta que foram vistos OVNIs na área.  Assegure-se de que os seus funcionários estejam preparados para receber algumas visitas inesperadas.  O seu hospital terá que alcançar um valor de $240.000, precisará ter $500.000 no banco e uma reputaçäo de 700."
introduction_texts.level9 = "Depois de depositar o dinheiro na conta bancária do Ministério e pagar uma nova limousine para o Ministro, agora pode dedicar a criar um bom hospital para cuidar dos doentes e necessitados.  Aqui terá um montäo de problemas diferentes.  Se os seus funcionários tiverem uma boa formaçäo e suficientes consultas, poderäo resolver qualquer situaçäo.  O seu hospital terá que valer $200.000 e precisará ter $400.000 no banco.  Se näo o conseguir näo poderá terminar o nível."
introduction_texts.level16 = "Uma vez que tenha diagnosticado algum dos pacientes, precisará construir salas de tratamento e clínicas para curá-los.  Pode começar com uma Farmácia, onde precisará de uma Enfermeira que distribua os remédios."
introduction_texts.level10 = "Além de dever curar todas as doenças que possa haver, o Ministério pede que empregue um pouco de tempo em aumentar a eficácia dos seus remédios.//Houve algumas queixas por parte do D. Salutíssimo, o Cachorro Guardiäo da Saúde, assim deve procurar com que todos os seus remédios sejam extremamente eficazes para ficar bem.  Também, assegure-se de que o seu hospital tenha uma reputaçäo irrepreensível.  Procure deixar morrer poucos pacientes.  Como sugestäo, deveria deixar espaço para um banho gelatinoso.  Para ganhar, os seus remédios deveräo ter uma eficácia de, pelo menos, 80%, tem que conseguir uma reputaçäo de 650 e guardar $500.000 no banco."
introduction_texts.level12 = "Agora enfrentará o maior dos desafios.  Impressionado com os seus lucros, o Ministério tem uma grande tarefa para você; querem que construa outro magnífico hospital, que tenha um excelente lucro e uma reputaçäo incrível.  Também querem que compre todo o terreno que puder, cure tudo (e queremos dizer todas as doenças) e ganhe todos os prêmios.  Acha que conseguirá?  Ganhe $650.000, cure 750 pessoas e consiga uma reputaçäo de 800 para ganhar este nível."
introduction_texts.level15 = "Bem, estes säo os mecanismos básicos para pôr em funcionamento um hospital.//Os seus Médicos väo precisar de toda a ajuda que possam obter para diagnosticar alguns dos pacientes.  Pode ajudá-los construindo outros equipamentos de diagnóstico como a sala de Diagnóstico Geral."
-- A small error in the introduction text of level 2
introduction_texts.level2 = "Há uma grande variedade de doenças nesta área. Prepare o seu hospital para tratar mais pacientes " ..
                            "e para a construçäo de um Centro de Pesquisa. Lembre-se que deve manter limpo o hospital e procurar atingir a " ..
                            "sua mais alta reputaçäo possível. Tratará doenças como a língua comprida, entäo necessitará de uma sala de " ..
                            "laringologia. Também pode construir uma cardiologia para diagnosticar novas doenças. Estas duas consultas deveräo " ..
                            "ser pesquisadas antes de as construir. Também pode comprar mais terreno para aumentar o seu hospital. " ..
                            "Para isso, utilize o mapa da cidade. Obtenha uma reputaçäo de 300 um saldo de bancário de $10,000 e 40 pessoas curadas. "

-- Override for level progress typo
level_progress.hospital_value_enough = "Mantenha o valor do seu hospital acima de %d e atenda os seus outros problemas para ganhar o nível."
level_progress.cured_enough_patients = "Curou muitos pacientes, mas precisa manter o seu hospital em melhor estado para ganhar o nível."

-- Override for multiplayer typos
multiplayer.players_failed = "O(s) seguinte(s) jogador(es) näo conseguiu(ram) atingir o último objetivo:"
multiplayer.everyone_failed = "Ninguém conseguiu cumprir o último objetivo. Entäo, todos continuam jogando!"

-- Override for a disease patient choice typo
disease_discovered_patient_choice.need_to_employ = "Contrate um(a) %s para lidar com esta situaçäo."

-- Override for shorter messages and a typo in 12.2
letter[9][2] = "Você provou ser o melhor administrador de hospitais na longa e conturbada história da medicina. Tal conquista monumental näo pode passar despercebida, entäo gostaríamos de oferecer-lhe o cargo honorário de Chefe Supremo de Todos os Hospitais. Isso vem com um salário de $%d. Você será recebido com uma parada em sua homenagem, e as pessoas demonstraräo sua gratidäo por onde quer que vá.//"
letter[10][2] = "Parabéns por administrar com sucesso todos os hospitais que lhe foram designados. Tal desempenho magnífico lhe qualifica para a liberdade de todas as cidades do mundo. Você receberá uma pensäo de $%d, e tudo o que pedimos é que viaje, gratuitamente, por todo o país, promovendo o trabalho de todos os hospitais ao seu público adorador.//"
letter[11][2] = "Sua carreira foi exemplar, e você é uma inspiraçäo para todos nós. Obrigado por administrar tantos hospitais com tanta competência. Gostaríamos de lhe conceder um salário vitalício de $%d, e simplesmente pedir que viaje em um carro oficial aberto de cidade em cidade, proferindo palestras sobre como alcançou tanto sucesso em täo pouco tempo.//"
letter[11][3] = "Você é um exemplo para todas as pessoas sábias, e sem exceçäo, todos no mundo o(a) consideram um ativo supremo.//"
letter[12][2] = "Sua carreira de sucesso como o melhor administrador de hospitais desde Moisés está chegando ao fim. Condizente com seu impacto na naçäo, o Ministério gostaria de lhe oferecer um salário de $%d apenas para aparecer em nosso nome, inaugurando eventos, lançando navios e participando de programas de entrevistas. Seria uma ótima PR para todos nós!//"

-------------------------------  NEW STRINGS  -------------------------------
date_format = {
  daymonth = "%1% %2:months%",
}

object.litter = "Lixo"
tooltip.objects.litter = "Lixo: Deixado no chäo por um paciente porque ele näo encontrou uma lixeira para jogá-lo."

object.rathole = "Buraco de rato"
tooltip.objects.rathole = "Casa de uma família de ratos que encontrou seu hospital sujo o suficiente para morar nele."

tooltip.fax.close = "Fecha esta janela sem apagar a mensagem."
tooltip.message.button = "Clique com o botäo esquerdo para abrir a mensagem"
tooltip.message.button_dismiss = "Clique com o botäo esquerdo para abrir a mensagem e botäo direto para recusá-la"
tooltip.casebook.cure_requirement.hire_staff = "Você precisa contratar funcionários para realizar este tratamento."
tooltip.casebook.cure_type.unknown = "Você ainda näo sabe como tratar esta doença"
tooltip.research_policy.no_research = "Nenhuma pesquisa está sendo realizada nesta categoria no momento."
tooltip.research_policy.research_progress = "Progresso para a próxima descoberta nesta categoria: %1%/%2%"

menu["player_count"] = "QUANTIDADE DE JOGADORES"

menu_file = {
  load =    "  (%1%) CARREGAR  ",
  save =    "  (%1%) SALVAR  ",
  restart = "  (%1%) REINICIAR  ",
  quit =    "  (%1%) SAIR  "
}

menu_options = {
  sound = "  (%1%) SOM  ",
  announcements = "  (%1%) ANUNCIOS  ",
  music = "  (%1%) MUSICA  ",
  jukebox = "  (%1%) JUKEBOX  ",
  lock_windows = "  TRAVAR JANELAS  ",
  edge_scrolling = "  ROLAR MARGEM  ",
  capture_mouse = "  CAPTURAR MOUSE  ",
  adviser_disabled = "  (%1%) CONSELHEIRO  ",
  warmth_colors = "  CORES QUENTES  ",
  wage_increase = "  EXIGENCIAS SALARIAS  ",
  twentyfour_hour_clock = "  RELOGIO DE 24 HORAS  ",
}

menu_options_game_speed = {
  pause               = "  (%1%) PAUSAR  ",
  slowest             = "  (%1%) MUITO LENTO  ",
  slower              = "  (%1%) LENTO  ",
  normal              = "  (%1%) NORMAL  ",
  max_speed           = "  (%1%) RAPIDO  ",
  and_then_some_more  = "  (%1%) MUITO RAPIDO  ",
}

menu_options_warmth_colors = {
  choice_1 = "  VERMELHO  ",
  choice_2 = "  AZUL VERDE VERMELHO  ",
  choice_3 = "  AMARELO LARANJA VERMELHO  ",
}

menu_options_wage_increase = {
  grant = "    CONCEDER ",
  deny =  "    NEGAR ",
}

-- Add F-keys to entries in charts menu (except briefing), also town_map was added.
menu_charts = {
  bank_manager  = "  (%1%) GERENTE DO BANCO  ",
  statement     = "  (%1%) ESTADO DA CONTA  ",
  staff_listing = "  (%1%) LISTA DOS FUNCIONARIOS  ",
  town_map      = "  (%1%) MAPA DA CIDADE  ",
  casebook      = "  (%1%) FICHA CLINICA  ",
  research      = "  (%1%) PESQUISA  ",
  status        = "  (%1%) ESTADO  ",
  graphs        = "  (%1%) GRAFICO  ",
  policy        = "  (%1%) NORMAS  ",
}

menu_debug = {
  jump_to_level               = "  IR PARA O NIVEL  ",
  connect_debugger            = "  (%1%) CONECTAR AO SERVIDOR LUA DBGp  ",
  transparent_walls           = "  (%1%) PAREDES TRANSPARENTES  ",
  limit_camera                = "  LIMITAR CAMERA  ",
  disable_salary_raise        = "  DESATIVAR AUMENTO SALARIAL  ",
  allow_blocking_off_areas    = "  PERMITIR BLOQUEIO DE AREAS  ",
  allow_falling               = "  PERMITIR QUEDAS  ",
  make_debug_fax              = "  CRIAR FAX DE DEPURAÇAO  ",
  make_debug_patient          = "  CRIAR PACIENTE DE DEPURAÇAO  ",
  cheats                      = "  (%1%) TRAPAÇAS  ",
  lua_console                 = "  (%1%) CONSOLE LUA  ",
  debug_script                = "  (%1%) EXECUTAR SCRIPT DE DEPURAÇAO  ",
  calls_dispatcher            = "  DESPACHANTE DE CHAMADAS  ",
  dump_strings                = "  (%1%) EXPORTAR TEXTOS DO JOGO  ",
  dump_gamelog                = "  (%1%) EXPORTAR REGISTRO DO JOGO  ",
  map_overlay                 = "  SOBREPOSIÇAO DO MAPA  ",
  sprite_viewer               = "  VISUALIZADOR DE SPRITES  ",
}

menu_debug_overlay = {
  none                        = "  NADA  ",
  flags                       = "  SINALIZADORES  ",
  positions                   = "  POSIÇOES  ",
  heat                        = "  TEMPERATURA  ",
  byte_0_1                    = "  BYTE 0 & 1  ",
  byte_floor                  = "  BYTE DO PISO  ",
  byte_n_wall                 = "  BYTE DA PAREDE NORTE  ",
  byte_w_wall                 = "  BYTE DA PAREDE OESTE  ",
  byte_5                      = "  BYTE 5  ",
  byte_6                      = "  BYTE 6  ",
  byte_7                      = "  BYTE 7  ",
  parcel                      = "  TERRENO  ",
}

menu_player_count = {
  players_1 = "  1 JOGADOR  ",
  players_2 = "  2 JOGADORES  ",
  players_3 = "  3 JOGADORES  ",
  players_4 = "  4 JOGADORES  ",
}
adviser = {
  room_forbidden_non_reachable_parts = "Construir a sala neste local resultará em alas do hospital que näo poderäo ser acessadas.",
  warnings = {
    no_desk = "Você precisa comprar um balcäo de recepçäo e contratar uma recepcionista em algum momento!",
    no_desk_1 = "Se você quer que os pacientes venham ao seu hospital, você precisa contratar uma recepcionista e comprar um balcäo para recepcioná-los!",
    no_desk_2 = "Excelente, isso provavelmente é um recorde mundial - quase um ano e nenhum paciente! Se você deseja continuar administrando este hospital, você precisa urgente contratar uma recepcionista e comprar um balcäo para que ela possa trabalhar!",
    no_desk_3 = "Brilhante, se passou quase um ano e ainda näo tem uma recepcionista! Como quer que os pacientes apareçam? Arrume uma recepcionista e deixe de perder tempo!",
    no_desk_4 = "Uma recepcionista necessita de uma mesa para atender os pacientes que aparecem.",
    no_desk_5 = "Já era hora! Os pacientes começaräo a chegar logo.",
    no_desk_6 = "Você tem uma recepcionista, que tal se construir uma mesa de recepçäo para que possa trabalhar?",
    no_desk_7 = "Você construiu a mesa da recepçäo, entäo que tal contratar um recepcionista?  Você näo receberá nenhum paciente até que contrate uma.",
    another_desk = "Você precisará construir outra mesa para essa nova recepcionista.",
    cannot_afford = "Você näo tem dinheiro suficiente no banco para contratar essa pessoa!", -- I can't see anything like this in the original strings
    cannot_afford_2 = "Você näo tem dinheiro suficiente no banco para fazer essa compra!",
    cannot_afford_machine = "Você precisa de pelo menos $%1% no banco para comprar um novo %2%!",
    falling_1 = "Ei! Isso näo é engraçado, cuidado onde aponta este mouse; alguém pode se machucar!",
    falling_2 = "Gostou da queda? Pare de bagunçar!",
    falling_3 = "Ai, isso dói, alguém chame um médico!",
    falling_4 = "Isto é um Hospital, näo um parque de diversöes!",
    falling_5 = "Este näo é o local para empurrar as pessoas, elas estäo doentes sabia?!",
    falling_6 = "Aqui näo é uma pista de boliche, pessoas doentes näo deveriam ser tratadas desta forma!",
    research_screen_open_1 = "Para acessar a tela de pesquisa, tem que construir um Centro de Pesquisa.",
    research_screen_open_2 = "Näo é possível realizar pesquisas nessa fase.",
    researcher_needs_desk_1 = "Uma pesquisa necessita de uma mesa para trabalhar.",
    researcher_needs_desk_2 = "Seu pesquisador agradece que lhe tenha dado um descanso. Se pretende ter mais pessoas pesquisando, deve dar a cada um uma mesa para trabalhar.",
    researcher_needs_desk_3 = "Cada pesquisa necessita de uma mesa para trabalhar.",
    nurse_needs_desk_1 = "Cada enfermeira necessita de uma mesa para trabalhar.",
    nurse_needs_desk_2 = "Sua enfermeira agradece que lhe tenha dado um descanso. Se pretende ter mais pessoas trabalhando na Enfermaria, tem que dar a cada uma delas uma mesa para trabalhar.",
    low_prices = "Você está cobrando muito pouco pelo uso de %s. Isto trará pessoas para o seu hospital, mas você näo fará muito lucro com cada uma delas.",
    high_prices = "Você está cobrando muito pelo uso de %s. Isto trará grande lucro a curto prazo, mas no final das contas você começará a afugentar as pessoas para longe do seu hospital.",
    fair_prices = "Seus preços de %s parecem justos e equilibrados.",
    patient_not_paying = "Um paciente saiu sem pagar por %s porque está muito caro!",
  },
  cheats = {
    th_cheat = "Parabéns, você habilitou os códigos de trapaça!",
    roujin_on_cheat = "Desafio de Roujin ativado! Boa sorte nos próximos meses...",
    roujin_off_cheat = "Desafio de Roujin desativado. Tudo voltará ao normal em breve.",
    norest_on_cheat = "Oh näo! Parece que sua equipe consumiu muita cafeína e näo sente mais necessidade de descansar.",
    norest_off_cheat = "Ufa! Parece que a agitaçäo finalmente passou. Sua equipe agora descansará adequadamente.",
  },
  staff_place_advice = {
    not_enough_lecture_chairs = "Cada médico estagiário precisa de uma cadeira para assistir às aulas!",
  },
}

dynamic_info.patient.actions.no_gp_available = "Esperando que construa um Consultório Geral"
dynamic_info.staff.actions.heading_for = "Indo para %s"
dynamic_info.staff.actions.fired = "Demitido"
dynamic_info.staff.actions.vaccine = "Vacinando um paciente"
dynamic_info.patient.actions.epidemic_vaccinated = "Eu näo sou mais contagioso"
dynamic_info.object.strength_extra_info = "Força %d (Atualizável para %d)"

progress_report.free_build = "CONSTRUÇAO LIVRE"

fax = {
  choices = {
    return_to_main_menu = "Retornar ao menu principal",
    accept_new_level = "Passar para o próximo nível",
    decline_new_level = "Continuar jogando um pouco mais",
  },
  emergency = {
    num_disease_singular = "Existe uma pessoa com %s que precisa urgente de sua atençäo.",
    free_build = "Se você for bem-sucedido, sua reputaçäo aumentará, mas se falhar, sua reputaçäo será seriamente prejudicada.",
  },
  vip_visit_result = {
    remarks = {
      free_build = {
        "Seu hospital é muito bom! Näo é muito difícil fazê-lo funcionar sem limitaçöes financeiras, né?",
        "Näo sou economista, mas até eu poderia dirigir este hospital, se é que você me entende...",
        "Um hospital muito bem cuidado. Mas tome cuidado a crise financeira! Certo... você näo tem que se preocupar com isso.",
      }
    }
  }
}

letter = {
  dear_player = "Prezado(a) %s\n",
  custom_level_completed = "Parabéns! Você completou todos os objetivos desta fase personalizada!",
  return_to_main_menu = "Deseja retornar ao menu principal ou continuar jogando?",
  campaign_level_completed = "Bom trabalho! Você superou este nível, mas ainda näo acabou!\n Você se interessaria em aceitar um posto no hospital %s?",
  campaign_completed = "Incrível! Você conseguiu superar todos os níveis. Já pode relaxar e desfrutar enquanto fala das suas realizaçöes nos fóruns de toda a Internet. Boa sorte!",
  campaign_level_missing = "Desculpe, parece que o próximo nível desta campanha está faltando. (Nome: %s)",
}

install = {
  title = "----------------------- Configuraçäo do CorsixTH -----------------------",
  th_directory = "O CorsixTH precisa de uma cópia dos arquivos de dados do Theme Hospital original (ou a demo) para executar. Utilize o seletor abaixo para localizar o diretório onde o jogo Theme Hospital está instalado.",
  ok = "OK",
  exit = "Sair",
  cancel = "Cancelar",
}

misc = {
  not_yet_implemented = "(ainda näo implementado)",
  no_heliport = "Ou nenhuma doença foi descoberta ainda, ou näo há heliporto neste mapa. Pode ser que você precise construir uma recepçäo e contratar uma recepcionista.",
  cant_treat_emergency = "Seu hospital näo pode tratar essa emergência porque a doença näo foi descoberta. Sinta-se à vontade para tentar novamente.",
  epidemics_off = "Epidemias desativadas",
  epidemics_on = "Epidemias reativadas",
  earthquakes_off = "Terremotos desativados",
  earthquakes_on = "Terremotos reativados",
  epidemic_no_icon_to_toggle = "Näo foi possível mostrar/ocultar ícones de infectados - nenhuma epidemia em andamento näo revelada",
  epidemic_no_diseases = "Näo é possível criar uma epidemia - nenhuma doença contagiosa disponível",
  epidemic_no_receptionist = "Näo é possível criar uma epidemia - näo há recepçäo com pessoal",
}

main_menu = {
  new_game = "Campanha",
  custom_campaign = "Campanha Personalizada",
  custom_level = "Cenário Unico",
  continue = "Continuar Jogo",
  load_game = "Carregar Jogo",
  options = "Configuraçöes",
  map_edit = "Editor de Mapas",
  savegame_version = "Versäo do jogo salvo: ",
  updates_off = "Näo verificando atualizaçöes",
  version = "Versäo: ",
  exit = "Sair",
}

tooltip.main_menu = {
  new_game = "Iniciar o primeiro nível da campanha",
  custom_campaign = "Jogar uma campanha criada pela comunidade",
  custom_level = "Construa seu hospital em um cenário único",
  continue = "Continue seu jogo salvo mais recente",
  load_game = "Carregar um jogo salvo",
  options = "Ajustar várias configuraçöes",
  map_edit = "Criar um mapa personalizado",
  exit = "Näo, näo, por favor, näo saia!",
  quit = "Você está prestes a sair do CorsixTH. Tem certeza de que é isso que deseja fazer?",
}

load_game_window = {
  caption = "Carregar Jogo (%1%)",
  load_button = "Carregar",
}

tooltip.load_game_window = {
  load_game = "Carregar jogo %s",
  load_game_number = "Carregar jogo %d",
  load_autosave = "Carregar salvamento automático",
}

custom_game_window = {
  caption = "Jogo Personalizado",
  free_build = "Construçäo Livre",
  load_selected_level = "Iniciar",
}

tooltip.custom_game_window = {
  choose_game = "Clique em um nível para ver mais informaçäo sobre o mesmo.",
  free_build = "Marque esta opçäo se quiser jogar sem dinheiro nem condiçöes de vitória ou derrota.",
  load_selected_level = "Carregar e jogar o nível selecionado",
}

custom_campaign_window = {
  caption = "Campanha Personalizada",
  start_selected_campaign = "Iniciar Campanha",
}

tooltip.custom_campaign_window = {
  choose_campaign = "Selecione uma campanha para ver mais informaçäo sobre a mesma.",
  start_selected_campaign = "Carregar o primeiro nível desta campanha",
}

save_game_window = {
  caption = "Salvar Jogo (%1%)",
  new_save_game = "Novo jogo salvo",
  save_button = "Salvar",
  missing_filename = "Por favor, insira o nome do novo salvamento ou selecione o salvamento para sobrescrever.",
}

tooltip.save_game_window = {
  save_game = "Sobrescrever jogo salvo %s",
  new_save_game = "Insira o nome para um novo jogo salvo",
}

save_map_window = {
  caption = "Salvar Mapa (%1%)",
  new_map = "Novo Mapa",
  save_button = "Salvar",
  missing_filename = "Por favor, insira o nome do novo arquivo de mapa ou selecione o arquivo de mapa para sobrescrever.",
}

tooltip.save_map_window = {
  map = "Sobrescrever mapa %s",
  new_map = "Insira o nome para um novo jogo salvo do mapa",
}

load_map_window = {
  caption = "Carregar Mapa (%1%)",
  load_button = "Carregar",
}

menu_list_window = {
  name = "Nome",
  save_date = "Modificado",
  ok = "OK",
  back = "Voltar",
}

tooltip.menu_list_window = {
  name = "Clique aqui para ordenar a lista por nome",
  save_date = "Clique aqui para ordenar a lista pela data da última modificaçäo",
  ok = "Confirmar escolha",
  back = "Fechar esta janela",
}

options_window = {
  caption = "Configuraçöes",
  option_on = "Ligar",
  option_off = "Desligar",
  option_enabled = "Ativado",
  option_disabled = "Desativado",
  fullscreen = "Tela Cheia",
  resolution = "Resoluçäo",
  capture_mouse = "Capturar Mouse",
  right_mouse_scrolling = "Rolagem do Mouse",
  right_mouse_scrolling_option_middle = "Botäo do Meio",
  right_mouse_scrolling_option_right = "Botäo Direito",
  custom_resolution = "Personalizar...",
  width = "Largura",
  height = "Altura",
  audio = "Audio Geral",
  customise = "Personalizar",
  folder = "Pastas",
  language = "Idioma do Jogo",
  apply = "Aplicar",
  cancel = "Cancelar",
  back = "Voltar",
  scrollspeed = "Veloc. de Rolagem",
  shift_scrollspeed = "Veloc. Rolagem Acel.",
  zoom_speed = "Veloc. do Zoom",
  hotkey = "Atalhos",
  check_for_updates = "Verificar Atualizaçöes",
  jukebox = "Jukebox",
}

tooltip.options_window = {
  fullscreen = "Se o jogo deve ser executado em tela cheia ou modo janela",
  fullscreen_button = "Clique para mudar para tela cheia",
  resolution = "A resoluçäo que o jogo deve ser executado",
  select_resolution = "Selecionar uma nova resoluçäo",
  capture_mouse = "Clique para alternar a captura do cursor na janela do jogo",
  right_mouse_scrolling = "Alterne o botäo do mouse que é usado para rolar o mapa",
  width = "Insira a largura da tela desejada",
  height = "Insira a altura da tela desejada",
  apply = "Aplicar a resoluçäo inserida",
  cancel = "Retornar sem alterar a resoluçäo",
  audio_button = "Ligar ou desligar todo o áudio do jogo",
  audio_toggle = "Ativar ou desativar",
  customise_button = "Você pode alterar mais configuraçöes para personalizar sua experiência de jogo",
  folder_button = "Opçöes de pastas",
  language = "O idioma em que os textos do jogo apareceräo",
  select_language = "Selecione o idioma do jogo",
  language_dropdown_item = "Selecionar %s como idioma",
  language_dropdown_no_font = "Selecione uma fonte nas configuraçöes de pastas para ativar este idioma",
  back = "Fechar a janela de Configuraçöes",
  scrollspeed = "Defina a velocidade de rolagem entre 1 (mais lenta) até 10 (mais rápida). O padräo é 2.",
  shift_scrollspeed = "Defina a velocidade da rolagem enquanto a tecla Shift é pressionada. 1 (mais lento) até 10 (mais rápido). O padräo é 4.",
  zoom_speed = "Defina a velocidade da aproximaçäo da câmera de 10 (mais lenta) até 1000 (mais rápida). O padräo é 80.",
  apply_scrollspeed = "Aplique a velocidade de rolagem inserida.",
  cancel_scrollspeed = "Retornar sem alterar a velocidade de rolagem.",
  apply_shift_scrollspeed = "Aplique a velocidade de rolagem de acelerada inserida.",
  cancel_shift_scrollspeed = "Retorne sem alterar a velocidade de rolagem acelerada.",
  apply_zoomspeed = "Aplique a velocidade de aproximaçäo inserida.",
  cancel_zoomspeed = "Retorne sem alterar a velocidade de aproximaçäo.",
  hotkey = "Altere as teclas de atalho do teclado.",
  check_for_updates = "Define se o jogo deve procurar atualizaçöes ao iniciar.",
  jukebox = "Abrir a Jukebox para controlar a música",
}

customise_window = {
  caption = "Config. Personalizadas",
  option_on = "Ligado",
  option_off = "Desligado",
  back = "Voltar",
  movies = "Vídeo Geral",
  intro = "Vídeo de Introduçäo",
  paused = "Construir em Pausa",
  volume = "Tecla de Volume",
  aliens = "Pacientes Alienígenas",
  fractured_bones = "Fraturas Osseas",
  average_contents = "Conteúdos Habituais",
  remove_destroyed_rooms = "Remover salas destruídas",
}

tooltip.customise_window = {
  movies = "Controle geral de vídeos, que permitirá a você desativar todos os vídeos",
  intro = "Desligar ou ligar o vídeo de introduçäo, vídeos gerais precisaräo estar ligados se você quiser o vídeo de introduçäo rode quando você carregar o CorsixTH",
  paused = "No Theme Hospital o jogador só teria permissäo para utilizar o menu superior se o jogo estivesse pausado. Esta é também a configuraçäo padräo no CorsixTH, mas habilitando isso você tem permissäo para acessar tudo enquanto o jogo está pausado",
  volume = "Se a tecla de baixar volume abrir também a ficha clínica, utilize esta opçäo para mudar  o atalho para direto a ficha clínica para Shift + C.",
  aliens = "Devido à falta de animaçöes decentes disponíveis, fizemos com que os pacientes com DNA alienígena só apareçam em uma emergência. Para permitir que os pacientes com DNA alienígena possam visitar seu hospital, desative esta opçäo.",
  fractured_bones = "Devido a uma animaçäo deficiente, fizemos que näo existam pacientes com Fraturas ósseas femininas. Para permitir que as pacientes com Fraturas ósseas visitem seu hospital, desative esta opçäo.",
  average_contents = "Se você quiser que o jogo lembre que objetos extras você normalmente adiciona quando constrói salas, entäo ligue esta opçäo",
  remove_destroyed_rooms = "Se você gostaria de poder remover salas destruídas, mediante taxa, ative essa opçäo",
  back = "Fecha este menu e volta para o Menu de Configuraçöes",
}

folders_window = {
  caption = "Localizaçäo de Pastas",
  data_label = "Dados do TH",
  font_label = "Fonte",
  music_label = "Músicas",
  savegames_label = "Jogos Salvos",
  screenshots_label = "Capturas de Tela",
  -- next four are the captions for the browser window, which are called from the folder setting menu
  new_th_location = "Aqui pode especificar uma nova pasta de instalaçäo do Theme Hospital. O jogo será reiniciado assim que selecionar a nova pasta.",
  savegames_location = "Selecione a pasta que quer utilizar para seus jogos salvos.",
  music_location = "Selecione a pasta que quer utilizar para sua música.",
  screenshots_location = "Selecione a pasta que quer utilizar para suas capturas de tela.",
  back  = "Voltar",
}

tooltip.folders_window = {
  browse = "Procurar a localizaçäo da pasta",
  data_location = "A pasta com a instalaçäo do Theme Hospital original, necessário para executar o CorsixTH",
  font_location = "A localizaçäo de uma fonte de letra capaz de mostrar caracteres Unicode necessários para seu idioma. Se näo for indicado, näo poderá selecionar idiomas que tenham mais caracteres dos que o jogo original tem, por exemplo, russo e chinês.",
  savegames_location = "A pasta de jogos salvos é localizada por padräo junto com o arquivo de configuraçäo e é utilizado para armazenar os jogos salvo. Se você näo gostar, pode selecionar outra procurando a pasta que quiser usar.",
  screenshots_location = "As capturas de tela säo guardadas por padräo em uma pasta junto com o arquivo de configuraçäo. Se você näo gostar, pode selecionar outra procurando a pasta que quiser usar.",
  music_location = "Selecione uma pasta com seus arquivos de música. Necessita de uma pasta já existente, entäo poderá procurá-la.",
  browse_data = "Procurar outra localizaçäo com uma instalaçäo do Theme Hospital. (Localizaçäo atual: %1%)",
  browse_font = "Procurar outro arquivo de fonte de letra. (Localizaçäo atual: %1%)",
  browse_saves = "Procurar outra localizaçäo para sua pasta de jogos salvos. (Localizaçäo atual: %1%) ",
  browse_screenshots = "Procurar outra localizaçäo para sua pasta de capturas de tela. (Localizaçäo atual: %1%) ",
  browse_music = "Procurar outra localizaçäo para sua pasta de música. (Localizaçäo atual: %1%) ",
  no_font_specified = "Pasta de fontes näo especificada!",
  not_specified = "Pasta näo especificada!",
  default = "Localizaçäo padräo",
  reset_to_default = "Volta a atribuir a pasta a sua localizaçäo padräo",
  back  = "Fechar este menu e voltar para o menu de Configuraçöes",
}

hotkey_window = {
  caption_main = "Atribuiçäo de teclas de atalho",
  caption_panels = "Teclas do painel",
  button_accept = "Aceitar",
  button_defaults = "Restaurar padröes",
  button_cancel = "Cancelar",
  button_back = "Voltar",
  button_toggleKeys = "Teclas de alternância",
  button_gameSpeedKeys = "Teclas de velocidade do jogo",
  button_recallPosKeys = "Tecla de retorno de posiçäo",
  panel_globalKeys = "Teclas globais",
  panel_generalInGameKeys = "Teclas gerais no jogo",
  panel_scrollKeys = "Teclas de rolagem",
  panel_zoomKeys = "Teclas de aproximaçäo",
  panel_gameSpeedKeys = "Teclas de velocidade do jogo",
  panel_toggleKeys = "Teclas de alternância",
  panel_debugKeys = "Teclas de depuraçäo",
  panel_storePosKey = "Armazenamento de posiçäo",
  panel_recallPosKeys = "Retorno de posiçäo",
  panel_altPanelKeys = "Teclas de alternância do painel",
  global_confirm = "Confirmar",
  global_confirm_alt = "Alt. confirmar",
  global_cancel = "Cancelar",
  global_cancel_alt = "Alt. cancelar",
  global_fullscreen_toggle = "Tela cheia",
  global_exitApp = "Sair do app",
  global_resetApp = "Reiniciar app",
  global_releaseMouse = "Liberar mouse",
  global_connectDebugger = "Depurar",
  global_showLuaConsole = "Console Lua",
  global_runDebugScript = "Script de depuraçäo",
  global_screenshot = "Capturar tela",
  global_stop_movie_alt = "Parar filme",
  global_window_close_alt = "Fechar janela",
  ingame_scroll_up = "Rolar p/ cima",
  ingame_scroll_down = "Rolar p/ baixo",
  ingame_scroll_left = "Rolar p/ esq.",
  ingame_scroll_right = "Rolar p/ dir.",
  ingame_scroll_shift = "Veloc. aceler.",
  ingame_zoom_in = "Aproximar",
  ingame_zoom_in_more = "Aproximar mais",
  ingame_zoom_out = "Afastar",
  ingame_zoom_out_more = "Afastar mais",
  ingame_reset_zoom = "Redefinir zoom",
  ingame_showmenubar = "Barra de menu",
  ingame_showCheatWindow = "Menu de trapaça",
  ingame_loadMenu = "Carregar jogo",
  ingame_saveMenu = "Salvar jogo",
  ingame_jukebox = "Jukebox",
  ingame_openFirstMessage = "Nív. mensagem",
  ingame_pause = "Pausa",
  ingame_gamespeed_slowest = "Muito lento",
  ingame_gamespeed_slower = "Lento",
  ingame_gamespeed_normal = "Normal",
  ingame_gamespeed_max = "Rápido",
  ingame_gamespeed_thensome = "Muito rápido",
  ingame_gamespeed_speedup = "Acelerar",
  ingame_panel_bankManager = "Ger. do banco",
  ingame_panel_bankStats = "Estado da conta",
  ingame_panel_staffManage = "Lista de funcion.",
  ingame_panel_townMap = "Mapa da cidade",
  ingame_panel_casebook = "Ficha clinica",
  ingame_panel_research = "Pesquisa",
  ingame_panel_status = "Estado",
  ingame_panel_charts = "Gráfico",
  ingame_panel_policy = "Normas",
  ingame_panel_map_alt = "Mapa da cidade 2",
  ingame_panel_research_alt = "Pesquisa 2",
  ingame_panel_casebook_alt = "Ficha clinica 2",
  ingame_panel_casebook_alt02 = "Ficha clinica 3",
  ingame_panel_buildRoom = "Construir sala",
  ingame_panel_furnishCorridor = "Mobiliar corredor",
  ingame_panel_editRoom = "Editar sala",
  ingame_panel_hireStaff = "Contratar",
  ingame_rotateobject = "Girar objeto",
  ingame_quickSave = "Salvar rapid.",
  ingame_quickLoad = "Carregar rapid.",
  ingame_restartLevel = "Reiniciar nível",
  ingame_quitLevel = "Sair do nível",
  ingame_setTransparent = "Transparente",
  ingame_toggleAnnouncements = "Anúncios",
  ingame_toggleSounds = "Sons",
  ingame_toggleMusic = "Música",
  ingame_toggleAdvisor = "Conselheiro",
  ingame_toggleInfo = "Informaçöes",
  ingame_poopLog = "Relatório de erros",
  ingame_poopStrings = "Extrair textos",
  ingame_patient_gohome = "Enviar p/ casa",
  ingame_storePosition_1 = "1",
  ingame_storePosition_2 = "2",
  ingame_storePosition_3 = "3",
  ingame_storePosition_4 = "4",
  ingame_storePosition_5 = "5",
  ingame_storePosition_6 = "6",
  ingame_storePosition_7 = "7",
  ingame_storePosition_8 = "8",
  ingame_storePosition_9 = "9",
  ingame_storePosition_0 = "10",
  ingame_recallPosition_1 = "1",
  ingame_recallPosition_2 = "2",
  ingame_recallPosition_3 = "3",
  ingame_recallPosition_4 = "4",
  ingame_recallPosition_5 = "5",
  ingame_recallPosition_6 = "6",
  ingame_recallPosition_7 = "7",
  ingame_recallPosition_8 = "8",
  ingame_recallPosition_9 = "9",
  ingame_recallPosition_0 = "10",
}

tooltip.hotkey_window = {
  button_accept = "Aceitar e salvar atribuiçöes de teclas de atalho",
  button_defaults = "Restaura todas as teclas de atalho para os padröes do programa",
  button_cancel = "Cancela a atribuiçäo e volta ao menu de opçöes",
  caption_panels = "Abre a janela para atribuir teclas do painel",
  button_gameSpeedKeys = "Abre a janela para definir teclas para controlar a velocidade do jogo",
  button_recallPosKeys = "Abre a janela para definir teclas para armazenamento e retorno da posiçöes da câmera",
  button_back_02 = "Volta para a janela principal de teclas de atalho. As teclas de atalho alteradas nesta janela podem ser aceitas lá",
}

font_location_window = {
  caption = "Selecionar fonte (%1%)",
}

handyman_window = {
  all_parcels = "Todos os terrenos",
  parcel = "Terreno"
}

tooltip.handyman_window = {
  parcel_select = "O terreno onde o zelador aceita tarefas, clique para alterar a configuraçäo"
}

new_game_window = {
  caption = "Campanha",
  player_name = "Nome",
  option_on = "Ligado",
  option_off = "Desligado",
  difficulty = "Dificuldade",
  easy = "Residente (Fácil)",
  medium = "Médico (Normal)",
  hard = "Consultor (Difícil)",
  tutorial = "Tutorial",
  start = "Iniciar",
  cancel = "Cancelar",
}

tooltip.new_game_window = {
  player_name = "Digite o nome que você deseja ser chamado no jogo",
  difficulty = "Selecione o nível de dificuldade do jogo",
  easy = "Se você näo conhecer jogos de simulaçäo, esta dificuldade é para você.",
  medium = "Esta é a dificuldade intermediária, se você está inseguro do que deve escolher.",
  hard = "Se você está acostumado com este tipo de jogo e quer um bom desafio, escolha esta opçäo",
  tutorial = "Se você precisa de ajuda para começar a jogar, escolha esta opçäo",
  start = "Iniciar o jogo com a configuraçäo selecionada",
  cancel = "Ah, eu näo queria começar um novo jogo!",
}

lua_console = {
  execute_code = "Executar",
  close = "Fechar",
}

tooltip.lua_console = {
  textbox = "Digite aqui o código Lua que deseja executar",
  execute_code = "Executar o código Lua que digitou",
  close = "Fechar o console",
}

errors = {
  dialog_missing_graphics = "Desculpe, os arquivos de dados da versäo de demonstraçäo näo contém este diálogo.",
  save_prefix = "Erro ao salvar o jogo: ",
  load_prefix = "Erro ao carregar o jogo: ",
  load_map_prefix = "Erro ao carregar o mapa: ",
  load_level_prefix = "Erro ao carregar o nível: ",
  no_games_to_contine = "Näo há jogos salvos.",
  load_quick_save = "Erro, näo foi possível carregar o carregamento rápido já que ele näo existe, näo se preocupe nós criamos um agora para você!",
  map_file_missing = "Näo foi possível encontrar o arquivo de mapa %s para esta fase!",
  minimum_screen_size = "Por favor, insira um tamanho de tela de pelo menos 640x480.",
  unavailable_screen_size = "O tamanho da tela que você digitou näo está disponível em tela cheia.",
  alien_dna = "NOTA: Os pacientes alienígenas näo têm animaçöes para se sentar, abrir portas, bater nas portas, etc. portanto, assim como no Theme Hospital original, ao fazer estas coisas aparentaräo mudar para uma imagem normal e logo voltaräo para o seu estado.  Os pacientes com DNA alienígena só apareceräo se o arquivo de fase o indicar",
  fractured_bones = "NOTA: A animaçäo das pacientes femininas com Fraturas ósseas näo é perfeita",
  could_not_load_campaign = "Falha ao carregar a campanha: %s",
  could_not_find_first_campaign_level = "Näo foi possível encontrar o primeiro nível desta campanha: %s",
  save_to_tmp = "O arquivo em %s näo pôde ser usado. O jogo foi salvo em %s. Erro: %s",
  dialog_empty_queue = "Desculpe, um humanoide acabou de ter uma fila de açöes vazia, o que significa que ele näo sabia o que fazer a seguir. Consulte a janela de comandos para mais informaçöes detalhadas. Um diálogo com o humanoide ofensivo foi aberto. Gostaria que ele saísse do hospital?",
  compatibility_error = {
    new_in_old = "Desculpe, este salvamento foi criado com uma versäo mais recente do CorsixTH e näo é compatível. Por favor, atualize para uma versäo mais recente.",
    demo_in_full = "Desculpe, você näo pode abrir um salvamento de demonstraçäo com os arquivos do jogo completo carregados. Por favor, atualize sua configuraçäo da pasta de dados do TH.",
    full_in_demo = "Desculpe, você näo pode abrir um salvamento do jogo completo com os arquivos de demonstraçäo carregados. Por favor, atualize sua configuraçäo da pasta de dados do TH.",
  },
  music = "Há problemas de reproduçäo com um ou mais arquivos em seu diretório de música. Arquivos problemáticos seräo desativados no jukebox. Veja a janela do console para mais informaçöes.",
}

warnings = {
  levelfile_variable_is_deprecated = "Aviso: O nível '%s ' contém uma definiçäo variável obsoleta no arquivo de nível." ..
                                     " '%LevelFile' foi renomeado para '%MapFile '. Por favor, informe ao criador do mapa para atualizar o nível.",
  newersave = "Aviso, você carregou um salvamento de uma versäo mais recente do CorsixTH. Näo é recomendável continuar, pois podem ocorrer falhas. Jogue por sua conta e risco."
}

confirmation = {
  needs_restart = "Para alterar esta configuraçäo é necessário reiniciar o CorsixTH. Qualquer alteraçäo näo salva será perdida. Tem certeza que deseja fazer isso?",
  abort_edit_room = "Você está editando uma sala. Se todos os objetos necessários estiverem colocados ela será completada, caso contrário ela será removida. Continuar?",
  maximum_screen_size = "O tamanho de tela que digitou é maior que 3000 x 2000.  É possível utilizar uma resoluçäo maior, mas necessitará de um computador melhor para que a velocidade de quadros por segundo seja aceitável. Tem certeza de que quer continuar?",
  remove_destroyed_room = "Gostaria de remover a sala por $%d?",
  replace_machine_extra_info = "A nova máquina terá %d de força (atualmente %d).",
  restart_mapeditor = "Tem certeza de que deseja reiniciar o editor de mapas?",
  quit_mapeditor = "Tem certeza de que deseja sair do editor de mapas?",
}

information = {
  custom_game = "Bem-vindo ao CorsixTH. Divirta-se com esse mapa personalizado!",
  no_custom_game_in_demo = "Desculpe, mas a versäo de demonstraçäo näo pode jogar mapas personalizados.",
  cannot_restart = "Infelizmente este mapa personalizado foi salvo antes que a funcionalidade de reiniciaçäo fosse implementada.",
  very_old_save = "Houveram muitas mudanças no jogo desde que você começou a jogar este mapa. Para ter certeza que todas as funcionalidades estäo funcionando considere recomeçar o mapa.",
  level_lost = {
    "Que pena! Você fracassou. Mais sorte na próxima vez!",
    "Você perdeu porque:",
    reputation = "Sua reputaçäo caiu abaixo de %d.",
    balance = "Seu saldo bancário caiu abaixo de %d.",
    percentage_killed = "Você matou mais de %d por cento dos pacientes.",
    cheat = "Foi escolha sua ou você se enganou de botäo? Näo sabe nem trapacear direito?",
  },
  cheat_not_possible = "Näo pode usar essa trapaça nesta fase. Näo sabe nem trapacear direito?",
}

tooltip.information = {
  close = "Fechar a janela de informaçäo",
}

totd_window = {
  tips = {
  "Todo hospital precisa de uma Recepçäo e um Consultório Geral para começar. Depois disso, dependerá do tipo de pacientes que visitará seu hospital. Entretanto ter uma farmácia é sempre uma boa ideia.",
  "Máquinas como o Inflador precisam de constante manutençäo. Contrate um ou dois Zeladores para reparos nestas máquinas, ou colocará seus funcionários e pacientes em risco.",
  "Depois de um certo período de trabalho, seus funcionários ficaräo cansados. Certifique-se de construir uma Sala de Descanso, para que posam relaxar.",
  "Instale Radiadores suficientes para manter seus funcionários e pacientes aquecidos, do contrário ficaräo infelizes. Use o Mapa da Cidade para localizar pontos do hospital que precisem ser aquecidos.",
  "O nível de habilidade de um médico reflete na qualidade e velocidade dos diagnósticos. Coloque um médico experiente no Consultório Geral, assim näo precisará de muitas salas de diagnósticos adicionais.",
  "Médicos de níveis 'Residente' e 'Médico' podem melhorar suas habilidades aprendendo com um Consultor na Sala de Treinamento. Se o Consultor possuir alguma especializaçäo (Cirurgiäo, Psiquiatra ou Pesquisador), ele irá passar este conhecimento aos seus alunos.",
  "Você já tentou digitar o número europeu de emergência (112) no aparelho de fax? Certifique-se que o seu som esteja ligado!",
  "Você pode alterar algumas configuraçöes como a resoluçäo da tela e o idioma na janela de opçöes que pode ser acessar no menu inicial e dentro do jogo.",
  "Você selecionou um idioma que näo é o inglês, mas continua vendo textos em inglês por todos os lugares? Ajude-nos a traduzir os textos restantes para o seu idioma!",
  "A comunidade do CorsixTH está precisando de reforços em sua equipe! Você está interessado em codificar, traduzir ou criar gráficos para o CorsixTH? Entre em contato conosco pelo nosso Fórum, Lista de Discussäo ou canal de IRC (#corsix-th no freenode).",
  "Se localizar um bug, por favor reporte-o em nosso rastreador de erros: th-issues.corsix.org",
  "Cada fase possui certas metas a serem atingidas antes de passar para a próxima fase. Cheque a janela de situaçäo para acompanhar seu progresso a fim de atingir seus objetivos.",
  "Se você deseja editar ou remover uma sala existente, pode fazê-lo com o botäo de ediçäo de sala na barra inferior.",
  "Caso haja uma multidäo de pacientes esperando, você deve descobrir rapidamente quais deles estäo aguardando por uma sala em particular passando o ponteiro do mouse por cima desta sala.",
  "Clique nas portas das salas para ver sua fila. Isso pode ser muito útil, já que pode reordenar a fila ou encaminhar um paciente para outra sala.",
  "Funcionários infelizes iräo pedir aumentos de salários com mais frequência. Certifique-se que sua equipe esteja trabalho em um ambiente de trabalho confortável para mantê-los felizes.",
  "Pacientes podem ficar com sede enquanto esperam em seu hospital, ainda mais se ligar o aquecimento! Instale máquinas de venda de refrigerantes em pontos estratégicos para um ganho extra.",
  "Você pode abortar o processo de diagnóstico prematuramente e pressupor a cura, se você já tiver descoberto a doença. Atente-se que desta maneira aumenta-se o risco de um tratamento errado, resultando na morte do paciente.",
  "Emergências podem ser uma boa fonte de grana extra, desde que você possua plena capacidade e recursos de lidar com os pacientes à tempo.",
  "Você sabia que pode atribuir Faz-Tudo a terrenos específicos? Basta clicar no texto Todos os Terrenos em seu perfil de funcionário para alternar entre eles!",
  },
  previous = "Dica anterior",
  next = "Próxima dica",
}

tooltip.totd_window = {
  previous = "Mostra a dica anterior",
  next = "Mostra a próxima dica",
}

debug_patient_window = {
  caption = "Depurar Paciente",
}

tooltip.debug_patient_window = {
  item = "Criar um paciente de depuraçäo com %s",
}

cheats_window = {
  caption = "Trapaças",
  warning = "Atençäo: Você näo conseguirá quaisquer pontos de bonificaçöes no fim do nível se você trapacear!",
  cheated = {
    no = "Trapaças usadas: Näo",
    yes = "Trapaças usadas: Sim",
  },
  cheats = {
    money = "Trapaça de Dinheiro",
    all_research = "Trapaça Todas as Pesquisas Realizadas",
    emergency = "Criar Emergência",
    vip = "Criar VIP",
    toggle_earthquake = "Alternar terremotos",
    earthquake = "Criar Terremoto",
    toggle_epidemic = "Alternar epidemias",
    epidemic = "Gerar um paciente contagioso",
    show_infected = "Mostrar ou ocultar ícones de infectados",
    create_patient = "Criar Paciente",
    end_month = "Fim do Mês",
    end_year = "Fim do ano",
    lose_level = "Perder a Fase",
    win_level = "Ganhar a Fase",
    increase_prices = "Aumentar Preços",
    decrease_prices = "Reduzir Preços",
    reset_death_count = "Redefinir contagem de mortes",
    max_reputation = "Reputaçäo Máxima",
  },
  close = "Fechar",
}

tooltip.cheats_window = {
  close = "Fechar o diálogo de trapaças",
  cheats = {
    money = "Adiciona $10.000 ao seu saldo bancário",
    all_research = "Completa todas as pesquisas.",
    emergency = "Cria uma emergência.",
    vip = "Cria um visitante VIP.",
    toggle_earthquake = "Alternar terremotos",
    earthquake = "Cria um Terremoto.",
    toggle_epidemic = "Alternar se epidemias podem acontecer",
    epidemic = "Cria um paciente contagioso",
    toggle_infected = "Mostra/oculta os ícones de infecçäo",
    create_patient = "Cria um Paciente no canto de mapa.",
    end_month = "Pula para o final do mês.",
    end_year = "Pula para o final do ano.",
    lose_level = "Perde esta fase.",
    win_level = "Ganha esta fase.",
    increase_prices = "Aumenta todos os preços em 50% (200% máximo).",
    decrease_prices = "Reduz todos os preços em 50% (50% mínimo).",
    reset_death_count = "Redefinir a contagem de mortes do hospital para zero",
    max_reputation = "Definir a reputaçäo do hospital para o máximo",
  }
}

-- Level description, can be double spaced after full-stop
introduction_texts = {
  demo =
    "Bem-vindo ao hospital de demonstraçäo!//" ..
    "Infelizmente esta versäo de demonstraçäo só possui esta fase. Entretanto, teremos aqui o suficiente para mantê-lo ocupado por enquanto! " ..
    "Você encontrará várias doenças que necessitaräo de salas diferentes para cura. De tempos em tempos, emergências ocorreräo. E você precisará pesquisar por salas adicionais usando o Centro de Pesquisas. " ..
    "Seu objetivo é ter um saldo bancário de $100.000,00, o valor do hospital em $ 70.000,00 e uma reputaçäo de 700, enquanto você cura pelo menos 75% de seus pacientes. " ..
    "Certifique-se que sua reputaçäo näo fique abaixo de 300 e você näo mate mais de 40% dos seus pacientes, senäo você perde.//" ..
    "Boa sorte!",
}

calls_dispatcher = {
  -- Dispatcher description message. Visible in Calls Dispatcher dialog
  summary = "%d chamadas; %d atribuídas",
  staff = "%s - %s",
  watering = "Regando @ %d,%d",
  repair = "Reparar %s",
  close = "Fechar",
}

tooltip.calls_dispatcher = {
  task = "Lista de tarefas - clique na tarefa para abrir a janela do funcionário responsável e ir para o local da tarefa.",
  assigned = "Esta janela será marcada se alguém for designado para a tarefa correspondente.",
  close = "Fechar a janela de chamadas de controle",
}

update_window = {
  caption = "Atualizaçäo Disponível!",
  new_version = "Nova Versäo:",
  current_version = "Versäo Atual:",
  download = "Ir para página de download",
  ignore = "Pular e ir para o menu principal",
}

tooltip.update_window = {
  download = "Vai para a página de downloads para obter a última versäo do CorsixTH",
  ignore = "Ignora esta atualizaçäo no momento. Você será notificado da próxima vez que abrir o CorsixTH",
}

map_editor_window = {
  pages = {
    inside = "Interno",
    outside = "Externo",
    foliage = "Folhagem",
    hedgerow = "Cerca viva",
    pond = "Lago",
    road = "Estrada",
    north_wall = "Parede Norte",
    west_wall = "Parede Oeste",
    helipad = "Heliponto",
    set_parcel = "Definir número do terreno",
    delete_wall = "Excluir paredes",
    parcel = "Terreno %d",
    set_parcel_tooltip = "Escolha um número e pressione Enter.",
    camera_1 = "Câmera 1",
    camera_2 = "Câmera 2",
    camera_3 = "Câmera 3",
    camera_4 = "Câmera 4",
    heliport_1 = "Heliporto 1",
    heliport_2 = "Heliporto 2",
    heliport_3 = "Heliporto 3",
    heliport_4 = "Heliporto 4",
    paste = "Colar área",
  },
  checks = {
    spawn_points_and_path = "Aviso: Pacientes näo conseguem chegar ao hospital. Eles precisam de ladrilhos 'estrada' ou 'externo' cinza na borda do mapa e um caminho desses ladrilhos até a entrada do hospital.",
  },
}

hotkeys_file_err = {
  file_err_01 = "Näo foi possível carregar o arquivo hotkeys.txt. Certifique-se de que o " ..
        "CorsixTH tenha permissäo de leitura/escrita ",
  file_err_02 = ", ou use a opçäo linha de comando --hotkeys-file=nome_do_arquivo para especificar um arquivo gravável. " ..
        "Para referência, o erro ao carregar o arquivo de teclas de atalho foi: ",
}

fax = {
  vip_visit_result = {
    remarks = {
      [1] = "Que hospital eficiente! Da próxima vez que eu estiver gravemente doente, vou querer ser tratado aqui.",
      [2] = "Isso sim é o que eu chamo de um hospital.",
      [3] = "Este hospital é excelente. E eu sei do que estou falando; visito muitos hospitais.",
      [4] = "Que hospital bem administrado! Obrigado pelo convite.",
      [5] = "Mmmm. Definitivamente näo é uma má instituiçäo médica.",
      [6] = "Gostei muito do seu excelente hospital. Agora, alguém aí quer um curry da Casa do Curry?",
      [7] = "Bem, já vi piores. Mas você deveria fazer algumas melhorias.",
      [8] = "Oh céus! Isso näo é um lugar agradável para se estar quando se está doente.",
      [9] = "Para ser honesto, é um hospital mediano. Francamente, eu esperava mais.",
      [10] = "Por que me zanguei? Isso foi pior que assistir a uma ópera de quatro horas!",
      [11] = "Estou decepcionado com o que vi. Você chama isso de hospital? Parece mais uma pocilga!",
      [12] = "Estou farto de atrair atençäo pública e visitar buracos fedorentos como este! Eu me demito.",
      [13] = "Que lixo. Vou tentar fechá-lo.",
      [14] = "Eu nunca vi um hospital täo ruim. Que vergonha!",
      [15] = "Estou chocado. Isso näo pode ser chamado de hospital! Näo conte comigo para voltar aqui.",
    }
  }
}

transactions.remove_room = "Construir: Remover sala destruída"
--------------------------------  UNUSED  -----------------------------------
------------------- (kept for backwards compatibility) ----------------------

options_window.change_resolution = "Alterar resoluçäo"
tooltip.options_window.change_resolution = "Altera a resoluçäo de janela para as dimensöes digitadas na esquerda"

--------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------  MISSING STRINGS IN LANGUAGE "PORTUGUêS DO BRASIL":  -----------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------
rooms_long.ward = "Sala de Enfermaria"
rooms_long.blood_machine = "Sala de Transfusöes"
rooms_long.emergency = "Sala de Emergências"
rooms_long.general = "Diagnóstico Geral"
rooms_long.cardiogram = "Sala de Cardiograma"
rooms_long.decontamination = "Sala de Descontaminaçäo"
rooms_long.jelly_vat = "Banho Gelatinoso"
rooms_long.staffroom = "Sala de Descanso"
rooms_long.hair_restoration = "Sala de Peloterapia"
rooms_long.inflation = "Sala de Inflatoterapia"
rooms_long.operating_theatre = "Sala de Cirurgia"
rooms_long.gps_office = "Consultório de Clínica Geral"
rooms_long.training_room = "Sala de Formaçäo"
rooms_long.x_ray = "Sala de Raio-X"
rooms_long.tongue_clinic = "Sala de Laringologia"
rooms_long.psychiatric = "Sala de Psiquiatria"
rooms_long.corridors = "Corredores"
rooms_long.ultrascan = "Sala de Ultra Scanner"
rooms_long.dna_fixer = "Sala de Genética"
rooms_long.toilets = "Banheiro"
rooms_long.fracture_clinic = "Sala de Traumatologia"
rooms_long.pharmacy = "Farmácia"
rooms_long.general_diag = "Diagnóstico Geral"
rooms_long.research_room = "Centro de Pesquisa"
rooms_long.scanner = "Sala de Scanner"
rooms_long.electrolysis = "Sala de Eletrólise"
fax.debug_fax.text4 = "FACTORS  : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d"
fax.debug_fax.text2 = "TOTAL PEOPLE IN HOSPITAL %d CHECKING AGAINST %d"
fax.debug_fax.text9 = "DISASTERS %d ALLOWED (MTHS) %d (%d)REDUCTION %d"
fax.debug_fax.text3 = "FIGURES  : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d"
fax.debug_fax.close_text = "Sim, sim, sim!"
fax.debug_fax.text5 = "CONTRIBN : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d PERCENT"
fax.debug_fax.text1 = "BEST COUNT %d"
fax.debug_fax.text8 = "AMENITIES %d PEEPS HANDLED %d REDUCTION %d"
fax.debug_fax.text10 = "KILLS %d ALLOWED (MTHS) %d (%d) REDUCTION %d"
fax.debug_fax.text7 = "REPUTATION: %d EXPECTED %d REDUCTION %d"
fax.debug_fax.text11 = "PEOPLE THIS MONTH %d"
fax.debug_fax.text6 = "THE FOLLOWING FACTORS ARE ALSO APPLIED"
fax.emergency.choices.accept = "Sim, preparado para enfrentar esta emergência."
fax.emergency.choices.refuse = "Näo. Recuso-me a enfrentar esta emergência."
fax.emergency.cure_possible_drug_name_efficiency = "Já dispöe da equipe e do pessoal qualificado. Tem o medicamento necessário. É %s e tem uma efetividade de %d por cento."
fax.emergency.bonus = "Você ganhará um bônus máximo de $%d por cuidar desta emergência. Mas, se fracassar, sua reputaçäo será seriamente danificada."
fax.emergency.locations[1] = "Planta Química Thatcher"
fax.emergency.locations[2] = "Universidade Suja"
fax.emergency.locations[3] = "Centro de Plantas Aquáticas"
fax.emergency.locations[4] = "Instituto de Pesquisa de Substâncias Perigosas"
fax.emergency.locations[5] = "Congresso de Bailarinos Russos"
fax.emergency.locations[6] = "Pub O Touro e A Rä"
fax.emergency.locations[7] = "Funerária Sem Licença Para Boa Morte"
fax.emergency.locations[8] = "A Casa do Curry"
fax.emergency.locations[9] = "Empório Petroquímico Usado"
fax.emergency.cure_not_possible_employ = "Precisará contratar um(a) %s"
fax.emergency.location = "Houve um incidente em %s"
fax.emergency.cure_possible = "Tem a equipe e o pessoal qualificado necessários, poderá enfrentar esta emergência."
fax.emergency.cure_not_possible = "Näo pode curar esta doença no momento."
fax.epidemic.cover_up_explanation_2 = "Se um Inspetor de Saúde visitar e encontrar uma epidemia encoberta, tomará medidas drásticas contra você."
fax.epidemic.choices.cover_up = "Tentar ocultá-la. Buscar curar a epidemia antes que se espalhe por todo o país."
fax.epidemic.choices.declare = "Há uma epidemia"
fax.epidemic.disease_name = "Seus médicos descobriram uma variedade contagiosa de %s."
fax.epidemic.declare_explanation_fine = "Se declarar uma epidemia, pagará uma multa de %d, danificando sua reputaçäo e seus pacientes seräo automaticamente vacinados."
fax.epidemic.cover_up_explanation_1 = "Se tentar encobri-la, terá um tempo limitado para curar todos os infectados antes que as autoridades de saúde descubram."
fax.vip_visit_result.close_text = "Obrigado por visitar o hospital."
fax.vip_visit_result.telegram = "Telegrama!"
fax.vip_visit_result.vip_remarked_name = "Depois de visitar o seu hospital, %s declarou:"
fax.vip_visit_result.cash_grant = "Você ganhou um prêmio em dinheiro de $%d."
fax.vip_visit_result.rep_boost = "Sua reputaçäo na comunidade acaba de aumentar."
fax.vip_visit_result.rep_loss = "Sua reputaçäo foi afetada em consequência"
fax.disease_discovered.close_text = "Foi encontrada uma nova doença."
fax.disease_discovered.need_to_build = "Precisa construir um(a) %s para tratar isto."
fax.disease_discovered.can_cure = "Pode tratar esta doença."
fax.disease_discovered.need_to_employ = "Contrate um(a) %s que possa solucionar este problema."
fax.disease_discovered.need_to_build_and_employ = "Se construir uma %s e contratar um(a) %s, pode ter êxito."
fax.disease_discovered.discovered_name = "Sua equipe descobriu uma nova doença. É %s."
fax.epidemic_result.close_text = "Bem!"
fax.epidemic_result.compensation_amount = "O Governo decidiu lhe dar uma compensaçäo de %d pelos danos que este incidente causou ao bom nome do seu hospital."
fax.epidemic_result.succeeded.part_1_name = "Chegou aos ouvidos do Inspetor de Saúde que na sua instituiçäo estava tratando um caso maligno de %s."
fax.epidemic_result.succeeded.part_2 = "Embora näo fosse possível encontrar provas que comprovassem os ditos rumores..."
fax.epidemic_result.hospital_evacuated = "O Ministério da Saúde näo tem outra alternativa senäo evacuar o seu hospital."
fax.epidemic_result.failed.part_1_name = "Ao tentar esconder o fato de que enfrentavam um surto contagioso de %s"
fax.epidemic_result.failed.part_2 = "Os funcionários do seu hospital säo responsáveis pela doença que se propagou entre as pessoas que vivem perto do seu hospital."
fax.epidemic_result.fine_amount = "O Governo declarou uma emergência nacional e multou-o em %d."
fax.epidemic_result.rep_loss_fine_amount = "Os jornais têm feito um escândalo com isso. Sua reputaçäo será gravemente afetada. Além disso, imporá uma multa de %d."
fax.emergency_result.close_text = "Aperte para sair"
fax.emergency_result.saved_people = "Salvou %d pessoas de um total de %d."
fax.emergency_result.earned_money = "Ganhou %d, de um bônus máximo de %d."
fax.vip_visit_query.vip_name = "%s expressou o desejo de visitar o seu hospital."
fax.vip_visit_query.choices.refuse = "Dispensar o V.I.P."
fax.vip_visit_query.choices.invite = "Enviar um convite oficial ao V.I.P."
fax.diagnosis_failed.what_to_do_question = "O que vamos fazer com o paciente?"
fax.diagnosis_failed.choices.send_home = "Enviar o paciente para casa."
fax.diagnosis_failed.choices.take_chance = "Tentar uma possível cura."
fax.diagnosis_failed.choices.wait = "Fazer o paciente esperar enquanto constrói mais salas de diagnóstico."
fax.diagnosis_failed.partial_diagnosis_percentage_name = "Existe %d por cento de chances de descobrirmos que tipo de %s o paciente está sofrendo."
fax.diagnosis_failed.situation = "Fizemos todos os nossos diagnósticos com este paciente e näo estamos seguros do que se trata."
fax.disease_discovered_patient_choice.what_to_do_question = "O que você quer fazer com o paciente?"
fax.disease_discovered_patient_choice.choices.send_home = "Enviar o paciente para casa."
fax.disease_discovered_patient_choice.choices.research = "Enviar o paciente para Pesquisa."
fax.disease_discovered_patient_choice.choices.wait = "Faça o paciente esperar um momento no hospital."
fax.disease_discovered_patient_choice.can_not_cure = "Näo pode curar esta doença."
fax.disease_discovered_patient_choice.need_to_employ = "Contrate um(a) %s para corrigir esta situaçäo."
fax.disease_discovered_patient_choice.need_to_build = "Precisa construir um(a) %s para poder tratar isso."
fax.disease_discovered_patient_choice.need_to_build_and_employ = "Pode conseguir se construir um(a) %s e contratar um(a) %s."
fax.disease_discovered_patient_choice.guessed_percentage_name = "Sua equipe tem que averiguar o que tem um paciente. Há %d por cento de chance de que seja %s."
fax.disease_discovered_patient_choice.disease_name = "Sua equipe descobriu uma nova doença. É %s."
original_credits[1] = " "
original_credits[2] = " "
original_credits[3] = " "
original_credits[4] = " "
original_credits[5] = " "
original_credits[6] = " "
original_credits[7] = " "
original_credits[8] = " "
original_credits[9] = " "
original_credits[10] = " "
original_credits[11] = " "
original_credits[12] = ":Desenvolvido e criado pela"
original_credits[13] = ":Bullfrog Productions"
original_credits[14] = " "
original_credits[15] = ":Equipe de Desenvolvimento Pluto"
original_credits[16] = ","
original_credits[17] = "Mark Webley"
original_credits[18] = "Gary Carr"
original_credits[19] = "Matt Chilton"
original_credits[20] = "Matt Sullivan"
original_credits[21] = "Jo Rider"
original_credits[22] = "Rajan Tande"
original_credits[23] = "Wayne Imlach"
original_credits[24] = "Andy Bass"
original_credits[25] = "Jon Rennie"
original_credits[26] = "Adam Coglan"
original_credits[27] = "Natalie White"
original_credits[28] = " "
original_credits[29] = " "
original_credits[30] = " "
original_credits[31] = ":Programaçäo"
original_credits[32] = ","
original_credits[33] = "Mark Webley"
original_credits[34] = "Matt Chilton"
original_credits[35] = "Matt Sullivan"
original_credits[36] = "Rajan Tande"
original_credits[37] = " "
original_credits[38] = "Ben Deane"
original_credits[39] = "Gary Morgan"
original_credits[40] = "Jonty Barnes"
original_credits[41] = " "
original_credits[42] = " "
original_credits[43] = " "
original_credits[44] = ":Arte"
original_credits[45] = ","
original_credits[46] = "Gary Carr"
original_credits[47] = "Jo Rider"
original_credits[48] = "Andy Bass"
original_credits[49] = "Adam Coglan"
original_credits[50] = " "
original_credits[51] = "Eoin Rogan"
original_credits[52] = "George Svarovsky"
original_credits[53] = "Saurev Sarkar"
original_credits[54] = "Jason Brown"
original_credits[55] = "John Kershaw"
original_credits[56] = "Dee Lee"
original_credits[57] = " "
original_credits[58] = " "
original_credits[59] = " "
original_credits[60] = ":Sequência Introdutória"
original_credits[61] = ","
original_credits[62] = "Stuart Black"
original_credits[63] = " "
original_credits[64] = " "
original_credits[65] = " "
original_credits[66] = ":Música e Efeitos Sonoros"
original_credits[67] = ","
original_credits[68] = "Russell Shaw"
original_credits[69] = "Adrian Moore"
original_credits[70] = " "
original_credits[71] = "Jeremy Longley"
original_credits[72] = "Andy Wood"
original_credits[73] = " "
original_credits[74] = " "
original_credits[75] = " "
original_credits[76] = ":Voz da Narradora"
original_credits[77] = ","
original_credits[78] = "Rebecca Green"
original_credits[79] = " "
original_credits[80] = " "
original_credits[81] = " "
original_credits[82] = ":Desenho dos Níveis"
original_credits[83] = ","
original_credits[84] = "Wayne Imlach"
original_credits[85] = "Natalie White"
original_credits[86] = "Steven Jarrett"
original_credits[87] = "Shin Kanaoya"
original_credits[88] = " "
original_credits[89] = " "
original_credits[90] = " "
original_credits[91] = ":Roteiristas"
original_credits[92] = ","
original_credits[93] = "James Leach"
original_credits[94] = "Sean Masterson"
original_credits[95] = "Neil Cook"
original_credits[96] = " "
original_credits[97] = " "
original_credits[98] = " "
original_credits[99] = ":Pesquisa e Desenvolvimento"
original_credits[100] = ","
original_credits[101] = "Andy Cakebread"
original_credits[102] = "Richard Reed"
original_credits[103] = " "
original_credits[104] = "Glenn Corpes"
original_credits[105] = "Martin Bell"
original_credits[106] = "Ian Shaw"
original_credits[107] = "Jan Svarovsky"
original_credits[108] = " "
original_credits[109] = " "
original_credits[110] = " "
original_credits[111] = ":Bibliotecas e Ferramentas"
original_credits[112] = ","
original_credits[113] = "Mark Huntley"
original_credits[114] = "Alex Peters"
original_credits[115] = "Rik Heywood"
original_credits[116] = " "
original_credits[117] = "Ian Shippen"
original_credits[118] = "Mark Lamport"
original_credits[119] = " "
original_credits[120] = "Russell Shaw"
original_credits[121] = "Tony Cox"
original_credits[122] = " "
original_credits[123] = " "
original_credits[124] = " "
original_credits[125] = ":Programaçäo do Instalador"
original_credits[126] = ","
original_credits[127] = "Andy Nuttall"
original_credits[128] = "Tony Cox"
original_credits[129] = "Andy Cakebread"
original_credits[130] = " "
original_credits[131] = " "
original_credits[132] = " "
original_credits[133] = ":Chefe de Testes"
original_credits[134] = ","
original_credits[135] = "Andy Robson"
original_credits[136] = " "
original_credits[137] = " "
original_credits[138] = " "
original_credits[139] = ":Testadores"
original_credits[140] = ","
original_credits[141] = "Wayne Imlach"
original_credits[142] = "Jon Rennie"
original_credits[143] = " "
original_credits[144] = "Jeff Brutus"
original_credits[145] = "Wayne Frost"
original_credits[146] = "Steven Lawrie"
original_credits[147] = "Tristan Paramor"
original_credits[148] = "Nathan Smethurst"
original_credits[149] = " "
original_credits[150] = "Ryan Corkery"
original_credits[151] = "Simon Doherty"
original_credits[152] = "James Dormer"
original_credits[153] = "Martin Gregory"
original_credits[154] = "Ben Lawley"
original_credits[155] = "Joel Lewis"
original_credits[156] = "David Lowe"
original_credits[157] = "Robert Monczak"
original_credits[158] = "Dominic Mortoza"
original_credits[159] = "Karl O'Keeffe"
original_credits[160] = "Michael Singletary"
original_credits[161] = "Andrew Skipper"
original_credits[162] = "Stuart Stephen"
original_credits[163] = "David Wallington"
original_credits[164] = " "
original_credits[165] = " "
original_credits[166] = " "
original_credits[167] = ":Suporte Técnico"
original_credits[168] = ","
original_credits[169] = "Kevin Donkin"
original_credits[170] = "Mike Burnham"
original_credits[171] = "Simon Handby"
original_credits[172] = " "
original_credits[173] = " "
original_credits[174] = " "
original_credits[175] = ":Marketing"
original_credits[176] = ","
original_credits[177] = "Pete Murphy"
original_credits[178] = "Sean Ratcliffe"
original_credits[179] = " "
original_credits[180] = " "
original_credits[181] = " "
original_credits[182] = ":Relaçöes Públicas"
original_credits[183] = ","
original_credits[184] = "Cathy Campos"
original_credits[185] = " "
original_credits[186] = " "
original_credits[187] = " "
original_credits[188] = ":Documentaçäo"
original_credits[189] = ","
original_credits[190] = "Mark Casey"
original_credits[191] = "Richard Johnston"
original_credits[192] = "James Lenoel"
original_credits[193] = "Jon Rennie"
original_credits[194] = " "
original_credits[195] = " "
original_credits[196] = " "
original_credits[197] = ":Documentaçäo e Desenho da Caixa"
original_credits[198] = ","
original_credits[199] = "Caroline Arthur"
original_credits[200] = "James Nolan"
original_credits[201] = " "
original_credits[202] = " "
original_credits[203] = " "
original_credits[204] = ":Chefe do Projeto de Localizaçäo"
original_credits[205] = ","
original_credits[206] = "Carol Aggett"
original_credits[207] = " "
original_credits[208] = " "
original_credits[209] = ":Traduçäo para Português"
original_credits[210] = ","
original_credits[211] = "Altieres Lima"
original_credits[212] = "Leonardo Malaman"
original_credits[213] = "Henrique Poyatos"
original_credits[214] = " "
original_credits[215] = " "
original_credits[216] = ":Produçäo"
original_credits[217] = ","
original_credits[218] = "Rachel Holman"
original_credits[219] = " "
original_credits[220] = " "
original_credits[221] = " "
original_credits[222] = ":Produtor"
original_credits[223] = ","
original_credits[224] = "Mark Webley"
original_credits[225] = " "
original_credits[226] = " "
original_credits[227] = " "
original_credits[228] = ":Produtor Associado"
original_credits[229] = ","
original_credits[230] = "Andy Nuttall"
original_credits[231] = " "
original_credits[232] = " "
original_credits[233] = " "
original_credits[234] = ":Operaçöes"
original_credits[235] = ","
original_credits[236] = "Steve Fitton"
original_credits[237] = " "
original_credits[238] = " "
original_credits[239] = " "
original_credits[240] = ":Administraçäo da Companhia"
original_credits[241] = ","
original_credits[242] = "Audrey Adams"
original_credits[243] = "Annette Dabb"
original_credits[244] = "Emma Gibbs"
original_credits[245] = "Lucia Gobbo"
original_credits[246] = "Jo Goodwin"
original_credits[247] = "Sian Jones"
original_credits[248] = "Kathy McEntee"
original_credits[249] = "Louise Ratcliffe"
original_credits[250] = " "
original_credits[251] = " "
original_credits[252] = " "
original_credits[253] = ":Direçäo da Companhia"
original_credits[254] = ","
original_credits[255] = "Les Edgar"
original_credits[256] = "Peter Molyneux"
original_credits[257] = "David Byrne"
original_credits[258] = " "
original_credits[259] = " "
original_credits[260] = " "
original_credits[261] = ":O nosso agradecimento especial para"
original_credits[262] = ","
original_credits[263] = "Peter Molyneux"
original_credits[264] = " "
original_credits[265] = "O pessoal do Hospital Frimley Park"
original_credits[266] = " "
original_credits[267] = "em particular ao"
original_credits[268] = ","
original_credits[269] = "Beverley Cannell"
original_credits[270] = "Doug Carlisle"
original_credits[271] = " "
original_credits[272] = " "
original_credits[273] = " "
original_credits[274] = ":Continuem a pensar"
original_credits[275] = " "
original_credits[276] = " "
original_credits[277] = " "
original_credits[278] = " "
original_credits[279] = " "
original_credits[280] = " "
original_credits[281] = " "
original_credits[282] = " "
original_credits[283] = " "
original_credits[284] = " "
original_credits[285] = " "
original_credits[286] = " "
original_credits[287] = " "
original_credits[288] = " "
original_credits[289] = " "
original_credits[290] = " "
original_credits[291] = " "
original_credits[292] = " "
original_credits[293] = " "
original_credits[294] = " "
original_credits[295] = "."
buy_objects_window.choose_items = "Escolha os objetos"
buy_objects_window.total = "Total: "
buy_objects_window.price = "Preço: "
build_room_window.pick_room_type = "Escolha a sala"
build_room_window.pick_department = "Departamento"
build_room_window.cost = "Custo: "
object.bench = "Banco"
object.pharmacy_cabinet = "Armário de remédios"
object.console = "Console"
object.atom_analyser = "Analisador atômico"
object.fire_extinguisher = "Extintor"
object.scanner = "Scanner"
object.bin = "Cesto de lixo"
object.swing_door1 = "Porta de batente"
object.pool_table = "Mesa de bilhar"
object.screen = "Biombo"
object.cabinet = "Arquivo"
object.sofa = "Sofá"
object.projector = "Projetor"
object.table2 = "Mesa"
object.shower = "Ducha descontaminadora"
object.comfortable_chair = "Poltrona confortável"
object.door = "Porta"
object.computer = "Computador"
object.litter_bomb = "Bomba de lixo"
object.entrance_left = "Porta de entrada esquerda"
object.dna_fixer = "Reparador de DNA"
object.bed = "Cama"
object.lamp = "Abajur"
object.bookcase = "Estante"
object.desk = "Escrivaninha"
object.toilet_sink = "Pia"
object.gates_of_hell = "Portas do Inferno"
object.swing_door2 = "Porta de batente"
object.cast_remover = "Removedor de gesso"
object.plant = "Planta"
object.blood_machine = "Transfusiômetro"
object.slicer = "Cortador"
object.x_ray = "Raio-X"
object.cardio = "Eletrocardiograma"
object.crash_trolley = "Carrinho"
object.bed2 = "Cama"
object.electrolyser = "Eletrólise"
object.video_game = "Videogame"
object.skeleton = "Esqueleto"
object.ultrascanner = "Ultra scanner"
object.op_sink1 = "Pia"
object.hair_restorer = "Pêlo-restaurador"
object.reception_desk = "Recepçäo"
object.radiation_shield = "Painel anti-radiaçäo"
object.couch = "Divä"
object.inflator = "Inflador"
object.toilet = "Banheiro"
object.lecture_chair = "Poltrona"
object.auto_autopsy = "Máq. autópsias"
object.chair = "Cadeira"
object.x_ray_viewer = "Máquina de raio-X"
object.radiator = "Radiador"
object.bed3 = "Cama"
object.surgeon_screen = "Tela de cirurgiäo"
object.jelly_moulder = "Moldador de gelatina"
object.drinks_machine = "Máq. de bebidas"
object.op_sink2 = "Pia"
object.table1 = "Mesa"
object.entrance_right = "Porta de entrada direita"
object.operating_table = "Mesa de cirurgia"
object.tv = "Televisäo"
transactions.bank_loan = "Empréstimo bancário"
transactions.buy_object = "Comprou"
transactions.cure = "Cura"
transactions.general_bonus = "Pagamento extra geral"
transactions.treat_colon = "Tratamento:"
transactions.eoy_bonus_penalty = "Bônus/multa de fim de ano"
transactions.loan_repayment = "Devoluçäo do empréstimo"
transactions.research = "Gastos em pesquisa"
transactions.epidemy_coverup_fine = "Multa por ocultaçäo da epidemia"
transactions.build_room = "Construiu"
transactions.sell_object = "Vendeu"
transactions.vaccination = "Vacinas"
transactions.personal_bonus = "Pagamento extra individual"
transactions.drug_cost = "Medicamento"
transactions.severance = "Inden. demissäo"
transactions.deposit = "Tratamentos"
transactions.epidemy_fine = "Multa pela epidemia"
transactions.buy_land = "Comprou terreno"
transactions.hire_staff = "Contratou"
transactions.insurance_colon = "Seguro:"
transactions.drinks = "Renda: máquinas de bebidas"
transactions.overdraft = "Juros do saldo devedor"
transactions.vip_award = "Prêmio VIP"
transactions.research_bonus = "Bônus de pesquisa"
transactions.cheat = "Trapaça de dinheiro"
transactions.compensation = "Indenizaçäo do governo"
transactions.wages = "Salários"
transactions.advance_colon = "Avanços:"
transactions.cure_colon = "Cura:"
transactions.jukebox = "Renda: máquina de discos"
transactions.machine_replacement = "Custo por substituiçäo de máquinas"
transactions.heating = "Gastos com aquecimento"
transactions.final_treat_colon = "Tratamento final:"
transactions.emergency_bonus = "Pagamento extra de emergência"
transactions.eoy_trophy_bonus = "Troféu bônus de fim de ano"
transactions.loan_interest = "Juros do empréstimo"
menu_options.game_speed = "  VELOCIDADE DO JOGO  "
menu_options.sound_vol = "  VOLUME DO SOM  "
menu_options.music_vol = "  VOLUME DA MUSICA  "
menu_options.autosave = "  AUTO-SALVAR  "
menu_options.announcements_vol = "  VOLUME DOS AVISOS  "
newspaper[1][1] = "TERROR NO HOSPITAL"
newspaper[1][2] = "O MÉDICO AÇOUGUEIRO"
newspaper[1][3] = "PANICO GERAL"
newspaper[1][4] = "O QUE HAVIA NO LABORATORIO?"
newspaper[1][5] = "DETEVE UMA INVESTIGAÇAO DE RISCO"
newspaper[2][1] = "DR UNK É UM CANALHA"
newspaper[2][2] = "CIRURGIAO DESPEDAÇADO"
newspaper[2][3] = "ESPECIALISTA EM JOGOS"
newspaper[2][4] = "EMBRIAGADO"
newspaper[2][5] = "CIRURGIAO CACHACEIRO"
newspaper[2][6] = "EMBRIAGADO EM CIRURGIA"
newspaper[3][1] = "CIRURGIAO VICIADO"
newspaper[3][2] = "MÉDICO SEM CALÇAS"
newspaper[3][3] = "MÉDICO SEDUTOR"
newspaper[3][4] = "CIRURGIAO INSACIAVEL"
newspaper[4][1] = "MÉDICO INVADE HOSPITAL"
newspaper[4][2] = "CRIME ORGANIZADO"
newspaper[4][3] = "OPERAÇAO DE DESVIO DE FUNDOS"
newspaper[4][4] = "FECHAMENTO SEM REMUNERAÇAO"
newspaper[5][1] = "ASSALTO EM UM HOSPITAL"
newspaper[5][2] = "MÉDICO RETIRA CADAVERES"
newspaper[5][3] = "CAPTURADO COM O CORPO"
newspaper[5][4] = "AJUSTE DE CONTAS DO DR MORTE"
newspaper[5][5] = "ROUBO NO DEPOSITO"
newspaper[5][6] = "DENOMINADO DR CAVATUMBAS"
newspaper[6][1] = "DR COSTURA MAIS UMA VEZ!"
newspaper[6][2] = "FALSO MÉDICO"
newspaper[6][3] = "DIAGNOSTICO ERRADO"
newspaper[6][4] = "CONSULTOR DESAJEITADO"
newspaper[7][1] = "MÉDICO SE SENTE MARGINALIZADO"
newspaper[7][2] = "UM CIRURGIAO 'OPERA' A SI MESMO"
newspaper[7][3] = "DESCONTROLE EM BANHEIROS"
newspaper[7][4] = "MÉDICO PROTAGONIZA UM ESCANDALO"
newspaper[7][5] = "MÉDICO 'CRIA UM BARRACO"
progress_report.too_hot = "Revise o seu sistema de aquecimento. Faz muito calor."
progress_report.header = "Relatório em curso"
progress_report.percentage_pop = "% da populaçäo"
progress_report.too_cold = "Faz muito frio. Coloque radiadores."
progress_report.quite_unhappy = "Os seus pacientes estäo muito contentes."
progress_report.win_criteria = "CRITÉRIOS PARA GANHAR"
progress_report.very_unhappy = "Os seus pacientes estäo muito descontentes."
progress_report.more_drinks_machines = "Coloque mais máquinas de bebidas."
staff_descriptions.bad[1] = "É uma pessoa lenta e suscetível. "
staff_descriptions.bad[2] = "Mostra preguiça e falta de motivaçäo. "
staff_descriptions.bad[3] = "Com uma má formaçäo e pouco eficaz. "
staff_descriptions.bad[4] = "Pessoa grosseira e brusca. Chateia as pessoas. "
staff_descriptions.bad[5] = "Tem pouca resistência e má atitude. "
staff_descriptions.bad[6] = "Pessoa surda como uma porta. Cheira a repolho. "
staff_descriptions.bad[7] = "Pessoa imunda no serviço. Um estorvo. "
staff_descriptions.bad[8] = "Imprudente e se distrai com facilidade. "
staff_descriptions.bad[9] = "Pessoa estressada e confusa. "
staff_descriptions.bad[10] = "Pessoa desleal e rancorosa. Cheia de ódio. "
staff_descriptions.bad[11] = "Näo toma cuidado e provoca acidentes. "
staff_descriptions.bad[12] = "Näo se importa com o trabalho. Perde tempo. "
staff_descriptions.bad[13] = "Pessoa temerária e sem cuidado. "
staff_descriptions.bad[15] = "Pessoa arrogante e presunçosa. "
staff_descriptions.misc[1] = "Joga golfe. "
staff_descriptions.misc[2] = "Pratica mergulho. "
staff_descriptions.misc[3] = "Faz esculturas de gelo. "
staff_descriptions.misc[4] = "Bebe vinho. "
staff_descriptions.misc[5] = "Participa de rally. "
staff_descriptions.misc[6] = "Faz bungee-jump. "
staff_descriptions.misc[7] = "Coleciona latas de cerveja. "
staff_descriptions.misc[8] = "Gosta de mergulhar no público em shows. "
staff_descriptions.misc[9] = "Gosta de fazer surf. "
staff_descriptions.misc[10] = "Pratica rafting. "
staff_descriptions.misc[12] = "Especialista em 'faça você mesmo'. "
staff_descriptions.misc[13] = "Gosta do cinema francês. "
staff_descriptions.misc[14] = "Joga muito Theme Park. "
staff_descriptions.misc[15] = "Possui carteira de habilitaçäo E. "
staff_descriptions.misc[16] = "Corre de motocicleta. "
staff_descriptions.misc[17] = "Toca violino e violoncelo. "
staff_descriptions.misc[18] = "Adora andar de trem. "
staff_descriptions.misc[19] = "Adora cachorros. "
staff_descriptions.misc[20] = "Ouve rádio. "
staff_descriptions.misc[21] = "Toma banho com frequência. "
staff_descriptions.misc[22] = "Instrutor de costura. "
staff_descriptions.misc[23] = "Tira o miolo dos vegetais para usar como saboneteira. "
staff_descriptions.misc[24] = "É policial em meio expediente. "
staff_descriptions.misc[25] = "Ex-convidado de um concurso. "
staff_descriptions.misc[26] = "Coleciona bombas da Segunda Guerra. "
staff_descriptions.misc[27] = "Restaura móveis. "
staff_descriptions.misc[28] = "Escuta rap e hip-hop. "
staff_descriptions.misc[29] = "Extermina insetos borrifando desodorante. "
staff_descriptions.misc[30] = "Ridiculariza comediantes ruins. "
staff_descriptions.misc[31] = "Investiga para a Câmara Municipal. "
staff_descriptions.misc[32] = "Cuida do jardim às escondidas. "
staff_descriptions.misc[33] = "Faz contrabando de relógios falsos. "
staff_descriptions.misc[34] = "Vocalista de uma banda de rock & roll. "
staff_descriptions.misc[35] = "Adora programas de televisäo vespertinos. "
staff_descriptions.misc[36] = "Pesca trutas com a mäo. "
staff_descriptions.misc[37] = "Isca turistas em museus. "
staff_descriptions.good[1] = "Trabalha de forma rápida e diligente. "
staff_descriptions.good[2] = "Trabalha com consciência e seriedade. "
staff_descriptions.good[3] = "Sabe fazer muitas coisas. "
staff_descriptions.good[4] = "Muito agradável e gosta de rir. "
staff_descriptions.good[5] = "Tem muita energia. Näo para. "
staff_descriptions.good[6] = "Pessoa educada e de boas maneiras. "
staff_descriptions.good[7] = "Com talento e capacidade incríveis. "
staff_descriptions.good[8] = "Preocupa-se muito com seu trabalho. "
staff_descriptions.good[9] = "Procura a perfeiçäo e nunca se rende. "
staff_descriptions.good[10] = "Ajuda as pessoas com um sorriso. "
staff_descriptions.good[11] = "Tem encanto, educaçäo e disponibilidade. "
staff_descriptions.good[12] = "Normalmente tem estímulo e dedicaçäo. "
staff_descriptions.good[13] = "É boa pessoa e trabalha muito. "
staff_descriptions.good[14] = "Leal e amigável. "
staff_descriptions.good[15] = "Pessoa atenta e confiável em caso de emergência. "
humanoid_name_ends[1] = "SMITH"
humanoid_name_ends[2] = "WICK"
humanoid_name_ends[3] = "CLIFFE"
humanoid_name_ends[4] = "SON"
humanoid_name_ends[5] = "INGTON"
humanoid_name_ends[6] = "BURY"
humanoid_name_ends[7] = "TON"
humanoid_name_ends[8] = "SON"
humanoid_name_ends[9] = "LEY"
humanoid_name_ends[10] = "BERRY"
humanoid_name_ends[11] = "BAUM"
humanoid_name_ends[12] = "LAN"
humanoid_name_ends[13] = "HAM"
humanoid_name_ends[14] = "SILL"
humanoid_name_ends[15] = "WIN"
humanoid_name_ends[16] = "LET"
humanoid_name_ends[17] = "ERS"
humanoid_name_ends[18] = "TON"
humanoid_name_ends[19] = "MOND"
humanoid_name_ends[20] = "MAN"
humanoid_name_ends[21] = "ELTON"
humanoid_name_ends[22] = "E"
humanoid_name_ends[23] = "MORE"
humanoid_name_ends[24] = "MOOR"
humanoid_name_ends[25] = "LET"
humanoid_name_ends[26] = "LIN"
menu.options = "  OPÇOES  "
menu.display = "  TELA  "
menu.file = "  ARQUIVO  "
menu.debug = "  DEPURAÇAO  "
menu.charts = "  GRAFICOS  "
letter[1][1] = "Olá %s!//"
letter[1][2] = "Fantástico! Dirigiu este hospital de uma maneira excelente. Nós, a elite do Ministério da Saúde, gostaríamos de saber se você estaria interessado em fazer parte de um grande projeto. Há um trabalho para o qual acreditamos que você seria a pessoa perfeita. O salário seria de %d. Pense nisso.//"
letter[1][3] = "Está interessado em trabalhar no Hospital %s?"
letter[2][1] = "Olá %s!//"
letter[2][2] = "Parabéns! Realizou notáveis melhorias no seu hospital. Temos outro serviço que você poderia assumir, se gostar de mudanças e novos desafios. Näo é obrigatório aceitar, mas seria bom se o fizesse. O salário é de %d.//"
letter[2][3] = "Quer trabalhar no Hospital %s?"
letter[3][1] = "Olá %s!//"
letter[3][2] = "Dirigiu este hospital com notável desempenho durante o seu mandato. Ao chegar ao fim, prevejo um brilhante futuro, e gostaríamos de lhe oferecer um cargo em outro lugar. O salário seria de %d, e acredito que você adoraria o desafio que isso criaria.//"
letter[3][3] = "Gostaria de ter um posto no Hospital %s?"
letter[4][1] = "Olá %s!//"
letter[4][2] = "Parabéns! No Ministério estamos muito impressionados com sua capacidade como diretor do hospital. É, sem dúvida, uma pessoa valiosa para o Departamento de Saúde, mas acreditamos que você preferiria um trabalho mais qualificado. Receberia um salário de %d, embora a decisäo seja sua.//"
letter[4][3] = "Está interessado em trabalhar no Hospital %s?"
letter[5][1] = "Olá %s!//"
letter[5][2] = "Saudaçöes novamente. Respeitamos o seu desejo de näo querer sair do seu estupendo hospital, mas pedimos que reconsidere. Ofereceremos a você um alto salário de %d se decidir ir para o outro hospital e assumir a sua direçäo.//"
letter[5][3] = "Gostaria de ir agora para o Hospital %s?"
letter[6][1] = "Olá %s!//"
letter[6][2] = "Receba nossas saudaçöes. Sabemos que você desfrutou muito da sua estadia nesta instituiçäo, täo agradável e bem dirigida, mas acreditamos que agora deveria pensar no seu futuro. Naturalmente, você teria um salário de %d se decidisse sair. Vale a pena considerar.//"
letter[6][3] = "Gostaria de ter um posto no Hospital %s?"
letter[7][1] = "Olá %s!//"
letter[7][2] = "Bom dia! O Ministério da Saúde gostaria de saber se você reconsideraria a sua decisäo de ficar no seu hospital. Compreendemos que você tenha um ótimo hospital, mas acreditamos que faria muito bem em aceitar um trabalho mais estimulante, com um salário de %d.//"
letter[7][3] = "Aceitaria um posto no Hospital %s?"
letter[8][1] = "Olá %s!//"
letter[8][2] = "Olá, novamente. Recebemos a sua resposta negativa na nossa última carta, na qual oferecíamos um posto de direçäo em outro hospital, com um alto salário de %d. Contudo, acreditamos que você deveria reconsiderar essa decisäo. Como verá, temos o trabalho perfeito para você.//"
letter[8][3] = "Aceitaria um posto no Hospital %s, por favor?"
letter[9][1] = "Olá %s!//"
letter[9][2] = "Você demonstrou ser o melhor diretor de hospital na longa e infeliz história da medicina. O lucro que obteve näo pode ficar sem recompensa, por isso lhe oferecemos o posto de Diretor Chefe de Todos os Hospitais. Terá um salário de %d, uma cerimônia com todas as honras e as pessoas demonstraräo seu reconhecimento onde quer que esteja.//"
letter[9][3] = "Agradecemos por tudo o que fez e desfrute de uma longa semi-aposentadoria.//"
letter[9][4] = ""
letter[10][1] = "Olá %s!//"
letter[10][2] = "Parabéns por dirigir com sucesso todos os hospitais que lhe atribuímos. Esta grande atuaçäo lhe permite viajar livremente por todo o mundo. Receberá uma pensäo de %d e uma limousine para poder viajar de cidade em cidade, saudando seu incondicional público e incentivando o trabalho realizado em todos os hospitais.//"
letter[10][3] = "Estamos orgulhosos e agradecidos pelo seu trabalho ao salvar vidas.//"
letter[10][4] = ""
letter[11][1] = "Olá %s!//"
letter[11][2] = "Sua carreira tem sido exemplar, e você é uma inspiraçäo para todos nós. Obrigado por dirigir täo bem tantos hospitais. Gostaríamos de lhe conceder um salário vitalício de %d, e só lhe pedimos que viaje em um carro oficial descoberto de cidade em cidade, dando conferências sobre seus rápidos lucros.//"
letter[11][3] = "Você é um exemplo para todos e uma pessoa de enorme valor.//"
letter[11][4] = ""
letter[12][1] = "Olá %s!//"
letter[12][2] = "A sua bem-sucedida carreira como o melhor diretor de hospital desde Moisés está chegando ao fim. Você causou tanto impacto nos círculos médicos que o Ministério quer lhe oferecer um salário de %s, só para inaugurar festas, navios e organizar entrevistas em nosso nome. Você seria um excelente relaçöes públicas!//"
letter[12][3] = "Por favor, aceite. Será fácil e você terá um veículo e uma escolta policial.//"
letter[12][4] = ""
place_objects_window.place_objects_in_corridor = "Coloque os objetos em um corredor."
place_objects_window.drag_blueprint = "Arraste a marca azul até conseguir o tamanho desejado."
place_objects_window.pick_up_object = "Clique em um objeto para selecioná-lo ou escolher outra opçäo no diálogo."
place_objects_window.place_windows = "Se desejar, coloque algumas janelas. Em seguida, clique em confirmar."
place_objects_window.place_objects = "Coloque os objetos e mova-os ao seu gosto. Em seguida, confirme."
place_objects_window.confirm_or_buy_objects = "Você pode confirmar a sala, comprar ou mover alguns objetos."
place_objects_window.place_door = "Coloque a porta."
level_names[1] = "Cidade Contaminada"
level_names[2] = "Cidade do Sonho"
level_names[3] = "Vila Grande"
level_names[4] = "Vila Praia"
level_names[5] = "Vila Simples"
level_names[6] = "Vila Ulcera"
level_names[7] = "Cidade Verde"
level_names[8] = "Cidade do Porto"
level_names[9] = "Cidade Leste"
level_names[10] = "Ovovile"
level_names[11] = "Vila Corvo"
level_names[12] = "Vila Próspera"
level_names[13] = "Vila Amistosa"
level_names[14] = "Vila Pancadaria"
level_names[15] = "Vila Sepultura"
pay_rise.definite_quit = "Faça o que fizer, näo ficarei. Estou farto deste local."
pay_rise.regular[2] = "Estou muito cansado. Preciso de férias e de um aumento salarial de %d, até um total de %d. E quero já, seu tirano!"
pay_rise.regular[3] = "Vamos! Trabalho como um escravo. Se me der um bônus de %d, ficarei no seu hospital."
pay_rise.regular[4] = "Estou muito descontente. Exijo um aumento de %d, e um salário final de %d, caso contrário, vou embora."
pay_rise.regular[5] = "Meus pais me disseram que os médicos ganham um bom salário, sendo assim, me dê um aumento de %d ou me dedicarei à produçäo de jogos de computador."
pay_rise.regular[6] = "Estou farto. Pague-me um bom salário. Será suficiente um aumento de %d."
pay_rise.poached = "%s ofereceu-me um salário de %d. Se näo me pagar o mesmo, vou embora."
casebook.reputation = "reputaçäo"
casebook.earned_money = "dinheiro ganho"
casebook.cure_desc.no_cure_known = "Näo há cura conhecida."
casebook.cure_desc.hire_doctors = "Você precisa contratar alguns médicos."
casebook.cure_desc.build_ward = "Ainda é necessário construir uma Enfermaria."
casebook.cure_desc.improve_cure = "Melhorar Cura."
casebook.cure_desc.build_room = "Sugiro que construa %s"
casebook.cure_desc.hire_surgeons = "Você precisa contratar cirurgiöes."
casebook.cure_desc.cure_known = "Cura."
casebook.cure_desc.hire_psychiatrists = "Você precisa contratar psiquiatras."
casebook.cure_desc.hire_nurses = "Você deve contratar algumas enfermeiras."
casebook.sent_home = "rejeitados"
casebook.cured = "recuperaçöes"
casebook.deaths = "falecimentos"
casebook.treatment_charge = "custo tratamento"
casebook.research = "pesquisa intensiva"
casebook.cure = "cura"
confirmation.replace_machine = "Quer mesmo substituir esta máquina?"
confirmation.quit = "Você escolheu sair do jogo. Tem certeza de que deseja sair?"
confirmation.sack_staff = "Tem certeza de que deseja despedir este funcionário?"
confirmation.delete_room = "Quer mesmo eliminar esta sala?"
confirmation.return_to_blueprint = "Tem certeza de que deseja substituir o(a) %s por $%d?"
confirmation.overwrite_save = "Já existe um jogo salvo neste local. Tem certeza de que deseja substituí-lo?"
menu_options_volume[80] = "  80%  "
menu_options_volume[50] = "  50%  "
menu_options_volume[100] = "  100%  "
menu_options_volume[70] = "  70%  "
menu_options_volume[40] = "  40%  "
menu_options_volume[90] = "  90%  "
menu_options_volume[60] = "  60%  "
menu_options_volume[20] = "  20%  "
menu_options_volume[30] = "  30%  "
menu_options_volume[10] = "  10%  "
vip_names[1] = "O Maior dos Ricaços"
vip_names[2] = "Lawrence Nightingale"
vip_names[3] = "Rei Bernard da Holanda"
vip_names[4] = "Aung Sang Su Kyi"
vip_names[5] = "Sir Reginald Crumbly"
vip_names[7] = "O Vereador Joäo Precipício"
vip_names[8] = "O Marquês do Figo de Chumbo"
vip_names[9] = "Uma estrela do futebol"
vip_names[10] = "A. Eskoplovitz, II"
vip_names.health_minister = "O Ministro da Saúde"
menu_charts.briefing = "  INSTRUÇOES  "
diseases.kidney_beans.cause = "Causa - Mastigar cubos de gelo das bebidas."
diseases.kidney_beans.name = "Incontinência"
diseases.kidney_beans.symptoms = "Sintomas - Dor e idas frequentes ao banheiro."
diseases.kidney_beans.cure = "Cura - Dois cirurgiöes extraem as pedras dos rins."
diseases.ruptured_nodules.cause = "Causa - Fazer bungee jumping em tempo frio."
diseases.ruptured_nodules.name = "Boludite"
diseases.ruptured_nodules.symptoms = "Sintomas - Incapacidade de se sentar confortavelmente."
diseases.ruptured_nodules.cure = "Cura - Dois cirurgiöes qualificados colocam certas partes no lugar com mäos firmes."
diseases.fractured_bones.cause = "Causa - Queda de um lugar alto."
diseases.fractured_bones.name = "Fraturas ósseas"
diseases.fractured_bones.symptoms = "Sintomas - Um grande rangido e a impossibilidade de usar os membros afetados."
diseases.fractured_bones.cure = "Cura - Um molde é colocado, depois removido com uma máquina a laser."
diseases.diag_psych.name = "Diag: Psiquiatria"
diseases.jellyitis.cause = "Causa - Dieta rica em gelatina e muito exercício."
diseases.jellyitis.name = "Gelatinite"
diseases.jellyitis.symptoms = "Sintomas - Tremores excessivos e quedas frequentes."
diseases.jellyitis.cure = "Cura - O paciente é imerso em um banheiro gelatinoso em uma consulta especial."
diseases.discrete_itching.cause = "Causa - Insetos diminutos com dentes afiados."
diseases.discrete_itching.name = "Coceira leve"
diseases.discrete_itching.symptoms = "Sintomas - Coceira que leva ao inchaço da área afetada."
diseases.discrete_itching.cure = "Cura - O paciente bebe um xarope farmacêutico para aliviar a coceira."
diseases.alien_dna.cause = "Causa - Enfrentar gigantes com sangue alienígena inteligente."
diseases.alien_dna.name = "DNA alienígena"
diseases.alien_dna.symptoms = "Sintomas - Metamorfose alienígena gradual e desejo de destruir cidades."
diseases.alien_dna.cure = "Cura - O DNA é mecanicamente removido, limpo de elementos alienígenas e substituído rapidamente."
diseases.infectious_laughter.cause = "Causa - Comédia clássica de situaçäo."
diseases.infectious_laughter.name = "Risada contagiosa"
diseases.infectious_laughter.symptoms = "Sintomas - Incapacidade de parar de rir e repetir frases sem graça."
diseases.infectious_laughter.cure = "Cura - Um psiquiatra qualificado deve lembrar o paciente de que a doença é grave."
diseases.diag_general_diag.name = "Diag: Geral"
diseases.spare_ribs.cause = "Causa - Sentar-se em locais muito frios."
diseases.spare_ribs.name = "Costelas extras"
diseases.spare_ribs.symptoms = "Sintomas - Mal-estar no peito."
diseases.spare_ribs.cure = "Cura - Dois cirurgiöes removem as costelas e as colocam em uma sacola para o paciente."
diseases.transparency.cause = "Causa - Lamber tampas de iogurte já usadas."
diseases.transparency.name = "Transparentite"
diseases.transparency.symptoms = "Sintomas - A pele fica transparente e horrível."
diseases.transparency.cure = "Cura - Tomar uma preparaçäo farmacêutica de água esfriada e colorida de modo especial."
diseases.baldness.cause = "Causa - Contar mentiras e inventar histórias para ser famoso."
diseases.baldness.name = "Calvície"
diseases.baldness.symptoms = "Sintomas - Ter a cabeça brilhante e passar vergonha."
diseases.baldness.cure = "Cura - O cabelo é costurado na cabeça do paciente com uma dolorosa máquina."
diseases.sleeping_illness.cause = "Causa - Uma glândula do sono hiperativa no céu da boca."
diseases.sleeping_illness.name = "Sonolência"
diseases.sleeping_illness.symptoms = "Sintomas - Um desejo irresistível de mergulhar no sono."
diseases.sleeping_illness.cure = "Cura - Uma enfermeira administra uma dose elevada de um poderoso estimulante."
diseases.pregnancy.cause = "Causa - Cortes de eletricidade em áreas urbanas."
diseases.pregnancy.name = "Gravidez"
diseases.pregnancy.symptoms = "Sintomas - Muita vontade de comer e um mal-estar no estômago."
diseases.pregnancy.cure = "Cura - O bebê é retirado na Sala de Cirurgia, limpo e entregue ao paciente."
diseases.general_practice.name = "Diagnóstico Geral"
diseases.tv_personalities.cause = "Causa - Assistir televisäo durante o dia."
diseases.tv_personalities.name = "Personalitite"
diseases.tv_personalities.symptoms = "Sintomas - Ilusäo de estar apresentando um programa de culinária na televisäo."
diseases.tv_personalities.cure = "Cura - Um psiquiatra deve convencer o paciente a vender o seu televisor e comprar um rádio."
diseases.broken_wind.cause = "Causa - Usar um aparelho ginástico depois das refeiçöes."
diseases.broken_wind.name = "Aerofagia"
diseases.broken_wind.symptoms = "Sintomas - Incomodar as pessoas que estäo atrás do paciente."
diseases.broken_wind.cure = "Cura - Beber rapidamente uma forte mistura de substâncias aquosas na farmácia."
diseases.hairyitis.cause = "Causa - Exposiçäo prolongada à lua."
diseases.hairyitis.name = "Peludismo"
diseases.hairyitis.symptoms = "Sintomas - Pacientes com olfato mais sensível."
diseases.hairyitis.cure = "Cura - Uma máquina de eletrólise elimina o pelo e fecha os poros."
diseases.diag_ward.name = "Diag: Clínico"
diseases.third_degree_sideburns.cause = "Causa - Desejo intenso pelos anos 70."
diseases.third_degree_sideburns.name = "Costeletas de terceiro grau"
diseases.third_degree_sideburns.symptoms = "Sintomas - Corte comprido, roupas largas, plataformas e muita maquiagem."
diseases.third_degree_sideburns.cure = "Cura - O pessoal psiquiátrico deve convencer o paciente de que essa moda é horrível, usando técnicas atualizadas."
diseases.gut_rot.cause = "Causa - O xarope para tosse à base de uísque da Sra. McGuiver."
diseases.gut_rot.name = "Ulcera gástrica"
diseases.gut_rot.symptoms = "Sintomas - O paciente näo tosse, mas também näo tem paredes no estômago."
diseases.gut_rot.cure = "Cura - Uma enfermeira administra uma soluçäo variada de substâncias químicas para revestir o estômago."
diseases.chronic_nosehair.cause = "Causa - Cheirar com desprezo aqueles que estäo pior que o paciente."
diseases.chronic_nosehair.name = "Nariz peludo"
diseases.chronic_nosehair.symptoms = "Sintomas - Ter tanto cabelo no nariz que dá para fazer uma peruca."
diseases.chronic_nosehair.cure = "Cura - Tomar um xarope anti-pelo, preparado pela enfermeira na farmácia."
diseases.the_squits.cause = "Causa - Comer pizza encontrada debaixo da mesa da cozinha."
diseases.the_squits.name = "Decomposiçäo"
diseases.the_squits.symptoms = "Sintomas - Agh! Certamente pode imaginar."
diseases.the_squits.cure = "Cura - Uma mistura pegajosa de substâncias viscosas preparada na farmácia solidifica as tripas do paciente."
diseases.fake_blood.cause = "Causa - O paciente está acostumado a ser o alvo das brincadeiras."
diseases.fake_blood.name = "Sangue falso"
diseases.fake_blood.symptoms = "Sintomas - Fluido vermelho nas veias que se evapora ao contato com a roupa."
diseases.fake_blood.cure = "Cura - Esse problema só se resolve com tratamento psiquiátrico."
diseases.corrugated_ankles.cause = "Causa - Avançar o sinal vermelho do semáforo."
diseases.corrugated_ankles.name = "Tornozelo torcido"
diseases.corrugated_ankles.symptoms = "Sintomas - Os pés näo cabem bem nos sapatos."
diseases.corrugated_ankles.cure = "Cura - Os tornozelos säo endireitados bebendo uma infusäo ligeiramente tóxica de ervas e plantas."
diseases.diag_x_ray.name = "Diag: Raio-X"
diseases.invisibility.cause = "Causa - A picada de uma formiga radioativa (e invisível)."
diseases.invisibility.name = "Invisibilidade"
diseases.invisibility.symptoms = "Sintomas - Os pacientes näo sofrem, mas às vezes gostam de pregar peças em seus familiares."
diseases.invisibility.cure = "Cura - Beber um líquido colorido na farmácia torna o paciente completamente visível."
diseases.sweaty_palms.cause = "Causa - Temer entrevistas de trabalho."
diseases.sweaty_palms.name = "Mäos suadas"
diseases.sweaty_palms.symptoms = "Sintomas - Dar a mäo ao paciente é como agarrar uma esponja encharcada."
diseases.sweaty_palms.cure = "Cura - Um psiquiatra deve discutir a fundo com o paciente sobre essa doença inventada."
diseases.bloaty_head.cause = "Causa - Cheirar queijo e beber água da chuva näo purificada."
diseases.bloaty_head.name = "Cabeça inchada"
diseases.bloaty_head.symptoms = "Sintomas - Muito desconforto aparente."
diseases.bloaty_head.cure = "Cura - Fura-se a cabeça inflada, em seguida, usa-se uma máquina inteligente para voltar a inflar até o tamanho correto."
diseases.heaped_piles.cause = "Causa - Permanecer de pé ao lado de refrigeradores de água."
diseases.heaped_piles.name = "Hemorroidas"
diseases.heaped_piles.symptoms = "Sintomas - O paciente sente-se como se estivesse sentado sobre bolas de gude."
diseases.heaped_piles.cure = "Cura - Uma bebida agradável, embora muito ácida, dissolve as hemorroidas internas."
diseases.king_complex.cause = "Causa - O espírito do rei entrou na mente do paciente e se apoderou dela."
diseases.king_complex.name = "Complexo de rei"
diseases.king_complex.symptoms = "Sintomas - Calçar sapatos de camurça e comer hambúrgueres."
diseases.king_complex.cure = "Cura - Um psiquiatra conta ao paciente como ele está ridículo."
diseases.golf_stones.cause = "Causa - Inalar gás venenoso contendo bolas de golfe."
diseases.golf_stones.name = "Cálculos de golfe"
diseases.golf_stones.symptoms = "Sintomas - Delírios e muita vergonha."
diseases.golf_stones.cure = "Cura - Dois cirurgiöes operam para extrair os cálculos."
diseases.gastric_ejections.cause = "Causa - Comida mexicana ou indiana muito condimentada."
diseases.gastric_ejections.name = "Vômito"
diseases.gastric_ejections.symptoms = "Sintomas - O paciente vomita a comida ainda meio digerida a qualquer momento."
diseases.gastric_ejections.cure = "Cura - Beber um adstringente especial para parar os vômitos."
diseases.unexpected_swelling.cause = "Causa - Algo inesperado."
diseases.unexpected_swelling.name = "Inchaço inesperado"
diseases.unexpected_swelling.symptoms = "Sintomas - Inchaço."
diseases.unexpected_swelling.cure = "Cura - Só é possível reduzir o inchaço com uma lanceta durante uma operaçäo que requer dois cirurgiöes."
diseases.slack_tongue.cause = "Causa - Fazer muita fofoca."
diseases.slack_tongue.name = "Língua comprida"
diseases.slack_tongue.symptoms = "Sintomas - A língua cresce até cinco vezes o seu tamanho original."
diseases.slack_tongue.cure = "Cura - A língua é colocada no corta-línguas e removida de forma rápida, eficaz e dolorosa."
diseases.diag_scanner.name = "Diag: Scanner"
diseases.uncommon_cold.cause = "Causa - Pequenas partículas de muco no ar."
diseases.uncommon_cold.name = "Catarro atípico"
diseases.uncommon_cold.symptoms = "Sintomas - Mucosidade, espirros e pulmöes descoloridos."
diseases.uncommon_cold.cure = "Cura - Beber um grande gole de um xarope estranho para tosse fabricado na farmácia com ingredientes especiais."
diseases.broken_heart.cause = "Causa - Alguém mais rico, mais jovem e mais magro que o paciente."
diseases.broken_heart.name = "Infelicidade"
diseases.broken_heart.symptoms = "Sintomas - Chorar e rir depois de passar horas rasgando as fotos das férias."
diseases.broken_heart.cure = "Cura - Dois cirurgiöes abrem o peito e arrumam com delicadeza o coraçäo enquanto prendem a respiraçäo."
diseases.diag_blood_machine.name = "Diag: Análise Sanguínea"
diseases.diag_cardiogram.name = "Diag: Cardiologia"
diseases.serious_radiation.cause = "Causa - Confundir isótopos de plutônio com chiclete."
diseases.serious_radiation.name = "Radiaçäo Grave"
diseases.serious_radiation.symptoms = "Sintomas - Os pacientes com essa doença se sentem muito mal."
diseases.serious_radiation.cure = "Cura - O paciente deve ir para a Ducha de Descontaminaçäo para se limpar."
diseases.iron_lungs.cause = "Causa - Contaminaçäo urbana misturada com restos de kebab."
diseases.iron_lungs.name = "Pulmäo de aço"
diseases.iron_lungs.symptoms = "Sintomas - Capacidade para aspirar fogo e gritar debaixo da água."
diseases.iron_lungs.cure = "Cura - Dois cirurgiöes realizam uma operaçäo para remover as partes duras do pulmäo na Sala de Cirurgia."
diseases.diag_ultrascan.name = "Diag: Ultra Scanner"
diseases.autopsy.name = "Autópsia"
dynamic_info.staff.ability = "Habilidade"
dynamic_info.staff.psychiatrist_abbrev = "Psiq."
dynamic_info.staff.actions.waiting_for_patient = "Esperando um paciente"
dynamic_info.staff.actions.wandering = "Andando por aí"
dynamic_info.staff.actions.going_to_repair = "Indo reparar %s"
dynamic_info.staff.tiredness = "Cansaço"
dynamic_info.vip = "Visitante VIP"
dynamic_info.patient.diagnosis_progress = "Diagnóstico em curso"
dynamic_info.patient.emergency = "Emergências: %s"
dynamic_info.patient.diagnosed = "Diagnóstico: %s"
dynamic_info.patient.guessed_diagnosis = "Bom diagnóstico: %s"
dynamic_info.patient.actions.fed_up = "Perdeu a paciência - Indo para casa"
dynamic_info.patient.actions.waiting_for_diagnosis_rooms = "Esperando a construçäo da consulta"
dynamic_info.patient.actions.sent_to_other_hospital = "Enviado para outro local"
dynamic_info.patient.actions.on_my_way_to = "Indo para %s"
dynamic_info.patient.actions.waiting_for_treatment_rooms = "Esperando a construçäo do tratamento"
dynamic_info.patient.actions.queueing_for = "Na fila para %s"
dynamic_info.patient.actions.epidemic_contagious = "Tenho uma doença contagiosa"
dynamic_info.patient.actions.no_diagnoses_available = "Näo há mais diagnósticos, vou embora"
dynamic_info.patient.actions.awaiting_decision = "Esperando por sua decisäo"
dynamic_info.patient.actions.sent_home = "Dado alta"
dynamic_info.patient.actions.cured = "Curado!"
dynamic_info.patient.actions.prices_too_high = "Os seus preços säo muito altos, vou embora"
dynamic_info.patient.actions.epidemic_sent_home = "Enviado para casa por um Inspetor"
dynamic_info.patient.actions.no_treatment_available = "Näo há tratamentos, vou para casa."
dynamic_info.patient.actions.dying = "Morrendo!"
dynamic_info.object.strength = "Resistência %d"
dynamic_info.object.queue_expected = "Fila esperada %d"
dynamic_info.object.times_used = "Utilizado %d vezes"
dynamic_info.object.queue_size = "Tamanho da fila %d"
dynamic_info.health_inspector = "Inspetor de Saúde"
town_map.chat = "Detalhes da cidade"
town_map.not_for_sale = "Näo vende-se"
town_map.price = "Preço"
town_map.number = "Número"
town_map.owner = "Proprietário"
town_map.for_sale = "Vende-se"
town_map.area = "Terreno"
misc.grade_adverb.mildly = "ligeiramente"
misc.grade_adverb.moderately = "moderadamente"
misc.grade_adverb.extremely = "extremamente"
misc.out_of_sync = "Jogo fora de sincronismo"
misc.load_failed = "Jogo näo carregado"
misc.send_message_all = "Enviar mensagem para todos os jogadores"
misc.hospital_open = "Hospital Aberto"
misc.save_failed = "ERRO: Näo foi possível salvar o jogo"
misc.mouse = "Rato"
misc.pause = "Pausa"
misc.done = "Concluído"
misc.send_message = "Enviar mensagem para o jogador %d"
misc.balance = "Arquivo de Balanço:"
misc.low_res = "Baixa Resoluçäo"
misc.force = "Mäo-de-obra"
misc.save_success = "Jogo salvo com êxito"
drug_companies[1] = "Laboratórios Joäo"
drug_companies[2] = "Curatudo S.A."
drug_companies[3] = "Pequena Pílula Co."
drug_companies[4] = "Remédios Seguros S.A."
drug_companies[5] = "Omnipharma Corp."
high_score.score = "PONTOS"
high_score.pos = "POS"
high_score.worst_scores = "GALERIA DA VERGONHA"
high_score.categories.cures = "NUMERO DE CURAS"
high_score.categories.cure_death_ratio = "MEDIA DE CURAS E MORTES"
high_score.categories.total_value = "VALOR TOTAL"
high_score.categories.visitors = "MAIS VISITANTES"
high_score.categories.clean = "LIMPEZA"
high_score.categories.money = "O MAIS RICO"
high_score.categories.salary = "SALARIO MAIS ALTO"
high_score.categories.deaths = "NUMERO DE MORTES"
high_score.categories.patient_happiness = "CLIENTES SATISFEITOS"
high_score.categories.staff_number = "FUNCIONARIOS"
high_score.categories.staff_happiness = "FUNCIONARIOS CONTENTES"
high_score.player = "JOGADOR"
high_score.best_scores = "GALERIA DA FAMA"
high_score.killed = "Morto"
competitor_names[1] = "ORAC"
competitor_names[2] = "COLOSSUS"
competitor_names[3] = "HAL"
competitor_names[4] = "MULTIVAC"
competitor_names[5] = "HOLLY"
competitor_names[6] = "DEEP THOUGHT"
competitor_names[7] = "ZEN"
competitor_names[8] = "LEON"
competitor_names[9] = "MARVIN"
competitor_names[10] = "AKIRA"
competitor_names[11] = "MOTHER"
competitor_names[12] = "JAYNE"
competitor_names[13] = "CORSIX"
competitor_names[14] = "ROUJIN"
competitor_names[15] = "EDVIN"
competitor_names[16] = "SAM"
competitor_names[17] = "CHARLIE"
competitor_names[18] = "ARTHUR"
competitor_names[19] = "MAGNUS"
competitor_names[20] = "SAL"
competitor_names[21] = "JOSHUA"
competitor_names[22] = "DANEEL"
competitor_names[23] = "OLIVAW"
competitor_names[24] = "NIC"
staff_class.handyman = "Zelador"
staff_class.nurse = "Enfermeira"
staff_class.surgeon = "Cirurgiäo"
staff_class.receptionist = "Recepcionista"
staff_class.doctor = "Médico"
menu_debug.display_pager = "  MOSTRAR PAGINADOR            "
menu_debug.nav_bits = "  NAV BITS                     "
menu_debug.win_level_anim = "  SUPERAR NIVEL ANIM           "
menu_debug.plant_pagers = "  PAGINADORES DE PLANTAS       "
menu_debug.display_room_status = "  MOSTRAR ESTADO DA CONSULTA"
menu_debug.show_nav_cells = "  MOSTRAR CELAS NAV           "
menu_debug.entry_cells = "  CELAS DE ENTRADA            "
menu_debug.object_cells = "  CELAS DE OBJETO             "
menu_debug.lose_game_anim[1] = "  PERDER JOGO 1 ANIM        "
menu_debug.lose_game_anim[2] = "  PERDER JOGO 2 ANIM        "
menu_debug.lose_game_anim[3] = "  PERDER JOGO 3 ANIM        "
menu_debug.lose_game_anim[4] = "  PERDER JOGO 4 ANIM        "
menu_debug.lose_game_anim[5] = "  PERDER JOGO 5 ANIM        "
menu_debug.lose_game_anim[6] = "  PERDER JOGO 6 ANIM        "
menu_debug.lose_game_anim[7] = "  PERDER JOGO 7 ANIM        "
menu_debug.show_help_hotspot = "  MOSTRAR AJUDAS               "
menu_debug.porter_pagers = "  PAGINADORES DE ZELADOR      "
menu_debug.mapwho_checking = "  VERIFICAR LOCALIZAÇAO       "
menu_debug.machine_pagers = "  PAGINADORES DE MAQUINA       "
menu_debug.keep_clear_cells = "  CONSERVAR AS CELAS LIMPAS "
menu_debug.enter_nav_debug = "  INTRODUZIR NAV DEBUG         "
menu_debug.win_game_anim = "  GANHAR JOGO ANIM             "
menu_debug.remove_objects = "  RETIRAR OBJETOS               "
menu_debug.display_big_cells = "  MOSTRAR CELAS GRANDES       "
menu_debug.pixbuf_cells = "  CELAS PIXBUF                "
menu_debug.remove_walls = "  RETIRAR PAREDES               "
research.categories.drugs = "Pesquisa farmacêutica"
research.categories.cure = "Equipam. de cura"
research.categories.improvements = "Melhorias"
research.categories.specialisation = "Especializaçäo"
research.categories.diagnosis = "Equipam. de diagnóstico"
research.funds_allocation = "Alocaçäo de fundos"
research.allocated_amount = "Quantidade alocada"
months[1] = "Jan"
months[2] = "Fev"
months[3] = "Mar"
months[4] = "Abr"
months[5] = "Mai"
months[6] = "Jun"
months[7] = "Jul"
months[8] = "Ago"
months[9] = "Set"
months[10] = "Out"
months[11] = "Nov"
months[12] = "Dez"
trophy_room.cleanliness.award[1] = "Os Inspetores notaram que o seu hospital está muito limpo. Um hospital limpo é um hospital seguro. Continue assim."
trophy_room.cleanliness.regional_good[1] = "Seu hospital foi apontado como um dos menos limpos da regiäo. Um hospital sujo, que cheira mal e é perigoso. Deveria se preocupar mais com a limpeza."
trophy_room.cleanliness.regional_bad[1] = "O seu hospital é o mais sujo da regiäo. Outros diretores conseguiram manter os seus hospitais mais limpos. Você é a vergonha da profissäo médica."
trophy_room.happy_vips.trophies[1] = "Ganhou o Prêmio Nobel de VIP Exemplares. Todos os que visitaram o seu hospital no ano passado o elogiaram muito."
trophy_room.happy_vips.trophies[2] = "A Agência de Pessoas Famosas deseja-lhe conceder o Prêmio à Celebridade por ter agradado a todos os VIP que visitaram o seu hospital."
trophy_room.happy_vips.trophies[3] = "Ganhou a VIAGEM VIP por melhorar a imagem dos trabalhadores aos olhos de todos os que visitaram o seu hospital. Estupendo!"
trophy_room.gen_repairs.awards[1] = "Foi-lhe concedido um prêmio especial pela diligência dos seus zeladores na hora de manter as máquinas do seu hospital em bom estado. Muito bem. Tire umas férias."
trophy_room.gen_repairs.awards[2] = "Os seus zeladores trabalharam melhor que os de qualquer outro hospital. Este é um importante acontecimento de felicidade."
trophy_room.gen_repairs.awards[3] = "As suas máquinas estäo em um magnífico estado. A dedicaçäo dos seus zeladores foi extraordinária. Merecem este prestigioso prêmio. Um trabalho estupendo!"
trophy_room.gen_repairs.penalty[1] = "Os seus zeladores näo cuidaram bem das suas máquinas. Deveria fiscalizá-los melhor ou contratar mais para que façam o trabalho melhor."
trophy_room.gen_repairs.penalty[2] = "Näo fez uma boa manutençäo. Os seus funcionários deveriam cuidar melhor dos seus equipamentos."
trophy_room.many_cured.penalty[1] = "O seu hospital näo cura com eficácia os pacientes que o necessitam. Tenha mais atençäo às curas para que sejam mais eficazes."
trophy_room.many_cured.penalty[2] = "O seu hospital é o menos eficaz na hora de curar pacientes. Decepcionou o Ministério e defraudou a si mesmo. Näo diremos mais."
trophy_room.many_cured.trophies[1] = "Parabéns pela concessäo do prêmio Marie Curie por ter curado quase todos os pacientes do seu hospital no ano passado."
trophy_room.many_cured.trophies[2] = "A Fundaçäo Nacional de Curas deseja premiá-lo por ter curado um grande número de pacientes no ano passado, concedendo o Galardäo ao Maior Curador."
trophy_room.many_cured.trophies[3] = "Foi-lhe concedida a Medalha do Paciente Säo por ter conseguido curar no seu hospital uma enorme porcentagem de pacientes no ano passado."
trophy_room.many_cured.awards[1] = "Parabéns por curar um montäo de pessoas no ano passado. Um grande número de pessoas sente-se muito melhor, graças ao seu trabalho."
trophy_room.many_cured.awards[2] = "Pedimos que aceite este prêmio por ter curado mais pacientes que qualquer outro hospital. Um excelente trabalho."
trophy_room.many_cured.regional[1] = "Você recebeu o prêmio de cura total por ter curado mais pessoas do que todos os outros hospitais juntos."
trophy_room.sold_drinks.trophies[1] = "A Associaçäo Odontológica orgulha-se de lhe conceder este troféu e esta placa por vender um montäo de bebidas em lata no seu hospital."
trophy_room.sold_drinks.trophies[2] = "O seu hospital foi premiado com o prêmio Bizz-Efervescente pela Venda de Refrigerante em reconhecimento ao número de bebidas vendidas em seu hospital no ano passado."
trophy_room.sold_drinks.trophies[3] = "Em nome de DK Obturaçöes Inc., você recebe o prêmio coberto de chocolate para celebrar a enorme quantidade de refrigerantes que vendeu no seu hospital este ano."
trophy_room.consistant_rep.trophies[1] = "O Conselho de Ministros concedeu-lhe a Mençäo de Honra por ter alcançado o nível máximo de eficácia e reputaçäo durante o ano presente. Muito bem."
trophy_room.consistant_rep.trophies[2] = "Parabéns pela concessäo do Prêmio Lençóis Limpos por ser o hospital com a melhor reputaçäo do ano. Você mereceu."
trophy_room.cash = "EFETIVO"
trophy_room.high_rep.penalty[1] = "Vai ser sancionado pela má reputaçäo que teve no ano passado. Procure melhorar no futuro."
trophy_room.high_rep.penalty[2] = "A reputaçäo do seu hospital é a pior da área. É uma vergonha. Melhore ou consiga outro emprego."
trophy_room.high_rep.awards[1] = "Muito bem! Ganhou um pequeno prêmio por alcançar uma impressionante reputaçäo no ano passado."
trophy_room.high_rep.awards[2] = "Maravilhoso! O seu hospital ganhou um prêmio por conseguir a melhor reputaçäo no ano passado."
trophy_room.high_rep.regional[1] = "Por favor, aceite o Prêmio Bullfrog por dirigir o melhor hospital do ano. Você mereceu, aproveite."
trophy_room.high_rep.regional[2] = "Este ano, a reputaçäo do seu hospital superou a do resto dos hospitais. Um estupendo lucro."
trophy_room.best_value_hosp.trophies[1] = "Parabéns pela concessäo do Prêmio Lençóis Limpos por ser o hospital com a melhor reputaçäo do ano. Você mereceu."
trophy_room.best_value_hosp.regional[1] = "Parabéns por ter o hospital mais valioso do jogo. Bom trabalho! Por favor, continue assim."
trophy_room.best_value_hosp.penalty[1] = "Todos os hospitais da área valem mais do que o seu. Faça algo a respeito desta vergonhosa situaçäo. Consiga coisas mais caras!"
trophy_room.reputation = "REPUTAÇAO"
trophy_room.happy_staff.regional_good[1] = "Os seus funcionários säo os mais satisfeitos de todos os hospitais. Se os funcionários estäo contentes, há mais ganhos e menos mortes. No Ministério estäo satisfeitos."
trophy_room.happy_staff.penalty[1] = "Os seus funcionários desejam que saiba que estäo muito descontentes. Ter bons funcionários é muito proveitoso. Faça com que eles estejam mais satisfeitos ou algum dia irá perdê-los."
trophy_room.happy_staff.trophies[1] = "Ganhou o Prêmio Médico Sorridente por manter o mais contente possível os seus funcionários."
trophy_room.happy_staff.trophies[2] = "A Fundaçäo para a Felicidade do Pessoal Sanitário concedeu-lhe este galardäo por näo ter tido trabalhadores descontentes no seu hospital no ano passado."
trophy_room.happy_staff.trophies[3] = "Concedemos a você o prêmio Monopoliza do Sorriso Radiante por manter contente todos os seus funcionários, mais à frente do cumprimento do dever, durante o ano passado."
trophy_room.happy_staff.awards[1] = "Sua equipe te concedeu um prêmio. Eles dizem que, em geral, você manda muito bem."
trophy_room.happy_staff.awards[2] = "Seus funcionários säo täo felizes trabalhando para você que näo conseguem tirar os sorrisos dos seus rostos. Você é um gerente magnífico."
trophy_room.happy_staff.regional_bad[1] = "A sua equipe esteve muito infeliz durante o ano passado. Você deveria ter notado. Do jeito que está, as equipes dos outros hospitais estäo muito mais contentes do que a sua."
trophy_room.hosp_value.penalty[1] = "O seu hospital fracassou em alcançar um valor razoável. Gerenciou mal o dinheiro. Lembre-se, um bom hospital também é um hospital caro."
trophy_room.hosp_value.awards[1] = "O Ministério da Saúde gostaria de parabenizá-lo pelo impressionante valor alcançado em seu hospital."
trophy_room.hosp_value.regional[1] = "É uma promessa dos negócios. O hospital é o mais valioso de toda a área."
trophy_room.healthy_plants.awards[1] = "Parabéns por ganhar o galardäo do Grande Fertilizante por manter as suas plantas vivas durante o ano passado."
trophy_room.healthy_plants.trophies[1] = "Os Amigos das Plantas de Interior desejam lhe conceder o Prêmio de Saúde Verde por manter vivas as suas plantas durante os últimos doze meses."
trophy_room.healthy_plants.trophies[2] = "Salvem as Plantas quer concede-lhe o Prêmio do Maior Ecologista por manter vivas as plantas do seu hospital durante o ano passado."
trophy_room.research.penalty[1] = "Foi pouco eficiente ao investigar curas, máquinas e remédios novos. Isto é fatal, já que o avanço tecnológico é algo fundamental."
trophy_room.research.regional_good[1] = "As suas pesquisas conseguiram colocar o seu hospital nos últimos avanços de hoje em dia. Os seus pesquisadores merecem este prêmio. Muito bem!"
trophy_room.research.awards[1] = "As suas pesquisas conseguiram colocar o seu hospital nos últimos avanços de hoje em dia. Os seus pesquisadores merecem este prêmio. Muito bem!"
trophy_room.research.awards[2] = "No ano passado, descobriu mais remédios e máquinas do que se podia esperar. Por favor, aceite este prêmio de todos nós no Ministério."
trophy_room.research.regional_bad[1] = "Outros hospitais säo melhores que o seu na pesquisa. No Ministério estäo furiosos, seu hospital deveria lhe conceder mais importância."
trophy_room.no_deaths.penalty[1] = "O número de mortes no seu hospital, no ano passado, foi muito elevado. Coloque mais atençäo ao seu trabalho. Assegure-se de que no futuro sobreviva mais pessoas."
trophy_room.no_deaths.penalty[2] = "O seu hospital é um risco para os pacientes. Supöe-se que deve curar muitas pessoas, näo deixar morrer."
trophy_room.no_deaths.trophies[1] = "Ganhou o Prêmio de Ausência de Reclamaçöes por manter 100%% dos seus pacientes com vida no ano passado."
trophy_room.no_deaths.trophies[2] = "A Associaçäo A Vida Continua concede-lhe este prêmio pela ausência de falecimentos no seu hospital este ano."
trophy_room.no_deaths.trophies[3] = "Você recebeu o Prêmio pela Conservaçäo da Vida por ter conseguido evitar falecimentos no seu hospital durante este ano. Genial!"
trophy_room.no_deaths.awards[1] = "Ganhou este prêmio como reconhecimento ao seu baixo índice de falecimentos no hospital este ano. É estupendo!"
trophy_room.no_deaths.awards[2] = "A sua habilidade conseguiu reduzir ao mínimo o número de mortes no seu hospital. Deve estar muito feliz com este resultado."
trophy_room.no_deaths.regional[1] = "No ano passado, a taxa de mortalidade do seu hospital foi inferior a dos outros. Por favor, aceite este prêmio."
trophy_room.rats_accuracy.trophies[1] = "Você recebeu o Prêmio de Disparos Certeiros Syndicate Wars por acertar em %d%% ratos no seu hospital no ano passado."
trophy_room.rats_accuracy.trophies[2] = "Este prêmio é para celebrar a sua incrível pontaria ao eliminar %d%% dos ratos que disparou no seu hospital no ano passado."
trophy_room.rats_accuracy.trophies[3] = "Para celebrar o fato de que eliminou %d%% dos ratos do seu hospital, foi-lhe concedido o Troféu de Eliminador de Roedores. Parabéns!"
trophy_room.emergencies.penalty[1] = "Foi muito pouco eficiente nos casos de emergência. Os pacientes de emergência merecem uma atençäo rápida e precisa, que você näo lhes deu."
trophy_room.emergencies.award[1] = "Parabéns! Ganhou este prêmio pela maneira eficaz e eficiente com a qual solucionou as emergências. Bom trabalho."
trophy_room.emergencies.award[2] = "Confrontou as emergências de uma maneira extraordinária. Ganhou este prêmio por ser o melhor na hora de lidar com uma grande quantidade de pacientes."
trophy_room.emergencies.regional_good[1] = "O Ministério reconhece que no ano passado, no seu hospital, você tratou as emergências melhor do que qualquer outro hospital, entäo lhe concedeu este prêmio."
trophy_room.emergencies.regional_bad[1] = "O seu hospital é o pior da regiäo para tratar casos de emergência. Tem a culpa de ocupar o último lugar na Liga Local de Tratamentos de Emergência."
trophy_room.curesvdeaths.awards[1] = "Os meus mais sinceros parabéns. No ano passado, o número de curas foi superior ao de falecimentos no seu hospital."
trophy_room.curesvdeaths.penalty[1] = "A sua proporçäo entre curas e mortes é extremamente baixa. Deveria assegurar-se de que cura mais pessoas do que mata. Näo deixe os seus funcionários em má situaçäo."
trophy_room.wait_times.award[1] = "Parabéns! No seu hospital, a espera dos pacientes foi muito curta. Este é um acontecimento importante."
trophy_room.wait_times.penalty[1] = "No seu hospital, os pacientes esperam muito tempo. Há sempre filas inaceitáveis. Poderia tratar os seus pacientes com mais eficácia se quisesse."
trophy_room.happy_patients.awards[1] = "Deve estar orgulhoso de que, no ano passado, as pessoas estiveram muito contentes com o seu hospital."
trophy_room.happy_patients.awards[2] = "Os pacientes que visitaram o seu hospital sentiram-se mais contentes com o seu tratamento do que em outros hospitais."
trophy_room.happy_patients.penalty[1] = "As pessoas que väo ao hospital têm uma experiência terrível. Terá que melhorar muito se quiser ganhar o respeito do Ministério."
trophy_room.happy_patients.penalty[2] = "As pessoas que receberam tratamento no seu hospital queixaram-se do estado do mesmo. Deveria considerar muito mais o bem-estar dos pacientes."
trophy_room.pop_percentage.awards[1] = "Note, no ano passado, curou uma grande parte da populaçäo local no seu hospital. Muito bem."
trophy_room.pop_percentage.awards[2] = "Parabéns! A maioria da populaçäo local vai ao seu hospital em vez de a qualquer outra instituiçäo."
trophy_room.pop_percentage.awards[3] = "Brilhante! O seu hospital recebeu o maior número de pacientes que todos os outros hospitais juntos."
trophy_room.pop_percentage.penalty[1] = "Teve muito poucos pacientes este ano. Para ganhar dinheiro, precisa que haja pacientes que paguem."
trophy_room.pop_percentage.penalty[2] = "Todos os hospitais da área conseguiram mais pacientes do que você. Deveria estar envergonhado."
trophy_room.rats_killed.trophies[1] = "Você recebeu o Troféu Raticida por eliminar %s ratos no seu hospital no ano passado."
trophy_room.rats_killed.trophies[2] = "Você merece este prêmio da Federaçäo Anti-Ratos pela sua excepcional habilidade em eliminar ratos, demonstrada ao eliminar %s exemplares."
trophy_room.rats_killed.trophies[3] = "Você recebeu o Troféu Acaba com Ratos pela sua grande habilidade em eliminar %d ratos no seu hospital no ano passado."
trophy_room.all_cured.awards[1] = "Parabéns por ter ganho o Prêmio Marie Curie por curar todos os pacientes do seu hospital no ano passado."
trophy_room.all_cured.trophies[1] = "A Fundaçäo Curadores Nacionais premia-o por ter curado todos os pacientes do seu hospital no ano passado, concedendo-lhe o Prêmio do Maior Curador."
trophy_room.all_cured.trophies[2] = "Você recebeu a Medalha do Paciente Säo por ter conseguido curar todos os pacientes do seu hospital no ano passado."
graphs.cures = "Curas"
graphs.reputation = "Reputaçäo"
graphs.balance = "Balanço"
graphs.wages = "Salários"
graphs.visitors = "Visitantes"
graphs.time_spans[1] = "1 Ano"
graphs.time_spans[2] = "12 Anos"
graphs.time_spans[3] = "48 Anos"
graphs.deaths = "Mortes"
graphs.money_out = "Pagamento"
graphs.money_in = "Crédito"
queue_window.max_queue_size = "Máximo"
queue_window.num_expected = "Previsto"
queue_window.num_in_queue = "Tamanho da fila"
queue_window.num_entered = "Pacientes totais"
room_classes.clinics = "Clínica"
room_classes.facilities = "Instalaçöes"
room_classes.diagnosis = "Diagnóstico"
room_classes.treatment = "Tratamento"
rooms_short.ward = "Enfermaria"
rooms_short.blood_machine = "Transfusöes"
rooms_short.fracture_clinic = "Traumatologia"
rooms_short.cardiogram = "Cardiologia"
rooms_short.decontamination = "Descontaminaçäo"
rooms_short.jelly_vat = "Banho Gelatinoso"
rooms_short.staffroom = "Sala de Descanso"
rooms_short.hair_restoration = "Pêloterapia"
rooms_short.inflation = "Inflatoterapia"
rooms_short.operating_theatre = "Sala de Cirurgia"
rooms_short.reception = "Recepçäo"
rooms_short.gps_office = "Consultório de CG"
rooms_short.training_room = "Formaçäo"
rooms_short.x_ray = "Raio-X"
rooms_short.tongue_clinic = "Laringologia"
rooms_short.general_diag = "Diagnóstico Geral"
rooms_short.ultrascan = "Ultra Scanner"
rooms_short.dna_fixer = "Genética"
rooms_short.psychiatric = "Psiquiatria"
rooms_short.toilets = "Banheiro"
rooms_short.corridor_objects = "Objetos do Corredor"
rooms_short.pharmacy = "Farmácia"
rooms_short.destroyed = "Destruída"
rooms_short.research_room = "Centro de Pesquisa"
rooms_short.scanner = "Scanner"
rooms_short.electrolysis = "Eletrólise"
tooltip.status.warmth = "Nível global de calor das pessoas no seu hospital"
tooltip.status.close = "Fechar tela de condiçäo"
tooltip.status.thirst = "Nível global de sede das pessoas no seu hospital"
tooltip.status.population = "Você precisa ter %d%% da populaçäo total vindo para o seu hospital"
tooltip.status.num_cured = "O objetivo é curar %d pessoas. Até agora curou %d"
tooltip.status.percentage_killed = "O objetivo é matar pelo menos %d%% dos seus pacientes. Até agora morreram %d%%"
tooltip.status.percentage_cured = "Você precisa tratar %d%% dos visitantes do seu hospital. Até agora tratou %d%%"
tooltip.status.win_progress_own = "Mostra o progresso para conquistar os critérios do seu próprio hospital"
tooltip.status.value = "O seu hospital deve valer $%d. Agora vale $%d"
tooltip.status.happiness = "Nível global de satisfaçäo das pessoas no seu hospital"
tooltip.status.win_progress_other = "Mostra o progresso para conquistar os critérios de %s"
tooltip.status.population_chart = "Gráfico que mostra a proporçäo de pacientes de cada hospital da cidade"
tooltip.objects.bench = "Banco: serve de assento aos pacientes para que esperem com mais conforto."
tooltip.objects.pharmacy_cabinet = "Farmácia: onde se guardam os remédios"
tooltip.objects.console = "15 CONSOLES DE SCANNER"
tooltip.objects.atom_analyser = "Misturador químico: situado no Dept. de Desenvolvimento, esta máquina acelera todo o processo de pesquisa."
tooltip.objects.fire_extinguisher = "Extintor: reduz o perigo do mau funcionamento das máquinas."
tooltip.objects.scanner = "14 SCANNERS"
tooltip.objects.bin = "Cesto de papéis: os pacientes atiram aqui os seus desperdícios."
tooltip.objects.swing_door1 = "52 PORTAS DUPLAS 1"
tooltip.objects.pool_table = "Mesa de bilhar: ajuda os seus funcionários a relaxarem."
tooltip.objects.screen = "16 TELAS"
tooltip.objects.cabinet = "Armário: contém fichas dos pacientes, notas e documentos sobre pesquisa."
tooltip.objects.sofa = "Sofá: os funcionários que descansam na Sala de Descanso sentaräo em um sofá, a menos que tenham uma maneira melhor de relaxar."
tooltip.objects.projector = "37 PROJETORES"
tooltip.objects.table2 = "12 MESAS"
tooltip.objects.shower = "54 DUCHAS DESCONTAMINADORAS"
tooltip.objects.comfortable_chair = "61 CADEIRAS DE LEITURA"
tooltip.objects.door = "Porta: as pessoas fecham e abrem um montäo de vezes."
tooltip.objects.computer = "Computador: componente chave para a pesquisa"
tooltip.objects.litter_bomb = "Bomba de lixo: sabota os hospitais dos oponentes"
tooltip.objects.entrance_left = "58 PORTAS DIREITAS DE ENTRADA"
tooltip.objects.dna_fixer = "23 REPARADORES DE DNA"
tooltip.objects.bed = "Cama: as pessoas que estejam mesmo doentes deitam-se nela."
tooltip.objects.lamp = "Abajur: ilumina e permite que o pessoal veja."
tooltip.objects.bookcase = "Livraria: material de consulta para os médicos."
tooltip.objects.desk = "Escritório: é fundamental para que o médico coloque o seu PC."
tooltip.objects.toilet_sink = "Pia: os seus pacientes mais limpos lavam as suas mäos sujas aqui. Se näo houver suficientes pias, os pacientes ficam infelizes."
tooltip.objects.gates_of_hell = "48 PORTAS DO INFERNO"
tooltip.objects.swing_door2 = "53 PORTAS DUPLAS 2"
tooltip.objects.cast_remover = "24 REMOVEDORES DE GESSO"
tooltip.objects.plant = "Planta: alegra os pacientes e purifica o ar."
tooltip.objects.blood_machine = "42 TRANSFUSIOMETROS"
tooltip.objects.slicer = "26 CORTADORES"
tooltip.objects.x_ray = "27 RAIOS-X"
tooltip.objects.cardio = "13 ELETROCARDIOGRAMAS"
tooltip.objects.crash_trolley = "20 CARROS"
tooltip.objects.bed2 = "näo se utiliza"
tooltip.objects.electrolyser = "46 ELETROLISIS"
tooltip.objects.video_game = "Videogame: deixe que os seus funcionários se divirtam com o Hi-Octane."
tooltip.objects.skeleton = "Esqueleto: é utilizado para aprender e na Noite do Halloween."
tooltip.objects.ultrascanner = "22 ULTRA SCANNERS"
tooltip.objects.op_sink1 = "33 PIAS 1 OP"
tooltip.objects.hair_restorer = "25 RESTAURADORES DE CABELO"
tooltip.objects.reception_desk = "Recepçäo: requer uma recepcionista para que envie os pacientes para o médico."
tooltip.objects.radiation_shield = "28 TELAS ANTI-RADIACAO"
tooltip.objects.couch = "18 POLTRONAS"
tooltip.objects.inflator = "Inflador: cura a cabeça inflada."
tooltip.objects.toilet = "Banheiro: a natureza uma hora chama..."
tooltip.objects.lecture_chair = "Cadeira de leitura: os médicos que estäo estudando sentam-se aqui para tomar notas, aborrecer-se e rabiscar desnecessariamente. Quantas mais cadeiras colocar, mais compridas as aulas seräo."
tooltip.objects.auto_autopsy = "Autópsia: uma grande ajuda para descobrir novas curas."
tooltip.objects.chair = "Cadeira: os pacientes sentam-se sobre ela e falam das suas doenças."
tooltip.objects.x_ray_viewer = "29 TELAS DE RAIOS-X"
tooltip.objects.radiator = "Radiador: evita que o seu hospital fique frio."
tooltip.objects.bed3 = "näo se utiliza"
tooltip.objects.surgeon_screen = "35 TELAS DE CIRURGIAO"
tooltip.objects.jelly_moulder = "47 BANHOS GELATINOSOS"
tooltip.objects.drinks_machine = "Máquina de bebidas: impede que os pacientes tenham sede e contribui com ganhos."
tooltip.objects.op_sink2 = "34 PIAS 2 OP"
tooltip.objects.table1 = "Mesa: sobre ela coloca-se um montäo de revistas para que os pacientes esperem contentes."
tooltip.objects.entrance_right = "59 PORTAS ESQUERDAS DE ENTRADA"
tooltip.objects.operating_table = "30 MESAS DE OPERACAO"
tooltip.objects.tv = "TV: assegura que os seus funcionários näo percam os seus programas favoritos."
tooltip.watch.hospital_opening = "Cronômetro de construçäo: é o tempo que resta para que o seu hospital seja declarado aberto. Se apertar o botäo IR, abrirá o hospital imediatamente."
tooltip.watch.epidemic = "Epidemia: tempo que resta para encobrir a epidemia. Quando este tempo expire ou um paciente contagioso abandone o seu hospital, um Inspetor de Saúde vem visitar. O botäo liga ou desliga o modo vacina. Aperte em um paciente para que uma Enfermeira o vacine."
tooltip.watch.emergency = "Emergência: tempo que resta para curar todos os pacientes nas emergências."
tooltip.buy_objects_window.increase = "Comprar mais um objeto"
tooltip.buy_objects_window.price = "Preço do objeto"
tooltip.buy_objects_window.confirm = "Comprar objeto(s)"
tooltip.buy_objects_window.cancel = "Cancelar"
tooltip.buy_objects_window.decrease = "Comprar menos um objeto"
tooltip.buy_objects_window.total_value = "Custo total dos objetos solicitados"
tooltip.machine_window.status = "Estado das máquinas."
tooltip.machine_window.close = "Cancelar caixa de diálogo"
tooltip.machine_window.repair = "Mandar o zelador reparar as máquinas."
tooltip.machine_window.name = "Nome"
tooltip.machine_window.times_used = "Número de vezes que reparou as máquinas."
tooltip.machine_window.replace = "Substituir máquinas"
tooltip.pay_rise_window.accept = "Satisfazer a sua demanda salarial"
tooltip.pay_rise_window.decline = "Näo pagar; despedir"
tooltip.staff_window.psychiatrist = "Psiquiatra"
tooltip.staff_window.close = "Cancelar caixa de diálogo"
tooltip.staff_window.sack = "Despedir"
tooltip.staff_window.name = "Nome do empregado"
tooltip.staff_window.pick_up = "Selecionar"
tooltip.staff_window.tiredness = "Nível de cansaço"
tooltip.staff_window.ability = "Nível de qualificaçäo"
tooltip.staff_window.researcher = "Pesquisador"
tooltip.staff_window.skills = "Qualificaçöes especiais"
tooltip.staff_window.salary = "Salário mensal"
tooltip.staff_window.happiness = "Nível de satisfaçäo"
tooltip.staff_window.doctor_seniority = "Categoria - Residente, Médico ou Consultor"
tooltip.staff_window.surgeon = "Cirurgiäo"
tooltip.research.cure_dec = "Reduzir a porcentagem dos equipamentos de cura"
tooltip.research.close = "Fechar tela de pesquisa"
tooltip.research.diagnosis_inc = "Aumentar a porcentagem dos equipamentos de diagnóstico"
tooltip.research.cure_inc = "Aumentar a porcentagem dos equipamentos de cura"
tooltip.research.specialisation_inc = "Aumentar a porcentagem em pesquisa especial"
tooltip.research.diagnosis_dec = "Reduzir a porcentagem dos equipamentos de diagnóstico"
tooltip.research.improvements_inc = "Aumentar a porcentagem nas melhorias"
tooltip.research.drugs_dec = "Reduzir a porcentagem da pesquisa farmacêutica"
tooltip.research.specialisation_dec = "Reduzir a porcentagem em pesquisa especial"
tooltip.research.improvements_dec = "Reduzir a porcentagem nas melhorias"
tooltip.research.drugs_inc = "Aumentar a porcentagem da pesquisa farmacêutica"
tooltip.research.allocated_amount = "Quantidade do orçamento alocado"
tooltip.statement.close = "Fechar tela do estado das contas"
tooltip.rooms.ward = "As Enfermarias säo úteis tanto para diagnosticar como para tratamento. Envie aqui os pacientes para observaçäo e para recuperar de uma operaçäo sob o cuidado de uma enfermeira."
tooltip.rooms.blood_machine = "O médico usa o Transfusiômetro para diagnosticar os pacientes"
tooltip.rooms.fracture_clinic = "A enfermeira utiliza a consulta de traumatologia para arrumar fraturas"
tooltip.rooms.cardiogram = "O médico usa a cardiologia para diagnosticar os pacientes"
tooltip.rooms.decontamination = "O médico usa a ducha descontaminadora para curar a radioatividade"
tooltip.rooms.jelly_vat = "O médico usa o Banho Gelatinoso para curar a gelatinite"
tooltip.rooms.staffroom = "Os médicos e as enfermeiras descansam na Sala de Descanso"
tooltip.rooms.hair_restoration = "O médico usa o Pêlo-restaurador para curar a calvície"
tooltip.rooms.inflation = "O médico usa a Inflatoterapia para curar a cabeça inflada"
tooltip.rooms.gps_office = "Os pacientes recebem seu primeiro atendimento no Consultório de Clínica Geral"
tooltip.rooms.training_room = "A Sala de Formaçäo com um consultor serve para formar outros médicos"
tooltip.rooms.x_ray = "O médico usa Raio-X para diagnosticar os pacientes"
tooltip.rooms.general_diag = "O médico utiliza a sala de Diagnóstico Geral para fazer um diagnóstico básico. É barato e frequentemente eficaz"
tooltip.rooms.operating_theatre = "Na Sala de Cirurgia faltam dois cirurgiöes qualificados"
tooltip.rooms.ultrascan = "O médico usa o Ultra-scanner para diagnosticar os pacientes"
tooltip.rooms.psychiatry = "A Psiquiatria cura os pacientes loucos e ajuda a diagnosticar outros pacientes, mas requer um médico qualificado em psiquiatria."
tooltip.rooms.toilets = "Construa Banheiros para impedir que os pacientes armem uma confusäo no seu hospital!"
tooltip.rooms.dna_fixer = "O médico usa o Reparador de DNA para curar os pacientes com DNA alienígena"
tooltip.rooms.pharmacy = "Na Enfermaria, a enfermeira administra remédios para curar os pacientes"
tooltip.rooms.tongue_clinic = "O médico usa a Laringologia para curar a língua comprida"
tooltip.rooms.research_room = "Os médicos pesquisadores investigam remédios e máquinas novas no Centro de Pesquisa"
tooltip.rooms.scanner = "O médico usa o Scanner para diagnosticar os pacientes"
tooltip.rooms.electrolysis = "O médico usa a consulta de eletrólise para curar o peludismo"
tooltip.policy.diag_procedure = "Se o diagnóstico de um médico é menos seguro que a porcentagem de ENVIAR PARA CASA, o paciente será enviado para casa. Se o diagnóstico for melhor que a porcentagem de TENTAR CURA, será administrado o tratamento adequado ao paciente"
tooltip.policy.staff_leave = "Aperte aqui para que os funcionários livres ajudem os companheiros que precisem"
tooltip.policy.close = "Fechar tela de normas"
tooltip.policy.staff_rest = "Nível de cansaço dos funcionários antes de poderem descansar"
tooltip.policy.diag_termination = "O diagnóstico de um paciente continuará até que os médicos estejam seguros da porcentagem de PARAR PROCESSO, ou até que sejam utilizados todos os diagnósticos"
tooltip.policy.staff_stay = "Aperte aqui para assegurar que o funcionário fique nas consultas que foram atribuídas a ele"
tooltip.main_menu.load_menu.empty_slot = "VAZIO"
tooltip.main_menu.load_menu.load_slot = "JOGO"
tooltip.main_menu.network = "Iniciar um jogo em rede"
tooltip.staff_list.psychiatrist = "Psiquiatra qualificado"
tooltip.staff_list.close = "Fechar gerenciamento de funcionários"
tooltip.staff_list.happiness_2 = "Moral do empregado"
tooltip.staff_list.ability = "Mostra o nível de habilidade destes empregados"
tooltip.staff_list.tiredness_2 = "Cansaço do empregado"
tooltip.staff_list.ability_2 = "Nível de habilidade do empregado"
tooltip.staff_list.salary = "Salário atual pago a esta pessoa"
tooltip.staff_list.researcher_train = "Formado um %d%% para ser Pesquisador"
tooltip.staff_list.happiness = "Mostra o quanto contentes estäo estes empregados"
tooltip.staff_list.sack = "Despedir esta pessoa"
tooltip.staff_list.surgeon = "Cirurgiäo qualificado"
tooltip.staff_list.view_staff = "Ver a pessoa trabalhando"
tooltip.staff_list.surgeon_train = "Formado um %d%% para ser Cirurgiäo"
tooltip.staff_list.tiredness = "Mostra o quanto cansados estäo estes empregados"
tooltip.staff_list.receptionists = "Ver a lista das recepcionistas contratadas neste hospital"
tooltip.staff_list.pay_rise = "Subir o salário desta pessoa em 10%"
tooltip.staff_list.bonus = "Pagar a esta pessoa um bônus de 10%"
tooltip.staff_list.doctor_seniority = "Experiência do médico"
tooltip.staff_list.nurses = "Ver a lista das enfermeiras contratadas neste hospital"
tooltip.staff_list.skills = "Outras qualificaçöes"
tooltip.staff_list.detail = "Cuidar os detalhes"
tooltip.staff_list.doctors = "Ver a lista dos médicos contratados neste hospital"
tooltip.staff_list.handymen = "Ver a lista dos zeladores contratados neste hospital"
tooltip.staff_list.researcher = "Pesquisador qualificado"
tooltip.staff_list.psychiatrist_train = "Formado um %d%% para ser Psiquiatra"
tooltip.place_objects_window.confirm = "Confirmar"
tooltip.place_objects_window.buy_sell = "Comprar/vender objetos"
tooltip.place_objects_window.pick_up = "Pegar objeto"
tooltip.place_objects_window.cancel = "Cancelar"
tooltip.casebook.increase = "Aumentar quantidade"
tooltip.casebook.reputation = "Reputaçäo de curas ou diagnósticos"
tooltip.casebook.close = "Fechar ficha clínica"
tooltip.casebook.earned_money = "Ganhos até a data"
tooltip.casebook.decrease = "Reduzir quantidade"
tooltip.casebook.up = "Subir"
tooltip.casebook.research = "Clique aqui para utilizar o orçamento de Pesquisa Especializada para este tratamento"
tooltip.casebook.down = "Baixar"
tooltip.casebook.sent_home = "Número de pacientes dados alta"
tooltip.casebook.cured = "Número de restabelecimentos"
tooltip.casebook.deaths = "Número de falecimentos"
tooltip.casebook.treatment_charge = "Preço"
tooltip.casebook.cure_type.psychiatrist = "Os psiquiatras realizam este tratamento"
tooltip.casebook.cure_type.drug_percentage = "Este tratamento requer um remédio. O seu tem uma eficácia de %d%%"
tooltip.casebook.cure_type.drug = "Este tratamento requer um remédio"
tooltip.casebook.cure_type.machine = "É preciso de uma máquina para este tratamento"
tooltip.casebook.cure_type.surgery = "Esta doença requer cirurgia"
tooltip.casebook.cure_requirement.hire_staff_old = "Você precisa contratar um %s para este tratamento"
tooltip.casebook.cure_requirement.not_possible = "Näo pode administrar este tratamento"
tooltip.casebook.cure_requirement.hire_surgeon = "Você precisa contratar um segundo cirurgiäo para que realize operaçöes"
tooltip.casebook.cure_requirement.build_ward = "Você precisa construir uma Enfermaria para administrar este tratamento"
tooltip.casebook.cure_requirement.possible = "Pode administrar este tratamento"
tooltip.casebook.cure_requirement.build_room = "Você precisa construir uma consulta para dar este tratamento"
tooltip.casebook.cure_requirement.hire_surgeons = "Você precisa contratar dois cirurgiöes para as operaçöes"
tooltip.casebook.cure_requirement.research_machine = "Precisa inventar alguma máquina para este tratamento."
tooltip.casebook.cure_requirement.ward_hire_nurse = "Você precisa de uma enfermeira que trabalhe na Enfermaria para administrar este tratamento"
tooltip.patient_window.center_view = "Enfocar a pessoa"
tooltip.patient_window.warmth = "Quanto calor tem a pessoa"
tooltip.patient_window.close = "Cancelar caixa de diálogo"
tooltip.patient_window.send_home = "Dar alta à pessoa"
tooltip.patient_window.thirst = "Quanta sede tem a pessoa"
tooltip.patient_window.graph = "Clique para escolher entre o gráfico do estado de saúde da pessoa ou o seu histórico clínico"
tooltip.patient_window.queue = "Ver detalhes da pessoa que faz fila"
tooltip.patient_window.happiness = "Satisfaçäo da pessoa"
tooltip.patient_window.casebook = "Ver detalhes da doença da pessoa"
tooltip.patient_window.abort_diagnosis = "Colocar a pessoa em tratamento em vez de esperar que complete o diagnóstico"
tooltip.town_map.fire_extinguishers = "Alternar extintores"
tooltip.town_map.people = "Alternar pessoas"
tooltip.town_map.balance = "Saldo"
tooltip.town_map.objects = "Alternar objetos"
tooltip.town_map.heat_inc = "Subir aquecimento"
tooltip.town_map.heating_bill = "Recibo de aquecimento"
tooltip.town_map.heat_level = "Nível de aquecimento"
tooltip.town_map.radiators = "Alternar radiadores"
tooltip.town_map.plants = "Alternar plantas"
tooltip.town_map.heat_dec = "Baixar aquecimento"
tooltip.town_map.close = "Fechar mapa da cidade"
tooltip.graphs.cures = "Alternar curas"
tooltip.graphs.reputation = "Alternar o valor do hospital"
tooltip.graphs.close = "Fechar tela de gráficos"
tooltip.graphs.balance = "Alternar saldo"
tooltip.graphs.wages = "Alternar salários"
tooltip.graphs.visitors = "Alternar visitantes"
tooltip.graphs.money_in = "Alternar crédito"
tooltip.graphs.deaths = "Alternar mortes"
tooltip.graphs.scale = "Tabela de gráficos"
tooltip.graphs.money_out = "Alternar gastos"
tooltip.toolbar.policy = "Normas"
tooltip.toolbar.status = "Condiçäo"
tooltip.toolbar.research = "Pesquisa"
tooltip.toolbar.hire = "Contratar funcionários"
tooltip.toolbar.bank_button = "Aperte o botäo esquerdo para o diretor do banco e o direito para o saldo bancário"
tooltip.toolbar.charts = "Gráficos"
tooltip.toolbar.balance = "O seu saldo"
tooltip.toolbar.edit = "Editar salas e objetos"
tooltip.toolbar.date = "A data"
tooltip.toolbar.rooms = "Construir salas"
tooltip.toolbar.staff_list = "Gerenciamento de funcionários"
tooltip.toolbar.town_map = "Mapa da cidade"
tooltip.toolbar.casebook = "Ficha clínica"
tooltip.toolbar.reputation = "A sua reputaçäo"
tooltip.toolbar.objects = "Colocar objetos de corredor"
tooltip.queue_window.patient_dropdown.reception = "Enviar paciente à Recepçäo"
tooltip.queue_window.patient_dropdown.hospital_1 = "Enviar o paciente para outro hospital"
tooltip.queue_window.patient_dropdown.send_home = "Dar alta ao paciente"
tooltip.queue_window.patient_dropdown.hospital_3 = "Enviar o paciente para outro hospital"
tooltip.queue_window.patient_dropdown.hospital_2 = "Enviar o paciente para outro hospital"
tooltip.queue_window.close = "Fechar esta caixa de diálogo"
tooltip.queue_window.num_expected = "Número de pacientes que a recepcionista calcula que logo faräo fila"
tooltip.queue_window.front_of_queue = "Arraste um paciente para este ícone para colocá-lo no início da fila"
tooltip.queue_window.dec_queue_size = "Reduzir o máximo do tamanho da fila"
tooltip.queue_window.num_in_queue = "Número de pacientes em fila"
tooltip.queue_window.num_entered = "Número de pacientes que foram tratados nesta consulta até agora"
tooltip.queue_window.max_queue_size = "Tamanho máximo da fila que permite a recepcionista"
tooltip.queue_window.inc_queue_size = "Aumentar o máximo do tamanho da fila"
tooltip.queue_window.end_of_queue = "Arraste um paciente para este ícone para colocá-lo no final da fila"
tooltip.queue_window.patient = "Arraste um paciente para colocá-lo na fila. Clique com o botäo direito sobre um paciente para mandá-lo para a fila ou para um hospital rival"
tooltip.bank_manager.graph = "Gráfico dos pagamentos esperados de %s"
tooltip.bank_manager.close = "Fechar tela do gerente do banco"
tooltip.bank_manager.balance = "O seu saldo bancário"
tooltip.bank_manager.borrow_5000 = "Pedir $5000 ao banco"
tooltip.bank_manager.hospital_value = "Valor atual do seu hospital"
tooltip.bank_manager.insurance_owed = "Quantidade de dinheiro que lhe deve %s"
tooltip.bank_manager.interest_payment = "Pagamentos dos juros mensais"
tooltip.bank_manager.repay_5000 = "Devolver $5000 ao banco"
tooltip.bank_manager.graph_return = "Voltar para a tela anterior"
tooltip.bank_manager.interest_rate = "Taxa de juro anual"
tooltip.bank_manager.inflation_rate = "Taxa de inflaçäo anual"
tooltip.bank_manager.show_graph = "Mostrar o gráfico dos pagamentos esperados de %s"
tooltip.bank_manager.current_loan = "Empréstimos pendentes"
tooltip.jukebox.play = "Ligar jukebox"
tooltip.jukebox.stop = "Parar jukebox"
tooltip.jukebox.close = "Fechar jukebox"
tooltip.jukebox.fast_forward = "Avançar rapidamente no jukebox"
tooltip.jukebox.rewind = "Retroceder no jukebox"
tooltip.jukebox.current_title = "Máquina de discos"
tooltip.jukebox.loop = "Funcionamento contínuo da máquina de discos"
tooltip.build_room_window.cost = "Preço da consulta selecionada"
tooltip.build_room_window.room_classes.treatment = "Selecione consultas de tratamentos gerais"
tooltip.build_room_window.room_classes.facilities = "Selecione instalaçöes especiais"
tooltip.build_room_window.room_classes.diagnosis = "Selecione consultas de diagnóstico"
tooltip.build_room_window.room_classes.clinic = "Selecione clínicas especializadas"
tooltip.build_room_window.close = "Sair desta caixa de diálogo e voltar para o jogo"
tooltip.hire_staff_window.surgeon = "Cirurgiäo"
tooltip.hire_staff_window.psychiatrist = "Psiquiatra"
tooltip.hire_staff_window.qualifications = "Outras habilidades do médico"
tooltip.hire_staff_window.receptionists = "Ver as recepcionistas que pode contratar"
tooltip.hire_staff_window.hire = "Contratar pessoa"
tooltip.hire_staff_window.nurses = "Ver as enfermeiras que pode contratar"
tooltip.hire_staff_window.doctor_seniority = "Experiência médica (Residente, Médico, Consultor)"
tooltip.hire_staff_window.cancel = "Cancelar"
tooltip.hire_staff_window.researcher = "Pesquisador"
tooltip.hire_staff_window.prev_person = "Ver pessoa anterior"
tooltip.hire_staff_window.salary = "Salário"
tooltip.hire_staff_window.staff_ability = "Qualificaçäo dos funcionários"
tooltip.hire_staff_window.doctors = "Ver os médicos que pode contratar"
tooltip.hire_staff_window.next_person = "Ver pessoa seguinte"
tooltip.hire_staff_window.handymen = "Ver os zeladores que pode contratar"
tooltip.handyman_window.center_view = "Enfocar o zelador"
tooltip.handyman_window.close = "Cancelar caixa de diálogo"
tooltip.handyman_window.sack = "Despedir"
tooltip.handyman_window.name = "Nome do zelador"
tooltip.handyman_window.pick_up = "Apanhar"
tooltip.handyman_window.prio_litter = "Aumentar a prioridade do zelador para a limpeza"
tooltip.handyman_window.ability = "Qualificaçäo"
tooltip.handyman_window.prio_machines = "Aumentar a prioridade do zelador para reparar as máquinas"
tooltip.handyman_window.salary = "Salário"
tooltip.handyman_window.face = "Face do zelador"
tooltip.handyman_window.happiness = "Satisfaçäo"
tooltip.handyman_window.tiredness = "Cansaço"
tooltip.handyman_window.prio_plants = "Aumentar a prioridade do zelador para regar as plantas"
tooltip.window_general.cancel = "Cancelar"
tooltip.window_general.confirm = "Confirmar"
adviser.earthquake.ended = "Nossa! Acreditei que ia ser o pior de todos! Alcançou um %d na Escala Richter."
adviser.earthquake.damage = "Por causa do terremoto há %d máquinas danificadas e %d pessoas feridas no hospital."
adviser.earthquake.alert = "Perigo de terremoto! As suas máquinas podem danificar-se durante o terremoto se näo tiverem uma boa manutençäo."
adviser.staff_place_advice.only_psychiatrists = "Os Médicos só podem trabalhar em uma sala de psiquiatria se estiverem qualificados para isso."
adviser.staff_place_advice.doctors_cannot_work_in_room = "Os Médicos näo podem trabalhar em %s"
adviser.staff_place_advice.only_researchers = "Os Médicos só podem trabalhar em um Centro de Pesquisa se estiverem qualificados para isso."
adviser.staff_place_advice.nurses_cannot_work_in_room = "As Enfermeiras näo podem trabalhar em %s"
adviser.staff_place_advice.only_surgeons = "Os Médicos só podem trabalhar em uma Sala de Cirurgia se estiverem qualificados para isso."
adviser.staff_place_advice.receptionists_only_at_desk = "As Recepcionistas só podem trabalhar na Recepçäo."
adviser.staff_place_advice.only_doctors_in_room = "Apenas Médicos podem trabalhar em %s"
adviser.staff_place_advice.only_nurses_in_room = "Só Enfermeiras podem trabalhar na %s"
adviser.competitors.staff_poached = "Um dos seus funcionários recebeu uma boa oferta de trabalho de outro hospital."
adviser.competitors.land_purchased = "%s acaba de comprar terrenos."
adviser.competitors.hospital_opened = "%s, da concorrência, abriu um hospital na área."
adviser.epidemic.hurry_up = "Se näo acabar com esta epidemia rapidamente, terá muitos problemas. Aja agora!"
adviser.epidemic.multiple_epidemies = "Parece que há mais de uma epidemia ao mesmo tempo. Isto pode ser desastroso; faça algo rapidamente."
adviser.epidemic.serious_warning = "Esta doença contagiosa está começando a ser grave. Você precisa agir rapidamente!"
adviser.warnings.patients_unhappy = "Os pacientes näo gostam do seu hospital. Você deve fazer algo para melhorá-lo."
adviser.warnings.too_much_litter = "Há um problema com a limpeza. Mais zeladores säo a soluçäo."
adviser.warnings.patients_very_thirsty = "Os pacientes estäo com muita sede. Se você näo colocar algumas máquinas de bebidas logo, eles iräo embora do seu hospital para tomar algo refrescante."
adviser.warnings.queue_too_long_at_reception = "Há muitos pacientes esperando por reservas na recepçäo. Adicione outra recepçäo e contrate mais uma recepcionista."
adviser.warnings.patients_thirsty = "As pessoas estäo começando a ter sede. Talvez você devesse colocar algumas máquinas de bebidas."
adviser.warnings.nurses_tired = "As suas enfermeiras estäo cansadas. Mande-as descansar agora mesmo."
adviser.warnings.patients_too_hot = "Os pacientes estäo com muito calor. Retire alguns radiadores, diminua a temperatura ou coloque mais máquinas de bebidas."
adviser.warnings.patients_thirsty2 = "As pessoas estäo reclamando de sede. Você deveria colocar mais máquinas de bebidas ou aproximar as que já existem."
adviser.warnings.machines_falling_apart = "Suas máquinas estäo caindo aos pedaços. Chame a manutençäo para repará-las."
adviser.warnings.financial_trouble3 = "O seu saldo está preocupante. Tome uma açäo efetiva. Você está a %d do desastre."
adviser.warnings.nurses_tired2 = "As suas enfermeiras estäo extremamente cansadas. Faça com que elas descansem imediatamente."
adviser.warnings.people_have_to_stand = "Há pacientes de pé. Faça-os sentar já!"
adviser.warnings.handymen_tired = "Os seus zeladores estäo muito cansados. Mande-os descansar agora mesmo."
adviser.warnings.change_priorities_to_plants = "Você precisa alterar as prioridades dos seus zeladores para que eles dediquem mais tempo ao cuidado das plantas."
adviser.warnings.staff_tired = "Os seus funcionários estäo incrivelmente cansados. Se näo os deixar descansar um momento em uma Sala de Descanso, alguns poderäo cair de esgotamento."
adviser.warnings.some_litter = "Os zeladores podem recolher todo esse lixo antes que se torne um problema grave."
adviser.warnings.cash_low_consider_loan = "As suas finanças estäo ruins. Já considerou um empréstimo?"
adviser.warnings.reduce_staff_rest_threshold = "Tente alterar o Tempo de Descanso dos funcionários na tela de Normas para que possam descansar mais frequentemente. É só uma sugestäo."
adviser.warnings.build_staffroom = "Construa uma Sala de Descanso o mais rápido possível. Seus funcionários estäo trabalhando demais e estäo à beira do colapso. Seja razoável!"
adviser.warnings.many_epidemics = "Parece que há mais de uma epidemia ao mesmo tempo. Isto pode ser desastroso; faça algo rapidamente."
adviser.warnings.build_toilets = "Construa um banheiro imediatamente ou você verá algo muito desagradável. E pode imaginar como ficará o cheiro do seu hospital."
adviser.warnings.staff_overworked = "Os seus empregados estäo sobrecarregados. Estäo perdendo eficácia e começaräo a cometer erros desastrosos."
adviser.warnings.doctors_tired2 = "Os seus médicos estäo exaustos. Eles precisam descansar imediatamente."
adviser.warnings.queues_too_long = "Há muitas filas de pacientes."
adviser.warnings.staff_unhappy = "Os seus funcionários estäo descontentes. Dê-lhes um pagamento extra ou, ainda melhor, construa uma Sala de Descanso para eles. Você também pode ajustar o tempo de descanso na tela de Normas."
adviser.warnings.patient_leaving = "Há um paciente indo embora. A causa? A má administraçäo e a péssima qualidade dos seus funcionários e equipamentos."
adviser.warnings.patient_stuck = "Alguém ficou preso. Planeje melhor o layout do seu hospital."
adviser.warnings.receptionists_tired = "As suas recepcionistas estäo extenuadas. Mande-as descansar imediatamente."
adviser.warnings.charges_too_low = "Você está cobrando muito barato. Terá pacientes no seu hospital, mas eles näo contribuiräo com muito lucro."
adviser.warnings.epidemic_getting_serious = "Esta doença contagiosa está começando a ser grave. Você precisa agir rapidamente!"
adviser.warnings.patients_really_thirsty = "Os pacientes estäo com muita sede. Coloque mais máquinas de bebidas ou aproxime as existentes das filas mais longas."
adviser.warnings.patients_annoyed = "As pessoas estäo extremamente insatisfeitas com a forma como você está administrando o hospital. Näo pode alegar falta de culpa. Resolva o problema ou enfrente as consequências!"
adviser.warnings.place_plants3 = "Os pacientes estäo descontentes. Coloque mais plantas para animá-los."
adviser.warnings.machinery_deteriorating = "As suas máquinas estäo começando a se deteriorar devido ao uso excessivo. Fique de olho nelas."
adviser.warnings.place_plants4 = "Alegre os pacientes colocando mais plantas."
adviser.warnings.money_very_low_take_loan = "O seu saldo bancário está muito baixo. Considere pedir um empréstimo."
adviser.warnings.finanical_trouble2 = "Consiga algum crédito ou estará acabado. Perderá o nível se perder outros %d."
adviser.warnings.patients_very_cold = "Os pacientes estäo com muito frio. Aumente o aquecimento ou coloque mais radiadores no seu hospital."
adviser.warnings.deal_with_epidemic_now = "Se você näo resolver esta epidemia imediatamente, terá muitos problemas. Aja rápido!"
adviser.warnings.litter_catastrophy = "O problema da sujeira é grave. Coloque vários zeladores para trabalhar agora mesmo!"
adviser.warnings.litter_everywhere = "Há sujeira por toda parte. Coloque mais zeladores para trabalhar."
adviser.warnings.machinery_slightly_damaged = "A maquinaria do seu hospital está um pouco danificada. Näo se esqueça de repará-la."
adviser.warnings.patients_getting_hot = "Os pacientes estäo com muito calor. Diminua o aquecimento ou retire alguns radiadores."
adviser.warnings.no_patients_last_month = "No último mês, näo vieram novos pacientes ao seu hospital. Horrível!"
adviser.warnings.many_killed = "Você matou %d pacientes. Acho que precisa melhorar, näo?"
adviser.warnings.build_toilet_now = "Construa banheiros imediatamente. As pessoas näo aguentam mais. Näo é uma piada, é grave."
adviser.warnings.people_freezing = "Que horrível! Nesta era de aquecimento central, alguns dos seus pacientes estäo se congelando. Coloque radiadores e aumente o aquecimento."
adviser.warnings.place_plants_to_keep_people = "As pessoas estäo indo embora. Se você colocasse mais plantas, poderia convencê-los a ficar."
adviser.warnings.patients_leaving = "Os pacientes estäo indo embora. Melhore seu hospital colocando plantas, bancos, máquinas de bebidas, etc., para os seus visitantes."
adviser.warnings.doctors_tired = "Os seus médicos estäo exaustos. Mande-os descansar imediatamente."
adviser.warnings.charges_too_high = "Os seus preços estäo muito altos. Você terá grandes benefícios a curto prazo, mas a longo prazo ficará sem pacientes."
adviser.warnings.financial_trouble = "Você tem sérios problemas financeiros. Ajuste suas finanças agora! Se perder outros %d, terá arruinado este nível!"
adviser.warnings.reception_bottleneck = "Há um gargalo na recepçäo. Contrate outra recepcionista."
adviser.warnings.pay_back_loan = "Você tem dinheiro de sobra. Por que näo quita o seu empréstimo?"
adviser.warnings.nobody_cured_last_month = "No mês passado, näo houve nenhuma cura."
adviser.warnings.queue_too_long_send_doctor = "As filas de %s estäo muito longas. Certifique-se de que há um médico na sala."
adviser.warnings.staff_too_hot = "Os seus empregados estäo com muito calor. Diminua a temperatura ou retire alguns radiadores das suas consultas."
adviser.warnings.place_plants2 = "Os pacientes estäo indo embora. Com mais plantas, você poderia fazer com que eles ficassem mais tempo."
adviser.warnings.doctor_crazy_overwork = "Oh näo! Um dos seus médicos ficou louco devido ao excesso de trabalho. Ele se recuperará se descansar agora mesmo."
adviser.warnings.machinery_damaged = "Repare as suas máquinas o mais rápido possível. Elas estäo prestes a se quebrar."
adviser.warnings.more_benches = "Você poderia colocar mais bancos. Os pacientes reclamam por ter que ficar de pé."
adviser.warnings.bankruptcy_imminent = "Ei! Você está prestes a ficar sem máquinas. Tome cuidado!"
adviser.warnings.need_toilets = "Os pacientes precisam de banheiros. Coloque-os em um local acessível."
adviser.warnings.more_toilets = "Você precisa de mais banheiros. As pessoas näo aguentam mais."
adviser.warnings.plants_dying = "As suas plantas estäo secando. Elas precisam de água. Contrate mais zeladores para cuidar disso. Os pacientes näo gostam de plantas mortas."
adviser.warnings.people_did_it_on_the_floor = "Alguns dos seus pacientes näo aguentam mais. Alguém terá que limpar sem parar."
adviser.warnings.need_staffroom = "Construa uma sala de descanso para que seus empregados possam relaxar."
adviser.warnings.plants_thirsty = "Você precisa cuidar das suas plantas. Elas estäo secando."
adviser.warnings.too_many_plants = "Você tem muitas plantas. Está parecendo uma selva."
adviser.warnings.receptionists_tired2 = "As suas recepcionistas estäo exaustas. Deixe-as descansar agora mesmo."
adviser.warnings.machine_severely_damaged = "%s está prestes a se quebrar."
adviser.warnings.machinery_very_damaged = "É uma emergência! Faça com que um zelador repare as suas máquinas imediatamente. Elas estäo prestes a explodir!"
adviser.warnings.hospital_is_rubbish = "As pessoas estäo dizendo abertamente que seu hospital é uma porcaria. Elas logo se queixaräo em outro lugar."
adviser.warnings.handymen_tired2 = "Os seus zeladores estäo cansados. Mande-os descansar imediatamente."
adviser.warnings.machinery_damaged2 = "Você precisa contratar um zelador para reparar as suas máquinas rapidamente."
adviser.warnings.staff_very_cold = "O pessoal está reclamando do frio. Aumente o aquecimento ou coloque mais radiadores."
adviser.warnings.desperate_need_for_watering = "Você precisa desesperadamente contratar um zelador para cuidar das suas plantas."
adviser.warnings.staff_unhappy2 = "Os seus funcionários, no geral, estäo descontentes. Em breve, pediräo mais dinheiro."
adviser.staff_advice.too_many_nurses = "Você está contratando muitas enfermeiras."
adviser.staff_advice.need_handyman_litter = "Os pacientes estäo sujando o seu hospital. Contrate um zelador para se encarregar da limpeza."
adviser.staff_advice.need_nurses = "Contrate mais enfermeiras. Na enfermaria e na farmácia, faltam enfermeiras."
adviser.staff_advice.need_doctors = "Você precisa de mais médicos. Tente colocar os seus melhores médicos nas consultas com mais pacientes."
adviser.staff_advice.too_many_doctors = "Você tem muitos médicos. Alguns estäo desocupados no momento."
adviser.staff_advice.need_handyman_machines = "Você precisará contratar um zelador se quiser que as máquinas do seu hospital funcionem."
adviser.staff_advice.need_handyman_plants = "Contrate um zelador para regar as plantas."
adviser.praise.few_have_to_stand = "Quase ninguém fica de pé no seu hospital. Os seus pacientes estäo contentes."
adviser.praise.patients_cured = "%d pacientes curados."
adviser.praise.plants_are_well = "Muito bem. Você está cuidando bem das suas plantas. Excelente."
adviser.praise.plenty_of_benches = "Há muitos assentos, assim näo há problema."
adviser.praise.plants_thriving = "Muito bem. As suas plantas estäo muito viçosas. Têm um aspecto maravilhoso. Mantenha-as assim e você poderá ganhar um prêmio por isso."
adviser.praise.many_benches = "Agora seus pacientes têm assentos suficientes. Muito bem!"
adviser.praise.many_plants = "Fantástico! Você tem muitas plantas. Seus pacientes väo agradecer."
adviser.surgery_requirements.need_surgeons_ward_op = "Você precisa contratar dois cirurgiöes e construir uma enfermaria e uma sala de cirurgia para realizar operaçöes."
adviser.surgery_requirements.need_surgeon_ward = "Você precisa contratar mais um cirurgiäo e construir uma enfermaria para poder realizar operaçöes."
adviser.multiplayer.objective_completed = "Você completou o objetivo. Parabéns!"
adviser.multiplayer.objective_failed = "Você näo conseguiu completar o objetivo."
adviser.multiplayer.everyone_failed = "Todos falharam em satisfazer aquele último objetivo."
adviser.multiplayer.players_failed = "Os seguintes jogadores falharam em alcançar o último objetivo: "
adviser.multiplayer.poaching.not_interested = "Ha! Näo está interessado em trabalhar para você. Está contente onde está."
adviser.multiplayer.poaching.already_poached_by_someone = "Nem pensar! Alguém já está tentando contratar essa pessoa!"
adviser.multiplayer.poaching.in_progress = "Eu o informarei se essa pessoa quiser trabalhar para você."
adviser.research.new_drug_researched = "Um novo medicamento para curar %s foi descoberto."
adviser.research.new_machine_researched = "Você pesquisou com êxito %s."
adviser.research.drug_fully_researched = "Você pesquisou 100%% de %s."
adviser.research.drug_improved = "O seu Centro de Pesquisa melhorou o medicamento para %s."
adviser.research.new_available = "Já está disponível um novo %s."
adviser.research.machine_improved = "O Centro de Pesquisa trouxe melhorias para %s."
adviser.research.autopsy_discovered_rep_loss = "Foi descoberta uma máquina de autópsias. Aguarde uma reaçäo desfavorável das pessoas."
adviser.information.emergency = "Há uma emergência! Mexa-se! Mexa-se! Mexa-se!"
adviser.information.handyman_adjust = "Você pode fazer com que o zelador limpe melhor se estabelecer as suas prioridades."
adviser.information.promotion_to_specialist = "Um dos seus médicos foi promovido a %s."
adviser.information.pay_rise = "Um funcionário ameaça se demitir. Você pode atender à sua petiçäo ou demiti-lo. Clique no último ícone da esquerda para ver quem deseja demitir."
adviser.information.first_death = "Acabou de perder o seu primeiro paciente. Como se sente?"
adviser.information.fax_received = "O ícone que apareceu no canto inferior esquerdo da tela alerta você sobre uma informaçäo importante ou a necessidade de tomar uma decisäo."
adviser.information.promotion_to_consultant = "Um dos seus médicos foi promovido a CONSULTOR."
adviser.information.patient_abducted = "Os alienígenas raptaram um dos seus pacientes."
adviser.information.vip_arrived = "Cuidado! %s acabou de chegar para visitar o seu hospital! Faça com que tudo funcione bem para agradá-lo."
adviser.information.extra_items = "Os funcionários ficam mais confortáveis e melhoram seu desempenho se você adicionar itens complementares nas salas."
adviser.information.epidemic_health_inspector = "O Ministério da Saúde soube da epidemia em seu hospital. Prepare-se para a visita de um Inspetor de Saúde."
adviser.information.first_cure = "Muito bem! Você curou o seu primeiro paciente."
adviser.information.epidemic = "Há uma doença contagiosa no seu hospital. Você precisa resolvê-la imediatamente!"
adviser.information.patient_leaving_too_expensive = "Um paciente está indo embora sem pagar %s. É muito dinheiro."
adviser.information.place_windows = "Se você colocar janelas, as salas teräo mais luz e seus funcionários ficaräo mais felizes."
adviser.information.initial_general_advice.first_patients_thirsty = "Os pacientes estäo com sede. Coloque máquinas de bebidas."
adviser.information.initial_general_advice.epidemic_spreading = "Há uma doença contagiosa no seu hospital. Tente curar os pacientes infectados antes que eles possam ir embora."
adviser.information.initial_general_advice.research_now_available = "Você construiu seu primeiro centro de pesquisa. Agora pode acessar a tela de pesquisa."
adviser.information.initial_general_advice.autopsy_available = "Foi inventada uma máquina de autópsias. Com ela, você poderá eliminar os pacientes problemáticos e investigar seus restos. Tome cuidado, o uso desta máquina é polêmico."
adviser.information.initial_general_advice.rats_have_arrived = "Os ratos invadiram seu hospital. Tente eliminá-los com o mouse."
adviser.information.initial_general_advice.surgeon_symbol = "Os médicos especializados em cirurgia usam o símbolo: {"
adviser.information.initial_general_advice.machine_needs_repair = "Há uma máquina que precisa ser reparada. Encontre a máquina e clique sobre ela. Em seguida, clique no botäo do zelador."
adviser.information.initial_general_advice.research_symbol = "Os médicos pesquisadores usam o símbolo: }"
adviser.information.initial_general_advice.decrease_heating = "As pessoas estäo com calor no seu hospital. Diminua o aquecimento. Isso é feito na tela de mapa da cidade."
adviser.information.initial_general_advice.taking_your_staff = "Alguém está subornando sua equipe. Você terá que discutir com eles para que fiquem."
adviser.information.initial_general_advice.first_VIP = "Você receberá seu primeiro visitante VIP. Certifique-se de que o VIP näo veja nada sujo nem pacientes insatisfeitos."
adviser.information.initial_general_advice.increase_heating = "As pessoas estäo com frio. Ligue o aquecimento na tela de mapa da cidade."
adviser.information.initial_general_advice.psychiatric_symbol = "Os médicos especializados em psiquiatria usam o símbolo: |"
adviser.information.initial_general_advice.first_epidemic = "Há uma epidemia no seu hospital! Decida se quer tratá-la ou liberá-la."
adviser.information.initial_general_advice.place_radiators = "As pessoas estäo com frio no seu hospital. Você pode colocar mais radiadores selecionando-os no menu de mobiliário do corredor."
adviser.information.initial_general_advice.first_emergency = "Os pacientes de emergência têm uma luz azul piscando sobre a cabeça. Cure-os antes que morram ou que o tempo limite se esgote."
adviser.information.promotion_to_doctor = "Um dos seus residentes foi promovido a MEDICO."
adviser.information.larger_rooms = "Se você construir salas maiores, seus funcionários se sentiräo mais importantes e melhoraräo seu desempenho."
adviser.goals.win.value = "AUMENTE O VALOR DO SEU HOSPITAL EM %d"
adviser.goals.win.reputation = "AUMENTE A SUA REPUTAÇAO EM %d PARA SATISFAZER O NIVEL DO CRITÉRIO PARA GANHAR"
adviser.goals.win.cure = "Cure mais %d paciente(s) e terá curado os suficientes para ganhar este nível."
adviser.goals.win.money = "Você precisa de outros %d para alcançar o critério financeiro deste nível."
adviser.build_advice.door_not_reachable = "As pessoas näo poderäo passar por essa porta. Pense sobre isto."
adviser.build_advice.blueprint_would_block = "Essa marca azul tapará outras consultas. Tente alterar o tamanho ou coloque em outro local!"
adviser.build_advice.placing_object_blocks_door = "Se colocar este objeto aí, impedirá que se possa acessar alguma porta."
adviser.build_advice.blueprint_invalid = "Esta marca azul näo é válida."
adviser.level_progress.three_quarters_won = "Falta 75%% para superar este nível."
adviser.level_progress.reputation_good_enough = "De acordo, a sua reputaçäo é muito boa para ganhar este nível, mantenha acima de %d e resolva outros problemas para terminar."
adviser.level_progress.nearly_won = "Falta muito pouco para superar este nível."
adviser.level_progress.hospital_value_enough = "Mantenha o valor do seu hospital acima de %d e atenda os seus outros problemas para ganhar o nível."
adviser.level_progress.improve_reputation = "Você precisa melhorar a sua reputaçäo em %d para ter uma oportunidade de ganhar o nível."
adviser.level_progress.halfway_won = "Falta 50%% para superar este nível."
adviser.level_progress.close_to_win_increase_value = "Está próximo da vitória. Aumente o valor do seu hospital em $%d."
adviser.level_progress.another_patient_cured = "Muito bem! Outro paciente curado. Isto faz um total de %d curados."
adviser.level_progress.nearly_lost = "Falta muito pouco para perder este nível."
adviser.level_progress.three_quarters_lost = "Falta 75%% para perder este nível."
adviser.level_progress.dont_kill_more_patients = "Näo pode permitir deixar que morram mais pacientes!"
adviser.level_progress.cured_enough_patients = "Curou muitos pacientes, mas precisa manter o seu hospital em melhor estado para ganhar o nível."
adviser.level_progress.financial_criteria_met = "Tem satisfeito o critério financeiro deste nível. Agora mantenha o seu saldo acima de %d, enquanto assegura que o hospital funcione eficazmente."
adviser.level_progress.halfway_lost = "Falta 50%% para perder este nível."
adviser.level_progress.another_patient_killed = "Oh, näo! Matou outro paciente. Agora há um total de %d mortes."
adviser.vomit_wave.started = "Parece que tem um vírus de vômitos no seu hospital. Isto näo teria acontecido se o tivesse mantido limpo. Talvez devesse contratar um zelador."
adviser.vomit_wave.ended = "Ufa! Parece que o vírus que causou essa epidemia de vômitos está controlado. No futuro, mantenha o seu hospital limpo."
adviser.placement_info.staff_cannot_place = "Näo pode colocar este funcionário aqui. Desculpe."
adviser.placement_info.room_cannot_place_2 = "Näo pode colocar a consulta aqui."
adviser.placement_info.object_cannot_place = "Eh! Näo pode colocar aqui este objeto."
adviser.placement_info.object_can_place = "Pode colocar este objeto aqui."
adviser.placement_info.door_can_place = "Se quiser, pode colocar a porta aqui."
adviser.placement_info.reception_cannot_place = "Näo pode colocar a Recepçäo aqui."
adviser.placement_info.door_cannot_place = "Desculpe, mas näo pode colocar aqui a porta."
adviser.placement_info.window_cannot_place = "Ah! Näo pode colocar a janela aqui."
adviser.placement_info.staff_can_place = "Pode colocar este funcionário aqui."
adviser.placement_info.window_can_place = "Pode colocar a janela aqui. Está bem."
adviser.placement_info.reception_can_place = "Näo pode colocar aqui a Recepçäo."
adviser.placement_info.room_cannot_place = "Näo pode colocar aqui a consulta."
adviser.boiler_issue.maximum_heat = "A caldeira do poräo ficou danificada. Os radiadores estäo no máximo. As pessoas väo derreter! Seria bom que colocasse mais máquinas de bebidas."
adviser.boiler_issue.minimum_heat = "Ah, aí está! A caldeira do poräo ficou danificada. Parece que dentro de pouco tempo as pessoas väo congelar no seu hospital!"
adviser.boiler_issue.resolved = "Boas notícias. A caldeira e os radiadores voltaram a funcionar corretamente. Os seus pacientes e os seus funcionários desfrutaräo de uma boa temperatura."
adviser.tutorial.build_reception = "Você precisa de uma Recepçäo no seu hospital. Escolha uma do menu de mobiliário do corredor."
adviser.tutorial.click_and_drag_to_build = "Aperte o botäo esquerdo e arraste para desenhar a sala."
adviser.tutorial.window_in_invalid_position = "Esta janela está mal colocada. Tente colocá-la em outro lugar da parede."
adviser.tutorial.room_in_invalid_position = "Esta marca azul näo é válida. As áreas vermelhas assinalam onde ocupou parte de outro quarto ou das paredes do hospital."
adviser.tutorial.choose_receptionist = "Clique no ícone que pisca para contratar a recepcionista que escolheu."
adviser.tutorial.place_doctor = "Coloque o médico na consulta."
adviser.tutorial.build_gps_office = "É imprescindível um médico para diagnosticar os doentes."
adviser.tutorial.select_doctors = "Clique no ícone que pisca para ver os médicos que pode contratar."
adviser.tutorial.click_gps_office = "Clique na linha que pisca para escolher o Consultório Geral."
adviser.tutorial.prev_receptionist = "Clique no ícone que pisca para ver a recepcionista disponível anterior."
adviser.tutorial.information_window = "A funçäo de ajuda proporciona toda a informaçäo sobre a consulta que acabou de construir."
adviser.tutorial.place_receptionist = "Mova a recepcionista e coloque-a no seu lugar."
adviser.tutorial.confirm_room = "Clique no ícone que pisca para abrir a consulta ou cancelar para voltar para o passo anterior."
adviser.tutorial.doctor_in_invalid_position = "Näo pode colocar o médico aqui."
adviser.tutorial.place_objects = "Aperte o botäo esquerdo para colocar os objetos, e o direito para fazê-los girar."
adviser.tutorial.hire_receptionist = "Agora você precisa de uma recepcionista para atender os seus pacientes."
adviser.tutorial.hire_doctor = "Você precisa de um médico para diagnosticar e atender os seus pacientes."
adviser.tutorial.room_too_small_and_invalid = "A marca azul é muito pequena e está mal colocada."
adviser.tutorial.receptionist_invalid_position = "Näo pode colocar a sua recepcionista aqui."
adviser.tutorial.door_in_invalid_position = "Tentou colocar a porta em um lugar incorreto. Tente em outro lugar da grade azul."
adviser.tutorial.next_receptionist = "Clique no ícone que pisca para ver a seguinte recepcionista disponível."
adviser.tutorial.object_in_invalid_position = "Este objeto está mal colocado. Por favor, coloque em outro lugar ou tente girar."
adviser.tutorial.choose_doctor = "Veja as habilidades de cada médico antes de escolher um."
adviser.tutorial.rotate_and_place_reception = "Coloque a Recepçäo e aperte o botäo direito do mouse para girá-la."
adviser.tutorial.accept_purchase = "Clique com o botäo esquerdo no ícone que pisca para colocá-lo."
adviser.tutorial.room_too_small = "A marca azul desta sala é muito pequena. Arraste-a ou aumente o seu tamanho."
adviser.tutorial.room_big_enough = "A marca azul é agora suficientemente grande. Se quiser, pode movê-la ou colocá-la."
adviser.tutorial.start_tutorial = "Leia as instruçöes. Quando terminar, aperte o botäo esquerdo do mouse para começar o tutorial."
adviser.tutorial.place_door = "Mova o mouse ao redor das paredes marcadas de azul para colocar a porta."
adviser.tutorial.select_receptionists = "Clique no ícone que pisca para ver as recepcionistas que estäo disponíveis."
adviser.tutorial.order_one_reception = "Clique na linha que pisca com o botäo esquerdo do mouse para comprar uma Recepçäo."
adviser.tutorial.place_windows = "Coloque as janelas da mesma forma que a porta. Se näo quiser janelas, näo tem que as colocar."
adviser.tutorial.select_diagnosis_rooms = "Clique com o botäo esquerdo no ícone que pisca para ver a lista de salas de diagnóstico."
adviser.tutorial.reception_invalid_position = "A Recepçäo ficou cinzenta porque näo é possível colocá-la aqui. Mova ou gire-a."
adviser.tutorial.build_pharmacy = "Parabéns! Agora, construa uma farmácia e contrate uma enfermeira para que o seu hospital funcione."
adviser.room_requirements.pharmacy_need_nurse = "Contrate uma enfermeira para a farmácia."
adviser.room_requirements.op_need_two_surgeons = "Contrate dois cirurgiöes para a Sala de Cirurgia."
adviser.room_requirements.training_room_need_consultant = "Você precisará contratar um especialista para dar conferências nesta Sala de Formaçäo."
adviser.room_requirements.research_room_need_researcher = "Você precisará contratar um médico pesquisador para utilizar o centro de pesquisa."
adviser.room_requirements.op_need_ward = "É necessário construir uma Enfermaria para os pacientes que väo ser operados."
adviser.room_requirements.reception_need_receptionist = "Você precisa contratar uma recepcionista para atender seus pacientes."
adviser.room_requirements.op_need_another_surgeon = "Você precisa contratar um outro cirurgiäo para usar a Sala de Cirurgia."
adviser.room_requirements.gps_office_need_doctor = "Contrate um médico para o Consultório de Clínica Geral."
adviser.room_requirements.ward_need_nurse = "Contrate uma enfermeira para trabalhar na Enfermaria."
adviser.room_requirements.psychiatry_need_psychiatrist = "Agora que construiu uma sala de psiquiatria, você precisará de um psiquiatra."
introduction_texts.level6 = "Utilize toda a sua capacidade para criar um hospital que funcione bem, cure muitos pacientes e trate qualquer caso que apareça.//Este ambiente é especialmente propenso a germes e infecçöes. A menos que mantenha uma limpeza rigorosa na sua instituiçäo, enfrentará uma série de epidemias entre os pacientes. Procure obter um lucro de $20.000 e fazer o valor do seu hospital superar os $140.000."
introduction_texts.level3 = "Desta vez, o seu hospital estará em uma área rica.//O Ministério da Saúde espera que você cure muitos pacientes. Ganhe uma boa reputaçäo para começar, e uma vez que o hospital comece a funcionar, concentre-se em ganhar o máximo de dinheiro possível. Também pode haver emergências, que ocorrem quando muitos pacientes chegam com a mesma doença. Se você os curar dentro de um prazo determinado, aumentará sua reputaçäo e ganhará um grande extra. Você precisará construir uma Sala de Cirurgia e uma Enfermaria para tratar doenças como o complexo de rei. Ganhe $20.000 para superar este nível."
introduction_texts.level14 = "Você enfrentará mais um desafio: um hospital surpresa totalmente imprevisível. Se conseguir ter êxito, será o vencedor dos vencedores. E näo espere que seja fácil, pois é a tarefa mais difícil que você enfrentará. Boa sorte!"
introduction_texts.level5 = "Este será um hospital concorrido, que tratará casos muito variados.//Seus médicos säo recém-formados, entäo é fundamental construir uma Sala de Formaçäo para que eles atinjam o nível necessário. Você só tem três especialistas para treinar seus funcionários inexperientes, entäo mantenha-os satisfeitos. O hospital está localizado sobre a falha geológica de San Android, e sempre há risco de terremotos. Os terremotos causaräo danos significativos às suas máquinas e afetaräo o bom funcionamento do seu hospital. Aumente sua reputaçäo para 400 e obtenha $50.000 para vencer. Além disso, cure 200 pacientes."
introduction_texts.level1 = "Bem-vindo ao seu primeiro hospital!//Para fazê-lo funcionar, coloque uma Recepçäo, construa um Consultório de Clínica Geral e contrate uma recepcionista e um médico. Em seguida, espere que os pacientes cheguem. Seria uma boa ideia construir uma Psiquiatria e contratar um psiquiatra. Uma Farmácia e uma enfermeira säo fundamentais para curar seus pacientes. Cuidado com os casos malignos de cabeça inflada; eles säo tratados na Sala de Inflatoterapia. Cure 10 pessoas e assegure-se de que sua reputaçäo näo seja inferior a 200."
introduction_texts.level7 = "Aqui, você estará sob a estrita vigilância do Ministério da Saúde, entäo faça com que suas contas reflitam excelentes lucros e aumente sua reputaçäo.//Näo podemos permitir mortes desnecessárias; elas näo beneficiam o negócio. Certifique-se de que seus funcionários estejam em plena forma e que você tenha todos os equipamentos necessários. Alcance uma reputaçäo de 600 e um saldo bancário de $200.000."
introduction_texts.level4 = "Mantenha seus pacientes felizes e trate-os com a maior eficácia possível, reduzindo ao máximo o número de óbitos.//Sua reputaçäo está em jogo, entäo procure aumentá-la ao máximo. Näo se preocupe muito com dinheiro, pois você o ganhará mais rápido à medida que sua reputaçäo cresce. A partir de agora, você poderá treinar seus médicos e ampliar seus conhecimentos, permitindo-os curar pacientes com enfermidades mais difíceis. Alcance uma reputaçäo acima de 500."
introduction_texts.level18 = ""
introduction_texts.level13 = "Sua incrível habilidade como diretor do hospital chamou a atençäo da Divisäo Secreta Especial do Serviço Secreto Especial. Tenho um trabalho especial para você. Há um hospital infestado de ratos que precisa de um exterminador eficiente. Você deve eliminar todos os ratos antes que o pessoal de Manutençäo limpe toda a sujeira. Você acha que está à altura dessa missäo?"
introduction_texts.level8 = "Depende apenas de você construir o hospital mais rentável e eficiente possível.//As pessoas aqui säo bastante ricas, entäo tente arrecadar o máximo possível. Lembre-se que curar as pessoas é importante, mas o que PRECISAMOS é do dinheiro delas. Arranque todo o dinheiro dos pacientes. Acumule a enorme quantia de $300.000 para completar este nível."
humanoid_name_starts[1] = "GOLD"
humanoid_name_starts[2] = "HIGH"
humanoid_name_starts[3] = "AND"
humanoid_name_starts[4] = "BEN"
humanoid_name_starts[5] = "BAN"
humanoid_name_starts[6] = "BILL"
humanoid_name_starts[7] = "WY"
humanoid_name_starts[8] = "WAT"
humanoid_name_starts[9] = "POD"
humanoid_name_starts[10] = "KING"
humanoid_name_starts[11] = "BAR"
humanoid_name_starts[12] = "PET"
humanoid_name_starts[13] = "MAN"
humanoid_name_starts[14] = "BOY"
humanoid_name_starts[15] = "WAR"
humanoid_name_starts[16] = "JACK"
humanoid_name_starts[17] = "CRAB"
humanoid_name_starts[18] = "FISH"
humanoid_name_starts[19] = "WATER"
humanoid_name_starts[20] = "MIL"
humanoid_name_starts[21] = "BY"
humanoid_name_starts[22] = "FEN"
humanoid_name_starts[23] = "RICH"
humanoid_name_starts[24] = "SCOT"
humanoid_name_starts[25] = "BUR"
humanoid_name_starts[26] = "PIKE"
humanoid_name_starts[27] = "CUR"
humanoid_name_starts[28] = "WHIT"
humanoid_name_starts[29] = "BINN"
humanoid_name_starts[30] = "BONN"
humanoid_name_starts[31] = "POG"
humanoid_name_starts[32] = "WRIGHT"
humanoid_name_starts[33] = "KER"
policy.diag_procedure = "Procedimento de diagnóstico"
policy.header = "NORMAS DO HOSPITAL"
policy.staff_leave_rooms = "Abandonar as consultas"
policy.staff_rest = "Enviar os funcionários para descansar"
policy.diag_termination = "Conclusäo do diagnóstico"
policy.sliders.send_home = "ENVIA PARA CASA"
policy.sliders.guess = "TENTAR CURA"
policy.sliders.stop = "PARAR PROCESSO"
policy.sliders.staff_room = "IR DESCANSAR"
menu_display.mcga_lo_res = "  BAIXA RESOLUÇAO MCGA  "
menu_display.shadows = "  SOMBRAS  "
menu_display.high_res = "  ALTA RESOLUÇAO  "
staff_title.surgeon = "Cirurgiäo"
staff_title.psychiatrist = "Psiquiatra"
staff_title.general = "Geral"
staff_title.junior = "Residente"
staff_title.researcher = "Pesquisador"
staff_title.consultant = "Consultor"
staff_title.nurse = "Enfermeira"
staff_title.doctor = "Médico"
staff_title.receptionist = "Recepcionista"
bank_manager.insurance_owed = "Dívida do seguro"
bank_manager.interest_rate = "Juros"
bank_manager.interest_payment = "Pagamento de juros"
bank_manager.statistics_page.date = "Data"
bank_manager.statistics_page.money_out = "Débito"
bank_manager.statistics_page.money_in = "Crédito"
bank_manager.statistics_page.balance = "Saldo"
bank_manager.statistics_page.current_balance = "Saldo atual"
bank_manager.statistics_page.details = "Detalhes"
bank_manager.balance = "Saldo"
bank_manager.inflation_rate = "Inflaçäo"
bank_manager.hospital_value = "Valor do hospital"
bank_manager.current_loan = "Empréstimo pendente"
menu_file_save[1] = "  JOGO 1 "
menu_file_save[2] = "  JOGO 2 "
menu_file_save[3] = "  JOGO 3 "
menu_file_save[4] = "  JOGO 4 "
menu_file_save[5] = "  JOGO 5 "
menu_file_save[6] = "  JOGO 6 "
menu_file_save[7] = "  JOGO 7 "
menu_file_save[8] = "  JOGO 8 "
insurance_companies[1] = "Seguros Estrelinha"
insurance_companies[2] = "Seguros Nacional"
insurance_companies[3] = "Mútua Seguril"
insurance_companies[4] = "Seguros Ponderoso"
insurance_companies[5] = "Geral Seguro"
insurance_companies[6] = "Seguro Fiel"
insurance_companies[7] = "Holding de Seguros"
insurance_companies[8] = "Seguros Leon"
insurance_companies[9] = "Joäo e Maria Ltda."
insurance_companies[10] = "Seguro Feliz"
insurance_companies[11] = "Seguros Sindicato"
insurance_companies.out_of_business = "FECHADO"
room_descriptions.ward[1] = "Enfermaria//"
room_descriptions.ward[2] = "Os pacientes ficam aqui para serem atendidos por uma enfermeira enquanto säo diagnosticados. Permanecem aqui antes de serem operados.//"
room_descriptions.ward[3] = "A Enfermaria requer uma enfermeira. "
room_descriptions.blood_machine[1] = "Sala de Transfusöes//"
room_descriptions.blood_machine[2] = "O transfusiômetro é um elemento do equipamento de diagnóstico que revisa as células do sangue do paciente para descobrir do que sofrem.//"
room_descriptions.blood_machine[3] = "A sala de transfusöes requer um médico. Também precisa de manutençäo. "
room_descriptions.fracture_clinic[1] = "Traumatologia//"
room_descriptions.fracture_clinic[2] = "Os pacientes que têm a desgraça de ter fraturas vêm aqui. O removedor de gesso usa poderosos lasers industriais para cortar os gessos mais duros, causando ao paciente só uma pequena dor.//"
room_descriptions.fracture_clinic[3] = "A sala de traumatologia requer uma enfermeira. Também precisa de uma manutençäo muito frequente. "
room_descriptions.cardiogram[1] = "Cardiologia//"
room_descriptions.cardiogram[2] = "Os pacientes säo diagnosticados aqui, antes de retornarem para o Consultório de Clínica Geral para conseguir um tratamento.//"
room_descriptions.cardiogram[3] = "A Cardiologia requer um médico. Também precisa de manutençäo. "
room_descriptions.decontamination[1] = "Descontaminaçäo//"
room_descriptions.decontamination[2] = "Os pacientes que estiveram expostos à radiaçäo säo enviados rapidamente à consulta de descontaminaçäo. Esta consulta dispöe de uma ducha que os purifica de toda a horrível radioatividade e sujeira.//"
room_descriptions.decontamination[3] = "A ducha descontaminadora requer um médico. Também precisa de um zelador que se ocupe da sua manutençäo. "
room_descriptions.jelly_vat[1] = "Banho Gelatinoso//"
room_descriptions.jelly_vat[2] = "Os pacientes que sofrem da risível doença da gelatinite devem ir a cambalear-se para a consulta de gelatinite e ser inundados no banheiro gelatinoso. Isto faz com que se curem de um modo que näo resulta de tudo compreensível para a profissäo médica.//"
room_descriptions.jelly_vat[3] = "O banho gelatinoso requer um médico. Também precisa de um zelador para a sua manutençäo. "
room_descriptions.gp[1] = "Consultório de Clínica Geral//"
room_descriptions.gp[2] = "Esta é a consulta mais importante do seu hospital. Os novos pacientes säo enviados aqui para averiguar o que é que eles têm. Entäo, ou fazem outro diagnóstico ou mandam para uma consulta onde possam ser curados. Possivelmente queira construir outro consultório se o primeiro tiver muito trabalho. Quanto maior for o consultório e quanto mais objetos colocar nele, maior prestígio terá o médico. O mesmo acontece com todas as consultas abertas.//"
room_descriptions.gp[3] = "O consultório geral requer um médico. "
room_descriptions.hair_restoration[1] = "Peloterapia//"
room_descriptions.hair_restoration[2] = "Os pacientes que sofrem de calvície seräo enviados ao pêlo-restaurador desta sala. Um médico ligará o pêlo-restaurador, que, rapidamente, implantará na cabeça do paciente ar puro.//"
room_descriptions.hair_restoration[3] = "A consulta de peloterapia requer um médico. Também precisa de manutençäo periódica. "
room_descriptions.inflation[1] = "Inflatoterapia//"
room_descriptions.inflation[2] = "Os pacientes que sofrem a dolorosa doença de terem a cabeça inflada devem ir à sala de inflatoterapia, será desinflada sua cabeça e em seguida volta a ser inflada à pressäo correta.//"
room_descriptions.inflation[3] = "A Inflatoterapia requer um médico. Também precisa de um zelador que se ocupe do seu bom funcionamento. "
room_descriptions.psych[1] = "Psiquiatria//"
room_descriptions.psych[2] = "Os pacientes que säo diagnosticados com uma doença psiquiátrica têm que ir a uma consulta de psiquiatria para receber o tratamento. Os psiquiatras também podem realizar diagnósticos para saber que tipo de doença que sofrem os pacientes, e se estas säo do tipo mental, podem tratá-los deitando-os no divä.//"
room_descriptions.psych[3] = "A sala de psiquiatria requer um médico especializado em psiquiatria. "
room_descriptions.operating_theatre[1] = "Sala de Cirurgia//"
room_descriptions.operating_theatre[2] = "Esta importante instalaçäo serve para curar um grande número de doenças. A Sala de Cirurgia tem que ser espaçosa e deve estar bem equipada. É uma parte essencial do seu hospital.//"
room_descriptions.operating_theatre[3] = "A Sala de Cirurgia requer dois médicos especializados em cirurgia. "
room_descriptions.no_room[1] = ""
room_descriptions.x_ray[1] = "Sala de Raio-X//"
room_descriptions.x_ray[2] = "O Raio-X fotografa o interior do paciente empregando uma radiaçäo especial para ajudar a equipe a descobrir o que acontece.//"
room_descriptions.x_ray[3] = "A sala de Raio-X requer um médico. Também precisa de manutençäo. "
room_descriptions.tv_room[1] = "TV ROOM NOT USED"
room_descriptions.staff_room[1] = "Sala de Descanso//"
room_descriptions.staff_room[2] = "Os seus funcionários se cansam quando realizam o seu trabalho. Precisam desta sala para descansar e se refrescar. Os funcionários cansados säo mais lentos, pedem mais dinheiro e por fim väo embora. Também cometem mais erros. Vale a pena construir uma sala que tenha muitos passatempos. Assegure-se de que há lugar para vários funcionários ao mesmo tempo. "
room_descriptions.slack_tongue[1] = "Laringologia//"
room_descriptions.slack_tongue[2] = "Os pacientes diagnosticados com língua comprida no Consultório de Clínica Geral seräo enviados aqui para receber tratamento. O médico utilizará uma máquina de alta tecnologia para esticar a língua e cortá-la, assim o paciente ficará curado.//"
room_descriptions.slack_tongue[3] = "A sala de laringologia requer um médico. Também precisa de manutençäo muito frequente. "
room_descriptions.dna_fixer[1] = "Genética//"
room_descriptions.dna_fixer[2] = "Os pacientes que foram manipulados por alienígenas devem ter seu DNA substituído nesta sala. O reparador de DNA é uma máquina complexa e seria sensato ter um extintor na sala, só por garantia.//"
room_descriptions.dna_fixer[3] = "O reparador de DNA requer que um zelador o revise de vez em quando. Também requer um médico especializado em pesquisa para poder usá-lo. "
room_descriptions.training[1] = "Sala de Formaçäo//"
room_descriptions.training[2] = "Os seus residentes e médicos podem obter uma valiosa qualificaçäo extra aprendendo nesta sala. Um especialista em cirurgia, pesquisa ou psiquiatria ensinará a sua especialidade aos médicos que recebem formaçäo. Os médicos que já possuem estas especialidades veräo a sua habilidade aumentar enquanto estäo aqui.//"
room_descriptions.training[3] = "A Sala de Formaçäo requer um especialista. "
room_descriptions.toilets[1] = "Banheiro//"
room_descriptions.toilets[2] = "Os pacientes estäo sentindo um chamado da natureza e precisam se aliviar no conforto de suas instalaçöes de banheiro. Pode construir mais banheiros e pias se esperar muitos visitantes. Em alguns casos, terá que colocar mais banheiros em outras partes do hospital. "
room_descriptions.ultrascan[1] = "Ultra Scanner//"
room_descriptions.ultrascan[2] = "O ultra scanner é, virtualmente, o mais avançado em equipamentos de diagnóstico. Tem um preço alto, mas vale a pena se quiser que o seu hospital realize diagnósticos excelentes.//"
room_descriptions.ultrascan[3] = "O ultra scanner requer um médico. Também precisa de manutençäo. "
room_descriptions.pharmacy[1] = "Farmácia//"
room_descriptions.pharmacy[2] = "Os pacientes que foram diagnosticados e que devem tomar um medicamento devem visitar a farmácia para tomá-lo. Quantos mais remédios forem descobertos e estiverem disponíveis, mais concorrida estará a farmácia. Possivelmente queira construir outra farmácia mais para frente.//"
room_descriptions.pharmacy[3] = "A farmácia requer uma enfermeira. "
room_descriptions.research[1] = "Centro de Pesquisa//"
room_descriptions.research[2] = "No centro de pesquisa säo inventados ou melhorados novos remédios e curas. É uma parte essencial do seu hospital e fará maravilhas para elevar a sua porcentagem de curas.//"
room_descriptions.research[3] = "O Centro de Pesquisa requer um médico especializado em pesquisa. "
room_descriptions.general_diag[1] = "Diagnóstico Geral//"
room_descriptions.general_diag[2] = "Aqui säo examinados os pacientes que precisam de outro diagnóstico. Se em uma consulta näo descobrir os seus problemas, o diagnosticador geral normalmente consegue. Em seguida, volta a enviar os pacientes para a consulta para analisar os resultados obtidos aqui.//"
room_descriptions.general_diag[3] = "A sala de Diagnóstico Geral requer um médico. "
room_descriptions.scanner[1] = "Scanner//"
room_descriptions.scanner[2] = "É diagnosticado com precisäo os pacientes empregando um sofisticado scanner. Em seguida, väo para o Consultório de Clínica Geral para que o médico veja o tratamento posterior.//"
room_descriptions.scanner[3] = "O scanner requer um médico. Também precisa de manutençäo. "
room_descriptions.electrolysis[1] = "Eletrólise//"
room_descriptions.electrolysis[2] = "Os pacientes com peludismo säo enviados para esta consulta, onde uma máquina especial de eletrólise elimina os pelos e fecha os poros com eletricidade empregando um composto parecido ao cal.//"
room_descriptions.electrolysis[3] = "A sala de eletrólise requer um médico. Também precisa que um zelador faça a sua manutençäo. "
staff_list.skill = "NIVEL"
staff_list.morale = "MORAL"
staff_list.tiredness = "CANSAÇO"
staff_list.total_wages = "SALARIOS TOTAIS"
menu_file_load[1] = "  JOGO 1 "
menu_file_load[2] = "  JOGO 2 "
menu_file_load[3] = "  JOGO 3 "
menu_file_load[4] = "  JOGO 4 "
menu_file_load[5] = "  JOGO 5 "
menu_file_load[6] = "  JOGO 6 "
menu_file_load[7] = "  JOGO 7 "
menu_file_load[8] = "  JOGO 8 "
