/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.KeyPairCodecFactory;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.javax.crypto.key.GnuSecretKey;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;

public final class PrivateKeyEntry
extends PrimitiveEntry {
    public static final int TYPE = 7;
    private Key key;

    public static final PrivateKeyEntry decode(DataInputStream dataInputStream) throws IOException {
        PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
        privateKeyEntry.defaultDecode(dataInputStream);
        String string = privateKeyEntry.properties.get("type");
        if (string == null) {
            throw new MalformedKeyringException("no key type");
        }
        if (string.equalsIgnoreCase("RAW-DSS")) {
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dss");
            privateKeyEntry.key = iKeyPairCodec.decodePrivateKey(privateKeyEntry.payload);
        } else if (string.equalsIgnoreCase("RAW-RSA")) {
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("rsa");
            privateKeyEntry.key = iKeyPairCodec.decodePrivateKey(privateKeyEntry.payload);
        } else if (string.equalsIgnoreCase("RAW-DH")) {
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dh");
            privateKeyEntry.key = iKeyPairCodec.decodePrivateKey(privateKeyEntry.payload);
        } else if (string.equalsIgnoreCase("RAW")) {
            privateKeyEntry.key = new GnuSecretKey(privateKeyEntry.payload, null);
        } else if (string.equalsIgnoreCase("PKCS8")) {
            KeyFactory keyFactory;
            try {
                keyFactory = KeyFactory.getInstance("RSA");
                privateKeyEntry.key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyEntry.payload));
            }
            catch (Exception exception) {}
            if (privateKeyEntry.key == null) {
                try {
                    keyFactory = KeyFactory.getInstance("DSA");
                    privateKeyEntry.key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyEntry.payload));
                }
                catch (Exception exception) {}
                if (privateKeyEntry.key == null) {
                    throw new MalformedKeyringException("could not decode PKCS#8 key");
                }
            }
        } else {
            throw new MalformedKeyringException("unsupported key type " + string);
        }
        return privateKeyEntry;
    }

    public final Key getKey() {
        return this.key;
    }

    protected final void encodePayload() throws IOException {
        String string = this.key.getFormat();
        if (this.key instanceof DSSPrivateKey) {
            this.properties.put("type", "RAW-DSS");
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dss");
            this.payload = iKeyPairCodec.encodePrivateKey((PrivateKey)this.key);
        } else if (this.key instanceof GnuRSAPrivateKey) {
            this.properties.put("type", "RAW-RSA");
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("rsa");
            this.payload = iKeyPairCodec.encodePrivateKey((PrivateKey)this.key);
        } else if (this.key instanceof GnuDHPrivateKey) {
            this.properties.put("type", "RAW-DH");
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dh");
            this.payload = iKeyPairCodec.encodePrivateKey((PrivateKey)this.key);
        } else if (this.key instanceof GnuSecretKey) {
            this.properties.put("type", "RAW");
            this.payload = this.key.getEncoded();
        } else if (string != null && string.equals("PKCS#8")) {
            this.properties.put("type", "PKCS8");
            this.payload = this.key.getEncoded();
        } else {
            throw new IllegalArgumentException("unsupported private key");
        }
    }

    public PrivateKeyEntry(Key key, Date date, Properties properties) {
        super(7, date, properties);
        if (key == null) {
            throw new IllegalArgumentException("no private key");
        }
        if (!(key instanceof PrivateKey) && !(key instanceof GnuSecretKey)) {
            throw new IllegalArgumentException("not a private or secret key");
        }
        this.key = key;
    }

    private PrivateKeyEntry() {
        super(7);
    }
}

