/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_LAYER_H__
#define __SG_LAYER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtk/gtkmarshal.h>
#include <gtkextra/gtkextra.h>
#include "../sg_dataset.h"
#include "../sg_plugin_layer.h"
#include "sg_widgets_enums.h"
#include "sg_worksheet.h"

#define SG_LAYER(obj)        GTK_CHECK_CAST (obj, sg_layer_get_type (), SGlayer)
#define GTK_TYPE_SG_LAYER   (sg_layer_get_type ())

#define SG_LAYER_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_layer_get_type(), SGlayerClass)
#define GTK_IS_SG_LAYER(obj)     GTK_CHECK_TYPE (obj, sg_layer_get_type ())


typedef struct _SGlayer SGlayer;
typedef struct _SGlayerClass SGlayerClass;
typedef struct _SGtick SGtick;

struct _SGtick 
{
  gdouble value;
  gchar *label;
};

struct _SGlayer 
{
  GtkPlotCanvasPlot object;

  gint rescale;

  SGpluginLayer *plugin;

  /* Automatic symbols */
  gint symbol;
  gint symbol_style;
  gint line_style;
  gint connector;
  GdkColor symbol_color;
  GdkColor line_color;
};

struct _SGlayerClass
{
   GtkPlotCanvasPlotClass parent_class;

   void (*add_dataset)			(SGlayer *layer, GtkPlotData *data);
   void (*remove_dataset)		(SGlayer *layer, GtkPlotData *data);
   void (*activate_dataset)		(SGlayer *layer, GtkPlotData *data);
};

GtkType		sg_layer_get_type		(void);
SGlayer 	*sg_layer_new			(SGpluginLayer *plugin,
                                                 gdouble width,
						 gdouble height);
SGlayer 	*sg_layer_clone			(SGlayer *layer);
GtkPlotData *	sg_layer_add_dataset		(SGlayer *layer,
						 SGdataset *dataset);
GtkPlotData *	sg_layer_add_dataset_default	(SGlayer *layer,
						 SGdataset *dataset);
GtkPlotData *	sg_layer_add_dataset_autosymbol	(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_add_dataset_child	(SGlayer *layer,
						 GtkPlotData *real_data);
void		sg_layer_set_active_dataset	(SGlayer *layer,
						 GtkPlotData *dataset);
void		sg_layer_remove_dataset		(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_clear			(SGlayer *layer);
void		sg_layer_remove_markers		(SGlayer *layer);
void		sg_layer_show_markers		(SGlayer *layer, gboolean show);
void		sg_layer_refresh_datasets	(SGlayer *layer);
gint		sg_layer_min_max		(SGlayer *layer, 
						 gdouble *xmin, gdouble *xmax, 
						 gdouble *ymin, gdouble *ymax);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_LAYER_H__ */

