.\"
.\" Copyright (c) 2019 Kamil Rytarowski <kamil@NetBSD.org>
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
.\" ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
.\" TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
.\" BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
.\" CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
.\" SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
.\" CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
.\" ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
.\" POSSIBILITY OF SUCH DAMAGE.
.\"
.\"
.Dd October 6, 2019
.Dt THEO n
.Os
.Sh NAME
.Nm theo
.Nd return a quote from theo.c
.Sh SYNOPSIS
package require theo 0.0.1
.Sh DESCRIPTION
This package provides quotes from OpenBSD's src/usr.bin/mg/theo.c.
The quotes were originally spoken by Theo de Raadt,
the OpenBSD project founder.
.Pp
The inferface of
.Nm
consists of a single tcl command named
.Nm .
Because there is only this one command, the interface is not placed in a separate namespace.
.Pp
The
.Nm
command does not take any arguments and returns a random string with a quote.
.Sh EXAMPLES
.Bd -literal -offset indent
# load the extension
package require theo
.Ed
.Pp
.Bd -literal -offset indent
# return a quote and print it to the standard output
puts [theo]
.Ed
.Sh SEE ALSO
mg (editor) - originally called MicroGnuEmacs.
.Sh HISTORY
theo.c as a mg extension first appeared in the OpenBSD's fork of mg in 2002 and was written by Artur Grabowski.
.Pp
The theo.c file was removed from OpenBSD on 16 Sep 2016.
This TCL extension ships with the latest list of the original quotes.
.Sh AUTHORS
.An Kamil Rytarowski Aq Mt kamil@NetBSD.org
