;;;
;;; irchat-pj-action.el
;;; last modify : Sat, 18 Dec 1999 01:43:57 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; see file irchat-copyright.el for change log and copyright info
;;;

(require 'irchat-vars)

(defun irchat-pj-re-member (str list)
  "Return non-nil if STR is an element of LIST.  Comparison done with `string-match'.
The value is actually the tail of LIST whose car matches with STR."
  (if (stringp str)
      (let (item (result list))
	(catch 'found
	  (while result
	    (setq item (car result))
	    (and (stringp item)
		 (string-match item str)
		 (throw 'found result))
	    (setq result (cdr result)))))))

(defun irchat-pj-re-assoc (str alist)
  "Return non-nil if STR is `string-match' to the car of an element of ALIST.
The value is actually the element of ALIST whose car matches STR."
  (if (stringp str)
      (let (item (result alist))
	(catch 'found
	  (while result
	    (setq item (car result))
	    (and (consp item)
		 (stringp (car item))
		 (string-match (car item) str)
		 (throw 'found item))
	    (setq result (cdr result)))))))


(defun irchat-pj-action-auto-oper (nick userhost chan)
  "Give defined-user channel-operator automatically."
  (and (string= "@" (irchat-channel-operator irchat-nickname chan))
       (not (string= "@" (irchat-channel-operator nick chan)))
       (let* (tmp
	      (id (concat nick "!" userhost))
	      (ok (irchat-pj-re-member id irchat-pj-auto-oper-list)))
	 (if ok ok
	   (setq ok  (irchat-pj-re-assoc id irchat-pj-auto-oper-list)
		 tmp (cdr ok))
	   (or (and (stringp tmp)
		    (string-match chan tmp))
	       (and (listp tmp)
		    (member chan tmp))
	       (setq ok nil)))
	 (if (car ok)
	     (irchat-send "MODE %s +o %s" chan nick)))))

(provide 'irchat-pj-action)

;;
;; end
;;
