/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.BoardPainter;
import free.chess.DefaultBoardPainter;
import free.chess.ResourceBoardPainter;
import free.util.IOUtilities;
import free.util.ImageUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class SquareImagesBoardPainter
implements ResourceBoardPainter {
    public static final int SCALE_MODE = 0;
    public static final int SLICE_MODE = 1;
    private static final BoardPainter whileLoadingDelegate = new DefaultBoardPainter();
    private static volatile boolean asyncImageLoad = false;
    private Image lightImage = null;
    private Image darkImage = null;
    private int mode;
    private Image scaledLightImage = null;
    private Image scaledDarkImage = null;
    private URL lightImageUrl = null;
    private URL darkImageUrl = null;
    private ImageDataReceiver imageDataReceiver = null;

    public SquareImagesBoardPainter() {
    }

    public SquareImagesBoardPainter(Image image, Image image2, int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image usage mode: " + n);
            }
        }
        this.lightImage = image;
        this.darkImage = image2;
        this.mode = n;
    }

    public static void setAsyncImageLoad(boolean bl) {
        asyncImageLoad = bl;
    }

    public BoardPainter freshInstance() {
        return this;
    }

    public void load(URL uRL) throws IOException {
        String string;
        if (this.lightImageUrl != null) {
            throw new IllegalStateException("This SquareImagesBoardPainter has already been loaded");
        }
        URL uRL2 = new URL(uRL, "definition");
        Properties properties = IOUtilities.loadProperties((URL)uRL2, (boolean)true);
        if (properties == null) {
            properties = new Properties();
        }
        this.mode = properties.getProperty("scaleSquares") != null ? (new Boolean(properties.getProperty("scaleSquares", "false")) != false ? 0 : 1) : ("slice".equals(string = properties.getProperty("imageUseMode", "slice")) ? 1 : 0);
        string = properties.getProperty("ext", "gif");
        this.lightImageUrl = new URL(uRL, "light." + string);
        this.darkImageUrl = new URL(uRL, "dark." + string);
    }

    protected synchronized boolean prepareSquareImages(int n, int n2, Component component) {
        if (this.lightImage == null) {
            if (this.imageDataReceiver != null) {
                this.imageDataReceiver.addComponentToRepaint(component);
                return false;
            }
            if (asyncImageLoad) {
                this.imageDataReceiver = new ImageDataReceiver(component);
                IOUtilities.loadAsynchronously((URL[])new URL[]{this.lightImageUrl, this.darkImageUrl}, null, (IOUtilities.DataReceiver)this.imageDataReceiver, (boolean)true);
                return false;
            }
            this.imageDataReceiver = new ImageDataReceiver(null);
            IOUtilities.loadSynchronously((URL[])new URL[]{this.lightImageUrl, this.darkImageUrl}, null, (IOUtilities.DataReceiver)this.imageDataReceiver, (boolean)true);
            if (this.lightImage == null || this.darkImage == null) {
                return false;
            }
            this.scaleSquareImages(n, n2);
            return true;
        }
        this.scaleSquareImages(n, n2);
        return true;
    }

    private void scaleSquareImages(int n, int n2) {
        if (this.mode == 0) {
            int n3 = n / 8;
            int n4 = n2 / 8;
            if (this.scaledLightImage != null && this.scaledLightImage.getWidth(null) == n3 && this.scaledLightImage.getHeight(null) == n4) {
                return;
            }
            this.scaledLightImage = this.lightImage.getScaledInstance(n3, n4, 4);
            this.scaledDarkImage = this.darkImage.getScaledInstance(n3, n4, 4);
            ImageUtilities.preload((Image)this.scaledLightImage);
            ImageUtilities.preload((Image)this.scaledDarkImage);
        } else if (this.mode == 1) {
            // empty if block
        }
    }

    public void paintBoard(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (this.prepareSquareImages(n3, n4, component)) {
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = new Rectangle(n, n2, n3 / 8, n4 / 8);
            if (this.mode == 0) {
                int n5 = 0;
                while (n5 < 8) {
                    rectangle2.y = n2;
                    int n6 = 7;
                    while (n6 >= 0) {
                        if (rectangle2.intersects(rectangle)) {
                            Image image = (n5 + n6) % 2 == 0 ? this.scaledDarkImage : this.scaledLightImage;
                            graphics.drawImage(image, rectangle2.x, rectangle2.y, component);
                        }
                        --n6;
                        rectangle2.y += n4 / 8;
                    }
                    ++n5;
                    rectangle2.x += n3 / 8;
                }
            } else if (this.mode == 1) {
                int n7 = this.lightImage.getWidth(null);
                int n8 = this.lightImage.getHeight(null);
                int n9 = this.darkImage.getWidth(null);
                int n10 = this.darkImage.getHeight(null);
                int n11 = 0;
                while (n11 < 8) {
                    rectangle2.y = n2;
                    int n12 = 7;
                    while (n12 >= 0) {
                        if (rectangle2.intersects(rectangle)) {
                            int n13;
                            int n14;
                            Image image;
                            if ((n11 + n12) % 2 == 0) {
                                image = this.darkImage;
                                n14 = n9;
                                n13 = n10;
                            } else {
                                image = this.lightImage;
                                n14 = n7;
                                n13 = n8;
                            }
                            graphics.setClip(rectangle.intersection(rectangle2));
                            int n15 = n11 * n14 % rectangle2.width;
                            int n16 = (7 - n12) * n13 % rectangle2.height;
                            int n17 = rectangle2.x;
                            while (n17 - n15 < rectangle2.x + rectangle2.width) {
                                int n18 = rectangle2.y;
                                while (n18 - n16 < rectangle2.y + rectangle2.height) {
                                    graphics.drawImage(image, n17 - n15, n18 - n16, component);
                                    n18 += n13;
                                }
                                n17 += n14;
                            }
                        }
                        --n12;
                        rectangle2.y += n4 / 8;
                    }
                    ++n11;
                    rectangle2.x += n3 / 8;
                }
            }
            graphics.setClip(rectangle);
        } else {
            whileLoadingDelegate.paintBoard(graphics, component, n, n2, n3, n4);
        }
    }

    private class ImageDataReceiver
    implements IOUtilities.DataReceiver {
        private final Set componentsToRepaint = new HashSet(2);

        public ImageDataReceiver(Component component) {
            this.componentsToRepaint.add(component);
        }

        public void addComponentToRepaint(Component component) {
            this.componentsToRepaint.add(component);
        }

        public void dataRead(URL[] uRLArray, Object object, byte[][] byArray, IOException[] iOExceptionArray) {
            for (int i = 0; i < iOExceptionArray.length; ++i) {
                if (iOExceptionArray[i] == null) continue;
                return;
            }
            SquareImagesBoardPainter.this.lightImage = Toolkit.getDefaultToolkit().createImage(byArray[0]);
            SquareImagesBoardPainter.this.darkImage = Toolkit.getDefaultToolkit().createImage(byArray[1]);
            ImageUtilities.preload((Image)SquareImagesBoardPainter.this.lightImage);
            ImageUtilities.preload((Image)SquareImagesBoardPainter.this.darkImage);
            Iterator iterator = this.componentsToRepaint.iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                if (component == null) continue;
                component.repaint();
            }
        }
    }
}

