<?php
/**
 * Unicode Normalizer
 *
 * PHP version 5
 *
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * + Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * + Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * + The names of its contributors may not be used to endorse or
 * promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  Internationalization
 * @package   I18N_UnicodeNormalizer
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2007 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   SVN: $Id: FileTest.php 38 2007-07-23 11:42:30Z mcorne $
 * @link      http://pear.php.net/package/I18N_UnicodeNormalizer
 */
// Call tests_UnicodeNormalizer_FileTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "tests_UnicodeNormalizer_FileTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'I18N/UnicodeNormalizer/File.php';

/**
 * Test class for I18N_UnicodeNormalizer_File.
 * Generated by PHPUnit_Util_Skeleton on 2007-05-17 at 11:00:39.
 *
 * @category  Internationalization
 * @package   I18N_UnicodeNormalizer
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2007 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   Release: @package_version@
 * @link      http://pear.php.net/package/I18N_UnicodeNormalizer
 */
class tests_UnicodeNormalizer_FileTest extends PHPUnit_Framework_TestCase
{
    /**
     * The I18N_UnicodeNormalizer_File class instance
     *
     * @var    object 
     * @access private
     */
    private $file;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite = new PHPUnit_Framework_TestSuite("I18N_UnicodeNormalizer_FileTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $this->file = new I18N_UnicodeNormalizer_File();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown()
    {
    }

    /**
     * Tests put()
     *
     * @return void  
     * @access public
     */
    public function testPut()
    {
        // creates a temporary file name, exports the data into a temp PHP file
        $fileName = tempnam('/tmp', "gdb");
        $this->file->put($fileName, array('foo' => 123), 'foo::foo', 'foo.php', 'this is a test', '01/01/2000');
        // reads the file content, removes the temporary file
        $content = file_get_contents($fileName);
        @unlink($fileName);
        // creates the expected file content
        $expected = "<?php\n";
        $expected .= "/**\n";
        $expected .= " * Unicode Normalizer\n";
        $expected .= " *\n";
        $expected .= " * File: $fileName\n";
        $expected .= " * Generated automatically by: foo::foo\n";
        $expected .= " * From: foo.php\n";
        $expected .= " * Date: 01/01/2000\n";
        $expected .= " * this is a test\n";
        $expected .= " * DO NOT MODIFY !\n";
        $expected .= " *\n";
        $expected .= " * PHP version 5\n";
        $expected .= " *\n";
        $expected .= " * All rights reserved.\n";
        $expected .= " * Redistribution and use in source and binary forms, with or without modification,\n";
        $expected .= " * are permitted provided that the following conditions are met:\n";
        $expected .= " * + Redistributions of source code must retain the above copyright notice,\n";
        $expected .= " * this list of conditions and the following disclaimer.\n";
        $expected .= " * + Redistributions in binary form must reproduce the above copyright notice,\n";
        $expected .= " * this list of conditions and the following disclaimer in the documentation and/or\n";
        $expected .= " * other materials provided with the distribution.\n";
        $expected .= " * + The names of its contributors may not be used to endorse or\n";
        $expected .= " * promote products derived from this software without specific prior written permission.\n";
        $expected .= " * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n";
        $expected .= " * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n";
        $expected .= " * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n";
        $expected .= " * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR\n";
        $expected .= " * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n";
        $expected .= " * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n";
        $expected .= " * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n";
        $expected .= " * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n";
        $expected .= " * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n";
        $expected .= " * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n";
        $expected .= " * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n";
        $expected .= " *\n";
        $expected .= " * @category Internationalization\n";
        $expected .= " * @package I18N_UnicodeNormalizer\n";
        $expected .= " * @author Michel Corne <mcorne@yahoo.com>\n";
        $expected .= " * @copyright 2007 Michel Corne\n";
        $expected .= " * @license http://www.opensource.org/licenses/bsd-license.php The BSD License\n";
		// the SVN tag is split so it does get changed during the versioning of this file
        $expected .= " * @version SVN: \$" . 'Id' . "$\n";
        $expected .= " * @link http://pear.php.net/package/I18N_UnicodeNormalizer\n";
        $expected .= " */\n";
        $expected .= "\n";
        $expected .= "return array (\n";
        $expected .= "  'foo' => 123,\n";
        $expected .= ");\n";
        $expected .= "?>\n";
        // file_put_contents('expected.txt', $expected); // for debbuging purposes
        // file_put_contents('content.txt', $content); // for debbuging purposes
        $this->assertEquals($expected, $content);
    }
}
// Call tests_UnicodeNormalizer_FileTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "tests_UnicodeNormalizer_FileTest::main") {
    tests_UnicodeNormalizer_FileTest::main();
}

?>
