/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class EtchedBorder
extends AbstractBorder {
    static final long serialVersionUID = 4001244046866360638L;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlight;
    protected Color shadow;

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        switch (this.etchType) {
            case 0: {
                EtchedBorder.paintEtchedBorder(g, x, y, width, height, this.getHighlightColor(c), this.getShadowColor(c));
                break;
            }
            case 1: {
                EtchedBorder.paintEtchedBorder(g, x, y, width, height, this.getShadowColor(c), this.getHighlightColor(c));
                break;
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    public boolean isBorderOpaque() {
        boolean bl = false;
        if (!(this.highlight != null && this.highlight.getAlpha() != 255 || this.shadow != null && this.shadow.getAlpha() != 255)) {
            bl = true;
        }
        return bl;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component c) {
        if (this.highlight != null) {
            return this.highlight;
        }
        return c.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component c) {
        if (this.shadow != null) {
            return this.shadow;
        }
        return c.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void paintEtchedBorder(Graphics g, int x, int y, int width, int height, Color a, Color b) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        --width;
        --height;
        try {
            g.setColor(a);
            g.drawRect(0, 0, width - 1, height - 1);
            g.setColor(b);
            g.drawLine(1, 1, width - 2, 1);
            g.drawLine(1, 2, 1, height - 2);
            g.drawLine(0, height, width, height);
            g.drawLine(width, 0, width, height - 1);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            g.translate(-x, -y);
            g.setColor(oldColor);
            throw throwable;
        }
        {
            Object var9_10 = null;
            g.translate(-x, -y);
            g.setColor(oldColor);
            return;
        }
    }

    public EtchedBorder() {
        this(1);
    }

    public EtchedBorder(int etchType) {
        if (etchType != 0 && etchType != 1) {
            throw new IllegalArgumentException();
        }
        this.etchType = etchType;
    }

    public EtchedBorder(Color highlight, Color shadow) {
        this(1, highlight, shadow);
    }

    public EtchedBorder(int etchType, Color highlight, Color shadow) {
        this(etchType);
        this.highlight = highlight;
        this.shadow = shadow;
    }
}

