/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.ui;

import java.awt.datatransfer.*; // FOR COPY_TO_CLIPBOARD
import java.awt.Toolkit;        // FOR COPY_TO_CLIPBOARD
import java.awt.event.*;
import javax.swing.*;

import GoGrinder.Main;
import GoGrinder.Messages;
import GoGrinder.SysInfo;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class SysInfoDialog extends javax.swing.JDialog {
  private boolean settFromEnv = (!Main.SETT_FROM_ENV.equals("") ) ? true : false;
  private javax.swing.JPanel panelMain;
  private javax.swing.JPanel panelSysInfo;
  private javax.swing.JPanel panelButtons;
  private javax.swing.JLabel labelSysInfo;
  private javax.swing.JTextArea textAreaSysInfo;
  private javax.swing.JButton buttonCopyInfo;
  private javax.swing.JButton buttonOK;
  private SysInfo sInfo = new SysInfo(1); // 1 = sysinfo for the GUI
  
  public SysInfoDialog(java.awt.Dialog parent, boolean modal) {
    super(parent, modal);
    initComponents();
    setResizable(false);
    setLocationRelativeTo(parent);
  }
  
  public SysInfoDialog(java.awt.Frame parent, boolean modal) {
    super(parent, modal);
    initComponents();
    setResizable(false);
    setLocationRelativeTo(parent);
  }
  
  private void initComponents() {
    panelMain = new javax.swing.JPanel();
    panelSysInfo = new javax.swing.JPanel();
    panelButtons = new javax.swing.JPanel(); 
    labelSysInfo = new javax.swing.JLabel();
    textAreaSysInfo = new javax.swing.JTextArea();
    buttonCopyInfo = new javax.swing.JButton();
    buttonOK = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE); 

    setTitle(Messages.getString("view_sys_info"));

    panelMain.setLayout(new javax.swing.BoxLayout(panelMain, javax.swing.BoxLayout.Y_AXIS));
    panelMain.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)),
                                                              new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10))));
                                                               // Border = 1px broad, black
    labelSysInfo.setText(Messages.getString("sys_info")); //$NON-NLS-1$ // "Some info about this program and your system:"
    panelMain.add(labelSysInfo);
    textAreaSysInfo.setAlignmentX(0.0F);
    textAreaSysInfo.setEditable(false); // .setBorder
    textAreaSysInfo.setWrapStyleWord(true);
    textAreaSysInfo.setText(sInfo.sysInfoWithSettingsText);

    panelSysInfo.setLayout(new javax.swing.BoxLayout(panelSysInfo, javax.swing.BoxLayout.Y_AXIS));
    panelSysInfo.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.LineBorder(new java.awt.Color(255, 0, 0)), new javax.swing.border.EmptyBorder(new java.awt.Insets(3, 3, 3, 3))));
//    panelSysInfo.add(labelSysInfo); // OOPS, THIS DIDN'T SHOW UP - only for topmost panel?
    panelMain.add(textAreaSysInfo);

    buttonCopyInfo.setText(Messages.getString("copy_this_info")); //$NON-NLS-1$
    buttonCopyInfo.setToolTipText(Messages.getString("sys_info_copy_clipb")); //$NON-NLS-1$
    buttonCopyInfo.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            onCopy();
        }
    });

    buttonOK.setText(Messages.getString("ok")); //$NON-NLS-1$
  
    // close this dialog with [Enter], [Space] or [Esc]
    ActionListener closeListener = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            onOK();
        }
    };
    buttonOK.addActionListener(closeListener);
    buttonOK.registerKeyboardAction(closeListener, 
                             KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
                             JComponent.WHEN_FOCUSED);  // WHEN_FOCUSED
    buttonOK.registerKeyboardAction(closeListener, 
                             KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 0),
                             JComponent.WHEN_FOCUSED);  // WHEN_FOCUSED
    buttonOK.registerKeyboardAction(closeListener, 
                             KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
                             JComponent.WHEN_IN_FOCUSED_WINDOW); // WHEN_IN_FOCUSED_WINDOW

    panelButtons.setAlignmentX(0.0F);
    panelButtons.add(buttonCopyInfo);
    panelButtons.add(buttonOK);

    panelMain.add(panelButtons);
    getContentPane().add(panelMain, java.awt.BorderLayout.CENTER);
    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

    pack();
    getRootPane().setDefaultButton(buttonOK);
    buttonOK.requestFocusInWindow();
  }

    private void onOK() {
        setVisible(false);
        dispose();
    }
  
    // copy this system's info to clipboard 
    private void onCopy() {
      final String NL = Main.NEW_LINE;
      String forTheClipboard = sInfo.sysInfoWithSettingsTextEN;
      StringSelection myStringSelection = new StringSelection(forTheClipboard);
      Clipboard myClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
      myClipboard.setContents(myStringSelection, null);
    }
}
