%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2009-2024. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%% This file is generated DO NOT EDIT

-module(wxSpinEvent).
-moduledoc """
Functions for wxSpinEvent class

This event class is used for the events generated by `m:wxSpinButton` and
`m:wxSpinCtrl`.

See: `m:wxSpinButton`, and, `m:wxSpinCtrl`

This class is derived (and can use functions) from: `m:wxNotifyEvent`
`m:wxCommandEvent` `m:wxEvent`

wxWidgets docs:
[wxSpinEvent](https://docs.wxwidgets.org/3.1/classwx_spin_event.html)

## Events

Use `wxEvtHandler:connect/3` with [`wxSpinEventType`](`t:wxSpinEventType/0`) to
subscribe to events of this type.
""".
-include("wxe.hrl").
-export([getPosition/1,setPosition/2]).

%% inherited exports
-export([allow/1,getClientData/1,getExtraLong/1,getId/1,getInt/1,getSelection/1,
  getSkipped/1,getString/1,getTimestamp/1,isAllowed/1,isChecked/1,isCommandEvent/1,
  isSelection/1,parent_class/1,resumePropagation/2,setInt/2,setString/2,
  shouldPropagate/1,skip/1,skip/2,stopPropagation/1,veto/1]).

-type wxSpinEvent() :: wx:wx_object().
-include("wx.hrl").
-type wxSpinEventType() :: 'command_spinctrl_updated' | 'spin_up' | 'spin_down' | 'spin'.
-export_type([wxSpinEvent/0, wxSpin/0, wxSpinEventType/0]).
%% @hidden
-doc false.
parent_class(wxNotifyEvent) -> true;
parent_class(wxCommandEvent) -> true;
parent_class(wxEvent) -> true;
parent_class(_Class) -> erlang:error({badtype, ?MODULE}).

%% @doc See <a href="http://www.wxwidgets.org/manuals/2.8.12/wx_wxspinevent.html#wxspineventgetposition">external documentation</a>.
-doc "Retrieve the current spin button or control value.".
-spec getPosition(This) -> integer() when
	This::wxSpinEvent().
getPosition(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxSpinEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxSpinEvent_GetPosition),
  wxe_util:rec(?wxSpinEvent_GetPosition).

%% @doc See <a href="http://www.wxwidgets.org/manuals/2.8.12/wx_wxspinevent.html#wxspineventsetposition">external documentation</a>.
-doc "Set the value associated with the event.".
-spec setPosition(This, Pos) -> 'ok' when
	This::wxSpinEvent(), Pos::integer().
setPosition(#wx_ref{type=ThisT}=This,Pos)
 when is_integer(Pos) ->
  ?CLASS(ThisT,wxSpinEvent),
  wxe_util:queue_cmd(This,Pos,?get_env(),?wxSpinEvent_SetPosition).

 %% From wxNotifyEvent
%% @hidden
-doc false.
veto(This) -> wxNotifyEvent:veto(This).
%% @hidden
-doc false.
isAllowed(This) -> wxNotifyEvent:isAllowed(This).
%% @hidden
-doc false.
allow(This) -> wxNotifyEvent:allow(This).
 %% From wxCommandEvent
%% @hidden
-doc false.
setString(This,String) -> wxCommandEvent:setString(This,String).
%% @hidden
-doc false.
setInt(This,IntCommand) -> wxCommandEvent:setInt(This,IntCommand).
%% @hidden
-doc false.
isSelection(This) -> wxCommandEvent:isSelection(This).
%% @hidden
-doc false.
isChecked(This) -> wxCommandEvent:isChecked(This).
%% @hidden
-doc false.
getString(This) -> wxCommandEvent:getString(This).
%% @hidden
-doc false.
getSelection(This) -> wxCommandEvent:getSelection(This).
%% @hidden
-doc false.
getInt(This) -> wxCommandEvent:getInt(This).
%% @hidden
-doc false.
getExtraLong(This) -> wxCommandEvent:getExtraLong(This).
%% @hidden
-doc false.
getClientData(This) -> wxCommandEvent:getClientData(This).
 %% From wxEvent
%% @hidden
-doc false.
stopPropagation(This) -> wxEvent:stopPropagation(This).
%% @hidden
-doc false.
skip(This, Options) -> wxEvent:skip(This, Options).
%% @hidden
-doc false.
skip(This) -> wxEvent:skip(This).
%% @hidden
-doc false.
shouldPropagate(This) -> wxEvent:shouldPropagate(This).
%% @hidden
-doc false.
resumePropagation(This,PropagationLevel) -> wxEvent:resumePropagation(This,PropagationLevel).
%% @hidden
-doc false.
isCommandEvent(This) -> wxEvent:isCommandEvent(This).
%% @hidden
-doc false.
getTimestamp(This) -> wxEvent:getTimestamp(This).
%% @hidden
-doc false.
getSkipped(This) -> wxEvent:getSkipped(This).
%% @hidden
-doc false.
getId(This) -> wxEvent:getId(This).
