/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class NewAlbumDialog
extends JDialog
implements ActionListener,
ItemListener,
FocusListener {
    public static final String MODULE = "NewAlbum";
    Gallery gallery = null;
    Album defaultAlbum = null;
    Album newAlbum = null;
    Album parentAlbum = null;
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JTextField jTitle = new JTextField();
    JTextField jName = new JTextField();
    JTextArea jDescription = new JTextArea();
    JLabel jLabel1 = new JLabel();
    JLabel jGalleryName = new JLabel();
    JComboBox jAlbum = null;
    JPanel jPanel2 = new JPanel();
    JButton jOk = new JButton();
    JButton jCancel = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    private static final String ILLEGAL_CHARACTERS = "[ \\\\/*?\"'&|.+#]";

    public NewAlbumDialog(Frame owner, Gallery gallery, Album defaultAlbum) {
        super(owner, true);
        this.gallery = gallery;
        this.defaultAlbum = defaultAlbum;
        this.jbInit();
        this.pack();
        DialogUtil.center(this, owner);
        this.setVisible(true);
    }

    private void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setTitle(GRI18n.getString(MODULE, "title"));
        Vector albums = new Vector(this.gallery.getFlatAlbumList());
        this.jAlbum = new JComboBox(albums);
        this.jAlbum.setRenderer(new AlbumListRenderer());
        if (this.defaultAlbum == null) {
            this.jAlbum.setSelectedItem(this.gallery.getRoot());
        } else {
            this.jAlbum.setSelectedItem(this.defaultAlbum);
        }
        this.jCancel.setText(GRI18n.getString("Common", "Cancel"));
        this.jCancel.setActionCommand("Cancel");
        this.jDescription.setBorder(BorderFactory.createBevelBorder(1, Color.white, Color.lightGray, Color.darkGray, Color.gray));
        this.jDescription.setLineWrap(true);
        this.jDescription.setWrapStyleWord(true);
        JScrollPane descriptionArea = new JScrollPane(this.jDescription, 20, 30);
        descriptionArea.setPreferredSize(new Dimension(250, 100));
        this.jAlbum.setFont(UIManager.getFont("Label.font"));
        this.jGalleryName.setText(GRI18n.getString(MODULE, "createAlbm", new String[]{this.gallery.toString()}));
        this.jName.setFont(UIManager.getFont("Label.font"));
        this.jName.setToolTipText(GRI18n.getString(MODULE, "albmNameTip"));
        this.jOk.setText(GRI18n.getString("Common", "OK"));
        this.jOk.setActionCommand("OK");
        this.jTitle.setFont(UIManager.getFont("Label.font"));
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(5);
        this.jLabel2.setText(GRI18n.getString(MODULE, "parentAlbm"));
        this.jLabel3.setText(GRI18n.getString(MODULE, "albmTitle"));
        this.jLabel4.setText(GRI18n.getString(MODULE, "albmName"));
        this.jLabel5.setText(GRI18n.getString(MODULE, "albmDesc"));
        this.jPanel2.setLayout(this.gridLayout1);
        this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 4));
        this.getContentPane().add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 0, 5), 0, 4));
        this.getContentPane().add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 0, 5), 0, 4));
        this.getContentPane().add((Component)this.jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 0, 5), 0, 3));
        this.getContentPane().add((Component)this.jTitle, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jName, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)descriptionArea, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jGalleryName, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.jAlbum, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jPanel2, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel2.add((Component)this.jCancel, null);
        this.jPanel2.add((Component)this.jOk, null);
        this.jOk.addActionListener(this);
        this.jCancel.addActionListener(this);
        this.jAlbum.addItemListener(this);
        this.jName.addFocusListener(this);
        this.jTitle.addFocusListener(this);
        this.getRootPane().setDefaultButton(this.jOk);
        this.resetUIState();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Log.log(2, MODULE, "Command selected " + command);
        if (command.equals("Cancel")) {
            this.setVisible(false);
        } else if (command.equals("OK")) {
            this.newAlbum = new Album(this.gallery);
            this.newAlbum.setName(this.jName.getText());
            this.newAlbum.setTitle(this.jTitle.getText());
            this.newAlbum.setCaption(this.jDescription.getText());
            this.parentAlbum = (Album)this.jAlbum.getSelectedItem();
            this.parentAlbum.getGallery().insertNodeInto(this.newAlbum, this.parentAlbum, this.parentAlbum.getChildCount());
            this.setVisible(false);
        }
    }

    public Album getNewAlbum() {
        return this.newAlbum;
    }

    public Album getParentAlbum() {
        return this.parentAlbum;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.resetUIState();
        }
    }

    void resetUIState() {
        Album a = (Album)this.jAlbum.getSelectedItem();
        boolean canCreateSubAlbum = a.getCanCreateSubAlbum();
        this.jOk.setEnabled(canCreateSubAlbum);
        this.jName.setEnabled(canCreateSubAlbum);
        this.jTitle.setEnabled(canCreateSubAlbum);
        this.jDescription.setEnabled(canCreateSubAlbum);
    }

    public void focusGained(FocusEvent e) {
        ((JTextField)e.getSource()).selectAll();
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.jTitle && this.jName.getText().length() == 0) {
            this.jName.setText(NewAlbumDialog.getDefaultName(this.jTitle.getText()));
        }
    }

    static String getDefaultName(String text) {
        String r = text.toLowerCase();
        r = r.replaceAll("[&]", "and");
        r = r.replaceAll(ILLEGAL_CHARACTERS, "_");
        return r.replaceAll("_{2,}", "_");
    }

    public class AlbumListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (((Album)value).getCanCreateSubAlbum()) {
                if (!isSelected) {
                    this.setForeground(Color.BLACK);
                }
            } else {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }
}

