/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpregress;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.utils.FileUtils;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public class GtpRegress
implements GtpClient.IOCallback {
    private boolean m_lastError;
    private boolean m_longOutput;
    private boolean m_result = true;
    private boolean m_verbose;
    private int m_lastCommandId;
    private int m_lastSgfMove;
    private int m_otherErrors;
    private File m_testFile;
    private PrintStream m_out;
    private final Set m_dataFiles = new TreeSet();
    private static final String COLOR_ERROR = "#ffa954";
    private static final String COLOR_HEADER = "#91aee8";
    private static final String COLOR_INFO = "#e0e0e0";
    private static final String COLOR_BG_LIGHT = "#e0e0e0";
    private static final String COLOR_BG_GRAY = "#e0e0e0";
    private static final String COLOR_GREEN = "#5eaf5e";
    private static final String COLOR_RED = "#ff5454";
    private String m_currentStyle;
    private String m_lastCommand;
    private String m_lastFullResponse;
    private String m_lastResponse;
    private String m_lastSgf;
    private String m_name;
    private String m_outFileName;
    private String m_outFileRelativeName;
    private String m_outPrefix;
    private String m_prefix;
    private String m_program;
    private String m_relativePath;
    private String m_version;
    private final ArrayList m_tests = new ArrayList();
    private final ArrayList m_testSummaries = new ArrayList();
    private GtpClient m_gtp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpRegress(String string, String[] stringArray, String string2, boolean bl, boolean bl2) throws Exception {
        this.m_program = string;
        this.m_longOutput = bl;
        this.m_verbose = bl2;
        this.m_prefix = "";
        if (!string2.equals("")) {
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            this.m_prefix = string2 + File.separator;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_outPrefix = stringArray.length > 1 ? stringArray[i] + " " : "";
            this.runTest(stringArray[i]);
        }
        this.writeSummary();
        this.writeData();
    }

    public boolean getResult() {
        return this.m_result;
    }

    public void receivedInvalidResponse(String string) {
        this.printOutLine("invalid", "Invalid response: " + string);
    }

    public void receivedResponse(boolean bl, String string) {
    }

    public void receivedStdErr(String string) {
        this.printOut("stderr", string, -1);
    }

    public void sentCommand(String string) {
    }

    private void checkLastSgf(String string) {
        Matcher matcher;
        Pattern pattern;
        String string2;
        block4: {
            string2 = "[0-9]*\\s*loadsgf\\s+(\\S+\\.[Ss][Gg][Ff])\\s+([0-9]+)\\s*";
            pattern = Pattern.compile(string2);
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                this.m_lastSgf = matcher.group(1);
                try {
                    this.m_lastSgfMove = Integer.parseInt(matcher.group(2));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        if ((matcher = (pattern = Pattern.compile(string2 = "[0-9]*\\s*loadsgf\\s+(\\S+\\.[Ss][Gg][Ff])\\s*")).matcher(string)).matches()) {
            this.m_lastSgf = matcher.group(1);
            this.m_lastSgfMove = -1;
        }
    }

    private void finishOutFile() {
        if (this.m_currentStyle != null) {
            this.m_out.print("</span>");
        }
        this.m_out.print("</pre>\n</body>\n");
        this.m_out.close();
    }

    private int getId(String string) {
        int n = (string = string.replaceAll("\\t", "\n")).indexOf(32);
        if (n < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private TestSummary getTestSummary(long l, double d) {
        TestSummary testSummary = new TestSummary();
        testSummary.m_file = this.m_testFile;
        testSummary.m_timeMillis = l;
        testSummary.m_cpuTime = d;
        testSummary.m_otherErrors = this.m_otherErrors;
        for (int i = 0; i < this.m_tests.size(); ++i) {
            Test test = (Test)this.m_tests.get(i);
            ++testSummary.m_numberTests;
            if (test.m_fail && !test.m_expectedFail) {
                ++testSummary.m_unexpectedFails;
                continue;
            }
            if (test.m_fail && test.m_expectedFail) {
                ++testSummary.m_expectedFails;
                continue;
            }
            if (!test.m_fail && !test.m_expectedFail) {
                ++testSummary.m_expectedPasses;
                continue;
            }
            if (test.m_fail || !test.m_expectedFail) continue;
            ++testSummary.m_unexpectedPasses;
        }
        return testSummary;
    }

    private synchronized void handleLastResponse() {
        if (this.m_lastCommandId >= 0) {
            boolean bl = false;
            if (this.m_lastError) {
                this.printOutLine("fail", this.m_lastFullResponse);
                if (this.m_lastResponse.equals("")) {
                    System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected FAIL");
                } else {
                    System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected FAIL: '" + this.m_lastResponse + "'");
                }
                bl = true;
            } else {
                this.printOutLine("test", this.m_lastFullResponse);
            }
            this.m_tests.add(new Test(this.m_lastCommandId, this.m_lastCommand, bl, false, "", this.m_lastResponse, this.m_lastSgf, this.m_lastSgfMove));
        } else if (this.m_lastError) {
            this.printOutLine("error", this.m_lastFullResponse);
            ++this.m_otherErrors;
        } else {
            this.printOutLine(null, this.m_lastFullResponse);
        }
    }

    private void handleLine(String string) throws ProgramIsDeadException {
        if ((string = string.trim()).startsWith("#?")) {
            if (this.m_lastFullResponse == null) {
                System.err.println("Warning: " + this.m_testFile + ": Response pattern" + " without preceding test command: " + string);
                this.printOutLine("comment", string);
                return;
            }
            this.printOutLine("test", string);
            this.handleTest(string.substring(2).trim());
            this.m_lastFullResponse = null;
            return;
        }
        if (this.m_lastFullResponse != null) {
            this.handleLastResponse();
            this.m_lastFullResponse = null;
        }
        if (string.equals("")) {
            this.printOutLine(null, string);
        } else if (string.startsWith("#")) {
            this.printOutLine("comment", string);
        } else {
            block12: {
                string = string.replaceAll("\\t", " ");
                this.m_lastCommandId = this.getId(string);
                if (this.m_lastCommandId < 0) {
                    this.m_lastCommand = string;
                } else {
                    int n = string.indexOf(32);
                    this.m_lastCommand = string.substring(n + 1);
                }
                this.printOutLine(this.m_lastCommandId >= 0 ? "test" : "command", string, this.m_lastCommandId);
                this.checkLastSgf(string);
                this.m_lastError = false;
                if (!$assertionsDisabled && this.m_lastFullResponse != null) {
                    throw new AssertionError();
                }
                try {
                    this.m_lastResponse = this.m_gtp.send(string);
                }
                catch (GtpError gtpError) {
                    this.m_lastError = true;
                    this.m_lastResponse = gtpError.getMessage();
                    if (!this.m_gtp.isProgramDead()) break block12;
                    throw new ProgramIsDeadException();
                }
            }
            this.m_lastFullResponse = this.m_gtp.getFullResponse();
        }
    }

    private void handleTest(String string) {
        Object object;
        boolean bl = false;
        if (string.endsWith("*")) {
            bl = true;
            string = string.substring(0, string.length() - 1);
        }
        if (!string.startsWith("[") || !string.endsWith("]")) {
            this.handleLastResponse();
            return;
        }
        String string2 = string = string.substring(1, string.length() - 1).trim();
        boolean bl2 = false;
        if (string.startsWith("!")) {
            bl2 = true;
            string = string.substring(1);
        }
        boolean bl3 = false;
        String string3 = "";
        int n = this.m_lastFullResponse.indexOf(32);
        if (n >= 0) {
            string3 = this.m_lastFullResponse.substring(n).trim();
        }
        if (this.m_lastError) {
            bl3 = true;
        } else {
            object = Pattern.compile(string, 40);
            Matcher matcher = ((Pattern)object).matcher(string3);
            if (!matcher.matches() && !bl2 || matcher.matches() && bl2) {
                bl3 = true;
            }
        }
        if (bl3 && !bl) {
            this.m_result = false;
        }
        object = null;
        object = bl3 && !bl ? "fail" : (!bl3 && bl ? "pass" : "test");
        this.printOutLine((String)object, this.m_lastFullResponse);
        if (this.m_longOutput) {
            if (bl3 && !bl) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " FAILED: Correct '" + string2 + "', got '" + string3 + "'");
            } else if (bl3 && bl) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " failed: Correct '" + string2 + "', got '" + string3 + "'");
            } else if (!bl3 && bl) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " PASSED");
            } else if (!bl3 && !bl) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " passed");
            }
        } else if (bl3 && !bl) {
            System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected FAIL: Correct '" + string2 + "', got '" + string3 + "'");
        } else if (!bl3 && bl) {
            System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected PASS!");
        }
        this.m_tests.add(new Test(this.m_lastCommandId, this.m_lastCommand, bl3, bl, string2, string3, this.m_lastSgf, this.m_lastSgfMove));
    }

    private void initOutFile() throws Exception {
        this.m_outFileRelativeName = FileUtils.replaceExtension(this.m_testFile, "tst", "out.html");
        this.m_outFileName = this.m_prefix + this.m_outFileRelativeName;
        File file = new File(this.m_outFileName);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdir();
        }
        this.m_currentStyle = null;
        this.m_out = new PrintStream(new FileOutputStream(file));
        this.m_out.print("<html>\n<head>\n<title>Output: " + this.m_testFile + "</title>\n" + "<meta name=\"generator\" content=\"GtpRegress " + Version.get() + "\">\n" + "<style type=\"text/css\">\n" + "<!--\n" + "span.comment { color:#999999; }\n" + "span.fail { font-weight:bold; color:" + COLOR_RED + "; }\n" + "span.error { font-weight:bold; color:" + COLOR_ERROR + "; }\n" + "span.stderr { font-style: italic; color:#666666; }\n" + "span.invalid { background:" + COLOR_RED + ";}\n" + "span.pass { font-weight:bold; color:" + COLOR_GREEN + "; }\n" + "span.test { font-weight:bold; }\n" + "-->\n" + "</style>\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\"" + " link=\"#0000ee\" vlink=\"#551a8b\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>Output: " + this.m_testFile + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + "#e0e0e0" + "\">\n");
        this.writeInfo(this.m_out, false);
        this.m_out.print("</table>\n<pre>\n");
    }

    private synchronized void printOut(String string, String string2, int n) {
        Pattern pattern;
        Matcher matcher;
        if (string2 == null || string2.length() == 0) {
            return;
        }
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("<", "&lt;");
        if (string != null && (string.equals("command") || string.equals("test")) && (matcher = (pattern = Pattern.compile("\\S*\\.[Ss][Gg][Ff]")).matcher(string2)).find()) {
            String string3 = matcher.group();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2.substring(0, matcher.start()));
            stringBuffer.append("<a href=\"");
            stringBuffer.append(this.m_relativePath);
            stringBuffer.append(string3);
            stringBuffer.append("\">");
            stringBuffer.append(string3);
            stringBuffer.append("</a>");
            stringBuffer.append(string2.substring(matcher.end()));
            string2 = stringBuffer.toString();
        }
        if (string != this.m_currentStyle) {
            if (this.m_currentStyle != null) {
                this.m_out.print("</span>");
            }
            if (string != null) {
                this.m_out.print("<span class=\"" + string + "\">");
            }
            this.m_currentStyle = string;
        }
        if (n >= 0) {
            this.m_out.print("<a name=\"" + n + "\">");
        }
        this.m_out.print(string2);
        if (n >= 0) {
            this.m_out.print("</a>");
        }
    }

    private synchronized void printOutLine(String string, String string2, int n) {
        if (string2 == null) {
            return;
        }
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        this.printOut(string, string2, n);
    }

    private synchronized void printOutSeparator() {
        if (this.m_currentStyle != null) {
            this.m_out.print("</span>");
        }
        this.m_out.println("</pre>\n<hr>\n<pre>");
    }

    private synchronized void printOutLine(String string, String string2) {
        this.printOutLine(string, string2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String send(String string) throws GtpError {
        this.printOutLine(null, string);
        try {
            String string2 = this.m_gtp.send(string);
            return string2;
        }
        finally {
            this.printOutLine(null, this.m_gtp.getFullResponse());
        }
    }

    private double getCpuTime() {
        try {
            return Double.parseDouble(this.send("cputime"));
        }
        catch (GtpError gtpError) {
            return 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private TestSummary getTotalSummary() {
        TestSummary testSummary = new TestSummary();
        for (int i = 0; i < this.m_testSummaries.size(); ++i) {
            TestSummary testSummary2 = (TestSummary)this.m_testSummaries.get(i);
            testSummary.m_numberTests += testSummary2.m_numberTests;
            testSummary.m_otherErrors += testSummary2.m_otherErrors;
            testSummary.m_unexpectedFails += testSummary2.m_unexpectedFails;
            testSummary.m_expectedFails += testSummary2.m_expectedFails;
            testSummary.m_expectedPasses += testSummary2.m_expectedPasses;
            testSummary.m_unexpectedPasses += testSummary2.m_unexpectedPasses;
            testSummary.m_timeMillis += testSummary2.m_timeMillis;
            testSummary.m_cpuTime += testSummary2.m_cpuTime;
        }
        return testSummary;
    }

    private void runTest(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader;
        block9: {
            this.m_tests.clear();
            this.m_dataFiles.clear();
            this.m_otherErrors = 0;
            this.m_testFile = new File(string);
            this.initOutFile();
            File file = new File(this.m_outFileName);
            File file2 = this.m_testFile.getAbsoluteFile().getParentFile();
            this.m_relativePath = FileUtils.getRelativeURI(file, file2);
            if (!this.m_relativePath.equals("") && !this.m_relativePath.endsWith("/")) {
                this.m_relativePath = this.m_relativePath + "/";
            }
            FileReader fileReader = new FileReader(this.m_testFile);
            bufferedReader = new BufferedReader(fileReader);
            this.m_gtp = new GtpClient(this.m_program, this.m_verbose, this);
            this.m_lastSgf = null;
            try {
                this.m_name = this.send("name");
            }
            catch (GtpError gtpError) {
                this.m_name = "";
                if (!this.m_gtp.isProgramDead()) break block9;
                throw gtpError;
            }
        }
        try {
            this.m_version = this.send("version");
        }
        catch (GtpError gtpError) {
            this.m_version = "";
        }
        double d = this.getCpuTime();
        long l = System.currentTimeMillis();
        this.printOutSeparator();
        while ((string2 = bufferedReader.readLine()) != null) {
            this.handleLine(string2);
        }
        l = System.currentTimeMillis() - l;
        if (this.m_lastFullResponse != null) {
            this.handleLastResponse();
            this.m_lastFullResponse = null;
        }
        this.printOutSeparator();
        d = this.getCpuTime() - d;
        if (this.m_lastFullResponse != null) {
            this.handleLastResponse();
            this.m_lastFullResponse = null;
        }
        if (!this.m_gtp.isProgramDead()) {
            this.send("quit");
        }
        this.m_gtp.waitForExit();
        bufferedReader.close();
        this.finishOutFile();
        TestSummary testSummary = this.getTestSummary(l, d);
        this.m_testSummaries.add(testSummary);
        this.writeTestSummary(testSummary);
    }

    private String truncate(String string) {
        int n = 25;
        if (string.length() < n) {
            return string.trim();
        }
        return string.substring(0, n).trim() + "...";
    }

    private void writeInfo(PrintStream printStream, boolean bl) {
        String string = Platform.getHostInfo();
        if (bl) {
            printStream.print("<tr><th align=\"left\">Name:</th><td>" + this.m_name + "</td></tr>\n" + "<tr><th align=\"left\">Version:</th><td>" + this.m_version + "</td></tr>\n");
        }
        printStream.print("<tr><th align=\"left\">Date:</th><td>" + StringUtils.getDate() + "</td></tr>\n" + "<tr><th align=\"left\">Host:</th><td>" + string + "</td></tr>\n" + "<tr><th align=\"left\" valign=\"top\">Command:</th>\n" + "<td valign=\"top\"><tt>" + this.m_program + "</tt></td></tr>\n");
    }

    private void writeData() throws FileNotFoundException {
        File file = new File(this.m_prefix + "summary.dat");
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        NumberFormat numberFormat = StringUtils.getNumberFormat(1);
        TestSummary testSummary = this.getTotalSummary();
        double d = (double)testSummary.m_timeMillis / 1000.0;
        printStream.print("#Tests\tFAIL\tfail\tPASS\tpass\tError\tTime\tCpuTime\n" + testSummary.m_numberTests + "\t" + testSummary.m_unexpectedFails + "\t" + testSummary.m_expectedFails + "\t" + testSummary.m_unexpectedPasses + "\t" + testSummary.m_expectedPasses + "\t" + testSummary.m_otherErrors + "\t" + numberFormat.format(d) + "\t" + numberFormat.format(testSummary.m_cpuTime) + "\t" + "\n");
        printStream.close();
    }

    private void writeSummary() throws FileNotFoundException {
        File file = new File(this.m_prefix + "index.html");
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        printStream.print("<html>\n<head>\n<title>Regression Test Summary</title>\n<meta name=\"generator\" content=\"GtpRegress " + Version.get() + "\">\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\" link=\"blue\"" + " vlink=\"purple\" alink=\"red\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>Regression Test Summary</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + "#e0e0e0" + "\">\n");
        this.writeInfo(printStream, true);
        printStream.print("</table>\n<table width=\"100%\">\n<colgroup>\n<col width=\"20%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n</colgroup>\n<thead align=\"center\">\n<tr bgcolor = \"#91aee8\">\n<th>File</th>\n<th>Tests</th>\n<th>FAIL</th>\n<th>fail</th>\n<th>PASS</th>\n<th>pass</th>\n<th>Error</th>\n<th>Time</th>\n<th>CpuTime</th>\n</tr>\n</thead>\n");
        for (int i = 0; i < this.m_testSummaries.size(); ++i) {
            TestSummary testSummary = (TestSummary)this.m_testSummaries.get(i);
            this.writeSummaryRow(printStream, testSummary, true, false);
        }
        this.writeSummaryRow(printStream, this.getTotalSummary(), true, true);
        printStream.print("</table>\n</body>\n</html>\n");
        printStream.close();
    }

    private void writeSummaryRow(PrintStream printStream, TestSummary testSummary, boolean bl, boolean bl2) {
        File file = testSummary.m_file;
        if (bl2) {
            printStream.print("<tfoot align=\"center\">\n");
            printStream.print("<tr align=\"center\" bgcolor=\"#91aee8\">\n");
        } else {
            printStream.print("<tr align=\"center\" bgcolor=\"#e0e0e0\">\n");
        }
        if (bl) {
            if (bl2) {
                printStream.print("<td><b>Total</b></td>");
            } else {
                printStream.print("<td><a href=\"" + FileUtils.replaceExtension(file, "tst", "html") + "\">" + file + "</a></td>");
            }
        }
        double d = (double)testSummary.m_timeMillis / 1000.0;
        NumberFormat numberFormat = StringUtils.getNumberFormat(1);
        String string = "";
        if (testSummary.m_unexpectedFails > 0) {
            string = " bgcolor=\"#ff5454\"";
        }
        String string2 = "";
        if (testSummary.m_unexpectedPasses > 0) {
            string2 = " bgcolor=\"#5eaf5e\"";
        }
        String string3 = "";
        if (testSummary.m_otherErrors > 0) {
            string3 = " bgcolor=\"#ffa954\"";
        }
        printStream.print("<td>" + testSummary.m_numberTests + "</td>\n" + "<td" + string + ">" + testSummary.m_unexpectedFails + "</td>\n" + "<td>" + testSummary.m_expectedFails + "</td>\n" + "<td" + string2 + ">\n" + testSummary.m_unexpectedPasses + "</td>\n" + "<td>" + testSummary.m_expectedPasses + "</td>\n" + "<td" + string3 + ">\n" + testSummary.m_otherErrors + "</td>\n" + "<td>" + numberFormat.format(d) + "</td>\n" + "<td>" + numberFormat.format(testSummary.m_cpuTime) + "</td>\n" + "</tr>\n");
        if (bl2) {
            printStream.print("</tfoot>\n");
        }
    }

    private void writeTestSummary(TestSummary testSummary) throws FileNotFoundException {
        if (this.m_longOutput) {
            System.out.println("Summary: " + testSummary.getNumberPasses() + "/" + testSummary.m_numberTests + " passes. " + testSummary.m_unexpectedPasses + " unexpected passes, " + testSummary.m_unexpectedFails + " unexpected failures");
        }
        File file = new File(this.m_prefix + FileUtils.replaceExtension(this.m_testFile, "tst", "html"));
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        printStream.print("<html>\n<head>\n<title>Summary: " + this.m_testFile + "</title>\n" + "<meta name=\"generator\" content=\"GtpRegress " + Version.get() + "\">\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\" link=\"blue\"" + " vlink=\"purple\" alink=\"red\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>Summary: " + this.m_testFile + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + "#e0e0e0" + "\">\n");
        this.writeInfo(printStream, true);
        printStream.print("<tr><th align=\"left\">Output:</th><td><a href=\"" + this.m_outFileRelativeName + "\">" + this.m_outFileRelativeName + "</a></td></tr>\n" + "</table>\n" + "<table width=\"100%\">\n" + "<colgroup>\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "</colgroup>\n" + "<thead align=\"center\">\n" + "<tr bgcolor=\"" + COLOR_HEADER + "\">\n" + "<th>Tests</th>\n" + "<th>FAIL</th>\n" + "<th>fail</th>\n" + "<th>PASS</th>\n" + "<th>pass</th>\n" + "<th>Error</th>\n" + "<th>Time</th>\n" + "<th>CpuTime</th>\n" + "</tr>\n" + "</thead>\n");
        this.writeSummaryRow(printStream, testSummary, false, false);
        printStream.print("</table>\n<table width=\"100%\">\n<thead>\n<tr bgcolor=\"#91aee8\">\n<th>ID</th>\n<th>Status</th>\n<th>Command</th>\n<th>Output</th>\n<th>Required</th>\n<th>Last SGF</th>\n</tr>\n</thead>\n");
        for (int i = 0; i < this.m_tests.size(); ++i) {
            String string;
            Test test = (Test)this.m_tests.get(i);
            String string2 = string = "#e0e0e0";
            String string3 = null;
            if (test.m_fail && test.m_expectedFail) {
                string3 = "fail";
            } else if (test.m_fail && !test.m_expectedFail) {
                string2 = COLOR_RED;
                string3 = "FAIL";
            } else if (!test.m_fail && test.m_expectedFail) {
                string2 = COLOR_GREEN;
                string3 = "PASS";
            } else if (!test.m_fail && !test.m_expectedFail) {
                string3 = "pass";
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            String string4 = "";
            if (test.m_lastSgf != null) {
                string4 = "<a href=\"" + this.m_relativePath + test.m_lastSgf + "\">" + test.m_lastSgf + "</a>";
                if (test.m_lastSgfMove != -1) {
                    string4 = string4 + "&nbsp;" + test.m_lastSgfMove;
                }
            }
            String string5 = test.m_command.replaceAll(" ", "&nbsp;");
            printStream.print("<tr bgcolor=\"" + string + "\">\n" + "<td align=\"right\"><a href=\"" + this.m_outFileRelativeName + "#" + test.m_id + "\">" + test.m_id + "</a></td>\n" + "<td align=\"center\" bgcolor=\"" + string2 + "\">" + string3 + "</td>\n" + "<td>" + string5 + "</td>\n" + "<td align=\"center\">" + this.truncate(test.m_response) + "</td>\n" + "<td align=\"center\">" + this.truncate(test.m_required) + "</td>\n" + "<td>" + string4 + "</td>\n" + "</tr>\n");
        }
        printStream.print("</table>\n</body>\n</html>\n");
        printStream.close();
    }

    static {
        $assertionsDisabled = !GtpRegress.class.desiredAssertionStatus();
    }

    private static class TestSummary {
        public File m_file;
        public int m_numberTests;
        public int m_otherErrors;
        public int m_unexpectedFails;
        public int m_expectedFails;
        public int m_expectedPasses;
        public int m_unexpectedPasses;
        public long m_timeMillis;
        public double m_cpuTime;

        private TestSummary() {
        }

        public int getNumberPasses() {
            return this.m_expectedPasses + this.m_unexpectedPasses;
        }
    }

    private static class Test {
        public int m_id;
        public int m_lastSgfMove;
        public boolean m_expectedFail;
        public boolean m_fail;
        public String m_command;
        public String m_required;
        public String m_response;
        public String m_lastSgf;

        public Test(int n, String string, boolean bl, boolean bl2, String string2, String string3, String string4, int n2) {
            this.m_id = n;
            this.m_fail = bl;
            this.m_expectedFail = bl2;
            this.m_command = string;
            this.m_required = string2;
            this.m_response = string3;
            this.m_lastSgf = string4;
            this.m_lastSgfMove = n2;
        }
    }

    private static class ProgramIsDeadException
    extends Exception {
        private static final long serialVersionUID = 0L;

        private ProgramIsDeadException() {
        }

        public String getMessage() {
            return "Program died";
        }
    }
}

