/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.gtp.ReadThread;

public abstract class GtpEngine {
    private InputStream m_in;
    private final PrintStream m_log;
    private PrintStream m_out;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpEngine(PrintStream printStream) {
        this.m_log = printStream;
    }

    public abstract void interruptCommand();

    public abstract void handleCommand(GtpCommand var1) throws GtpError;

    public synchronized void log(String string) {
        if (!$assertionsDisabled && this.m_log == null) {
            throw new AssertionError();
        }
        this.m_log.println(string);
    }

    public void mainLoop(InputStream inputStream, OutputStream outputStream) throws IOException {
        GtpCommand gtpCommand;
        this.m_out = new PrintStream(outputStream);
        this.m_in = inputStream;
        ReadThread readThread = new ReadThread(this, this.m_in, this.m_log != null);
        readThread.start();
        do {
            if ((gtpCommand = readThread.getCommand()) == null) {
                return;
            }
            this.sendResponse(gtpCommand);
        } while (!gtpCommand.isQuit());
    }

    public static GoPoint parsePointArgument(String[] stringArray, int n) throws GtpError {
        if (stringArray.length != 2) {
            throw new GtpError("Missing point argument");
        }
        return GtpUtils.parsePoint(stringArray[1], n);
    }

    public static ArrayList parsePointListArgument(String[] stringArray, int n) throws GtpError {
        int n2 = stringArray.length;
        if (!$assertionsDisabled && n2 < 1) {
            throw new AssertionError();
        }
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>();
        for (int i = 1; i < n2; ++i) {
            GoPoint goPoint = GtpUtils.parsePoint(stringArray[i], n);
            arrayList.add(goPoint);
        }
        return arrayList;
    }

    public void printInvalidResponse(String string) {
        this.m_out.print(string);
    }

    public void respond(boolean bl, boolean bl2, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (bl) {
            stringBuffer.append('=');
        } else {
            stringBuffer.append('?');
        }
        if (bl2) {
            stringBuffer.append(n);
        }
        stringBuffer.append(' ');
        stringBuffer.append(string);
        if (string.length() == 0 || string.charAt(string.length() - 1) != '\n') {
            stringBuffer.append('\n');
        }
        this.m_out.println(stringBuffer);
        if (this.m_log != null) {
            this.m_log.println(stringBuffer);
        }
    }

    private void sendResponse(GtpCommand gtpCommand) {
        String string;
        boolean bl = true;
        try {
            this.handleCommand(gtpCommand);
            string = gtpCommand.getResponse().toString();
        }
        catch (GtpError gtpError) {
            string = gtpError.getMessage();
            bl = false;
        }
        String string2 = string.replaceAll("\\n\\n", "\n \n");
        this.respond(bl, gtpCommand.hasId(), gtpCommand.getId(), string2);
    }

    static {
        $assertionsDisabled = !GtpEngine.class.desiredAssertionStatus();
    }
}

