/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpdisplay;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.GuiBoardUtils;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.gui.StatusBar;

public class GtpDisplay
extends GtpEngine {
    private int m_size;
    private final Board m_board;
    private GoColor m_color;
    private final GuiBoard m_guiBoard;
    private GoPoint m_fieldClicked;
    private final GtpClient m_gtp;
    private Move m_move;
    private final Object m_mutex = new Object();
    private JFrame m_frame;
    private final StatusBar m_statusBar;
    private final String m_name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpDisplay(String string, boolean bl, boolean bl2) throws Exception {
        super(null);
        Object object;
        if (string != null && !string.equals("")) {
            this.m_gtp = new GtpClient(string, bl, null);
            this.m_gtp.queryProtocolVersion();
            this.m_gtp.querySupportedCommands();
        } else {
            this.m_gtp = null;
        }
        this.m_size = 19;
        this.m_board = new Board(this.m_size);
        this.m_frame = new JFrame();
        this.m_frame.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GtpDisplay.this.closeFrame();
            }
        };
        this.m_frame.addWindowListener(windowAdapter);
        if (this.m_gtp == null) {
            this.m_name = null;
            this.m_frame.setTitle("GtpDisplay");
        } else {
            this.m_name = this.m_gtp.queryName();
            object = "GtpDisplay: " + this.m_name;
            this.m_frame.setTitle((String)object);
        }
        object = this.m_frame.getContentPane();
        this.m_guiBoard = new GuiBoard(this.m_size, bl2);
        if (this.m_gtp != null) {
            this.m_guiBoard.setShowCursor(false);
        }
        this.m_guiBoard.setListener(new GuiBoard.Listener(){

            public void contextMenu(GoPoint goPoint, Component component, int n, int n2) {
            }

            public void fieldClicked(GoPoint goPoint, boolean bl) {
                GtpDisplay.this.cbFieldClicked(goPoint, bl);
            }
        });
        ((Container)object).add(this.m_guiBoard);
        this.m_statusBar = new StatusBar();
        ((Container)object).add((Component)this.m_statusBar, "South");
        GuiUtils.setGoIcon(this.m_frame);
        this.m_frame.pack();
        this.m_frame.setVisible(true);
    }

    public void close() {
        if (this.m_gtp != null) {
            this.m_gtp.close();
            this.m_gtp.waitForExit();
        }
        try {
            this.invokeAndWait(new Runnable(){

                public void run() {
                    if (GtpDisplay.this.m_frame != null) {
                        SimpleDialogs.showInfo(GtpDisplay.this.m_frame, "GTP stream was closed");
                        GtpDisplay.this.showStatus("GTP stream was closed");
                    } else if (GtpDisplay.this.m_gtp == null) {
                        System.exit(0);
                    }
                }
            });
        }
        catch (GtpError gtpError) {
            System.err.println(gtpError.getMessage());
        }
    }

    public void handleCommand(GtpCommand gtpCommand) throws GtpError {
        if (gtpCommand.getCommand().equals("black")) {
            this.cmdPlay(GoColor.BLACK, gtpCommand);
        } else if (gtpCommand.getCommand().equals("boardsize")) {
            this.cmdBoardsize(gtpCommand);
        } else if (gtpCommand.getCommand().equals("clear_board")) {
            this.cmdClearBoard(gtpCommand);
        } else if (gtpCommand.getCommand().equals("genmove")) {
            this.cmdGenmove(gtpCommand);
        } else if (gtpCommand.getCommand().equals("genmove_black")) {
            this.cmdUnknown();
        } else if (gtpCommand.getCommand().equals("genmove_white")) {
            this.cmdUnknown();
        } else if (gtpCommand.getCommand().equals("help")) {
            this.cmdListCommands(gtpCommand);
        } else if (gtpCommand.getCommand().equals("komi")) {
            this.cmdKomi(gtpCommand);
        } else if (gtpCommand.getCommand().equals("list_commands")) {
            this.cmdListCommands(gtpCommand);
        } else if (gtpCommand.getCommand().equals("loadsgf")) {
            this.cmdUnknown();
        } else if (gtpCommand.getCommand().equals("name")) {
            this.cmdName(gtpCommand);
        } else if (gtpCommand.getCommand().equals("place_free_handicap")) {
            this.cmdPlaceFreeHandicap(gtpCommand);
        } else if (gtpCommand.getCommand().equals("play")) {
            this.cmdPlay(gtpCommand);
        } else if (gtpCommand.getCommand().equals("protocol_version")) {
            gtpCommand.setResponse("2");
        } else if (gtpCommand.getCommand().equals("set_free_handicap")) {
            this.cmdSetFreeHandicap(gtpCommand);
        } else if (gtpCommand.getCommand().equals("version")) {
            this.cmdVersion();
        } else if (gtpCommand.getCommand().equals("undo")) {
            this.cmdUndo(gtpCommand);
        } else if (gtpCommand.getCommand().equals("white")) {
            this.cmdPlay(GoColor.WHITE, gtpCommand);
        } else if (gtpCommand.getCommand().equals("quit")) {
            this.cmdQuit(gtpCommand);
        } else {
            if (this.m_gtp == null) {
                throw new GtpError("unknown command");
            }
            this.send(gtpCommand.getLine(), gtpCommand.getResponse());
        }
    }

    public void interruptCommand() {
        if (this.m_gtp == null) {
            return;
        }
        try {
            if (this.m_gtp.isInterruptSupported()) {
                this.m_gtp.sendInterrupt();
            }
        }
        catch (GtpError gtpError) {
            System.err.println(gtpError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cbFieldClicked(GoPoint goPoint, boolean bl) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.m_board.getColor(goPoint) != GoColor.EMPTY) {
            return;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_fieldClicked = bl ? null : goPoint;
            this.m_mutex.notifyAll();
        }
    }

    private void clearStatus() {
        this.m_statusBar.clear();
    }

    private void closeFrame() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.m_gtp == null) {
            if (!SimpleDialogs.showQuestion(this.m_frame, "Terminate GtpDisplay?")) {
                return;
            }
            System.exit(0);
        }
        this.m_frame.dispose();
        this.m_frame = null;
    }

    private void cmdBoardsize(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(1);
        int n = gtpCommand.getIntArg(0, 1, 25);
        if (this.m_gtp != null) {
            String string = this.m_gtp.getCommandBoardsize(n);
            if (string != null) {
                this.send(string);
            }
            string = this.m_gtp.getCommandClearBoard(n);
            this.send(string);
        }
        this.m_size = n;
        this.invokeAndWait(new Runnable(){

            public void run() {
                GtpDisplay.this.m_board.initSize(GtpDisplay.this.m_size);
                GtpDisplay.this.m_guiBoard.initSize(GtpDisplay.this.m_size);
                GtpDisplay.this.m_frame.pack();
                GtpDisplay.this.updateFromGoBoard();
            }
        });
    }

    private void cmdClearBoard(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        if (this.m_gtp != null) {
            String string = this.m_gtp.getCommandClearBoard(this.m_size);
            this.send(string);
        }
        this.invokeAndWait(new Runnable(){

            public void run() {
                GtpDisplay.this.m_board.newGame();
                GtpDisplay.this.updateFromGoBoard();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdGenmove(GtpCommand gtpCommand) throws GtpError {
        GoPoint goPoint;
        GoColor goColor = gtpCommand.getColorArg();
        if (this.m_gtp == null && this.m_frame != null) {
            this.m_color = goColor;
            this.invokeAndWait(new Runnable(){

                public void run() {
                    GtpDisplay.this.showStatus("Input move for " + GtpDisplay.this.m_color + " (right click for pass)");
                }
            });
            Object object = this.m_mutex;
            synchronized (object) {
                try {
                    this.m_mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("InterruptedException");
                }
                goPoint = this.m_fieldClicked;
            }
            gtpCommand.setResponse(GoPoint.toString(goPoint));
        } else {
            String string = this.m_gtp.getCommandGenmove(goColor);
            StringBuffer stringBuffer = gtpCommand.getResponse();
            this.send(string, stringBuffer);
            if (stringBuffer.toString().trim().equalsIgnoreCase("resign")) {
                return;
            }
            goPoint = GtpUtils.parsePoint(stringBuffer.toString(), this.m_size);
        }
        this.m_move = Move.get(goPoint, goColor);
        this.invokeAndWait(new Runnable(){

            public void run() {
                GtpDisplay.this.m_board.play(GtpDisplay.this.m_move);
                GtpDisplay.this.updateFromGoBoard();
                GtpDisplay.this.clearStatus();
            }
        });
    }

    private void cmdKomi(GtpCommand gtpCommand) throws GtpError {
        if (this.m_gtp == null) {
            return;
        }
        this.send(gtpCommand.getLine(), gtpCommand.getResponse());
    }

    private void cmdListCommands(GtpCommand gtpCommand) throws GtpError {
        if (this.m_gtp != null) {
            ArrayList arrayList = this.m_gtp.getSupportedCommands();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                if (string.equals("boardsize") || string.equals("black") || string.equals("clear_board") || string.equals("genmove") || string.equals("genmove_black") || string.equals("genmove_white") || string.equals("help") || string.equals("komi") || string.equals("list_commands") || string.equals("play") || string.equals("protocol_version") || string.equals("quit") || string.equals("white")) continue;
                gtpCommand.getResponse().append(string);
                gtpCommand.getResponse().append("\n");
            }
        }
        gtpCommand.getResponse().append("boardsize\n");
        gtpCommand.getResponse().append("clear_board\n");
        gtpCommand.getResponse().append("genmove\n");
        gtpCommand.getResponse().append("komi\n");
        gtpCommand.getResponse().append("list_commands\n");
        gtpCommand.getResponse().append("play\n");
        gtpCommand.getResponse().append("protocol_version\n");
        gtpCommand.getResponse().append("quit\n");
    }

    private void cmdName(GtpCommand gtpCommand) {
        if (this.m_gtp == null) {
            gtpCommand.setResponse("GtpDisplay");
        } else {
            gtpCommand.setResponse(this.m_name);
        }
    }

    private void cmdPlaceFreeHandicap(GtpCommand gtpCommand) throws GtpError {
        int n = gtpCommand.getIntArg();
        ArrayList arrayList = Board.getHandicapStones(this.m_size, n);
        if (arrayList == null) {
            throw new GtpError("Invalid number of handicap stones");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < arrayList.size(); ++i) {
            GoPoint goPoint = (GoPoint)arrayList.get(i);
            this.play(GoColor.BLACK, goPoint);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(goPoint);
        }
        gtpCommand.setResponse(stringBuffer.toString());
    }

    private void cmdPlay(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(2);
        GoColor goColor = gtpCommand.getColorArg(0);
        GoPoint goPoint = gtpCommand.getPointArg(1, this.m_size);
        this.play(goColor, goPoint);
    }

    private void cmdPlay(GoColor goColor, GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(1);
        GoPoint goPoint = gtpCommand.getPointArg(0, this.m_size);
        this.play(goColor, goPoint);
    }

    private void cmdQuit(GtpCommand gtpCommand) throws GtpError {
        if (this.m_gtp != null) {
            this.send("quit", gtpCommand.getResponse());
        }
    }

    private void cmdSetFreeHandicap(GtpCommand gtpCommand) throws GtpError {
        for (int i = 0; i < gtpCommand.getNuArg(); ++i) {
            this.play(GoColor.BLACK, gtpCommand.getPointArg(i, this.m_size));
        }
    }

    private void cmdUndo(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        this.undo();
    }

    private void cmdUnknown() throws GtpError {
        throw new GtpError("Unknown command");
    }

    private void cmdVersion() {
    }

    private void invokeAndWait(Runnable runnable) throws GtpError {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            throw new GtpError("InterruptedException");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GtpError("InvocationTargetException");
        }
    }

    private void play(GoColor goColor, GoPoint goPoint) throws GtpError {
        if (this.m_gtp != null) {
            String string = this.m_gtp.getCommandPlay(Move.get(goPoint, goColor));
            this.send(string);
        }
        this.m_move = Move.get(goPoint, goColor);
        this.invokeAndWait(new Runnable(){

            public void run() {
                GtpDisplay.this.m_board.play(GtpDisplay.this.m_move);
                GtpDisplay.this.updateFromGoBoard();
            }
        });
    }

    private void send(String string, StringBuffer stringBuffer) throws GtpError {
        stringBuffer.append(this.m_gtp.send(string));
    }

    private void send(String string) throws GtpError {
        this.m_gtp.send(string);
    }

    private void showStatus(String string) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.m_statusBar.setText(string);
    }

    private void undo() throws GtpError {
        if (this.m_gtp != null) {
            this.send("undo");
        }
        this.invokeAndWait(new Runnable(){

            public void run() {
                GtpDisplay.this.m_board.undo();
                GtpDisplay.this.updateFromGoBoard();
            }
        });
    }

    private void updateFromGoBoard() {
        GuiBoardUtils.updateFromGoBoard(this.m_guiBoard, this.m_board, true);
    }

    static {
        $assertionsDisabled = !GtpDisplay.class.desiredAssertionStatus();
    }
}

