/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.go.Score;
import net.sf.gogui.gui.GuiUtils;

public class ScoreDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    private final JButton m_cancelButton;
    private final JTextField m_territoryBlack;
    private final JTextField m_territoryWhite;
    private final JTextField m_areaBlack;
    private final JTextField m_areaWhite;
    private final JTextField m_capturedBlack;
    private final JTextField m_capturedWhite;
    private final JTextField m_komi;
    private final JTextField m_resultChinese;
    private final JTextField m_resultJapanese;
    private final JTextField m_rules;
    private final JTextField m_result;

    public ScoreDialog(Frame frame, ActionListener actionListener) {
        super(frame, "Score");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ScoreDialog.this.close();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 2));
        this.m_territoryBlack = this.createEntry(jPanel, "Territory Black:");
        this.m_territoryWhite = this.createEntry(jPanel, "Territory White:");
        this.m_areaBlack = this.createEntry(jPanel, "Area Black:");
        this.m_areaWhite = this.createEntry(jPanel, "Area White:");
        this.m_capturedBlack = this.createEntry(jPanel, "Captured Black:");
        this.m_capturedWhite = this.createEntry(jPanel, "Captured White:");
        this.m_komi = this.createEntry(jPanel, "Komi:");
        this.m_resultChinese = this.createEntry(jPanel, "Result Chinese:");
        this.m_resultJapanese = this.createEntry(jPanel, "Result Japanese:");
        this.m_rules = this.createEntry(jPanel, "Rules:");
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
        this.m_result = this.createEntry(jPanel2, "Game result:");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(GuiUtils.createFiller());
        jPanel3.add(GuiUtils.createFiller());
        jPanel3.add(jPanel2);
        JButton jButton = new JButton("Ok");
        jButton.setActionCommand("score-done");
        jButton.addActionListener(actionListener);
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.setActionCommand("score-cancel");
        this.m_cancelButton.addActionListener(actionListener);
        Object[] objectArray = new Object[]{jButton, this.m_cancelButton};
        JOptionPane jOptionPane = new JOptionPane(jPanel3, -1, 2, null, objectArray, objectArray[0]);
        this.setContentPane(jOptionPane);
        this.pack();
    }

    public void showScore(Score score) {
        this.m_territoryBlack.setText(Integer.toString(score.m_territoryBlack));
        this.m_territoryWhite.setText(Integer.toString(score.m_territoryWhite));
        this.m_areaBlack.setText(Integer.toString(score.m_areaBlack));
        this.m_areaWhite.setText(Integer.toString(score.m_areaWhite));
        this.m_capturedBlack.setText(Integer.toString(score.m_capturedBlack));
        this.m_capturedWhite.setText(Integer.toString(score.m_capturedWhite));
        this.m_komi.setText(GameInformation.roundKomi(score.m_komi));
        this.m_resultChinese.setText(Score.formatResult(score.m_resultChinese));
        this.m_resultJapanese.setText(Score.formatResult(score.m_resultJapanese));
        this.m_rules.setText(score.m_rules == 2 ? "Japanese" : "Chinese");
        this.m_result.setText(score.formatResult());
    }

    private void close() {
        this.m_cancelButton.doClick();
        this.dispose();
    }

    private JTextField createEntry(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField("        ");
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        jTextField.setHorizontalAlignment(2);
        jPanel.add(jTextField);
        return jTextField;
    }
}

