/*
 * Decompiled with CFR 0.152.
 */
package free.jin.gamelogger;

import bsh.EvalError;
import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.Preferences;
import free.jin.gamelogger.GameLogger;
import free.jin.gamelogger.LoggingRule;
import free.jin.ui.OptionPanel;
import free.jin.ui.PreferencesPanel;
import free.util.swing.ExtensionFileFilter;
import free.workarounds.FixedJTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class GameLoggerPreferencesPanel
extends PreferencesPanel {
    protected final GameLogger gameLogger;
    private JRadioButton logNoneButton;
    private JRadioButton logAllButton;
    private JRadioButton useRulesButton;
    private JTextField allGamesLogFileField;
    private JList loggingRulesList;
    private JTextField rulenameField;
    private JTextField filenameField;
    private JTextField conditionField;
    private JButton deleteRuleButton;
    private JPanel logAllPanel;
    private JPanel useRulesPanel;
    private JPanel rulePropertiesPanel;
    private boolean ignoreRuleFieldsDocumentChange = false;
    private boolean ignoreRulesListSelectionChange = false;
    private int rulesListSelectedIndex = -1;
    private final DocumentListener changeFiringDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!GameLoggerPreferencesPanel.this.ignoreRuleFieldsDocumentChange) {
                GameLoggerPreferencesPanel.this.fireStateChanged();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!GameLoggerPreferencesPanel.this.ignoreRuleFieldsDocumentChange) {
                GameLoggerPreferencesPanel.this.fireStateChanged();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!GameLoggerPreferencesPanel.this.ignoreRuleFieldsDocumentChange) {
                GameLoggerPreferencesPanel.this.fireStateChanged();
            }
        }
    };

    public GameLoggerPreferencesPanel(GameLogger gameLogger) {
        this.gameLogger = gameLogger;
        this.createUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncUI() {
        try {
            this.ignoreRuleFieldsDocumentChange = true;
            if (this.logNoneButton.isSelected()) {
                GameLoggerPreferencesPanel.setContainerEnabled(this.logAllPanel, false);
                GameLoggerPreferencesPanel.setContainerEnabled(this.useRulesPanel, false);
            } else if (this.logAllButton.isSelected()) {
                GameLoggerPreferencesPanel.setContainerEnabled(this.logAllPanel, true);
                GameLoggerPreferencesPanel.setContainerEnabled(this.useRulesPanel, false);
            } else if (this.useRulesButton.isSelected()) {
                GameLoggerPreferencesPanel.setContainerEnabled(this.logAllPanel, false);
                GameLoggerPreferencesPanel.setContainerEnabled(this.useRulesPanel, true);
            }
            if (this.loggingRulesList.getSelectedIndex() == -1) {
                this.rulenameField.setText("");
                this.filenameField.setText("");
                this.conditionField.setText("");
                GameLoggerPreferencesPanel.setContainerEnabled(this.rulePropertiesPanel, false);
                this.deleteRuleButton.setEnabled(false);
            } else {
                Object e;
                if (this.useRulesButton.isSelected()) {
                    GameLoggerPreferencesPanel.setContainerEnabled(this.rulePropertiesPanel, true);
                    this.deleteRuleButton.setEnabled(true);
                }
                if ((e = this.loggingRulesList.getSelectedValue()) instanceof LoggingRule) {
                    LoggingRule loggingRule = (LoggingRule)e;
                    this.rulenameField.setText(loggingRule.getName());
                    this.filenameField.setText(loggingRule.getFilename());
                    this.conditionField.setText(loggingRule.getCondition());
                }
            }
        }
        finally {
            this.ignoreRuleFieldsDocumentChange = false;
        }
    }

    protected void createUI() {
        I18n i18n = I18n.get((Class)GameLoggerPreferencesPanel.class);
        int n = this.gameLogger.getLoggingMode();
        String string = this.gameLogger.getLogFileForAll();
        Vector vector = this.gameLogger.getLoggingRules();
        this.logNoneButton = i18n.createRadioButton("logNoGamesRadioButton");
        this.logAllButton = i18n.createRadioButton("logAllGamesRadioButton");
        this.useRulesButton = i18n.createRadioButton("ruleBasedGameLoggingRadioButton");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.logNoneButton);
        buttonGroup.add(this.logAllButton);
        buttonGroup.add(this.useRulesButton);
        this.logNoneButton.setActionCommand("none");
        this.logAllButton.setActionCommand("all");
        this.useRulesButton.setActionCommand("rules");
        this.logAllPanel = new JPanel();
        this.useRulesPanel = new JPanel();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameLoggerPreferencesPanel.this.syncUI();
                GameLoggerPreferencesPanel.this.fireStateChanged();
            }
        };
        switch (n) {
            case 0: {
                this.logNoneButton.setSelected(true);
                break;
            }
            case 1: {
                this.logAllButton.setSelected(true);
                break;
            }
            case 2: {
                this.useRulesButton.setSelected(true);
            }
        }
        this.logNoneButton.addActionListener(actionListener);
        this.logAllButton.addActionListener(actionListener);
        this.useRulesButton.addActionListener(actionListener);
        this.allGamesLogFileField = new FixedJTextField(10);
        this.allGamesLogFileField.setText(string);
        this.allGamesLogFileField.getDocument().addDocumentListener(this.changeFiringDocumentListener);
        JButton jButton = i18n.createButton("browseLogFileButton");
        jButton.setDefaultCapable(false);
        jButton.addActionListener(new PGNFileSelectActionListener((Component)((Object)this), this.allGamesLogFileField));
        this.logAllPanel.setLayout(new BorderLayout(5, 5));
        this.logAllPanel.add((Component)this.allGamesLogFileField, "Center");
        this.logAllPanel.add((Component)jButton, "East");
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.logNoneButton, "West");
        Box box = Box.createHorizontalBox();
        box.add(this.logAllButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.logAllPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.useRulesButton, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 5, 5));
        jPanel3.add(jPanel);
        jPanel3.add(box);
        jPanel3.add(jPanel2);
        final DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.elementAt(i));
        }
        this.loggingRulesList = new JList(defaultListModel);
        this.loggingRulesList.setSelectionMode(0);
        this.loggingRulesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (GameLoggerPreferencesPanel.this.ignoreRulesListSelectionChange) {
                    GameLoggerPreferencesPanel.this.rulesListSelectedIndex = GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex();
                    return;
                }
                if (GameLoggerPreferencesPanel.this.rulesListSelectedIndex != -1 && GameLoggerPreferencesPanel.this.rulesListSelectedIndex < defaultListModel.size()) {
                    try {
                        GameLoggerPreferencesPanel.this.updateRuleFromUI(GameLoggerPreferencesPanel.this.rulesListSelectedIndex);
                    }
                    catch (BadChangesException badChangesException) {
                        GameLoggerPreferencesPanel.this.ignoreRulesListSelectionChange = true;
                        GameLoggerPreferencesPanel.this.loggingRulesList.setSelectedIndex(GameLoggerPreferencesPanel.this.rulesListSelectedIndex);
                        GameLoggerPreferencesPanel.this.ignoreRulesListSelectionChange = false;
                        I18n i18n = I18n.get((Class)(class$free$jin$gamelogger$GameLoggerPreferencesPanel == null ? (class$free$jin$gamelogger$GameLoggerPreferencesPanel = GameLoggerPreferencesPanel.class$("free.jin.gamelogger.GameLoggerPreferencesPanel")) : class$free$jin$gamelogger$GameLoggerPreferencesPanel));
                        OptionPanel.error((String)i18n.getString("badChangesDialog.title"), (String)badChangesException.getMessage(), (Component)((Object)GameLoggerPreferencesPanel.this));
                        if (badChangesException.getErrorComponent() != null) {
                            badChangesException.getErrorComponent().requestFocus();
                        }
                        return;
                    }
                }
                GameLoggerPreferencesPanel.this.rulesListSelectedIndex = GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex();
                GameLoggerPreferencesPanel.this.syncUI();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.loggingRulesList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(80, 80));
        JLabel jLabel = i18n.createLabel("gameLoggingRulesLabel");
        jLabel.setLabelFor(this.loggingRulesList);
        jLabel.setAlignmentX(0.0f);
        JButton jButton2 = i18n.createButton("addGameLoggingRuleButton");
        jButton2.setDefaultCapable(false);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex();
                if (n != -1) {
                    try {
                        GameLoggerPreferencesPanel.this.updateRuleFromUI(n);
                    }
                    catch (BadChangesException badChangesException) {
                        I18n i18n = I18n.get((Class)(class$free$jin$gamelogger$GameLoggerPreferencesPanel == null ? (class$free$jin$gamelogger$GameLoggerPreferencesPanel = GameLoggerPreferencesPanel.class$("free.jin.gamelogger.GameLoggerPreferencesPanel")) : class$free$jin$gamelogger$GameLoggerPreferencesPanel));
                        OptionPanel.error((String)i18n.getString("badChangesDialog.title"), (String)badChangesException.getMessage(), (Component)((Object)GameLoggerPreferencesPanel.this));
                        if (badChangesException.getErrorComponent() != null) {
                            badChangesException.getErrorComponent().requestFocus();
                        }
                        return;
                    }
                }
                defaultListModel.addElement(I18n.get((Class)(class$free$jin$gamelogger$GameLoggerPreferencesPanel == null ? (class$free$jin$gamelogger$GameLoggerPreferencesPanel = GameLoggerPreferencesPanel.class$("free.jin.gamelogger.GameLoggerPreferencesPanel")) : class$free$jin$gamelogger$GameLoggerPreferencesPanel)).getString("initialNewGameLoggingRuleName"));
                GameLoggerPreferencesPanel.this.loggingRulesList.setSelectedIndex(defaultListModel.size() - 1);
                GameLoggerPreferencesPanel.this.loggingRulesList.ensureIndexIsVisible(GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex());
                GameLoggerPreferencesPanel.this.rulenameField.setText("");
                GameLoggerPreferencesPanel.this.filenameField.setText("");
                GameLoggerPreferencesPanel.this.conditionField.setText("");
                GameLoggerPreferencesPanel.this.rulenameField.requestFocus();
            }
        });
        this.deleteRuleButton = i18n.createButton("deleteGameLoggingRuleButton");
        this.deleteRuleButton.setDefaultCapable(false);
        this.deleteRuleButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                try {
                    GameLoggerPreferencesPanel.this.ignoreRulesListSelectionChange = true;
                    defaultListModel.removeElementAt(n);
                    if (n < defaultListModel.size()) {
                        GameLoggerPreferencesPanel.this.loggingRulesList.setSelectedIndex(n);
                    } else if (defaultListModel.size() != 0) {
                        GameLoggerPreferencesPanel.this.loggingRulesList.setSelectedIndex(n - 1);
                    }
                    GameLoggerPreferencesPanel.this.loggingRulesList.ensureIndexIsVisible(GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex());
                }
                finally {
                    GameLoggerPreferencesPanel.this.ignoreRulesListSelectionChange = false;
                }
                GameLoggerPreferencesPanel.this.syncUI();
                GameLoggerPreferencesPanel.this.fireStateChanged();
            }
        });
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel4.add(jButton2);
        jPanel4.add(this.deleteRuleButton);
        jPanel4.setMaximumSize(jPanel4.getPreferredSize());
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalGlue());
        box2.add(jPanel4);
        box2.add(Box.createVerticalGlue());
        Box box3 = Box.createHorizontalBox();
        box3.add(jScrollPane);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(box2);
        box3.add(Box.createHorizontalGlue());
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel5.add((Component)jLabel, "North");
        jPanel5.add((Component)box3, "Center");
        this.rulenameField = new FixedJTextField(10);
        this.filenameField = new FixedJTextField(10);
        this.conditionField = new FixedJTextField(20);
        this.rulenameField.getDocument().addDocumentListener(this.changeFiringDocumentListener);
        this.filenameField.getDocument().addDocumentListener(this.changeFiringDocumentListener);
        this.conditionField.getDocument().addDocumentListener(this.changeFiringDocumentListener);
        this.rulenameField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateRulename();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateRulename();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateRulename();
            }

            private void updateRulename() {
                Object e = GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedValue();
                if (e instanceof String) {
                    String string = GameLoggerPreferencesPanel.this.rulenameField.getText();
                    if (string.length() == 0) {
                        defaultListModel.setElementAt(I18n.get((Class)(class$free$jin$gamelogger$GameLoggerPreferencesPanel == null ? (class$free$jin$gamelogger$GameLoggerPreferencesPanel = GameLoggerPreferencesPanel.class$("free.jin.gamelogger.GameLoggerPreferencesPanel")) : class$free$jin$gamelogger$GameLoggerPreferencesPanel)).getString("initialNewGameLoggingRuleName"), GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex());
                    } else {
                        defaultListModel.setElementAt(string, GameLoggerPreferencesPanel.this.loggingRulesList.getSelectedIndex());
                    }
                } else if (e instanceof LoggingRule) {
                    LoggingRule loggingRule = (LoggingRule)e;
                    String string = GameLoggerPreferencesPanel.this.rulenameField.getText();
                    if (string != null && string.length() != 0) {
                        loggingRule.setName(string);
                        GameLoggerPreferencesPanel.this.loggingRulesList.repaint();
                    }
                }
            }
        });
        JLabel jLabel2 = i18n.createLabel("gameLoggingRuleNameLabel");
        JLabel jLabel3 = i18n.createLabel("gameLoggingFilenameLabel");
        JLabel jLabel4 = i18n.createLabel("gameLoggingConditionLabel");
        jLabel2.setLabelFor(this.rulenameField);
        jLabel3.setLabelFor(this.filenameField);
        jLabel4.setLabelFor(this.conditionField);
        JButton jButton3 = i18n.createButton("browseLogFileButton");
        jButton3.setDefaultCapable(false);
        jButton3.addActionListener(new PGNFileSelectActionListener((Component)((Object)this), this.filenameField));
        JButton jButton4 = i18n.createButton("conditionHelpButton");
        jButton4.setDefaultCapable(false);
        jButton4.setPreferredSize(jButton3.getPreferredSize());
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                I18n i18n = I18n.get((Class)(class$free$jin$gamelogger$GameLoggerPreferencesPanel == null ? (class$free$jin$gamelogger$GameLoggerPreferencesPanel = GameLoggerPreferencesPanel.class$("free.jin.gamelogger.GameLoggerPreferencesPanel")) : class$free$jin$gamelogger$GameLoggerPreferencesPanel));
                i18n.showPlainTextDialog("conditionHelpDialog", (Component)((Object)GameLoggerPreferencesPanel.this));
            }
        });
        this.rulePropertiesPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        Box box4 = Box.createHorizontalBox();
        Box box5 = Box.createHorizontalBox();
        Box box6 = Box.createHorizontalBox();
        int n2 = Math.max(jLabel2.getPreferredSize().width, Math.max(jLabel3.getPreferredSize().width, jLabel4.getPreferredSize().width));
        jLabel2.setPreferredSize(new Dimension(n2 + 7, 20));
        jLabel3.setPreferredSize(new Dimension(n2 + 7, 20));
        jLabel4.setPreferredSize(new Dimension(n2 + 7, 20));
        box4.add(jLabel2);
        box4.add(Box.createHorizontalStrut(5));
        box4.add(this.rulenameField);
        box4.add(Box.createHorizontalStrut(5 + jButton3.getPreferredSize().width));
        box5.add(jLabel3);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.filenameField);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(jButton3);
        box6.add(jLabel4);
        box6.add(Box.createHorizontalStrut(5));
        box6.add(this.conditionField);
        box6.add(Box.createHorizontalStrut(5));
        box6.add(jButton4);
        this.rulePropertiesPanel.add(box4);
        this.rulePropertiesPanel.add(box5);
        this.rulePropertiesPanel.add(box6);
        this.useRulesPanel.setBorder(new EmptyBorder(5, 16, 0, 0));
        this.useRulesPanel.setLayout(new BorderLayout(5, 20));
        this.useRulesPanel.add((Component)jPanel5, "Center");
        this.useRulesPanel.add((Component)this.rulePropertiesPanel, "South");
        this.add(jPanel3, "North");
        this.add(this.useRulesPanel, "Center");
        int n3 = defaultListModel.getSize() - 1;
        this.loggingRulesList.setSelectedIndex(n3);
        this.loggingRulesList.ensureIndexIsVisible(n3);
        this.syncUI();
    }

    private static void setContainerEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(bl);
            }
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            GameLoggerPreferencesPanel.setContainerEnabled((Container)component, bl);
        }
    }

    private void updateRuleFromUI(int n) throws BadChangesException {
        I18n i18n = I18n.get((Class)GameLoggerPreferencesPanel.class);
        DefaultListModel defaultListModel = (DefaultListModel)this.loggingRulesList.getModel();
        Object e = defaultListModel.getElementAt(n);
        LoggingRule loggingRule = e instanceof LoggingRule ? (LoggingRule)e : null;
        String string = this.rulenameField.getText();
        String string2 = this.filenameField.getText();
        String string3 = this.conditionField.getText();
        String string4 = null;
        JTextField jTextField = null;
        if (string == null || string.length() == 0) {
            string4 = i18n.getString("ruleNameUnspecifiedErrorMessage");
            jTextField = this.rulenameField;
        } else if (string2 == null || string2.length() == 0) {
            string4 = i18n.getString("fileNameUnspecifiedErrorMessage");
            jTextField = this.filenameField;
        } else if (string3 == null || string3.length() == 0) {
            string3 = "true";
            this.conditionField.setText(string3);
        } else {
            string4 = this.checkLogFile(string2);
            if (string4 != null) {
                jTextField = this.filenameField;
            }
        }
        if (string4 != null) {
            throw new BadChangesException(string4, (Component)jTextField);
        }
        try {
            if (loggingRule == null) {
                loggingRule = new LoggingRule(string, string3, string2);
                defaultListModel.setElementAt(loggingRule, n);
            } else {
                loggingRule.setName(string);
                loggingRule.setFilename(GameLoggerPreferencesPanel.interpretLoggingTarget(string2));
                loggingRule.setCondition(string3);
                this.loggingRulesList.repaint();
            }
        }
        catch (EvalError evalError) {
            throw new BadChangesException(i18n.getString("invalidGameLoggingConditionMessage"), (Component)this.conditionField);
        }
    }

    private static String interpretLoggingTarget(String string) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        return new File(System.getProperty("user.home"), string).getAbsolutePath();
    }

    private String checkLogFile(String string) {
        Object object;
        I18n i18n = I18n.get((Class)GameLoggerPreferencesPanel.class);
        File file = new File(GameLoggerPreferencesPanel.interpretLoggingTarget(string));
        File file2 = file.getParentFile();
        Object[] objectArray = new Object[]{file.getPath(), file2 == null ? null : file2.getPath()};
        if (file.isDirectory()) {
            return i18n.getFormattedString("logFileIsDirectoryErrorMessage", objectArray);
        }
        if (file2 == null) {
            return i18n.getFormattedString("badLogFileErrorMessage", objectArray);
        }
        if (!file2.exists() && (object = i18n.confirm(OptionPanel.OK, "createLogFileDirectoryDialog", (Component)((Object)this), objectArray)) == OptionPanel.OK && !file2.mkdirs()) {
            return i18n.getFormattedString("unableToCreateLogFileDirectory", objectArray);
        }
        try {
            object = new FileOutputStream(file, true);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            return i18n.getFormattedString("unableToWriteLogFile", objectArray);
        }
        return null;
    }

    public void applyChanges() throws BadChangesException {
        Object object;
        String string;
        I18n i18n = I18n.get((Class)GameLoggerPreferencesPanel.class);
        Preferences preferences = this.gameLogger.getPrefs();
        int n = this.loggingRulesList.getSelectedIndex();
        if (n != -1) {
            this.updateRuleFromUI(n);
        }
        if (this.logNoneButton.isSelected()) {
            string = "none";
        } else if (this.logAllButton.isSelected()) {
            string = "all";
        } else if (this.useRulesButton.isSelected()) {
            string = "rules";
        } else {
            throw new IllegalStateException("None of the mode radio buttons are selected");
        }
        String string2 = this.allGamesLogFileField.getText();
        if ("all".equals(string)) {
            object = null;
            object = string2 == null || string2.length() == 0 ? i18n.getString("fileNameUnspecifiedErrorMessage") : this.checkLogFile(string2);
            if (object != null) {
                throw new BadChangesException((String)object, (Component)this.allGamesLogFileField);
            }
        }
        preferences.setString("logging.mode", string);
        preferences.setString("logging.all.filename", GameLoggerPreferencesPanel.interpretLoggingTarget(string2));
        object = (DefaultListModel)this.loggingRulesList.getModel();
        int n2 = ((DefaultListModel)object).size();
        preferences.setInt("logging.rules.count", n2);
        for (int i = 0; i < n2; ++i) {
            LoggingRule loggingRule = (LoggingRule)((DefaultListModel)object).elementAt(i);
            preferences.setString("logging.rule-" + (i + 1) + ".name", loggingRule.getName());
            preferences.setString("logging.rule-" + (i + 1) + ".condition", loggingRule.getCondition());
            preferences.setString("logging.rule-" + (i + 1) + ".filename", GameLoggerPreferencesPanel.interpretLoggingTarget(loggingRule.getFilename()));
        }
        this.gameLogger.refreshFromProperties();
    }

    private static class PGNFileSelectActionListener
    implements ActionListener {
        private final Component parent;
        private final JTextField textfield;

        public PGNFileSelectActionListener(Component component, JTextField jTextField) {
            this.parent = component;
            this.textfield = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            I18n i18n = I18n.get((Class)(class$free$jin$gamelogger$GameLoggerPreferencesPanel == null ? (class$free$jin$gamelogger$GameLoggerPreferencesPanel = GameLoggerPreferencesPanel.class$("free.jin.gamelogger.GameLoggerPreferencesPanel")) : class$free$jin$gamelogger$GameLoggerPreferencesPanel));
            File file = new File(this.textfield.getText());
            File file2 = null;
            if (file.isFile()) {
                file2 = new File(file.getParent());
                if (!file2.exists()) {
                    file2 = null;
                    file = null;
                }
            } else if (file.exists()) {
                file2 = file;
                file = null;
            }
            JFileChooser jFileChooser = new JFileChooser(file2);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(i18n.getString("pgnFileChooser.filterName"), ".pgn", false));
            jFileChooser.setFileHidingEnabled(true);
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showDialog(this.parent, i18n.getString("pgnFileChooser.name"));
            if (n == 0) {
                String string = null;
                try {
                    string = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (string == null) {
                    string = jFileChooser.getSelectedFile().getAbsolutePath();
                }
                if (!string.endsWith(".pgn") && !string.endsWith(".PGN")) {
                    string = string + ".pgn";
                }
                this.textfield.setText(string);
            }
        }
    }
}

