/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.sasl.srp.KDF;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.security.sasl.SaslException;

public final class IALG
implements Cloneable {
    private IMac hmac;

    static final synchronized IALG getInstance(String string) throws SaslException {
        IMac iMac = MacFactory.getInstance(string);
        if (iMac == null) {
            throw new SaslException("getInstance()", new NoSuchAlgorithmException(string));
        }
        return new IALG(iMac);
    }

    public final Object clone() throws CloneNotSupportedException {
        return new IALG((IMac)this.hmac.clone());
    }

    public final void init(KDF kDF) throws SaslException {
        try {
            byte[] byArray = kDF.derive(this.hmac.macSize());
            HashMap hashMap = new HashMap();
            hashMap.put("gnu.crypto.mac.key.material", byArray);
            this.hmac.init(hashMap);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SaslException("getInstance()", invalidKeyException);
        }
    }

    public final void update(byte[] byArray) {
        this.hmac.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) {
        this.hmac.update(byArray, n, n2);
    }

    public final byte[] doFinal() {
        return this.hmac.digest();
    }

    public final int length() {
        return this.hmac.macSize();
    }

    private IALG(IMac iMac) {
        this.hmac = iMac;
    }
}

