/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DirectByteBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;
import java.nio.VMDirectByteBuffer;

final class MappedByteBufferImpl
extends MappedByteBuffer {
    boolean readOnly;
    public Pointer implPtr;
    public long implLen;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final byte get() {
        this.checkForUnderflow();
        int n = this.position();
        byte by = VMDirectByteBuffer.get(this.address, n);
        this.position(n + 1);
        return by;
    }

    public final ByteBuffer put(byte by) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        int n = this.position();
        VMDirectByteBuffer.put(this.address, n, by);
        this.position(n + 1);
        return this;
    }

    public final byte get(int n) {
        this.checkIndex(n);
        return VMDirectByteBuffer.get(this.address, n);
    }

    public final ByteBuffer get(byte[] byArray, int n, int n2) {
        MappedByteBufferImpl.checkArraySize(byArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = this.position();
        VMDirectByteBuffer.get(this.address, n3, byArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    public final ByteBuffer put(int n, byte by) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        VMDirectByteBuffer.put(this.address, n, by);
        return this;
    }

    public final ByteBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        if (n > 0) {
            int n2 = this.remaining();
            VMDirectByteBuffer.shiftDown(this.address, 0, n, n2);
            this.position(n2);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public final boolean isDirect() {
        return true;
    }

    public final ByteBuffer slice() {
        int n = this.remaining();
        if (this.isReadOnly()) {
            return new DirectByteBufferImpl.ReadOnly(this, VMDirectByteBuffer.adjustAddress(this.address, this.position()), n, n, 0);
        }
        return new DirectByteBufferImpl.ReadWrite(this, VMDirectByteBuffer.adjustAddress(this.address, this.position()), n, n, 0);
    }

    private final ByteBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        DirectByteBufferImpl directByteBufferImpl = bl ? new DirectByteBufferImpl.ReadOnly(this, this.address, this.capacity(), this.limit(), n) : new DirectByteBufferImpl.ReadWrite(this, this.address, this.capacity(), this.limit(), n);
        if (n2 != n) {
            directByteBufferImpl.position(n2);
            directByteBufferImpl.mark();
            directByteBufferImpl.position(n);
        }
        return directByteBufferImpl;
    }

    public final ByteBuffer duplicate() {
        return this.duplicate(this.isReadOnly());
    }

    public final ByteBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public final CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.remaining() >> 1);
    }

    public final ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.remaining() >> 1);
    }

    public final IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.remaining() >> 2);
    }

    public final LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.remaining() >> 3);
    }

    public final FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.remaining() >> 2);
    }

    public final DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.remaining() >> 3);
    }

    public final char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public final ByteBuffer putChar(char c) {
        ByteBufferHelper.putChar(this, c, this.order());
        return this;
    }

    public final char getChar(int n) {
        return ByteBufferHelper.getChar(this, n, this.order());
    }

    public final ByteBuffer putChar(int n, char c) {
        ByteBufferHelper.putChar(this, n, c, this.order());
        return this;
    }

    public final short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public final ByteBuffer putShort(short s) {
        ByteBufferHelper.putShort(this, s, this.order());
        return this;
    }

    public final short getShort(int n) {
        return ByteBufferHelper.getShort(this, n, this.order());
    }

    public final ByteBuffer putShort(int n, short s) {
        ByteBufferHelper.putShort(this, n, s, this.order());
        return this;
    }

    public final int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public final ByteBuffer putInt(int n) {
        ByteBufferHelper.putInt(this, n, this.order());
        return this;
    }

    public final int getInt(int n) {
        return ByteBufferHelper.getInt(this, n, this.order());
    }

    public final ByteBuffer putInt(int n, int n2) {
        ByteBufferHelper.putInt(this, n, n2, this.order());
        return this;
    }

    public final long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public final ByteBuffer putLong(long l) {
        ByteBufferHelper.putLong(this, l, this.order());
        return this;
    }

    public final long getLong(int n) {
        return ByteBufferHelper.getLong(this, n, this.order());
    }

    public final ByteBuffer putLong(int n, long l) {
        ByteBufferHelper.putLong(this, n, l, this.order());
        return this;
    }

    public final float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public final ByteBuffer putFloat(float f) {
        ByteBufferHelper.putFloat(this, f, this.order());
        return this;
    }

    public final float getFloat(int n) {
        return ByteBufferHelper.getFloat(this, n, this.order());
    }

    public final ByteBuffer putFloat(int n, float f) {
        ByteBufferHelper.putFloat(this, n, f, this.order());
        return this;
    }

    public final double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public final ByteBuffer putDouble(double d) {
        ByteBufferHelper.putDouble(this, d, this.order());
        return this;
    }

    public final double getDouble(int n) {
        return ByteBufferHelper.getDouble(this, n, this.order());
    }

    public final ByteBuffer putDouble(int n, double d) {
        ByteBufferHelper.putDouble(this, n, d, this.order());
        return this;
    }

    final native void unmapImpl();

    final native boolean isLoadedImpl();

    final native void loadImpl();

    final native void forceImpl();

    public MappedByteBufferImpl(Pointer pointer, int n, boolean bl) throws IOException {
        super(n, n, 0, -1);
        this.address = pointer;
        this.readOnly = bl;
    }
}

