/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;

    public boolean implies(Permission permission) {
        if (!this.getClass().isInstance(permission)) {
            return false;
        }
        String string = permission.getName();
        String string2 = this.getName();
        if (string2.equals(string)) {
            return true;
        }
        int n = string2.length() - 1;
        boolean bl = false;
        if (string2.charAt(n) == '*' && string.startsWith(string2.substring(0, n))) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this.getClass().isInstance(object) && this.getName().equals(((BasicPermission)object).getName())) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection(this.getClass());
    }

    public BasicPermission(String string) {
        super(string);
        if (string.equals("")) {
            throw new IllegalArgumentException("Empty name");
        }
    }

    public BasicPermission(String string, String string2) {
        this(string);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class BasicPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 739301742472979399L;
        private final Hashtable permissions;
        private boolean all_allowed;
        private final Class permClass;

        public final void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("readonly");
            }
            if (!this.permClass.isInstance(permission)) {
                throw new IllegalArgumentException("Expecting instance of " + this.permClass);
            }
            BasicPermission basicPermission = (BasicPermission)permission;
            String string = basicPermission.getName();
            if (string.equals("*")) {
                this.all_allowed = true;
            }
            this.permissions.put(string, basicPermission);
        }

        public final boolean implies(Permission permission) {
            if (!this.permClass.isInstance(permission)) {
                return false;
            }
            if (this.all_allowed) {
                return true;
            }
            BasicPermission basicPermission = (BasicPermission)permission;
            String string = basicPermission.getName();
            if (string.equals("*")) {
                return false;
            }
            int n = string.length();
            if (string.endsWith("*")) {
                n -= 2;
            }
            while (this.permissions.get(string) == null) {
                if ((n = string.lastIndexOf(46, n)) < 0) {
                    return false;
                }
                string = string.substring(0, n + 1) + '*';
            }
            return true;
        }

        public final Enumeration elements() {
            return this.permissions.elements();
        }

        private final /* synthetic */ void this() {
            this.permissions = new Hashtable();
        }

        BasicPermissionCollection(Class clazz) {
            this.this();
            this.permClass = clazz;
        }
    }
}

