/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JList
extends JComponent
implements Accessible,
Scrollable {
    private static final long serialVersionUID = 4406629526391098046L;
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    boolean dragEnabled;
    ListCellRenderer cellRenderer;
    int fixedCellWidth;
    int fixedCellHeight;
    int layoutOrientation;
    ListModel model;
    Object prototypeCellValue;
    Color selectionBackground;
    Color selectionForeground;
    ListSelectionModel selectionModel;
    boolean valueIsAdjusting;
    int visibleRowCount;
    ListListener listListener;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
        ListSelectionListener[] listSelectionListenerArray = this.getListSelectionListeners();
        int n3 = 0;
        while (n3 < listSelectionListenerArray.length) {
            listSelectionListenerArray[n3].valueChanged(listSelectionEvent);
            ++n3;
        }
    }

    void init() {
        this.dragEnabled = false;
        this.fixedCellHeight = -1;
        this.fixedCellWidth = -1;
        this.layoutOrientation = 0;
        this.opaque = true;
        this.valueIsAdjusting = false;
        this.visibleRowCount = 7;
        this.cellRenderer = new DefaultListCellRenderer();
        this.listListener = new ListListener();
        this.setModel(new DefaultListModel());
        this.setSelectionModel(this.createSelectionModel());
        this.setSelectionMode(2);
        this.setLayout(null);
        this.updateUI();
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int n) {
        if (this.fixedCellHeight == n) {
            return;
        }
        int n2 = this.fixedCellHeight;
        this.fixedCellHeight = n;
        this.firePropertyChange("fixedCellWidth", n2, n);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int n) {
        if (this.fixedCellWidth == n) {
            return;
        }
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        this.firePropertyChange("fixedCellWidth", n2, n);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
        this.revalidate();
        this.repaint();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = JList.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        this.listenerList.add(clazz, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = JList.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        this.listenerList.remove(clazz, listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = JList.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        return (ListSelectionListener[])this.getListeners(clazz);
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void setSelectionMode(int n) {
        this.selectionModel.setSelectionMode(n);
    }

    public void setSelectedIndex(int n) {
        if (n < 0) {
            this.selectionModel.clearSelection();
        } else {
            this.selectionModel.setSelectionInterval(n, n);
        }
    }

    public void setSelectedIndices(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.setSelectedIndex(nArray[n]);
            ++n;
        }
    }

    public int getSelectedIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public int getFirstVisibleIndex() {
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        Rectangle rectangle = this.getVisibleRect();
        if (componentOrientation == ComponentOrientation.RIGHT_TO_LEFT) {
            rectangle.translate((int)rectangle.getWidth() - 1, 0);
        }
        return this.getUI().locationToIndex(this, rectangle.getLocation());
    }

    public int locationToIndex(Point point) {
        return this.getUI().locationToIndex(this, point);
    }

    public Point indexToLocation(int n) {
        return this.getUI().indexToLocation(this, n);
    }

    public int getLastVisibleIndex() {
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        Rectangle rectangle = this.getVisibleRect();
        rectangle.translate(0, (int)rectangle.getHeight() - 1);
        if (componentOrientation == ComponentOrientation.LEFT_TO_RIGHT) {
            rectangle.translate((int)rectangle.getWidth() - 1, 0);
        }
        if (this.getUI().locationToIndex(this, rectangle.getLocation()) == -1 && this.indexToLocation((int)(this.getModel().getSize() - 1)).y < rectangle.y) {
            return this.getModel().getSize() - 1;
        }
        return this.getUI().locationToIndex(this, rectangle.getLocation());
    }

    public int[] getSelectedIndices() {
        if (this.selectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        int n = this.selectionModel.getMinSelectionIndex();
        int n2 = this.selectionModel.getMaxSelectionIndex();
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (this.selectionModel.isSelectedIndex(n4)) {
                ++n3;
            }
            ++n4;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        n4 = n;
        while (n4 <= n2) {
            if (this.selectionModel.isSelectedIndex(n4)) {
                nArray[n5++] = n4;
            }
            ++n4;
        }
        return nArray;
    }

    public boolean isSelectedIndex(int n) {
        return this.selectionModel.isSelectedIndex(n);
    }

    public Object getSelectedValue() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getModel().getElementAt(n);
    }

    public Object[] getSelectedValues() {
        int[] nArray = this.getSelectedIndices();
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.getModel().getElementAt(n);
            ++n;
        }
        return objectArray;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        if (this.selectionBackground == color) {
            return;
        }
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        if (this.selectionForeground == color) {
            return;
        }
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public void setSelectedValue(Object object, boolean bl) {
        int n = 0;
        while (n < this.model.getSize()) {
            if (this.model.getElementAt(n).equals(object)) {
                this.setSelectedIndex(n);
                if (!bl) break;
                this.ensureIndexIsVisible(n);
                break;
            }
            ++n;
        }
    }

    public void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getUI().getCellBounds(this, n, n);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void setListData(final Object[] objectArray) {
        this.setModel(new AbstractListModel(){

            public final int getSize() {
                return objectArray.length;
            }

            public final Object getElementAt(int n) {
                return objectArray[n];
            }
        });
    }

    public void setListData(final Vector vector) {
        this.setModel(new AbstractListModel(){

            public final int getSize() {
                return vector.size();
            }

            public final Object getElementAt(int n) {
                return vector.elementAt(n);
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (this.cellRenderer == listCellRenderer) {
            return;
        }
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
        this.revalidate();
        this.repaint();
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("Null 'model' argument.");
        }
        if (this.model == listModel) {
            return;
        }
        if (this.model != null) {
            this.model.removeListDataListener(this.listListener);
        }
        ListModel listModel2 = this.model;
        this.model = listModel;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.firePropertyChange("model", listModel2, listModel);
        this.revalidate();
        this.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.selectionModel == listSelectionModel) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this.listListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
        }
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
        this.revalidate();
        this.repaint();
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ListUI";
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object object) {
        if (this.prototypeCellValue == object) {
            return;
        }
        Object object2 = this.prototypeCellValue;
        Component component = this.getCellRenderer().getListCellRendererComponent(this, object, 0, false, false);
        Dimension dimension = component.getPreferredSize();
        this.fixedCellWidth = dimension.width;
        this.fixedCellHeight = dimension.height;
        this.prototypeCellValue = object;
        this.firePropertyChange("prototypeCellValue", object2, object);
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJList();
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        int n = this.getModel().getSize();
        if (this.fixedCellHeight != -1 && this.fixedCellWidth != -1) {
            return new Dimension(this.fixedCellWidth, n * this.fixedCellHeight);
        }
        if (n == 0) {
            if (this.fixedCellWidth == -1) {
                return new Dimension(256, 16 * this.getVisibleRowCount());
            }
            return new Dimension(this.fixedCellWidth, 16 * this.getVisibleRowCount());
        }
        int n2 = this.fixedCellWidth != -1 ? this.fixedCellWidth : this.getPreferredSize().width;
        int n3 = this.fixedCellHeight != -1 ? this.fixedCellHeight : this.getVisibleRowCount() * this.getCellBounds((int)0, (int)0).height;
        return new Dimension(n2, n3);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        ListUI listUI = this.getUI();
        if (n == 1) {
            if (n2 > 0) {
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                int n3 = listUI.locationToIndex(this, point);
                Rectangle rectangle2 = listUI.getCellBounds(this, n3, n3);
                if (rectangle2.y + rectangle2.height == point.y) {
                    if (n3 + 1 < this.model.getSize()) {
                        Rectangle rectangle3 = listUI.getCellBounds(this, n3 + 1, n3 + 1);
                        return rectangle3.height;
                    }
                    return 0;
                }
                return rectangle2.y + rectangle2.height - point.y;
            }
            Point point = new Point(rectangle.x, rectangle.y);
            int n4 = listUI.locationToIndex(this, point);
            Rectangle rectangle4 = listUI.getCellBounds(this, n4, n4);
            if (rectangle4.y == point.y) {
                if (n4 > 0) {
                    Rectangle rectangle5 = listUI.getCellBounds(this, n4 - 1, n4 - 1);
                    return -rectangle5.height;
                }
                return 0;
            }
            return rectangle4.y - point.y;
        }
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.height * n2;
        }
        return rectangle.width * n2;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        boolean bl = false;
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Dimension dimension = this.getPreferredSize();
            if (jViewport.getSize().width > dimension.width) {
                bl = true;
            }
            if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        boolean bl = false;
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Dimension dimension = this.getPreferredSize();
            if (jViewport.getSize().height > dimension.height) {
                bl = true;
            }
            if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
                bl = true;
            }
        }
        return bl;
    }

    public int getAnchorSelectionIndex() {
        return this.selectionModel.getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.selectionModel.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.selectionModel.getMaxSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.selectionModel.getMaxSelectionIndex();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSelectionInterval(int n, int n2) {
        this.selectionModel.setSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this.selectionModel.addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.selectionModel.removeSelectionInterval(n, n2);
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean bl) {
        this.valueIsAdjusting = bl;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int n) {
        if (this.layoutOrientation == n) {
            return;
        }
        int n2 = this.layoutOrientation;
        this.layoutOrientation = n;
        this.firePropertyChange("layoutOrientation", n2, n);
    }

    public Rectangle getCellBounds(int n, int n2) {
        return this.getUI().getCellBounds(this, n, n2);
    }

    public int getNextMatch(String string, int n, Position.Bias bias) {
        if (string == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be less than zero.");
        }
        int n2 = this.model.getSize();
        if (n > this.model.getSize()) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be greater than the number of elements in the ListModel.");
        }
        int n3 = -1;
        if (bias == Position.Bias.Forward) {
            int n4 = n;
            while (n4 < n2) {
                String string2 = this.model.getElementAt(n4).toString();
                if (string2.startsWith(string)) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 >= 0) {
                String string3 = this.model.getElementAt(n5).toString();
                if (string3.startsWith(string)) {
                    n3 = n5;
                    break;
                }
                --n5;
            }
        }
        return n3;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JList() {
        this.init();
    }

    public JList(Object[] objectArray) {
        this.init();
        this.setListData(objectArray);
    }

    public JList(Vector vector) {
        this.init();
        this.setListData(vector);
    }

    public JList(ListModel listModel) {
        this.init();
        this.setModel(listModel);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ListListener
    implements ListSelectionListener,
    ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            JList.this.repaint();
        }

        private ListListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n) {
            return new AccessibleJListChild(JList.this, JList.this.getSelectedIndices()[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        public void addAccessibleSelection(int n) {
            JList.this.addSelectionInterval(n, n);
        }

        public void removeAccessibleSelection(int n) {
            JList.this.removeSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, JList.this.getModel().getSize());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                listModel.removeListDataListener(this);
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                listModel2.addListDataListener(this);
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                listSelectionModel.removeListSelectionListener(this);
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                listSelectionModel.addListSelectionListener(this);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JList.this.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JList.this.locationToIndex(point);
            return this.getAccessibleChild(n);
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n) {
            if (JList.this.getModel().getSize() <= n) {
                return null;
            }
            return new AccessibleJListChild(JList.this, n);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            JList parent;
            int listIndex;
            Cursor cursor;

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public void setCursor(Cursor cursor) {
                this.cursor = cursor;
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public void setEnabled(boolean bl) {
            }

            public boolean isVisible() {
                boolean bl = false;
                if (this.listIndex >= this.parent.getFirstVisibleIndex() && this.listIndex <= this.parent.getLastVisibleIndex()) {
                    bl = true;
                }
                return bl;
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                boolean bl = false;
                if (this.isVisible() && this.parent.isShowing()) {
                    bl = true;
                }
                return bl;
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                Point point = this.getLocation();
                SwingUtilities.convertPointToScreen(point, this.parent);
                return point;
            }

            public Point getLocation() {
                return this.parent.indexToLocation(this.listIndex);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.parent.getCellBounds(this.listIndex, this.listIndex);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                return rectangle.getSize();
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public void requestFocus() {
                this.parent.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                this.parent.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.parent.removeFocusListener(focusListener);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                }
                if (this.isFocusTraversable()) {
                    accessibleStateSet.add(AccessibleState.FOCUSABLE);
                }
                if (this.parent.isEnabled()) {
                    accessibleStateSet.add(AccessibleState.SELECTABLE);
                }
                if (this.parent.isSelectedIndex(this.listIndex)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.listIndex;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            private final /* synthetic */ void this() {
                this.cursor = Cursor.getDefaultCursor();
            }

            public AccessibleJListChild(JList jList, int n) {
                this.this();
                this.parent = jList;
                this.listIndex = n;
            }
        }
    }
}

