/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component center;
    private Component firstLine;
    private Component lastLine;
    private Component firstItem;
    private Component lastItem;
    private int hgap;
    private int vgap;

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("Constraint must be a string");
        }
        this.addLayoutComponent((String)object, component);
    }

    public void addLayoutComponent(String string, Component component) {
        String string2 = string;
        if (string2 == null || string2.equals(CENTER)) {
            this.center = component;
        } else if (string2.equals(NORTH)) {
            this.north = component;
        } else if (string2.equals(SOUTH)) {
            this.south = component;
        } else if (string2.equals(EAST)) {
            this.east = component;
        } else if (string2.equals(WEST)) {
            this.west = component;
        } else if (string2.equals("First")) {
            this.firstLine = component;
        } else if (string2.equals("Last")) {
            this.lastLine = component;
        } else if (string2.equals("Before")) {
            this.firstItem = component;
        } else if (string2.equals("After")) {
            this.lastItem = component;
        } else {
            throw new IllegalArgumentException("Constraint value not valid: " + string2);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.north == component) {
            this.north = null;
        }
        if (this.south == component) {
            this.south = null;
        }
        if (this.east == component) {
            this.east = null;
        }
        if (this.west == component) {
            this.west = null;
        }
        if (this.center == component) {
            this.center = null;
        }
        if (this.firstItem == component) {
            this.firstItem = null;
        }
        if (this.lastItem == component) {
            this.lastItem = null;
        }
        if (this.firstLine == component) {
            this.firstLine = null;
        }
        if (this.lastLine == component) {
            this.lastLine = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calcSize(container, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calcSize(container, 2);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Component component;
            Component component2;
            Component component3;
            Component component4;
            boolean bl;
            int n;
            int n2;
            int n3;
            int n4;
            block13: {
                block14: {
                    Insets insets = container.getInsets();
                    n4 = insets.top;
                    n3 = container.height - insets.bottom;
                    n2 = insets.left;
                    n = container.width - insets.right;
                    bl = container.getComponentOrientation().isLeftToRight();
                    component4 = this.north;
                    component3 = this.east;
                    component2 = this.south;
                    component = this.west;
                    if (this.firstLine != null) {
                        component4 = this.firstLine;
                    }
                    if (this.lastLine != null) {
                        component2 = this.lastLine;
                    }
                    if (this.firstItem == null) break block13;
                    if (!bl) break block14;
                    component = this.firstItem;
                    break block13;
                }
                component3 = this.firstItem;
            }
            if (this.lastItem != null) {
                if (bl) {
                    component3 = this.lastItem;
                } else {
                    component = this.lastItem;
                }
            }
            if (component4 != null) {
                dimension = this.calcCompSize(component4, 2);
                component4.setBounds(n2, n4, n - n2, dimension.height);
                n4 += dimension.height + this.vgap;
            }
            if (component2 != null) {
                dimension = this.calcCompSize(component2, 2);
                component2.setBounds(n2, n3 - dimension.height, n - n2, dimension.height);
                n3 -= dimension.height + this.vgap;
            }
            if (component3 != null) {
                dimension = this.calcCompSize(component3, 2);
                component3.setBounds(n - dimension.width, n4, dimension.width, n3 - n4);
                n -= dimension.width + this.hgap;
            }
            if (component != null) {
                dimension = this.calcCompSize(component, 2);
                component.setBounds(n2, n4, dimension.width, n3 - n4);
                n2 += dimension.width + this.hgap;
            }
            if (this.center != null) {
                this.center.setBounds(n2, n4, n - n2, n3 - n4);
            }
            return;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ']';
    }

    private final Dimension calcCompSize(Component component, int n) {
        if (component == null || !component.isVisible()) {
            return new Dimension(0, 0);
        }
        if (n == 0) {
            return component.getMinimumSize();
        }
        if (n == 1) {
            return component.getMaximumSize();
        }
        return component.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Dimension calcSize(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            Component component;
            Component component2;
            Component component3;
            Component component4;
            boolean bl;
            Insets insets;
            block13: {
                block14: {
                    insets = container.getInsets();
                    ComponentOrientation componentOrientation = container.getComponentOrientation();
                    bl = componentOrientation.isLeftToRight();
                    component4 = this.north;
                    component3 = this.east;
                    component2 = this.south;
                    component = this.west;
                    if (this.firstLine != null) {
                        component4 = this.firstLine;
                    }
                    if (this.lastLine != null) {
                        component2 = this.lastLine;
                    }
                    if (this.firstItem == null) break block13;
                    if (!bl) break block14;
                    component = this.firstItem;
                    break block13;
                }
                component3 = this.firstItem;
            }
            if (this.lastItem != null) {
                if (bl) {
                    component3 = this.lastItem;
                } else {
                    component = this.lastItem;
                }
            }
            Dimension dimension = this.calcCompSize(component4, n);
            Dimension dimension2 = this.calcCompSize(component2, n);
            Dimension dimension3 = this.calcCompSize(component3, n);
            Dimension dimension4 = this.calcCompSize(component, n);
            Dimension dimension5 = this.calcCompSize(this.center, n);
            int n3 = dimension3.width + dimension5.width + dimension4.width + this.hgap * 2;
            if (n3 < dimension3.width || n3 < dimension5.width || n3 < dimension5.width) {
                n3 = Integer.MAX_VALUE;
            }
            if (dimension.width > n3) {
                n3 = dimension.width;
            }
            if (dimension2.width > n3) {
                n3 = dimension2.width;
            }
            n3 += insets.left + insets.right;
            int n4 = dimension3.height;
            if (dimension5.height > n4) {
                n4 = dimension5.height;
            }
            if (dimension4.height > n4) {
                n4 = dimension4.height;
            }
            n4 = (n2 = n4 + (dimension.height + dimension2.height + this.vgap * 2 + insets.top + insets.bottom)) < n4 ? Integer.MAX_VALUE : n2;
            return new Dimension(n3, n4);
        }
    }

    public Component getLayoutComponent(Object object) {
        if (object == CENTER) {
            return this.center;
        }
        if (object == NORTH) {
            return this.north;
        }
        if (object == EAST) {
            return this.east;
        }
        if (object == SOUTH) {
            return this.south;
        }
        if (object == WEST) {
            return this.west;
        }
        if (object == "First") {
            return this.firstLine;
        }
        if (object == "Last") {
            return this.lastLine;
        }
        if (object == "Before") {
            return this.firstItem;
        }
        if (object == "After") {
            return this.lastItem;
        }
        throw new IllegalArgumentException("constraint " + object + " is not recognized");
    }

    public Component getLayoutComponent(Container container, Object object) {
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        if (object == CENTER) {
            return this.center;
        }
        if (object == NORTH) {
            return this.north;
        }
        if (object == SOUTH) {
            return this.south;
        }
        if (object == WEST) {
            if (componentOrientation.isLeftToRight()) {
                return this.firstItem == null ? this.west : this.firstItem;
            }
            return this.lastItem == null ? this.west : this.lastItem;
        }
        if (object == EAST) {
            if (componentOrientation.isLeftToRight()) {
                return this.lastItem == null ? this.east : this.lastItem;
            }
            return this.firstItem == null ? this.east : this.firstItem;
        }
        throw new IllegalArgumentException("constraint " + object + " is not recognized");
    }

    public Object getConstraints(Component component) {
        if (component == null) {
            return null;
        }
        if (component == this.center) {
            return CENTER;
        }
        if (component == this.north) {
            return NORTH;
        }
        if (component == this.east) {
            return EAST;
        }
        if (component == this.south) {
            return SOUTH;
        }
        if (component == this.west) {
            return WEST;
        }
        if (component == this.firstLine) {
            return "First";
        }
        if (component == this.lastLine) {
            return "Last";
        }
        if (component == this.firstItem) {
            return "Before";
        }
        if (component == this.lastItem) {
            return "After";
        }
        return null;
    }

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }
}

