/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.channels.FileChannelImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private FileChannelImpl ch;

    public int available() throws IOException {
        return this.ch.available();
    }

    public void close() throws IOException {
        this.ch.close();
    }

    protected void finalize() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FileDescriptor getFD() throws IOException {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.fd == null) {
                this.fd = new FileDescriptor(this.ch);
            }
            return this.fd;
        }
    }

    public int read() throws IOException {
        return this.ch.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ch.read(byArray, n, n2);
    }

    public synchronized long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Can't skip negative bytes: " + l);
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = this.ch.position();
        this.ch.position(l2 + l);
        return this.ch.position() - l2;
    }

    public synchronized FileChannel getChannel() {
        return this.ch;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public FileInputStream(File file) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(file.getPath());
        }
        this.ch = FileChannelImpl.create(file, 1);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.ch = (FileChannelImpl)fileDescriptor.channel;
    }

    FileInputStream(FileChannelImpl fileChannelImpl) {
        this.ch = fileChannelImpl;
    }
}

