/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_STOCK__
#define __SG_STOCK__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef __SG_STOCK_H__

#define SG_STOCK_BUTTON_OK     "Button_Ok"
#define SG_STOCK_BUTTON_CANCEL "Button_Cancel"
#define SG_STOCK_BUTTON_YES    "Button_Yes"
#define SG_STOCK_BUTTON_NO     "Button_No"
#define SG_STOCK_BUTTON_CLOSE  "Button_Close"
#define SG_STOCK_BUTTON_APPLY  "Button_Apply"
#define SG_STOCK_BUTTON_HELP   "Button_Help"
#define SG_STOCK_BUTTON_NEXT   "Button_Next"
#define SG_STOCK_BUTTON_PREV   "Button_Prev"
#define SG_STOCK_BUTTON_UP     "Button_Up"
#define SG_STOCK_BUTTON_DOWN   "Button_Down"
#define SG_STOCK_BUTTON_FONT   "Button_Font"
#define SG_STOCK_PIXMAP_OPEN   "Open"

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_STOCK_H__ */

/* returns a default button widget for dialogs */
GtkWidget            *sg_stock_button          		(const char *type);

GtkWidget            *sg_pixmap_button         		(GtkWidget *pixmap,
                                                   	 const char *text);
GtkWidget            *sg_stock_pixmap_widget_new	(const char *type);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_STOCK__ */

