# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the Daemon module"""

from lottanzb.hellalog import LogRecord, _ExceptionHandler, _Plural
from lottanzb.util import _

class UndefinedDirectoryFatal(LogRecord): # ensureDaemonDirs()
    PATTERN = r"Required directory not defined in config file: Hellanzb\.(?P<directory>.+)"
    TEMPLATE = _("Required directory Hellanzb.%(directory)s not defined in the configuration file")

class UndefinedStateFileFatal(LogRecord): # ensureDaemonDirs()
    PATTERN = r"Hellanzb\.STATE_XML_FILE not defined in config file"
    TEMPLATE = _("Hellanzb.STATE_XML_FILE not defined in the configuration file")

class StateFileWriteAccessFatal(LogRecord): # ensureDaemonDirs()
    PATTERN = r"hellanzb does not have write access to the Hellanzb\.STATE_XML_FILE file"
    TEMPLATE = _("HellaNZB does not have write access to the Hellanzb.STATE_XML_FILE file")

class WriteAccessFatal(LogRecord): # ensureCleanDir(...)
    PATTERN = r"Cannot continue: hellanzb needs write access to (?P<directory>.+)"
    TEMPLATE = _("HellaNZB does not have write access to %(directory)s")

class MonitoringQueueInfo(LogRecord): # initDaemon()
    PATTERN = r"^hellanzb - Now monitoring queue\.\.\.$"
    TEMPLATE = _("Now monitoring queue...")

class LoadingHellaHellaError(_ExceptionHandler, LogRecord): # initHellaHella()
    PATTERN = r"^Unable to load hellahella$"
    TEMPLATE = _("Unable to load hellahella")

class ResumingPostProcessorInfo(LogRecord): # resumePostProcessors()
    PATTERN = r"^Resuming post processor: (?P<archive_name>.+)$"
    TEMPLATE = _("Resuming post-processor: %(archive_name)s")

class TransferredInfo(LogRecord): # endDownload()
    PATTERN = r"^Transferred (?P<size>.+) in (?P<time>.+) at (?P<speed>[.0-9]+)KB/s \((?P<archive_name>.+)\)$"
    TEMPLATE = _("Transferred %(size)s in %(time)s at %(speed)s KB/s (%(archive_name)s)")

class NotADirectoryError(LogRecord): # postProcess(...)
    PATTERN = r"^Unable to process, not a directory: (?P<directory>.+)$"
    TEMPLATE = _("Unable to process: %(directory)s is not a directory")

class ReadAccessError(LogRecord): # postProcess(...)
    PATTERN = r"^Unable to process, no read access to directory: (?P<directory>.+)$"
    TEMPLATE = _("Unable to process: HellaNZB does not have read access to %(directory)s")

class StartingPostProcessorInfo(LogRecord): # postProcess(...)
    PATTERN = r"^Starting post processor$"
    TEMPLATE = _("Starting post-processor")

class CancelDownloadInfo(LogRecord): # cancelCurrent()
    PATTERN = r"^Canceling download: (?P<archive_name>.+)$"
    TEMPLATE = _("Canceling download: %(archive_name)s")

class CancelingWorkingDirError(_ExceptionHandler, LogRecord): # cancelCurrent()
    PATTERN = r"^Problem while canceling WORKING_DIR$"
    TEMPLATE = _("Problem while canceling WORKING_DIR")

class PausingDownloaderInfo(LogRecord): # pauseCurrent()
    PATTERN = r"^Pausing downloader$"
    TEMPLATE = _("Pausing downloader")

class ContinuingDownloaderInfo(LogRecord): # continueCurrent()
    PATTERN = r"^Continuing downloader$"
    TEMPLATE = _("Continuing downloader")

class ContinuingDownloaderResetInfo(_Plural, ContinuingDownloaderInfo): # continueCurrent()
    PATTERN = r"^Continuing downloader \((?P<connections>\d+) connections were reset\)$"
    TEMPLATE = _("Continuing downloader (%(connections)s connection was reset)")
    TEMPLATE_2 = _("Continuing downloader (%(connections)s connections were reset)")

class ClearingQueueInfo(LogRecord): # clearCurrent(...)
    PATTERN = r"^Clearing queue$"
    TEMPLATE = _("Clearing queue")

class ResettingMaxRateInfo(LogRecord): # maxRate(...)
    PATTERN = r"^Resetting MAX_RATE to: (?P<speed>[.0-9]+)KB/s$"
    TEMPLATE = _("Resetting MAX_RATE to: %(speed)s KB/s")

class InterruptingInfo(LogRecord): # forceNZB(...)
    PATTERN = r"^Interrupting: (?P<archive_name>.+)$"
    TEMPLATE = _("Interrupting: %(archive_name)s")
