/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.PointBehaviourListener;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraphBase;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;

public class Sprite
extends SceneGraphBase
implements Primitive,
ImageObserver {
    private URL _src = null;
    private double _hotspot_x = 0.0;
    private double _hotspot_y = 0.0;
    private transient Image _image = null;
    private Shape _last_drawn = null;

    public Shape getShape(Graphics2D graphics2D) {
        if (this._image == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return new Rectangle2D.Double(-(this._hotspot_x + 1.0), -(this._hotspot_y + 1.0), this._image.getWidth(this) + 2, this._image.getHeight(this) + 2);
    }

    public Shape getLastDrawnShape() {
        return this._last_drawn;
    }

    public Image getImage() {
        return this._image;
    }

    public void setSrc(URL uRL) {
        this._src = uRL;
        this.setDirty(true);
        this.reloadImage();
    }

    public URL getSrc() {
        return this._src;
    }

    public Point2D getHotspot() {
        return new Point2D.Double(this._hotspot_x, this._hotspot_y);
    }

    public void setHotspot(Point2D point2D) {
        this._hotspot_x = point2D.getX();
        this._hotspot_y = point2D.getY();
        this.setDirty(true);
    }

    public double getHotspotX() {
        return this._hotspot_x;
    }

    public void setHotspotX(double d) {
        this._hotspot_x = d;
        this.setDirty(true);
    }

    public double getHotspotY() {
        return this._hotspot_y;
    }

    public void setHotspotY(double d) {
        this._hotspot_y = d;
        this.setDirty(true);
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.drawImage(this._image, -((int)this._hotspot_x), -((int)this._hotspot_y), null);
        this._last_drawn = this.getShape(graphics2D);
        this.setDirty(false);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.setDirty(true);
        if ((n & 0xC0) != 0) {
            this._image = null;
            return false;
        }
        return (n & 0x20) == 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.reloadImage();
    }

    private void reloadImage() {
        if (this._image != null) {
            this._image.flush();
        }
        this._image = Toolkit.getDefaultToolkit().createImage(this._src);
        Toolkit.getDefaultToolkit().prepareImage(this._image, -1, -1, this);
    }

    public PointBehaviourListener newHotspotAdapter() {
        return new Hotspot();
    }

    public DoubleBehaviourListener newHotspotXAdapter() {
        return new HotspotX();
    }

    public DoubleBehaviourListener newHotspotYAdapter() {
        return new HotspotY();
    }

    class HotspotY
    implements DoubleBehaviourListener {
        HotspotY() {
        }

        public void behaviourUpdated(double d) {
            Sprite.this.setHotspotY(d);
        }
    }

    class HotspotX
    implements DoubleBehaviourListener {
        HotspotX() {
        }

        public void behaviourUpdated(double d) {
            Sprite.this.setHotspotX(d);
        }
    }

    class Hotspot
    implements PointBehaviourListener {
        Hotspot() {
        }

        public void behaviourUpdated(Point2D point2D) {
            Sprite.this.setHotspot(point2D);
        }
    }
}

