local lang = {
  ["abort"] = "Abort",
  ["acknowledge"] = "Acknowledge",
  ["acknowledge_alerts"] = "Acknowledge Alerts",
  ["acknowledged_all"] = "All",
  ["acknowledged_only"] = "Acknowledged Only",
  ["action"] = "Action",
  ["actions"] = "Actions",
  ["active_flows"] = "Live",
  ["active_hosts"] = "Active",
  ["active_inactive"] = "Active/Inactive Hosts",
  ["active_monitoring"] = "Active Monitoring",
  ["active_ports"] = "Server Ports Analysis",
  ["activities"] = "Activities",
  ["activity"] = "Activity",
  ["add"] = "Add",
  ["additional_interfaces"] = "Additional Interfaces",
  ["add_application"] = "Add Application",
  ["add_vs_host"] = "Add Host to Scan",
  ["admin_status"] = "Administrative Status",
  ["admin_status_short"] = "Admin. Status",
  ["advanced"] = "Advanced",
  ["advanced_charts_test"] = "Advanced Charts Test",
  ["aggregation"] = "Aggregation",
  ["alerted_flows"] = "Alerted Flows",
  ["alerts_analysis"] = "Flow Alerts Analyser",
  ["alias"] = "Alias",
  ["all"] = "All",
  ["all_devices"] = "All Devices",
  ["all_hosts"] = "All Hosts",
  ["all_manufacturer"] = "All Manufacturer",
  ["all_obs_points"] = "All Obs. Points",
  ["all_tcp_udp"] = "All (TCP and UDP)",
  ["allowed"] = "Allowed",
  ["always"] = "Always",
  ["analysis"] = "Analysis",
  ["analyze_db"] = "Analyse DB records",
  ["analyze_db_descr"] = "Please select a valid range for records to be analysed by ntopng",
  ["analyze_db_error"] = "Error while creating a new runtime interface",
  ["analyze_db_ok"] = "Records analysed succesfully",
  ["analyze_db_ok_descr"] = "Historical flows have been analysed and a new virtual network interface is now available.",
  ["analyze_db_ok_note"] = "Please note historical flow processing is limited by the flow cache size (%{size} entries).",
  ["analyze_pcap"] = "Analyse pcap",
  ["analyze_pcap_descr"] = "Please select a pcap file to be uploaded to ntopng for analysis",
  ["analyze_pcap_error"] = "Error while creating a new pcap interface (same pcap already uploaded ?)",
  ["analyze_pcap_long_descr"] = "This page allows you to upload a pcap and analyze it with ntopng.",
  ["analyze_pcap_ok"] = "Pcap uploaded succesfully",
  ["and"] = "and",
  ["and_x_more"] = "and %{num} more",
  ["answer"] = "Answer",
  ["any"] = "any",
  ["app_name"] = "Application Name",
  ["application"] = "Application",
  ["application_proto"] = "Application Protocol",
  ["application_proto_guessed"] = "Guessed",
  ["applications"] = "Apps",
  ["applications_long"] = "Applications",
  ["apply"] = "Apply",
  ["are_you_sure"] = "Are you sure?",
  ["arp"] = "ARP",
  ["arp_type"] = "ARP Type",
  ["as"] = "AS",
  ["as_client"] = "as Client",
  ["as_info"] = "AS info",
  ["as_number"] = "AS number",
  ["as_server"] = "as Server",
  ["asn"] = "ASN",
  ["asn_id"] = "ASN %{id}",
  ["asset"] = "Asset",
  ["asset_map"] = "Asset Map",
  ["asset_table"] = "Asset Table",
  ["assets"] = "Assets",
  ["attacker"] = "Is Attacker",
  ["auto_refresh_descr"] = "Click the arrows to enable/disable Auto-Refresh (enabled when spinning). Click the Cog next to the arrows to go to the alert Preferences.",
  ["autolayout"] = "Autolayout",
  ["autolayout_description"] = "Performing auto-layout could change the network's current layout drastically.",
  ["availability"] = "Availability",
  ["available"] = "Available",
  ["avg_bytes_volume_per_status"] = "Average Bytes Volume (per Flow)",
  ["avg_client_nw_latency"] = "Average Client Network Latency",
  ["avg_host_score"] = "Average Host Score",
  ["avg_server_nw_latency"] = "Average Server Network Latency",
  ["backup"] = "Backup",
  ["backup_date"] = "Backup Date",
  ["begin"] = "Begin",
  ["big_endian"] = "Year/Month/Day",
  ["bind"] = "Bind",
  ["blacklisted_category"] = "Application category Malware detected %{config_href}",
  ["breakdown"] = "Breakdown",
  ["bridge"] = "Bridge",
  ["broadcast"] = "Broadcast",
  ["broadcast_domain"] = "Broadcast Domain",
  ["broadcast_domain_too_large_description"] = "Trigger an alert when ARP traffic between two MACS addresses beloging to different broadcast domains is detected",
  ["broadcast_domain_too_large_title"] = "Broadcast Domain Too Large",
  ["broadcast_traffic"] = "Broadcast Traffic",
  ["broadcast_traffic_rx"] = "Broadcast Traffic RX",
  ["broadcast_traffic_rx_tx"] = "Broadcast Traffic RX + TX",
  ["broadcast_traffic_tx"] = "Broadcast Traffic TX",
  ["browse_config"] = "Browse a configuration file to import",
  ["browse_snmp_devices"] = "Browse a CSV or JSON file with a list of SNMP devices",
  ["busy"] = "Busy",
  ["bytes"] = "Bytes",
  ["cancel"] = "Cancel",
  ["categories"] = "Categories",
  ["category"] = "Category",
  ["category_custom_rule"] = "Category Custom Rule",
  ["cc_list"] = "Comma separated list of email addresses.",
  ["change"] = "Change",
  ["change_number_of_rows"] = "Change the number of rows per page",
  ["change_policy"] = "Change Host Pool Policy",
  ["chart"] = "Chart",
  ["chart_annotation"] = "* Each bar is %{time} long",
  ["chart_view"] = "Chart View",
  ["check_emergency_recipient"] = "No recipient configured for Emergency Alerts (alerts with Emergency severity), please <a href='%{http_prefix}/lua/admin/endpoint_notifications_list.lua?subdir=recipient'>configure</a> it to receive important notifications!",
  ["check_historical"] = "Check Historical",
  ["check_live"] = "Check Live",
  ["check_mirrored_traffic"] = "RX only traffic detected. Perhaps do you need to activate 'Mirrored Traffic' option in the <a href='/lua/if_stats.lua?ifid=%{id}&page=config'>Interface options</a>?",
  ["city"] = "City",
  ["classification"] = "Traffic Classification",
  ["cli_port"] = "Cli Port",
  ["click_to_expand"] = "Click to expand",
  ["client"] = "Client",
  ["client_alpn"] = "Client ALPN",
  ["client_and_server"] = "Client and Server",
  ["client_count"] = "Clients Contacts",
  ["client_fingerprint"] = "Client Fingerprint",
  ["client_fingerprint_type"] = "Type",
  ["client_name"] = "Client Name",
  ["client_requested_server_name"] = "Requested Server Name",
  ["client_server"] = "Client / Server",
  ["client_server_application_proto"] = "Client / Server / App. Proto",
  ["client_server_srv_port"] = "Client / Server / Dst Port",
  ["client_server_srv_port_app_proto"] = "Client / Server / Dst Port / App. Proto",
  ["client_signature"] = "Client Signature",
  ["client_tls_supported_versions"] = "Client Supported TLS Protocols",
  ["client_to_server"] = "Client to Server",
  ["client_traffic"] = "Client to Server Traffic",
  ["clients"] = "Clients",
  ["clone"] = "Clone",
  ["close"] = "Close",
  ["code"] = "ICMP Code",
  ["comment"] = "Comment",
  ["confidence"] = "Confidence",
  ["confidence_dpi"] = "DPI",
  ["confidence_guessed"] = "Guess",
  ["confidence_unknown"] = "Unknown",
  ["configure"] = "Configure",
  ["confirm"] = "Confirm",
  ["confirm_delete_obs_point"] = "Are you sure to delete the selected Observation Point?",
  ["connected"] = "Connected",
  ["connection_states"] = "Connection State [ Major / Minor ]",
  ["copied"] = "Copied",
  ["copy_button"] = "<span title='%{full_name}'>%{name}</span>",
  ["count"] = "Count",
  ["countries"] = "Countries",
  ["country"] = "Country",
  ["create"] = "Create",
  ["create_new_pcap_iface"] = "Open On New Network Interface",
  ["create_new_pcap_iface_descr"] = "Open the pcap on a new network interface (or load it on this interface).",
  ["criteria"] = "Criteria",
  ["criteria_filter"] = "Aggregation type",
  ["csv"] = "CSV",
  ["culprit"] = "Culprit",
  ["current_filter"] = "Exclude Checks",
  ["current_filter_for"] = "Exclude For",
  ["current_interface_traffic"] = "Current Interface Traffic",
  ["dark"] = "Dark",
  ["data_flush_confirm"] = "Do you really want to flush all data?",
  ["date"] = "Date",
  ["date_from"] = "Begin Date/Time:",
  ["date_to"] = "End Date/Time:",
  ["day"] = "Day",
  ["default"] = "Default",
  ["default_interface_speed"] = "Default Interface Speed",
  ["default_serie_name"] = "Series 1",
  ["define"] = "Define",
  ["delete"] = "Delete",
  ["delete_alerts"] = "Delete Alerts",
  ["delete_all_entries"] = "Delete All",
  ["delete_all_inactive_hosts"] = "Are you sure to delete all Inactive Hosts? This action cannot be undone.",
  ["delete_all_vs_hosts"] = "Are you sure to delete all Hosts to Scan? This action cannot be undone.",
  ["delete_disabled_alerts"] = "Delete Alerts",
  ["delete_inactive_host"] = "Are you sure to delete the selected host from Inactive Hosts? This action cannot be undone.",
  ["delete_inactive_host_title"] = "Delete Inactive Host",
  ["delete_obs_point"] = "Delete Observation Point",
  ["delete_older"] = "Delete Older Than",
  ["delete_since"] = "Are you sure to remove ALL Inactive Hosts older than:",
  ["delete_vs_host"] = "Are you sure to remove the selected host to scan? This action cannot be undone.",
  ["delete_vs_host_title"] = "Delete Host to Scan",
  ["denied"] = "Denied",
  ["description"] = "Description",
  ["destination"] = "Destination",
  ["developer"] = "Developer",
  ["device"] = "Device",
  ["device_ip"] = "Device IP",
  ["device_protocols_description"] = "In this page it is possible to configure the list of acceptable applications per device type and direction (device as client or server with respect to the application). By enabling the flow user script Device Application Not Allowed in the Checks configuration page, alerts are generated when an anomalous application is detected.",
  ["device_type_filter"] = "Device Filter",
  ["devices"] = "Devices",
  ["difference"] = "Difference",
  ["disable"] = "Disable",
  ["disable_check_title"] = "Disable Selected Check",
  ["disabled"] = "Disabled",
  ["discarded"] = "Discarded",
  ["disconnected"] = "Disconnected",
  ["dismiss"] = "Dismiss",
  ["dns"] = "DNS",
  ["does_not_have"] = "does not contain",
  ["domain"] = "Domain",
  ["double_click_node"] = "<b>Note:</b> Double click on a host rectangle to drill down.",
  ["double_num_flows_hosts"] = "Double Number",
  ["downlink"] = "In Usage",
  ["downlink_usage"] = "Last In Usage",
  ["download"] = "Download",
  ["download_days"] = "Download last %{days} day(s)",
  ["download_format"] = "Please select the format of the data to download:",
  ["download_icon"] = "<i class='fas fa-arrow-down'></i>",
  ["download_x"] = "%{what} Download",
  ["downloaders"] = "Download Volume",
  ["drilldown"] = "Drilldown",
  ["dscp"] = "DSCP",
  ["dscp_dst2src"] = "Server DSCP",
  ["dscp_src2dst"] = "Client DSCP",
  ["duplexstatus"] = "Duplex Status",
  ["duration"] = "Duration",
  ["edit"] = "Edit",
  ["edit_application"] = "Edit Application",
  ["edit_check_title"] = "Edit Check Options",
  ["edit_configuration"] = "Edit Configuration",
  ["egress"] = "Egress",
  ["emergency_notifications"] = "Emergency Notifications",
  ["empty"] = "Empty",
  ["enable"] = "Enable",
  ["enable_active_monitoring_warning"] = "Active Monitoring is disabled. Please enable it on the Active Monitoring <a href='%{base_prefix}/lua/admin/prefs.lua?tab=active_monitoring'>Preferences</a> Page.",
  ["enable_auto_refresh"] = "Auto-Refresh",
  ["enable_check_title"] = "Enable Selected Check",
  ["enable_snmp_polling_warning"] = "SNMP polling is disabled. Please enable it on the SNMP <a href='%{base_prefix}/lua/admin/prefs.lua?tab=snmp'>Preferences</a> Page.",
  ["enable_them"] = "Enable Them",
  ["enabled"] = "Enabled",
  ["end"] = "End",
  ["enterpriseOnly"] = "This feature is only available in the ntopng Enterprise edition",
  ["err_del_inactive_hosts"] = "Error while deleting Inactive Hosts",
  ["error"] = "Error",
  ["error_no_search_results"] = "No results found. Please modify your search criteria.",
  ["error_not_granted"] = "Request not granted",
  ["error_rrd_cannot_complete_dump"] = "Cannot complete local hosts timeseries dump. Disk slow or too many local hosts?",
  ["error_rrd_low_resolution"] = "You are asking to fetch data at lower resolution than the one available on RRD, which will lead to invalid data.<br>If you still want data with such granularity, please tune <a href=\"%{prefs}\">Application/Networks Timeseries</a> preferences",
  ["errors"] = "Errors",
  ["exclude_check"] = "Exclude Check",
  ["exclude_for"] = "Exclude for",
  ["expired_csrf"] = "Could not perform the requested action because the page expired. Please reload the page and perform the action again.",
  ["export"] = "Export",
  ["export_snmp_device_data"] = "Download Debug Data",
  ["external_link"] = "External Link",
  ["external_link_url"] = "<button onclick='const textArea = document.createElement(`textarea`);textArea.value=`%{proto}://%{url}`;textArea.style.position=`absolute`;textArea.style.left=`-999999px`;document.body.prepend(textArea);textArea.select();document.execCommand(`copy`);' class='btn btn-light btn-sm border ms-1' style='cursor: pointer;'><i class='fas fa-copy'></i></button> <a class='ntopng-external-link' href='%{proto}://%{url}' target='_blank'><i class='fas fa-external-link-alt'></i> %{url_name}</a>",
  ["factory_reset"] = "Factory Reset",
  ["file"] = "File",
  ["file_to_large"] = "File size exceeds the maximum limit of 128KB.",
  ["filter"] = "Exclude",
  ["filter_alerts_by"] = "Deliver Alerts based on",
  ["filter_by"] = "Filter by",
  ["filter_per_alerts"] = "Alert Type",
  ["filter_per_properties"] = "Properties",
  ["filter_presets"] = "Filter Presets",
  ["fingerprint_note"] = "Application name is set only if ntopng is configured to receive a eBPF feed via ZMQ",
  ["first_seen"] = "First Seen",
  ["flow"] = "Flow",
  ["flow_alerts_search_criteria"] = "Flow Alerts Search Criteria",
  ["flow_count_per_flow_risk"] = "Flow Count (Flow Risk)",
  ["flow_count_per_l7"] = "Flow Count (Applications)",
  ["flow_count_per_status"] = "Flow Count (Status)",
  ["flow_dump_not_working"] = "Please check the service logs for more information, it could be there is some issue with the filesystem permissions or available space.",
  ["flow_dump_not_working_title"] = "Flows Dump is not working",
  ["flow_exporter_device"] = "Exporters",
  ["flow_exporter_traffic"] = "Flow Exporter Traffic",
  ["flow_geomap"] = "Flow GeoMap",
  ["flow_issue_description"] = "Issue Description",
  ["flow_search_criteria"] = "Flow Search Criteria",
  ["flow_search_from_aggregated"] = "(Aggregated)",
  ["flow_search_results"] = "Flow Search Results",
  ["flow_size"] = "Flow Size",
  ["flow_source_netflow"] = "<span class=\"badge bg-secondary\">NetFlow/IPFIX</span>",
  ["flow_source_sflow"] = "<span class=\"badge bg-secondary\">sFlow</span>",
  ["flow_status"] = "Flows",
  ["flowdev_alias"] = "Flow Device Alias",
  ["flows"] = "Flows",
  ["flush_map_data"] = "Flush Data",
  ["forbidden"] = "Forbidden",
  ["free"] = "Free",
  ["frequency"] = "Frequency",
  ["from"] = "from",
  ["full"] = "Full",
  ["gateway"] = "Gateway",
  ["gb"] = "GB",
  ["gbit"] = "Gbit",
  ["gbps"] = "Gbps",
  ["generic_data"] = "Generic Data",
  ["geolocation_unavailable"] = "Please follow these <a href='%{url}' target='%{target}'>instructions <i class='%{icon}'></i></a>.",
  ["geolocation_unavailable_title"] = "Running without Geolocation support",
  ["geomap_per_status"] = "Alerted Flows Hosts Geomap",
  ["granularity"] = "Granularity",
  ["has"] = "contains",
  ["has_attacker"] = "Has Attacker",
  ["has_victim"] = "Has Victim",
  ["hassh_fingerprint"] = "HASSH Fingerprint",
  ["health"] = "Health",
  ["help"] = "Help",
  ["hidden_from_top_talkers"] = "Hidden from Top Talkers",
  ["highest_avg_dst_score"] = "Top Average Flow Score (Servers)",
  ["highest_avg_flow_size_per_l7"] = "Top Average Flow Size (Applications)",
  ["highest_avg_l7_score"] = "Top Average Flow Score (Applications)",
  ["highest_avg_protocol_score"] = "Top Average Flow Score (Protocols)",
  ["highest_avg_src_score"] = "Top Average Flow Score (Clients)",
  ["historical"] = "Historical Data",
  ["hits"] = "Hits",
  ["host"] = "Host %{host}",
  ["host_address"] = "Host Address",
  ["host_details_tooltip"] = "Host Details",
  ["host_flows"] = "Host Flows",
  ["host_notes"] = "Host Notes",
  ["host_score_ratio"] = "Host/Score Ratio",
  ["hostname"] = "Hostname",
  ["hosts"] = "Hosts",
  ["hosts_map"] = "Hosts Map",
  ["hour"] = "Hour",
  ["howto_multiselect"] = "To select multiple items hold <kbd>Ctrl</kbd> (or <kbd>Cmd</kbd> on Macs).",
  ["http"] = "HTTP",
  ["http_s"] = "HTTP(S)",
  ["https"] = "HTTPS",
  ["icmp"] = "ICMP",
  ["icmp_code"] = "ICMP Code",
  ["icmp_type"] = "ICMP Type",
  ["icmpv4"] = "ICMPv4",
  ["icmpv6"] = "ICMPv6",
  ["id"] = "ID",
  ["if_id"] = "SNMP Interface",
  ["iface_download"] = "%{iface} download",
  ["iface_upload"] = "%{iface} upload",
  ["import"] = "Import",
  ["import_export_config"] = "Import/Export Configuration",
  ["import_snmp_devices"] = "Succesfully imported devices!",
  ["import_snmp_devices_error"] = "The maximum number of configurable SNMP devices has been reached.",
  ["import_snmp_devices_fail"] = "Wrongly formatted json.",
  ["import_snmp_devices_ok"] = "Imported %{added_devices_num} new devices!",
  ["in_usage"] = "In Usage",
  ["inactive"] = "Inactive",
  ["inactive_hosts"] = "Inactive Local Hosts",
  ["inactive_hosts_navbar"] = "Inactive (Local)",
  ["inactivity_period"] = "Inactive Since",
  ["incomingflows"] = "Active Incoming Flows",
  ["info"] = "Info",
  ["information"] = "Information",
  ["ingress"] = "Ingress",
  ["input_interface"] = "Input Interface",
  ["interface"] = "Interface",
  ["interface_advertised_speed"] = "Interface Speed",
  ["interface_alias"] = "Alias",
  ["interface_details"] = "Details",
  ["interface_downlink_speed"] = "Downlink (In) Speed",
  ["interface_flow_exporter_device"] = "Interface of flow exporter device",
  ["interface_id"] = "Interface Id",
  ["interface_ifname"] = "Interface %{ifname}",
  ["interface_name"] = "Name",
  ["interface_status"] = "Operational Status",
  ["interface_status_short"] = "Oper. Status",
  ["interface_traffic"] = "Interface Traffic",
  ["interface_uplink_speed"] = "Uplink (Out) Speed",
  ["interfaces"] = "Interfaces",
  ["interfaces_traffic"] = "Interfaces Traffic",
  ["interfaces_usage"] = "Interfaces Usage",
  ["intranet_traffic"] = "Intranet Traffic",
  ["invalid_chars_in_query"] = "Invalid Characters in Query",
  ["invalid_password"] = "Password is not compliant with the ntop requirements: too short or does not contain valid ISO8859-1 (latin1) letters/numbers",
  ["invalid_value"] = "Invalid value",
  ["ip_address"] = "IP Address",
  ["ip_address_network"] = "IP Address / Network",
  ["ipv4"] = "IPv4",
  ["ipv6"] = "IPv6",
  ["is_connected"] = "is connected",
  ["issuerDN"] = "IssuerDN",
  ["issues_score"] = "Score / Issues",
  ["ja3_client"] = "JA3 Client",
  ["ja3_client_hash"] = "JA3 Client Hash",
  ["ja3_fingerprint"] = "JA3 Fingerprint",
  ["ja3_server"] = "JA3 Server",
  ["ja3_server_cipher"] = "JA3 Server Cipher",
  ["ja3_server_hash"] = "JA3 Server Hash",
  ["ja3_server_unsafe_cipher"] = "Cipher State",
  ["ja4_client_hash"] = "JA4 Client Hash",
  ["json"] = "JSON",
  ["jump_to_chart"] = "Chart View",
  ["jump_to_table"] = "Table View",
  ["kb"] = "KB",
  ["kbps"] = "Kbps",
  ["key"] = "Key",
  ["l7_error_code"] = "Error Code",
  ["l7_id"] = "App %{id}",
  ["l7_proto"] = "L7 Proto",
  ["label"] = "Label",
  ["label_alerts"] = "Label Alerts",
  ["language"] = "Language",
  ["last_downlink_usage"] = "Last Downlink (In) Usage",
  ["last_method"] = "Method",
  ["last_query"] = "Query",
  ["last_query_type"] = "Query Type",
  ["last_response_status_code"] = "Response Status Code",
  ["last_return_code"] = "Return Code",
  ["last_seen"] = "Last Seen",
  ["last_server"] = "Server",
  ["last_uplink_usage"] = "Last Uplink Usage",
  ["last_url"] = "URL",
  ["last_user_agent"] = "User Agent",
  ["latency"] = "Latency",
  ["layer_2"] = "MAC Addresses",
  ["legenda"] = "Legenda",
  ["level"] = "Level",
  ["light"] = "Light",
  ["listening_ports"] = "Listening Ports",
  ["little_endian"] = "Day/Month/Year",
  ["live_flows"] = "Active Flows",
  ["loading"] = "Loading...",
  ["local_hosts"] = "Local Hosts (Local RX-only Hosts)",
  ["local_hosts_only"] = "Local Hosts",
  ["local_traffic"] = "Local Traffic",
  ["lower_value_upper"] = "(lower / value / upper)",
  ["lua_c_api"] = "Lua/C API",
  ["mac_address"] = "MAC Address",
  ["mac_address_dev_type"] = "MAC Address / Device Type",
  ["main_issue"] = "Main Issue",
  ["malicious"] = "Malicious",
  ["manufacturer"] = "Manufacturer",
  ["map_format"] = "Map",
  ["maps"] = "Maps",
  ["max_entries_reached"] = "Warning: The entries of the Maps are too many, limited to 800 flows.",
  ["max_rate"] = "Max Rate",
  ["mb"] = "MB",
  ["mbps"] = "Mbps",
  ["memory"] = "Memory",
  ["middle_endian"] = "Month/Day/Year",
  ["mirrored_traffic"] = "Mirrored Traffic",
  ["missing_x_parameter"] = "Missing \"%{param}\" parameter",
  ["mitre_id"] = "Mitre Att&ck",
  ["model"] = "Model",
  ["modify_flowdev_alias"] = "Modify Flow Device Alias",
  ["monitoring"] = "Monitoring",
  ["month"] = "Month",
  ["mtu"] = "MTU",
  ["multicast"] = "Multicast",
  ["n_more_objects"] = "%{label} and %{num} more %{object}",
  ["name"] = "Name",
  ["name_txt"] = "Text Name",
  ["nation"] = "Country",
  ["ndpi_confidence"] = "Confidence",
  ["netmask"] = "Netmask",
  ["network"] = "Network",
  ["network_discovery_disabled"] = "Network Discovery is Disabled, Please Enable it in Preferences",
  ["network_filter"] = "Network Filter",
  ["network_id"] = "Network %{id}",
  ["network_traffic"] = "Network Traffic",
  ["networks"] = "Networks",
  ["new"] = "New",
  ["next"] = "Next",
  ["no"] = "No",
  ["noTraffic"] = "No traffic has been reported for the specified date/time selection",
  ["no_alerts_require_attention"] = "All good. There is no alert requiring user actions in the selected time frame.",
  ["no_attacker_no_victim"] = "No Attacker/Victim",
  ["no_data_available"] = "No Data Available",
  ["no_external_link_url"] = "<span><button data-to-copy='%{proto}://%{url}' class='copy-http-url btn btn-light btn-sm border ms-1' style='cursor: pointer;'><i class='fas fa-copy'></i></button>  <a href='%{proto}://%{url}' target='_blank'><i class='fas fa-external-link-alt'></i> %{url_name}</a></span>",
  ["no_flows"] = "No Flows",
  ["no_nprobes_message"] = "No nProbe Instances found",
  ["no_ports"] = "No Ports",
  ["no_results_found"] = "No results found",
  ["no_talkers_for_the_host"] = "There are no talkers for the current host",
  ["no_vlan"] = "Untagged",
  ["none"] = "None",
  ["notAfter"] = "TLS Certificate Validity To",
  ["notBefore"] = "TLS Certificate Validity From",
  ["not_admin"] = "Administrator privileges required",
  ["note_flow_search_allowed_networks"] = "Current user is only allowed to browse the following networks: %{nets}.",
  ["note_flow_search_allowed_networks_applications"] = "Hosts not belonging to any of the allowed networks will be hidden from the application talkers.",
  ["note_flow_search_allowed_networks_counter"] = "Counters in the flow search results are total but only flows with client and server in allowed networks will be shown.",
  ["note_flow_search_allowed_networks_ipv6"] = "Non-zero allowed IPv6 networks will cause all IPv6 flows from being shown.",
  ["note_flow_search_allowed_networks_talkers"] = "Hosts not belonging to any of the allowed networks will be hidden from the top talkers.",
  ["note_scan_host"] = "The scanning should be scheduled in a couple of seconds, see 'Scan Status' to check the progresses",
  ["notes"] = "NOTES",
  ["nprobe_dropped_flows"] = "Failed Exports",
  ["nprobe_dropped_packets"] = "Capture Drops",
  ["nprobe_exported_flows"] = "Exported Flows",
  ["nprobe_packets"] = "Captured Pkts",
  ["ntop_age_to"] = "24",
  ["num_alerts"] = "Alerts Count",
  ["num_different_ports"] = "%{num} ports. None doing %{threshold}%%+ of the traffic.",
  ["num_entries"] = "Entries",
  ["num_uses"] = "Contacts",
  ["observation_point_alias"] = "Observation Point Alias",
  ["observation_point_id"] = "Obs. Point ID",
  ["observationpoints"] = "Observation Points",
  ["obsolete_mysql"] = "MySQL support is deprecated",
  ["obsolete_mysql_message"] = "ntopng is currently dumping flow data to MySQL, however MySQL export is deprecated. Please move to <a href=\"https://www.ntop.org/guides/ntopng/clickhouse.html\">ClickHouse</a> and migrate your data.",
  ["obsolete_nindex"] = "nIndex support is deprecated",
  ["obsolete_nindex_message"] = "ntopng is currently dumping flow data to nIndex, however nIndex support is deprecated. Please <a href=\"https://www.ntop.org/guides/ntopng/clickhouse.html#migration-from-nindex\">migrate flow data</a> to <a href=\"https://www.ntop.org/guides/ntopng/clickhouse.html\">ClickHouse</a>.",
  ["off"] = "Off",
  ["offline"] = "Offline (No Internet Connectivity)",
  ["ok"] = "OK",
  ["on_interface"] = "on interface",
  ["on_release"] = " The alert is released",
  ["on_trigger"] = "The alert is triggered",
  ["open"] = "Open",
  ["open_documentation"] = "Open in Documentation",
  ["operating_systems"] = "Operating Systems",
  ["optional_field"] = "(This field is optional)",
  ["options"] = "Options",
  ["order_by"] = "Order By",
  ["os"] = "OS",
  ["other"] = "Other",
  ["other_interfaces"] = "Other Interfaces",
  ["other_ip"] = "Other IP",
  ["others"] = "Others",  
  ["out_of_order"] = "Out of Order",
  ["out_of_orders"] = "Out of Orders",
  ["out_usage"] = "Out Usage",
  ["outgoingflows"] = "Active Outgoing Flows",
  ["output_interface"] = "Output Interface",
  ["overview"] = "Overview",
  ["package"] = "Package Name",
  ["packet_loss"] = "Packet Loss",
  ["packets"] = "Packets",
  ["passive"] = "Passive",
  ["pcap_file"] = "File To Analyse",
  ["peers"] = "Peers",
  ["per_alerts"] = "Per Alerts",
  ["percentage"] = "Percentage",
  ["percentage_absolute"] = "Absolute Percentage",
  ["percentage_change"] = "Percentage Change",
  ["percentage_decrease"] = "Percentage Decrease",
  ["percentage_increase"] = "Percentage Increase",
  ["perform_autolayout"] = "Perform Auto-Layout",
  ["periodic_flow"] = "Periodic",
  ["periodicity"] = "Periodicity",
  ["periodicity_map"] = "Periodicity Map",
  ["periodicity_table"] = "Periodicity Table",
  ["pkts"] = "Pkts",
  ["pkts_distribution"] = "Packets Distribution",
  ["pollers"] = "Monitoring",
  ["port"] = "Port",
  ["port_application"] = "Port (Application)",
  ["port_count"] = "Contacted Ports",
  ["ports"] = "Ports",
  ["posted"] = "Posted on",
  ["predominant_direction"] = "Main Direction",
  ["previous"] = "Previous",
  ["process"] = "Process",
  ["proto"] = "Proto",
  ["proto_info"] = "Protocol Info",
  ["protocol"] = "Protocol",
  ["protocol_categories"] = "Protocol Categories",
  ["protocols"] = "Protocols",
  ["purged_error_message"] = "Very likely it is expired and %{product} has purged it from memory. You can set purge idle timeout settings from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>.",
  ["push_notification"] = "Push Notification",
  ["qos_class"] = "QoS Class",
  ["quotas"] = "Quotas",
  ["ram_available"] = "Available",
  ["ram_total"] = "Total",
  ["ram_used"] = "Used",
  ["rcvd"] = "Rcvd",
  ["reason"] = "Reason",
  ["received"] = "Received",
  ["recipient"] = "Recipient",
  ["records_to_show"] = "Records to show",
  ["redirect"] = "Redirect",
  ["refresh"] = "Refresh",
  ["reload_graph"] = "Reload Graph",
  ["reload_map"] = "Reload Map",
  ["remediation"] = "Remediation",
  ["remote_hosts"] = "Remote Hosts (Remote RX-only Hosts)",
  ["remote_networks"] = "Remote Networks",
  ["remote_probe_clock_drift"] = "Remote probe clock drift",
  ["remove"] = "Remove",
  ["request_failed_message"] = "The request has failed !",
  ["reset"] = "Reset",
  ["reset_column"] = "Reset Columns Size",
  ["reset_default_interface_speed"] = "Reset Speed",
  ["reset_drops_if_message"] = "Are you sure to reset the Interface packet drops counters?",
  ["reset_drops_if_title"] = "Reset Interface Packet Drop Stats",
  ["reset_drops_ifs_message"] = "Are you sure to reset all Interfaces packet drops counters?",
  ["reset_drops_ifs_title"] = "Reset Interfaces Packet Drop Stats",
  ["reset_if_message"] = "Are you sure to reset the Interface stats?",
  ["reset_if_title"] = "Reset Interface Stats",
  ["reset_ifs_message"] = "Are you sure to reset all Interfaces stats?",
  ["reset_ifs_title"] = "Reset Interfaces Stats",
  ["restore"] = "Restore",
  ["restore_checks"] = "Restore Checks Defaults",
  ["retransmission"] = "Retransmission",
  ["retransmissions"] = "Retransmissions",
  ["retry"] = "Retry",
  ["role"] = "Role",
  ["rule_already_present"] = "The rule has already been added!",
  ["running"] = "Running",
  ["save"] = "Save",
  ["save_configuration"] = "Save Configuration",
  ["save_settings"] = "Save Settings",
  ["scan_all_hosts"] = "Do you really want to scan all configured hosts?",
  ["scan_all_hosts_title"] = "Scan All Hosts",
  ["scan_details"] = "Scan Details",
  ["scan_host"] = "Do you really want to scan the selected host?",
  ["scan_host_already_inserted"] = "Host %{host} with Scan Type: %{scan_type} has already been added!",
  ["scan_host_inserted"] = "Host %{host} has been correctly added!",
  ["scan_host_title"] = "Scan Selected Host",
  ["scan_host_updated"] = "Host %{host} has been correctly updated!",
  ["scan_hosts"] = "Vulnerability Scan",
  ["scan_in_progress"] = "total scan(s) to complete, it may take a while...",
  ["scan_net_not_found_hosts"] = "Scanning %{host}, not found any hosts to scan!",
  ["score"] = "Score",
  ["score_as_client"] = "Score As Client",
  ["score_as_server"] = "Score As Server",
  ["score_average"] = "Avg Score",
  ["score_distribution"] = "Score Distribution",
  ["score_not_accounted"] = "Not Accounted",
  ["script_browser"] = "Script Viewer: %{script_name}",
  ["script_contents"] = "Script File",
  ["scripts"] = "Scripts",
  ["search"] = "Search",
  ["search_host"] = "Search",
  ["seen_since"] = "Seen Since",
  ["sent"] = "Sent",
  ["serial"] = "Serial",
  ["server"] = "Server",
  ["server_count"] = "Contacted Servers",
  ["server_name"] = "Server Name",
  ["server_names"] = "Server Names",
  ["server_ports_analysis"] = "Server Ports Analysis",
  ["server_signature"] = "Server Signature",
  ["server_to_client"] = "Server to Client",
  ["server_traffic"] = "Server to Client Traffic",
  ["servers"] = "Servers",
  ["service"] = "Service",
  ["service_acceptance"] = "Service Status",
  ["service_map"] = "Service Map",
  ["service_table"] = "Service Table",
  ["service_tag"] = "Service Tag",
  ["set"] = "Set",
  ["settings"] = "Settings",
  ["severity"] = "Severity",
  ["short_broadcast"] = "B",
  ["short_multicast"] = "M",
  ["shortcuts"] = "Shortcuts",
  ["show_hide_filters"] = "Show/Hide Filters",
  ["showing_x_to_y_rows"] = "Showing %{x} to %{y} of %{tot} rows",
  ["similarity"] = "Similarity",
  ["snmp_max_num_devices_configured"] = "A number %{configured_devices} of SNMP devices have been configured, exceeding the limit of %{max_num}. Therefore, not all devices will be polled.",
  ["source"] = "Source",
  ["span_with_title"] = "<A HREF='%{url}'>%{shorten_name}</A",
  ["speed"] = "Speed",
  ["srv_port"] = "Srv Port",
  ["ssh"] = "SSH",
  ["ssid"] = "SSID",
  ["start"] = "Start",
  ["status"] = "Status",
  ["stop"] = "Stop",
  ["subjectDN"] = "SubjectDN",
  ["succ_del_inactive_hosts"] = "Successfully deleted Inactive Hosts",
  ["success"] = "Success",
  ["summary"] = "Summary",
  ["suspicious_payload"] = "Suspicious Payload",
  ["swagger_api"] = "REST API",
  ["swapped_flow"] = "Flow directions have been swapped",
  ["switch_new_db_interface"] = "View Analysed Traffic",
  ["switch_new_pcap_interface"] = "View Uploaded pcap",
  ["system"] = "System",
  ["system_alerts_status"] = "Alerts",
  ["system_host"] = "System Host",
  ["system_interface"] = "System Interface",
  ["system_interfaces_status"] = "Interfaces",
  ["system_status"] = "System",
  ["table_format"] = "Table",
  ["table_view"] = "Table View",
  ["talkers"] = "Talkers",
  ["tcp"] = "TCP",
  ["tcp_flags"] = "TCP Flags and Connection State",
  ["tcp_flow_state"] = "TCP Flow State",
  ["tcp_processes"] = "TCP Processes",
  ["tcp_stats"] = "TCP Statistics",
  ["tcp_udp"] = "Protocol",
  ["tcp_unresp_as_client"] = "TCP Flows Unresp as Client",
  ["tcp_unresp_as_server"] = "TCP Flows Unresp as Server",
  ["telemetry"] = "Telemetry",
  ["threshold"] = "Threshold",
  ["throughput"] = "Throughput",
  ["time"] = "Time",
  ["time_in"] = "in",
  ["timeframe"] = "Timeframe",
  ["timeline_test"] = "Timeline Test",
  ["tls"] = "TLS",
  ["tls_certificate"] = "TLS Certificate",
  ["tls_certificate_validity"] = "TLS Cert Validity",
  ["tls_version"] = "TLS Version",
  ["today"] = "Today",
  ["toggle_dark_theme"] = "Toggle Dark Theme",
  ["toggle_white_theme"] = "Toggle White Theme",
  ["too_many_exports"] = "Too many flow export drops",
  ["too_many_flows"] = "Too many flows",
  ["too_many_hosts"] = "Too many hosts",
  ["tools"] = "Tools",
  ["top_alerted_hosts"] = "Top Alerted Hosts",
  ["top_asn"] = "Top Autonomous Systems",
  ["top_cli_per_proto"] = "Top Clients per Application",
  ["top_dst_asn"] = "Top Autonomous Systems (Servers)",
  ["top_dst_flow_status"] = "Top Alerted Servers",
  ["top_dst_score"] = "Top Total Score (Servers)",
  ["top_hosts_per_proto_in_flows"] = "Top Hosts per Application (Flows)",
  ["top_interfaces_traffic"] = "Top Interfaces Traffic",
  ["top_l4_proto"] = "Top Protocols",
  ["top_l7_cat"] = "Top Categories",
  ["top_l7_proto"] = "Top Applications",
  ["top_mitre_id"] = "Top Mitre Attacks",
  ["top_mitre_subtechnique"] = "Top Mitre Sub-Techniques",
  ["top_mitre_tactic"] = "Top Mitre Tactics",
  ["top_mitre_technique"] = "Top Mitre Techniques",
  ["top_proto_per_flow_status"] = "Top Alerted Applications",
  ["top_protos"] = "Top Applications",
  ["top_sites"] = "Top Sites",
  ["top_sites_hits"] = "Top Sites (Hits)",
  ["top_sites_volume"] = "Top Sites (Volume)",
  ["top_src_asn"] = "Top Autonomous Systems (Clients)",
  ["top_src_flow_status"] = "Top Alerted Clients",
  ["top_src_score"] = "Top Total Score (Clients)",
  ["total"] = "Total",
  ["total_alerts"] = "Total Alerts",
  ["total_bytes"] = "Total Bytes",
  ["total_dst2src_bytes"] = "Total Rcvd Bytes",
  ["total_flow_score"] = "Total Flow Score",
  ["total_incoming_alerted_flows"] = "Total Alerted Flows As Server",
  ["total_incoming_unreachable_flows"] = "Total Incoming Unreach Flows",
  ["total_outgoing_alerted_flows"] = "Total Outgoing Alerted Flows",
  ["total_outgoing_unreachable_flows"] = "Total Outgoing Unreach Flows",
  ["total_retransmissions_rcvd"] = "Total Retransm Rcvd",
  ["total_retransmissions_sent"] = "Total Retransm Sent",
  ["total_score"] = "Tot. Score",
  ["total_score_host_page"] = "Total Score",
  ["total_src2dst_bytes"] = "Total Sent Bytes",
  ["total_traffic"] = "Total Traffic",
  ["traffic"] = "Traffic",
  ["traffic_cli_to_srv"] = "Client <i class='fas fa-arrow-right'></i> Server",
  ["traffic_policy"] = "Traffic Policy",
  ["traffic_rcvd"] = "Traffic Rcvd",
  ["traffic_sent"] = "Traffic Sent",
  ["traffic_srv_to_cli"] = "Server <i class='fas fa-arrow-right'></i> Client",
  ["traffic_type"] = "Traffic Type",
  ["type"] = "ICMP Type",
  ["udp"] = "UDP",
  ["udp_processes"] = "UDP Processes",
  ["unable_to_copy_to_clickboard"] = "Unable to copy to clipboard",
  ["undo"] = "Undo",
  ["unicast_only"] = "Unicast Only",
  ["unknowers"] = "Unknown Traffic Volume",
  ["unknown"] = "Unknown",
  ["unlimited"] = "&infin;",
  ["unreachable"] = "Unreachable",
  ["untagged"] = "Untagged",
  ["uplink"] = "In Usage",
  ["uplink_usage"] = "Last Out Usage",
  ["upload"] = "Upload",
  ["upload_icon"] = "<i class='fas fa-arrow-up'></i>",
  ["upload_pcap"] = "Upload pcap",
  ["upload_pcap_max_size"] = "File too big: max upload size %{size} MB",
  ["uploaders"] = "Upload Volume",
  ["used_by"] = "Used by",
  ["value"] = "Value",
  ["values"] = "Values",
  ["version"] = "Your version is %{vers}.",
  ["via"] = "Via",
  ["victim"] = "Is Victim",
  ["views"] = "Views",
  ["visible_columns"] = "Visible Columns",
  ["vlan"] = "VLAN",
  ["vlan_filter"] = "VLAN Filter",
  ["vlan_id"] = "VLAN",
  ["volume"] = "Volume",
  ["waiting_for_clickhouse_msg"] = "ClickHouse did not start correctly: please check the ntopng startup log and fix the reported problems.",
  ["warning"] = "Warning",
  ["week"] = "Week",
  ["welcome"] = "Welcome",
  ["welcome_to"] = "Welcome to %{product}",
  ["white"] = "White",
  ["wrong_date_range"] = "Invalid range date, please change it.",
  ["wrong_min_interval"] = "Invalid interval, range has to be less than: %time_interval",
  ["year"] = "Year",
  ["years"] = "Years",
  ["yes"] = "Yes",
  ["about"] = {
    ["about"] = "About",
    ["about_x"] = "About %{product}",
    ["active"] = "active",
    ["alert_defines"] = "Alert and Flow Status Definitions",
    ["alert_queries"] = "Queries",
    ["alerts_dropped"] = "Dropped",
    ["alerts_stored"] = "Stored",
    ["analyze_db"] = "Analyse DB Records",
    ["analyze_pcap"] = "Analyse Pcap File",
    ["built_on"] = "Built on",
    ["callback_directories"] = "Checks Directories",
    ["checks"] = "Behavioural Checks",
    ["configure_dhcp_range"] = "Configure DHCP range",
    ["contribute_to_project"] = "Contribute",
    ["copyright"] = "Copyright",
    ["cpu_load"] = "CPU Load",
    ["cpu_states"] = "CPU States",
    ["create_license"] = "We advise you create as well <code>ntopng.license</code> file (according to the instructions you received) to avoid loosing your license in case of redis cleanup",
    ["create_license_l"] = "Please be aware that you need also to create <code>/etc/ntopng.license</code> file as this file is used by the other companion applications.",
    ["data_directory"] = "Data",
    ["datadir_warning"] = "Please <A HREF=\"https://www.ntop.org/support/faq/migrate-the-data-directory-in-ntopng/\">migrate your data</A>",
    ["defs_directories"] = "Definitions Directories",
    ["dhcp_monitoring_title"] = "Monitoring DHCP Hosts",
    ["dhcp_range_missing_warning"] = "Configure <a href='%{dhcp_url}'>DHCP ranges</a> to make <a href='%{url}'>%{name}</a> preference effective.",
    ["directories"] = "Directories",
    ["dropped_store_queries_alerts"] = "Queries/Stored/Dropped Alerts",
    ["flow_checks_directory"] = "Flow",
    ["flows_limit_reached"] = "The maximum number of active flows has been reached thus not all records have been processed. This can be tuned with -X, or by clicking on the button below to double the current number. A %{product} restart is required to apply the changes.",
    ["forced_community_notification"] = "Community edition forced with <code>--community</code> with a ntop license installed. Please remove this option to enable the installed license.",
    ["forced_community_notification_short"] = "Community edition forced with --community",
    ["host_checks_directory"] = "Host",
    ["host_identifier_warning"] = "This interface is monitoring DHCP hosts. Please consider changing the <a href='%{url}'>%{name}</a> preference to \"MAC Address\".",
    ["hw_model"] = "Hardware Model",
    ["idle"] = "idle",
    ["interface_callbacks_directory"] = "Interface",
    ["iowait"] = "iowait",
    ["last_log"] = "Last Log Trace",
    ["licence"] = "License",
    ["licence_expires_in"] = "License expires in %{time}",
    ["licence_generation"] = "Click on the above URL to generate your ntopng license, or purchase a license at <a class='ntopng-external-link' href=\"%{purchase_url}\"> ntop shop  <i class=\"fas fa-external-link-alt\"></i></a>.<br>If you are no-profit, research or an education institution please read <a class='ntopng-external-link' href=\"%{universities_url}\">this page  <i class=\"fas fa-external-link-alt\"></i></a>.",
    ["licence_limits"] = "License Limits",
    ["licence_save_path"] = "Please generate your license and save it on /etc/ntopng.license (or /usr/local/etc on BSD-based platforms) and restart ntopng.",
    ["licence_status"] = "License",
    ["maintenance"] = "Maintenance",
    ["maintenance_expired"] = "%{product} maintenance expired",
    ["maintenance_expired_no_days_left"] = "Maintenance expired (no days left)",
    ["maintenance_left"] = "Until %{_until} [%{days_left} days left]",
    ["maxmind"] = "Includes support for <a class='ntopng-external-link' href=\"%{maxmind_url}\">MaxMind <i class=\"fas fa-external-link-alt\"></i></a> and <a class='ntopng-external-link' href='https://db-ip.com'>DB-IP <i class=\"fas fa-external-link-alt\"></i></a> Geolocation databases.",
    ["network_callbacks_directory"] = "Network",
    ["new_major_available"] = "A new %{product} stable version (v.%{version}) is available for <a href=\"%{url}\">download</a>: please upgrade.",
    ["ntop_blog"] = "ntop Blog",
    ["platform"] = "Platform",
    ["ram_memory"] = "RAM",
    ["readme_and_manual"] = "User's Guide",
    ["remote_probe_times"] = "Local time is %{local_time} and remote probe time is %{remote_time}",
    ["report_issue"] = "Report an Issue",
    ["runtime_status"] = "Runtime Status",
    ["save_licence"] = "Save License",
    ["scripts_directory"] = "Scripts",
    ["server_time"] = "Server Time",
    ["specify_licence"] = "Specify here your ntopng License",
    ["startup_line"] = "Startup Line",
    ["suggest_feature"] = "Suggest a Feature",
    ["system"] = "System",
    ["system_id"] = "System Id",
    ["telegram"] = "Help and News",
    ["telemetry_data_opt_out_msg"] = "Contribute to the project by sending encrypted, <a href=\"%{tel_url}\">anonymous telemetry data</a> to <a href=\"%{ntop_org}\">ntop.org</a>.",
    ["timezone"] = "Local Timezone",
    ["too_many_exports"] = "Restart %{product} removing <code>-F</code> option or use a faster storage.",
    ["upgrade_to_professional"] = "Upgrade to Pro/Enterprise version",
    ["uptime"] = "Uptime",
    ["version"] = "Version",
    ["you_have_too_many_flows"] = "Too many flows for %{product} leading to packet drops and high CPU load. Please tune -X or click the button below to double the current number. After that restart %{product}",
    ["you_have_too_many_hosts"] = "Too many hosts for %{product} leading to packet drops and high CPU load. Please tune -x or click the button below to double the current number. After that restart %{product}",
    ["you_need_to_sync_remote_probe_time"] = "You must synchronize the clock of ntopng and remote probe hosts as the <a href=\"%{url}\">clock drift</A> is too large and this will affect collected flow data.",
  },
  ["active_monitoring_stats"] = {
    ["active_monitoring"] = "Active Monitoring",
    ["active_monitoring_description"] = "Monitors the status and the response time of specific hosts",
    ["add_icmp"] = "Add ICMP Monitor",
    ["add_pool"] = "New Active Monitoring Pool",
    ["add_record"] = "Add Active Monitoring Record",
    ["alert_status"] = "Alert Status",
    ["alerted"] = "Alerted",
    ["am_note_http"] = "Measurement HTTP(S) retrieves a web page using HTTP and HTTPS.",
    ["am_note_icmp"] = "ICMP not available on Windows.",
    ["app_connect_descr"] = "The \"App Connect\" time is the time took to complete the TLS handshake.",
    ["availability"] = "Availability",
    ["bad_action_param"] = "Bad \"action\" paramater",
    ["checking_host"] = "Checking host...",
    ["config_reset_confirm"] = "Do you really want to discard the current configuration and reset it to default?",
    ["confirm_delete"] = "Do you want really remove this record?",
    ["cve_changes_detected"] = "CVE Changes Detected",
    ["default_interface"] = "Default Interface",
    ["download_speed"] = "Download Speed",
    ["edit_record"] = "Edit Active Monitoring Record",
    ["empty_action"] = "Something went wrong (empty action). Reload the page and try again.",
    ["host_add_ok"] = "Host %{host} was successfully added!",
    ["host_delete_ok"] = "Host %{host} was successfully deleted!",
    ["host_edit_ok"] = "Host %{host} was successfully edited!",
    ["host_exists"] = "Measurement %{measurement} already defined for %{host}",
    ["host_not_exists"] = "Host \"%{host}\" not found",
    ["http_download"] = "Throughput",
    ["icmp_continuous"] = "Continuous ICMP",
    ["icmp_continuous_v6"] = "Continuous ICMP (IPv6)",
    ["invalid_combination"] = "Invalid measurement/host combination",
    ["invalid_host"] = "Invalid host specified",
    ["jitter"] = "Mean RTT / Jitter",
    ["last_24_hours"] = "Last 24 Hours",
    ["last_measurement"] = "Last Measurement",
    ["measurement"] = "Measurement",
    ["measurement_time"] = "Measurement Time",
    ["msec"] = "ms",
    ["no_updates_yet"] = "No updates yet",
    ["not_alerted"] = "Not Alerted",
    ["note3"] = "ntopng generates traffic towards the configured hosts in order to perform measurements.",
    ["note_alert"] = "An alert is triggered when the calculated measurement exceeds the threshold set.",
    ["note_alert_dashed"] = "The dashed element identifies the current measurement hour.",
    ["note_availability"] = "The availability percentage shows the percentage of time that the measurement has been within the configured threshold in the last day.",
    ["note_periodicity_change"] = "Changing Periodicity causes old timeseries data to be deleted.",
    ["other_http_descr"] = "The sum of \"Name Lookup\" and \"Other\" is the total time took to complete the HTTP request.",
    ["other_https_descr"] = "The sum of \"App Connect\", \"Name Lookup\" and \"Other\" is the total time took to complete the HTTPS request.",
    ["pool"] = "Pool",
    ["ports_changes_detected"] = "Ports Changes Detected",
    ["rtt_vs_jitter"] = "Mean RTT / Jitter",
    ["speedtest"] = "Speedtest",
    ["throughput"] = "Throughput",
    ["upload_speed"] = "Upload Speed",
    ["vulnerability_scan"] = "Vulnerability Scan",
    ["validation"] = {
      ["abort_add"] = "Abort add Active Monitoring record?",
      ["abort_edit"] = "Abort edit Active Monitoring record?",
    },
  },
  ["activities_page"] = {
    ["host_activity"] = "Host Activity",
  },
  ["activity_descriptions"] = {
    ["5min"] = "Executes 5 minutes tasks. When using RRD, also writes hosts timeseries data.",
    ["daily"] = "Executes daily tasks.",
    ["dequeue_flows_for_hooks"] = "A critical activity which identifies idle hash table entries and purges them, executes checks on flows and exports flows.",
    ["discover"] = "Scans the network for devices. If not scan was requested/planned, this activity does nothing.",
    ["hourly"] = "Executes hourly tasks.",
    ["housekeeping"] = "Checks for alerts to store on the disk or to notify, performs n2disk extraction jobs, reloads category lists if needed.",
    ["minute"] = "Executes minute tasks and writes minute timeseries. When using InfluxDB, also writes hosts timeseries data.",
    ["second"] = "Writes the interface timeseries and other high frequency data.",
    ["stats_update"] = "Computes the throughput of the active traffic elements.",
    ["timeseries"] = "Checks for buffered timeseries points and exports them to InfluxDB.",
  },
  ["alert"] = {
    ["alert_error"] = {
      ["configuration"] = {
        ["no_attacker"] = "Attacker requested, but no attacker set.",
        ["no_status_key"] = "Status key required, no status key found.",
        ["no_victim"] = "Victim requested, but no victim set.",
      },
    },
    ["anomalies"] = {
      ["active_flows_as_client"] = "Live Flows Behaviour as Client",
      ["active_flows_as_server"] = "Live Flows Behaviour as Server",
      ["contacts"] = "Contacts Behaviour",
      ["score_as_client"] = "Score Behaviour as Client",
      ["score_as_server"] = "Score Behaviour as Server",
    },
  },
  ["alert_behaviors"] = {
    ["l7_traffic_behavior"] = "Traffic RX + TX",
    ["score_behavior"] = "Score",
    ["traffic_rx_behavior"] = "Traffic RX",
    ["traffic_tx_behavior"] = "Traffic TX",
  },
  ["alert_details"] = {
    ["cannot_be_found_message"] = "This alert cannot be found.",
    ["flow_details"] = "Flow Details",
  },
  ["alert_entities"] = {
    ["am_host"] = "Active Monitoring",
    ["asn"] = "ASN",
    ["domain"] = "Domain",
    ["flow"] = "Flow",
    ["host"] = "Host",
    ["host_pool"] = "Host Pool",
    ["interface"] = "Interface",
    ["l7"] = "L7 Proto",
    ["mac"] = "MAC Address",
    ["mitre"] = "Mitre Attack Matrix",
    ["network"] = "Local Networks",
    ["other"] = "Other",
    ["snmp_device"] = "SNMP",
    ["system"] = "System",
    ["test"] = "Unit Test",
    ["user"] = "User",
  },
  ["alert_messages"] = {
    ["a_new_device_has_connected"] = "New device <a href=\"%{url}\">%{device}</a> has connected to the network.",
    ["alert"] = "Alert",
    ["alert_ids_ips_jail_add"] = "Host %{host} added to the jailed hosts pool on %{when}",
    ["alert_ids_ips_jail_remove"] = "Host %{host} removed from the jailed hosts pool on %{when}",
    ["alert_port_too_many_macs"] = "Too many MACs on non-trunk <a href=\"%{url}\">%{ip}</a> Interface Id <a href=\"%{port_url}\">%{port}</a> [%{value} %{op} %{threshold} MACs]",
    ["anomalous_tcp_flags"] = "%{entity} has %{sent_or_rcvd} too many TCP RST flags vs SYN [Ratio: %{ratio}%%]",
    ["attack_mitigation_via_snmp_failure"] = "Failure to set interface <a href=\"%{port_url}\">%{port}</a> admin status on SNMP device <a href=\"%{url}\">%{device}</a> to %{admin_down}: %{granularity} <b>%{metric}</b> crossed by %{entity} [%{value} %{op} %{threshold}]. Make sure the SNMP device has a (valid) write community configured.",
    ["attack_mitigation_via_snmp_success"] = "Interface <a href=\"%{port_url}\">%{port}</a> admin status on SNMP device <a href=\"%{url}\">%{device}</a> set to %{admin_down}: %{granularity} <b>%{metric}</b> crossed by %{entity} [%{value} %{op} %{threshold}]",
    ["broadcast_domain_info"] = "It is unlikely to see ARP traffic between those IPs as they are seemingly belonging to different broadcast domains. Check for hosts and networks configurations.",
    ["broadcast_domain_too_large"] = "ARP traffic from <a href=\"%{src_mac_url}\">%{src_mac}</a>/<a href=\"%{spa_url}\">%{spa}</a> to <a href=\"%{dst_mac_url}\">%{dst_mac}</a>/<a href=\"%{tpa_url}\">%{tpa}</a> detected.",
    ["contacted_peers"] = "Too many Peers contacted by %{host} %{host_category}. As a client: [%{value_cli} > %{dyn_threshold_cli}]. As a server: [%{value_srv} > %{dyn_threshold_srv}].",
    ["contacted_peers_as_cli"] = "Too many Peers contacted as a client by %{host} %{host_category} [%{value_cli} > %{dyn_threshold_cli}].",
    ["contacted_peers_as_srv"] = "Too many Peers contacted as a server by %{host} %{host_category} [%{value_srv} > %{dyn_threshold_srv}].",
    ["custom_lua_script"] = "%{message}",
    ["device_has_connected"] = "MAC: [ <a href=\"%{device_url}\">%{device}</a> ] connected to the interface <a href=\"%{if_url}\">%{if_name}</a> <a target=\"blank\" href=\"%{exclusion_url}\"><i class=\"fas fa-external-link-alt\"></i></a>",
    ["device_has_disconnected"] = "MAC: [ <a href=\"%{device_url}\">%{device}</a> ] disconnected from the interface <a href=\"%{if_url}\">%{if_name}</a> <a target=\"blank\" href=\"%{exclusion_url}\"><i class=\"fas fa-external-link-alt\"></i></a>",
    ["dns_flood_attacker"] = "%{entity} is a DNS flooder [%{value} &gt; %{threshold} client DNS Flows/sec for ~3 sec]",
    ["dns_flood_victim"] = "%{entity} is under DNS flood attack [%{value} &gt; %{threshold} server DNS Flows/sec for ~3 sec]",
    ["exporters_limit_exceeded"] = "Exceeded maximum number of license-allowed flow exporters or exporters/ports combinations: expect flow drops",
    ["external_script"] = "%{message}",
    ["fin_scan_attacker"] = "%{entity} is a FIN scan attacker [%{value} &gt; %{threshold} FIN sent]",
    ["fin_scan_victim"] = "%{entity} is under a FIN scan [%{value} &gt; %{threshold} FIN received]",
    ["flow_flood_attacker"] = "%{entity} is a flow flooder [%{value} &gt; %{threshold} client flows/sec for ~3 sec]",
    ["flow_flood_victim"] = "%{entity} is under flow flood attack [%{value} &gt; %{threshold} server flows/sec for ~3 sec]",
    ["flow_number_anomaly"] = "%{role} Flows: %{value} [Expected Range: %{lower_bound} ... %{upper_bound}]",
    ["flow_reset"] = "The flow has been reset",
    ["gateway_unreachable"] = "Gateway \"%{name}\" seems to be unreachable.",
    ["host_alert_countries_contacts"] = "Too many countries contacted by %{entity} [%{value} &gt; %{threshold} countries]",
    ["host_alert_dangerous_host"] = "Score limit exceeded by %{entity} [Score: %{score}]",
    ["host_alert_dns_server_contacts"] = "Too many DNS servers contacted by %{entity} [%{value} &gt; %{threshold} servers]",
    ["host_alert_domain_names_contacts"] = "Too many Domain Names contacted [Threshold: %{threshold}][Contacted: %{contacts}]",
    ["host_alert_score"] = "Score exceeded by %{entity} [%{value} %{op} %{threshold}]",
    ["host_alert_server_ports_contacts"] = "%{entity} has been contacted on Port %{value} [Detected Protocol: %{threshold}]",
    ["host_alert_smtp_server_contacts"] = "Too many SMTP servers contacted by %{entity} [%{value} &gt; %{threshold} servers]",
    ["host_entity"] = "host %{entity_value}",
    ["host_log"] = "Log from <a href=\"%{url}\">%{host}</a> (%{facility}) %{line}",
    ["host_pool_has_connected"] = "Host pool <a href=\"%{url}\">%{pool}</a> has connected to the network.",
    ["host_pool_has_disconnected"] = "Host pool <a href=\"%{url}\">%{pool}</a> has disconnected from the network.",
    ["host_remote_to_remote"] = "Remote host <a href=\"%{url}\">%{ip}</a> %{mac} has contacted a remote host. Remote-to-remote flows available from the <a href=\"%{flow_alerts_url}\">flow alerts page</a>.",
    ["http_download_failed"] = "Host %{host} %{numeric_ip} throughput check failed.",
    ["icmp_flood_attacker"] = "%{entity} is an ICMP flooder [%{value} &gt; %{threshold} client ICMP Flows/sec for ~3 sec]",
    ["icmp_flood_victim"] = "%{entity} is under ICMP flood attack [%{value} &gt; %{threshold} server ICMP Flows/sec for ~3 sec]",
    ["iface_alerts_dropped"] = "Interface <a href=\"%{url}\">%{iface}</a> is dropping alerts. Likely it is generating too many of them, or recipients are slow.",
    ["influxdb_dropped_points"] = "Points dropped. Could not send them to \"%{influxdb}\".",
    ["influxdb_migration_msg"] = "You have a lot of local hosts. Please consider <a href='%{url}'>moving from RRD to InfluxDB</a> for timeseries storage to improve performance.",
    ["influxdb_partial_write"] = "This can be fixed by setting \"max-values-per-tag = 0\" in the InfluxDB server config.",
    ["influxdb_write_error"] = "There was an error while sending timeseries data to \"%{influxdb}\": %{err}",
    ["interface_entity"] = "interface %{entity_value}",
    ["ip_outside_dhcp_range_router_ip"] = "[Router: <a href=\"%{router_url}\">%{router_ip}</a>]",
    ["ip_outsite_dhcp_range"] = "Device <a href=\"%{client_url}\">%{client_mac}</a> got the IP address <a href=\"%{client_ip_url}\">%{client_ip}</a> which is outside the <a href=\"%{dhcp_url}\">configured DHCP range</a>. [Sender: <a href=\"%{sender_url}\">%{sender_mac}</a>]",
    ["lldp_arc_added"] = "New link added between SNMP devices <a href=\"%{url1}\">%{node1}</a> and <a href=\"%{url2}\">%{node2}</a>",
    ["lldp_arc_removed"] = "Removed link between between SNMP devices <a href=\"%{url1}\">%{node1}</a> and <a href=\"%{url2}\">%{node2}</a>",
    ["mac_ip_association_change"] = "IP %{ip} changed association from <a href=\"%{old_mac_url}\">%{old_mac}</a> to <a href=\"%{new_mac_url}\">%{new_mac}</a>: MITM (Man In The Middle) attack?",
    ["measurement_too_high_msg"] = "Measurement too high for %{host} %{numeric_ip} [%{am_value} %{unit} > %{threshold} %{unit}].",
    ["measurement_too_low_msg"] = "Measurement too low for %{host} %{numeric_ip} [%{am_value} %{unit} < %{threshold} %{unit}].",
    ["misbehaving_flows_ratio"] = "%{entity} has %{sent_or_rcvd} too many misbehaving flows vs total flows [Ratio: %{ratio}%%]",
    ["nbox"] = "Log from <a href=\"%{url}\">%{host}</a> (%{facility}) %{line}",
    ["nbox_service"] = "%{service} on %{host} (%{ip}) %{reason}",
    ["nbox_service_instance"] = "%{service} %{instance} on %{host} (%{ip}) %{reason}",
    ["network_entity"] = "network %{entity_value}",
    ["network_issues"] = "Detected network issues ",
    ["network_issues_out_of_orders"] = "out of orders: ",
    ["network_issues_packet_loss"] = "packet loss: ",
    ["network_issues_retransmissions"] = "retransmissions: ",
    ["network_score_per_host"] = "Network score above threshold: [%{score} > %{threshold} | Num. Hosts: %{num_hosts}, Score Threshold per Host: %{threshold_per_host}]",
    ["nfq_flushed"] = "Interface <a href=\"%{url}\">%{name}</a> packets queue flushed. Queue %{pct}%% full with %{tot} packets and %{dropped} drops.",
    ["ngi_trust_event"] = "Abnormal activity detected for device <a href=\"%{mac_url}\">%{mac}</a> at %{time}. [Last state: %{last_state}][Unchanged since: %{state_unchanged_since}][Abnormality grade: %{abnormality_grade}]",
    ["ngi_trust_event_released"] = "Device <a href=\"%{mac_url}\">%{mac}</a> state is back to normal at %{time}. [Last state: %{last_state}][Unchanged since: %{state_unchanged_since}][Abnormality grade: %{abnormality_grade}]",
    ["no_clickhouse"] = "ClickHouse not enabled.",
    ["no_influxdb"] = "Please <A HREF=\"%{url}\">enable timeseries dump to InfluxDB</A> and then reload this page",
    ["ntopng_anomalous_termination"] = "Started after anomalous termination (<a href=\"%{url}\">bug report</a>)",
    ["ntopng_died"] = "Died",
    ["ntopng_start"] = "Started",
    ["ntopng_stop"] = "Stopped",
    ["ntopng_update"] = "Started after software update",
    ["open_files_limit_too_small"] = "Ntopng detected that the maximum number of files MySQL can open is potentially too small. This can result in flow data loss due to errors such as [Out of resources when opening file './ntopng/flowsv6#P#p22.MYD' (Errcode: 24 - Too many open files)][23]. Make sure to increase open_files_limit or, if you just want to ignore this warning, disable the check from the preferences.",
    ["periodic_activity_not_executed"] = "Periodic activity \"%{script}\" is queued but has not been executed. No thread available for  execution.  [Pending since %{pending_since}]",
    ["periodicity_update_ended"] = "Periodic flow ended: %{host_info1}  <i class=\"fas fa-exchange-alt fa-lg\" aria-hidden=\"true\" data-original-title=\"\" title=\"\"></i> %{host_info2} [%{l7_proto}] %{info}",
    ["periodicity_update_new"] = "%{host_info1}  <i class=\"fas fa-exchange-alt fa-lg\" aria-hidden=\"true\" data-original-title=\"\" title=\"\"></i> %{host_info2} [%{l7_proto}] %{info} is now periodic (<i class=\"fas fa-wave-square\" title=\"Frequency\"></i> %{frequency} sec)",
    ["ping_host_unreachable_v3"] = "Host %{host} %{numeric_ip} is unreachable.",
    ["potentially_dangerous_protocol_description"] = "This flow can be harmful for the network because an outdated or vulnerable protocol is in use.",
    ["proto_bytes_quotas"] = "%{proto} bytes",
    ["proto_time_quotas"] = "%{proto} time",
    ["remote_to_local_insecure_flow"] = "Remote to Local Insecure Flow",
    ["remote_to_local_insecure_proto"] = "Remote to Local Insecure Protocol",
    ["remote_to_local_insecure_proto_breed_info"] = " [Breed: %{ndpi_breed}]",
    ["remote_to_local_insecure_proto_category_info"] = " [Category: %{ndpi_category}]",
    ["remote_to_remote"] = "Remote %{entity}%{host_category} contacted a remote host",
    ["rst_scan_attacker"] = "%{entity} is a RST scan attacker [%{value} &gt; %{threshold} RST sent]",
    ["rst_scan_victim"] = "%{entity} is under a RST scan [%{value} &gt; %{threshold} RST received]",
    ["rx_scan_detected"] = "%{entity} RX-only under scan detected [Remote Host Contacts: %{as_server}] [Contacted Ports: %{num_server_ports}]",
    ["scan_detected"] = "%{entity} is a scanner [%{value} &gt; %{threshold} scan attempts]",
    ["scanner_contacts"] = "%{entity} scanner contacted %{as_client} RX-only hosts",
    ["score_number_anomaly"] = "%{role} Score: %{score} [Expected Range: %{lower_bound} ... %{upper_bound} <i class='fas fa-question-circle' title='This Behaviour is automatically calculated by ntopng by analyzing the host behavior during time, find more at ntopng guide into `Basic Concept->Alerts->Behaviour Alerts` section'></i>][Cybersecurity Score: %{cat_sec}% | Network Score: %{cat_net}%][Flow Alerts: <a href='%{flow_params}'><i class='fas fa-search-plus fa-lg'></i></a>][Past Host Alerts: <a href='%{host_params_historical}'><i class='fas fa-search-plus fa-lg'></i></a>][Engaged Host Alerts: <a href='%{host_params_engaged}'><i class='fas fa-search-plus fa-lg'></i></a>]",
    ["score_number_anomaly_threshold"] = "%{metric} exceeded by %{entity} [%{value} > %{threshold}]",
    ["score_threshold"] = "Score exceeded by %{entity} as %{cli_or_srv} [%{value} > %{threshold}] %{flows_info}",
    ["shell_script_executed"] = "Shell script '%{script_exec_comm}' executed in response of an alert: '%{alert_type}'",
    ["slow_periodic_activity"] = "Periodic activity \"%{script}\" running for too long [more than %{max_duration}] or executed too late (blocked in queue).",
    ["snmp_flood_attacker"] = "%{entity} is a SNMP flooder [%{value} &gt; %{threshold} client SNMP Flows/sec for ~3 sec]",
    ["snmp_flood_victim"] = "%{entity} is under SNMP flood attack [%{value} &gt; %{threshold} server SNMP Flows/sec for ~3 sec]",
    ["speedtest_failed"] = "Host %{host} %{numeric_ip} speedtest execution failed.",
    ["subject_quota_exceeded"] = "Host pool <a href=\"%{url}\">%{pool}</a> exceeded %{subject} quota [%{value} &gt; %{quota}]",
    ["suspicious_dga_domain_http"] = "Possible risky DGA Domain name detected [url: %{href}]",
    ["suspicious_dga_domain_other"] = "Possible risky DGA Domain name detected [domain: %{href}]",
    ["syn_flood_attacker"] = "%{entity} is a SYN flooder [%{value} &gt; %{threshold} SYN/sec sent for ~3 sec]",
    ["syn_flood_victim"] = "%{entity} is under SYN flood attack [%{value} &gt; %{threshold} SYN/sec received for ~3 sec]",
    ["syn_scan_attacker"] = "%{entity} is a SYN scan attacker [%{value} &gt; %{threshold} SYN sent]",
    ["syn_scan_victim"] = "%{entity} is under a SYN scan [%{value} &gt; %{threshold} SYN received]",
    ["system_error"] = "System error detected in ntopng, please report it. Error message: %{system_error_msg}",
    ["test_failed"] = "Test Failed",
    ["threshold_crossed"] = "%{granularity} <b>%{metric}</b> crossed by %{entity} [%{value} %{op} %{threshold}]",
    ["too_many_drops"] = "%{iface} has too many dropped packets [%{perc_drops}%% &gt %{max_drops}%%]",
    ["too_many_flows"] = "%{iface} has too many flows. Please extend the %{option} command line option.",
    ["too_many_flows_details"] = "Do you want to double the current number of maximum Flows?",
    ["too_many_flows_err"] = "Unable to double max Flows. Please tune -X from the configuration file and restart ntopng.",
    ["too_many_flows_title"] = "Double Max Flows",
    ["too_many_hosts"] = "%{iface} has too many hosts. Please extend the %{option} command line option.",
    ["too_many_hosts_details"] = "Do you want to double the current number of maximum Hosts?",
    ["too_many_hosts_err"] = "Unable to double max Hosts. Please tune -X from the configuration file and restart ntopng.",
    ["too_many_hosts_title"] = "Double Max Hosts",
    ["traffic_flowdev_port_volume_alert"] = "[Flow Exporter Device: <a href=\"%{url}\" target='_blank'>%{host}</a> Interface %{iface}] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_flowdev_volume_alert"] = "[Flow Exporter Device: <a href=\"%{url}\">%{host}</a>] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_host_pool_volume_alert"] = "[Host Pool: <a href=\"%{url}%{host_pool_id}\">%{host_pool_label}</a>] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_interface_volume_alert"] = "[Interface: <a href=\"%{url}\">%{iface}</a>] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_network_volume_alert"] = "[Network: <a href=\"%{url}%{network_id}\">%{network}</a>] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_profile_volume_alert"] = "[Traffic Profile: <a href=\"%{url}%{profile}\">%{profile}</a>] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_vlan_volume_alert"] = "[VLAN: <a href=\"%{url}%{vlan_id}\">%{vlan}</a>] [Metric: %{metric}] [Condition: %{value} %{threshold_sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["traffic_volume_alert"] = "[Metric: %{metric}] [Condition: %{value} %{sign} %{threshold}] [Check Frequency: %{frequency}]",
    ["unknown_contacted_peers"] = "Too many Peers contacted by %{host} %{host_category}.",
    ["vlan_bidirectional_traffic"] = "Detected bidirectional traffic flow on VLAN %{vlan} [RX : %{rx} > 0 & TX : %{tx}]",
    ["x_alerts"] = "%{num} alerts",
  },
  ["alerts_analysis_page"] = {
    ["flow_dst_alertid_density"] = "AlertType: Server",
    ["flow_dst_score_count_density"] = "Score: Server",
    ["flow_src_alertid_density"] = "AlertType: Client",
    ["flow_src_dst_alertid_density"] = "AlertType: Client/Server",
    ["flow_src_dst_score_count_density"] = "Score: Client/Server",
    ["flow_src_score_count_density"] = "Score: Client",
    ["labels"] = {
      ["f_count"] = "Alerts Count",
      ["f_score"] = "Total Score",
      ["f_type"] = "Alert Type",
    },
  },
  ["alerts_dashboard"] = {
    ["active_flows_anomaly"] = "Live Flows Anomaly",
    ["add_filter"] = "Add Filter",
    ["alert"] = "Alert",
    ["alert_counts"] = "Counts",
    ["alert_custom_lua_script"] = "Custom Script",
    ["alert_duration"] = "Duration",
    ["alert_external_script"] = "External Script",
    ["alert_ids_ips_jail_add"] = "Jailed Host Added",
    ["alert_ids_ips_jail_remove"] = "Jailed Host Removed",
    ["alert_periodicity_update"] = "Periodicity Changed",
    ["alert_port_too_many_macs_title"] = "Many MACs on Non-Trunk",
    ["alert_severity"] = "Severity",
    ["alert_snmp_device_polling_error_description"] = "Polling <a href=\"%{url}\">%{device}</a> failed: %{reason}",
    ["alert_snmp_device_polling_error_title"] = "SNMP Polling Error",
    ["alert_snmp_device_reset_description"] = "SNMP device <a href=\"%{url}\">%{device}</a> has been restarted",
    ["alert_snmp_device_reset_title"] = "SNMP Device Restart",
    ["alert_snmp_interface_mac_appeared_description"] = "A new MAC <a href=\"%{mac_url}\">%{mac}</a> has been detected on SNMP device <a href=\"%{url}\">%{device}</a> interface <a href=\"%{port_url}\">%{port_name} (%{port})</a>",
    ["alert_snmp_interface_mac_appeared_title"] = "MAC Appeared",
    ["alert_snmp_interface_mac_changed_description"] = "MAC <a href=\"%{mac_url}\">%{mac}</a> seen on SNMP device <a href=\"%{url}\">%{device}</a> interface <a href=\"%{port_url}\">%{port_name} (%{port})</a> previously seen on SNMP device <a href=\"%{prev_device_url}\">%{prev_device}</a> interface <a href=\"%{prev_port_url}\">%{prev_port_name} (%{prev_port})</a>",
    ["alert_snmp_interface_mac_changed_title"] = "MAC Port Changed",
    ["alert_snmp_interface_mac_disappeared_description"] = "MAC <a href=\"%{mac_url}\">%{mac}</a> has disappeared from SNMP device <a href=\"%{url}\">%{device}</a> interface <a href=\"%{port_url}\">%{port_name} (%{port})</a>",
    ["alert_snmp_interface_mac_disappeared_title"] = "MAC Disappeared",
    ["alert_snmp_traffic_change_detected"] = "Traffic Change Detected",
    ["alert_snmp_traffic_change_detected_description"] = "Trigger an alert when an SNMP device stops or starts sending/receiving traffic",
    ["alert_snmp_traffic_change_detected_message_down"] = "No more traffic detected on interface <a href=\"%{port_url}\" title=\"%{port_index}\">%{port}</a>, SNMP device <a href=\"%{url}\" title=\"%{device}\">%{device_name}</a> <a href=\"%{http_prefix}/lua/pro/enterprise/snmp_interface_details.lua?host=%{device}&snmp_port_idx=%{port_index}&page=historical\"><i class=\"fas fa-lg fa-chart-area\"></i></a>",
    ["alert_snmp_traffic_change_detected_message_up"] = "Traffic detected on interface <a href=\"%{port_url}\" title=\"%{port_index}\">%{port}</a>, SNMP device <a href=\"%{url}\" title=\"%{device}\">%{device_name}</a> <a href=\"%{http_prefix}/lua/pro/enterprise/snmp_interface_details.lua?host=%{device}&snmp_port_idx=%{port_index}&page=historical\"><i class=\"fas fa-lg fa-chart-area\"></i></a>",
    ["alert_snmp_trap_title"] = "SNMP Trap",
    ["alert_traffic_volume"] = "Threshold Crossed",
    ["alert_type"] = "Type",
    ["alert_unexpected_behavior_description"] = "Trigger an alert when an unexpected behavior is identified from the specified %{type}/s. <b>Restart is required</b> after enabling/disabling the alert.",
    ["alert_unexpected_score_behavior_description"] = "Trigger an alert when an unexpected score is identified.",
    ["alert_unexpected_score_behavior_title"] = "Unexpected Score Behavior",
    ["alert_unexpected_traffic_behavior_description"] = "Trigger an alert when an unexpected amount of traffic is identified.",
    ["alert_unexpected_traffic_behavior_title"] = "Unexpected Traffic Behavior",
    ["alerts"] = " Alerts Explorer",
    ["alerts_dashboard"] = "Alerts Dashboard",
    ["alerts_ts"] = "Process Alerts Timeseries",
    ["alerts_ts_description"] = "Generate process alerts timeseries",
    ["all_hosts"] = "All Hosts",
    ["anomalous_tcp_flags"] = "Anomalous TCP Flags",
    ["attack_mitigation_snmp_description"] = "Set host SNMP access port admin status to down when the client score exceeds the specified threshold",
    ["attack_mitigation_snmp_title"] = "Attack Mitigation via SNMP",
    ["binary_application_transfer"] = "Binary App Transfer",
    ["binary_application_transfer_url"] = "%{type_icon} File Transfered: %{href}",
    ["blacklisted_country"] = "Blacklisted Country",
    ["blacklisted_country_descr"] = "Trigger an alert when hosts contact or are contacted by the specified countries",
    ["blacklisted_flow"] = "Blacklisted Flow",
    ["blocked_flow"] = "Flow Risk",
    ["broadcast_domain_too_large"] = "Broadcast domain",
    ["checks_calls_drops"] = "Checks Calls Dropped",
    ["clickhouse_monitor"] = "ClickHouse monitor",
    ["clickhouse_monitor_description"] = "Monitor the ClickHouse health",
    ["client_and_server_countries_blacklisted"] = "Client country %{cli_country} and server country %{srv_country} are blacklisted",
    ["client_country_blacklisted"] = "Client country %{country} is blacklisted",
    ["client_ports"] = "Client Ports",
    ["connection_issues"] = "TCP Issues",
    ["contacted_peers_description"] = "Trigger an alert when an host contacts an unexpected number of clients or servers",
    ["contacted_peers_title"] = "Contacted Peers Alert",
    ["critical"] = "Critical",
    ["custom_lua_script"] = "Custom Script",
    ["custom_period"] = "Custom Period",
    ["dangerous_host_description"] = "Triggers an alert and adds the host to the jailed hosts pool for 30 minutes, when the configured score threshold is crossed for more than 5 consecutive minutes. Hosts in the jailed hosts pool are prevented from generating traffic when using nProbe in IPS mode.",
    ["dangerous_host_title"] = "Dangerous Host",
    ["debug"] = "Debug",
    ["device_connection_disconnection"] = "Unexpected MAC Conn./Disc.",
    ["dhcp_storm"] = "DHCP Storm",
    ["dhcp_storm_description"] = "Trigger an alert when a DHCP Storm attack is detected",
    ["dhcp_storm_detected_description"] = "DHCP Storm attack detected at %{epoch} [DHCP Packets: %{dhcp_num_pkts}]",
    ["dns_anomaly"] = "DNS Anomaly",
    ["dns_flood"] = "DNS Flood",
    ["element"] = "Element",
    ["emergency"] = "Emergency",
    ["engaged_for_longest"] = "Past Alerts Engaged for Longest",
    ["error"] = "Error",
    ["experimental_checks"] = "Experimental",
    ["experimental_checks_description"] = "Enable experimental alert checks: TCP flags, anomalous flows ratio",
    ["external_alert"] = "External Alert",
    ["external_script"] = "External Script",
    ["fail2ban"] = "Fail2Ban command executed",
    ["five_mins"] = "Last 5 Minutes",
    ["flow_alert_origins"] = "Flow Alert Origins",
    ["flow_alert_targets"] = "Flow Alert Targets",
    ["flow_anomaly"] = "Flow Anomaly",
    ["flow_checks_calls_drops_description"] = "%{num_drops} <a href='%{url}'>flow checks</a> calls were not invoked. Some misbehaving flows may go unnoticed.",
    ["flow_flood"] = "Flows Flood",
    ["flow_flood_attacker"] = "Flows Flood Attacker",
    ["flow_flood_victim"] = "Flows Flood Victim",
    ["flow_logger"] = "Flow Logger",
    ["flow_logger_descr"] = "Logs new flows to console/file",
    ["flow_low_goodput"] = "Low Goodput Ratio",
    ["flow_misbehaviour"] = "Flow Misbehaviour",
    ["flow_related_info"] = "Flow Related Info",
    ["flow_related_info_composed"] = "%{proto} Related Info",
    ["flow_reset"] = "Flow Reset",
    ["flow_risk"] = "Flow Risk",
    ["gateway_unreachable"] = "Gateway Unreachable",
    ["gateway_unreachable_descr"] = "Trigger an alert when the system is no longer able to reach a gateway.",
    ["ghost_network_detected"] = "Ghost Network Detected",
    ["ghost_network_detected_description"] = "Subnet %{network} does not belong to the <a href='%{url}'>%{entity} networks</a>.",
    ["ghost_networks"] = "Ghost Networks",
    ["ghost_networks_description"] = "Trigger an alert for unknown networks detected on the network interface.",
    ["host_alert_countries_contacts"] = "Countries Contacts",
    ["host_alert_dns_server_contacts"] = "DNS Server Contacts",
    ["host_alert_dns_traffic"] = "DNS Traffic",
    ["host_alert_domain_names_contacts"] = "Trigger an alert when the number of contacted Domain Names exceed a certain threshold",
    ["host_alert_ntp_server_contacts"] = "NTP Server Contacts",
    ["host_alert_ntp_traffic"] = "NTP Traffic",
    ["host_alert_p2p_traffic"] = "P2P Traffic",
    ["host_alert_server_ports_contacts"] = "Server Port Detected",
    ["host_alert_smtp_server_contacts"] = "SMTP Server Contacts",
    ["host_log"] = "Host Log",
    ["host_pool_connection"] = "Host Pool Connection",
    ["host_pool_disconnection"] = "Host Pool Disconnection",
    ["host_score_description"] = "Compute host score and trigger alerts when it exceeds the specified threshold.",
    ["http_rcvd_sent_ratio"] = "[HTTP Rcvd Repls. / Sent Reqs. %{ratio}%% &lt; %{threshold}%%][Repls: %{replies}][Reqs: %{requests}]",
    ["http_sent_rcvd_ratio"] = "[HTTP Sent Repls. / Rcvd Reqs. %{ratio}%% &lt; %{threshold}%%][Repls: %{replies}][Reqs: %{requests}]",
    ["icmp_anomaly"] = "ICMP Anomaly",
    ["icmp_flood"] = "ICMP Flood",
    ["iec_invalid_command_transition"] = "IEC104 Invalid Command Transition",
    ["iec_invalid_transition"] = "IEC104 Invalid Transition",
    ["iec_unexpected_type_id"] = "IEC104 Unexpected TypeId",
    ["inactivity"] = "Inactivity",
    ["influxdb_dropped_points"] = "InfluxDB Dropped Points",
    ["influxdb_error"] = "InfluxDB Error",
    ["influxdb_export_failure"] = "InfluxDB Export Failure",
    ["influxdb_monitor"] = "InfluxDB monitor",
    ["influxdb_monitor_description"] = "Monitor the InfluxDB health",
    ["info"] = "Info",
    ["interface_periodic_activity_not_executed"] = "Interface Periodic Activity Not Executed",
    ["interface_periodic_activity_not_executed_descr"] = "Trigger an alert when an interface periodic activity is queued for execution but is not getting executed as all the worker threads are busy",
    ["interface_slow_periodic_activity"] = "Interface Slow Periodic Activity",
    ["interface_slow_periodic_activity_descr"] = "Trigger an alert when an interface periodic activity is taking too long to execute.",
    ["internal_issues"] = "Internal Issues",
    ["involving_msg"] = "Flow Alerts Involving",
    ["known_proto_on_non_std_port"] = "Known Proto on Non Std Port",
    ["known_proto_on_non_std_port_full"] = "Known application %{app} detected on non-standard port %{port}",
    ["last_12_hours"] = "Last 12 Hours",
    ["last_2_hours"] = "Last 2 Hours",
    ["last_5_minutes"] = "Last 5 Minutes",
    ["last_6_hours"] = "Last 6 Hours",
    ["last_day"] = "Last Day",
    ["last_hour"] = "Last Hour",
    ["last_minute"] = "Last Minute",
    ["last_month"] = "Last Month",
    ["last_week"] = "Last Week",
    ["last_year"] = "Last Year",
    ["lateral_movement"] = "Lateral Movement on Service Map",
    ["lateral_movement_descr"] = "Service map denied service detected %{info} %{href}",
    ["list_download_failed"] = "List Download Failed",
    ["list_download_succeeded"] = "List Download Succeeded",
    ["local_host_blacklisted"] = "Local Host Blacklisted",
    ["local_only"] = "Local Hosts",
    ["local_origin_remote_target"] = "Local Origin - Remote Target",
    ["login_failed"] = "Login Failed",
    ["mac_ip_association_change"] = "IP/MAC Reassoc/Spoofing",
    ["mac_ip_association_change_descr"] = "Trigger an alert when an IP address, previously seen with a MAC address, is now seen with another MAC address. This alert might indicate an ARP spoof attempt. Only works for the builtin alert recipient.",
    ["malicious_signature_detected"] = "Malicious signature detected [Client JA3 Hash: %{ja3_hash}]",
    ["many_replies"] = "%{count} %{what} replies",
    ["many_requests"] = "%{count} %{what} requests",
    ["memory_ts"] = "Memory Timeseries",
    ["memory_ts_description"] = "Generate process memory timeseries",
    ["misbehaving_flows_ratio"] = "Too Many Misbehaving Flows",
    ["misconfigured_app"] = "Misconfigured App",
    ["misconfigured_dhcp_range"] = "Misconfigured DHCP Range",
    ["nbox"] = "nBox",
    ["ndpi_dns_suspicious_traffic_descr"] = "Detected unexpected/obsolete record type",
    ["ndpi_dns_suspicious_traffic_title"] = "Susp. DNS Traffic",
    ["ndpi_http_invalid_content_title"] = "Invalid HTTP content",
    ["ndpi_http_numeric_ip_host_title"] = "HTTP/TLS/QUIC Numeric Hostname/SNI",
    ["ndpi_http_suspicious_header_title"] = "HTTP Susp. Header",
    ["ndpi_http_suspicious_url_descr"] = "Access to suspicious URL",
    ["ndpi_http_suspicious_url_title"] = "HTTP Susp. URL",
    ["ndpi_http_suspicious_user_agent_title"] = "HTTP Susp. User-Agent",
    ["ndpi_malformed_packet_title"] = "Malformed Packet",
    ["ndpi_malicious_ja3_title"] = "Possibly Malicious JA3",
    ["ndpi_malicious_sha1"] = "Malicious SHA1 Cert",
    ["ndpi_risky_asn_title"] = "Risky ASN",
    ["ndpi_risky_domain_title"] = "Risky Domain",
    ["ndpi_smb_insecure_version_title"] = "Insecure SMB Version",
    ["ndpi_ssh_obsolete_client_title"] = "SSH Obsolete Cli Vers/Cipher",
    ["ndpi_ssh_obsolete_server_title"] = "SSH Obsolete Ser Vers/Cipher",
    ["ndpi_suspicious_dga_domain_title"] = "Susp. DGA Domain",
    ["ndpi_tls_cert_validity_too_long_title"] = "Too Long TLS Cert Validity",
    ["ndpi_tls_certificate_expired_title"] = "TLS Cert Expired",
    ["ndpi_tls_certificate_mismatch_title"] = "TLS Cert Mismatch",
    ["ndpi_tls_missing_sni_title"] = "Missing SNI TLS Extn",
    ["ndpi_tls_not_carrying_https_title"] = "TLS not carrying HTTPS",
    ["ndpi_tls_obsolete_version_title"] = "Obsolete TLS Version",
    ["ndpi_tls_selfsigned_certificate_title"] = "Self-signed Cert",
    ["ndpi_tls_suspicious_esni_usage_title"] = "Susp. TLS ESNI Usage",
    ["ndpi_tls_weak_cipher_title"] = "Weak TLS Cipher",
    ["ndpi_unsafe_protocol_title"] = "Unsafe Protocol",
    ["ndpi_url_possible_rce_injection_title"] = "Possible RCE",
    ["ndpi_url_possible_sql_injection_descr"] = "Requested URL: %{url}",
    ["ndpi_url_possible_sql_injection_descr_generic"] = "Possible SQL Injection in the url requested",
    ["ndpi_url_possible_sql_injection_title"] = "Possible SQL Inj",
    ["ndpi_url_possible_xss_title"] = "Possible XSS",
    ["network_issues"] = "Network issues",
    ["new_device"] = "New Device",
    ["nfq_flushed"] = "Packets Queue Flushed",
    ["ngi_trust_event"] = "NGI Trust Event",
    ["no_alert"] = "No Alert",
    ["no_alerts"] = "No alerts",
    ["none"] = "None",
    ["not_engaged"] = "Not engaged",
    ["notice"] = "Notice",
    ["one_day"] = "Last Day",
    ["one_hour"] = "Last Hour",
    ["one_min"] = "Last Minute",
    ["one_reply"] = "%{count} %{what} reply",
    ["one_request"] = "%{count} %{what} request",
    ["out_of_x_total_packets"] = "out of %{tot} Packets",
    ["periodic_activity_not_executed"] = "Periodic Activity Not Executed",
    ["periodic_activity_not_executed_descr"] = "Trigger an alert when a periodic activity is queued for execution but is not getting executed as all the worker threads are busy.",
    ["periodicity_changed"] = "Periodicity",
    ["periodicity_changed_descr"] = "Periodicity changed %{info} %{href}",
    ["periodicity_is_aperiodic_descr"] = "Service no longer periodic %{info} %{href}",
    ["periodicity_is_periodic_descr"] = "Periodic service %{info} %{href}",
    ["ping_issues"] = "Ping",
    ["possible_bot_flow_description"] = "Possible Flow with a Bot as a server",
    ["possible_bot_flow_title"] = "Possible Bot",
    ["potentially_dangerous_protocol"] = "Potentially Dangerous Protocol",
    ["process"] = "Process",
    ["quota_exceeded"] = "Quota Exceeded",
    ["quota_exceeded_descr"] = "Trigger an alert when a configured quota has been exceeded.",
    ["rare_destination"] = "Rare Destination",
    ["rare_destination_description"] = "Rare Destination '%{destination}' detected",
    ["remote_access_alert_descr"] = "Remote access ended [duration: %{time}]",
    ["remote_access_description"] = "Trigger an alert when a Remote Access Session is ended",
    ["remote_access_title"] = "Remote Access",
    ["remote_connection_alert_descr"] = "Host %{host} has %{connections} active flows using a remote access protocol",
    ["remote_connection_description"] = "Trigger an alert whenever an host has at least one active flow using a remote access protocol",
    ["remote_connection_title"] = "Remote Connection",
    ["remote_only"] = "Remote Hosts",
    ["remote_origin_local_target"] = "Remote Origin - Local Target",
    ["remote_to_local_insecure_proto"] = "Remote to Local Insecure Protocol",
    ["remote_to_remote"] = "Remote to Remote",
    ["scan_detected"] = "Scan Detected",
    ["scanner_contacts"] = "Host Scanner Detected",
    ["score_anomaly"] = "Score Anomaly",
    ["score_threshold_cross"] = "Score Threshold Cross",
    ["search_criteria"] = "Dashboard Settings",
    ["server_country_blacklisted"] = "Server country %{country} is blacklisted",
    ["shell_script"] = "Endpoint Shell Script Executed",
    ["sites_behaviour_description"] = "Triggers an alert when an host contacts an unexpected number of hosts",
    ["slow_periodic_activity"] = "Slow Periodic Activity",
    ["slow_periodic_activity_descr"] = "Trigger an alert when a periodic activity is taking too long to execute.",
    ["slow_purge"] = "Slow Idle Purging",
    ["snmp_device_interface_threshold_crossed"] = "Threshold Crossed",
    ["snmp_device_interface_threshold_crossed_alert_description"] = "Metric: %{metric} / Unit: %{measure_unit} / Value: %{value} / Threshold: %{threshold_sign} %{threshold}",
    ["snmp_device_interface_threshold_crossed_alert_description_percentile"] = "Traffic: %{value} %{threshold_sign} %{threshold} of the line capacity",
    ["snmp_device_interface_threshold_crossed_description"] = "Trigger an alert when one of the thresholds configured in the SNMP Device Rules page is crossed.",
    ["snmp_device_is_unresponsive"] = "SNMP device <a href=\"%{url}\">%{device}</a> is unresponsive",
    ["snmp_device_reset_script_description"] = "Trigger an alert when a restart for an SNMP device has been detected",
    ["snmp_flood"] = "SNMP Flood",
    ["snmp_interface_errors"] = "SNMP High Error Counter",
    ["snmp_interface_errors_descr"] = "Trigger an alert when an SNMP interface error counters exceed 5% of total traffic",
    ["snmp_interface_errors_description"] = "Error counters exceed 5% of total traffic, on interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a>",
    ["snmp_interface_errors_threshold"] = "Interface Errors Exceeded",
    ["snmp_interface_errors_threshold_descr"] = "Trigger an alert when an SNMP interface errors counter exceed 5% of packets",
    ["snmp_interface_errors_title"] = "High Interface Errors",
    ["snmp_interface_mac_changed_script_description"] = "Trigger an alert when a MAC has moved between interfaces or devices (SNMP)",
    ["snmp_interface_mac_changed_script_title"] = "MAC Port Changed (SNMP)",
    ["snmp_interface_mac_detection_script_description"] = "Trigger an alert when a MAC appears/disappears from a device (SNMP)",
    ["snmp_interface_mac_detection_script_title"] = "MAC Detection (SNMP)",
    ["snmp_interfaces_rsi"] = "SNMP Interfaces RSI",
    ["snmp_interfaces_rsi_descr"] = "Detect changes in the interfaces traffic and trigger alerts (experimental)",
    ["snmp_port_avg_perc_usage_threshold_crossed"] = "Interface Avg Usage Threshold Exceeded",
    ["snmp_port_avg_perc_usage_threshold_crossed_message"] = "Avg usage threshold exceeded on interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> [threshold: %{threshold} %%][Avg IN Usage: %{avg_in_perc}][Avg OUT Usage: %{avg_out_perc}]",
    ["snmp_port_changed_duplex_status"] = "Interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> changed its duplex status to %{new_op}",
    ["snmp_port_changed_operational_status"] = "Interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> changed its status to %{new_op}",
    ["snmp_port_duplexstatus_change"] = "Duplex Status Change",
    ["snmp_port_duplexstatus_change_description"] = "Trigger an alert when an interface duplex status changes",
    ["snmp_port_errors"] = "High Interface Discards/Errors",
    ["snmp_port_errors_description"] = "Trigger an alert when an SNMP interface discard/error counters increase",
    ["snmp_port_errors_increased"] = "Discard/error counters increased on interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a>",
    ["snmp_port_load_threshold_exceeded"] = "Interface Load Threshold Exceeded",
    ["snmp_port_load_threshold_exceeded_message"] = "Load threshold exceeded on interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> [threshold: %{threshold}%%][IN load: %{in_load}%%][OUT load: %{out_load}%%]",
    ["snmp_port_status_change"] = "Oper. Status Change",
    ["snmp_port_status_change_description"] = "Trigger an alert when the operational state of an interface changes",
    ["starting_on"] = "starting on",
    ["submit"] = "Update Dashboard",
    ["suspicious_activity"] = "Susp. Activity",
    ["suspicious_device_protocol"] = "Susp. Device Protocol",
    ["tcp_fin_scan"] = "TCP FIN Scan",
    ["tcp_fin_scan_attacker"] = "TCP FIN Scan Attacker",
    ["tcp_fin_scan_victim"] = "TCP FIN Scan Victim",
    ["tcp_rst_scan"] = "TCP RST Scan",
    ["tcp_rst_scan_attacker"] = "TCP RST Scan Attacker",
    ["tcp_rst_scan_victim"] = "TCP RST Scan Victim",
    ["tcp_syn_flood"] = "TCP SYN Flood",
    ["tcp_syn_flood_attacker"] = "TCP SYN Flood Attacker",
    ["tcp_syn_flood_victim"] = "TCP SYN Flood Victim",
    ["tcp_syn_scan"] = "TCP SYN Scan",
    ["tcp_syn_scan_attacker"] = "TCP SYN Scan Attacker",
    ["tcp_syn_scan_victim"] = "TCP SYN Scan Victim",
    ["threashold_cross"] = "Threshold Cross",
    ["tls_old_protocol_version"] = "Obsolete TLS [Version: %{version}]",
    ["tls_protocol_version"] = "TLS Version: %{version}",
    ["too_many_drops"] = "Packet Drops",
    ["too_many_flows"] = "Too Many Flows Alert",
    ["too_many_flows_description"] = "Trigger an alert when the number of active flows is too high",
    ["too_many_hosts"] = "Too Many Hosts Alert",
    ["too_many_hosts_description"] = "Trigger an alert when the number of active hosts is too high",
    ["top_addresses"] = "Top Mac Addresses",
    ["top_alerts"] = "Top Alerts",
    ["top_alerts_by_count"] = "Top Alerts By Count",
    ["top_alerts_by_severity"] = "Top Alerts By Severity",
    ["top_cli"] = "Top Clients",
    ["top_cli_networks"] = "Top Client Networks",
    ["top_dga_domain"] = "Top DGA Domains",
    ["top_hosts"] = "Top Hosts",
    ["top_l7proto"] = "Top Applications",
    ["top_networks"] = "Top Networks",
    ["top_srv"] = "Top Servers",
    ["top_srv_networks"] = "Top Server Networks",
    ["top_vlan"] = "Top VLANs",
    ["total_alerts"] = "Total Alerts",
    ["trailing_msg"] = "Time Window",
    ["trailing_msg_compact"] = "Window",
    ["unexpected_behavior_anomaly_description"] = "%{entity} [%{type_of_behavior}: %{value} | Expected Range: %{lower_bound} ... %{upper_bound}]",
    ["unexpected_host_behavior_description"] = "%{host} [%{type_of_behaviour}][Value: %{value}][Expected Range: %{lower_bound} ... %{upper_bound}]",
    ["unexpected_host_behaviour_act_flows_title"] = "Unexpected Host Live Flows Behaviour",
    ["unexpected_host_behaviour_contacts_title"] = "Unexpected Host Contacts Behaviour",
    ["unexpected_host_behaviour_score_title"] = "Unexpected Host Score Behaviour",
    ["unresponsive_device"] = "Unresponsive Device",
    ["user_activity"] = "User Activity",
    ["vlan_bidirectional_traffic"] = "VLAN Bidirectional Traffic",
    ["vulnerability_scan_description"] = "Trigger an alert when a Vulnerability Scan is executed and the new scan reports different vulnerabilities (meaning that some could be solved and new ones could be there).",
    ["vulnerability_scan_title"] = "Vulnerability Scan",
    ["warning"] = "Warning",
    ["web_mining"] = "Web Mining",
    ["x_lost"] = "%{lost} Lost",
    ["x_ooo"] = "%{ooo} Out-of-Order",
    ["x_retx"] = "%{retx} Retransmissions",
    ["tooltips"] = {
      ["top_addresses"] = "Mac Addresses with most alerts",
      ["top_alerts"] = "Most seen alerts",
      ["top_alerts_by_severity"] = "Alerts with higher severity",
      ["top_cli"] = "Hosts as client with most alerts",
      ["top_dga_domain"] = "DGA Domains with most alerts",
      ["top_hosts"] = "Hosts with most alerts",
      ["top_l7proto"] = "Applications with most alerts",
      ["top_mitre_id"] = "Mitre Attacks with most alerts",
      ["top_mitre_subtechnique"] = "Mitre Sub-Techniques with most alerts",
      ["top_mitre_tactic"] = "Mitre Tactics with most alerts",
      ["top_mitre_technique"] = "Mitre Techniques with most alerts",
      ["top_networks"] = "Networks with most alerts",
      ["top_srv"] = "Hosts as server with most alerts",
      ["top_vlan"] = "VLANs with most alerts",
    },
  },
  ["alerts_thresholds_config"] = {
    ["active_local_hosts"] = "Local Hosts Alert",
    ["active_local_hosts_threshold_descr"] = "Trigger an alert when the number of Active Local Hosts exceeds the threshold",
    ["activity_time"] = "Activity Time Alert",
    ["alert_active_description"] = "Trigger an alert when the Activity time delta exceeds the threshold",
    ["alert_bytes_description"] = "Trigger an alert when the Layer 2 bytes delta (sent + received) exceeds the threshold",
    ["alert_bytes_title"] = "Traffic Alert",
    ["alert_dns_description"] = "Trigger an alert when layer 2 Bytes delta (sent + received) for DNS traffic exceeds the threshold",
    ["alert_flows_description"] = "Trigger an alert when the Flows delta (as client + as server) exceeds the threshold",
    ["alert_flows_title"] = "Flows Alert",
    ["alert_idle_description"] = "Trigger an alert when the Idle time (time since last packet seen) exceeds the threshold",
    ["alert_network_egress_description"] = "Trigger an alert when the Egress Bytes delta exceeds the threshold",
    ["alert_network_ingress_description"] = "Trigger an alert when the Ingress Bytes delta exceeds the threshold",
    ["alert_network_inner_description"] = "Trigger an alert when the Inner Bytes delta exceeds the threshold",
    ["alert_ntp_description"] = "Trigger an alert when the Layer 2 bytes delta (sent + received) for NTP traffic exceeds the threshold",
    ["alert_p2p_description"] = "Trigger an alert when the Layer 2 bytes delta (sent + received) for P2P traffic exceeds the threshold",
    ["alert_packets_description"] = "Trigger an alert when the Packets delta (sent + received) exceeds the threshold",
    ["alert_packets_title"] = "Packets Exceeded",
    ["alert_pkt_description"] = "Trigger an alert when the packet delta (sent + received) exceeds the threshold",
    ["alert_pkt_title"] = "Packets Exceeded",
    ["alert_throughput_description"] = "Trigger an alert when the Average throughput (sent + received) exceeds the percentage configured (Interface Max Speed percentage)",
    ["common_thresholds_local_sources"] = "%{source} Common Configuration",
    ["countries_contacts_description"] = "Trigger an alert when the number of different countries contacted exceeds the threshold",
    ["countries_contacts_title"] = "Countries Contacts Alert",
    ["custom_host_lua_script_description"] = "Trigger a host alert based on a custom Lua user script",
    ["custom_host_lua_script_title"] = "Host User Check Script",
    ["daily"] = "Daily",
    ["dns_contacts_description"] = "Trigger an alert when the number of different DNS servers contacted exceeds the threshold",
    ["dns_contacts_title"] = "DNS Server Contacts",
    ["dns_traffic"] = "DNS Traffic",
    ["domain_names_contacts_description"] = "Trigger an alert when the number of contacted Domain Names is greater then a certain threshold",
    ["domain_names_contacts_title"] = "Domain Names Contacts",
    ["egress_traffic"] = "Egress Traffic",
    ["every_5_minutes"] = "Every 5 Minutes",
    ["every_minute"] = "Every Minute",
    ["external_host_script_description"] = "Trigger a host alert from an external script via REST API",
    ["external_host_script_title"] = "Host External Check (REST)",
    ["flows_anomaly_description"] = "Detects anomalies in active flows number",
    ["flows_anomaly_title"] = "Flows Anomaly",
    ["host_alert_pkt_threshold"] = "Pkt Threshold",
    ["host_mac_reassociation_description"] = "Detects IP/MAC reassociations often used in spoofing attacks.",
    ["host_mac_reassociation_title"] = "MAC Reassociation",
    ["hourly"] = "Hourly",
    ["idle_time"] = "Idle Time Alert",
    ["ingress_traffic"] = "Ingress Traffic",
    ["inner_traffic"] = "Inner Traffic",
    ["manual"] = "Manual",
    ["note_add_custom_scripts"] = "%{product} looks for custom scripts in these <a href=\"%{url}\"> <i class=\"fas fa-folder\"></i> directories</a>.",
    ["note_checks_on_active_hosts"] = "Checks are only performed for active hosts.",
    ["note_consecutive_checks"] = "Consecutive checks are not necessarily performed on consecutive periods. For example, if an host goes idle, its thresholds will not be checked until it becomes active again.",
    ["note_control_threshold_checks_periods"] = "Callbacks listed in these tabs are executed periodically.",
    ["note_create_custom_scripts"] = "Documentation to create custom scripts for the execution of callbacks is available at the following <a class='ntopng-external-link' href=\"%{url}\">link <i class=\"fas fa-external-link-alt\"></i></a>.",
    ["note_thresholds_expressed_as_delta"] = "Some callbacks compute a delta. A delta is the difference of the same quantity between two consecutive executions.",
    ["notes"] = "NOTES",
    ["ntp_contacts_description"] = "Trigger an alert when the number of different NTP servers contacted exceeds the threshold",
    ["ntp_contacts_title"] = "NTP Server Contacts",
    ["ntp_traffic"] = "NTP Traffic",
    ["p2p_traffic"] = "P2P Traffic",
    ["score_anomaly_description"] = "Detects anomalies in host score",
    ["score_anomaly_title"] = "Score Anomaly",
    ["score_threshold_description"] = "Trigger an alert when the score of an host exceeds the threshold",
    ["score_threshold_title"] = "Score Threshold Exceeded",
    ["server_ports_contacts_description"] = "Trigger an alert when a new server port has been detected after the learning period",
    ["smtp_contacts_description"] = "Trigger an alert when the number of different SMTP servers contacted exceeds the threshold",
    ["smtp_contacts_title"] = "SMTP Server Contacts",
    ["threshold_type"] = "Callback",
    ["thresholds_single_source"] = "%{source} %{alt_name} Configuration",
    ["throughput"] = "Throughput Exceeded",
  },
  ["appliance"] = {
    ["capture_interfaces"] = "Capture Interfaces",
    ["enable_wifi"] = "Enable Wi-Fi",
    ["enable_wifi_descr"] = "Enable or disable the Wi-Fi interface.",
    ["management"] = "Management Interface",
    ["ssid"] = "SSID",
    ["ssid_descr"] = "Wi-Fi name (Service Set IDentifier).",
    ["wpa_passphrase"] = "Passphrase",
    ["wpa_passphrase_descr"] = "WPA passphrase (min 8 characters and less than 64).",
  },
  ["arp_page"] = {
    ["arp_type"] = "ARP Type",
  },
  ["as_details"] = {
    ["as"] = "Autonomous System",
    ["as_parameter_missing_message"] = "Autonomous System parameter is missing (internal error?)",
    ["as_timeseries_enable_message"] = "AS timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
    ["no_available_data_for_as"] = "No available data for AS %{asn}.",
  },
  ["as_stats"] = {
    ["autonomous_systems"] = "Autonomous Systems",
  },
  ["assets_page"] = {
    ["address"] = "IP Address",
    ["hostname"] = "Server Name",
    ["last_use"] = "Last Used",
  },
  ["blog_feed"] = {
    ["blog_updates"] = "Blog Updates",
    ["blog_updates_info"] = "Receive notification when a new blog is posted at: <a href='https://www.ntop.org/blog' target='_blank'>https://ntop.org/blog</a>",
    ["news_from_blog"] = "News from the <b>ntop Blog</b>",
    ["nothing_to_show"] = "Nothing to show here. Try tomorrow!",
  },
  ["breed"] = {
    ["acceptable"] = "Acceptable Protocol",
    ["dangerous"] = "Dangerous",
    ["fun"] = "Fun Protocol",
    ["safe"] = "Safe Protocol",
    ["unsafe"] = "Unsafe Protocol",
  },
  ["bubble_map"] = {
    ["bubble_mode"] = "Criteria",
    ["notes"] = "A preview of the alerts can be found here, number of alerts, score of the hosts, ecc.<li>Above the chart a list of filters can be used to change the preview.<li>By changing the 'Type' filter, even the data are going to be changed.<li>When hovering on a node, a preview of the node data is going to be displayed.<li>When clicking on a node, the user is going to be redirect to the alert page with a set of filter to find the problem.",
    ["timeframe"] = "Timeframe",
    ["vlan"] = "VLAN",
  },
  ["capabilities"] = {
    ["active_monitoring"] = "Active Monitoring",
    ["alerts"] = "Alerts",
    ["checks"] = "Behavioural Checks",
    ["developer"] = "Developer",
    ["flowdevices"] = "Flow Probes",
    ["historical_flows"] = "Historical Flows",
    ["notifications"] = "Notifications",
    ["pools"] = "Pools",
    ["preferences"] = "Preferences",
    ["snmp"] = "SNMP",
  },
  ["categories_page"] = {
    ["search_application"] = "Search Application",
    ["target"] = "Target",
  },
  ["category_lists"] = {
    ["category_lists"] = "Blacklists",
    ["connection_time_out"] = "The server connection timeout out after %{duration} seconds",
    ["disable_some_list"] = "Please disable some lists in order to fix this.",
    ["download_succeeded"] = "List '%{name}' downloaded successfully",
    ["edit_list"] = "Edit Category List",
    ["enabled"] = "Enabled",
    ["error_occurred"] = "An error occurred while downloading <a href=\"%{url}\">list</a> '%{name}': %{err}",
    ["http_code"] = "[HTTP Code: %{err_code}]",
    ["last_update"] = "Last Update",
    ["list_will_be_updated"] = "The list '%{name}' will be updated within 30 seconds.",
    ["loading_stats"] = "Last reload (at %{when}): loaded %{num_hosts} domains, %{num_ips} IP addresses in %{duration} .",
    ["local_host_blacklisted"] = "Local host %{host} found in blacklist '%{name}'",
    ["ready_for_update"] = "Ready for Update",
    ["reset_list"] = "Reset Category List",
    ["server_returned_error"] = "The server returned an error",
    ["too_many_hosts_loaded"] = "Domain names limit reached (%{limit} domains)",
    ["too_many_ips_loaded"] = "IP addresses limit reached (%{limit} addresses)",
    ["too_many_ja3_loaded"] = "JA3 signatures limit reached (%{limit} signatures)",
    ["update_frequency"] = "Update Frequency",
    ["update_now"] = "Update Now",
  },
  ["check_exclusion"] = {
    ["add_exclusion"] = "Add Check Exclusion",
    ["alert_type"] = "Exclude Alert",
    ["disable_warn"] = "Alerts are being deleted this may take a while.",
    ["domain"] = "Domain",
    ["edit_exclusion"] = "Edit Check Exclusion",
    ["exclude_all_alerts"] = "All Alerts",
    ["exclude_all_checks_for"] = "Exclude all checks for",
    ["flow"] = "Flow",
    ["flow_alert_type"] = "Flow Alerts",
    ["host"] = "Host",
    ["host_alert_type"] = "Host Alerts",
    ["ip_address"] = "IP Address",
    ["member_type"] = "Exclude type",
    ["network"] = "Network",
    ["none"] = "None",
    ["spacing_bar"] = "----------------------------------",
    ["tls_certificate"] = "TLS Cert Issuer",
    ["validation"] = {
      ["abort_add_exclusion"] = "Abort Add Exclusion",
      ["abort_edit_exclusion"] = "Abort Edit Exclusion",
      ["select_an_alert"] = "Select at least an alert to exclude",
    },
  },
  ["checks"] = {
    ["categories"] = "Categories",
    ["category"] = "Category",
    ["category_active_monitoring"] = "Active Monitoring",
    ["category_active_monitoring_descr"] = "Active monitoring alerting system (e.g., host unreachable).",
    ["category_ids_ips"] = "Intrusion Detection and Prevention",
    ["category_ids_ips_descr"] = "Checks that evaluate the behavior of hosts and add them to the jailed hosts pool when deemed to be suspicious. When ntopng is used in combination with nProbe IPS, suspicious hosts are actually blocked and prevented from generating traffic.",
    ["category_internals"] = "Internals",
    ["category_internals_descr"] = "Internal functionalities of %{product} (e.g., memory management and host and flows lifecycles)",
    ["category_network"] = "Network",
    ["category_network_descr"] = "Network behaviors and anomalies (e.g., traffic above a certain threshold, TCP not working as expected)",
    ["category_other"] = "Other",
    ["category_other_descr"] = "Default category for uncategorized scripts or for those that cannot be included in any of the other categories",
    ["category_security"] = "Cybersecurity",
    ["category_security_descr"] = "Security behaviors and anomalies (e.g, contacts from or to a blacklisted host, TCP and UDP scans)",
    ["category_snmp"] = "SNMP",
    ["category_snmp_descr"] = "SNMP devices status (e.g., Interface duplex status changes, SNMP device restart).",
    ["category_system"] = "System",
    ["category_system_descr"] = "Functionalities of the system on top of which %{product} is running (e.g, disk space full, load too high)",
    ["device_connection_disconnection_description"] = "Enables MAC tracking to which a deny/allow policy is associated and triggering an alert MAC addresses violate it.",
    ["device_connection_disconnection_title"] = "Device/MAC Address Tracking",
    ["disable_all"] = "Disable All",
    ["disable_all_checks"] = "Disable All Checks",
    ["disable_all_message"] = "Do you want to disable all checks?",
    ["elephant_flows_descr"] = "> %{l2r_bytes} (L2R), > %{r2l_bytes} (R2L)",
    ["exceptions"] = "Exceptions: %{exceptions}",
    ["factory_reset_all_checks"] = "Factory Reset All Checks",
    ["factory_reset_all_message"] = "Do you want to reset the checks configuration to the default?",
    ["long_lived_flows_descr"] = "> %{duration}",
    ["network_discovery_alert_description"] = "Periodic Network Discovery executed",
    ["network_discovery_description"] = "Trigger an alert when a Network Discovery is detected",
    ["network_discovery_title"] = "Network Discovery",
    ["network_score_per_host_description"] = "Depending on the number of hosts in a Network, if total score exceeds the threshold per host configured, triggers an alert (e.g. 500 host, threshold 10, if the Network Score exceeds 5000 then trigger the alert)",
    ["network_score_per_host_title"] = "Network Score Per Host",
    ["no_activity_description"] = "No activity reported on %{ifname} Network Interface.",
    ["no_activity_on_exporter_description"] = "No activity reported on exporter %{exporter}. Last seen %{last_seen}.",
    ["no_activity_on_probe_description"] = "No activity reported on probe %{probe}. Last seen %{last_seen}.",
    ["no_exporter_activity_description"] = "Trigger an alert when no activity from an exporter is detected",
    ["no_exporter_activity_title"] = "No Exporter Activity",
    ["no_if_activity_description"] = "Trigger an alert when no activity from an interface is detected",
    ["no_if_activity_title"] = "No Traffic Activity",
    ["no_probe_activity_description"] = "Trigger an alert when no activity from a probe is detected",
    ["no_probe_activity_title"] = "No Probe Activity",
    ["note_apply_to_default"] = "The <b>Default</b> configuration is also 'Applied to' any pool which is not included in any other configuration.",
    ["note_configsets"] = "Checks are configured and enabled/disabled on a per-configuration basis. Multiple configurations can be created and each configuration can be 'Applied To' multiple pools.",
    ["note_what_are_checks"] = "<a href=\"%{checks_url}\">Checks</a> %{checks_external} are executed periodically or when a certain event occurs. ",
    ["stop_recording_after"] = "Stop recording after %{duration}",
    ["unexpected_new_device_exclusion_description"] = "Comma separated values of allowed MAC Addresses. Example: FF:FF:FF:FF:FF:FF",
    ["unexpected_new_device_exclusion_title"] = "Allowed MAC Addresses",
    ["hint"] = {
      ["body"] = "Configure unexpected <a href='%{link_DHCP}' target='_about'>DHCP</a>, <a href='%{link_SMTP}' target='_about'>SMTP</a>, <a href='%{link_DNS}' target='_about'>DNS</a>, <a href='%{link_NTP}' target='_about'>NTP</a> servers.",
      ["title"] = "Unexpected Servers",
    },
  },
  ["cloud"] = {
    ["cloud"] = "Cloud",
    ["disconnected"] = "Lost connection with the Cloud",
    ["disconnection"] = "Cloud Disconnection",
    ["reconnected"] = "Restored connection with the Cloud",
    ["reconnection"] = "Cloud Reconnected",
  },
  ["conf_backup"] = {
    ["conf_backup"] = "Backup Configuration",
    ["conf_restore"] = "Restore Configuration",
  },
  ["config_scripts"] = {
    ["applied_to"] = "Applied to",
    ["config_apply"] = "Config Apply",
    ["config_clone"] = "Cloning Configuration",
    ["config_clone_message"] = "Type a name for the clonation",
    ["config_delete"] = "Deleting Config",
    ["config_delete_message"] = "Do you want really remove this configuration?",
    ["config_entities"] = "Configuration Entities",
    ["config_export"] = "Export Configuration",
    ["config_import"] = "Import Configuration",
    ["config_name"] = "Configuration Name",
    ["config_rename"] = "Configuration Rename",
    ["config_rename_message"] = "Type the new name for the configuration",
    ["config_reset"] = "Reset Configuration",
    ["config_reset_confirm"] = "Do you really want to delete ALL the configurations and reset the default configuration to its initial value?",
    ["config_search"] = "Search Config:",
    ["config_x"] = "Config %{product}",
    ["empty_target_message"] = "Select one or more targets!",
    ["empty_value_message"] = "The input box cannot be empty!",
    ["invalid_characters"] = "The name contains not valid characters!",
    ["invalid_file"] = "Not a valid configuration file",
    ["max_input_length"] = "The name can have only 16 characters maximum!",
    ["no_file"] = "No configuration file selected",
    ["no_pools_applied"] = "No pool",
    ["select_interface"] = "Select Interfaces",
    ["select_network"] = "Select Networks",
    ["type_targets"] = "Type targets",
    ["type_targets_example"] = "Type targets separated by a comma. i.e: 192.168.1.20,192.168.0.0/16",
    ["actions"] = {
      ["apply_to"] = "Apply to",
      ["clone"] = "Clone",
      ["delete"] = "Delete",
      ["edit"] = "Edit",
      ["rename"] = "Rename",
    },
    ["granularities"] = {
      ["active_monitoring"] = "Active Monitoring",
      ["flow"] = "Flow",
      ["host"] = "Host",
      ["interface"] = "Interface",
      ["network"] = "Network",
      ["snmp_device"] = "SNMP Device",
      ["syslog"] = "Syslog",
      ["system"] = "System",
    },
  },
  ["configsets"] = {
    ["bad_target"] = "Bad configuration target: \"%{target}\"",
    ["duplicate_target"] = "Target \"%{target}\" is assigned to both configuration \"%{confname1}\" and \"%{confname2}\"",
    ["error_exists"] = "The configuration name \"%{name}\" is already in use",
    ["unknown_check"] = "Unknown user script \"%{check}\"",
    ["unknown_id"] = "No configuration found with id %{confid}",
    ["wrong_args_ex_list"] = "The parameters of the alert exclusion aren't correct. Check for duplicates.",
  },
  ["contacts_page"] = {
    ["client_address"] = "Client Address",
    ["client_contacts_initiator"] = "Client Contacts (Initiator)",
    ["contacts"] = "Contacts",
    ["no_client_contacts_so_far"] = "No client contacts so far",
    ["no_contacts_message"] = "No contacts for this host",
    ["no_server_contacts_so_far"] = "No server contacts so far",
    ["server_address"] = "Server Address",
    ["server_contacts_receiver"] = "Server Contacts (Receiver)",
  },
  ["containers_stats"] = {
    ["all_containers"] = "All Containers",
    ["all_pods"] = "All Pods",
    ["avg_rtt"] = "Avg RTT",
    ["avg_rtt_as_client"] = "Avg RTT as Client",
    ["avg_rtt_as_server"] = "Avg RTT as Server",
    ["avg_rtt_variance"] = "Avg RTT Variance",
    ["avg_rtt_variance_as_client"] = "Avg RTT Variance as Client",
    ["avg_rtt_variance_as_server"] = "Avg RTT Variance as Server",
    ["client_container"] = "Client Container",
    ["client_pod"] = "Client Pod",
    ["client_rtt"] = "Client RTT",
    ["container"] = "Container",
    ["containers"] = "Containers",
    ["containers_list"] = "Containers List",
    ["containers_of_pod"] = "Containers of Pod '%{pod}'",
    ["pod"] = "Pod",
    ["pods"] = "Pods",
    ["pods_list"] = "Pods List",
    ["server_container"] = "Server Container",
    ["server_pod"] = "Server Pod",
    ["server_rtt"] = "Server RTT",
  },
  ["country_details"] = {
    ["country"] = "Country",
    ["country_parameter_missing_message"] = "Country parameter is missing (internal error?)",
    ["no_available_stats_for_country"] = "No available stats for country %{country}",
  },
  ["custom_categories"] = {
    ["add"] = "Add",
    ["add_application"] = "Add Application",
    ["add_custom_app"] = "Add Custom Application",
    ["add_to_categories"] = "Add Host Rule",
    ["allowed_rules"] = "The currently allowed rules are the following: IPv4 Address, IPv4 and Port, Port, Port Ranges and Domain Names",
    ["app_delete_error"] = "Cannot delete the \"%{app}\" application. Please restart %{product} to ensure that there are no pending changes.",
    ["app_deleted"] = "Application \"%{app}\" has been deleted. Please restart %{product} to apply the changes.",
    ["application_exists"] = "Application \"%{app}\" already exists!",
    ["application_name"] = "Application Name",
    ["application_not_exists"] = "Application \"%{app}\" does not exist!",
    ["apps_and_categories"] = "Applications and Categories",
    ["category_name"] = "Category Name",
    ["custom_host_category"] = "Custom Host Rule",
    ["custom_hosts"] = "Custom Rules",
    ["delete_app"] = "Delete Application",
    ["delete_app_confirm"] = "WARNING: Deleting an application is a destructive operation which can affect the historical data of the other custom applications defined. Do you really want to delete selected application?",
    ["domain_names_substrings"] = "Domain names are interpreted as substring to be matched. E.g. 'ntop.org' will match 'mail.ntop.org' and 'ntop.org.example.com'",
    ["each_host_separate_line"] = "Each rule must be put on a separate line",
    ["edit_custom_rules"] = "Edit Custom Rules",
    ["edit_hosts"] = "Edit Rules",
    ["error_added"] = "Error while adding the application",
    ["example_port_range"] = "Port range examples: 'udp:443', 'tcp:1230-1235'",
    ["host_domain"] = "Domain names rules (Domain names are interpreted as substring to be matched):<br />&nbsp;&nbsp;&nbsp;&nbsp;host:domainName (e.g.: host:google )",
    ["host_domain_or_cidr"] = "Rules can be either domain names or IPv4 addresses/CIDR network addresses",
    ["host_domain_or_port"] = "Rules can be either domain names, IPv4 addresses or TCP/UDP port ranges",
    ["invalid_rule"] = "Invalid rule has been ignored: %{rule}",
    ["ip_address"] = "IPv4 Address rules:<br />&nbsp;&nbsp;&nbsp;&nbsp;ip:ip_address (e.g.: ip:0.0.0.0 )",
    ["ip_address_port"] = "IPv4 and Port:<br />&nbsp;&nbsp;&nbsp;&nbsp;ip:ip_address:port (e.g.: ip:0.0.0.0:55666 )",
    ["ipv6_address"] = "IPv6 Address rules:<br />&nbsp;&nbsp;&nbsp;&nbsp;ipv6:ipv6_address (e.g.: ipv6:[1:1:1:1:1:1:1:1] )",
    ["ipv6_address_port"] = "IPv6 and Port:<br />&nbsp;&nbsp;&nbsp;&nbsp;ipv6:ipv6_address:port (e.g.: ipv6:[1:1:1:1:1:1:1:1]:55666 )",
    ["new_app_added"] = "Application \"%{app}\" has been configured. Please restart %{product} to start using it.",
    ["non_empty_list_required"] = "At least one rule must be specified.",
    ["option_needed"] = "Custom applications configuration is currently disabled as the <i>%{option}</i> parameter is missing from the configuration. Check out <a href=\"%{url}\">the documentation</a> for more details.",
    ["port"] = "Port rules:<br />&nbsp;&nbsp;&nbsp;&nbsp;tcp/udp:port (e.g.: tcp:11555, udp:5566 )",
    ["port_range"] = "Port Range rules:<br />&nbsp;&nbsp;&nbsp;&nbsp;tcp/udp:port-port (e.g.: tcp:111-113, udp:111-134 )",
    ["protos_reboot_necessary"] = "Application rules have been written. Please restart %{product} to apply them.",
    ["protos_unexpected_error"] = "Unexpected error while updating the applications rules. Check out the %{product} log for more details.",
    ["select_url_category"] = "Please select where the domain will be added:",
    ["similar_host_found"] = "a rule similar to \"%{host}\" is already contained into the %{category} category",
    ["succesfully_added"] = "Succesfully added the application, reloading in a couple of seconds",
    ["succesfully_edited"] = "Succesfully edited the application, reloading in a couple of seconds",
    ["succesfully_removed"] = "Succesfully removed the application, reloading in a couple of seconds",
    ["the_following_is_a_list_of_hosts"] = "The following is a list of custom rules for the %{category} category",
    ["the_following_is_a_list_of_hosts_app"] = "The following is a list of custom rules for the %{application} application",
    ["the_following_url_will_be_added"] = "The following domain will be added:",
  },
  ["dashboard"] = {
    ["actual_traffic"] = "Current Traffic",
    ["add_component"] = "Add Widget",
    ["advanced_settings"] = "Advanced Settings",
    ["community_dashboard"] = "Community Dashboard",
    ["component_height"] = "Height",
    ["component_json_error"] = "There is an error in the JSON syntax",
    ["component_title"] = "Title",
    ["component_width"] = "Width",
    ["current_time"] = "Current",
    ["custom"] = "Custom",
    ["del_template"] = "Delete Template",
    ["del_template_confirm"] = "Are you sure you want to delete the current template?",
    ["edit_component"] = "Edit Widget",
    ["edit_mode"] = "Template Editor",
    ["empty_template"] = "Empty Template",
    ["empty_template_note"] = "This template is empty, please use the Template Editor in the Toolbox to start adding Widgets to this report.",
    ["gateways_users"] = "Gateways and Users",
    ["lastday_app_traffic"] = "Top Applications (Last Day)",
    ["lastday_traffic"] = "All Network Interfaces (Last Day)",
    ["new_template"] = "New Template",
    ["open"] = "Open Report",
    ["print"] = "Print Report",
    ["realtime_app_traffic"] = "Top Applications (Realtime)",
    ["realtime_traffic"] = "All Network Interfaces (Realtime)",
    ["slow_dashboard_message"] = "Too much latency in the %{product} response. Consider setting an higher <a href='%{url}'>Realtime Stats Refresh Rate</a>.",
    ["store"] = "Save Report",
    ["time_offset"] = "Time Offset",
    ["time_window"] = "Time Window",
    ["top_local_talkers"] = "Top Local Talkers",
    ["top_remote_destinations"] = "Top Remote Destinations",
    ["traffic_dashboard"] = "Traffic Dashboard",
    ["component_sizes"] = {
      ["auto"] = "Auto",
      ["large"] = "Large",
      ["medium"] = "Medium",
      ["small"] = "Small",
    },
    ["time_ago"] = {
      ["12_hours"] = "12 Hours Ago",
      ["2_hours"] = "2 Hours Ago",
      ["30_min"] = "30 Min Ago",
      ["5_min"] = "5 Min Ago",
      ["6_hours"] = "6 Hours Ago",
      ["day"] = "1 Day Ago",
      ["hour"] = "1 Hour Ago",
      ["month"] = "1 Month Ago",
      ["none"] = " ",
      ["now"] = " ",
      ["week"] = "1 Week Ago",
      ["year"] = "1 Year Ago",
    },
    ["time_offset_list"] = {
      ["12_hours"] = "-12 Hours",
      ["2_hours"] = "-2 Hours",
      ["30_min"] = "-30 Min",
      ["5_min"] = "-5 Min",
      ["6_hours"] = "-6 Hours",
      ["day"] = "-1 Day",
      ["hour"] = "-1 Hour",
      ["month"] = "-1 Month",
      ["none"] = " ",
      ["now"] = " ",
      ["week"] = "-1 Week",
      ["year"] = "-1 Year",
    },
    ["time_window_list"] = {
      ["12_hours"] = "12 Hours",
      ["2_hours"] = "2 Hours",
      ["30_min"] = "30 Minutes",
      ["5_min"] = "5 Minutes",
      ["day"] = "1 Day",
      ["hour"] = "1 Hour",
      ["month"] = "1 Month",
      ["week"] = "1 Week",
      ["year"] = "1 Year",
    },
  },
  ["datasources"] = {
    ["alias"] = "Alias",
    ["alias_example"] = "i.e. Datasource Alias",
    ["families"] = "Families",
    ["key"] = "Key",
    ["metrics"] = "Metrics",
    ["new_source"] = "New Source",
    ["origin"] = "Origin",
    ["private"] = "Private",
    ["public"] = "Public",
    ["retention"] = "Retention",
    ["schema"] = "Schema",
    ["scope"] = "Scope",
    ["select_family"] = "Select a family",
    ["select_metrics"] = "Select a metric",
    ["select_schema"] = "Select a schema",
    ["select_schema_first"] = "Select a schema first",
    ["select_series"] = "Select a series",
    ["series"] = "Series",
    ["source_exists"] = "There is already a source like this!",
    ["tags"] = "Tags",
    ["widget_bound"] = "There are widgets bound to this Datasource!",
    ["modal"] = {
      ["add_datasource"] = "Add Datasource",
      ["delete_datasource"] = "Delete Datasource: %{datasource}",
      ["delete_description"] = "Are you really sure to remove the datasource: %{datasource}?",
      ["edit_datasource"] = "Edit Datasource: %{datasource}",
    },
    ["validation"] = {
      ["abort_add"] = "Abort add Datasource?",
      ["abort_edit"] = "Abort edit Datasource?",
    },
  },
  ["datatable"] = {
    ["abort_add_filter"] = "Abort add filter?",
    ["add_filter"] = "Add Filter",
    ["aggregated"] = "Hourly",
    ["edit_filter"] = "Edit Filter",
    ["manage_snapshots"] = "Manage Snapshots",
    ["no_records"] = "No Records",
    ["number_of_records"] = "Number of records",
    ["select_filter"] = "Filter",
    ["fields"] = {
      ["info"] = "Info",
      ["traffic_exchanged"] = "Traffic Exchanged",
    },
  },
  ["date_time_range_picker"] = {
    ["btn_move_left"] = "Shift Left Time Interval",
    ["btn_move_right"] = "Shift Right Time Interval",
    ["btn_refresh"] = "Refresh Time Interval",
    ["btn_undo"] = "Restore the previous Time Interval",
    ["btn_zoom_in"] = "Zoom In Time Interval",
    ["btn_zoom_out"] = "Zoom Out Time Interval",
  },
  ["db_explorer"] = {
    ["abort"] = "Abort",
    ["alert_details"] = "Alert Details",
    ["all"] = "all",
    ["app_between_talkers_pairs"] = "applications between pairs of talkers",
    ["app_flows_between"] = "%{app} application flows between %{peer1} and %{peer2}",
    ["app_talkers"] = "%{app} talkers",
    ["app_talkers_with"] = "%{app} talkers with %{peer}",
    ["application_flows"] = "Application flows",
    ["applications_between"] = "Applications between %{peer1} and %{peer2}",
    ["average_throughput"] = "Avg Thpt",
    ["cli_latency"] = "Client Nw Latency",
    ["client_server_breakdown"] = "Client vs Server Traffic Breakdown",
    ["client_server_host"] = "Client/Server Host",
    ["community_id"] = "Community ID",
    ["date_time"] = "Date / Time",
    ["dns_query"] = "DNS Query",
    ["download_flows"] = "Download flows",
    ["download_flows_limit"] = "Maximum 1000 records.",
    ["empty_query_response"] = "Empty query response (database down or query killed/timed out?)",
    ["extract_pcap"] = "Extract PCAP",
    ["filter_bpf"] = "Filter (BPF)",
    ["flow_peers"] = "Flow Peers",
    ["get_proto_talkers"] = "Get Talkers using this application",
    ["historical_data"] = "Historical Flows",
    ["historical_data_explorer"] = "Historical",
    ["historical_flow"] = "Historical Flow",
    ["host_data"] = "Host",
    ["host_name"] = "Host Name",
    ["host_talkers"] = "%{host} talkers",
    ["hosts_talking_proto_with"] = "Hosts talking %{proto} with {host}",
    ["http_host"] = "HTTP Host",
    ["http_method"] = "HTTP Method",
    ["info"] = "Info",
    ["interface_data"] = "Interface",
    ["interface_name"] = "Instance Name",
    ["is_attacker"] = "Is Attacker",
    ["is_blacklisted"] = "Is Blacklisted",
    ["is_victim"] = "Is Victim",
    ["issue_description"] = "Main Issue Description",
    ["last_hour_flows"] = "Flows seen in the last hour",
    ["ms_client"] = "%{client} ms (client)",
    ["ms_server"] = "%{server} ms (server)",
    ["network_latency_breakdown"] = "Network Latency Breakdown",
    ["observation_period"] = "Observation Period",
    ["observation_point"] = "Observation Point",
    ["ok_request_sent"] = "OK, request sent",
    ["other_issues"] = "Other Issues",
    ["packet_rate"] = "Average Packet Rate",
    ["pcap_requests_and_status"] = "PCAP Requests and Statuses",
    ["pcaps"] = "PCAPs",
    ["post_nat_info"] = "Post NAT flow",
    ["pre_nat_info"] = "Pre NAT flow",
    ["pre_post_nat_dst_port"] = "Pre - Post NAT Dst Port",
    ["pre_post_nat_ipv4_dst_addr"] = "Pre - Post NAT Dst IPs",
    ["pre_post_nat_ipv4_src_addr"] = "Pre - Post NAT Src IPs",
    ["pre_post_nat_src_port"] = "Pre - Post NAT Src Port",
    ["protocol_flows_between"] = "%{proto} application flows between %{peer1} and %{peer2}",
    ["protocol_id"] = "Application id",
    ["query_in_progress"] = "Database query in progress, waiting to receive results...",
    ["request_failed"] = "Request Failed",
    ["response_code"] = "Response Code",
    ["score"] = "Score",
    ["search_flows"] = "Search Flows",
    ["selected_saved"] = "Select saved",
    ["server_name"] = "Server Name",
    ["srv_latency"] = "Server Nw Latency",
    ["summary"] = "Summary",
    ["talkers_with_this_host"] = "Talkers with this host",
    ["task_id"] = "Task Id",
    ["this_flow_has_been_reset"] = "This flow has been reset and probably the server application is down",
    ["this_flow_is_active"] = "This flow is active",
    ["this_flow_is_completed"] = "This flow is completed and will soon expire",
    ["top_flows_ipv4"] = "Top IPv4 Flows [%{date_from} - %{date_to}]",
    ["top_flows_ipv6"] = "Top IPv6 Flows [%{date_from} - %{date_to}]",
    ["top_proto_ipv4_flows"] = "Top %{proto} IPv4 Flows",
    ["top_proto_ipv6_flows"] = "Top %{proto} IPv6 Flows",
    ["tos"] = "DSCP [ Client / Server ]",
    ["total_flows"] = "Total Flows",
    ["total_packets"] = "Total Packets",
    ["traffic_analysis"] = "Traffic Analysis",
    ["traffic_info"] = "Traffic Informations",
    ["traffic_rate"] = "Average Traffic Rate",
    ["traffic_received"] = "Bytes Received",
    ["traffic_sent"] = "Bytes Sent",
    ["traffic_sent_to_cli"] = "Bytes Sent to Clients",
    ["traffic_sent_to_srv"] = "Bytes Sent to Servers",
    ["traffic_volume"] = "Traffic Volume",
    ["unable_to_find_flow"] = "Unable to find the specified flow",
    ["unsave"] = "Remove",
    ["vlan_id"] = "VLAN Id",
  },
  ["db_search"] = {
    ["alert_category"] = "Category",
    ["alert_id"] = "Status",
    ["asn"] = "ASN",
    ["bytes"] = "Bytes",
    ["cli_asn"] = "Cli ASN",
    ["cli_host_pool_id"] = "Cli Pool",
    ["cli_location"] = "Client Location",
    ["cli_nw_latency"] = "Client Network Latency",
    ["cli_port"] = "Cli Port",
    ["client"] = "Client",
    ["client_name"] = "Client Name",
    ["dst2src_dscp"] = "Server DSCP",
    ["dst2src_tcp_flags"] = "Server TCP Flags",
    ["duration"] = "Duration",
    ["expand_button"] = "Expand",
    ["extract_flow_info"] = "Actions",
    ["find_in_historical"] = "Search '%{what}' '%{query}' in Historical Data",
    ["first_seen"] = "Begin",
    ["flow_risk"] = "Flow Risk",
    ["host"] = "Host",
    ["host_pool"] = "Host Pool",
    ["info"] = "Info",
    ["input_snmp"] = "Input Interface",
    ["l4proto"] = "Protocol",
    ["l7cat"] = "Category",
    ["l7proto"] = "Application",
    ["last_seen"] = "End",
    ["max_results"] = "Max Results",
    ["network"] = "Network",
    ["number"] = "Number",
    ["observation_point_id"] = "Obs. Point ID",
    ["output_snmp"] = "Output Interface",
    ["packets"] = "Pkts",
    ["probe_ip"] = "Flow Exporter",
    ["processed_records"] = "Processed %{records} records [%{rps} records/sec]",
    ["query"] = "Query",
    ["query_copied"] = "Query SQL copied to clipboard!",
    ["query_performed"] = "Query performed in",
    ["records"] = "Records",
    ["run_query"] = "Run query",
    ["select_note"] = "Use * for all fields or a comma-separated list of fields (<field1>,<field2>,...)",
    ["server"] = "Server",
    ["server_name"] = "Server Name",
    ["src2dst_dscp"] = "Client DSCP",
    ["src2dst_tcp_flags"] = "Client TCP Flags",
    ["srv_asn"] = "Srv ASN",
    ["srv_host_pool_id"] = "Srv Pool",
    ["srv_nw_latency"] = "Server Network Latency",
    ["srv_port"] = "Srv Port",
    ["throughput"] = "Thpt",
    ["time_range"] = "Time Range",
    ["top_clients"] = "Top Clients",
    ["top_clients_contacts"] = "Top Clients Contacts",
    ["top_contacted_servers"] = "Top Contacted Servers",
    ["top_exporter"] = "Top Flow Exporters",
    ["top_exporter_interfaces"] = "Top Exporter Interfaces",
    ["top_hosts"] = "Top Hosts",
    ["top_info"] = "Top Info",
    ["top_l7proto"] = "Top L7 Applications",
    ["top_protocols"] = "Top Protocols",
    ["top_servers"] = "Top Servers",
    ["traffic_direction"] = "Traffic Direction",
    ["vlan_id"] = "VLAN",
    ["where_note"] = "Use &lt;field&gt; &lt;operator&gt; &lt;value&gt; conditions, where &lt;operator&gt; could be &lt;, &gt;, =, !=. AND/OR operators are also allowed to combine conditions. Please use quotes for string fields (e.g. INFO='www.ntop.org')",
    ["all"] = {
      ["host_pool"] = "All Host Pools",
      ["input_snmp"] = "All Interfaces",
      ["l4proto"] = "All Protocols",
      ["l7cat"] = "All Categories",
      ["l7proto"] = "All Applications",
      ["network"] = "All Networks",
      ["output_snmp"] = "All Interfaces",
      ["probe_ip"] = "All Exporters",
      ["vlan_id"] = "All VLANs",
    },
    ["tags"] = {
      ["acknowledged"] = "Acknowledged",
      ["alert_category"] = "Category",
      ["alert_description"] = "Description",
      ["alert_id"] = "Alert Type",
      ["asn"] = "ASN",
      ["bytes"] = "Bytes",
      ["cli_asn"] = "Client ASN",
      ["cli_country"] = "Client Country",
      ["cli_host_pool_id"] = "Client Pool",
      ["cli_ip"] = "Client IP",
      ["cli_ip_v4"] = "Client IPv4",
      ["cli_ip_v6"] = "Client IPv6",
      ["cli_location"] = "Client Location",
      ["cli_mac"] = "Client MAC",
      ["cli_name"] = "Client Name",
      ["cli_network"] = "Client Network",
      ["cli_network_cidr"] = "Client Network CIDR",
      ["cli_nw_latency"] = "Cli Network Latency",
      ["cli_port"] = "Client Port",
      ["cli_proc_name"] = "Client Process",
      ["cli_user_name"] = "Client User",
      ["community_id"] = "Community ID",
      ["confidence"] = "Confidence",
      ["country"] = "Country",
      ["dga_domain_name"] = "Requested Domain Name",
      ["dscp_id"] = "DSCP ID",
      ["dst2src_dscp"] = "Server DSCP",
      ["dst2src_tcp_flags"] = "Srv TCP Flags",
      ["error_code"] = "Error Code",
      ["flow_risk"] = "Flow Risk",
      ["flows_number"] = "Total Flows",
      ["host_location"] = "Host Location",
      ["host_pool_id"] = "Host Pool",
      ["http_method"] = "HTTP Method",
      ["http_return_code"] = "HTTP Return Code",
      ["http_url"] = "HTTP URL",
      ["info"] = "Info",
      ["input_snmp"] = "In SNMP Iface",
      ["instance_name"] = "ntopng Instance Name",
      ["ip"] = "IP",
      ["ip_address"] = "IP",
      ["ip_version"] = "IP Version",
      ["issuer_dn"] = "TLS Issuer DN",
      ["ja3"] = "JA3",
      ["l4proto"] = "Protocol",
      ["l7_proto"] = "Application",
      ["l7cat"] = "Category",
      ["l7proto"] = "Application",
      ["last_server"] = "HTTP Last Server",
      ["lost"] = "Packets Lost",
      ["mac"] = "MAC",
      ["major_connection_state"] = "Major Connection State",
      ["mdns_answer"] = "MDNS Answer",
      ["mdns_name"] = "MDNS Name",
      ["mdns_name_txt"] = "MDNS Name TXT",
      ["mdns_ssid"] = "MDNS SSID",
      ["minor_connection_state"] = "Minor Connection State",
      ["mitre_id"] = "Mitre ID",
      ["mitre_subtechnique"] = "Mitre Sub-Technique",
      ["mitre_tactic"] = "Mitre Tactic",
      ["mitre_technique"] = "Mitre Technique",
      ["name"] = "Hostname",
      ["netbios_name"] = "NetBios Name",
      ["network"] = "Network",
      ["network_cidr"] = "Network CIDR",
      ["network_name"] = "Network Name",
      ["number"] = "Number",
      ["observation_point_id"] = "Observation Point ID",
      ["out_of_order"] = "Packets Out Of Order",
      ["output_snmp"] = "Out SNMP Iface",
      ["packets"] = "Packets",
      ["post_nat_dst_port"] = "Post-NAT Dst Port",
      ["post_nat_ipv4_dst_addr"] = "Post-NAT IPv4 Dst IP",
      ["post_nat_ipv4_src_addr"] = "Post-NAT IPv4 Src IP",
      ["post_nat_src_port"] = "Post-NAT Src Port",
      ["pre_nat_dst_port"] = "Pre-NAT Dst Port",
      ["pre_nat_ipv4_dst_addr"] = "Pre-NAT IPv4 Dst IP",
      ["pre_nat_ipv4_src_addr"] = "Pre-NAT IPv4 Src IP",
      ["pre_nat_src_port"] = "Pre-NAT Src Port",
      ["probe_ip"] = "Flow Exporter",
      ["retransmissions"] = "Packets Retransmissions",
      ["role"] = "Role",
      ["role_cli_srv"] = "Client/Server",
      ["roles"] = "Roles",
      ["score"] = "Score",
      ["severity"] = "Severity",
      ["snmp_interface"] = "SNMP Interface",
      ["src2dst_dscp"] = "Client DSCP",
      ["src2dst_tcp_flags"] = "Cli TCP Flags",
      ["srv_asn"] = "Server ASN",
      ["srv_country"] = "Server Country",
      ["srv_host_pool_id"] = "Server Pool",
      ["srv_ip"] = "Server IP",
      ["srv_ip_v4"] = "Server IPv4",
      ["srv_ip_v6"] = "Server IPv6",
      ["srv_location"] = "Server Location",
      ["srv_mac"] = "Server MAC",
      ["srv_name"] = "Server Name",
      ["srv_network"] = "Server Network",
      ["srv_network_cidr"] = "Server Network CIDR",
      ["srv_nw_latency"] = "Srv Network Latency",
      ["srv_port"] = "Server Port",
      ["srv_proc_name"] = "Server Process",
      ["srv_user_name"] = "Server User",
      ["status"] = "Status",
      ["subtype"] = "Subject",
      ["sum_dst2src_bytes"] = "Total Bytes Dst-Src",
      ["sum_packets"] = "Total Packets",
      ["sum_src2dst_bytes"] = "Total Bytes Src-Dst",
      ["total_score"] = "Total Score",
      ["traffic"] = "Bytes",
      ["traffic_direction"] = "Traffic Direction",
      ["user_agent"] = "User Agent",
      ["vlan_id"] = "VLAN",
      ["minor_connection_states"] = {
        ["0"] = "NO_STATE",
        ["1"] = "S0 - Connection attempt seen, no reply",
        ["10"] = "RSTRH - Responder sent a SYN ACK followed by a RST, we never saw a SYN from the originator",
        ["11"] = "SH - Originator sent a SYN followed by a FIN, we never saw a SYN ACK from the responder",
        ["12"] = "SHR - Responder sent a SYN ACK followed by a FIN, we never saw a SYN from the originator",
        ["13"] = "OTH - No SYN seen, just midstream traffic",
        ["2"] = "S1 - Connection established, not terminated",
        ["3"] = "SF - Normal establishment and termination",
        ["4"] = "REJ - Connection attempt rejected",
        ["5"] = "S2 - Connection established and close attempt by originator seen",
        ["6"] = "S3 - Connection established and close attempt by responder seen",
        ["7"] = "RSTO - Connection established, originator aborted",
        ["8"] = "RSTR - Responder sent a RST",
        ["9"] = "RSTOS0 - Originator sent a SYN followed by a RST, we never saw a SYN-ACK from the responder",
      },
    },
  },
  ["delete_data"] = {
    ["delete_active_interface_confirmation"] = "Are you sure you want to delete all the persistent data associated to %{ifname}?<br><br><b><b>NOTE</b>:</b> Data deletion will be performed upon %{product} restart. Restart %{product} to make the deletion effective.",
    ["delete_active_interface_data_failed"] = "Unable to delete active interface data.",
    ["delete_active_interface_data_ok"] = "Data for %{ifname} has successfully been marked for deletion. Restart %{product} to make the deletion effective.",
    ["delete_confirmation"] = "Are you sure you want to delete all persistent data for %{host}?",
    ["delete_failed"] = "Unable to delete data for %{host}.",
    ["delete_inactive_interfaces_confirmation"] = "The following interfaces are inactive:%{interfaces_list}Are you sure you want to delete all their persistent data?",
    ["delete_inactive_interfaces_data_failed"] = "Unable to delete inactive interfaces data.",
    ["delete_inactive_interfaces_data_ok"] = "Data for inactive interfaces successfully deleted.",
    ["delete_ok"] = "Data for %{host} has been successfully deleted.",
    ["msg_err_invalid_host"] = "The format of the specified host is not recognized.",
    ["msg_err_no_fs_data"] = "No persistent data found for the specified host.",
    ["msg_err_unable_to_delete_dir"] = "Unable to delete the data directory.",
    ["msg_err_unable_to_delete_ts_data"] = "Unable to delete timeseries data.",
    ["msg_err_unknown"] = "An unknown error occurred.",
    ["node_nindex_flows"] = "WARNING: nIndex is enabled for flows dump, historical flows information will not be deleted.",
    ["note_persistent_data"] = "All the persistent data is deleted. Data include traffic counters, timeseries, flows, alerts, and Redis caches.",
    ["restart_product_toast"] = "Restart %{product} to make the deletion of active interface effective.",
  },
  ["details"] = {
    ["additional_mac_address"] = "Additional MAC Address",
    ["address_resolution_protocol"] = "Address Resolution Protocol",
    ["ago"] = "ago",
    ["alerts"] = "Alerts",
    ["alerts_analysis"] = "Flow Alerts Analyser",
    ["alerts_list"] = "Explorer",
    ["arp_replies"] = "ARP Replies",
    ["arp_requests"] = "ARP Requests",
    ["as_client"] = "As Client",
    ["as_server"] = "As Server",
    ["comment_placeholder"] = "Write comment here...",
    ["contacts_blacklisted"] = "Total Flows with Blacklisted Hosts",
    ["custom_rules_placeholder"] = "Write the rules here...",
    ["details"] = "Details",
    ["device_port"] = "Device Port",
    ["device_type"] = "Device Type",
    ["dhcp_sent_received"] = "DHCP Sent / Received",
    ["duration"] = "Flow Duration",
    ["first_last_seen"] = "First / Last Seen",
    ["first_observed_on"] = "First Observed On",
    ["flow_exporter"] = "Flow Exporter",
    ["flow_snmp_localization"] = "Flow SNMP Localization",
    ["flow_verdict"] = "Flow Verdict",
    ["flows_dropped_by_bridge"] = "Flows Blocked due to Traffic Policies",
    ["flows_non_packet_iface"] = "Recently Live Flows / Total / Total Alerted",
    ["flows_packet_iface"] = "Flows: Active / Total / Alerted / Port Unreach",
    ["fragments"] = "Fragments",
    ["further_host_names_information"] = "Additional Host Names",
    ["goodput"] = "Goodput",
    ["host_mac_address"] = "Host MAC Address",
    ["host_pool"] = "Host Pool",
    ["host_purged"] = "This host is no longer active and it should have been purged from memory",
    ["host_snmp_localization"] = "SNMP Localization",
    ["input_device_port"] = "Ingress Interface Id",
    ["is_dhcp_broadcast"] = "DHCP broadcast",
    ["keep_alive"] = "KeepAlive",
    ["label_blackhole"] = "Blackhole",
    ["label_blacklisted_host"] = "Blacklisted",
    ["label_dhcp"] = "DHCP",
    ["label_dhcp_server"] = "DHCP Server",
    ["label_dns_server"] = "DNS Server",
    ["label_imap_server"] = "IMAP Server",
    ["label_local_host"] = "Local",
    ["label_ntp_server"] = "NTP Server",
    ["label_pop_server"] = "POP Server",
    ["label_private_ip"] = "Private",
    ["label_remote"] = "Remote",
    ["label_short_blackhole"] = "H",
    ["label_short_local_host"] = "L",
    ["label_short_local_host_badge"] = "<abbr title=\"Local\"><span class='badge bg-success'>L</span></abbr>",
    ["label_short_multicast_host_badge"] = "<abbr title=\"Multicast\"><span class='badge bg-primary'>M</span></abbr>",
    ["label_short_private_ip"] = "P",
    ["label_short_remote"] = "R",
    ["label_short_remote_host_badge"] = "<abbr title=\"Remote\"><span class='badge bg-secondary'>R</span></abbr>",
    ["label_smtp_server"] = "SMTP Server",
    ["label_system_ip"] = "System IP",
    ["lost"] = "Lost",
    ["mac_address"] = "MAC Address",
    ["misbehaving_flows_reasons"] = "Mibehaving Flows Reasons",
    ["more_then_one_device"] = " (More than one Probe has detected this Host)",
    ["note"] = "NOTE",
    ["note_hosts_located_snmp_device"] = "Hosts are located in SNMP devices using the <A HREF=%{url}>Bridge MIB</A>.",
    ["observation_point_id"] = "Observation Point Id",
    ["out_of_order"] = "Out of Order",
    ["output_device_port"] = "Egress Interface Id",
    ["peers"] = "Peers: Active",
    ["probes_ipv4_address"] = "Flow Exporter",
    ["rcvd"] = "Rcvd",
    ["retransmissions"] = "Retransmissions",
    ["ripestat_lookup"] = "RIPEstat Lookup",
    ["router_access_point_mac_address"] = "Router/AccessPoint MAC Address",
    ["sent_vs_received_traffic_breakdown"] = "Sent vs Received Traffic Breakdown",
    ["server_contacts"] = "Contacted Servers",
    ["server_contacts_tcp_unresponsive"] = "TCP/UDP Unresponsive Flows (Peer IP and Server Port)",
    ["show_hosts"] = "Show Hosts",
    ["source"] = "Source",
    ["source_id"] = "Source Id",
    ["tcp_packets_sent_analysis"] = "TCP Packets Sent Analysis",
    ["total_traffic"] = "Total Traffic",
    ["traffic_sent_received"] = "Traffic Sent / Received",
    ["unidirectional_tcp_flows"] = "Total Unidirectional TCP/UDP Flows",
    ["vlan_id"] = "VLAN ID",
    ["whois_lookup"] = "Whois Lookup",
  },
  ["developer_section"] = {
    ["datasources_list"] = "Datasources",
    ["widgets_list"] = "Widgets",
  },
  ["device_protocols"] = {
    ["alert"] = "Trigger Alert",
    ["device_protocol_policy"] = "Device Application Policy",
    ["device_protocols"] = "Device Applications",
    ["devtype_as_proto_client"] = "%{devtype} as <i>%{proto}</i> client",
    ["devtype_as_proto_server"] = "%{devtype} as <i>%{proto}</i> server",
    ["filter_device_protocols"] = "%{filter} Device Applications",
    ["ok"] = "Acceptable",
  },
  ["device_types"] = {
    ["iot"] = "IoT",
    ["laptop"] = "Laptop",
    ["multimedia"] = "Multimedia",
    ["nas"] = "NAS",
    ["networking"] = "Router/Switch",
    ["phone"] = "Phone",
    ["printer"] = "Printer",
    ["tablet"] = "Tablet",
    ["tv"] = "TV",
    ["unknown"] = "Unknown",
    ["video"] = "Video",
    ["wifi"] = "Wireless Network",
    ["workstation"] = "Computer",
  },
  ["dhcp"] = {
    ["delete_range"] = "Delete DHCP Range",
    ["delete_range_confirm"] = "Do you really want to delete the configured DHCP range %{range} ?",
    ["dhcp"] = "DHCP",
    ["dhcp_alert_note"] = "An alert will be generated when an IP address is assigned outside the configured DHCP ranges",
    ["dhcp_configuration_note"] = "This page lists the configured DHCP ranges for this interface. These should match the actual DHCP server configuration in use",
    ["invalid_ip_address"] = "Invalid IP address",
    ["no_dhcp_ranges"] = "No DHCP ranges configured.",
  },
  ["discover"] = {
    ["device"] = "Device",
    ["discovered_devices"] = "Discovered %{manuf} %{sys} %{dev} Devices",
    ["discovery_running"] = "If Active Network Discovery is enabled and it's running then the <span class=\"badge bg-warning\"><i class=\"fas fa-project-diagram\"></i></span> icon is going to be displayed close to the Interface Throughput",
    ["err_unable_to_arp_discovery"] = "Unable to start ARP network discovery",
    ["error_no_discovery_cached"] = "No discovery data has been cached yet.",
    ["error_unable_to_decode_json"] = "Unable to decode cache JSON discovery data.",
    ["ghost_icon_descr"] = "The <font color=red><i class='fas fa-ghost fa-lg' aria-hidden='true'></i></font> icon highlights ghost hosts (i.e. they do not belong to the interface IP address network)",
    ["network_discovery"] = "Network Discovery",
    ["network_discovery_datetime"] = "Last Network Discovery",
    ["network_discovery_not_enabled"] = "Network discovery in progress",
    ["protocols_note"] = "The following protocols are used to discover the devices: ARP, SSDP, MDNS, SNMP. For more info <a target=\"_blank\" href=\"https://www.ntop.org/guides/ntopng/web_gui/network_discovery.html\">Network Discovery</a>",
    ["start_discovery"] = "Run Discovery",
    ["too_many_devices_descr"] = "Too many devices discovered. Results have been trimmed at 8192 devices",
  },
  ["dns_info"] = {
    ["query_types"] = {
      ["1"] = "A",
      ["10"] = "NULL",
      ["100"] = "UINFO",
      ["101"] = "UID",
      ["102"] = "GID",
      ["103"] = "UNSPEC",
      ["104"] = "NID",
      ["105"] = "L32",
      ["106"] = "L64",
      ["107"] = "LP",
      ["108"] = "EUI48",
      ["109"] = "EUI64",
      ["11"] = "WKS",
      ["12"] = "PTR",
      ["13"] = "HINFO",
      ["14"] = "MINFO",
      ["15"] = "MX",
      ["16"] = "TXT",
      ["17"] = "RP",
      ["18"] = "AFSDB",
      ["19"] = "X25",
      ["2"] = "NS",
      ["20"] = "ISDN",
      ["21"] = "RT",
      ["22"] = "NSAP",
      ["23"] = "NSAP_PTR",
      ["24"] = "SIG",
      ["249"] = "TKEY",
      ["25"] = "KEY",
      ["250"] = "TSIG",
      ["251"] = "IXFR",
      ["252"] = "AXFR",
      ["253"] = "MAILB",
      ["254"] = "MAILA",
      ["255"] = "ANY",
      ["256"] = "URI",
      ["257"] = "CAA",
      ["26"] = "PX",
      ["27"] = "GPOS",
      ["28"] = "AAAA",
      ["29"] = "LOC",
      ["3"] = "MD",
      ["30"] = "NXT",
      ["31"] = "EID",
      ["32"] = "NIMLOC",
      ["33"] = "SRV",
      ["34"] = "ATMA",
      ["35"] = "NAPTR",
      ["36"] = "KX",
      ["37"] = "CERT",
      ["38"] = "A6",
      ["39"] = "DNAME",
      ["4"] = "MF",
      ["40"] = "SINK",
      ["41"] = "OPT",
      ["42"] = "APL",
      ["43"] = "DS",
      ["44"] = "SSHFP",
      ["45"] = "IPSECKEY",
      ["46"] = "RRSIG",
      ["47"] = "NSEC",
      ["48"] = "DNSKEY",
      ["49"] = "DHCID",
      ["5"] = "CNAME",
      ["50"] = "NSEC3",
      ["51"] = "NSEC3PARAM",
      ["52"] = "TLSA",
      ["55"] = "HIP",
      ["56"] = "NINFO",
      ["57"] = "RKEY",
      ["58"] = "TALINK",
      ["59"] = "CDS",
      ["6"] = "SOA",
      ["60"] = "CDNSKEY",
      ["61"] = "OPENPGPKEY",
      ["62"] = "CSYNC",
      ["64"] = "SVCB",
      ["65"] = "HTTPS",
      ["7"] = "MB",
      ["8"] = "MG",
      ["9"] = "MR",
      ["99"] = "SPF",
    },
    ["return_codes"] = {
      ["0"] = "NOERROR",
      ["1"] = "FORMERR",
      ["2"] = "SERVFAIL",
      ["3"] = "NXDOMAIN",
      ["4"] = "NOTIMP",
      ["5"] = "REFUSED",
      ["6"] = "YXDOMAIN",
      ["7"] = "XRRSET",
      ["8"] = "NOTAUTH",
      ["9"] = "NOTZONE",
    },
  },
  ["dns_page"] = {
    ["dns_breakdown"] = "DNS Breakdown",
    ["dns_query_sent_distribution"] = "DNS Query Sent Distribution",
    ["dns_query_sent_vs_rcvd_distribution"] = "DNS Query Sent vs Rcvd Distribution",
    ["doh_dot_server_uses"] = "Uses",
    ["doh_dot_servers"] = "Contacted <A class='ntopng-external-link' href=\"https://en.wikipedia.org/wiki/DNS_over_HTTPS\" target=_blank>DoH <i class='fas fa-external-link-alt'></i></A> / <A class='ntopng-external-link' href=\"https://en.wikipedia.org/wiki/DNS_over_TLS\" target=_blank>DoT <i class='fas fa-external-link-alt'></i></A> Servers",
    ["error_replies"] = "Error Replies",
    ["note"] = "NOTE",
    ["note_dns_ratio"] = "Ideally the request vs reply DNS ratio should be 1 (one reply per request). When much lower than that then there are issues worth to be investigated as it means that the number of replies received is much lower than expected and this can indicate that we are using unresponsive DNS resolvers or that they are misconfigured (e.g. they have been move to another IP).",
    ["positive_replies"] = "Positive Replies",
    ["queries"] = "Queries",
    ["ratio"] = "Ratio",
    ["rcvd"] = "Rcvd",
    ["replies"] = "Replies",
    ["reply_breakdown"] = "Reply Breakdown",
    ["request_vs_reply"] = "Request vs Reply Ratio",
  },
  ["dscp_page"] = {
    ["statistics"] = "Precedence Classes",
    ["statistics_received"] = "Received",
    ["statistics_sent"] = "Sent",
  },
  ["ecs"] = {
    ["anomalous_termination"] = "Started after anomalous termination",
  },
  ["edit_check"] = {
    ["add_device_exclusion"] = "Add Authorized Devices",
    ["add_device_exclusion_list_notes"] = "A list of authorized MAC addresses, one per row",
    ["add_device_exclusion_message"] = "Authorized Devices List",
    ["add_device_exclusion_notes"] = "all devices set here are going to override the already know statuses (If a device was unauthorized, now is set to authorized)",
    ["author"] = "Author",
    ["authorized"] = "Authorized",
    ["category"] = "Category",
    ["comment"] = "Comment",
    ["delete_alert_exclusions"] = "Deleting alert exclusions will cause new alerts to be triggered again. Do you really want to delete alert exclusions for",
    ["delete_all_alert_exclusions"] = "Delete Check Exclusions",
    ["delete_all_alert_exclusions_message"] = "Do you really want to delete all configured alert exclusions?",
    ["delete_all_device_exclusions"] = "Delete Devices",
    ["delete_all_device_exclusions_message"] = "Do you really want to delete all configured excluded devices?",
    ["delete_device_exclusion"] = "Deleting device exclusions will cause new alerts to be triggered again. Do you really want to delete exclusions for",
    ["description"] = "Description",
    ["device"] = "Device",
    ["device_alias"] = "Device Alias",
    ["device_exclusion"] = "Device/MAC Address Tracking",
    ["device_exclusion_list"] = "Device/MAC Address Tracking List",
    ["device_name"] = "Device Name",
    ["device_status"] = "Status",
    ["domain_names"] = "Domain Names",
    ["edit_all_devices_status"] = "Edit All",
    ["edit_device_exclusion"] = "Edit Device",
    ["excluded_device"] = "Excluded Device",
    ["excluded_domain_name"] = "Excluded Domain Name",
    ["excluded_host"] = "Excluded Host",
    ["excluded_host_name"] = "Excluded Host Name",
    ["excluded_issuer_dn"] = "Excluded Issuer DN",
    ["exclusion_list"] = "Behavioural Check Exclusions",
    ["exclusion_list_host_x"] = "Check Exclusions: Host %{host}",
    ["hooks_config"] = "Hooks Configuration",
    ["issuer_dn"] = "IssuerDN",
    ["learning"] = "The Device/MAC Address Tracking is still learning the devices...",
    ["success_message"] = "The User Script <b>%{script_name}</b> configuration has been saved successfully!",
    ["tls_certificate"] = "TLS Cert Issuer",
    ["trigger_alert"] = "Trigger Disconnection Alert",
    ["trigger_device_disconnected_alert"] = "Trigger Disconnection Alert",
    ["trigger_device_disconnected_alert_descr"] = "(Note: Trigger an alert when the authorized devices disconnect from the interface)",
    ["unauthorized"] = "Unauthorized",
    ["device_exclusion_page_notes"] = {
      ["note_1"] = "<b>Status</b>:",
      ["sub_note_1"] = "<span class='badge bg-success'>Authorized</span> -> when the device is connecting, NO alert will be triggered;",
      ["sub_note_2"] = "<span class='badge bg-danger'>Unauthorized</span> -> when the device is connecting, an alert will be triggered.",
    },
    ["hooks_name"] = {
      ["5mins"] = "5 Minutes",
      ["all"] = "All",
      ["day"] = "Daily",
      ["hour"] = "Hourly",
      ["min"] = "Minute",
    },
  },
  ["endpoint_notifications"] = {
    ["actions"] = "Actions",
    ["add_new_endpoint"] = "Add New Endpoint",
    ["add_new_recipient"] = "Add New Recipient",
    ["add_to_all"] = "Bind to All Pools",
    ["alert_select_note"] = "Select alerts to deliver to the Recipient",
    ["alert_types"] = "Alert Types",
    ["alerts"] = "Alerts",
    ["alerts_filter_type"] = "Choose which alerts to receive, if by properties(e.g. severity) or by specific alert(s)",
    ["associated_to"] = "Bound To",
    ["associated_to_endpoints"] = "Bound to Endpoint",
    ["associated_to_recipients"] = "Bound to Recipient",
    ["bad_endpoint"] = "Failure retrieving the Endpoint configuration",
    ["bad_recipient_params"] = "Bad Recipient parameters",
    ["bind_to_num_pools"] = "Pools",
    ["bind_to_pools"] = "Bound to",
    ["categories"] = "Categories",
    ["category_note"] = "Specify which alert categories (Cybersecurity, System, ...) to deliver to the Recipient",
    ["checks"] = "Checks",
    ["create_endpoint_first"] = "Please create an endpoint first!",
    ["edit_endpoint"] = "Edit Endpoint",
    ["edit_endpoints"] = "Edit Endpoints",
    ["edit_recipient"] = "Edit Recipient",
    ["empty_endpoints"] = "No Endpoint defined.",
    ["empty_template"] = "This recipient has no paramaters to fill.",
    ["endpoint"] = "Endpoint",
    ["endpoint_config_already_existing"] = "There is already a config with that name!",
    ["endpoint_list"] = "Endpoints",
    ["endpoint_recipient_already_existing"] = "There is already a recipient with that name",
    ["enpoint_recipients_list"] = "Recipients",
    ["entities"] = "Entities",
    ["entity_note"] = "Specify which alert entity (Flow, SNMP, ...) to deliver to the Recipient",
    ["fill_pct"] = "Fill",
    ["get_users_recipient_failed"] = "Sorry, but the recipient users loading has failed. Please try later.",
    ["internal_error"] = "Internal error",
    ["message_am_hosts"] = "Filter alerts matching the selected Active Monitoring entries.",
    ["message_host_pools"] = "Filter alerts matching the selected pools, whenever possible (e.g. Flow and Host alerts).",
    ["min_severity"] = "Min. Severity",
    ["min_severity_note"] = "Specify the minimum severity of the alerts to receive",
    ["name"] = "Name",
    ["no_recipients"] = "<i class='text-danger fas fa-exclamation-triangle'></i> No Recipient configured",
    ["notifications"] = "Notifications",
    ["notifications_type"] = "Notifications Type",
    ["notifications_type_abbr"] = "Notif. Type",
    ["notifications_type_notes"] = "Specify which type of notifications the user want to send to this Recipient (e.g. if alerts is selected only alerts are going to be sent here).",
    ["num_drops"] = "Drops",
    ["num_uses"] = "Uses",
    ["recipient_alerts"] = "Checks",
    ["recipient_category"] = "Alert Categories",
    ["recipient_entities"] = "Alert Entities",
    ["recipient_list"] = "Recipients",
    ["recipient_name"] = "Name",
    ["recipient_select"] = "Endpoint",
    ["recipient_severity"] = "Minimum Severity",
    ["recipient_type"] = "Recipient List",
    ["recipient_users"] = "Pools using Recipient %{recipient}",
    ["remove_endpoint"] = "Delete Endpoint",
    ["remove_endpoint_message"] = "Do you really want to delete '%{endpoint}' notification endpoint? <span class='count'>%{recipients_count} recipient(s) will be <b>DELETED</b> as well.</span>",
    ["remove_recipient"] = "Delete Recipient",
    ["remove_recipient_message"] = "Do you really want to delete '%{recipient}' recipient?",
    ["select_alert"] = "Select at least an Alert",
    ["select_type"] = "Select an Endpoint Type",
    ["server_error"] = "Something went wrong. Try later.",
    ["silence_mul_alerts"] = "Silence Dup. Alerts",
    ["silence_multiple_alerts"] = "Silence Duplicated Alerts",
    ["silence_multiple_alerts_notes"] = "If silenced, the same alert is not delivered to the recipient more than 1 time per hour",
    ["status"] = "Node Status",
    ["test_recipient"] = "Check",
    ["testing_recipient"] = "Testing the recipient",
    ["time_since_last_use"] = "Last Use",
    ["timed_out"] = "The recipient test has timed out!",
    ["type"] = "Type",
    ["used_by_recipients"] = "Used by Recipients",
    ["working_recipient"] = "Test successful!",
    ["zero_users_recipient"] = "There are no pools using this recipient. Add pools from the %{link} page.",
    ["factory_reset"] = {
      ["body"] = "Are you sure to reset the <b>%{reset_element}</b>?<br>Resetting to Factory Default <b>you will permentaly lose all the %{reset_element} configured</b> yet.",
      ["title"] = "Reset Configuration: %{reset_element}",
    },
    ["hints"] = {
      ["bind_pools"] = {
        ["body"] = "Last step! Bind recipients to pools to start delivering alerts to them.",
        ["title"] = "Bind Recipient",
      },
      ["create_endpoint"] = {
        ["action"] = "Create",
        ["body"] = "Create an <a target='_blank' href='%{link}'>endpoint</a> to start delivering alerts to the outside.",
        ["title"] = "Create an Endpoint",
      },
      ["create_recipients"] = {
        ["body"] = "Create new <a target='_blank' href='%{link}'>recipients</a> to start delivering alerts to them.",
        ["title"] = "Create Recipients",
      },
    },
    ["recipients"] = {
      ["cc"] = "CC",
      ["email_recipient"] = "Email Recipient",
    },
    ["severities"] = {
      ["alert"] = "Alert",
      ["critical"] = "Critical",
      ["debug"] = "Debug",
      ["emergency"] = "Emergency",
      ["error"] = "Error",
      ["info"] = "Info",
      ["notice"] = "Notice",
      ["warning"] = "Warning",
    },
    ["validation"] = {
      ["abort_add_endpoint"] = "Abort add of new endpoint?",
      ["abort_add_recipient"] = "Abort add of new endpoint recipient?",
      ["abort_edit_endpoint"] = "Abort edit of the endpoint?",
      ["abort_edit_recipient"] = "Abort edit of the endpoint recipient?",
    },
  },
  ["entity_thresholds"] = {
    ["black_hole_contacts_description"] = "Trigger an alert when a host contacts too many blackholed hosts.",
    ["black_hole_contacts_title"] = "Host Scanner Blackhole Contacts",
    ["dns_flood_description"] = "Trigger an alert when the number of sent/received DNS Flows/sec exceeds the threshold",
    ["dns_flood_title"] = "DNS Flood",
    ["dns_request_reply_ratio_description"] = "Trigger an alert when the replies/requests ratio is below the threshold",
    ["dns_request_reply_ratio_title"] = "DNS Repls. / Reqs. Ratio",
    ["fin_scan_description"] = "Trigger an alert when the number of sent/received FINs/min (with no response) exceeds the threshold",
    ["fin_scan_title"] = "FIN Scan",
    ["flow_flood_description"] = "Trigger an alert when the new client/server Flows/sec exceeds the threshold",
    ["flow_flood_title"] = "Flow Flood",
    ["flow_victim_description"] = "Trigger an alert when the new server Flows/sec exceeds the threshold",
    ["flow_victim_title"] = "Flow Flood Victim",
    ["http_request_reply_ratio_description"] = "Trigger an alert when the replies/requests ratio is below the threshold",
    ["http_request_reply_ratio_title"] = "HTTP Repls. / Reqs. Ratio",
    ["icmp_flood_description"] = "Trigger an alert when in the last minute, the number of sent/received ICMP packets/sec exceeds the threshold",
    ["icmp_flood_title"] = "ICMP Flood",
    ["network_issue_description"] = "Trigger an alert in case of Network issues including retransmissions, high number of fragments and packet loss",
    ["network_issue_title"] = "Network Issues",
    ["rst_scan_description"] = "Trigger an alert when the number of sent/received RSTs/min (with no response) exceeds the threshold",
    ["rst_scan_title"] = "RST Scan",
    ["rx_only_host_scan_description"] = "Trigger an alert when a host RX-only is under scan attack.",
    ["rx_only_host_scan_title"] = "RX-only Host Scan",
    ["scan_detection_description"] = "Trigger an alert when a scan (host/port) is detected when the number of incomplete TCP/UDP flows exceeds the specified threshold.",
    ["scan_detection_title"] = "Scan Detection",
    ["snmp_flood_description"] = "Trigger an alert when the number of sent/received SNMP Flows/sec exceeds the threshold",
    ["snmp_flood_title"] = "SNMP Flood",
    ["syn_flood_description"] = "Trigger an alert when the number of sent/received SYNs/sec exceeds the threshold",
    ["syn_flood_title"] = "SYN Flood",
    ["syn_scan_description"] = "Trigger an alert when the number of sent/received SYNs/min (with no response) exceeds the threshold",
    ["syn_scan_title"] = "SYN Scan",
    ["syn_scan_victim_description"] = "Trigger an alert when the number of received SYNs/min (with no response) exceeds the threshold",
    ["syn_scan_victim_title"] = "SYN Scan Victim",
    ["syn_victim_description"] = "Trigger an alert when the number of received SYNs/sec exceeds the threshold",
    ["syn_victim_title"] = "SYN Flood Victim",
  },
  ["error_page"] = {
    ["go_back"] = "Go Back",
    ["greeting"] = "An error has been detected",
    ["presence"] = "You're not supposed to be here!",
  },
  ["event_exporters"] = {
    ["event_device_x"] = "Event Exporter %{device}",
    ["event_exporter_ip"] = "Event Exporter IP",
    ["event_exporters"] = "Event Exporters",
  },
  ["export_data"] = {
    ["export_json_data"] = "Export JSON Data",
    ["note_active_hosts"] = "Only active hosts are returned.",
    ["note_maximum_number"] = "The maximum number of downloadable hosts is 32,768.",
  },
  ["exporters_page"] = {
    ["flow_drops_criteria"] = "Total Drops",
    ["flow_volume_criteria"] = "Total Flows",
  },
  ["external_stats"] = {
    ["capture_drops"] = "Dropped Packets",
    ["capture_packets"] = "Captured Packets",
    ["signatures_failed"] = "Signatures Failed",
    ["signatures_loaded"] = "Signatures Loaded",
    ["title"] = "External Statistics",
  },
  ["field_units"] = {
    ["bytes"] = "Bytes",
    ["contacts"] = "Contacts",
    ["exceptions"] = "Exceptions",
    ["fin_min"] = "FINs/min",
    ["flow_sec"] = "Flows/sec",
    ["flows"] = "Flows",
    ["hosts"] = "Hosts",
    ["icmp_flow_sec"] = "ICMP Pkts/sec",
    ["inc_min"] = "Incomplete Flows/min",
    ["macs"] = "MACs",
    ["mbits"] = "Mbps",
    ["packets"] = "Packets",
    ["per_host_score"] = "Max Score per Host",
    ["percentage"] = "%",
    ["rst_min"] = "RSTs/min",
    ["score"] = "Score",
    ["seconds"] = "sec",
    ["syn_min"] = "SYNs/min",
    ["syn_sec"] = "SYNs/sec",
  },
  ["flow_alerts_explorer"] = {
    ["alert_tcp_no_data_exchanged_description"] = "TCP flow ended with no data exchanged past 3WH",
    ["alert_tcp_no_data_exchanged_title"] = "TCP No Data Exchanged",
    ["alert_unexpected_dhcp_title"] = "Unexpected DHCP server found",
    ["alert_unexpected_dns_title"] = "Unexpected DNS server",
    ["alert_unexpected_ntp_title"] = "Unexpected NTP server found",
    ["alert_unexpected_smtp_title"] = "Unexpected SMTP server found",
    ["alert_zero_tcp_window_title"] = "TCP Zero Window",
    ["by_target_port"] = "By Target Port",
    ["flow_alert_origin"] = "Alert Origin",
    ["flow_alert_target"] = "Alert Target",
    ["label"] = "Flow Alerts Explorer",
    ["origins"] = "Origins",
    ["search"] = "Search Flow Alerts",
    ["status_unexpected_dhcp_description"] = "Unexpected DHCP server found: %{server}",
    ["status_unexpected_dns_description"] = "Unexpected DNS server: %{server}",
    ["status_unexpected_ntp_description"] = "Unexpected NTP server found: %{server}",
    ["status_unexpected_smtp_description"] = "Unexpected SMTP server found: %{server}",
    ["status_zero_tcp_window_description"] = "Reported TCP Zero Window",
    ["summary_cli2srv"] = "Total Origin to Target Traffic",
    ["summary_n_origins"] = "Total Origins",
    ["summary_n_targets"] = "Total Targets",
    ["summary_srv2cli"] = "Total Target to Origin Traffic",
    ["summary_total"] = "Total Flow Alerts",
    ["targets"] = "Targets",
    ["type_alerts_by_type"] = "Flow Alerts By Type",
    ["type_explorer"] = "Type Explorer",
    ["visual_explorer"] = "Visual Explorer",
  },
  ["flow_checks"] = {
    ["allowed_server_names_description"] = "Comma separated values of allowed server IPs. Example: 173.194.76.109,my.example.com",
    ["allowed_servers_description"] = "Comma separated values of allowed server IPs. Example: 173.194.76.109,52.97.232.242",
    ["allowed_servers_title"] = "Allowed Servers",
    ["application_detected"] = "Application Detected",
    ["asn_behavior_check_list"] = "ASN to analyze",
    ["asn_behavior_check_list_example"] = "A list of ASN (name or ID) to analyze, separated by commas",
    ["callback"] = "User Script",
    ["callback_config"] = "Configuration",
    ["callback_elapsed_time"] = "Execution Time",
    ["callback_elapsed_time_avg"] = "Flows/sec",
    ["callback_enabled"] = "Enabled",
    ["callback_function"] = "Hook",
    ["callback_function_duration"] = "Duration",
    ["callback_function_duration_fmt_long"] = "%{num_calls} Calls in %{time} [%{speed} Calls/sec]",
    ["callback_function_duration_fmt_short"] = "%{time}",
    ["callback_function_num_flows"] = "Flows",
    ["callback_function_throughput"] = "Processing Speed",
    ["callback_latest_run"] = "Latest Run",
    ["dns_esclusion_list"] = "Excluded Domains",
    ["dns_esclusion_list_example"] = "A list of domains to exclude from invalid queries, separated by commas",
    ["idle"] = "Idle",
    ["iec104_command_description"] = "Trigger an alert when a command to/from command or measure to/from command IEC transition is detected",
    ["iec104_command_title"] = "IEC Invalid Command Transition",
    ["iec104_description"] = "Trigger an alert when an invalid IEC transition is detected",
    ["iec104_title"] = "IEC Invalid Transition",
    ["iec104_unexpected_type_id_allowed_type_ids_description"] = "Comma separated values of IEC 60870-5-104 TypeIDs. Example: 1,2,3,4",
    ["iec104_unexpected_type_id_allowed_type_ids_title"] = "Allowed TypeIDs",
    ["iec104_unexpected_type_id_description"] = "Trigger an alert when an unexpected TypeID is detected in IEC 104 protocol",
    ["iec104_unexpected_type_id_title"] = "IEC Unexpected TypeID",
    ["l7_behavior_check_list"] = "Application to analyze",
    ["l7_behavior_check_list_example"] = "A list of Application (name or ID) to analyze, separated by commas",
    ["last_calls_per_sec"] = "Last Calls/sec",
    ["last_duration"] = "Last Duration",
    ["last_num_calls"] = "Last Num Calls",
    ["low_goodput_description"] = "Trigger an alert when flow goodput is too low",
    ["low_goodput_title"] = "Low Goodput",
    ["modbus_description"] = "Trigger an alert when an invalid ModbusTCP transition is detected",
    ["modbus_invalid_function_code"] = "ModbusTCP Invalid Function Code",
    ["modbus_invalid_transition"] = "ModbusTCP Invalid Transition",
    ["modbus_title"] = "ModbusTCP Invalid Transition",
    ["modbus_too_many_exceptions"] = "ModbusTCP Too Many Exceptions",
    ["modbus_too_many_exceptions_description"] = "Trigger an alert when a flow reports a number of exceptions exceeding the specified threshold",
    ["modbus_too_many_exceptions_title"] = "ModbusTCP Too Many Exceptions",
    ["modbus_unexpected_function_code_description"] = "Trigger an alert when an unexpected ModbusTCP Function code is detected",
    ["modbus_unexpected_function_code_ids_description"] = "Comma separated values of ModbusTCP Function Codes. Example: 1,2,3,4",
    ["modbus_unexpected_function_code_ids_title"] = "Allowed Function Codes",
    ["modbus_unexpected_function_code_title"] = "ModbusTCP Unexpected Function Code",
    ["network_behavior_check_list"] = "Networks to analyze",
    ["network_behavior_check_list_example"] = "A list of Networks to analyze, separated by commas",
    ["no_callbacks_available"] = "No callbacks available.",
    ["no_callbacks_available_disabled_alerts"] = "No callbacks available. Callbacks require alerts to be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>",
    ["no_callbacks_defined"] = "No callbacks found",
    ["note_add_custom_scripts"] = "%{product} looks for custom scripts in these <a href=\"%{url}\"> <i class=\"fas fa-folder\"></i> directories</a>.",
    ["note_create_custom_scripts"] = "Documentation to create custom scripts for the execution of callbacks is available at the following <a class='ntopng-external-link' href=\"%{url}\">link <i class=\"fas fa-external-link-alt\"></i></a>.",
    ["note_flow_application_detected"] = "\"Application Detected\" callbacks are executed right after the detection of the application. This occurs within the first 12 packets of a flow for packet interfaces or immediately after a flow has been received for ZMQ interfaces.",
    ["note_flow_idle"] = "\"Idle\" callbacks are executed when a flow has terminated its activity and it has gone idle.",
    ["note_flow_lifecycle"] = "Callbacks are executed at certain moments in the lifecycle of a flow.",
    ["note_flow_periodic_update"] = "\"Periodic Update\" callbacks are executed periodically after a flow has been active for more than five minutes.",
    ["note_flow_staus_changed"] = "\"Status Changed\" callbacks are executed every time there is a status change in the flow. For example when connection issues such as retransmissions are seen.",
    ["note_scripts_list"] = "A full list of available %{product} scripts can be found in the <a href=\"%{url}\">scripts</a> page.",
    ["notes"] = "NOTES",
    ["periodic_update"] = "Periodic Update",
    ["rare_destination_description"] = "Rare/unusual destination (hostname) detected.",
    ["rare_destination_title"] = "Rare Destination",
    ["status_changed"] = "Status Changed",
    ["status_zero_tcp_window_description"] = "Reported TCP Zero Window",
    ["status_zero_tcp_window_description_c2s"] = "Reported client TCP zero window",
    ["status_zero_tcp_window_description_s2c"] = "Reported server TCP zero window ",
    ["tcp_no_data_exchanged_description"] = "Trigger an alert when a TCP flow ends with no data exchanged",
    ["tcp_no_data_exchanged_title"] = "TCP No Data Exchanged",
    ["unexpected_dhcp_description"] = "Trigger an alert when not allowed DHCP server is detected",
    ["unexpected_dhcp_title"] = "Unexpected DHCP",
    ["unexpected_dns_description"] = "Trigger an alert when not allowed DNS server is detected",
    ["unexpected_dns_title"] = "Unexpected DNS server",
    ["unexpected_ntp_description"] = "Trigger an alert when not allowed NTP server is detected",
    ["unexpected_ntp_title"] = "Unexpected NTP server",
    ["unexpected_smtp_description"] = "Trigger an alert when not allowed SMTP server is detected",
    ["unexpected_smtp_title"] = "Unexpected SMTP server",
    ["vlan_inclusion_list"] = "Included VLANs",
    ["vlan_inclusion_list_description"] = "Comma separated list of VLAN IDs. This alert won't be triggered for flow of VLANs outside this list (0 value represents untagged flows).",
    ["zero_tcp_window_description"] = "Trigger an alert when for TCP flows with window set to zero",
    ["zero_tcp_window_title"] = "TCP Zero Window",
  },
  ["flow_checks_config"] = {
    ["blacklist_client_contact"] = "Blacklisted Client Contact",
    ["blacklist_client_contact_description"] = "Trigger an alert when a remote blacklisted host contacts a local host",
    ["blacklist_server_contact"] = "Blacklisted Server Contact",
    ["blacklist_server_contact_description"] = "Trigger an alert when a localhost contacts a remote blacklisted host",
    ["blacklisted"] = "Blacklisted Flow",
    ["blacklisted_description"] = "Trigger an alert when a blacklisted host or domain is detected",
    ["broadcast_non_udp_traffic_description"] = "Trigger an alert when an host contacts a Broadcast address using a non-UDP protocol",
    ["broadcast_non_udp_traffic_title"] = "Broadcast Non-UDP Traffic",
    ["connection_failed_description"] = "Trigger an alert when detecting a TCP connection with no server answer",
    ["connection_failed_title"] = "TCP With No Answer",
    ["custom_lua_script"] = "Flow User Check Script",
    ["custom_lua_script_description"] = "Trigger a flow alert based on a custom Lua user script executed (protocol detected, periodic update, flow end) on active flows",
    ["data_exfiltration"] = "ICMP Data Exfiltration",
    ["data_exfiltration_description"] = "Trigger alerts when a possible ICMP data exfiltration activity is detected",
    ["desktop_or_file_sharing_session"] = "Desktop/File Sharing",
    ["desktop_or_file_sharing_session_description"] = "Trigger an alert when a Desktop or File sharing session is detected",
    ["dev_proto_not_allowed"] = "Device Application Not Allowed",
    ["dev_proto_not_allowed_description"] = "Trigger an alert when an unusual application is detected for a device. Rules can be configured",
    ["dev_proto_not_allowed_nedge_description"] = "Trigger an alert when a not allowed application is detected for a <i>Not Assigned</i> device. Policies can be configured",
    ["dns_data_exfiltration"] = "DNS Data Exfiltration",
    ["dns_data_exfiltration_description"] = "Trigger alerts when a DNS data exfiltration activity is detected",
    ["elephant_flows"] = "Elephant Flows",
    ["elephant_flows_description"] = "Trigger an alert when a flow exchanges more than the configured bytes volume. The Remote to Local direction indicates traffic received by a local host from a remote host.",
    ["ext_alert"] = "External Alert",
    ["ext_alert_description"] = "Receives flow alerts from external endpoints (e.g. Suricata)",
    ["flow_reset_description"] = "Trigger an alert when a TCP flow is reset.",
    ["flow_reset_title"] = "TCP Flow Reset",
    ["flow_risk"] = "Flow Risk",
    ["flow_risk_description"] = "Trigger alerts on the basis of detected nDPI flow risks",
    ["flow_risk_list"] = "nDPI flow risks:",
    ["http_obsolete_server"] = "HTTP Obsolete Server",
    ["http_obsolete_server_description"] = "Trigger an alert when an obsolete HTTP server is contacted",
    ["invalid_dns_query"] = "Invalid DNS Query",
    ["invalid_dns_query_description"] = "Trigger an alert when a possibly malicious DNS query is detected",
    ["lateral_movement_description"] = "Trigger an alert when an unexpected service is detected. Enable traffic behaviour preference in order for this script to operate.",
    ["lateral_movement_title"] = "Service Map Lateral Movement Detection",
    ["long_lived"] = "Long Lived",
    ["long_lived_description"] = "Trigger an alert when a flow lasts more than the configured duration",
    ["malicious_ja3"] = "Malicious JA3 Fingerp.",
    ["malicious_ja3_description"] = "Trigger an alert when a JA3 of the TLS connection is considered suspicious",
    ["malicious_sha1_certificate"] = "Malicious JA3 SHA1 Cert.",
    ["malicious_sha1_certificate_description"] = "Trigger an alert when a SHA1 certificate of the TLS connection is found on a blacklist",
    ["malicious_signature"] = "Malicious JA3 Signature",
    ["malicious_signature_description"] = "Trigger an alert when a blacklisted JA3 signature is detected",
    ["ndpi_malware_host_contacted"] = "Malware Host Contacted",
    ["ndpi_malware_host_contacted_alert_descr"] = "Client or server contacted a malware host",
    ["ndpi_malware_host_contacted_description"] = "Trigger an alert when nDPI detects a contact towards a malware host",
    ["ndpi_periodic_flow"] = "Periodic Flow",
    ["ndpi_periodic_flow_description"] = "Trigger an alert when nDPI detects a periodic flow",
    ["nedge_blocked"] = "Blocked Flows",
    ["nedge_blocked_description"] = "Trigger an alert when a flow is blocked due to the configured policies",
    ["no_input"] = "No configuration necessary",
    ["not_purged"] = "Not Purged",
    ["not_purged_description"] = "Detects bugs in the flow purge logic",
    ["old_tls_version"] = "Old TLS Version",
    ["old_tls_version_description"] = "Trigger an alert when an old (and possibly unsecure) TLS version is detected",
    ["periodicity_changed_description"] = "Trigger an alert when a periodic service changes. Enable traffic behaviour preference in order for this script to operate.",
    ["periodicity_changed_title"] = "Periodicity Changed",
    ["possible_bot_flow_description"] = "Trigger an alert when the server is probably a Bot",
    ["possible_bot_flow_title"] = "Possible Bot",
    ["potentially_dangerous_protocol"] = "Potentially dangerous protocol",
    ["potentially_dangerous_protocol_description"] = "Trigger an alert when a potentially dangerous protocol is detected",
    ["rare_destination"] = "Rare Destination",
    ["remote_to_local_insecure_flow_description"] = "Trigger an alert when a remote Server contacts a local Host using an insecure protocol",
    ["remote_to_local_insecure_flow_title"] = "Remote to Local Insecure Flow",
    ["remote_to_local_insecure_proto_description"] = "Trigger an alert when a remote Server contacts a local Host using an insecure protocol",
    ["remote_to_local_insecure_proto_title"] = "Remote to Local Insecure Protocol",
    ["remote_to_remote"] = "Remote to Remote Flow",
    ["remote_to_remote_description"] = "Trigger an alert when a flow has remote hosts as client and server",
    ["risky_asn"] = "Risky ASN",
    ["risky_asn_description"] = "Trigger an alert when traffic exchanged with ASN that are considered risky is detected",
    ["risky_domain"] = "Risky Domain",
    ["risky_domain_description"] = "Trigger an alert when traffic exchanged with domains that are considered risky is detected",
    ["score"] = "Flow Score",
    ["tcp_connection_no_answer_descr"] = "TCP connection with no answer",
    ["tcp_connection_no_answer_description"] = "Trigger an alert when a Client Host tries to TCP connect to a Server Host but it does not receive an answer",
    ["tcp_connection_no_answer_title"] = "No Answer",
    ["tcp_connection_refused"] = "TCP Connection Refused",
    ["tcp_connection_refused_description"] = "Trigger an alert when a connection refused is detected (Reset response sent from the server)",
    ["tcp_packets_issues"] = "TCP Packets Issues",
    ["tcp_packets_issues_alert"] = "Detected an high percentage of packets %{type}: %{value}% on a threshold of %{threshold}%",
    ["tcp_packets_issues_description"] = "Detect TCP retransmissions, out of order and packet lost issues and whenever the numbers exceeds the treshold an alert is going to be triggered",
    ["tls_cert_expired"] = "TLS Cert Expired",
    ["tls_cert_expired_description"] = "Trigger an alert when an expired TLS certificate is detected",
    ["tls_cert_mismatch"] = "TLS Cert Issues",
    ["tls_cert_mismatch_alert_descr"] = "TLS certificate does not match the accessed hostname",
    ["tls_cert_mismatch_description"] = "Trigger an alert when a mismatched TLS certificate is detected",
    ["tls_cert_selfsigned"] = "TLS Cert Self-signed",
    ["tls_cert_selfsigned_description"] = "Trigger an alert when an self-signed TLS certificate is detected",
    ["tls_fatal_alert"] = "TLS Fatal Alert",
    ["tls_fatal_alert_description"] = "Trigger an alert when a fatal alert is detected in a TLS flow",
    ["tls_suspicious_extension"] = "TLS Susp. Extension",
    ["tls_suspicious_extension_description"] = "Trigger an alert when the domain name (SNI extension) is not printable and thus it is a problem",
    ["tls_uncommon_alpn"] = "TLS Uncommon ALPN",
    ["tls_uncommon_alpn_description"] = "Trigger an alert when the ALPN (it indicates the protocol carried into this TLS flow, for instance HTTP/1.1) is uncommon with respect to the list of expected values",
    ["tls_unsafe_ciphers"] = "TLS Unsafe Ciphers",
    ["tls_unsafe_ciphers_description"] = "Trigger an alert when unsafe TLS ciphers are detected",
    ["unidirectional_traffic"] = "Unidirectional Flow",
    ["unidirectional_traffic_description"] = "Trigger an alert when a unidirectional flow is detected",
    ["vlan_bidirectional_traffic"] = "VLAN Bidirectional Traffic",
    ["vlan_bidirectional_traffic_description"] = "Trigger an alert when a bidirectional flow member of one included VLAN, with remote server address, is detected",
    ["web_mining"] = "Web Mining",
    ["web_mining_description"] = "Toggle alerts generated when traffic from/to hosts known to perform cryptocurrencies mining is detected",
  },
  ["flow_details"] = {
    ["acceptable_label"] = "Acceptable",
    ["actual_peak_throughput"] = "Actual / Peak / Average Throughput",
    ["additional_alert_type"] = "Other Issues",
    ["additional_flow_elements"] = "Additional Flow Elements",
    ["alert_type"] = "Flow Status",
    ["alerted_flows"] = "Alerted Flows",
    ["alerted_flows_severity"] = "Alerted Flows Severity",
    ["application_latency"] = "Application Latency",
    ["as_prev_next"] = "ASN Previous / Next",
    ["as_src_dst"] = "ASN [ Client / Server ]",
    ["average_cpu_load"] = "Average CPU Load",
    ["bittorrent_hash"] = "BitTorrent hash",
    ["blacklist"] = "Blacklist: \"%{blacklist}\"",
    ["blacklisted_flow"] = "Client, server or domain is blacklisted",
    ["blacklisted_flow_detailed"] = "Blacklisted %{who} [ Blacklist: \"%{blacklist}\" ]",
    ["broadcast_non_udp_traffic"] = "Broadcast Traffic using non-UDP protocol detected [Cli MAC: %{mac}] [Cli IP: %{ip}]",
    ["c_ip_addresses"] = "C IP Addresses",
    ["call_canceled"] = "Call Canceled",
    ["call_completed"] = "Call Completed",
    ["call_error"] = "Call Error",
    ["call_id"] = "Call-ID",
    ["call_initiator"] = "Call Initiator",
    ["call_quality_indicators"] = "Call Quality Indicators",
    ["call_started"] = "Call Started",
    ["call_state"] = "Call State",
    ["called_party"] = "Called Party",
    ["cancel_bye_failure_reason_cause"] = "Cancel/Bye/Failure Reason Cause",
    ["certificates_not_match"] = "Certificates don't match",
    ["client_container_information"] = "Client Container Information",
    ["client_process_information"] = "Client Process Information",
    ["client_requested"] = "Client Requested",
    ["client_tls_supported_versions"] = "Client Supported TLS Protocols",
    ["computed_as_tcp_window_size_rtt"] = "Computed as TCP Window Size / RTT",
    ["connection_failed_descr"] = "Host [ %{cli} ] is trying to talk with Host [ %{srv} ] but got no answer",
    ["container_id"] = "Container ID",
    ["could_not_add_host_to_category"] = "Could not add host \"%{host}\" to \"%{category}\".",
    ["custom_lua_script"] = "%{message}",
    ["dangerous_flows"] = "Dangerous Flows",
    ["data_exfiltration"] = "ICMP Data Exfiltration",
    ["desirable_label"] = "Desirable",
    ["dns_data_exfiltration"] = "Too many packets exchanged in this flow",
    ["dns_invalid_query"] = "Invalid DNS query",
    ["dns_query"] = "DNS Query",
    ["docker"] = "Docker",
    ["docker_name"] = "Name",
    ["drop_flow_traffic_btn"] = "Drop Flow Traffic",
    ["dropped_packets"] = "Dropped Packets",
    ["dtmf_tones_sent"] = "DTMF tones sent during the call",
    ["dump_flow_traffic"] = "Dump Flow Traffic",
    ["elephant_exceeded"] = "[Local to remote: %{l2r}][Remote to Local: %{r2l}]",
    ["elephant_flow"] = "Elephant Flow",
    ["elephant_flow_descr"] = "Elephant flows are those that transfer more than a certain configured amount of data. Administrators can configure elephant flows from the preferences.",
    ["elephant_flow_l2r"] = "Elephant Flow (Local to Remote Traffic)",
    ["elephant_flow_r2l"] = "Elephant Flow (Remote to Local Traffic)",
    ["entropy"] = "Entropy (Initial Flow Bytes)",
    ["error_and_higher"] = "Error and Higher",
    ["existing_rules_note"] = "Existing rules can be found at the <a href=\"%{url}\">%{name}</a> page.",
    ["external_alert"] = "Detected %{scope} alert: %{msg} [%{maker}]",
    ["first_last_flow_sequence"] = "First / Last Flow Sequence",
    ["flow_active_msg"] = "Flow is active.",
    ["flow_alerted"] = "Alert",
    ["flow_anomalies"] = "Detected Flow Risks",
    ["flow_blocked_by_bridge"] = "Flow blocked due to configured policies",
    ["flow_cannot_be_found_message"] = "This flow cannot be found.",
    ["flow_completed_msg"] = "Flow is closed.",
    ["flow_connecting_msg"] = "Flow is connecting.",
    ["flow_details"] = "Flow Details",
    ["flow_emitted"] = "Flow emitted when network interface was alerted",
    ["flow_issues"] = "Issues",
    ["flow_low_goodput"] = "Low goodput ratio [%{ratio}%%]",
    ["flow_marker"] = "Flow Marker",
    ["flow_peer_roles_inaccurate_msg"] = "Flow is active, however, the beginning of the flow has not been observed, thus peer roles (client/server) might be inaccurate.",
    ["flow_peers_client_server"] = "Flow Peers [ Client / Server ]",
    ["flow_quota"] = "Flow Quota",
    ["flow_reset_by_resetter_msg"] = "Flow reset by the %{resetter}.",
    ["flow_reset_msg"] = "This flow has been reset",
    ["flow_score"] = "Total Flow Score",
    ["flow_score_breakdown"] = "Score Category Breakdown",
    ["flow_shapers"] = "Flow Shapers",
    ["flow_traffic_is_dropped"] = "Flow Traffic is Dropped",
    ["forward"] = "Forward",
    ["gsm_cell_identifier"] = "GSM Cell Identifier",
    ["gsm_cell_lac"] = "GSM Cell LAC (Location Area Code)",
    ["historical_flow_details"] = "Historical Flow Details",
    ["host_successfully_added_to_category"] = "Host \"%{host}\" successfully added to the <a href=\"%{url}\">%{category}</a> category. Only new flows will be affected by the rule.",
    ["http_method"] = "HTTP Method",
    ["icmp_entropy"] = "ICMP Packets Entropy",
    ["icmp_entropy_diff"] = "Difference",
    ["icmp_entropy_min_max"] = "Min / Max",
    ["icmp_info"] = "ICMP Info",
    ["ids_alert"] = "Detected %{scope} alert: %{msg} [%{maker}]",
    ["iec104_latency"] = "Type I-S Ack Latency (Average / Std Dev)",
    ["iec104_mask"] = "<A class='ntopng-external-link' href=https://infosys.beckhoff.com/english.php?content=../content/1033/tcplclibiec870_5_104/html/tcplclibiec870_5_104_objref_overview.htm&id>TypeIDs <i class='fas fa-external-link-alt'></i></A>",
    ["iec104_msg_breakdown"] = "Messages Breakdown",
    ["iec104_msg_loss"] = "Messages Lost / Retransmissions",
    ["iec104_transitions"] = "Type ID Transitions",
    ["imsi"] = "IMSI (International mobile Subscriber Identity)",
    ["io_wait_time_percentage"] = "I/O Wait Time Percentage",
    ["ip_packet_analysis"] = "IP Packet Analysis",
    ["jitter"] = "Jitter",
    ["k8s"] = "Kubernetes",
    ["k8s_name"] = "Name",
    ["k8s_ns"] = "Namespace",
    ["k8s_pod"] = "Pod",
    ["known_proto_on_non_std_port"] = "Found known application on a non-standard port",
    ["longlived_exceeded"] = "Exceeding %{amount}",
    ["longlived_flow"] = "Long-Lived Flow",
    ["longlived_flow_descr"] = "Long-Lived flows are those that last more than a certain configured amount of time. Administrators can configure elephant flows from the preferences.",
    ["looks_like_idle_flow_message"] = "This looks like an <font color=red>idle flow</font> with periodic transmissions just to keep it alive.",
    ["lost_packets"] = "Lost Packets",
    ["low_goodput"] = "Low Goodput",
    ["malicious_ja3_signature"] = "Possibly Malicious %{cli_or_srv} Signature [JA3: <a href=\"%{url}\">%{signature}</a> %{icon}]",
    ["max_estimated_tcp_throughput"] = "Max (Estimated) TCP Throughput",
    ["max_packet_interarrival_time"] = "Max Packet Interarrival Time",
    ["mean_rtt"] = "Mean RTT",
    ["memory_actual_peak"] = "Memory Actual / Peak",
    ["mibehaving_flows"] = "Misbehaving Flows",
    ["modbus_exceptions"] = "Exceptions",
    ["modbus_function"] = "Function",
    ["modbus_function_codes"] = "Function Codes",
    ["modbus_register"] = "Register",
    ["modbus_registers"] = "Registers",
    ["modbus_transitions"] = "Function Code Transitions",
    ["modbus_uses"] = "Uses",
    ["normal"] = "Normal",
    ["not_recommended_label"] = "Not Recommended",
    ["notice_and_lower"] = "Notice and Lower",
    ["now_purged"] = "This flow has been purged from memory.",
    ["nsapi"] = "NSAPI",
    ["ongoing_call"] = "Ongoing Call",
    ["packet_inter_arrival_time"] = "Packet Inter-Arrival Time <br>[ Min / Avg / Max ]",
    ["payload_type"] = "Payload Type",
    ["potentially_dangerous_protocol"] = "Potentially Dangerous Protocol",
    ["process_information_report_warning"] = "Process information report is limited unless you use ntopng with <A HREF='%{url}'>nProbe</A> and the sprobe script",
    ["process_package"] = "Package Name",
    ["process_pid"] = "PID",
    ["process_pid_name"] = "Process PID/Name",
    ["profile_name"] = "Profile Name",
    ["pseudo_mos"] = "(Pseudo) MOS",
    ["purge_time"] = "Flow Idle Timeout: %{purge_time} sec <span title='A Flow is purged when no traffic is seen for the time set; to change it jump to the Flow Idle Timeout preferences. To set in combination with nProbe, set -d configuration option in nProbe' style='cursor: help;'><i class='fas fa-question-circle'></i></span> <a href='%{prefs_url}' target='_blank'><i class='fas fa-cog fa-sm'></i></a>",
    ["r_factor"] = "R-Factor",
    ["reach_connection_label"] = "Reach Connection",
    ["remote_to_remote"] = "Remote Client and Remote Server",
    ["response_code"] = "Response Code",
    ["reverse"] = "Reverse",
    ["round_trip_time"] = "Min / Max RTT",
    ["rtp_codecs"] = "RTP Codecs",
    ["rtp_flow"] = "RTP Flow",
    ["rtp_protocol_information"] = "RTP Protocol Information",
    ["rtp_stream_peers"] = "RTP Stream Peers",
    ["rtp_transit_in_out"] = "RTP Transit IN / OUT",
    ["rtt_breakdown"] = "RTT Time Breakdown",
    ["rtt_distance"] = "Client/Server Estimated Distance",
    ["rtt_jitter"] = "RTT Jitter",
    ["rule_type"] = "Rule Type",
    ["sac_service_area_code"] = "SAC (Service Area Code)",
    ["score_category_network"] = "Network",
    ["score_category_security"] = "Cybersecurity",
    ["server"] = "Server",
    ["server_container_information"] = "Server Container Information",
    ["server_name"] = "Server Name",
    ["server_process_information"] = "Server Process Information",
    ["sip_call_id"] = "SIP Call-ID",
    ["sip_protocol_information"] = "SIP Protocol Information",
    ["slow_application_header"] = "Slow Application Header",
    ["slow_data_exchange"] = "Slow Data Exchange",
    ["slow_tcp_connection"] = "Slow TCP Connection",
    ["son_of_father_process"] = "son of",
    ["ssh_signature"] = "SSH Signature",
    ["suspicious_client_device_protocol"] = "\"%{proto}\" traffic not allowed for the client according to its <a href=\"%{url}\">%{devtype} application policy</a>",
    ["suspicious_device_protocol"] = "Susp. Device Protocol",
    ["suspicious_server_device_protocol"] = "\"%{proto}\" traffic not allowed for the server according to its <a href=\"%{url}\">%{devtype} application policy</a>",
    ["sync_source_id"] = "Sync Source ID",
    ["tcp_connection_issues"] = "TCP Connection Issues",
    ["tcp_packet_analysis"] = "TCP Packet Analysis",
    ["tcp_severe_connection_issues"] = "Severe TCP Issues",
    ["throughput_trend"] = "Throughput Trend",
    ["tls_certificate"] = "TLS Certificate",
    ["tls_certificate_expired"] = "TLS Cert Expired",
    ["tls_certificate_invalid"] = "TLS Cert Invalid",
    ["tls_certificate_mismatch"] = "TLS Cert Mismatch",
    ["tls_certificate_selfsigned"] = "TLS Cert Self-signed",
    ["tls_certificate_validity"] = "TLS Cert Validity",
    ["tls_old_protocol_version"] = "Obsolete TLS Version",
    ["tls_server_names"] = "Server Names",
    ["tls_unsafe_ciphers"] = "Unsafe TLS Ciphers",
    ["tos"] = "<A class='ntopng-external-link' target='_blank' href='https://en.wikipedia.org/wiki/Differentiated_services'>DSCP <i class='fas fa-external-link-alt'></i></A> / <A class='ntopng-external-link' target='_blank' href='https://en.wikipedia.org/wiki/Explicit_Congestion_Notification'>ECN <i class='fas fa-external-link-alt'></i></A> [ Client / Server ]",
    ["traffic_info"] = "Traffic Info",
    ["unidirectional_traffic"] = "Unidirectional Traffic",
    ["unknown_status"] = "Unknown status (%{status})",
    ["url"] = "URL",
    ["user_agent"] = "User Agent",
    ["user_name"] = "User Name",
    ["vm_page_faults"] = "VM Page Faults",
    ["warning"] = "Warning",
    ["web_mining_detected"] = "The website is known for mining cryptocurrencies on client devices",
  },
  ["flow_devices"] = {
    ["active_sflow"] = "Active sFlow Exporters",
    ["all_device_ports"] = "All %{device} Ports",
    ["all_exporters"] = "All NetFlow/IPFIX Exporter Devices",
    ["all_flow_devices"] = "All Flow Exporters",
    ["all_sflow_devices"] = "All sFlow Exporters",
    ["collection"] = "Collection",
    ["curr_hosts"] = "Hosts",
    ["curr_throughput"] = "Throughput",
    ["duplex"] = "Duplex",
    ["exporter_devices"] = "NetFlow/IPFIX Exporters",
    ["exporter_ip"] = "Flow Exporter IP",
    ["exporter_list_per_obs"] = "Flow Exporter Devices per Obs. Point %{obs_point}",
    ["exporter_time_last_used"] = "Last Flow Received",
    ["exporter_type"] = "Export Type",
    ["exporters"] = "Flow Exp.",
    ["exporters_menu_entry"] = "Probes",
    ["flow_device_x"] = "<a href=\"%{url}\">Flow Exporter</a>: %{device}",
    ["flow_device_x_interface_y"] = "Flow Exporter %{device} / %{interface}",
    ["flow_exporter_ip"] = "Exporter IP",
    ["flow_exporters"] = "Flow Exporters",
    ["flow_ratio_snmp_instructions"] = "To enable the Flow/SNMP ratio, this flow probe must support SNMP and must be <a href='%{href}'>added</a> to the SNMP devices.",
    ["flow_ratio_timeseries_instructions"] = "To enable the Flow/SNMP ratio, <b>SNMP and Flow Probe timeseries</b> must be enabled.",
    ["flow_snmp_ratio"] = "Flow/SNMP Ratio",
    ["full_duplex"] = "Full-Duplex",
    ["half_duplex"] = "Half-Duplex",
    ["in_errors"] = "In Errors",
    ["interface_index"] = "Interface Index",
    ["interface_name"] = "Interface Name",
    ["netflow_ipfix"] = "NetFlow/IPFIX",
    ["note_condition_1"] = "Device %{device} supports SNMP and it has been configured in the <a href=\"%{url}\">SNMP</a> devices page",
    ["note_condition_2"] = "Charts are shown by enabling SNMP and Flow Probes timeseries under <A HREF=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</A>",
    ["note_observation_points_fields1"] = "Observation Points timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
    ["note_observation_points_fields2"] = "To check the way to configure a new observation point check <a class='ntopng-external-link' href=\"%{url}\"><i class=\"fas fa-external-link-alt\"></i> Here</a>. Restart is needed.",
    ["note_observation_points_fields3"] = "Throughput is updated with recently active traffic over the last minute.",
    ["note_snmp_device"] = "SNMP-related information is only shown when an SNMP device with the same IP of the Probe is found among the <a href=\"%{url}\">SNMP devices</a>.",
    ["note_zmq_fields3"] = "sFlow probes are determined using sFlow field deviceIP received via ZMQ (topic 'counter')",
    ["note_zmq_fields4"] = "sFlow probes interfaces are determined using field ifIndex received via ZMQ (topic 'counter')",
    ["nprobe_instances"] = "nProbe Instances",
    ["nprobe_interface"] = "IfName (nProbe)",
    ["nprobe_version"] = "Version (nProbe)",
    ["ntopng_interface"] = "IfName (ntopng)",
    ["observation_point"] = "Observation Point",
    ["observation_point_x"] = "Observation Point %{observation_point}",
    ["observation_points"] = "Observation Points",
    ["out_errors"] = "Out Errors",
    ["packet"] = "Packet",
    ["probes_overview"] = "Probes Overview",
    ["promisc"] = "Promisc",
    ["ratio_not_ready"] = "Computing flow ratio...",
    ["remember_counter_ratio"] = "The Counters/SNMP Ratio can be enabled following these steps:",
    ["remember_ratio"] = "To enable Flow/SNMP Ratio please make sure that:",
    ["sflow"] = "sFlow",
    ["sflow_device_x"] = "sFlow Exporter %{device}",
    ["sflow_snmp_ratio"] = "Counters/SNMP Ratio",
    ["sflow_snmp_ratio_descr"] = "The Counters/SNMP Ratio is calculated by dividing the total interface traffic obtained using sFlow counter samples, by the total traffic of the same interface read via SNMP over the latest 30 minutes",
    ["snmp_description"] = "SNMP Description",
    ["snmp_devmodel"] = "SNMP Device Model",
    ["snmp_devname"] = "SNMP Device Name",
    ["snmp_ifindex"] = "SNMP Index",
    ["snmp_ifname"] = "SNMP Interface",
    ["snmp_location"] = "SNMP Location",
    ["snmp_no_device_found"] = "No matching SNMP device found",
    ["snmp_polling"] = "Flow/SNMP ratio needs at least 30 minutes of SNMP and flow data",
    ["snmp_ratio"] = "Flow/SNMP Ratio",
    ["snmp_ratio_descr"] = "The Flow/SNMP Ratio is calculated by dividing the total interface traffic obtained using flows, by the total traffic of the same interface read via SNMP. As in flow-based analysis non-IP and layer 2 headers are not accounted, <br>typical ratio values are between 0.8 and 0.9 (i.e. 0.9 means that 90%% of the received traffic as observed via SNMP has been reported in flows).<br>Ratio is computed using the traffic over the latest 5 minutes, as periodic SNMP walks are performed at 5-minute intervals. Ratio is only computed when the following conditions are met",
    ["this_page_contains_couters"] = "This page contains interface counters as they have been collected via sFlow. If SNMP is configured, you can also see the <A HREF=\"%{url}\">SNMP view</A> of this device",
    ["timeseries_descr"] = "Flow probes timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
    ["tot_bytes"] = "Total Bytes",
    ["tot_flows"] = "Total Flows",
    ["tot_traffic"] = "Traffic",
    ["version"] = "Version",
  },
  ["flow_fields_description"] = {
    ["appl_latency_ms"] = "Application latency (msec), a.k.a. server response time",
    ["application_id"] = "Application Id",
    ["application_name"] = "Application Name",
    ["biflow_direction"] = "1=initiator, 2=reverseInitiator",
    ["bittorrent_hash"] = "BitTorrent hash",
    ["client_nw_latency_ms"] = "Network RTT/2 client <-> nprobe (msec)",
    ["community_id"] = "Community ID",
    ["cumulative_icmp_type"] = "Cumulative OR of ICMP type packets",
    ["device_name"] = "Device Name",
    ["dhcp_client_ip"] = "DHCP assigned client IPv4 address",
    ["dhcp_client_mac"] = "MAC of the DHCP client",
    ["dhcp_client_name"] = "DHCP client name",
    ["dhcp_message_type"] = "DHCP message type",
    ["dhcp_remote_id"] = "DHCP agent remote Id",
    ["dhcp_subscriber_id"] = "DHCP subscriber Id",
    ["diameter_clr_cancel_type"] = "DIAMETER Cancellation Type",
    ["diameter_clr_flags"] = "DIAMETER CLR Flags",
    ["diameter_exp_res_result_code"] = "DIAMETER Response Experimental Result Code",
    ["diameter_exp_res_vendor_id"] = "DIAMETER Response Experimental Result Vendor Id",
    ["diameter_hop_by_hop_id"] = "DIAMETER Hop by Hop Identifier",
    ["diameter_req_msg_type"] = "DIAMETER Request Msg Type",
    ["diameter_req_origin_host"] = "DIAMETER Origin Host Request",
    ["diameter_req_user_name"] = "DIAMETER Request User Name",
    ["diameter_rsp_msg_type"] = "DIAMETER Response Msg Type",
    ["diameter_rsp_origin_host"] = "DIAMETER Origin Host Response",
    ["diameter_rsp_result_code"] = "DIAMETER Response Result Code",
    ["direction"] = "Flow direction [0=src->dst, 1=dst->src]",
    ["dns_num_answers"] = "DNS # of returned answers",
    ["dns_query"] = "DNS query",
    ["dns_query_id"] = "DNS query transaction Id",
    ["dns_query_type"] = "DNS query type (e.g. 1=A, 2=NS..)",
    ["dns_response"] = "DNS response(s)",
    ["dns_ret_code"] = "DNS return code (e.g. 0=no error)",
    ["dns_ttl_answer"] = "TTL of the first A record (if any)",
    ["dns_tx_id"] = "DNS Transaction ID",
    ["dot1qCustomerVlanId"] = "dot1Q Customer VLAN Id",
    ["dot1q_dst_vlan"] = "Destination VLAN (outer VLAN in QinQ)",
    ["dot1q_src_vlan"] = "Source VLAN (outer VLAN in QinQ)",
    ["downstream_session_id"] = "Downstream session identifier (e.g. L2TP) or 0 if unknown",
    ["downstream_tunnel_id"] = "Downstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
    ["dst_as"] = "Destination BGP AS",
    ["dst_as_map"] = "Organization name for DST_AS",
    ["dst_as_path_1"] = "Dest AS path position 1",
    ["dst_as_path_10"] = "Dest AS path position 10",
    ["dst_as_path_2"] = "Dest AS path position 2",
    ["dst_as_path_3"] = "Dest AS path position 3",
    ["dst_as_path_4"] = "Dest AS path position 4",
    ["dst_as_path_5"] = "Dest AS path position 5",
    ["dst_as_path_6"] = "Dest AS path position 6",
    ["dst_as_path_7"] = "Dest AS path position 7",
    ["dst_as_path_8"] = "Dest AS path position 8",
    ["dst_as_path_9"] = "Dest AS path position 9",
    ["dst_father_proc_name"] = "Server father process name",
    ["dst_father_proc_pid"] = "Server father process PID",
    ["dst_fragments"] = "Num fragmented packets dst->src",
    ["dst_intf_name"] = "Server Interface Name",
    ["dst_ip_city"] = "City where the dst IP is located",
    ["dst_ip_country"] = "Country where the dst IP is located",
    ["dst_ip_lat"] = "Latitude where the dst IP is located",
    ["dst_ip_long"] = "Longitude where the dst IP is located",
    ["dst_os_name"] = "Server OS Name",
    ["dst_proc_actual_memory"] = "Server process actual memory (bytes)",
    ["dst_proc_average_cpu_load"] = "Server process avg load (%% * 100)",
    ["dst_proc_name"] = "Server Process",
    ["dst_proc_num_page_faults"] = "Server process num pagefaults",
    ["dst_proc_package_name"] = "Server Process Package",
    ["dst_proc_pctg_iowait"] = "Client process iowait time %% (%% * 100)",
    ["dst_proc_peak_memory"] = "Server process peak memory (bytes)",
    ["dst_proc_pid"] = "Server process PID",
    ["dst_proc_uid"] = "Server process UID",
    ["dst_proc_user_name"] = "Server process user name",
    ["dst_sw_version"] = "Server Software Version",
    ["dst_to_src_avg_throughput"] = "Dst to src average thpt (bps)",
    ["dst_to_src_max_throughput"] = "Dst to src max thpt (bps)",
    ["dst_to_src_min_throughput"] = "Dst to src min thpt (bps)",
    ["dst_tos"] = "TOS/DSCP (dst->src)",
    ["dst_user"] = "Server Username",
    ["dst_vlan"] = "Destination VLAN (inner VLAN in QinQ)",
    ["duration_in"] = "Client to Server stream duration (msec)",
    ["duration_out"] = "Client to Server stream duration (msec)",
    ["engine_id"] = "Id of the flow switching engine",
    ["engine_type"] = "Flow switching engine",
    ["exporter_ipv4_address"] = "Flow Exporter IPv4 Address",
    ["exporter_ipv6_address"] = "Flow Exporter IPv6 Address",
    ["file_gaps"] = "File Gaps",
    ["file_id"] = "File ID",
    ["file_name"] = "File Name",
    ["file_size"] = "File Size",
    ["file_state"] = "File State",
    ["file_stored"] = "File Stored",
    ["firewall_event"] = "Firewall Event 0=ignore, 1=flow created, 2=flow deleted, 3=flow denied, 4=flow alert, 5=flow update",
    ["first_switched"] = "SysUptime (msec) of the first flow pkt",
    ["flow_active_timeout"] = "Activity timeout of flow cache entries",
    ["flow_duration_microseconds"] = "Flow duration (usec)",
    ["flow_duration_milliseconds"] = "Flow duration (msec)",
    ["flow_end_microseconds"] = "uSec (epoch) of the first flow packet",
    ["flow_end_milliseconds"] = "Msec (epoch) of the last flow packet",
    ["flow_end_reason"] = "Flow End Reason",
    ["flow_end_sec"] = "Seconds (epoch) of the last flow packet",
    ["flow_id"] = "Serial Flow Identifier",
    ["flow_inactive_timeout"] = "Inactivity timeout of flow cache entries",
    ["flow_proto_port"] = "L7 port that identifies the flow application or 0 if unknown",
    ["flow_server_name"] = "Flow server name (if known)",
    ["flow_start_microseconds"] = "uSec (epoch) of the first flow packet",
    ["flow_start_milliseconds"] = "Msec (epoch) of the first flow packet",
    ["flow_start_sec"] = "Seconds (epoch) of the first flow packet",
    ["flow_user_name"] = "Flow username of the tunnel (if known)",
    ["flow_verdict"] = "Flow Verdict",
    ["frame_length"] = "Original L2 frame length",
    ["ftp_command"] = "FTP client command",
    ["ftp_command_ret_code"] = "FTP client command return code",
    ["ftp_login"] = "FTP client login",
    ["ftp_password"] = "FTP client password",
    ["gtpv0_apn_name"] = "GTPv0 APN Name",
    ["gtpv0_end_user_ip"] = "GTPv0 End User IP Address",
    ["gtpv0_end_user_msisdn"] = "GTPv0 End User MSISDN",
    ["gtpv0_rai_cell_lac"] = "GTPv0 Cell Location Area Code",
    ["gtpv0_rai_cell_rac"] = "GTPv0 Cell Routing Area Code",
    ["gtpv0_rai_mcc"] = "GTPv0 Mobile Country Code",
    ["gtpv0_rai_mnc"] = "GTPv0 Mobile Network Code",
    ["gtpv0_req_msg_type"] = "GTPv0 Request Msg Type",
    ["gtpv0_response_cause"] = "GTPv0 Cause of Operation",
    ["gtpv0_rsp_msg_type"] = "GTPv0 Response Msg Type",
    ["gtpv0_tid"] = "GTPv0 Tunnel Identifier",
    ["gtpv1_apn_name"] = "GTPv1 APN Name",
    ["gtpv1_c2s_teid_ctrl"] = "GTPv1 Cli->Srv TunnelId Control",
    ["gtpv1_c2s_teid_data"] = "GTPv1 Cli->Srv TunnelId Data",
    ["gtpv1_end_user_imei"] = "GTPv1 End User IMEI",
    ["gtpv1_end_user_imsi"] = "GTPv1 End User IMSI",
    ["gtpv1_end_user_ip"] = "GTPv1 End User IP Address",
    ["gtpv1_end_user_msisdn"] = "GTPv1 End User MSISDN",
    ["gtpv1_rai_lac"] = "GTPv1 RAI Location Area Code",
    ["gtpv1_rai_mcc"] = "GTPv1 RAI Mobile Country Code",
    ["gtpv1_rai_mnc"] = "GTPv1 RAI Mobile Network Code",
    ["gtpv1_rai_rac"] = "GTPv1 RAI Routing Area Code",
    ["gtpv1_rat_type"] = "GTPv1 RAT Type",
    ["gtpv1_req_msg_type"] = "GTPv1 Request Msg Type",
    ["gtpv1_response_cause"] = "GTPv1 Cause of Operation",
    ["gtpv1_rsp_msg_type"] = "GTPv1 Response Msg Type",
    ["gtpv1_s2c_teid_ctrl"] = "GTPv1 Server->Client TunnelId Control",
    ["gtpv1_s2c_teid_data"] = "GTPv1 Server->Client TunnelId Data",
    ["gtpv1_uli_cell_ci"] = "GTPv1 ULI Cell CI",
    ["gtpv1_uli_cell_lac"] = "GTPv1 ULI Cell Location Area Code",
    ["gtpv1_uli_mcc"] = "GTPv1 ULI Mobile Country Code",
    ["gtpv1_uli_mnc"] = "GTPv1 ULI Mobile Network Code",
    ["gtpv1_uli_sac"] = "GTPv1 ULI SAC",
    ["gtpv2_apn_name"] = "GTPv2 APN Name",
    ["gtpv2_c2s_s1u_gtpu_ip"] = "GTPv2 Cli->Srv S1U GTPU IP",
    ["gtpv2_c2s_s1u_gtpu_teid"] = "GTPv2 Cli->Srv S1U GTPU TEID",
    ["gtpv2_c2s_s5_s8_gtpc_ip"] = "GTPv2 Cli->Srv S5/S8 GTPC IP",
    ["gtpv2_c2s_s5_s8_gtpu_ip"] = "GTPv2 Cli->Srv S5/S8 PGW GTPU IP",
    ["gtpv2_c2s_s5_s8_gtpu_teid"] = "GTPv2 Cli->Srv S5/S8 PGW GTPU TEID",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_ip"] = "GTPv2 Cli->Srv S5/S8 SGW GTPU IP",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_teid"] = "GTPv2 Cli->Srv S5/S8 SGW GTPU TEID",
    ["gtpv2_end_user_imei"] = "GTPv2 End User IMEI",
    ["gtpv2_end_user_imsi"] = "GTPv2 End User IMSI",
    ["gtpv2_end_user_msisdn"] = "GTPv2 End User MSISDN",
    ["gtpv2_pdn_ip"] = "GTPV2 PDN IP Address",
    ["gtpv2_rat_type"] = "GTPv2 RAT Type",
    ["gtpv2_req_msg_type"] = "GTPv2 Request Msg Type",
    ["gtpv2_response_cause"] = "GTPv2 Cause of Operation",
    ["gtpv2_rsp_msg_type"] = "GTPv2 Response Msg Type",
    ["gtpv2_s2c_s1u_gtpu_ip"] = "GTPv2 Srv->Cli S1U GTPU IP",
    ["gtpv2_s2c_s1u_gtpu_teid"] = "GTPv2 Srv->Cli S1U GTPU TEID",
    ["gtpv2_s2c_s5_s8_gtpc_ip"] = "GTPv2 Srv->Cli S5/S8 GTPC IP",
    ["gtpv2_s2c_s5_s8_gtpu_ip"] = "GTPv2 Srv->Cli S5/S8 PGW GTPU IP",
    ["gtpv2_s2c_s5_s8_gtpu_teid"] = "GTPv2 Srv->Cli S5/S8 PGW GTPU TEID",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_ip"] = "GTPv2 Srv->Cli S5/S8 SGW GTPU IP",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_teid"] = "GTPv2 Srv->Cli S5/S8 SGW GTPU TEID",
    ["gtpv2_s5_s8_gtpc_teid"] = "GTPv2 S5/S8 SGW GTPC TEIDs",
    ["gtpv2_uli_cell_id"] = "GTPv2 Cell Identifier",
    ["gtpv2_uli_cell_tac"] = "GTPv2 Tracking Area Code",
    ["gtpv2_uli_mcc"] = "GTPv2 Mobile Country Code",
    ["gtpv2_uli_mnc"] = "GTPv2 Mobile Network Code",
    ["httpMessageVersion"] = "HTTP Message Version",
    ["httpRequestHost"] = "HTTP Request Host",
    ["httpRequestMethod"] = "HTTP Request Method",
    ["httpRequestTarget"] = "HTTP Request Target",
    ["httpStatusCode"] = "HTTP Status Code",
    ["httpUserAgent"] = "HTTP User Agent",
    ["http_host"] = "HTTP Host Name (IXIA Host Name)",
    ["http_length"] = "HTTP Content Length",
    ["http_method"] = "HTTP METHOD",
    ["http_mime"] = "HTTP Mime Type",
    ["http_protocol"] = "HTTP Protocol",
    ["http_referer"] = "HTTP Referer",
    ["http_ret_code"] = "HTTP return code (e.g. 200, 304...)",
    ["http_site"] = "HTTP server without host name",
    ["http_ua"] = "HTTP User Agent",
    ["http_url"] = "HTTP URL (IXIA URI)",
    ["http_via"] = "HTTP Via",
    ["http_x_forwarded_for"] = "HTTP X-Forwarded-For",
    ["icmp_ipv4_code"] = "ICMP Code",
    ["icmp_ipv4_type"] = "ICMP Type",
    ["icmp_type"] = "ICMP Type * 256 + ICMP code",
    ["imap_login"] = "Mail sender",
    ["in_bytes"] = "Incoming flow bytes (src->dst)",
    ["in_dst_mac"] = "Destination MAC Address",
    ["in_pkts"] = "Incoming flow packets (src->dst)",
    ["in_src_mac"] = "Source MAC Address",
    ["in_src_osi_sap"] = "OSI Source SAP (OSI Traffic Only)",
    ["ingress_vrfid"] = "Ingress VRF ID",
    ["input_snmp"] = "Input interface SNMP idx",
    ["ipDSCP"] = "IP DSCP",
    ["ipPayloadLenght"] = "IP Payload Lenght",
    ["ipPrecendence"] = " IP Precedence",
    ["ip_lenght_maximum"] = "IP Max Length",
    ["ip_lenght_minimum"] = "IP Min Length",
    ["ip_protocol_version"] = "[4=IPv4][6=IPv6]",
    ["ipfix_sampling_algorithm"] = "Sampling algorithm",
    ["ipv4_dst_addr"] = "IPv4 destination address",
    ["ipv4_dst_mask"] = "IPv4 dest subnet mask (/<bits>)",
    ["ipv4_next_hop"] = "IPv4 next hop address",
    ["ipv4_src_addr"] = "IPv4 source address",
    ["ipv4_src_mask"] = "IPv4 source subnet mask (/<bits>)",
    ["ipv6_dst_addr"] = "IPv6 destination address",
    ["ipv6_dst_mask"] = "IPv6 destination mask",
    ["ipv6_next_hop"] = "IPv6 next hop address",
    ["ipv6_src_addr"] = "IPv6 source address",
    ["ipv6_src_mask"] = "IPv6 source mask",
    ["ja3"] = "JA3",
    ["l4_dst_port"] = "Layer 4 destination port",
    ["l4_dst_port_map"] = "Layer 4 destination port symbolic name",
    ["l4_src_port"] = "IPv4 source port",
    ["l4_src_port_map"] = "Layer 4 source port symbolic name",
    ["l4_srv_port"] = "Layer 4 server port",
    ["l4_srv_port_map"] = "Layer 4 server port symbolic name",
    ["l7_info"] = "Layer 7 Flow Information",
    ["l7_proto"] = "Layer 7 Application (numeric)",
    ["l7_proto_name"] = "Application Name",
    ["l7_risk_score"] = "nDPI Flow Risk Score",
    ["last_switched"] = "SysUptime (msec) of the last flow pkt",
    ["layer2FrameDeltaCount"] = "L2 Frame Delta Count",
    ["layer2FrameTotalCount"] = "L2 Frame Total Count",
    ["layer2OctetDeltaSumOfSquares"] = "L2 Octet Delta Sum Of Squares",
    ["layer2OctetTotalSumOfSquares"] = "L2 Octet Total Sum Of Squares",
    ["longest_flow_pkt"] = "Longest packet (bytes) of the flow",
    ["major_connection_state"] = "Major Connection State",
    ["max_ttl"] = "Max flow TTL",
    ["maximumLayer2TotalLength"] = "Max L2 Total Lenght",
    ["min_ttl"] = "Min flow TTL",
    ["minimumLayer2TotalLength"] = "Min L2 Total Lenght",
    ["minor_connection_state"] = "Minor Connection State",
    ["mpls_label_1"] = "MPLS label at position 1",
    ["mpls_label_10"] = "MPLS label at position 10",
    ["mpls_label_2"] = "MPLS label at position 2",
    ["mpls_label_3"] = "MPLS label at position 3",
    ["mpls_label_4"] = "MPLS label at position 4",
    ["mpls_label_5"] = "MPLS label at position 5",
    ["mpls_label_6"] = "MPLS label at position 6",
    ["mpls_label_7"] = "MPLS label at position 7",
    ["mpls_label_8"] = "MPLS label at position 8",
    ["mpls_label_9"] = "MPLS label at position 9",
    ["mysql_appl_latency_usec"] = "MySQL request->response latecy (usec)",
    ["mysql_db"] = "MySQL database in use",
    ["mysql_query"] = "MySQL Query",
    ["mysql_response"] = "MySQL server response",
    ["mysql_server_version"] = "MySQL server version",
    ["mysql_username"] = "MySQL username",
    ["netbios_query_name"] = "NETBIOS Query Name",
    ["netbios_query_os"] = "NETBIOS Query OS",
    ["netbios_query_type"] = "NETBIOS Query Type",
    ["netbios_response"] = "NETBIOS Query Response",
    ["nprobe_instance_name"] = "nProbe Instance Name",
    ["nprobe_ipv4_address"] = "IPv4 address of the host were nProbe runs",
    ["num_pkts_1024_to_1514_bytes"] = "# packets whose IP size > 1024 and <= 1514",
    ["num_pkts_128_to_256_bytes"] = "# packets whose IP size > 128 and <= 256",
    ["num_pkts_256_to_512_bytes"] = "# packets whose IP size > 256 and < 512",
    ["num_pkts_512_to_1024_bytes"] = "# packets whose IP size > 512 and < 1024",
    ["num_pkts_over_1514_bytes"] = "# packets whose IP size > 1514",
    ["num_pkts_ttl_128_160"] = "# packets with TTL > 128 and <= 160",
    ["num_pkts_ttl_160_192"] = "# packets with TTL > 160 and <= 192",
    ["num_pkts_ttl_192_224"] = "# packets with TTL > 192 and <= 224",
    ["num_pkts_ttl_224_255"] = "# packets with TTL > 224 and <= 255",
    ["num_pkts_ttl_2_5"] = "# packets with TTL > 1 and TTL <= 5",
    ["num_pkts_ttl_32_64"] = "# packets with TTL > 32 and <= 64",
    ["num_pkts_ttl_5_32"] = "# packets with TTL > 5 and TTL <= 32",
    ["num_pkts_ttl_64_96"] = "# packets with TTL > 64 and <= 96",
    ["num_pkts_ttl_96_128"] = "# packets with TTL > 96 and <= 128",
    ["num_pkts_ttl_eq_1"] = "# packets with TTL = 1",
    ["num_pkts_up_to_128_bytes"] = "# packets whose IP size <= 128",
    ["observation_point_id"] = "Observation point id",
    ["observation_point_type"] = "Observation point type",
    ["ooorder_in_pkts"] = "Number of out of order TCP flow packets (dst->src)",
    ["ooorder_out_pkts"] = "Number of out of order TCP flow packets (src->dst)",
    ["oracle_query"] = "Oracle Query",
    ["oracle_query_duration"] = "Oracle Query Duration (msec)",
    ["oracle_rsp_code"] = "Oracle Response Code",
    ["oracle_rsp_string"] = "Oracle Response String",
    ["oracle_username"] = "Oracle Username",
    ["out_bytes"] = "Outgoing flow bytes (dst->src) [Aliased to %%DST_TO_SRC_BYTES]",
    ["out_dst_mac"] = "Destination MAC Address, potentially modified by a middlebox function after the Observation Point",
    ["out_dst_osi_sap"] = "OSI Destination SAP (OSI Traffic Only)",
    ["out_pkts"] = "Outgoing flow packets (dst->src) [Aliased to %%DST_TO_SRC_PKTS]",
    ["out_src_mac"] = "Source MAC Address, potentially modified by a middlebox function after the Observation Point",
    ["output_snmp"] = "Output interface SNMP idx",
    ["packet_section_offset"] = "Packet section offset",
    ["packets_observed"] = "Tot number of packets seen",
    ["packets_selected"] = "Number of pkts selected for sampling",
    ["payload_hash"] = "Initial flow payload hash",
    ["policy_action"] = "Policy Action",
    ["policy_id"] = "Policy Id",
    ["pop_user"] = "POP3 user login",
    ["post_nat_dst_ipv4_addr"] = "Post NAT Destination IPv4 IP",
    ["post_nat_dst_transport_port"] = "Post NAPT Destination Transport Port",
    ["post_nat_src_ipv4_addr"] = "Post NAT Source IPv4 IP",
    ["post_nat_src_transport_port"] = "Post NAPT Source Transport Port",
    ["protocol"] = "IP protocol byte",
    ["protocol_map"] = "IP protocol name",
    ["radius_acct_in_octets"] = "RADIUS Accounting Input Octets",
    ["radius_acct_in_pkts"] = "RADIUS Accounting Input Packets",
    ["radius_acct_out_octets"] = "RADIUS Accounting Output Octets",
    ["radius_acct_out_pkts"] = "RADIUS Accounting Output Packets",
    ["radius_acct_session_id"] = "RADIUS Accounting Session Name",
    ["radius_acct_status_type"] = "RADIUS Accounting Status Type",
    ["radius_called_station_id"] = "RADIUS Called Station Id",
    ["radius_calling_station_id"] = "RADIUS Calling Station Id",
    ["radius_framed_ip_addr"] = "RADIUS Framed IP",
    ["radius_nas_identifier"] = "RADIUS NAS Identifier",
    ["radius_nas_ip_addr"] = "RADIUS NAS IP Address",
    ["radius_req_msg_type"] = "RADIUS Request Msg Type",
    ["radius_rsp_msg_type"] = "RADIUS Response Msg Type",
    ["radius_user_imei"] = "RADIUS User MSISDN (Extension)",
    ["radius_user_imsi"] = "RADIUS User IMSI (Extension)",
    ["radius_user_name"] = "RADIUS User Name (Access Only)",
    ["retransmitted_in_bytes"] = "Number of retransmitted TCP flow bytes (src->dst)",
    ["retransmitted_in_pkts"] = "Number of retransmitted TCP flow packets (src->dst)",
    ["retransmitted_out_bytes"] = "Number of retransmitted TCP flow bytes (dst->src)",
    ["retransmitted_out_pkts"] = "Number of retransmitted TCP flow packets (dst->src)",
    ["rtp_dtmf_tones"] = "DTMF tones sent (if any) during the call",
    ["rtp_first_seq"] = "First flow RTP Seq Number",
    ["rtp_first_ts"] = "First flow RTP timestamp",
    ["rtp_in_jitter"] = "RTP jitter (ms * 1000)",
    ["rtp_in_max_delta"] = "Max delta (ms*100) between consecutive pkts (src->dst)",
    ["rtp_in_mos"] = "RTP pseudo-MOS (value * 100) (src->dst)",
    ["rtp_in_payload_type"] = "RTP payload type",
    ["rtp_in_pkt_drop"] = "Packet discarded by Jitter Buffer (src->dst)",
    ["rtp_in_pkt_lost"] = "Packet lost in stream (src->dst)",
    ["rtp_in_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (src->dst)",
    ["rtp_in_transit"] = "RTP Transit (value * 100) (src->dst)",
    ["rtp_last_seq"] = "Last flow RTP Seq Number",
    ["rtp_last_ts"] = "Last flow RTP timestamp",
    ["rtp_mos"] = "RTP pseudo-MOS (value * 100) (average both directions)",
    ["rtp_out_jitter"] = "RTP jitter (ms * 1000)",
    ["rtp_out_max_delta"] = "Max delta (ms*100) between consecutive pkts (dst->src)",
    ["rtp_out_mos"] = "RTP pseudo-MOS (value * 100) (dst->src)",
    ["rtp_out_payload_type"] = "RTP payload type",
    ["rtp_out_pkt_drop"] = "Packet discarded by Jitter Buffer (dst->src)",
    ["rtp_out_pkt_lost"] = "Packet lost in stream (dst->src)",
    ["rtp_out_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (dst->src)",
    ["rtp_out_transit"] = "RTP Transit (value * 100) (dst->src)",
    ["rtp_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (average both directions)",
    ["rtp_rtt"] = "RTP Round Trip Time (ms)",
    ["rtp_sip_call_id"] = "SIP call-id corresponding to this RTP stream",
    ["rtp_ssrc"] = "RTP Sync Source ID",
    ["s1ap_cause_enb_to_mme"] = "S1AP Cause from ENB to MME",
    ["s1ap_detailed_cause_enb_to_mme"] = "S1AP Detailed Cause from ENB to MME",
    ["s1ap_enb_ue_s1ap_id"] = "S1AP ENB Identifier",
    ["s1ap_mme_ue_s1ap_id"] = "S1AP MME Identifier",
    ["s1ap_msg_emm_type_enb_to_mme"] = "S1AP EMM Message Type from ENB to MME",
    ["s1ap_msg_emm_type_mme_to_enb"] = "S1AP EMM Message Type from MME to ENB",
    ["s1ap_msg_esm_type_enb_to_mme"] = "S1AP ESM Message Type from ENB to MME",
    ["s1ap_msg_esm_type_mme_to_enb"] = "S1AP ESM Message Type from MME to ENB",
    ["sampled_packet_id"] = "Sampled packet id",
    ["sampled_packet_size"] = "Sampled packet size",
    ["sampling_algorithm"] = "Sampling type (deterministic/random)",
    ["sampling_interval"] = "Sampling rate",
    ["sampling_population"] = "Sampling population",
    ["sampling_size"] = "Number of packets to sample",
    ["script_name"] = "Script name used by this flow (if any)",
    ["selector_id"] = "Selector id",
    ["selector_name"] = "Sampler name",
    ["server_nw_latency_ms"] = "Network RTT/2 nprobe <-> server (msec)",
    ["shortest_flow_pkt"] = "Shortest packet (bytes) of the flow",
    ["sip_bye_ok_time"] = "SIP time (epoch) of BYE OK",
    ["sip_bye_time"] = "SIP time (epoch) of BYE",
    ["sip_c_ip"] = "SIP C IP adresses",
    ["sip_call_id"] = "SIP call-id",
    ["sip_call_state"] = "SIP Call State",
    ["sip_called_party"] = "SIP Called party",
    ["sip_calling_party"] = "SIP Call initiator",
    ["sip_cancel_ok_time"] = "SIP time (epoch) of CANCEL OK",
    ["sip_cancel_time"] = "SIP time (epoch) of CANCEL",
    ["sip_invite_failure_time"] = "SIP time (epoch) of INVITE FAILURE",
    ["sip_invite_ok_time"] = "SIP time (epoch) of INVITE OK",
    ["sip_invite_time"] = "SIP time (epoch) of INVITE",
    ["sip_reason_cause"] = "SIP Cancel/Bye/Failure reason cause",
    ["sip_response_code"] = "SIP failure response code",
    ["sip_ringing_time"] = "SIP time (epoch) of RINGING",
    ["sip_rtp_codecs"] = "SIP RTP codecs",
    ["sip_rtp_ipv4_dst_addr"] = "SIP RTP stream dest IP",
    ["sip_rtp_ipv4_src_addr"] = "SIP RTP stream source IP",
    ["sip_rtp_l4_dst_port"] = "SIP RTP stream dest port",
    ["sip_rtp_l4_src_port"] = "SIP RTP stream source port",
    ["sip_trying_time"] = "SIP time (epoch) of Trying",
    ["sip_uac"] = "SIP User-Agent Client",
    ["sip_uas"] = "SIP User-Agent Server",
    ["smtp_mail_from"] = "Mail sender",
    ["smtp_rcpt_to"] = "Mail recipient",
    ["src_as"] = "Source BGP AS",
    ["src_as_map"] = "Organization name for SRC_AS",
    ["src_as_path_1"] = "Src AS path position 1",
    ["src_as_path_10"] = "Src AS path position 10",
    ["src_as_path_2"] = "Src AS path position 2",
    ["src_as_path_3"] = "Src AS path position 3",
    ["src_as_path_4"] = "Src AS path position 4",
    ["src_as_path_5"] = "Src AS path position 5",
    ["src_as_path_6"] = "Src AS path position 6",
    ["src_as_path_7"] = "Src AS path position 7",
    ["src_as_path_8"] = "Src AS path position 8",
    ["src_as_path_9"] = "Src AS path position 9",
    ["src_father_proc_name"] = "Client father process name",
    ["src_father_proc_pid"] = "Client father process PID",
    ["src_fragments"] = "Num fragmented packets src->dst",
    ["src_intf_name"] = "Client Interface Name",
    ["src_ip_city"] = "City where the src IP is located",
    ["src_ip_country"] = "Country where the src IP is located",
    ["src_ip_lat"] = "Latitude where the src IP is located",
    ["src_ip_long"] = "Longitude where the src IP is located",
    ["src_os_name"] = "Client OS Name",
    ["src_proc_actual_memory"] = "Client process actual memory (bytes)",
    ["src_proc_average_cpu_load"] = "Client process avg load (%% * 100)",
    ["src_proc_name"] = "Client Process",
    ["src_proc_num_page_faults"] = "Client process num pagefaults",
    ["src_proc_package_name"] = "Client Process Package",
    ["src_proc_pctg_iowait"] = "Client process iowait time %% (%% * 100)",
    ["src_proc_peak_memory"] = "Client process peak memory (bytes)",
    ["src_proc_pid"] = "Client process PID",
    ["src_proc_uid"] = "Client process UID",
    ["src_proc_user_name"] = "Client process user name",
    ["src_sw_version"] = "Client Software Version",
    ["src_to_dst_avg_throughput"] = "Src to dst average thpt (bps)",
    ["src_to_dst_max_throughput"] = "Src to dst max thpt (bps)",
    ["src_to_dst_min_throughput"] = "Src to dst min thpt (bps)",
    ["src_tos"] = "TOS/DSCP (src->dst)",
    ["src_user"] = "Client Username",
    ["src_vlan"] = "Source VLAN (inner VLAN in QinQ)",
    ["ssdp_host"] = "SSDP Host",
    ["ssdp_method"] = "SSDP Method",
    ["ssdp_server"] = "SSDP Server",
    ["ssdp_type"] = "SSDP Type",
    ["ssdp_usn"] = "SSDP USN",
    ["suricata_app_proto"] = "Suricata Application Protocol",
    ["suricata_flow_id"] = "Suricata Flow ID",
    ["tcpAckNum"] = "TCP Ack Number",
    ["tcpSeqNum"] = "TCP Sequence Number",
    ["tcpUrgentPtr"] = "TCP Urgent Ptr",
    ["tcpWindowSize"] = "TCP Window Size",
    ["tcp_flags"] = "Cumulative of all flow TCP flags",
    ["tcp_win_max_in"] = "Max TCP Window [ Client -> Server ]",
    ["tcp_win_max_out"] = "Max TCP Window [ Server -> Client ]",
    ["tcp_win_min_in"] = "Min TCP Window [ Client -> Server ]",
    ["tcp_win_min_out"] = "Min TCP Window [ Server -> Client ]",
    ["tcp_win_mss_in"] = "TCP Max Segment Size [ Client -> Server ]",
    ["tcp_win_mss_out"] = "TCP Max Segment Size [ Server -> Client ]",
    ["tcp_win_scale_in"] = "TCP Window Scale [ Client -> Server ]",
    ["tcp_win_scale_out"] = "TCP Window Scale [ Server -> Client ]",
    ["tls_cert_after"] = "TLS Cert After",
    ["tls_cert_dn"] = "TLS Cert Issuer DN",
    ["tls_cert_not_before"] = "TLS Cert Not Before",
    ["tls_cert_sha1"] = "TLS Cert Fingerprint",
    ["tls_cert_sn"] = "TLS Cert Subject SN",
    ["tls_requested_sni"] = "TLS Requested SNI",
    ["tls_server_name"] = "TLS server name",
    ["tls_server_names"] = "TLS Server Names",
    ["tls_version"] = "TLS Version",
    ["total_bytes_exp"] = "Total Bytes Exported",
    ["total_flows_exp"] = "Total Number of Exported Flows",
    ["total_pkts_exp"] = "Total Flow Packets Exported",
    ["untunneled_ipv4_dst_addr"] = "Untunneled IPv4 destination address",
    ["untunneled_ipv4_src_addr"] = "Untunneled IPv4 source address",
    ["untunneled_ipv6_dst_addr"] = "Untunneled IPv6 destination address",
    ["untunneled_ipv6_src_addr"] = "Untunneled IPv6 source address",
    ["untunneled_l4_dst_port"] = "Untunneled IPv4 destination port",
    ["untunneled_l4_src_port"] = "Untunneled IPv4 source port",
    ["untunneled_protocol"] = "Untunneled IP protocol byte",
    ["upstream_session_id"] = "Upstream session identifier (e.g. L2TP) or 0 if unknown",
    ["upstream_tunnel_id"] = "Upstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
    ["user_name"] = "User Name",
    ["major_connection_states"] = {
      ["0"] = "NO_STATE",
      ["1"] = "Attempted",
      ["2"] = "Established",
      ["3"] = "Closed",
    },
    ["minor_connection_states"] = {
      ["0"] = "NO_STATE",
      ["1"] = "S0",
      ["10"] = "RSTRH",
      ["11"] = "SH",
      ["12"] = "SHR",
      ["13"] = "OTH",
      ["2"] = "S1",
      ["3"] = "SF",
      ["4"] = "REJ",
      ["5"] = "S2",
      ["6"] = "S3",
      ["7"] = "RSTO",
      ["8"] = "RSTR",
      ["9"] = "RSTOS0",
    },
    ["minor_connection_states_info"] = {
      ["0"] = "NO_STATE",
      ["1"] = "Connection attempt seen, no reply",
      ["10"] = "Responder sent a SYN ACK followed by a RST, we never saw a SYN from the (purported) originator",
      ["11"] = "Originator sent a SYN followed by a FIN, we never saw a SYN ACK from the responder (hence the connection was “half” open)",
      ["12"] = "Responder sent a SYN ACK followed by a FIN, we never saw a SYN from the originator",
      ["13"] = "No SYN seen, just midstream traffic (one example of this is a “partial connection” that was not later closed)",
      ["2"] = "Connection established, not terminated",
      ["3"] = "Normal establishment and termination",
      ["4"] = "Connection attempt rejected",
      ["5"] = "Connection established and close attempt by originator seen (but no reply from responder)",
      ["6"] = "Connection established and close attempt by responder seen (but no reply from originator)",
      ["7"] = "Connection established, originator aborted (sent a RST)",
      ["8"] = "Responder sent a RST",
      ["9"] = "Originator sent a SYN followed by a RST, we never saw a SYN-ACK from the responder",
    },
  },
  ["flow_risk"] = {
    ["malicious_signature_detected"] = "Possibly Client Malicious JA3 Signature",
    ["ndpi_anonymous_subscriber"] = "Anonymous Subscriber",
    ["ndpi_anonymous_subscriber_descr"] = "Trigger an alert whenever the (source) IP address has been anonymized and it can’t be used to identify the subscriber (e.g. iCloud-private-relay)",
    ["ndpi_binary_application_transfer"] = "Binary App/.exe Transfer",
    ["ndpi_binary_application_transfer_descr"] = "Trigger an alert when an executable/application download/upload (attempt) is detected",
    ["ndpi_binary_data_transfer"] = "Binary Data Transfer",
    ["ndpi_binary_data_transfer_descr"] = "Trigger an alert whenever binary data download/upload (attempt) is detected",
    ["ndpi_clear_text_credentials"] = "Clear-Text Credentials",
    ["ndpi_clear_text_credentials_descr"] = "Trigger an alert whenever clear text protocols (e.g. FTP, HTTP, IMAP…) contain credentials in clear text",
    ["ndpi_desktop_or_file_sharing_session"] = "Desktop or File Sharing Session",
    ["ndpi_dns_fragmented"] = "Fragmented DNS Message",
    ["ndpi_dns_fragmented_descr"] = "Trigger an alert when a Fragmented DNS Packet is detected (UDP/DNS Packets should be fragmented)",
    ["ndpi_dns_large_packet"] = "Large DNS Packet (512+ bytes)",
    ["ndpi_dns_large_packet_descr"] = "Trigger an alert when a DNS Packet too large (512+ bytes) is detected",
    ["ndpi_dns_suspicious_traffic"] = "Susp. DNS Traffic",
    ["ndpi_error_code_detected"] = "Error Code",
    ["ndpi_error_code_detected_descr"] = "Trigger an alert when an HTTP error code (response code) is detected",
    ["ndpi_http_crawler_bot"] = "Crawler/Bot",
    ["ndpi_http_crawler_bot_descr"] = "Trigger an alert  whenever a crawler/bot/robot is detected",
    ["ndpi_http_invalid_content"] = "Invalid HTTP content",
    ["ndpi_http_numeric_ip_host"] = "HTTP/TLS/QUIC Numeric Hostname/SNI",
    ["ndpi_http_suspicious_content"] = "HTTP Susp. Content",
    ["ndpi_http_suspicious_content_descr"] = "Trigger an alert when HTTP carries content in unexpected format (e.g. when the real content is not readable)",
    ["ndpi_http_suspicious_header"] = "HTTP Susp. Header",
    ["ndpi_http_suspicious_url"] = "HTTP Susp. URL",
    ["ndpi_http_suspicious_user_agent"] = "HTTP Susp. User-Agent",
    ["ndpi_invalid_characters"] = "DNS Invalid Characters",
    ["ndpi_invalid_characters_alert_descr"] = "Dissected contains characters not allowed",
    ["ndpi_invalid_characters_descr"] = "Trigger an alert when an invalid character is detected in DNS packets",
    ["ndpi_known_proto_on_non_stand_port_descr"] = "Detected known protocol used on a non standard port",
    ["ndpi_known_protocol_on_non_standard_port"] = "Known Proto on Non Std Por",
    ["ndpi_malformed_packet"] = "Malformed packet",
    ["ndpi_malformed_packet_descr"] = "Some packet has an unexpected format",
    ["ndpi_malicious_ja3"] = "Possibly Malicious Signature (JA3)",
    ["ndpi_malicious_sha1_certificate"] = "Malicisous SHA1 TLS Cert",
    ["ndpi_no_risk"] = "No risk",
    ["ndpi_periodic_flow_descr"] = "Periodic flow",
    ["ndpi_possible_exploit"] = "Possible Exploit",
    ["ndpi_possible_exploit_alert_descr"] = "Possible exploit detected",
    ["ndpi_possible_exploit_descr"] = "Trigger an alert when a possible exploit is detected (e.g. Log4J/Log4Shell)",
    ["ndpi_punicody_idn"] = "Punicody IDN",
    ["ndpi_punicody_idn_descr"] = "Trigger an alert whenever a domain name is specified in IDN format (as they are sometimes used in IDN homograph attacks)",
    ["ndpi_risky_asn"] = "Risky ASN",
    ["ndpi_risky_domain"] = "Risky Domain",
    ["ndpi_smb_insecure_version"] = "SMB Insecure Vers",
    ["ndpi_ssh_obsolete_client_version_or_cipher"] = "Obsolete SSH Client Version or Cipher",
    ["ndpi_ssh_obsolete_client_version_or_cipher_signature"] = "Obsolete SSH Client Version or Cipher [Signature: %{signature}]",
    ["ndpi_ssh_obsolete_server_version_or_cipher"] = "Obsolete SSH Server Version or Cipher",
    ["ndpi_ssh_obsolete_server_version_or_cipher_signature"] = "Obsolete SSH Server Version or Cipher [Signature: %{signature}]",
    ["ndpi_suspicious_dga_domain"] = "Susp. DGA Domain name",
    ["ndpi_suspicious_entropy"] = "Susp. Entropy",
    ["ndpi_suspicious_entropy_descr"] = "Detect suspicious data carried in ICMP packets whose entropy is suspicious and thus that it can indicate a data leak.",
    ["ndpi_tls_cert_validity_too_long"] = "TLS Cert Validity Too Long",
    ["ndpi_tls_certificate_about_to_expire"] = "TLS Cert About To Expire",
    ["ndpi_tls_certificate_about_to_expire_descr"] = "Trigger an alert when TLS certificate is nearly expired",
    ["ndpi_tls_certificate_expired"] = "TLS Certificate Expired [%{sni}][%{notBefore} - %{notAfter}]",
    ["ndpi_tls_certificate_mismatch"] = "TLS Cert Mismatch",
    ["ndpi_tls_fatal_alert"] = "TLS Fatal Alert",
    ["ndpi_tls_missing_sni"] = "Missing SNI TLS Extn",
    ["ndpi_tls_missing_sni_descr"] = "Trigger an alert when the SNI of the remote server is omitted in a TLS communication",
    ["ndpi_tls_not_carrying_https"] = "TLS (probably) Not Carrying HTTPS",
    ["ndpi_tls_obsolete_version"] = "Obsolete TLS Version",
    ["ndpi_tls_selfsigned_certificate"] = "TLS Cert Self-signed",
    ["ndpi_tls_suspicious_esni_usage"] = "TLS Susp. ESNI Usage",
    ["ndpi_tls_suspicious_extension"] = "TLS Susp. Extn",
    ["ndpi_tls_uncommon_alpn"] = "Uncommon TLS ALPN",
    ["ndpi_tls_weak_cipher"] = "Weak TLS Cipher",
    ["ndpi_unsafe_protocol"] = "Unsafe Protocol",
    ["ndpi_unsafe_protocol_descr"] = "Insecure protocol used",
    ["ndpi_url_possible_rce_injection"] = "Possible Remote Code Execution (RCE)",
    ["ndpi_url_possible_sql_injection"] = "SQL Injection",
    ["ndpi_url_possible_xss"] = "XSS Attack",
  },
  ["flows_page"] = {
    ["active_flows"] = "%{filter} Live Flows",
    ["actual_throughput"] = "Actual Thpt",
    ["aggregated_live_flows"] = "Aggregated Live Flows",
    ["alert_type_severity"] = "Severity",
    ["alerted"] = "Alerted",
    ["all_alerted"] = "All Alerted",
    ["all_ases"] = "All ASes",
    ["all_categories"] = "All Categories",
    ["all_devices"] = "All Exporters",
    ["all_dscp"] = "All DSCP",
    ["all_flows"] = "All Flows",
    ["all_host_pool"] = "All Host Pools",
    ["all_hosts"] = "All Hosts",
    ["all_inIfIdx"] = "All Input Interfaces",
    ["all_ip_versions"] = "All Versions",
    ["all_l4_protocols"] = "All Protocols",
    ["all_misbehaving"] = "All Misbehaving",
    ["all_networks"] = "All Networks",
    ["all_outIfIdx"] = "All Output Interfaces",
    ["all_periodic"] = "All Periodic",
    ["all_proto"] = "All L7 Protocols",
    ["all_vlan_ids"] = "All VLANs",
    ["applications"] = "Applications",
    ["blocked"] = "Blocked",
    ["client"] = " [ Client: <a href=\"%{base_url}/lua/host_details.lua?host=%{client}\">%{client_name}</a>  ] ",
    ["client_as"] = "Client AS",
    ["client_to_server"] = "[ Client: <a href=\"%{base_url}/lua/host_details.lua?host=%{client}\">%{client_name}</a> to Server: <a href=\"%{base_url}/lua/host_details.lua?host=%{server}\">%{server_name}</a> ] ",
    ["device_ip"] = "Flow Exporter",
    ["direction"] = "Direction",
    ["dscp"] = "DSCP",
    ["exporters"] = "Exporters",
    ["flow_info"] = "[ Info: %{flow_info}]",
    ["flows"] = "%{filter} Flows",
    ["flows_as_client"] = "Flows As Client",
    ["flows_as_server"] = "Flows As Server",
    ["host"] = " [ Host <a href='%{base_url}/lua/host_details.lua?host=%{host}'>%{host_name}</a> ]",
    ["host_pool_id"] = "Host Pool %{key}",
    ["hosts"] = "Hosts",
    ["icmp_only"] = "ICMP Only",
    ["idle_flows_not_listed"] = "Idle flows not listed.",
    ["inIfIdx"] = "Input Interface",
    ["ip_version"] = "IP Version",
    ["ipv4_only"] = "IPv4 Only",
    ["ipv6_only"] = "IPv6 Only",
    ["l4_protocol"] = "Protocol",
    ["live_flows"] = "Live Flows",
    ["local_cli_remote_srv"] = "Outbound (Local Client - Remote Server)",
    ["local_only"] = "Internal (Local Only)",
    ["local_srv_remote_cli"] = "Inbound (Remote Client - Local Server)",
    ["misbehaving"] = "Misbehaving",
    ["multicast"] = "Multicast/Broadcast",
    ["network"] = " [ Network %{network} ]",
    ["networks"] = "Networks",
    ["no_data"] = "No Data Found",
    ["non_multicast"] = "Non-Multicast/Non-Broadcast",
    ["normal"] = "Normal",
    ["one_way_multicast"] = "One-Way Multicast/Broadcast",
    ["one_way_non_multicast"] = "One-Way Non-Multicast/Non-Broadcast",
    ["outIfIdx"] = "Output Interface",
    ["port"] = " [ Port <a href=\"%{base_url}/lua/flows_stats.lua?port=%{port}\">%{port}</a>  ]",
    ["recently_active_flows"] = " %{filter} Recently Live Flows",
    ["remote_only"] = "Remote (Remote Only)",
    ["server"] = " [ Server: <a href=\"%{base_url}/lua/host_details.lua?host=%{server}\">%{server_name}</a> ]",
    ["server_as"] = "Server AS",
    ["sflow_devices"] = "sFlow Exporters",
    ["source_id"] = "Source Id",
    ["talking_with"] = "Talking With",
    ["tcp_only"] = "TCP Only",
    ["tcp_state"] = "TCP State",
    ["tcp_state_closed"] = "Closed",
    ["tcp_state_connecting"] = "Connecting",
    ["tcp_state_established"] = "Established",
    ["tcp_state_reset"] = "Reset",
    ["tcp_state_unknown"] = "Unknown",
    ["tot_bytes"] = "Total Bytes: ",
    ["tot_throughput"] = "Total Throughput: ",
    ["total_bytes"] = "Total Bytes",
    ["total_bytes_rcvd"] = "Total Bytes Received",
    ["total_bytes_sent"] = "Total Bytes Sent",
    ["total_bytes_unknown"] = "Total Unknown Applications Bytes",
    ["type"] = "Live Flows Page Type",
    ["udp_only"] = "UDP Only",
    ["vlan"] = "VLAN",
  },
  ["fortinet_collector"] = {
    ["description"] = "Collect logs from Fortinet firewalls: handle Identity Management (user correlation) and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "Fortinet",
  },
  ["geo_map"] = {
    ["browser_reported_home_map"] = "Browser reported home map location",
    ["configure_geo_ip"] = "Configure Geo IP",
    ["geo_ip"] = "Geo IP",
    ["geo_map"] = "Geo Map",
    ["geolocation_error"] = "Geolocation error",
    ["geolocation_warning"] = "Warning",
    ["hosts_geomap"] = "Hosts GeoMap",
    ["latitude"] = "Latitude",
    ["longitude"] = "Longitude",
    ["note"] = "NOTE",
    ["note_active_flows"] = "Have active flows between peers with public IP addresses.",
    ["note_compiled_ntopng_with_geolocation"] = "Have compiled the software with geolocation and started with it.",
    ["note_google_maps_browser_api_key"] = "A Google Maps API Key is required, you can generate one from <a href='%{url_google}'>Google Cloud Platform Console</a>:<br>please create a new project and select Maps JavaScript API -> Create Credentials -> API key.<br>Once generated, the key can be submitted via the <a href='%{url_prefs}'><i class=\"fas fa-flask\"></i> Preferences</a>.",
    ["note_html_browser_geolocation"] = "HTML <A HREF=%{url}>browser geolocation</A> is used to place on map hosts based on unknown locations.",
    ["note_requirements_visualize_maps"] = "In order to visualize maps you must",
    ["note_working_internet_connection"] = "Have a working Internet connection.",
    ["unavailable_geolocation"] = "Geolocation not supported by your browser or disabled.",
    ["using_default_location"] = "Using default location, maybe the browser geolocation is turned off.",
    ["warning_accuracy"] = "Geolocation accuracy depends on the geolocation database and may be approximated.",
  },
  ["graphs"] = {
    ["95_perc"] = "95th Perc",
    ["95_perc_rcvd"] = "95th Perc Received",
    ["95_perc_sent"] = "95th Perc Sent",
    ["active_devices"] = "Active Devices",
    ["active_flows"] = "Live Flows",
    ["active_host_contacts"] = "Active Host Contacts",
    ["active_hosts"] = "Active Hosts",
    ["active_http_servers"] = "Active HTTP Servers",
    ["active_local_hosts"] = "Active Local Hosts",
    ["active_monitoring"] = "Active Monitoring",
    ["actual_memory"] = "Actual Memory",
    ["alerts"] = "Alerts",
    ["analyse_records"] = "Analyse Records (Live)",
    ["app_connect"] = "App Connect",
    ["arp_distribution"] = "ARP Distribution",
    ["arp_replies"] = "ARP Replies",
    ["arp_requests"] = "ARP Requests",
    ["arp_rqst_sent_rcvd_rpls"] = "ARP Sent Requests / Rcvd Repls",
    ["average"] = "Average",
    ["average_traffic"] = "Average Traffic/sec",
    ["avg"] = "Avg",
    ["avg_rcvd"] = "Avg Received",
    ["avg_sent"] = "Avg Sent",
    ["behavior"] = "Behaviour",
    ["behavioural_maps"] = "Behaviour: Maps",
    ["binary_operators_note"] = "For more information about the EMA, SMA and RSI indicators check out the <a href=\"%{url}\">online documentation</a>.",
    ["blocked_flows"] = "Blocked Flows",
    ["bytes_sent_non_unicast"] = "Bytes Sent Non Unicast",
    ["bytes_sent_unicast"] = "Bytes Sent Unicast",
    ["category"] = "Categories",
    ["cli_active_flows_anomalies"] = "Anomalies: Client Live Flows",
    ["cli_active_flows_behaviour"] = "Behaviour: Client Live Flows",
    ["cli_ports"] = "Top Client Ports",
    ["cli_score"] = "Score as Client",
    ["cli_score_anomalies"] = "Anomalies: Client Score",
    ["cli_score_behaviour"] = "Behaviour: Client Score",
    ["cli_tcp_ports"] = "Client TCP Ports",
    ["cli_udp_ports"] = "Client UDP Ports",
    ["contacted_hosts"] = "Contacted Hosts",
    ["contacts"] = "Contacts",
    ["custom"] = "Custom",
    ["discarded_probing_bytes"] = "Discarded Probing Traffic",
    ["discarded_probing_packets"] = "Discarded Probing Packets",
    ["dns_qry_rcvd_rsp_sent"] = "DNS Rcvd Queries / Sent Repls",
    ["dns_qry_sent_rsp_rcvd"] = "DNS Sent Queries / Rcvd Repls",
    ["download_chart_data"] = "Download the current chart data",
    ["download_records"] = "Download Records",
    ["dropped_alerts"] = "Dropped Alerts",
    ["dropped_flows"] = "Dropped Flows",
    ["dscp_classes"] = "DSCP Classes",
    ["dumped_flows"] = "Exported Flows",
    ["echo_reply_packets"] = "Echo Reply Packets",
    ["echo_request_packets"] = "Echo Request Packets",
    ["engaged_alerts"] = "Engaged Alerts",
    ["errors"] = "Errors",
    ["export_flows_as_txt"] = "Export flows as TXT file",
    ["flow_status"] = "Alerted Status",
    ["flows_as_client"] = "Flows As Client",
    ["flows_as_server"] = "Flows As Server",
    ["flows_status_overview"] = "%{protocol} Flows Status Overview",
    ["flows_vs_local_hosts"] = "Live Flows vs Local Hosts",
    ["flows_vs_traffic"] = "Live Flows vs Traffic",
    ["get_permanent_link"] = "Get Permanent Link",
    ["graph_info"] = "Graph Info",
    ["host_contacts_behaviour"] = "Behaviour: Contacts",
    ["host_unreachable_flows"] = "Total Host Unreachable Flows",
    ["hosts_anomalies"] = "Hosts Anomalies",
    ["http_stats"] = "HTTP Stats",
    ["inactive_hosts"] = "Inactive Hosts",
    ["influxdb_not_responding"] = "Query has been aborted as InfluxDB is not responding. Query timeout can be configured from the <a href=\"%{url}\">%{flask_icon} Preferences</a> .",
    ["interface_label"] = "Interface %{if_name}",
    ["interface_label_packets"] = "%{if_name} Packets",
    ["interface_label_traffic"] = "%{if_name} Traffic RX/TX",
    ["interfaces"] = "Interfaces",
    ["intranet_traffic"] = "%{net_1} -> %{net_2}",
    ["l4_proto"] = "Traffic Protocols",
    ["l7_proto"] = "Applications",
    ["last_ms"] = "Last ms",
    ["loc_host_anomalies"] = "Local Hosts Anomalies",
    ["lower_bound"] = "Lower Bound",
    ["max"] = "Max",
    ["max_ms"] = "Max ms",
    ["max_rtt"] = "Max RTT Time",
    ["memory_vs_hosts_flows"] = "Process Memory vs Hosts/Flows",
    ["min_rtt"] = "Min RTT Time",
    ["minute_interface_top_stats"] = "Minute Interface Top Traffic Statistics",
    ["name_lookup"] = "Name Lookup",
    ["new_flows"] = "New Flows",
    ["non_unicast_rcvd"] = "Non-Unicast Rcvd",
    ["non_unicast_sent"] = "Non-Unicast Sent",
    ["note_ases_rcvd"] = "Traffic received the traffic received by the autonomous system.",
    ["note_ases_sent"] = "Traffic sent is the traffic sent by the autonomous system.",
    ["note_ases_traffic"] = "Traffic shown is sent and received by the autonomous system.",
    ["note_chart_zoom"] = "Click and drag on the chart to zoom in, double click to zoom out.",
    ["note_protocols_shown"] = "Applications not seen in the selected timeframe are not listed in the dropdown.",
    ["num_blacklisted_flows"] = "Flows with Blacklisted Hosts",
    ["num_calls"] = "Num calls",
    ["num_cve"] = "CVEs",
    ["num_hosts"] = "Hosts",
    ["num_ms_rtt"] = "RTT Time ms",
    ["num_nfq_drops"] = "Dropped Packets",
    ["num_nfq_pct"] = "Queue Fill %%",
    ["num_open_ports"] = "Open Ports",
    ["num_scans"] = "Hosts Scanned",
    ["num_servers"] = "Num. Servers",
    ["packet_drops"] = "Packet Drops",
    ["packets"] = "Packets",
    ["packets_rcvd"] = "Packets Received",
    ["packets_sent"] = "Packets Sent",
    ["packets_vs_drops"] = "Packets vs Drops",
    ["peak_memory"] = "Peak Memory",
    ["percentile"] = "95th <a href=\"%{url}\">Percentile</a>",
    ["periodicity_map_entries"] = "Periodicity Map Entries",
    ["permanent_link"] = "Permanent Link",
    ["pkt_drops"] = "Pkt Drops",
    ["process_alerts"] = "Process Alerts",
    ["process_memory"] = "Process Memory",
    ["query_too_much_time"] = "The query is taking a long time to complete",
    ["query_too_slow"] = "The query has taken too much time to complete",
    ["query_was_aborted"] = "Query was aborted",
    ["raw_flows"] = "Raw Flows",
    ["raw_proto_flows"] = "Raw %{proto} Flows",
    ["red_line_unreachable"] = "A red line indicates the time the host has been unreachable.",
    ["rem_host_anomalies"] = "Remote Hosts Anomalies",
    ["reset_zoom"] = "Reset Zoom",
    ["right_axis_note"] = "(right axis)",
    ["rtt"] = "Round Trip Time",
    ["rtt_as_client"] = "RTT as Client",
    ["rtt_as_server"] = "RTT as Server",
    ["scanned_hosts"] = "Scanned Hosts",
    ["score"] = "Score",
    ["score_anomalies"] = "Anomalies: Score",
    ["score_behavior"] = "Behaviour: Score",
    ["score_vs_hosts_flows"] = "Score vs Hosts/Flows",
    ["service_map_entries"] = "Service Map Entries",
    ["srv_active_flows_anomalies"] = "Anomalies: Server Live Flows",
    ["srv_active_flows_behaviour"] = "Behaviour: Server Live Flows",
    ["srv_ports"] = "Server Ports",
    ["srv_score"] = "Score as Server",
    ["srv_score_anomalies"] = "Anomalies: Server Score",
    ["srv_score_behaviour"] = "Behaviour: Server Score",
    ["srv_tcp_ports"] = "Server TCP Ports",
    ["srv_udp_ports"] = "Server UDP Ports",
    ["tcp_finack_packets"] = "TCP FIN+ACK Packets",
    ["tcp_flags"] = "TCP Flags",
    ["tcp_packets"] = "TCP Packets",
    ["tcp_packets_keep_alive"] = "TCP Packets KeepAlive",
    ["tcp_packets_lost"] = "TCP Packets Lost",
    ["tcp_packets_ooo"] = "TCP Packets Out-Of-Order",
    ["tcp_packets_retr"] = "TCP Retransmitted Packets",
    ["tcp_retr_ooo_lost"] = "TCP Retransmitted Out-Of-Order and Lost",
    ["tcp_rst_packets"] = "TCP RST Packets",
    ["tcp_rx_stats"] = "TCP RX Stats",
    ["tcp_syn_packets"] = "TCP SYN Packets",
    ["tcp_syn_vs_tcp_synack"] = "TCP SYN vs SYN+ACK Packets",
    ["tcp_synack_packets"] = "TCP SYN+ACK Packets",
    ["tcp_tx_stats"] = "TCP TX Stats",
    ["the_select_timeframe_too_small_top_talkers"] = "The selected timeframe is too small to determine the top talkers. Please select at least a 1 minute frame.",
    ["throughput_bps"] = "Throughput (bps)",
    ["throughput_pps"] = "Throughput (pps)",
    ["top_10_ndpi_categories"] = "Top 10 Categories",
    ["top_10_ndpi_protocols"] = "Top 10 Applications",
    ["top_breed"] = "Top Breeds",
    ["top_checks"] = "Top %{subdir} Scripts by Duration",
    ["top_clients"] = "Top %{protocol} Clients",
    ["top_interfaces"] = "Top Interfaces",
    ["top_l7_contacts"] = "Top %{protocol} L7 Contacts",
    ["top_local_receivers"] = "Top Local Receivers",
    ["top_local_senders"] = "Top Local Senders",
    ["top_ndpi_categories"] = "Top Categories",
    ["top_ndpi_protocols"] = "Top Applications",
    ["top_profiles"] = "Top Profiles",
    ["top_receivers"] = "Top Receivers",
    ["top_senders"] = "Top Senders",
    ["top_servers"] = "Top %{protocol} Servers",
    ["tot_ms"] = "Total ms",
    ["total_alerted_flows"] = "Total Alerted Flows",
    ["total_flows"] = "Total Flows",
    ["total_unreachable_flows"] = "Total Port Unreachable Flows",
    ["traffic"] = "Traffic",
    ["traffic_anomalies"] = "Anomalies: Traffic RX/TX",
    ["traffic_ip"] = "Traffic IPv4/v6",
    ["traffic_nfq"] = "Traffic Total/Userspace",
    ["traffic_rcvd"] = "Traffic RX",
    ["traffic_rx_behavior"] = "Behaviour: Traffic RX",
    ["traffic_rxtx"] = "Traffic (RX + TX)",
    ["traffic_rxtx_netflow"] = "Traffic RX/TX",
    ["traffic_rxtx_sflow"] = "Traffic RX/TX",
    ["traffic_rxtx_snmp"] = "Traffic RX/TX (SNMP 5 min)",
    ["traffic_rxtx_snmp_min"] = "Traffic RX/TX (SNMP min)",
    ["traffic_sent"] = "Traffic TX",
    ["traffic_tx_behavior"] = "Behaviour: Traffic TX",
    ["traffic_userspace"] = "Userspace",
    ["traffic_vs_errors"] = "Traffic vs Errors",
    ["trend"] = "Trend",
    ["udp_packets"] = "UDP Packets",
    ["udp_sent_unicast_vs_non_unicast"] = "UDP sent Unicast vs Non Unicast",
    ["unicast_rcvd"] = "Unicast Rcvd",
    ["unicast_sent"] = "Unicast Sent",
    ["unidirectional_tcp_flows"] = "Unidirectional TCP Flows",
    ["unreachable_host"] = "Unreachable Host",
    ["upper_bound"] = "Upper Bound",
    ["usage"] = "Usage",
    ["variance_as_client"] = "Variance as Client",
    ["variance_as_server"] = "Variance as Server",
    ["zmq_flow_coll_drops"] = "Flow Collection Drops",
    ["zmq_flow_coll_udp_drops"] = "Collection Socket Drops",
    ["zmq_msg_dropped"] = "Dropped ZMQ Messages",
    ["zmq_msg_rcvd"] = "Collected ZMQ Messages",
    ["zmq_received_flows"] = "Collected ZMQ Flows",
    ["metric_labels"] = {
      ["alerted_flows"] = "Alerted Flows",
      ["alerts"] = "Alerts",
      ["anomalies"] = "Anomalies",
      ["as_cli"] = "As Client",
      ["as_srv"] = "As Server",
      ["blacklist_hits"] = "Blacklist Hits",
      ["blacklist_num_hits"] = "Num Hits",
      ["bytes"] = "Bytes",
      ["cli_score"] = "Client Score",
      ["contacts"] = "Contacts",
      ["containers"] = "Containers",
      ["devices"] = "Devices",
      ["downlink"] = "Downlink (In) Usage",
      ["dropped_flows"] = "Dropped Flows",
      ["dropped_msgs"] = "Dropped Messages",
      ["drops"] = "Drops",
      ["entries"] = "Entries",
      ["error_pkts"] = "Error Pkts.",
      ["errors"] = "Errors",
      ["exported_flows"] = "Exported Flows",
      ["exports"] = "Exports",
      ["flows"] = "Flows",
      ["hash_entries"] = "Hash Entries",
      ["hosts"] = "Hosts",
      ["in_bytes"] = "In Bytes",
      ["ipv4"] = "IPv4",
      ["ipv6"] = "IPv6",
      ["keys"] = "Keys",
      ["load"] = "Load",
      ["lost_packets"] = "Lost Pkts",
      ["memory"] = "Memory",
      ["ms"] = "Milliseconds",
      ["num_active"] = "active entries",
      ["num_containers"] = "Num. Containers",
      ["num_devices"] = "Num. Devices",
      ["num_flows"] = "Num. Flows",
      ["num_hosts"] = "Num. Hosts",
      ["num_idle"] = "idle entries",
      ["num_points"] = "Num. Points",
      ["num_servers"] = "Num. Servers",
      ["ok_pkts"] = "Ok Pkts.",
      ["ooo_pkts"] = "O. of O. Pkts",
      ["out_bytes"] = "Out Bytes",
      ["packets"] = "Packets",
      ["packets_disc"] = "Packets Discarded",
      ["pkts_vs_drops"] = "Pkts VS Drops",
      ["queries"] = "Queries",
      ["queries_pkts"] = "Pkts. Queries",
      ["rcvd"] = "Rcvd",
      ["rcvd_msgs"] = "Rcvd Messages",
      ["retran_pkts"] = "Retra. Pkts",
      ["rtt"] = "RTT",
      ["score"] = "Score",
      ["sent"] = "Sent",
      ["sent_non_uni"] = "Sent non Uni.",
      ["sent_uni"] = "Sent Uni.",
      ["servers"] = "Servers",
      ["srv_score"] = "Server Score",
      ["throughput"] = "Throughput",
      ["top_blacklist_hits"] = "Top Blacklist Hits",
      ["traffic"] = "Traffic",
      ["uplink"] = "Uplink (Out) Usage",
    },
    ["metrics_prefixes"] = {
      ["broadcast_bytes"] = "Broadcast Bytes",
      ["chart"] = "Chart",
      ["drops"] = "Drops",
      ["num_devices"] = "Num Devices",
      ["num_flows"] = "Num Flows",
      ["num_hits"] = "Hits",
      ["num_hosts"] = "Entries",
      ["num_http_hosts"] = "Num HTTP Hosts",
      ["num_ms_rtt"] = "RTT ms",
      ["packets"] = "Packets",
    },
    ["metrics_suffixes"] = {
      ["by_as"] = "%{metric} by AS",
      ["egress"] = "Egress",
      ["ingress"] = "Ingress",
      ["inner"] = "Inner",
      ["rcvd"] = "rcvd",
      ["sent"] = "sent",
    },
    ["network_broadcast_traffic"] = {
      ["egress"] = "Broadcast Traffic Egress",
      ["ingress"] = "Broadcast Traffic Ingress",
      ["inner"] = "Broadcast Traffic Inner",
      ["total"] = "Broadcast Traffic (Ingress+Egress+Inner)",
    },
    ["network_traffic"] = {
      ["egress"] = "Traffic Egress",
      ["ingress"] = "Traffic Ingress",
      ["inner"] = "Traffic Inner",
      ["total"] = "Traffic (Ingress+Egress+Inner)",
    },
    ["snmp"] = {
      ["drop"] = "Drop",
      ["post"] = "Post",
      ["pre"] = "Pre",
    },
  },
  ["hash_table"] = {
    ["AggregatedFlowHash"] = "Aggregated Flows",
    ["AutonomousSystemHash"] = "Autonomous Systems",
    ["CountriesHash"] = "Countries",
    ["FlowHash"] = "Flows",
    ["HostHash"] = "Hosts",
    ["MacHash"] = "MACs",
    ["ObservationPointHash"] = "Observation Points",
    ["VlanHash"] = "VLANs",
  },
  ["host_config"] = {
    ["active_monitor_enable"] = "Active Monitoring is currently disabled. It can be enabled <a href=\"%{url}\">here</a>.",
    ["custom_name"] = "Custom Name",
    ["custom_notes"] = "Custom Notes",
    ["drop_all_host_traffic"] = "Drop All Host Traffic",
    ["drop_all_host_traffic_description"] = "By enabling this option all the traffic of this host is going to be dropped.",
    ["host_alias"] = "Host Alias",
    ["host_alias_description"] = "The host alias is going to be used instead of the host name.",
    ["host_config"] = "Host Configuration",
    ["host_notes_description"] = "This save a note for this host (e.g. to remember the role of the host, like router, switch, ...).",
    ["host_pool"] = "Host Pool",
    ["host_pool_description"] = "This is going to change the host pool associated with this host.",
    ["host_status"] = "Host Status",
    ["host_traffic_policy"] = "Host Traffic Policy",
    ["modify_host_pool_policy_btn"] = "Modify Host Pool Policy",
    ["nedge_user_description"] = "This is going to change the user associated with this host.",
    ["trigger_alerts_for_host"] = "Trigger alerts for Host %{host}",
    ["trigger_host_alerts"] = "Trigger Host Alerts",
    ["unblock_host_traffic"] = "Unblock Host Traffic",
  },
  ["host_details"] = {
    ["active_alerted_flows"] = "Active Alerted Flows",
    ["application"] = "Application",
    ["applications"] = "Applications",
    ["applications_tab"] = "Applications",
    ["attempted_reset_flows"] = "Reset / Attempted Flows",
    ["behavioural_anomalies"] = "Behavioural Counter Anomalies",
    ["blocked_traffic"] = "Blocked Traffic",
    ["breakdown"] = "Breakdown",
    ["categories_tab"] = "Categories",
    ["category"] = "Category",
    ["client_score"] = "Client",
    ["disabled_alert_type_help"] = "Turn off flow alerts generation based on flow status",
    ["duration"] = "Duration",
    ["host"] = "Host",
    ["host_cannot_be_found_message"] = "Host %{host} cannot be found.",
    ["host_parameter_missing_message"] = "Host parameter is missing (internal error ?)",
    ["host_restore_in_progress"] = "Restoring host %{host}...",
    ["host_traffic_blocked_quota"] = "Some host traffic has been blocked by an exceeded quota",
    ["host_traffic_blocked_quota_and_shaper"] = "Some host traffic has been blocked by an exceeded quota and a blocking shaper",
    ["host_traffic_blocked_shaper"] = "Some host traffic has been blocked by a blocking shaper",
    ["hosts_using_proto"] = "Hosts using %{proto}",
    ["inactive_host_x"] = "%{host} [Inactive]",
    ["list_of_general_purpose"] = "General purpose devices: %{list}",
    ["list_of_special_purpose"] = "Special purpose devices: %{list}",
    ["multiple_selection"] = "Multiple elements can be selected by pressing the CTRL key",
    ["notes"] = "Notes",
    ["rcvd"] = "Rcvd",
    ["reset_blacklisted_stats"] = "Reset Blacklisted Hosts Stats",
    ["reset_blacklisted_stats_confirm"] = "Do you really want to reset \"%{host}\" blacklisted stats?",
    ["reset_blacklisted_stats_note"] = "<b>NOTE</b>: these info are visible into the host map 'Flows with Blacklisted Host'",
    ["reset_host_stats"] = "Reset Host Stats",
    ["reset_host_stats_confirm"] = "Do you really want to reset \"%{host}\" runtime stats?",
    ["reset_host_stats_note"] = "<b>NOTE</b>: historical charts for this host may have a gap after the reset.",
    ["reset_stats_in_progress"] = "Host statistics will be reset within 5 seconds",
    ["restore_from_cache_message_v1"] = "Host %{host} is inactive. Click <a href=%{js_code}> here</a> to restore it from cache.",
    ["sent"] = "Sent",
    ["server_score"] = "Server",
    ["snmp"] = "SNMP",
    ["status_ignore"] = "Disabled Flow Status Alerts",
    ["tot_bytes"] = "Bytes",
    ["tot_percentage"] = "Percentage",
    ["trace_debug_host_info"] = "Host:%{hostinfo}, VLAN: %{vlan}",
    ["trace_debug_host_ip"] = "Host:%{hostip}, VLAN: %{vlan}",
    ["trace_debug_restored_host_info"] = "Restored Host Info",
    ["unknown_device_type"] = "Unknown Device Type",
  },
  ["host_log_collector"] = {
    ["description"] = "Collect syslog logs from hosts and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "Host Log",
  },
  ["host_pools"] = {
    ["active_pool_members"] = "Active pool members",
    ["add_host_pool_member"] = "Add Host Pool Member",
    ["alias_or_manufacturer"] = "Alias / Manufacturer",
    ["and_associated_members"] = "its historical data and any associated members",
    ["cannot_delete_cp"] = "A pool cannot be deleted if there is any Captive Portal user associated",
    ["change_member_pool"] = "Change Member Pool",
    ["change_pool"] = "Switch Pool",
    ["children_safe"] = "Child Safe",
    ["cidr"] = "CIDR",
    ["click_here_host_pool"] = "Click here to go to the Host Pool page",
    ["config_export"] = "Export Configuration",
    ["config_import"] = "Import Configuration",
    ["config_import_message"] = "Note: host pools with the same name will be replaced.",
    ["confirm_delete_pool"] = "Do you really want to delete host pool",
    ["confirm_empty_pool"] = "Do you really want to remove all members from host pool",
    ["confirm_remove_member"] = "Do you really want to remove member",
    ["confirm_reset_pool_quotas"] = "Do you really want to reset the \"%{pool}\" pool couters?",
    ["confirm_reset_quotas"] = "Do you really want to reset all the quotas counters?",
    ["create_new_quotas_here"] = "You can create new quotas <a href=\"%{url}\">here</a>.",
    ["create_pool_hint"] = "You can create new pools from the Manage Pools tab.",
    ["create_pools"] = "Manage Pools",
    ["delete_pool"] = "Delete Pool",
    ["duplicate_member"] = "Duplicate member address",
    ["duplicate_pool"] = "Duplicate pool name",
    ["edit_host_pool_member"] = "Edit members",
    ["edit_host_pools"] = "Edit Host Pools",
    ["empty_pool"] = "Empty Pool",
    ["enforce_quotas_per_pool_member"] = "Per-Member Quotas",
    ["enforce_shapers_per_pool_member"] = "Per-Member Shapers",
    ["from_pool"] = "from host pool",
    ["host_members"] = "Host/Network/MAC Pool Members",
    ["host_pools"] = "Host/Network/MAC Pools",
    ["import_hosts"] = "Import Host Pools Members",
    ["import_hosts_desc"] = "Upload a CSV file containing host pool members to insert.",
    ["import_hosts_title"] = "Import Host Pool Members: %{pool}",
    ["invalid_member"] = "Invalid member address format",
    ["ip_address"] = "IP Address",
    ["ip_filter"] = "IPv4/IPv6",
    ["ipv4"] = "IPv4",
    ["ipv6"] = "IPv6",
    ["mac_address"] = "MAC Address",
    ["mac_filter"] = "MAC Address",
    ["manage_pool"] = "Manage Pool",
    ["manage_pools"] = "Manage Pool Membership",
    ["manufacturer_filter"] = "Manufacturer: %{manufacturer}",
    ["max_members_message"] = "With this version of ntopng you can only assign %{maxnum} members per host pool. Upgrade to the Enterprise version to remove this limit.",
    ["max_pools_message"] = "With this version of ntopng you can only create %{maxnum} host pools. Upgrade to the Enterprise version to remove this limit.",
    ["member_address"] = "Member Address",
    ["member_exists"] = "member \"%{member_name}\" not added. It is already assigned to pool \"%{member_pool}\".",
    ["member_filter"] = "Member: %{member}",
    ["member_type"] = "Member Type",
    ["members_limit_reached"] = "members limit reached",
    ["network"] = "Network",
    ["network_normalized"] = "network \"%{network}\" has a non-zero host identifier. Using \"%{network_normalized}\".",
    ["new_host_pool"] = "New Host Pool",
    ["new_pool"] = "New Pool",
    ["no_hosts_defined"] = "No host pool defined.",
    ["no_pools_defined"] = "No Host Pools defined.",
    ["per_member_quotas"] = "When the per-member quotas option is set, each host will have a separate quota count. When unset, all hosts traffic will count as a whole to the quota limit",
    ["per_member_shapers"] = "When the per-member shapers option is set, each host will its own shapers. When unset, all hosts belonging to the same pool will share the same shapers",
    ["policy"] = "Current Policy",
    ["pool"] = "Pool Name",
    ["pool_name"] = "Pool Name",
    ["pool_name_pattern_error"] = "Please enter only lowercase characters, numbers or underscore",
    ["remove_member"] = "Remove Member",
    ["remove_member_pool"] = "Are you really sure to remove the member: '%{member}' from the pool '%{pool}'?",
    ["reset_quotas"] = "Reset Quotas",
    ["search_member"] = "Search Member",
    ["select_host_pool"] = "Current <b>Host Pool</b>",
    ["select_member_type"] = "Select a member type",
    ["select_new_pool"] = "Select a new pool from the dropdown below to assign member \"%{member}\" to:",
    ["select_policy"] = "Select the new Policy",
    ["specify_member_address"] = "Please specify an IPv4/IPv6 address or network or a MAC address",
    ["specify_pool_name"] = "Specify a pool name",
    ["type_valid"] = "Type a valid %input",
    ["view"] = "View",
    ["validation"] = {
      ["abort_add_member"] = "Abort add new Host Pool Member?",
      ["abort_add_pool"] = "Abort add new pool?",
      ["abort_edit_pool"] = "Abort edit pool?",
    },
  },
  ["hosts_comparison"] = {
    ["hosts_parameter_missing_message"] = "Hosts parameter is missing (internal error ?)",
  },
  ["hosts_map_page"] = {
    ["active_alert_flows"] = "Active Alerted Flows",
    ["alerted_flows"] = "Total Alerted Flows",
    ["all_flows"] = "All Flows",
    ["blacklisted_flows_hosts"] = "Flows with Blacklisted Hosts",
    ["dns_bytes"] = "DNS Traffic",
    ["dns_queries"] = "DNS Queries vs Replies",
    ["hosts_unidirectional_tcp_no_tx"] = "Hosts with RX-Only TCP Flows",
    ["ntp_packets"] = "NTP Traffic",
    ["score"] = "Host Score",
    ["syn_distribution"] = "SYN Distribution",
    ["syn_vs_rst"] = "SYN vs RST",
    ["syn_vs_synack"] = "SYN vs SYNACK",
    ["tcp_bytes_sent_vs_rcvd"] = "TCP Bytes Sent/Received",
    ["tcp_pkts_sent_vs_rcvd"] = "TCP Packets Sent/Received",
    ["traffic_ratio"] = "Traffic Ratio",
    ["unreach_flows"] = "Unreacheable Flows",
    ["labels"] = {
      ["af_c"] = "Alerted Flows as Client",
      ["af_s"] = "Alerted Flows as Server",
      ["b_ratio"] = "Bytes Ratio [-100 = Download, 0 = Mixed, 100 = Upload]",
      ["blacklisted_as_client"] = "Num Client Flows with Blacklisted Hosts",
      ["blacklisted_as_server"] = "Num Server Flows with Blacklisted Hosts",
      ["client_score"] = "Score as Attacker",
      ["dns_p_r"] = "Positive DNS Replies Received",
      ["dns_r"] = "DNS Bytes Received",
      ["dns_s"] = "DNS Queries Sent",
      ["dns_sent"] = "DNS Bytes Sent",
      ["f_a_c"] = "Alerted Flows as Client",
      ["f_a_s"] = "Alerted Flows as Server",
      ["f_c"] = "Flows as Client",
      ["f_s"] = "Flows as Server",
      ["hosts_unidirectional_tcp_no_tx_as_client"] = "RX-Only TCP Flows as Client",
      ["hosts_unidirectional_tcp_no_tx_as_server"] = "RX-Only TCP Flows as Server",
      ["ntp_r"] = "NTP Packets Received",
      ["ntp_s"] = "NTP Packets Sent",
      ["p_ratio"] = "Packets Ratio [-1 = Download, 0 = Mixed, 1 = Upload]",
      ["rst_r"] = "# of RST Received",
      ["sa_r"] = "# of SYN/ACK Received",
      ["server_score"] = "Score as Victim",
      ["syn_r"] = "# of SYN Received",
      ["syn_s"] = "# of SYN Sent",
      ["tcp_b_r"] = "TCP Bytes Received",
      ["tcp_b_s"] = "TCP Bytes Sent",
      ["tcp_p_r"] = "TCP Packets Received",
      ["tcp_p_s"] = "TCP Packets Sent",
      ["uf_c"] = "Unreachable Flows as Client",
      ["uf_s"] = "Unreachable Flows as Server",
    },
  },
  ["hosts_stats"] = {
    ["all"] = "All",
    ["all_hosts"] = "All Hosts",
    ["as_geolocation"] = "AS Geolocation",
    ["as_info"] = "AS Info",
    ["as_path"] = "AS Path",
    ["as_prefixes"] = "AS Prefixes",
    ["asn_title"] = "for AS %{asn}",
    ["bgp_updates"] = "BGP Updates",
    ["blacklisted"] = "Blacklisted",
    ["blacklisted_hosts_only"] = "Blacklisted Hosts",
    ["blocking_traffic_policy_popup_msg"] = "Host traffic is affected by a blocking Traffic Policy",
    ["broadcast_and_multicast"] = "Broadcast or Multicast Hosts",
    ["broadcast_domain_hosts_only"] = "Broadcast Domain Hosts",
    ["country_title"] = "for Country %{country}",
    ["crawler_bot_scanner"] = "Crawler/Bot/Scanner",
    ["filter_hosts"] = "Filter Hosts",
    ["filtered"] = "Filtered",
    ["filtered_hosts_only"] = "Hosts With Blocked Traffic",
    ["host_pool"] = "Host Pool %{pool_name}",
    ["hosts"] = "Hosts",
    ["hosts_list"] = "Hosts List",
    ["hosts_page_title"] = "%{all} %{vlan_name} %{traffic_type} %{device_ip} %{local_remote} %{protocol} %{network_cidr} %{network} %{ip_version} %{os} Hosts %{country_asn_or_mac} %{vlan} %{charts_icon} %{wheel}",
    ["idle_hosts_not_listed"] = "Idle hosts not listed.",
    ["in_network"] = "%{network}",
    ["ipver_title"] = "IPv%{version_num}",
    ["label_blacklisted_host"] = "Blacklisted",
    ["label_broadcast_domain_host"] = "Broadcast Domain",
    ["label_local_host"] = "Local",
    ["label_remote_host"] = "Remote",
    ["local"] = "Local",
    ["local_hosts_only"] = "Local Unicast",
    ["local_no_tcp_tx"] = "Local Unicast TCP/UDP No TX",
    ["local_no_tx"] = "Local Unicast No TX",
    ["location"] = "Location",
    ["mac_title"] = "with MAC %{mac}",
    ["more_info_about_as_popup_msg"] = "More Information about AS",
    ["pool_title"] = "for Pool %{poolname}",
    ["probe_traffic"] = "[Probe %{device_ip}]",
    ["remote"] = "Remote",
    ["remote_hosts_only"] = "Remote Hosts",
    ["remote_no_tcp_tx"] = "Remote TCP/UDP No TX",
    ["remote_no_tx"] = "Remote No TX",
    ["source_id"] = "Source Id",
    ["traffic_type_all"] = "All Hosts",
    ["traffic_type_one_way"] = "One-Way Traffic",
    ["traffic_type_two_ways"] = "Bidirectional Traffic",
    ["user"] = "User %{pool_name}",
    ["user_title"] = "for User %{poolname}",
    ["vlan_title"] = "VLAN %{vlan}",
    ["page_scan_hosts"] = {
      ["add_host"] = "Add Host/Network to Scan",
      ["add_to_scan_list"] = "Add Host to Vulnerability Scan List",
      ["automatic_scan"] = "Scan Frequency",
      ["cidr_placeholder"] = "24",
      ["daily"] = "Nightly",
      ["delete_host_description"] = "Are you sure to delete the selected Host?",
      ["delete_host_title"] = "Delete Host",
      ["disabled"] = "Disabled",
      ["download_last_scan_result"] = "Download Last Scan Report",
      ["download_page"] = "Report",
      ["edit_host"] = "Edit Host/Network",
      ["edit_host_title"] = "Edit Host/Network to Scan",
      ["enable_clickhouse"] = "Please use ClickHouse to enable the archive page for Vulnerability Scan Reports.",
      ["enable_clickhouse_toast_label"] = "Use ClickHouse to store Vulnerability Scan Reports and enable the <a target='_blank' href='%{link}'>archive page</a>.",
      ["error"] = "Error",
      ["every_night"] = "Nightly",
      ["every_week"] = "Weekly",
      ["failed"] = "Failed",
      ["filtered_port"] = "Filtered Port",
      ["host"] = "Host",
      ["host_discovered_scan_type"] = "Sub Scans",
      ["host_is_not_up_and_running"] = "Host down or unreachable.",
      ["host_name"] = "Name",
      ["host_not_resolved"] = "host not found, please insert a valid host",
      ["host_or_network"] = "Host/Network",
      ["host_placeholder"] = "IP",
      ["host_report"] = "Host (Scan Type) (Last Scan)",
      ["in_progress"] = "In Progress",
      ["inconsistency_state"] = "Found inconsistency, rescanning port: %{port}",
      ["ip_address"] = "Address",
      ["last_scan"] = "Last Scan",
      ["last_scan_status"] = "Status",
      ["load_nmap_ports"] = "Scan Host Ports",
      ["load_ports"] = "Load Open Ports",
      ["no_cves_detected"] = "No CVEs detected",
      ["no_ports_detected"] = "No Ports Detected!",
      ["not_scanned"] = "Not Yet Scanned",
      ["not_yet"] = "Not Yet Scanned",
      ["notification_endpoint"] = "notification endpoint",
      ["num_open_ports"] = "Open Ports",
      ["num_open_ports_tcp"] = "TCP Ports",
      ["num_open_ports_udp"] = "UDP Ports",
      ["num_vulnerabilities_found"] = "CVEs",
      ["periodicity"] = "Periodicity",
      ["periodicity_scan_1_day_started"] = "Daily Vulnerability Scan started.",
      ["periodicity_scan_1_week_started"] = "Weekly Vulnerability Scan started.",
      ["ports"] = "Ports",
      ["ports_placeholder"] = "Example: 22,8080 or 1-1024",
      ["prefs_tab_title"] = "Vulnerability Scan",
      ["scan_command_param"] = "Scan Parameters",
      ["scan_duration"] = "Last Duration",
      ["scan_type"] = "Scan Type",
      ["scanning"] = "Scanning",
      ["schedule_all_scan"] = "Schedule All Scans",
      ["schedule_scan"] = "Schedule Scan",
      ["scheduled"] = "Scheduled",
      ["score"] = "Score",
      ["service_name"] = "Service Name",
      ["show_hosts"] = "Show Hosts",
      ["show_result"] = "Show Last Scan Report",
      ["success"] = "Success",
      ["tcp_ports"] = "TCP Ports List",
      ["title"] = "Hosts to Scan",
      ["title_hosts_page"] = "CVEs",
      ["udp_ports"] = "UDP Ports List",
      ["unused_port"] = "Unused Port",
      ["update_all"] = "Update All",
      ["update_periodicity_title"] = "Batch Edit",
      ["vs_result"] = "Vulnerability Scan Report of %{host} at %{date}",
      ["vs_result_ipv4_netscan"] = "IPv4 Netscan Report",
      ["vs_result_no_longer_down"] = "Hosts No Longer Down Report",
      ["vs_result_total_reports"] = "Vulnerability Scan Report",
      ["vulnerabilities"] = "Vulnerabilities",
      ["vulnerabilities_found_list"] = "CVEs List",
      ["vulnerability_scan_reports"] = "Vulnerability Scan Reports",
      ["weekly"] = "Weekly",
      ["email"] = {
        ["discrepancy"] = "<br>Found some discrepancy with respect to the previous scan: %{new_ports_open} new ports open, %{cves_fixed} CVEs fixed.</br><br>Discrepancies details:<ul>%{hosts_discrepancy_details}</ul>",
        ["host_cve_discrepancy_description"] = "<li>%{host_id} has solved these CVEs: %{cves}.</li>",
        ["host_details"] = "----- Host <b>%{host_id}</b> -----<ul> %{details} </ul>",
        ["host_details_cves"] = "<li>Num CVEs: %{cves_num} (%{cves_list})</li>",
        ["host_details_open_ports"] = "<li>%{l4_proto} open ports: %{ports_list}</li>",
        ["host_details_scan_type"] = "<li>Scan Type: %{scan_type}</li>",
        ["host_down_item"] = "<li>%{host_id}</li>",
        ["host_down_list"] = "<ul>%{host_down_items}</ul>",
        ["host_port_discrepancy_description"] = "<li>%{host_id} has new %{port_type} ports open: %{ports}.</li>",
        ["hosts_no_longer_down"] = "%{add_br}%{no_longer_down_now_num}%{no_longer_down_list}",
        ["netscan_new_hosts"] = "%{add_br}On network %{net_scan} new hosts detected: %{num_hosts} %{host_list}",
        ["no_cves"] = "No CVEs found",
        ["no_discrepancy"] = "<br>No changes found since last scan.</br>",
        ["no_new_hosts_detected"] = "No new hosts detected on subnets %{subnets}",
        ["no_scanned_hosts"] = "No hosts scanned.",
        ["no_skipped_hosts"] = "No skipped hosts.",
        ["no_tcp"] = "no TCP open ports found",
        ["no_udp"] = "no UDP open ports found",
        ["num_cves"] = "%{num} CVEs",
        ["num_failed_scanned_hosts"] = "Hosts down or unreachable: %{num}",
        ["num_no_longer_down_now"] = "Hosts no longer down currently: %{num}",
        ["num_scanned_hosts"] = "Scanned Hosts: %{num}",
        ["num_tcp"] = "%{num} TCP open ports",
        ["num_udp"] = "%{num} UDP open ports",
        ["periodicity_scan_1_day_ended"] = "<br>Daily Vulnerability Scan successfully completed.</br><br>Start/End time %{start_date} - %{end_date} [Duration: %{duration}].</br><br>%{scanned_hosts}</br><br>%{not_scanned_hosts}%{skipped_hosts_list}%{no_hosts_down_br}%{cves}, %{udp_ports}, %{tcp_ports}.</br>",
        ["periodicity_scan_1_week_ended"] = "<br>Weekly Vulnerability Scan successfully completed.</br><br>Start/End time %{start_date} - %{end_date} [Duration: %{duration}].</br><br>%{scanned_hosts}</br><br>%{not_scanned_hosts}%{skipped_hosts_list}%{no_hosts_down_br}%{cves}, %{udp_ports}, %{tcp_ports}.</br>",
        ["report_link_line"] = "%{add_br}For further information see <a href='%{url}'>Vulnerability Scan Report</a>.",
        ["scan_all_ended"] = "<br>Vulnerability Scan of all entries successfully completed.</br><br>Start/End time %{start_date} - %{end_date} [Duration: %{duration}].</br><br>%{scanned_hosts}</br><br>%{not_scanned_hosts}%{skipped_hosts_list}%{no_hosts_down_br}%{cves}, %{udp_ports}, %{tcp_ports}.</br>",
        ["vulnerability_scan_report_title"] = "Vulnerability Scan Report",
      },
      ["notes"] = {
        ["generic_notes_1"] = "If a <a href=\"${http_prefix}/lua/admin/endpoint_notifications_list.lua\">notification endpoint</a> and the related recipient with the ‘Notification Type’ set to ‘Vulnerability Scan Reports’ are enabled, a notification is sent when the periodic vulnerability scan begins and ends.",
        ["note_1"] = "Host: host IP to scan.",
        ["note_2"] = "Ports: a comma-separated list (or port range) of ports; if empty, all host ports are going to be considered. If ntopng knows the specified it, clicking on the load open ports button, populates the Ports field with the known host server ports.",
        ["note_3"] = "Scan Type: select a specific vulnerability scan type.",
        ["note_3_1"] = "Sub Scans: select the scan type for hosts discovered in the initial netscan for a subsequent scan.",
        ["note_4"] = "Periodicity: select the automatic scan frequency.",
      },
      ["report"] = {
        ["address"] = "Address",
        ["count"] = "Hosts Count",
        ["cves"] = "CVEs",
        ["cves_list"] = "CVEs List",
        ["cves_title"] = "ID (Score)",
        ["host_name"] = "Name",
        ["hosts"] = "Hosts",
        ["ip_address"] = "IP Address",
        ["last_scan"] = "Last Scan",
        ["network"] = "Network",
        ["port"] = "Port",
        ["scan_type"] = "Scan Type",
        ["score"] = "Score",
        ["tcp_ports"] = "TCP Ports",
        ["tcp_udp_ports"] = "TCP/UDP Ports",
        ["title"] = "Report",
        ["udp_ports"] = "UDP Ports",
      },
      ["reports_page"] = {
        ["cves"] = "Num CVEs",
        ["date"] = "Date",
        ["delete_description"] = "Are you sure to remove the selected report? This action cannot be undone.",
        ["delete_title"] = "Delete Report",
        ["edit_report"] = "Edit Report",
        ["name"] = "Name",
        ["num_hosts"] = "Num Hosts",
        ["reports"] = "Scan Reports",
        ["tcp_ports"] = "Num TCP Ports",
        ["udp_ports"] = "Num UDP Ports",
        ["notes"] = {
          ["note_1"] = "Name: new report name.",
        },
      },
      ["scan_type_list"] = {
        ["cve"] = "CVE",
        ["ipv4_netscan"] = "IPv4 Netscan",
        ["openvas"] = "OpenVAS",
        ["tcp_portscan"] = "TCP Portscan",
        ["udp_portscan"] = "UDP Portscan",
        ["vulners"] = "Vulners",
      },
    },
  },
  ["http_info"] = {
    ["methods"] = {
      ["connect"] = "CONNECT",
      ["delete"] = "DELETE",
      ["get"] = "GET",
      ["head"] = "HEAD",
      ["options"] = "OPTIONS",
      ["patch"] = "PATCH",
      ["post"] = "POST",
      ["put"] = "PUT",
      ["trace"] = "TRACE",
    },
    ["return_codes"] = {
      ["100"] = "Continue",
      ["101"] = "Switching Protocols",
      ["102"] = "Processing",
      ["103"] = "Early Hints",
      ["200"] = "OK",
      ["201"] = "Created",
      ["202"] = "Accepted",
      ["203"] = "Non-Authoritative Information",
      ["204"] = "No Content",
      ["205"] = "Reset Content",
      ["206"] = "Partial Content",
      ["207"] = "Multi-Status",
      ["208"] = "Already Reported",
      ["226"] = "IM Used",
      ["300"] = "Multiple Choice",
      ["301"] = "Moved Permanently",
      ["302"] = "Found",
      ["303"] = "See Other",
      ["304"] = "Not Modified",
      ["305"] = "Use Proxy",
      ["307"] = "Temporary Redirect",
      ["308"] = "Permanent Redirect",
      ["400"] = "Bad Request",
      ["401"] = "Unauthorized",
      ["402"] = "Payment Required",
      ["403"] = "Forbidden",
      ["404"] = "Not Found",
      ["405"] = "Method Not Allowed",
      ["406"] = "Not Acceptable",
      ["407"] = "Proxy Authentication Required",
      ["408"] = "Request Timeout",
      ["409"] = "Conflict",
      ["410"] = "Gone",
      ["411"] = "Length Required",
      ["412"] = "Precondition Failed",
      ["413"] = "Payload Too Large",
      ["414"] = "URI Too Long",
      ["415"] = "Unsupported Media Type",
      ["416"] = "Range Not Satisfiable",
      ["417"] = "Expectation Failed",
      ["418"] = "I'm a teapot",
      ["421"] = "Misdirected Request",
      ["422"] = "Unprocessable Entity",
      ["423"] = "Locked",
      ["424"] = "Failed Dependency",
      ["425"] = "Too Early",
      ["426"] = "Upgrade Required",
      ["428"] = "Precondition Required",
      ["429"] = "Too Many Requests",
      ["431"] = "Request Header Fields Too Large",
      ["451"] = "Unavailable For Legal Reasons",
      ["500"] = "Internal Server Error",
      ["501"] = "Not Implemented",
      ["502"] = "Bad Gateway",
      ["503"] = "Service Unavailable",
      ["504"] = "Gateway Timeout",
      ["505"] = "HTTP Version Not Supported",
      ["506"] = "Variant Also Negotiates",
      ["507"] = "Insufficient Storage",
      ["508"] = "Loop Detected",
      ["510"] = "Not Executed",
      ["511"] = "Network Authentication Required",
    },
  },
  ["http_page"] = {
    ["distribution"] = "Distribution",
    ["http_queries"] = "HTTP Queries Sent",
    ["http_responses"] = "HTTP Responses Received",
    ["method"] = "Method",
    ["other_method"] = "Other Method",
    ["requests"] = "Requests",
    ["requests_served"] = "Requests Served",
    ["response_code"] = "Response code",
    ["response_code_1xx"] = "1xx (Informational)",
    ["response_code_2xx"] = "2xx (Success)",
    ["response_code_3xx"] = "3xx (Redirection)",
    ["response_code_4xx"] = "4xx (Client Error)",
    ["response_code_5xx"] = "5xx (Server Error)",
    ["responses"] = "Responses",
    ["traffic_received"] = "Traffic Received",
    ["traffic_sent"] = "Traffic Sent",
    ["virtual_hosts"] = "Virtual Hosts",
  },
  ["http_servers_stats"] = {
    ["actual_requests"] = "Actual Requests",
    ["bytes_received"] = "Bytes Received",
    ["bytes_sent"] = "Bytes Sent",
    ["http_server_ip"] = "HTTP Server IP",
    ["http_servers"] = "HTTP Servers",
    ["http_virtual_host"] = "HTTP Virtual Host",
    ["local_http_servers"] = "Local HTTP Servers",
    ["total_requests"] = "Total Requests",
  },
  ["http_status_code"] = {
    ["bad_request"] = "The URL specified contains invalid/dangerous characters",
    ["enterprise_only"] = "Enterprise edition license required",
    ["forbidden"] = "Forbidden page",
    ["internal_error"] = "Internal server error",
    ["not_found"] = "The requested page cannot be found",
    ["pro_only"] = "Professional/Enterprise edition license required",
    ["shut_start"] = "Unable to serve requests at this time, possibly starting up or shutting down",
  },
  ["icmp_info"] = {
    ["type"] = {
      ["0"] = {
        ["info"] = "Echo reply",
        ["code"] = {
        },
      },
      ["10"] = {
        ["info"] = "Router selection",
        ["code"] = {
        },
      },
      ["11"] = {
        ["info"] = "Time exceeded",
        ["code"] = {
          ["0"] = "Time to live exceeded in transit",
          ["1"] = "Fragment reassembly time exceeded",
        },
      },
      ["12"] = {
        ["info"] = "Parameter problem",
        ["code"] = {
          ["0"] = "Pointer indicates the error",
        },
      },
      ["13"] = {
        ["info"] = "Timestamp",
        ["code"] = {
        },
      },
      ["14"] = {
        ["info"] = "Timestamp reply",
        ["code"] = {
        },
      },
      ["15"] = {
        ["info"] = "Information request",
        ["code"] = {
        },
      },
      ["16"] = {
        ["info"] = "Information reply",
        ["code"] = {
        },
      },
      ["17"] = {
        ["info"] = "Address mask request",
        ["code"] = {
        },
      },
      ["18"] = {
        ["info"] = "Address mask reply",
        ["code"] = {
        },
      },
      ["3"] = {
        ["info"] = "Destination unreachable",
        ["code"] = {
          ["0"] = "Net unreachable",
          ["1"] = "Host unreachable",
          ["2"] = "Protocol unreachable",
          ["3"] = "Port unreachable",
          ["4"] = "Fragmentation needed and DF set",
          ["5"] = "Source route failed",
        },
      },
      ["30"] = {
        ["info"] = "Traceroute",
        ["code"] = {
          ["0"] = "Outbound Packet successfully forwarded",
          ["1"] = "No route for Outbound Packet; packet discarded",
        },
      },
      ["4"] = {
        ["info"] = "Source quench",
        ["code"] = {
        },
      },
      ["5"] = {
        ["info"] = "Redirect",
        ["code"] = {
          ["0"] = "Redirect datagrams for the Network",
          ["1"] = "Redirect datagrams for the Host",
          ["2"] = "Redirect datagrams for the Type of Service and Network",
          ["3"] = "Redirect datagrams for the Type of Service and Host",
        },
      },
      ["8"] = {
        ["info"] = "Echo",
        ["code"] = {
        },
      },
      ["9"] = {
        ["info"] = "Router advertisement",
        ["code"] = {
        },
      },
    },
  },
  ["icmp_page"] = {
    ["icmp_code"] = "Code",
    ["icmp_message"] = "ICMP Message",
    ["icmp_port_unreachable_extra"] = "%{unreach_protocol} port %{unreach_port} unreachable on %{unreach_host}",
    ["icmp_type"] = "Type",
    ["last_rcvd_peer"] = "Last Rcvd Peer",
    ["last_sent_peer"] = "Last Sent Peer",
    ["packets_received"] = "Packets Received",
    ["packets_sent"] = "Packets Sent",
  },
  ["if_stats_config"] = {
    ["add_host_rules_title"] = "Add Rule",
    ["add_rules_type"] = "Rule type",
    ["add_rules_type_cidr"] = "Networks",
    ["add_rules_type_flow_exporter"] = "Flow Exporter Device",
    ["add_rules_type_host"] = "Host",
    ["add_rules_type_host_pool"] = "Host Pools",
    ["add_rules_type_interface"] = "Interface",
    ["add_rules_type_profiles"] = "Profiles",
    ["add_rules_type_snmp"] = "SNMP Device",
    ["add_rules_type_vlans"] = "VLANs",
    ["automatic_reports_creation"] = "Create Daily Reports",
    ["companion_interface"] = "Companion Interface",
    ["custom_name"] = "Custom Name",
    ["custom_name_popup_msg"] = "Specify an alias for the interface",
    ["delete_host_rules_description"] = "Are you sure to delete the selected Host Rule?",
    ["delete_host_rules_title"] = "Delete Rule",
    ["discard_probing_traffic"] = "Discard Probing Traffic",
    ["dump_flows_to_database"] = "Dump Flows to Database",
    ["edit_host_rules_title"] = "Edit Rule",
    ["edit_local_network_rules"] = "Edit Rule",
    ["frequency"] = "Check Frequency",
    ["generic_notes_1"] = "Trigger an alert when a local host exceeds the specified traffic amount",
    ["generic_notes_2"] = "To add a new rule, click the '+' symbol on the right side above the table (next to the search)",
    ["generic_notes_3"] = "To remove a rule, click on the 'Actions' column button and then click onto 'Delete' on the row you want to remove",
    ["gw_macs"] = "MAC Address Based Traffic Directions",
    ["gw_macs_description"] = "This is used to compute traffic direction (ingress or egress) based on the provided MAC address(es) (comma-separated list) as in some case (when capturing traffic from a traffic mirror or PCAP) it is not possible to know the traffic direction. Traffic directed to the configured MAC address(es) is considered as egress traffic.<br><b>Note:</b><br>In case no MAC address is configured, the traffic direction is set using local vs remote hosts traffic (-m).",
    ["gw_macs_example"] = "e.g. %{example}",
    ["hide_from_top_networks"] = "Hide from Top Networks",
    ["hide_from_top_networks_descr"] = "e.g. %{example}",
    ["host_placeholder"] = "A local host IP or '*' for checking all local hosts",
    ["host_threshold_rules"] = "JSON Host Rules",
    ["interface_network_discovery"] = "Periodic Interface Network Discovery",
    ["interface_speed"] = "Interface Speed",
    ["interface_speed_measure_unit"] = "(Mbit/s)",
    ["interface_speed_popup_msg"] = "Specify the maximum interface speed",
    ["interface_top_talkers_creation"] = "Create Interface Top Talkers",
    ["is_mirrored_traffic"] = "Mirrored Traffic",
    ["last_measurement"] = "Last Measurement",
    ["metric"] = "Metric",
    ["multicast_ip_placeholder"] = "Multicast or Broadcast IP",
    ["note_1"] = "Target: insert the IP of a Local Host to be analyzed or a * (meaning that all Local Hosts has to be analyzed) or select a local network interface",
    ["note_2"] = "Metric: select the metric to be analyzed (e.g. DNS -> the DNS traffic)",
    ["note_3"] = "Frequency: select the frequency of the analysis (e.g. 5 Min -> analyzed every 5 minutes)",
    ["note_4"] = "Threshold: select the type of threshold (Volume, Throughput or Percentage), lowerbound or upperbound, and the threshold that, if exceeded, is going to trigger an alert",
    ["note_5"] = "Percentage Change: is calculated between the last two frequency checks (e.g., <1% with a frequency of 5 minutes; if the difference between the preceding frequency and the last 5-minute check is lower than 1%, trigger an alert).",
    ["note_6"] = "Absolute Percentage: is calculated relative to the speed of the SNMP device interface.",
    ["port_placeholder"] = "Port Value",
    ["referesh_rate_measure_unit"] = "(sec)",
    ["rule_type"] = "Type",
    ["scaling_factor"] = "Ingress Packets Sampling Rate",
    ["scaling_factor_popup_msg"] = "This should match your capture interface sampling rate",
    ["show_dyn_iface_traffic"] = "Duplicate Disaggregated Traffic",
    ["show_dyn_iface_traffic_note"] = "By enabling this option, traffic directed to dynamic or custom sub-interfaces is still shown in the master interface",
    ["snmp_device"] = "Device",
    ["snmp_interface"] = "Interface",
    ["target"] = "Target",
    ["target_exporter_device"] = "Exporter Device",
    ["target_exporter_device_ifid"] = "Network Interface",
    ["target_interface"] = "Network Interface Timeseries",
    ["target_profile"] = "Traffic Profile",
    ["target_vlan"] = "VLAN ID",
    ["threshold"] = "Threshold",
    ["toggle_push_host_filters"] = "Push Alerted Hosts to PF_RING",
    ["toggle_push_host_filters_note"] = "Push the IP address of alerted hosts to PF_RING through a Redis queue to filter and further analyse traffic on third party tools (e.g. IDS).",
    ["toggle_push_host_filters_queue"] = "Redis queue",
    ["traffic_rules"] = "Local Traffic Rules",
    ["trigger_interface_alerts"] = "Trigger Interface Alerts",
    ["note_snmp_device_rules"] = {
      ["note_1"] = "Device: select the SNMP Device to be analyzed",
      ["note_2"] = "Interface: select the interface of the SNMP device that needs to be analyzed.",
      ["note_3"] = "Metric: select the metric to be analyzed (e.g. errors -> the SNMP metric errors)",
    },
  },
  ["if_stats_networks"] = {
    ["no_broadcast_domains"] = "No broadcast domains inferred by inspecting ARP traffic.",
    ["no_ip_addresses_read"] = "No IP addresses read from the configuration.",
    ["note_ghost_bcast_domains"] = "The %{ghost_icon} highlights ghost broadcast domains (i.e. not belonging to any of the interface IP addresses networks).",
    ["note_iface_addresses"] = "IP addresses are read from the interface configuration.",
    ["note_iface_bcast_domains"] = "Broadcast domains are inferred by inspecting ARP traffic.",
  },
  ["if_stats_overview"] = {
    ["active"] = "Active",
    ["alert_events"] = "Alert Events",
    ["all_counters"] = "All Counters",
    ["blocked_flows"] = "Blocked Flows",
    ["bridged_traffic"] = "Bridged Traffic",
    ["buffer_full"] = "Buffer Full",
    ["collected_flows"] = "Collected Flows",
    ["collected_logs"] = "Collected Logs",
    ["conntrack_flow_entries"] = "Conntrack Flow Entries",
    ["counter_anomalies"] = "Counter Anomalies",
    ["db_statistics"] = "DB Statistics",
    ["direct_mode"] = "Direct Mode",
    ["discarded_flows"] = "Discarded Flows (by ntopng)",
    ["discarded_probing_traffic"] = "Discarded Probing Traffic",
    ["discarded_records"] = "Discarded Records (Bad Flows)",
    ["dispatched_logs"] = "Dispatched Events",
    ["dropped_alerts_info"] = "Number of non-engaged alerts which could not be written to disk because of a full alerts queue.",
    ["dropped_flows"] = "nProbe Dropped Flows",
    ["dropped_flows_by_nprobe"] = "nProbe Dropped Flows",
    ["dropped_flows_last_24_h_by_nprobe"] = "nProbe Dropped Flows Last 24h",
    ["dropped_packets"] = "Dropped Packets",
    ["dropped_probe_packets"] = "nProbe Dropped Pkts",
    ["drops_only"] = "Drops Only",
    ["dumped_files"] = "Dumped Files",
    ["dumped_packets"] = "Dumped Packets",
    ["egress_packets"] = "Egress Packets",
    ["expired_maintenance"] = "Expired",
    ["export_disabled"] = "Flows Export Disabled in Runtime Preferences",
    ["exported_flows"] = "Exported Flows",
    ["family"] = "Family",
    ["flow_exporters_num"] = "Exporters",
    ["flows_export_statistics"] = "Flows Export Statistics",
    ["handled_logs"] = "Detected Events",
    ["has_traffic_directions"] = "with RX/TX Directions",
    ["host_correlations"] = "Host Correlations",
    ["id"] = "Id",
    ["iface_switch_active_msg"] = "The selected interface <b>%{interface}</b> [ifid: %{ifid}] is now active",
    ["iface_switch_empty_session_msg"] = "Empty session",
    ["iface_switch_error_msg"] = "Error while switching interfaces",
    ["in_path_interface"] = "In-Path Interface (Bump in the Wire)",
    ["ingress_packets"] = "Ingress Packets",
    ["ingress_traffic"] = "Ingress Traffic",
    ["interface_ip"] = "Interface IP",
    ["interface_name"] = "Interface",
    ["interface_rx_updates"] = "Interface Updates",
    ["malformed_logs"] = "Malformed Logs",
    ["nf"] = "Netfilter",
    ["nf_enobufs"] = "No Buffer Space",
    ["nf_handle_packet_failed"] = "Queued Packets Handling Failures",
    ["nf_queue_dropped"] = "Dropped Packets (Queue Full)",
    ["nf_queue_pct"] = "Queue Fill Level",
    ["nf_queue_total"] = "Queued Packets",
    ["nf_queue_user_dropped"] = "Dropped Packets (Couldn't Send to Userspace)",
    ["no_license"] = "None",
    ["note"] = "NOTE",
    ["note_drop_ifstats_dynamic"] = "Drops are available in the main interface",
    ["note_drops_sflow"] = "Drops are shown only for sFlow as NetFlow does not report them.<br><A HREF=https://www.ietf.org/rfc/rfc3176.txt>sFlow</A> drops count the number of times the sFlow agent detected that a packet marked to be sampled was dropped due to lack of resources. The drops counter reports the total number of drops detected since the agent was last reset. A high drop rate indicates that the management agent is unable to process samples as fast as they are being generated by hardware. Increasing the sFlow sampling rate will reduce the drop rate. Note: An agent that cannot detect drops will always report zero.",
    ["note_lifetime_timeout"] = "Regardless of the flow duration, a flow that has been active for more that the specified maximum <A HREF=https://www.ntop.org/guides/nprobe/cli_options.html?highlight=maximum%20flow%20lifetime>lifetime</A> is considered expired and it will be emitted (nProbe -t option)",
    ["note_packets"] = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble (7 bytes), start of frame (1 byte), CRC (4 bytes), and <A HREF=\"http://en.wikipedia.org/wiki/Interframe_gap\">IFG</A> (12 bytes)]. Such overhead needs to be accounted to the interface traffic, but it is not added to the traffic being exchanged between IP addresses. This is because such data contributes to interface load, but it cannot be accounted in the traffic being exchanged by hosts, and thus expect little discrepancies between host and interface traffic values.",
    ["note_probe_zmq_drops_export_queue_full"] = "Remote probe has successfully processed these flows but is was unable to enqueue them for the export as the export queue was full.",
    ["note_probe_zmq_drops_flow_collection_drops"] = "Total number of dropped flows due on the nProbe side (e.g. due to collection or export drops)",
    ["note_probe_zmq_drops_flow_collection_udp_socket_drops"] = "Dropped flow packets on the nProbe collection socket",
    ["note_probe_zmq_timeout_lifetime"] = "Flow lifetime duration as advertised by nProbe and the real lifetime computed on collected flows",
    ["note_remote_probe_time"] = "Difference in seconds between ntopng time and remote nProbe time: ideally it should be close to zero. If too large please sync nProbe/ntopng time",
    ["other_probes"] = "%{num} other probes",
    ["paused"] = "Paused",
    ["probe_ip"] = "nProbe IP",
    ["probe_last_update"] = "Last Update",
    ["probe_public_ip"] = "Public IP",
    ["probe_throughput"] = "nProbe Throughput",
    ["probe_timeout_idle"] = "Idle Timeout",
    ["probe_timeout_lifetime"] = "Lifetime Timeout",
    ["probe_uuid"] = "UUID",
    ["probe_zmq_drops_export_queue_full"] = "Queue Full Dropped Flows",
    ["probe_zmq_drops_flow_collection_drops"] = "Flow Collection Drops",
    ["probe_zmq_drops_flow_collection_udp_socket_drops"] = "Collection Socket Drops",
    ["probe_zmq_num_endpoints"] = "Active Probe ZMQ Endpoints",
    ["probe_zmq_num_flow_exports"] = "Exported Flows",
    ["processed_records"] = "Processed Flow Records",
    ["public_probe_ip"] = "Public Probe IP",
    ["received_traffic"] = "Received Traffic",
    ["remote_flow_lifetime"] = "Flow Lifetime",
    ["remote_probe"] = "nProbe",
    ["remote_probe_collecting_from_x_devices"] = "Collecting from <a href=\"%{url}\">%{num} nProbe</a>.",
    ["remote_probe_collecting_from_x_devices_no_link"] = "Collecting from %{num} nProbe.",
    ["remote_probe_collector_mode"] = "Collector Mode",
    ["remote_probe_edition"] = "Edition",
    ["remote_probe_license"] = "License",
    ["remote_probe_maintenance"] = "Maintenance",
    ["remote_probe_showing_first_x_devices"] = "Showing the first %{num}.",
    ["remote_probe_time"] = "nProbe Time Drift",
    ["remote_probe_uuid"] = "nProbe UUID",
    ["reset_counters"] = "Reset Counters",
    ["rrd_timeseries"] = "RRD Timeseries",
    ["send_error"] = "Send Error",
    ["sflow_counter_updates"] = "Counter Updates",
    ["shaped_filtered_packets"] = "Shaped/Filtered Packets",
    ["snmp"] = "SNMP",
    ["state"] = "State",
    ["syslog_statistics"] = "Syslog Collection Statistics",
    ["traffic_breakdown"] = "Traffic Breakdown",
    ["traffic_statistics"] = "Traffic Statistics",
    ["unhandled_logs"] = "Unsupported Events",
    ["zmq_avg_msg_flows"] = "Avg Flows/Msg",
    ["zmq_download_conf"] = "Download Sample Configuration",
    ["zmq_encryption_alias"] = "******************",
    ["zmq_encryption_public_key"] = "ZMQ Encryption Public Key",
    ["zmq_encryption_public_key_note"] = "Please add --zmq-encryption-key '%{key}' to the nProbe configuration similar to the below (set the ntopng address properly):",
    ["zmq_message_drops"] = "Dropped ZMQ Messages",
    ["zmq_message_rcvd"] = "Collected ZMQ Messages",
    ["zmq_rx_statistics"] = "ZMQ Statistics",
  },
  ["index_page"] = {
    ["applications"] = "Applications",
    ["asns"] = "ASNs",
    ["dashboard"] = "Dashboard",
    ["hosts"] = "Hosts",
    ["live_update"] = "Live update",
    ["minute"] = "Minute",
    ["never"] = "Never",
    ["no_packet_warning"] = "No packet has been received yet on interface %{ifname}.<p>Please wait %{countdown} seconds until this page reloads.",
    ["refresh"] = "Refresh",
    ["refresh_frequency"] = "Refresh frequency",
    ["refresh_graph_popup_msg"] = "Refresh graph",
    ["seconds"] = "Seconds",
    ["senders"] = "Senders",
    ["top_flow_talkers"] = "Top Flow Talkers",
  },
  ["infrastructure_dashboard"] = {
    ["actions"] = "Actions",
    ["add_instance"] = "Add %{product} Instance",
    ["chart"] = "Chart",
    ["edit_instance"] = "Edit %{product} Instance",
    ["fetching_data"] = "Fetching data",
    ["information"] = "Information",
    ["infrastructure"] = "Infrastructure",
    ["infrastructure_dashboard"] = "Infrastructure",
    ["name"] = "Name",
    ["not_polled_yet"] = "Not polled yet",
    ["ntopng_instance"] = "%{product} Instance",
    ["remove_instance"] = "Do you really want to delete '%{instance}' instance?",
    ["status"] = "Status",
    ["url"] = "URL",
    ["collected_stats"] = {
      ["alerts"] = "Alerts",
      ["download"] = "Download",
      ["engaged_alerts"] = "Engaged Alerts",
      ["flow_alerts"] = "Flow Alerts",
      ["flows"] = "Flows",
      ["hosts"] = "Hosts",
      ["last_update"] = "Last Update",
      ["throughput"] = "Throughput",
      ["upload"] = "Upload",
    },
    ["modal"] = {
      ["bandwidth_threshold"] = "Bandwidth Threshold",
      ["failed_login"] = "The authentication has failed, please check if the User Authentication Token has been changed!",
      ["hint_token"] = "A Token can be generated from the user profile page.",
      ["insert_instance"] = "%{product}-instance",
      ["instance_alias"] = "Instance Alias",
      ["instance_url"] = "URL",
      ["password"] = "Password",
      ["rtt_threshold"] = "RTT Threshold",
      ["seconds"] = "sec",
      ["successfull_login"] = "The remote instance has responded succesfully!",
      ["test_auth"] = "Check",
      ["testing_authentication"] = "Testing authentication",
      ["threshold_hint"] = "Minimum threshold to trigger an alert",
      ["token"] = "User Authentication Token",
      ["unknown_host"] = "The authentication has failed, please check if the URL is right!",
      ["url_hint"] = "The remote instance URL",
      ["username"] = "Username",
    },
    ["validation"] = {
      ["abort_add"] = "Abort add of new instance?",
      ["abort_edit"] = "Abort edit of the current instance?",
    },
  },
  ["input_item_list"] = {
    ["dns_input_list_description"] = "Comma separated values of allowed DNS IPs. Example: 192.168.1.1",
    ["dns_input_list_title"] = "Allowed DNS",
    ["ntp_input_list_description"] = "Comma separated values of allowed NTP IPs. Example: 192.168.1.1",
    ["ntp_input_list_title"] = "Allowed NTP",
    ["smtp_input_list_description"] = "Comma separated values of allowed SMTP IPs. Example: 192.168.1.1",
    ["smtp_input_list_title"] = "Allowed SMTP",
  },
  ["internals"] = {
    ["alert_drops"] = "Interface Alerts Drops",
    ["alert_drops_descr"] = "Trigger an alert when alerts are dropped. Likely, this is due to too many alerts generated or slow recipients.",
    ["all_check_targets"] = "All User Script Targets",
    ["all_hash_tables"] = "All Hash Tables",
    ["all_periodic_activities"] = "All Periodic Activities",
    ["any_periodic_activity_issue"] = "Activities with Issues",
    ["chart_script_duration"] = "%{script} Duration",
    ["chart_script_rrds"] = "%{script} TS Stats",
    ["check"] = "User Script",
    ["check_target"] = "Target",
    ["checks"] = "Behavioural Checks",
    ["degraded_performance"] = "Degraded Performance",
    ["duration"] = "Duration",
    ["exporters_limit_exceeded"] = "Exporters Limit Exceeded",
    ["exporters_limit_exceeded_descr"] = "Trigger an alert when an higher number of exporters is detected based on the ntopng License.",
    ["exporters_limit_exceeded_title"] = "Exporters Limit Exceeded",
    ["flow_calls_stats"] = "flow.lua Calls Stats",
    ["flow_lua_duration"] = "flow.lua Duration",
    ["hash_entries"] = "Hash Entries",
    ["hash_table"] = "Hash Table",
    ["hash_table_utilization"] = "Hash Table Utilization",
    ["hash_tables"] = "Hash Tables",
    ["high_idle_entries"] = "High number of idle entries",
    ["iface_hash_tables"] = "%{iface} Hash Tables",
    ["iface_periodic_scripts"] = "%{iface} Periodic Activities",
    ["in_progress_since"] = "In Progress Since",
    ["last_duration_ms"] = "Last Duration",
    ["last_num_calls"] = "Last Num Calls",
    ["last_start_time"] = "Last Start",
    ["last_start_time_ago"] = "%{time} ago",
    ["lua"] = "Lua",
    ["max_duration_ms"] = "Max Duration",
    ["max_duration_secs"] = "Max Duration",
    ["missed_idle"] = "Missed Idle",
    ["missed_periodic_update"] = "Missed Periodic Update",
    ["missed_proto_detected"] = "Missed Proto Detected",
    ["num_calls"] = "%{script} Num Calls",
    ["num_calls_vs_duration"] = "Lua Calls vs Duration",
    ["num_drops"] = "Points Dropped",
    ["num_failed_enqueues"] = "Failed Enqueues",
    ["num_missed_calls"] = "Num Missed Calls",
    ["num_writes"] = "Points Written",
    ["pending_periodic_update"] = "Pending Periodic Update",
    ["pending_proto_detected"] = "Pending Proto Detected",
    ["periodic_activities"] = "Periodic Activities",
    ["periodic_activities_descr"] = "Hover the mouse on any of the listed activites to read its description.",
    ["periodic_activities_last_start_time_descr"] = "Last Start indicates when the periodic activity was started the last time.",
    ["periodic_activities_max_duration_secs_descr"] = "Max Duration indicates how long a script is allowed to execute.",
    ["periodic_activities_not_shown"] = "Only periodic activities which have been scheduled at least once are shown.",
    ["periodic_activities_periodicity_descr"] = "Frequency indicates how often a periodic activity is scheduled for execution.",
    ["periodic_activities_rrd_descr"] = "TS stands for Timeseries.",
    ["periodic_activities_tot_not_executed_descr"] = "Not Executed counts the number of times a periodic activity wasn't scheduled for execution, either because it was already running (running slow) or already scheduled (no thread was available to execute it).",
    ["periodic_activities_tot_running_slow_descr"] = "Running Slow counts the number of times a periodic activity was taking too long to complete.",
    ["periodic_activity"] = "Periodic Activity",
    ["periodic_activity_issues"] = "Issues",
    ["periodicity"] = "Periodicity",
    ["queue"] = "Queue",
    ["queued"] = "Queued",
    ["queues"] = "Queues",
    ["rrd_drops"] = "TS Drops",
    ["script_deadline_exceeded"] = "Running Slow",
    ["script_deadline_exceeded_descr"] = "The script has taken too long to complete",
    ["script_duration"] = "%{script} Duration",
    ["script_not_executed"] = "Not Executed",
    ["script_not_executed_descr"] = "The script has been scheduled but has not been executed yet",
    ["script_num_calls"] = "%{script} Num Calls",
    ["script_stats"] = "%{script} vs Total",
    ["sleeping"] = "Sleeping",
    ["state_active"] = "Entries in Active State",
    ["state_idle"] = "Entries in Idle State",
    ["state_idle_vs_active"] = "Idle vs Active Entries",
    ["status_description"] = "A periodic activity can be in one of the following statuses:",
    ["status_queued_descr"] = "The activity has been scheduled but it isn't running yet",
    ["status_running_descr"] = "The activity is currently in execution",
    ["status_sleeping_descr"] = "The activity has completed and waiting for the next schedulation",
    ["successful_calls"] = "Successful Calls",
    ["system_alert_drops"] = "System Alerts Drops",
    ["system_alert_drops_descr"] = "Trigger an alert when system alerts are dropped as there is no room in the internal alerts queue. Likely, this is due to too many alerts generated.",
    ["system_error"] = "System Error",
    ["system_error_description"] = "Trigger an alert when a system error (ntopng failure) is detected",
    ["system_iface_periodic_scripts"] = "System Periodic Activities",
    ["time_exceeded"] = "Time Exceeded",
    ["time_usage"] = "Time Utilization",
    ["timeseries_queue_length"] = "TS Queue Length",
    ["timeseries_queued_points"] = "Queued Points",
    ["timeseries_writes"] = "TS Writes",
    ["tot_not_executed"] = "Not Executed",
    ["tot_running_slow"] = "Running Slow",
    ["total_duration"] = "Total %{subdir} Scripts Duration",
    ["total_flow_duration"] = "Total Duration",
    ["total_num_calls"] = "Total %{subdir} Scripts Num Calls",
    ["total_stats"] = "Total %{subdir} Scripts Stats",
    ["work_completion"] = "Completion",
  },
  ["invalid_filters"] = {
    ["double_arg"] = "Two identical parameters given \"%{args}\"",
    ["empty"] = "Empty filter list",
    ["few_args"] = "Incorrect parameters, required a filter and its value but given only one \"%{args}\"",
    ["incorrect_args"] = "Incorrect parameters, one of the parameters is not supported or incorrect \"%{args}\"",
    ["invalid_subdir"] = "Invalid subdir given",
  },
  ["kerberos_collector"] = {
    ["description"] = "Collect Kerberos authentication logs exported by NXLog in XML format: handle Identity Management (user correlation) and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "Kerberos/NXLog",
  },
  ["license_page"] = {
    ["agreement"] = "License Agreement",
    ["license"] = "License",
    ["not_valid"] = "Not Valid",
    ["status"] = "Status",
    ["valid"] = "Valid License",
  },
  ["live_capture"] = {
    ["active_live_captures"] = "Live Captures",
    ["live_capture"] = "Live Capture",
    ["note"] = "Capture live traffic for host %{hostinfo}. The stream will automatically stop after 1 minute or 100k packets.",
  },
  ["live_traffic"] = {
    ["error_generic"] = "Generic Error",
    ["error_not_found"] = "Not found",
    ["error_not_granted"] = "Request not granted",
    ["modal_vlan_tagged_with_bpf_confirmation"] = "This host is VLAN-tagged. The BPF filter submitted, to properly match packets, must contain VLAN 51. The VLAN can be specified in the filter as <br> <pre>vlan %{vlan} and <i>...rest of the filter...</i></pre>",
    ["modal_vlan_tagged_with_bpf_continue"] = "Continue",
    ["modal_vlan_tagged_with_bpf_title"] = "Host PCAP Download",
  },
  ["local_flow_matrix"] = {
    ["error_no_local_hosts"] = "No local hosts can be found",
    ["local_flow_matrix"] = "Local Flow Matrix",
    ["local_hosts_active_flows_matrix"] = "Local Hosts Live Flows Matrix",
  },
  ["local_hosts_stats"] = {
    ["criteria"] = "Criteria",
    ["looking_glass"] = "Looking Glass",
  },
  ["locales"] = {
    ["cn"] = "Chinese",
    ["cz"] = "Czech",
    ["de"] = "German",
    ["en"] = "English",
    ["es"] = "Spanish",
    ["fr"] = "French",
    ["it"] = "Italian",
    ["jp"] = "Japanese",
    ["ko"] = "Korean",
    ["pt"] = "Portuguese",
  },
  ["login"] = {
    ["add_captive_portal_user"] = "Add Captive Portal User",
    ["add_web_user"] = "Add Web User",
    ["already_logged"] = "Already logged in.",
    ["auth_success"] = "Authentication Successful",
    ["auth_token"] = "User Authentication Token",
    ["blacklisted_ip_notice"] = "Too many failed authentication attempts. Please retry in 5 minutes.",
    ["change_password"] = "Change Password",
    ["confirm_password"] = "Confirm Password",
    ["device_label"] = "Device Label",
    ["enter_credentials"] = "Please enter your credentials for accessing this network.",
    ["generate_token"] = "Generate Token",
    ["generate_token_help"] = "More info about <A target='_blank' href='https://www.ntop.org/guides/ntopng/advanced_features/authentication.html?highlight=token#token-based-authentication'>token-based authentication</A> <i class='fas fa-external-link-alt'></i>  in ntopng API calls.",
    ["informative_captive_join"] = "Access the Internet",
    ["informative_captive_portal_tos"] = "I have read and agreed the <a target='_blank' href='%{url}'>terms of service</a>.",
    ["internet_redirecting"] = "We're redirecting you to the Internet...",
    ["license"] = "%{product} is released under <a href=\"%{license_url}\">%{license}</a>.",
    ["links"] = "<A target=\"_blank\" href=\"https://www.ntop.org/support/documentation/documentation/\">User's Guides</A> | <A target=\"_blank\" HREF=\"https://www.ntop.org/community/\">Community</A> | <A target=\"_blank\" HREF=\"https://www.ntop.org/support/need-help-2/commercial-support/\">Support</A> | <A target=\"_blank\" HREF=\"https://www.ntop.org/support/documentation/faq/\">FAQ</A> | <A target=\"_blank\" HREF=\"https://github.com/ntop\">Code</A> | <A target=\"_blank\" href=\"https://www.ntop.org/support/need-help-2/contact-us/\">Contact Us</A>",
    ["logged_out"] = "Logged out",
    ["logging_out"] = "Logging out...",
    ["login"] = "Login",
    ["logout"] = "Logout",
    ["logout_message"] = "Are you sure you want to logout?",
    ["logout_user_x"] = "Logout %{user}",
    ["must_change_password"] = "Default admin password must be changed. Please enter a new password below.",
    ["password"] = "Password",
    ["password_mismatch"] = "Passwords do not match",
    ["password_not_valid"] = "Please specify a different password",
    ["password_pattern_error"] = "Please enter at least 5 valid characters.",
    ["password_ph"] = "Password (default admin)",
    ["passwords_dont_match"] = "Passwords don't match.",
    ["unable_to_login"] = "Unable to login?",
    ["unsupported_browser"] = "Your browser is not supported.<br>Please consider using a recent Firefox or Chrome.",
    ["username"] = "Username",
    ["username_ph"] = "Username (default admin)",
    ["web_users"] = "Web Users",
    ["welcome_to"] = "Welcome to %{product}",
    ["wrong-credentials"] = "Login failed: invalid username or password.",
  },
  ["mac_details"] = {
    ["and_n_more_hosts"] = "<a href='%{host_url}'>%{host_label}</a> and <a href='%{url}'>%{num} more host(s)</a>",
    ["and_one_more_host"] = "<a href='%{host_url}'>%{host_label}</a> and <a href='%{url}'>1 more host</a>",
    ["json_error_inactive"] = "JSON Error: inactive host purged or %{product} terminated?",
    ["mac"] = "MAC",
    ["mac_cannot_be_found_message"] = "MAC %{mac} cannot be found.",
    ["mac_host"] = "<a href='%{host_url}'>%{host_label}</a>",
    ["mac_parameter_missing_message"] = "MAC parameter is missing (internal error ?)",
    ["reset_mac_stats"] = "Reset MAC Stats",
    ["reset_mac_stats_note"] = "<b>NOTE</b>: historical charts for this mac address may have a gap after the reset.",
    ["reset_stats_in_progress"] = "MAC statistics will be reset within 5 seconds",
  },
  ["mac_stats"] = {
    ["all_devices"] = "All",
    ["all_layer_2_devices"] = "All Devices",
    ["all_manufacturers"] = "All Manufacturers",
    ["arp_total"] = "ARP",
    ["dev_layer_2_devices"] = "%{device_type} Devices",
    ["dhcp_only"] = "DHCP Hosts",
    ["filter_macs"] = "Filter MACs",
    ["idle_devices_not_listed"] = "Idle devices not listed.",
    ["inactive_macs"] = "Inactive MACs",
    ["layer_2_dev_devices"] = "%{device_type} Devices",
    ["layer_2_devices_with_manufacturer"] = "%{manufacturer} %{title}",
    ["layer_2_source_devices"] = "%{device_type} Devices",
    ["manufacturer"] = "Manufacturer",
    ["source_macs"] = "Source Only",
  },
  ["manage_configurations"] = {
    ["active_monitoring"] = "Active Monitoring",
    ["active_monitoring_vs"] = "Active Monitoring and Vulnerability Scan",
    ["after_behavior_changes"] = "<b>Restart</b> %{product} to make the behavior changes effective.",
    ["after_reset_request"] = "<b>Restart</b> %{product} to make the configuration factory reset effective.",
    ["checks"] = "Behavioural Checks",
    ["config_import"] = "Import <span class='item'>{{ type }}</span> Configuration",
    ["everything"] = "Entire %{product} configuration (includes users, preferences, and all configurations below)",
    ["export_policy"] = "Export nProbe IPS Policy",
    ["infrastructure_instances"] = "Infrastructure Instances",
    ["manage_configuration"] = "Manage Configurations",
    ["manage_configurations"] = "Configurations",
    ["manage_configurations_backup"] = "Nightly Backups",
    ["notifications"] = "Endpoints and Recipients",
    ["pool_endpoint_recipients"] = "Pools",
    ["restart_request"] = "<b>Restart</b> %{product} to make the changes set effective.",
    ["snmp"] = "SNMP",
    ["snmp_config_moved"] = "SNMP Configuration import/export can be found in the SNMP Page",
    ["factory_reset"] = {
      ["body"] = "Reset configuration to factory. All custom changes will be lost.",
      ["title"] = "Reset <span class='selected-item'>%{reset_element}</span> Configuration",
    },
    ["import_modal"] = {
      ["all_title"] = "Import %{product} Configuration",
      ["title"] = "Import <span class='selected-item'>%{import_element}</span> Configuration",
    },
    ["messages"] = {
      ["import_all_success"] = "Configuration imported successfully. Please <b>restart ntopng</b> to make the imported configuration effective.",
      ["import_success"] = "The selected configuration has been imported successfully!",
      ["reset_all_success"] = "Factory reset request issued successfully. Please <b>restart %{product}</b> to make the configuration factory reset effective.",
      ["reset_success"] = "The selected configuration has been reset successfully!",
    },
  },
  ["manage_data"] = {
    ["all_hosts"] = "All",
    ["delete"] = "Purge Host Data",
    ["delete_active_interface"] = "Delete Interface Data",
    ["delete_inactive_interfaces"] = "Delete Inactive Interfaces Data",
    ["delete_system_interface_data"] = "Delete System Interface Data",
    ["delete_tab"] = "Delete",
    ["export"] = "Export Host Data",
    ["export_tab"] = "Export",
    ["hosts"] = "Hosts",
    ["inactive_interfaces_data"] = "Inactive Interfaces",
    ["inactive_interfaces_description"] = "Manage data of <b>Inactive Interfaces</b>, you can delete cached info about these interfaces.<br><br>The button below is enabled when inactive interfaces are configured.",
    ["ip_or_mac_address"] = "Specify",
    ["local_hosts"] = "Local",
    ["mac_or_ip_required"] = "Please insert a valid IP or MAC Address",
    ["manage_data"] = "Manage Data",
    ["purge_asset_inventory"] = "Purge Asset Inventory Cache",
    ["purge_asset_inventory_button"] = "Purge Asset Inventory",
    ["remote_hosts"] = "Remote",
    ["single"] = "Single",
    ["specify_ip_mac"] = "Specify Host IP or Mac Address or /24",
    ["specify_vlan"] = "Specify VLAN Host",
    ["system_interface_data"] = "System Interface",
    ["system_interface_description"] = "Manage cached data of the <b>System Interface</b>, you can delete the data to free up some space.<br><br>The button below is enabled when there is no delete pending request.",
    ["system_interface_note"] = "System Interface Data includes all the data located under the \"System\" menu entry, for example CPU, InfluxDB and SNMP data.",
  },
  ["manage_users"] = {
    ["add_new_user"] = "Add New User",
    ["administrator"] = "Administrator",
    ["allow_alerts"] = "Allow Alerts",
    ["allow_alerts_descr"] = "Allow the user to access Alerts.",
    ["allow_historical_flows"] = "Allow Historical Flows",
    ["allow_historical_flows_descr"] = "Allow the user to access Historical Flows and Reports, filtered based on the Allowed Networks configuration, if not empty.",
    ["allow_pcap_download"] = "Allow PCAP Download",
    ["allow_pcap_download_descr"] = "Allow the user to download live traffic and PCAPs.",
    ["allowed_interface"] = "Allowed Interface",
    ["allowed_networks"] = "Allowed Networks",
    ["allowed_networks_descr"] = "Comma separated list of networks this user can view. This applies to both runtime data and historical flows data, it does not apply to alerts. Format example:",
    ["allowed_passwd_charset"] = "Allowed characters are ISO 8859-1 (latin1) upper and lower case letters, numbers and special symbols",
    ["any_interface"] = "Any Interface",
    ["authentication_lifetime"] = "Authentication Lifetime",
    ["change_user_password"] = "Change User Password",
    ["change_user_preferences"] = "Change User Preferences",
    ["confirm_delete_user"] = "Are you sure you want to delete %{user}?",
    ["enable_captive_portal"] = "<a href=\"%{url}\">Enabling the captive portal</a> allows you to define captive portal users",
    ["expires_after"] = "Expires after",
    ["group"] = "Group",
    ["host_pool_id"] = "Host Pool Id",
    ["manage"] = "Manage",
    ["manage_user_x"] = "Manage User %{user}",
    ["manage_users"] = "Users",
    ["new_password"] = "New Password",
    ["new_password_confirm"] = "Confirm New Password",
    ["no_host_pools"] = "No Host Pools defined. Please create one <a href='%{url}'>here</a>",
    ["non_privileged_user"] = "Non Privileged User",
    ["old_password"] = "Old Password",
    ["the_auth_can_be_perpetual"] = "The authentication can be perpetual or can expire after the specified time",
    ["the_host_pool_associated"] = "Host pool that will be associated to the user upon successful authentication",
    ["token"] = "Token",
    ["token_not_generated"] = "Token not generated yet",
    ["unlimited"] = "Unlimited",
    ["user_role"] = "User Role",
    ["web_captive_users"] = "Web/Captive Portal Users",
  },
  ["map_page"] = {
    ["alerted_view"] = "Alerted View",
    ["allowed"] = "Allowed",
    ["asset_families"] = "All Asset Families",
    ["asset_family"] = "Asset Family",
    ["asset_in_edges"] = "Incoming Edges",
    ["asset_out_edges"] = "Outgoing Edges",
    ["asset_total_edges"] = "Total Edges",
    ["authorized"] = "Authorized",
    ["autolayout_services"] = "Autolayout Map",
    ["autolayout_services_message"] = "The Map auotolayout is going to probably change the positions of the nodes. Are you sure to proceed?",
    ["centrality_view"] = "Centrality View",
    ["client"] = "Client",
    ["delete_assets"] = "Delete Assets",
    ["delete_assets_message"] = "All the Assets are going to be delete. Are you sure to delete all the Assets?",
    ["delete_services"] = "Delete Services",
    ["delete_services_message"] = "All the services are going to be delete. Are you sure to delete all the Assets?",
    ["denied"] = "Denied",
    ["directions"] = "All Directions",
    ["download"] = "Download",
    ["download_message"] = "Download in Text format the Assets?",
    ["fetch_error"] = "Error while fetching Service Map Status.",
    ["filter_hosts"] = "Filters",
    ["first_seen"] = "First Seen",
    ["frequency"] = "Frequency",
    ["geo_map_notes"] = "Host details shown by clicking the markers can be modified from the preferences <a href=\"%{prefs_link}\"><i class=\"fas fa-cog\"></i></a>",
    ["graph_note_asset_map"] = "Hosts are represented as circles: <font color=#28a745>Local</font>, <font color=#6c757d>Remote</font>, <font color=#007bff>Multicast</font>, <font color=#17a2b8>Broadcast</font> hosts and <font color=#8004e0>MAC</font> addresses.<li>Double click on a node to jump to the host map. Use the mouse wheel to zoom in/out.</li>",
    ["graph_note_periodicity_map"] = "Hosts are represented as circles: <font color=#28a745>Local</font>, <font color=#6c757d>Remote</font>, <font color=#007bff>Multicast</font>, <font color=#17a2b8>Broadcast</font> hosts and <font color=#8004e0>MAC</font> addresses.<li>Double click on a node to jump to the host map. Use the mouse wheel to zoom in/out.</li>",
    ["graph_note_service_map"] = "Hosts are represented as circles: <font color=#28a745>Local</font>, <font color=#007bff>Multicast</font>, <font color=#17a2b8>Broadcast</font> hosts and <font color=#8004e0>MAC</font> addresses.<li>Edges represent a communication between two hosts: <font color=#28a745>authorized</font>, <font color=red>unauthorized</font>, and <font color=#ffc107>undecided</font> service status.<li>Double click on a node to jump to the host map. Use the mouse wheel to zoom in/out.</li>",
    ["graph_view"] = "Graph View",
    ["host"] = "Host",
    ["host_pools"] = "All Host Pools",
    ["in_edges"] = "Incoming Edges",
    ["info"] = "Info",
    ["l7proto"] = "Application",
    ["last_seen"] = "Last Seen",
    ["learning"] = "The Service Map is still <b>learning</b> <i class=\"fa-solid fa-marker\"></i>",
    ["learning_table"] = "The Service Map is <b>learning</b>, click on the reload table button to see new changes...",
    ["networks"] = "All Networks",
    ["no_services"] = "No services found.",
    ["num_uses"] = "Num Uses",
    ["observations"] = "Observations",
    ["only_mem_hosts"] = "Active Hosts",
    ["out_edges"] = "Outgoing Edges",
    ["port"] = "Port",
    ["protocol"] = "Protocol",
    ["protocols"] = "All Protocols",
    ["rank"] = "Rank",
    ["server"] = "Server",
    ["set_state"] = "Set %{label} service(s) status to: ",
    ["standard_view"] = "Standard View",
    ["status"] = "Status",
    ["statuses"] = "All Status",
    ["table_note_asset_map"] = "In graph analysis the number of edges is used to determine how important is a node.",
    ["table_note_periodicity_map"] = "The above table reports periodic activities (at various frequencies) that have been observed in the network.",
    ["table_note_service_map"] = "The services with the <b>Undecided</b> (<kbd class='bg-warning text-dark'><i class='fas fa-hourglass-half'></i></kbd>) status require a confirmation by the user. Once a service status has been confirmed it can be <b>Authorized</b> (<kbd class='bg-success'><i class='fas fa-check'></i></kbd>) or <b>Unauthorized</b> (<kbd class='bg-danger'><i class='fas fas fa-times'></i></kbd>).<li>Rank represents how important is a node in a network: higher is the rank more important is the node.",
    ["table_view"] = "Table View",
    ["total_edges"] = "Total Edges",
    ["unauthorized"] = "Unauthorized",
    ["undecided"] = "Undecided",
    ["vlan_id"] = "VLAN Id",
    ["vlans"] = "All VLANs",
    ["aging"] = {
      ["aging"] = "All Time",
      ["day"] = "Last Day",
      ["month"] = "Since Last Month",
      ["week"] = "Since Last Week",
    },
    ["assets"] = {
      ["dns"] = "DNS",
      ["imap"] = "IMAP",
      ["ntp"] = "NTP",
      ["pop"] = "POP",
      ["smtp"] = "SMTP",
    },
  },
  ["metrics"] = {
    ["days"] = "Days",
    ["hours"] = "Hours",
    ["mins"] = "Mins",
    ["minutes"] = "Minutes",
    ["secs"] = "Secs",
  },
  ["mitre"] = {
    ["mitre_id"] = "Mitre ID",
    ["mitre_sub_technique"] = "Mitre Subtechnique",
    ["mitre_tactic"] = "Mitre Tactic",
    ["mitre_technique"] = "Mitre Technique",
    ["sub_technique"] = {
      ["arp_cache_poisoning"] = "Arp Cache Poisoning",
      ["dhcp_spoofing"] = "DHCP Spoofing",
      ["direct_network_flood"] = "Direct Network Flood",
      ["dns"] = "DNS",
      ["dns_calculation"] = "DNS Calculation",
      ["dns_passive_dns"] = "DNS/Passive DNS",
      ["domain_fronting"] = "Domain Fronting",
      ["domain_generation_algorithms"] = "Domain Generation Algorithms",
      ["external_proxy"] = "External Proxy",
      ["mail_protocol"] = "Mail Protocol",
      ["malicious_link"] = "Malicious Link",
      ["multi_hop_proxy"] = "Multi-hop Proxy",
      ["network_device_config_dump"] = "Network Device Config Dump",
      ["network_topology"] = "Network Topology",
      ["one_way_communication"] = "One-Way Communication",
      ["port_knocking"] = "Port Knocking",
      ["protocol_impersonation"] = "Protocol Impersonation",
      ["rdp_hijacking"] = "RDP Hijacking",
      ["reflection_amplification"] = "Reflection Amplification",
      ["remote_desktop_proto"] = "Remote Desktop Protocol",
      ["smb_relay"] = "SMB Relay",
      ["smb_windows_admin_share"] = "SMB/Windows Admin Share",
      ["spearphishing_link"] = "Spearphishing Link",
      ["spearphishing_service"] = "Spearphishing Service",
      ["ssh"] = "SSH",
      ["web_protocol"] = "Web Protocol",
      ["wordlist_scanning"] = "Wordlist Scanning",
    },
    ["tactic"] = {
      ["c_and_c"] = "Command and Control",
      ["collection"] = "Collection",
      ["credential_access"] = "Credential Access",
      ["defense_evasion"] = "Defense Evasion",
      ["discovery"] = "Discovery",
      ["execution"] = "Execution",
      ["exfiltration"] = "Exfiltration",
      ["impact"] = "Impact",
      ["initial_access"] = "Initial Access",
      ["lateral_movement"] = "Lateral Movement",
      ["persistence"] = "Persistence",
      ["privilege_escalation"] = "Privilege Escalation",
      ["reconnaissance"] = "Reconnaissance",
      ["resource_develop"] = "Resource Development",
    },
    ["technique"] = {
      ["account_manipulation"] = "Account Manipulation",
      ["active_scanning"] = "Active Scanning",
      ["adversary_in_the_middle"] = "Adversary in the Middle",
      ["app_layer_proto"] = "Application Layer Protocol",
      ["automated_exf"] = "Automated Exfiltration",
      ["content_inj"] = "Content Injection",
      ["data_destruction"] = "Data Destruction",
      ["data_from_conf_repo"] = "Data from Configuration Repository",
      ["data_from_net_shared_driver"] = "Data from Network Shared Driver",
      ["data_manipulation"] = "Data Manipulation",
      ["data_obfuscation"] = "Data Obfuscation",
      ["drive_by_compr"] = "Drive by Compromise",
      ["dynamic_resolution"] = "Dynamic Resolution",
      ["encrypted_channel"] = "Encrypted Channel",
      ["endpoint_ddos"] = "Endpoint Denial of Service",
      ["exfiltration_over_alt_proto"] = "Exfiltration Over Alternative Protocol",
      ["exfiltration_over_c2_channel"] = "Exfiltration Over C2 Channel",
      ["exfiltration_over_web_service"] = "Exfiltration Over Web Service",
      ["expl_privilege_escalation"] = "Exploitation for Privilege Escalation",
      ["exploit_pub_facing_app"] = "Exploit Public-Facing Application",
      ["exploitatation_client_exec"] = "Exploitation for Client Execution",
      ["ext_remote_services"] = "External Remote Services",
      ["forced_authentication"] = "Forced Authentication",
      ["gather_victim_net_info"] = "Gather Victim Network Info",
      ["hide_infrastructure"] = "Hide Infrastructure",
      ["impair_defenses"] = "Impair Defenses",
      ["indicator_removal"] = "Indicator Removal",
      ["ingress_tool_transfer"] = "Ingress Tool Transfer",
      ["internal_spearphishing"] = "Internal Spearphishing",
      ["lateral_tool_transfer"] = "Lateral Tool Transfer",
      ["network_ddos"] = "Network Denial of Service",
      ["network_service_discovery"] = "Network Service Discovery",
      ["network_sniffing"] = "Network Sniffing",
      ["non_app_layer_proto"] = "Non Application Layer Protocol",
      ["non_std_port"] = "Known Protocol on Non Standard Port",
      ["obfuscated_files_info"] = "Obfuscated Files or Information",
      ["os_credential_dump"] = "OS Credential Dumping",
      ["phishing"] = "Phishing",
      ["phishing_info"] = "Phishing for Information",
      ["proxy"] = "Proxy",
      ["remote_services"] = "Remote Services",
      ["remote_system_discovery"] = "Remote System Discovery",
      ["resource_hijacking"] = "Resource Hijacking",
      ["rogue_domain_controller"] = "Rogue Domain Controller",
      ["scheduled_transfer"] = "Scheduled Transfer",
      ["search_open_tech_db"] = "Search Open Technical Databases",
      ["server_software_component"] = "Server Software Component",
      ["session_hijacking"] = "Session Hijacking",
      ["steal_web_session_cookie"] = "Steal Web Session Cookie",
      ["system_network_conf_discovery"] = "System Network Configuration Discovery",
      ["traffic_signaling"] = "Traffic Signaling",
      ["user_execution"] = "User Execution",
      ["valid_accounts"] = "Valid Accounts",
      ["web_service"] = "Web Service",
    },
  },
  ["modal_download_file"] = {
    ["download"] = "Download",
    ["filename"] = "Filename",
  },
  ["modal_timeseries"] = {
    ["add"] = "Add",
    ["add_timeseries"] = "Add Timeseries",
    ["apply"] = "Apply",
    ["apply_source"] = "Apply Source",
    ["manage_timeseries"] = "Manage Timeseries",
    ["metric"] = "Metric",
    ["snmp_confirm_device"] = "Reload SNMP Interfaces",
    ["source"] = "Source",
    ["source_type"] = "Source Type",
    ["timeseries_list"] = "Timeseries:",
    ["title"] = "Manage Timeseries",
  },
  ["nbox_collector"] = {
    ["description"] = "Collect events from nBox appliances and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "nBox",
  },
  ["ndpi_categories"] = {
    ["Advertisement"] = "Advertisement",
    ["Allowed_Site"] = "Allowed Site",
    ["Antimalware"] = "Antimalware",
    ["Banned_Site"] = "Banned Site",
    ["Chat"] = "Chat",
    ["Cloud"] = "Cloud",
    ["Collaborative"] = "Collaborative",
    ["DataTransfer"] = "DataTransfer",
    ["Database"] = "Database",
    ["Download-FileTransfer-FileSharing"] = "Download-FileTransfer-FileSharing",
    ["Email"] = "Email",
    ["FileSharing"] = "FileSharing",
    ["Game"] = "Game",
    ["Malware"] = "Malware",
    ["Media"] = "Media",
    ["Mining"] = "Mining",
    ["Music"] = "Music",
    ["Network"] = "Network",
    ["Productivity"] = "Productivity",
    ["RPC"] = "RPC",
    ["RemoteAccess"] = "RemoteAccess",
    ["Shopping"] = "Shopping",
    ["Site_Unavailable"] = "Site Unavailable",
    ["SocialNetwork"] = "SocialNetwork",
    ["SoftwareUpdate"] = "SoftwareUpdate",
    ["Streaming"] = "Streaming",
    ["System"] = "System",
    ["Unspecified"] = "Unspecified",
    ["VPN"] = "VPN",
    ["Video"] = "Video",
    ["VoIP"] = "VoIP",
    ["Web"] = "Web",
  },
  ["ndpi_page"] = {
    ["custom_applications"] = "Custom Applications",
    ["live_flows_count"] = "Live Flows Count",
    ["note"] = "NOTE",
    ["note_historical_per_protocol_traffic"] = "Historical %{what} traffic data can be enabled via the <a href='%{url}'>%{flask_icon} Preferences</a>.",
    ["note_live_flows_chart"] = "This chart depicts only TCP connections.",
    ["note_possible_probing_alert"] = "An icon like %{icon} indicates a possible probing (or application server down) alert as the host has received traffic for a specific application without sending back any data. You can use <A HREF='%{url}'>historical reports</A> to drill-down this issue.",
    ["note_protocol_usage_time"] = "Application usage time is computed on discrete slot intervals.",
    ["num_contacted_services_as_client"] = "Client Contacted Services",
    ["num_contacted_services_as_client_descr"] = "(TLS, HTTP and DNS names)",
    ["overview"] = "%{what} Overview",
    ["rcvd"] = "Rcvd",
    ["received_only"] = "Received only",
    ["sent"] = "Sent",
    ["sent_only"] = "Sent only",
    ["total_since_startup"] = "Total (Since Startup)",
    ["unable_to_find_host"] = "Unable to find %{host_ip} (data expired ?)",
  },
  ["nedge"] = {
    ["a_member_address_is"] = "A member address is a rule to assign devices to a user. The following order applies:",
    ["a_zero_quota_is_unlimited"] = "A zero quota means unlimited traffic.",
    ["active_dhcp_leases"] = "DHCP Active Leases",
    ["active_user"] = "Active User",
    ["add_gateway"] = "Add Gateway",
    ["add_member"] = "Add Member",
    ["add_port_forwarding_rule"] = "Add Port Forwarding Rule",
    ["add_routing_policy"] = "Add Routing Policy",
    ["add_some_gateways_first"] = "No gateways defined. Please define some gateways <a href=\"%{url}\">here</a>.",
    ["add_static_lease"] = "Add Static Lease",
    ["add_static_route"] = "Add Static Route",
    ["add_system_user"] = "Add System User",
    ["add_user_member"] = "Add User Member",
    ["add_vlan"] = "Add VLAN",
    ["applied_policy"] = "Applied Policy",
    ["apply_and_reboot"] = "Apply and Reboot",
    ["apply_and_restart_self"] = "Apply and Restart",
    ["apply_configuration"] = "Apply Configuration",
    ["apply_configuration_and_reboot"] = "You are going to apply the new configuration. Network interfaces will be reconfigured according to the specified settings and the system will be rebooted. Wrong settings can cause the system to lose IP connectivity. Only proceed if you are extremely confident settings are correct.",
    ["apply_configuration_and_restart_self"] = "You are going to apply the new configuration. This will cause %{product} to restart and can cause this web GUI to becomes unresponsive for a few seconds.",
    ["apply_the_initial_device_configuration"] = "Apply the initial device configuration.",
    ["authentication_gui_and_captive_portal"] = "The authentication methods apply both to the %{product} gui and the <a href=\"%{url}\">Captive Portal</a> access.",
    ["bandwidth_allocation"] = "Bandwidth Allocation",
    ["bind_to_any"] = "Any Interface",
    ["bind_to_lan"] = "LAN Interface",
    ["cannot_rename_gateway"] = "Cannot rename gateway.",
    ["cannot_rename_interface"] = "Unable to change the interface name.",
    ["cannot_rename_policy"] = "Cannot rename policy.",
    ["cannot_rename_static_route"] = "Cannot rename static route.",
    ["captive_portal_other_methods"] = "The Captive Portal uses the authentication methods defined in the <a href=\"%{url}\">Authentication preferences</a> (e.g. Radius).",
    ["categories_policies"] = "Category Policies",
    ["configure_routing_policies"] = "Configure Routing Policies",
    ["configured_members"] = "Configured Members",
    ["configured_vlans"] = "Configured VLANs",
    ["confirm_delete_gateway"] = "Do you really want to delete gateway \"%{gw}\" ?",
    ["confirm_delete_policy"] = "Do you really want to delete policy \"%{policy}\" ?",
    ["confirm_delete_port_forwarding_rule"] = "Do you really want to delete the specified rule?",
    ["confirm_delete_static_lease"] = "Do you really want to delete \"%{hostname}\" static lease?",
    ["confirm_delete_static_route"] = "Do you really want to delete static route \"%{sr}\" ?",
    ["confirm_delete_vlan"] = "Do you really want to delete the VLAN \"%{vlan}\" ?",
    ["confirm_remove_member_from_user"] = "Do you really want to remove the member %{member} from user %{user}?",
    ["could_not_add_port_forwarding"] = "Could not add the port forwarding rule",
    ["custom"] = "Custom",
    ["custom_datetime"] = "Current Time",
    ["custom_datetime_descr"] = "Manually sets the date and time of the system.",
    ["custom_policy"] = "Custom Policy",
    ["data_reset"] = "Data Reset",
    ["data_reset_msg"] = "Do you really want to reset all the device data? Data include stored timeseries, flows, alerts, Redis caches and host counters. Device configuration and system setup won't be affected by the reset.<br>This will cause %{product} to restart and can cause this web GUI to becomes unresponsive for a few seconds.",
    ["date_time"] = "Date and Time",
    ["default_categories"] = "Default Category Policies",
    ["default_categories_with_a_defined_policy"] = "Default Custom Category Policies",
    ["default_categories_with_a_defined_quota"] = "Default Quota Category Policies",
    ["default_categories_with_policy_x"] = "Default %{x} Category Policies",
    ["default_gateway"] = "Default Gateway",
    ["default_policy"] = "Default Policy",
    ["default_protocols"] = "Default Application Policies",
    ["default_protocols_with_a_defined_policy"] = "Default Custom Application Policies",
    ["default_protocols_with_a_defined_quota"] = "Default Quota Application Policies",
    ["default_protocols_with_policy_x"] = "Default %{x} Application Policies",
    ["default_shaper"] = "Pass",
    ["default_shaper_descr"] = "The Default bandwidth percentage of the interface speed.",
    ["delete_gateway"] = "Delete Gateway",
    ["delete_policy"] = "Delete Policy",
    ["delete_port_forwarding_rule"] = "Delete Port Forwarding Rule",
    ["delete_static_lease"] = "Delete Static Lease",
    ["delete_static_route"] = "Delete Static Route",
    ["delete_vlan"] = "Delete VLAN",
    ["device_protocol_policy_has_higher_priority"] = "Device Policies have higher priority than the Application Policies.",
    ["device_protocols_blocked_warning"] = "Traffic will <b>not</b> be blocked because %{device_protocols_policies} are disabled",
    ["device_protocols_policies"] = "Device Policies",
    ["dhcp_disabled_warning"] = "If no other DHCP server is available in your network then your clients won't be able to connect automatically.",
    ["dhcp_first_ip"] = "First IP address",
    ["dhcp_first_ip_descr"] = "The first IP address of the DHCP address pool",
    ["dhcp_last_ip"] = "Last IP address",
    ["dhcp_last_ip_descr"] = "The last IP address of the DHCP address pool",
    ["dhcp_leases"] = "DHCP Leases",
    ["dhcp_server"] = "DHCP Server",
    ["dhcp_server_description"] = "Enable the DHCP server.",
    ["dhcp_server_not_enabled"] = "The DHCP server is not enabled. You can enabled it <a href=\"%{url}\">here</a>.",
    ["dns_configuration"] = "DNS Configuration",
    ["dns_server_preset"] = "DNS Server Preset",
    ["dns_server_preset_descr"] = "You can select a featured DNS servers from the list or specify your custom DNS servers.",
    ["download_description"] = "The maximum download speed for the interface.",
    ["download_speed"] = "Download Speed",
    ["edit_gateway"] = "Edit Gateway",
    ["edit_interface"] = "Edit Interface Name",
    ["edit_quotas"] = "Edit Quotas",
    ["edit_routing_policy"] = "Edit Routing Policy",
    ["edit_static_route"] = "Edit Static Route",
    ["edit_user"] = "Edit User",
    ["edit_users"] = "Edit Users",
    ["enable_device_protocols_policies"] = "Device Applications Policies",
    ["enable_interface"] = "Enable Interface",
    ["enable_interface_descr"] = "Enable or disable the network interface.",
    ["enable_nat"] = "Enable NAT",
    ["enable_nat_descr"] = "If enabled, the clients IP addresses will be masqueraded with the IP address of the WAN interface.",
    ["enforce_global_dns"] = "Enforce Global DNS",
    ["enforce_global_dns_description"] = "Enable DNS forging to force the devices to use the specified global DNS.",
    ["enternal_port_overlap"] = "External port overlaps with port %{port} assigned to %{ip}",
    ["external_port"] = "External Port (WAN)",
    ["external_port_or_range"] = "External port or port range",
    ["factory_reset"] = "Factory Reset",
    ["factory_reset_msg"] = "Do you really want to reset the device to its factory configuration? Any configuration and data will be lost.",
    ["filter_policies"] = "Filter Policies",
    ["gateway"] = "Gateway",
    ["gateway_exists"] = "Gateway %{gw} already exists.",
    ["gateway_interface_descr"] = "Specify the network interface to use to determine the gateway IP address",
    ["gateway_name"] = "Gateway Name",
    ["gateway_type"] = "Mode",
    ["gateway_type_address_descr"] = "Specify the IP address of the gateway.",
    ["gateway_x"] = "Gateway %{gw}",
    ["gateways"] = "Gateways",
    ["gateways_status"] = "Gateways Status",
    ["global_dns"] = "Global DNS",
    ["global_shapers_rates"] = "Global Bandwidth Control",
    ["high_priority"] = "High Priority",
    ["higher_priority"] = "Higher Priority",
    ["hostname"] = "Hostname",
    ["hostname_lease_exists"] = "A static lease with hostname \"%{hostname}\" already exists.",
    ["interface"] = "Interface",
    ["interface_name"] = "Name",
    ["interfaces_configuration"] = "Interfaces Configuration",
    ["internal_ip"] = "Internal IP (LAN)",
    ["internal_port"] = "Internal Port (LAN)",
    ["internal_port_number"] = "Internal port number",
    ["internal_port_overlap"] = "Internal port overlaps with %{internal_port} already mapped to external port %{external_port}",
    ["invalid_dhcp_range"] = "Invalid DHCP range. Ensure that the DHCP IP addresses are inside the LAN network range, otherwise your devices won't be able to surf the web.",
    ["invalid_port_range"] = "Invalid port range",
    ["ip_address_takes_preced"] = "An IP address takes precedence over a network address",
    ["ip_lease_exists"] = "A static lease with ip \"%{ip}\" already exists.",
    ["lan"] = "LAN",
    ["lan_ip_addr"] = "LAN IP Address",
    ["lan_ip_addr_descr"] = "Specify the LAN interface IP address.",
    ["lan_recovery_ip"] = "LAN Recovery IP",
    ["lan_recovery_ip_descr"] = "An additional IP address to reach the %{product} device on the LAN interface.",
    ["lan_recovery_warning"] = "Please ensure that this does not collide with any other defined network.",
    ["leased_host_name"] = "Leased Host Name",
    ["leased_ip"] = "Leased IP",
    ["link_not_ready"] = "Link Not Ready",
    ["linkdown"] = "Link Down",
    ["loss_threshold"] = "Loss Threshold",
    ["loss_threshold_description"] = "Percentage of ping packets lost (or for which the RTT exceeds the configured Max RTT). If the packet loss exceeds this percentage, the gateway is considered down.",
    ["low_priority"] = "Low Priority",
    ["lower_priority"] = "Lower Priority",
    ["mac_address_takes_preced"] = "A mac address takes precedence over an IP address",
    ["mac_lease_exists"] = "A static lease for mac \"%{mac}\" already exists.",
    ["max_bps_per_host"] = "Max %{bps} per Host",
    ["max_perc"] = "Max %{perc}%%",
    ["max_rrt"] = "Max RTT",
    ["max_rrt_description"] = "The maximum Round Trip Time toward the monitor address. If the measured RTT exceeds this value, the gateway is considered down.",
    ["max_rtt"] = "Max RTT",
    ["max_rtt_description"] = "The maximum Round Trip Time toward the monitor address. If the measured RTT exceeds this value, the gateway is considered down.",
    ["maximum_enforced"] = "Maximum Enforced",
    ["maximum_enforced_descr"] = "If set to maximum enforced, the maximum bandwidth allocation will be enforced regardless of the available bandwidth.",
    ["member_address"] = "Member Address",
    ["member_exists"] = "Member %{member} not added, as it is already assigned to user %{existing_user}",
    ["members"] = "Members",
    ["members_for_user_x"] = "Members of User %{user}",
    ["min_perc"] = "Min %{perc}%%",
    ["minimum_guaranteed"] = "Minimum Guaranteed",
    ["minimum_guaranteed_descr"] = "If set to minimum guaranteed, only minimum bandwidth allocation will be guaranteed.",
    ["mode"] = "Mode",
    ["nedge"] = "nEdge",
    ["network_conf_dhcp"] = "DHCP",
    ["network_conf_iface_descr"] = "Specify the interface IP address mode.",
    ["network_conf_iface_gw"] = "IP address of the default gateway of the interface (e.g. 192.168.1.1).",
    ["network_conf_iface_ip"] = "IP address of the interface (e.g. 192.168.1.10).",
    ["network_conf_iface_nmask"] = "Network mask of the interface (e.g. 255.255.255.0).",
    ["network_conf_iface_title"] = "%{ifrole} Interface %{ifname}",
    ["network_conf_static"] = "Static",
    ["network_conf_vlan_trunk"] = "VLAN Trunk",
    ["no_gateways_defined"] = "No gateways defined.",
    ["no_interfaces_available"] = "No interfaces available.",
    ["no_routing_policies_defined"] = "No routing policies defined",
    ["no_rules"] = "No Rules",
    ["no_static_leases"] = "No Static Leases",
    ["no_static_routes_defined"] = "No static route defined.",
    ["ntp_sync"] = "NTP Synchronization",
    ["ntp_sync_descr"] = "Toggle the synchronization with an NTP server.",
    ["num_of_attempts"] = "Ping Attempts",
    ["num_of_attempts_description"] = "The number of ICMP requests (ping) used to test the gateway status and check the threshold.",
    ["per_ip_rates"] = "Per Host Bandwidth Control",
    ["ping_address"] = "Monitor Address",
    ["ping_address_description"] = "The address to monitor to verify the gateway status.",
    ["please_fill_out_this_field"] = "Please fill out this field.",
    ["policy_due_to_source"] = "%{policy} due to %{source}",
    ["policy_name"] = "Policy Name",
    ["port_forwarding"] = "Port Forwarding",
    ["power_off"] = "Power Off",
    ["power_off_confirm"] = "Do you want to power off the device?",
    ["priority_x"] = "Priority %{x}",
    ["product_status"] = "%{product} Status",
    ["protocol_policy_has_higher_priority"] = "Application Policies have higher priority than the Category Policies.",
    ["protocols_policies"] = "Application Policies",
    ["quotas_control"] = "Quotas Control",
    ["quotas_control_descr"] = "Controls the time span of configured quotas. Daily resets quotas every day, weekly resets quotas every Sunday at midnight, and monthly resets quotas at midnight the last day of every month.",
    ["quotas_control_title"] = "Quotas Time Span",
    ["quotas_daily_reset"] = "Daily",
    ["quotas_monthly_reset"] = "Monthly",
    ["quotas_weekly_reset"] = "Weekly",
    ["reboot"] = "Reboot",
    ["reboot_corfirm"] = "Do you want to reboot the device?",
    ["remote_assistance"] = "Remote Assistance",
    ["remove_all_members"] = "Remove All Members",
    ["remove_all_members_confirm"] = "Do you really want to remove all the members of user %{user}?",
    ["repeaters_config_title"] = "Multicast/Broadcast Forwarding",
    ["reset_and_reboot"] = "Reset and Reboot",
    ["reset_and_restart_self"] = "Reset and Restart",
    ["restrict_weg_gui_access_description"] = "Restrict the access to this management web GUI to make it accessible only from the LAN interface (more secure) or from any interface of the system (less secure).",
    ["restrict_weg_gui_access_title"] = "Management Web GUI Access",
    ["router"] = "Router",
    ["router_mode_requires_enterprise"] = "Router mode is only available in the nedge Enterprise edition.",
    ["routing"] = "Routing",
    ["routing_policies"] = "Routing Policies",
    ["routing_policy"] = "Routing Policy",
    ["routing_policy_exists"] = "Routing policy \"%{policy}\" already exists.",
    ["rules_config_title"] = "Inter-LAN Filtering Rules",
    ["safe_search_description"] = "Use the Child Safe DNS to block inappropriate content.",
    ["search_categories"] = "Search Categories",
    ["search_protocols"] = "Search Applications",
    ["security"] = "Cybersecurity",
    ["set_the_device_mode"] = "Set the device operating mode.",
    ["setup_apply"] = "Apply",
    ["setup_config_edited_descr"] = "Apply changes to make the new configuration effective or discard to keep using the current one.",
    ["setup_config_edited_title"] = "System configuration edited!",
    ["setup_discard"] = "Discard",
    ["setup_mode"] = "Operating Mode",
    ["setup_network"] = "Network",
    ["shapers"] = "Bandwidth Control",
    ["single_port_router"] = "Single Port Router",
    ["slow_pass_shaper_descr"] = "The Slow Pass bandwidth percentage of the interface speed.",
    ["slower_pass_shaper_descr"] = "The Slower Pass bandwidth percentage of the interface speed.",
    ["specify_a_protocol"] = "Specify an Application",
    ["static_dhcp_leases"] = "DHCP Static Leases",
    ["static_route_address_descr"] = "Specify the destination for the static route.",
    ["static_route_exists"] = "Static route %{sr} already exists.",
    ["static_route_is_local_descr"] = "Specify whether this is a static route to a local network. All hosts in a static route to a local network are treated as local hosts.",
    ["static_route_is_local_title"] = "Local Network Static Route",
    ["static_route_name"] = "Static Route Name",
    ["static_route_netmask_descr"] = "Specify the netmask to apply to the destination for the static route.",
    ["static_route_via_descr"] = "Specify the IP address to use as next hop for the static route.",
    ["static_route_x"] = "Static route %{sr}",
    ["static_routes"] = "Static Routes",
    ["static_routes_in_policies"] = "Static routes are applied to (and take precedence over) any of the defined <a href=\"%{url}\">Routing Policies</a>.",
    ["status_activate"] = "Activate",
    ["status_connected"] = "Connected",
    ["status_connecting"] = "Connecting",
    ["status_deactivate"] = "Deactivate",
    ["status_disabled"] = "Disabled",
    ["status_disconnected"] = "Disconnected",
    ["status_down"] = "Down",
    ["status_failed"] = "Failed",
    ["status_inactive"] = "Inactive",
    ["status_unreachable"] = "Unreachable",
    ["status_up"] = "Up",
    ["system_setup"] = "System Setup",
    ["system_users"] = "System Users",
    ["test_policies"] = "Test Policies",
    ["test_policies_page_description"] = "This page can be used to verify which will be the policies applied on the %{user} devices based on the current configuration.",
    ["the_fallback_policy"] = "The <a href=\"%{url}\">Fallback Policy</a> is applied when both the user and the global policy for a given application and its corresponding category are set to \"Default\".",
    ["the_not_assigned_user_contains"] = "The \"Not Assigned\" user can be used to define policies for devices which are not assigned to any user.",
    ["the_primary_dns_server"] = "The Primary DNS server",
    ["the_secondary_dns_server"] = "The Secondary DNS server",
    ["timezone"] = "Time Zone",
    ["timezone_descr"] = "Sets the time zone of the system.",
    ["upload_description"] = "The maximum upload speed for the interface.",
    ["upload_speed"] = "Upload Speed",
    ["user"] = "User",
    ["user_categories"] = "Category Policies for User %{user}",
    ["user_categories_with_a_defined_policy"] = "Custom Category Policies for User %{user}",
    ["user_categories_with_a_defined_quota"] = "Quota Category Policies for User %{user}",
    ["user_categories_with_policy_x"] = "%{x} Category Policies for User %{user}",
    ["user_category_policies"] = "User Category Policies",
    ["user_device_protocols"] = "Application Policies for %{user} Devices",
    ["user_protocols"] = "Application Policies for User %{user}",
    ["user_protocols_with_a_defined_policy"] = "Custom Application Policies for User %{user}",
    ["user_protocols_with_a_defined_quota"] = "Quota Application Policies for User %{user}",
    ["user_protocols_with_policy_x"] = "%{x} Application Policies for User %{user}",
    ["users_list"] = "Users List",
    ["view_quotas"] = "View Quotas",
    ["vlan"] = "VLAN",
    ["vlan_configuration"] = "VLAN Configuration",
    ["wan"] = "WAN",
    ["wan_interface"] = "WAN Interface",
    ["with_quota"] = "With Quota",
    ["x_shaper_per_host_descr"] = "The %{shaper} maximum per-host bandwidth allocation. 0 for unlimited.",
    ["you_can_assign_routing_policy"] = "You can assign routing policies to <a href=\"%{url}\">Users</a>.",
    ["you_can_assign_shapers_to_users_protocols"] = "You can assign bandwidth policies to <a href=\"%{url}\">Users</a> specific applications or set them globally as a <a href=\"%{url2}\">Fallback Policy</a>.",
    ["you_can_set_static_dhcp_lease_here"] = "You can configure static DHCP leases <a href=\"%{url}\">here</a>.",
    ["you_can_use_gateways_in_policies"] = "You can specify gateways priorities in <a href=\"%{url}\">Routing Policies</a>.",
    ["page_repeater_config"] = {
      ["interface"] = "Network Interface",
      ["interfaces"] = "Network Interfaces",
      ["ip"] = "IP",
      ["keep_src_address"] = "Keep Source Address",
      ["port"] = "Port",
      ["repeater_id"] = "Repeater ID",
      ["type"] = "Type",
      ["modal_repeater_config"] = {
        ["custom"] = "Custom",
        ["mdns"] = "MDNS",
        ["repeater_type"] = "Repeater Type",
      },
    },
    ["page_rules_config"] = {
      ["accept"] = "ACCEPT",
      ["action"] = "Action",
      ["bidirectional"] = "Bidirectional",
      ["default policy"] = "Default Policy",
      ["deny"] = "DENY",
      ["dest"] = "Destination",
      ["direction"] = "Direction",
      ["note_rules_edit_order"] = "In order to change the order and evaluate rule B before rule A, edit rule B by setting as ID the rule A's ID. Rule A will be shifted down to the next position.",
      ["note_rules_order"] = "Rules are evaluated top-down sorted by Rule ID (ID 1 has priority over ID 2).",
      ["rule_id"] = "Rule ID",
      ["source"] = "Source",
      ["source_to_dest"] = "Source to Destination",
      ["modal_change_default_policy"] = {
        ["title"] = "Edit Default Policy",
      },
      ["modal_rule_config"] = {
        ["cidr"] = "Network (CIDR)",
        ["dest_type"] = "Destination Type",
        ["direction"] = "Direction",
        ["ip"] = "IP",
        ["source_type"] = "Source Type",
        ["title_add"] = "Add Filter Rule",
        ["title_edit"] = "Edit Filter Rule",
      },
    },
    ["policy_source_labels"] = {
      ["policy_source_category"] = "Category Policy",
      ["policy_source_default"] = "Unknown",
      ["policy_source_device_protocol"] = "Device Application Policy",
      ["policy_source_pool"] = "Default Policy",
      ["policy_source_protocol"] = "Application Policy",
    },
  },
  ["network_alert_config"] = {
    ["trigger_alerts_for_network"] = "Trigger alerts for Network %{network}",
    ["trigger_network_alerts"] = "Trigger Network Alerts",
  },
  ["network_details"] = {
    ["network"] = "Network",
    ["network_alias"] = "Network Alias",
    ["network_parameter_missing_message"] = "Network parameter is missing (internal error?)",
    ["no_available_stats_for_network"] = "No available stats for network %{network}",
  },
  ["network_stats"] = {
    ["network_list"] = "Network List",
    ["network_name"] = "Network Name",
    ["networks"] = "Networks",
    ["networks_traffic_with_ipver"] = "%{networks} with IPv%{ipver} traffic",
    ["note_aliases_not_configurable"] = "The alias is non-editable as specified statically with option -m.",
    ["note_broader_network"] = "The broader network will not include hosts defined in smaller networks.",
    ["note_overlapping_networks"] = "In case you have defined overlapping networks:",
    ["note_see_both_network_entries"] = "You will see both network entries in the above table.",
  },
  ["notification_endpoint"] = {
    ["discord"] = {
      ["discord_send_error"] = "Error sending message to Discord.",
      ["message_sender"] = "Nickname of the discord message sender (optional). ",
      ["url"] = "WebHook URL",
      ["username"] = "Username",
      ["webhook_description"] = "Instructions:<ul><li>Open the Discord channel you want to receive ntopng notifications from.<li>From the channel menu, select Edit channel (or click on the wheel icon). <li>Click on Webhooks menu item.<li>Click the Create Webhook button and fill in the name of the bot that will post the messages (note that you can set it on the ntopng recipients page)<li>Note the URL from the WebHook URL field to be copied in the field above. <li>Click the Save button.</ul>",
      ["validation"] = {
        ["empty_url"] = "Discord Webook URL cannot be empty.",
        ["invalid_url"] = "Invalid Discord Webhook URL. See https://support.discord.com/hc/en-us/articles/228383668-Intro-to-Webhooks.",
        ["invalid_username"] = "Invalid Discord username.",
      },
    },
    ["elasticsearch"] = {
      ["description"] = "<ul><li>Specify a URL (including the port) to reach the Elasticsearch instance to use for indexing alerts. Example: http://localhost:9200/.</li><li>Specify a username and password if URL requires authentication.</li></ul>",
      ["index"] = "Index",
      ["index_description"] = "<b>NOTE</b>:<ul><li>Index specified is automatically suffixed with -%%Y.%%m.%%d, with %%Y, %%m, %%d being the current year, month and day, respectively. This determines a new index to be created daily.</li><li>When no index is specified, default name 'alerts-ntopng' is used.<li>For SecurityOnion please use so-ntopng as index name.</li></ul>",
      ["password"] = "Password",
      ["url"] = "URL",
      ["username"] = "Username",
      ["validation"] = {
        ["empty_url"] = "Elasticsearch URL cannot be empty.",
        ["invalid_index"] = "Invalid Elasticsearch index.",
        ["invalid_url"] = "Invalid Elasticsearch URL.",
        ["invalid_username"] = "Invalid Elasticsearch username.",
      },
    },
    ["email"] = {
      ["carbon_copy"] = "CC",
      ["email_recipient"] = "Email Recipient",
      ["email_sender"] = "Email Sender",
      ["smtp_password"] = "SMTP Password",
      ["smtp_port"] = "SMTP Port",
      ["smtp_server"] = "SMTP Server",
      ["smtp_username"] = "SMTP Username",
      ["use_proxy"] = "Use Proxy",
      ["use_proxy_descr"] = "Use system-wide Proxy configuration (HTTP_PROXY or http_proxy environment variables)",
      ["validation"] = {
        ["empty_SMTP_port"] = "Please insert a port.",
        ["empty_SMTP_server"] = "Please insert a IPv4/IPv6/Host address/SMTP URL.",
        ["empty_email"] = "Please insert an email address.",
        ["invalid_SMTP_port"] = "Please type a valid port.",
        ["invalid_SMTP_server"] = "Please type a valid IPv4/IPv6/Host address/SMTP URL.",
        ["invalid_email"] = "Please type a valid email address (i.e. name@domain.com).",
      },
    },
    ["fail2ban"] = {
      ["description"] = "<ul><li>Fail2Ban is required to use the Endpoint. Check: <a href='https://www.fail2ban.org/wiki/index.php/Downloads' target='_blank'>here</a> <i class='%{icon}'></i> for more info about the installation.<li>Fail2Ban Endpoint will be executed only with specific supported alerts.</ul><ul>Note:<li>ntopng user must have sudo privileges.</ul>",
      ["fail2ban_send_error"] = "Fail2Ban not working properly.",
      ["jail"] = "Jail",
      ["jail_description"] = "<ul><li>Specify the JAIL used to ban the IP. Check: <a href='https://www.fail2ban.org/wiki/index.php/MANUAL_0_8#Jails' target='_blank'>here</a> <i class='%{icon}'></i> for more info about JAIL.</ul>Note, if the check isn't successfull be sure:<ul><li>That ntopng user has sudo privileges.<li>That the JAIL added is a correct one (use the command `fail2ban-client status` to check the available Jails).",
      ["validation"] = {
        ["empty_jail"] = "Fail2Ban JAIL cannot be empty.",
        ["invalid_jail"] = "Invalid Fail2Ban jail.",
      },
    },
    ["mattermost"] = {
      ["api_token"] = "API Token",
      ["id"] = "Id Mattermost Channel",
      ["url"] = "Server URL",
      ["username"] = "Username",
      ["validation"] = {
        ["empty_token"] = "Token cannot be empty.",
        ["empty_url"] = "Server URL cannot be empty.",
        ["invalid_token"] = "Invalid token. Token can only contain lowecase characters and digits.",
        ["invalid_url"] = "Invalid Server URL.",
      },
    },
    ["pagerduty"] = {
      ["integreation_key"] = "Integration Key",
      ["pagerduty_send_error"] = "Error sending message to PagerDuty.",
      ["validation"] = {
        ["empty_int_key"] = "Integration Key cannot be empty.",
      },
    },
    ["shell"] = {
      ["shell_options"] = "Options",
      ["shell_script"] = "Script PATH",
      ["shell_script_execution"] = "Execute shell script when",
      ["shell_send_error"] = "Error while trying to run the script.",
      ["shell_description"] = {
        ["option_description"] = "Instructions<ul><li>Insert here the options with which the script is going to be executed (e.g. `-i eno1 -p 2220`)</ul>",
        ["path_description"] = "Note:<ul><li>The script must be stored in \"/usr/share/ntopng/scripts/shell/\"<li>Alert information are provided to the script through the standard input in JSON format.</lu>",
      },
      ["validation"] = {
        ["empty_path"] = "Shell script path cannot be empty.",
        ["invalid_path"] = "Invalid shell script path. The script must be stored in \"/usr/share/ntopng/scripts/shell/\" and end with .sh.",
        ["invalid_script"] = "Invalid script. Script not secure.",
      },
    },
    ["slack"] = {
      ["notification_webhook"] = "Notification Webhook",
      ["sender_username"] = "Sender Username",
      ["webhook_description"] = "Instructions:<ul><li>Create a new channel to be used for notifications<li>Create a Slack app from the <a href='https://api.slack.com/apps?new_app=1' target='_blank'>Slack API page</a><li>Activate Incoming Webhooks<li>Add a new Webhook and select the notifications channel<li>Copy the Webhook URL to <b>Notification Webhook</b></ul>",
    },
    ["smart_recording"] = {
      ["description"] = "Traffic recorded with continuous recording which is matching alerts delivered to this endpoint will be stored to a second level storage. This requires Smart Recording to be enabled under the Traffic Recording page.",
    },
    ["syslog"] = {
      ["alert_format"] = "Format",
      ["content"] = "Content",
      ["description"] = "Host, Port and Protocol should be specified for remote syslog servers only.",
      ["description_ecs"] = "ECS (Elasticsearch Common Schema) format is documented <a class='ntopng-external-link' href='%{url}' target='_blank'>here <i class='%{icon}'></i></a>.",
      ["description_raw_json"] = "Raw JSON format is self-documented in the <a class='ntopng-external-link' href='%{url}' target='_blank'>code <i class='%{icon}'></i></a> and is meant to be used only by programmers who intend to programmatically process notifications.",
      ["host"] = "Host",
      ["port"] = "Port",
      ["protocol"] = "Protocol",
      ["text"] = "Text",
      ["validation"] = {
        ["invalid_host"] = "Invalid Syslog host.",
        ["invalid_port"] = "Invalid Syslog port.",
      },
    },
    ["teams"] = {
      ["url"] = "Connector",
      ["webhook_description"] = "Instructions:<ul><li>Alerts information are delivered to the configured Microsoft Teams Channel as Message Card<li>Brief explanation: open the settings of the channel you want to add the endpoint, click on `Connectors` then on `Incoming WebHook` (add to M.Teams connectors if not added before) and on `Configure`; from there create a new Connector and paste the Connector URL here<li>The official guide to Microsoft Teams Connectors can be found <a class='ntopng-external-link' href='https://docs.microsoft.com/en-us/microsoftteams/platform/webhooks-and-connectors/how-to/add-incoming-webhook' target='_blank'>Here <i class='fas fa-external-link-alt'></i></a>",
    },
    ["telegram"] = {
      ["telegram_channel"] = "Channel Id",
      ["telegram_send_error"] = "Error sending message to Telegram.",
      ["telegram_token"] = "Token",
      ["validation"] = {
        ["invalid_channel_name"] = "Invalid Telegram Channel Name.",
        ["invalid_token"] = "Invalid Telegram Token.",
      },
      ["webhook_description"] = {
        ["channel_id_description"] = "Instructions if you want to use the bot in a chat:<ul><li>Start a conversation with the bot in Telegram (a bot can't initiate conversation with a user!)<li>Start a new conversation with @getidsbot<li>Copy here the id the @getidsbot gave to you</ul>Instructions if you want to use the bot in a group:<ul><li>Add to your group the bot you created<li>Call the REST API: https://api.telegram.org/bot&lt;botToken&gt;/getUpdates to find out the group chat id<li>Copy here the id the REST Response gave to you</ul>",
        ["token_description"] = "Instructions:<ul><li>Start a new chat with @BotFather<li>Type and send '/newbot'<li>Give a name to your bot<li>Give a username to your bot<li>Copy here the token the @BotFather gave to you</ul>",
      },
    },
    ["thehive"] = {
      ["api_token"] = "API Key",
      ["observable_mail"] = "Observable email",
      ["observable_url"] = "Observable URL",
      ["url"] = "Server URL",
      ["validation"] = {
        ["empty_obs_mail"] = "Observable email cannot be empty.",
        ["empty_obs_url"] = "Observable URL cannot be empty.",
        ["empty_token"] = "Token cannot be empty.",
        ["empty_url"] = "Server URL cannot be empty.",
        ["invalid_obs_mail"] = "Invalid Observable email.",
        ["invalid_obs_url"] = "Invalid Observable URL.",
        ["invalid_token"] = "Invalid token. Token can only contain lowecase characters and digits.",
        ["invalid_url"] = "Invalid Server URL.",
      },
    },
    ["webhook"] = {
      ["password"] = "Password",
      ["shared_secret"] = "Shared Secret",
      ["url"] = "URL",
      ["username"] = "Username",
      ["webhook_description"] = "Instructions:<ul><li>Alerts information are delivered to the configured URL in JSON format using POST requests.<li>The Shared Secret, when configured, is included in all JSON messages.<li>Username and Password (optional) use HTTP Basic authentication.",
    },
    ["wechat"] = {
      ["url"] = "WebHook URL",
      ["webhook_description"] = "<ul><li>Specify a URL to reach the WeChat to use for indexing alerts. Example: https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=693axxx6-7aoc-4bc4-97a0-0ec2sifa5aaa</li></ul>",
      ["wechat_send_error"] = "Error sending message to WeChat.",
      ["validation"] = {
        ["empty_url"] = "WeChat Webook URL cannot be empty.",
        ["invalid_url"] = "Invalid WeChat Webhook URL.",
      },
    },
  },
  ["openvpn_collector"] = {
    ["description"] = "Collect logs from OpenVPN: handle Identity Management (user correlation) and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "OpenVPN",
  },
  ["opnsense_collector"] = {
    ["description"] = "Collect logs from OPNsense firewalls: handle Identity Management (user correlation) and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "OPNsense",
  },
  ["os_details"] = {
    ["no_available_stats_for_os"] = "No available stats for OS %{os}",
    ["os"] = "Operating System",
    ["os_parameter_missing_message"] = "OS parameter is missing (internal error?)",
  },
  ["os_stats"] = {
    ["hosts_by_operating_system"] = "Hosts by Operating System",
  },
  ["packets_page"] = {
    ["arp_distribution"] = "ARP Distribution",
    ["ip_version_distribution"] = "IP Version Distribution",
    ["lost"] = "Lost",
    ["out_of_order"] = "Out of Order",
    ["received_distribution"] = "Received Distribution",
    ["retransmissions"] = "Retransmissions",
    ["sent_distribution"] = "Sent Distribution",
    ["sent_vs_rcvd_distribution"] = "Sent vs Rcvd Distribution",
    ["size_distribution"] = "Size Distribution",
    ["tcp_flags_distribution"] = "TCP Flags Distribution",
    ["tcp_flags_vs_arp_distribution"] = "TCP Flags / ARP Distribution",
    ["tcp_packets_analysis"] = "TCP Packets Analysis",
    ["version_vs_flags_distribution"] = "IP version vs TCP Flags Distribution",
  },
  ["page_stats"] = {
    ["95_perc"] = "95th Percentile",
    ["average"] = "Average",
    ["congestion_rate"] = "Congestion Rate",
    ["custom_metrics"] = "Custom Metrics",
    ["download_image_disabled"] = "Button currently disabled on Safari",
    ["historical_flows"] = "Jump to Historical Flows",
    ["interface_details"] = "SNMP Interface Details",
    ["last_value"] = "Last Value",
    ["layout_1_per_1"] = "One Chart per Metric",
    ["layout_1_per_all"] = "Single Chart",
    ["layout_1_per_y"] = "One Chart per Y-axis",
    ["manage_snapshots_btn"] = "Manage Snapshots",
    ["manage_timeseries_btn"] = "Manage Timeseries",
    ["max"] = "Max",
    ["metric"] = "Metric",
    ["min"] = "Min",
    ["title_modal_download_file"] = "Export Chart Image as .png",
    ["total"] = "Total",
    ["type"] = "Type",
    ["source_def"] = {
      ["active_monitoring"] = "Active Monitoring",
      ["as"] = "ASN",
      ["blacklist"] = "Blacklist",
      ["container"] = "Container",
      ["country"] = "Country",
      ["device"] = "Device",
      ["flow_device"] = "Flow Top Interfaces",
      ["flow_interface"] = "Flow Interface",
      ["host"] = "Host",
      ["influx"] = "Influx DB Stats",
      ["interface"] = "Interface",
      ["mac"] = "Mac",
      ["network"] = "Network",
      ["observation_point"] = "Observation Point",
      ["os"] = "OS",
      ["pod"] = "Pod",
      ["pool"] = "Host Pool",
      ["port"] = "Port",
      ["profile"] = "Profile",
      ["redis"] = "Redis Stats",
      ["sflow_device"] = "sFlow Top Interfaces",
      ["sflow_interface"] = "sFlow Interface",
      ["snmp_device"] = "SNMP Top Interfaces",
      ["snmp_interface"] = "SNMP Interface",
      ["system"] = "System",
      ["vlan"] = "Vlan",
      ["vuln_scan"] = "Vulnerability Scan",
    },
    ["top"] = {
      ["host_name"] = "Host Name",
      ["received"] = "Received",
      ["sent"] = "Sent",
      ["throughput"] = "Throughput",
      ["top_applications"] = "Top Applications",
      ["top_categories"] = "Top Categories",
      ["top_interfaces"] = "Top Interfaces",
      ["top_packets"] = "Top Packets",
      ["top_receivers"] = "Top Receivers",
      ["top_senders"] = "Top Senders",
      ["top_traffic"] = "Top Traffic",
      ["top_traffic_netflow"] = "Top Traffic",
      ["top_traffic_sflow"] = "Top Traffic",
      ["top_traffic_snmp"] = "Top Traffic (SNMP min)",
    },
  },
  ["peers_page"] = {
    ["host"] = "Host",
    ["no_active_flows_message"] = "No active flows have been observed for the specified host",
    ["top_peer_protocol"] = "Top Peer Applications",
    ["top_peers_for_host"] = "Top %{hostkey} Peers",
    ["traffic_volume"] = "Traffic Volume",
  },
  ["periodic_activities_descr"] = {
    ["5min.lua"] = "Iterates active hosts and writes their timeseries. Executes checks with 5 minutes granularity.",
    ["daily.lua"] = "Performs old data cleanup. Executes checks with daily granularity.",
    ["dequeue_flows_for_hooks.lua"] = "Handles the in-memory lifecycle of flows, hosts and other hash entries. Executes flow checks. Dumps flows to database.",
    ["discover.lua"] = "Runs requested and periodic network discoveries.",
    ["hourly.lua"] = "Executes checks with hourly granularity",
    ["housekeeping.lua"] = "Checks n2disk extraction jobs. Checks and reloads lists.",
    ["minute.lua"] = "Writes extended interface timeseries such applications. Writes timeseries for checks, pods, containers.  Executes checks with minute granularity.",
    ["notifications.lua"] = "Processes alert notifications, dispatching them to configured recipients.",
    ["periodic_checks.lua"] = "Executes periodic checks.",
    ["second.lua"] = "Writes fundamental interface timeseries such as total traffic.",
    ["stats_update.lua"] = "Updates system stats (e.g., CPU load).",
    ["timeseries.lua"] = "Writes timeseries data to InfluxDB. Has no effect when InfluxDB is not used.",
  },
  ["please_wait_page"] = {
    ["command"] = "Command",
    ["database"] = "Database",
    ["host"] = "Host",
    ["id"] = "Id",
    ["info"] = "Info",
    ["operations_on_database_msg"] = "Operations currently performed on the database are the following: ",
    ["state"] = "State",
    ["time"] = "Time",
    ["user"] = "User",
    ["waiting_for_db_msg"] = "Database schema migration in progress, waiting for database <b>%{dbname}</b> to become operational. You will be redirected as soon as the database is ready. Depending on the size of the existing database, this operation can take a long time. Migrations are performed only once and only during major version upgrades. If in doubt, please contact the developers at <a href='mailto:info@ntop.org'>info@ntop.org</a>.",
  },
  ["policy"] = {
    ["abort_add_rule"] = "Abort add rule?",
    ["add_rule"] = "Add Rule",
    ["autoconfigure"] = "Auto Configure",
    ["autoconfigure_note"] = "The Auto Configure functionality automatically creates a suggested configuration for the Pool by detecting protocols/hosts commonly used/contacted by the hosts in the Pool. Please note that the Default Policy is set to Drop when using this functionality (unless a Default Policy was already set).",
    ["autoconfigure_sites_note"] = "In order to populate Host Rules, the Auto Configure feature requires the Top Visited Sites euristic to be enabled under Settings > Preferences > Applications. For best results it should be enabled at least one day before to collect enough data.",
    ["continent"] = "Continent",
    ["continent_rules"] = "Continent Rules",
    ["continent_rules_descr"] = "Configure here the continent exceptions rules.",
    ["country"] = "Country",
    ["country_rules"] = "Country Rules",
    ["country_rules_descr"] = "Configure here the country exceptions rules.",
    ["default"] = "Default",
    ["default_policy"] = "Default Policy",
    ["default_policy_descr"] = "The default policy defines the default action for traffic matching the pool. Exceptions to the default policy (i.e. using the opposite policy with respect to the defaut one) can be configured by adding rules below.",
    ["drop"] = "Drop",
    ["edit_rule"] = "Edit Rule",
    ["host"] = "Host",
    ["host_rules"] = "Host Rules",
    ["host_rules_descr"] = "Configure here hostname (e.g. used in TLS, DNS... protocols) exception rules.",
    ["l7_category"] = "L7 Category",
    ["l7_category_rules"] = "L7 Category Rules",
    ["l7_category_rules_descr"] = "Configure here the traffic category exception rules.",
    ["l7_proto"] = "L7 Protocol",
    ["l7_proto_rules"] = "L7 Protocol Rules",
    ["l7_proto_rules_descr"] = "Configure here the L7/application protocol exception rules.",
    ["marker"] = "Action",
    ["pass"] = "Pass",
    ["remove_rules"] = "Remove Rules",
    ["risk"] = "Risk",
    ["risk_rules"] = "Risk Rules",
    ["risk_rules_descr"] = "Configure here policies based on the flow risk computed by nDPI.",
    ["rule"] = "Rule",
    ["rules"] = "Policy Rules",
    ["traffic_policies"] = "Traffic Policies",
    ["traffic_policy_for"] = "Traffic Policies for <a href='%{url}'>%{pool} <i class='fas fa-users'></i></a>",
    ["markers"] = {
      ["drop"] = "Drop",
      ["pass"] = "Pass",
      ["slow"] = "Slow Pass",
      ["slower"] = "Slower Pass",
    },
  },
  ["policy_presets"] = {
    ["business"] = "Business",
    ["business_description"] = "A preset for business company employees",
    ["child"] = "Child",
    ["child_description"] = "A preset for children. Blocks social networks and limits game time",
    ["default"] = "Default",
    ["guests"] = "Guests",
    ["guests_description"] = "A preset for guests. Only basic navigation allowed",
    ["no_obfuscation"] = "No Obfuscation",
    ["no_obfuscation_description"] = "A preset to prevent traffic obfuscation",
    ["walled_garden"] = "Walled Garden",
    ["walled_garden_description"] = "Blocks VPN and Social Networks",
  },
  ["pool_details"] = {
    ["host_pool"] = "Host Pool",
    ["host_pool_timeseries_enable_message"] = "Host Pool timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
    ["no_available_data_for_host_pool_message"] = "No available data for Host Pool '%{pool_name}'.",
    ["pool_parameter_missing_message"] = "Parameter is missing (internal error ?)",
  },
  ["pool_stats"] = {
    ["host_pool_list"] = "Host/Network/MAC Pool List",
  },
  ["pools"] = {
    ["config_import"] = "Import Configuration",
    ["config_import_message"] = "<b>Note</b>: pools with the same name will be replaced.",
    ["configuration"] = "Behavioural Checks Configuration",
    ["edit_host_pool"] = "Edit Host Pool",
    ["edit_pools"] = "Edit Pools",
    ["edit_recipients"] = "Edit recipients",
    ["family"] = "Family",
    ["id"] = "ID",
    ["insert_name"] = "i.e. MyPool",
    ["interface_pools"] = "Interface Pools",
    ["members"] = "Members",
    ["name"] = "Name",
    ["name_requirements"] = "The name must be longer than 1 character and it can't be empty.",
    ["no_recipients"] = "No recipients configured for the above pool.",
    ["not_assigned"] = "Not Assigned",
    ["pool"] = "Pool",
    ["pools"] = "Pools",
    ["recipients"] = "Recipients",
    ["remove_pool"] = "Are you really sure to delete '%{pool}' pool?",
    ["select_config"] = "Select a Checks Configuration",
    ["some_recipients"] = "${recipients} recipient(s) configured for the above pool.",
    ["unbounded_members"] = "All unbound",
    ["pool_name"] = {
      ["active_monitoring"] = "Active Monitoring",
      ["flow"] = "Flow",
      ["host"] = "Host",
      ["host_pool"] = "Host Pool",
      ["interface"] = "Interface",
      ["local_network"] = "Local Network",
      ["mac"] = "Device",
      ["snmp_device"] = "SNMP Device",
      ["system"] = "System",
    },
    ["pool_names"] = {
      ["active_monitoring"] = "Active Monitoring",
      ["all"] = "All",
      ["flow"] = "Flows",
      ["host"] = "Hosts",
      ["host_pool"] = "Host Pool",
      ["interface"] = "Interfaces",
      ["local_network"] = "Local Networks",
      ["mac"] = "Devices",
      ["snmp_device"] = "SNMP Devices",
      ["system"] = "System",
    },
    ["pool_names_suffix"] = {
      ["active_monitoring"] = "Active Monitoring Pool",
      ["interface"] = "Interface Pool",
      ["local_network"] = "Local Network Pool",
      ["snmp"] = "SNMP Pool",
    },
  },
  ["port_details"] = {
    ["active_flows_for_host_and_port"] = "Live Flows for %{host}:%{port}",
    ["active_flows_on_port"] = "Live Flows on Port %{port}",
    ["active_flows_on_port_symbolic"] = "Live Flows on Port %{port} [%{symbolic_port}]",
    ["l4_port"] = "L4 Port",
  },
  ["ports_analysis"] = {
    ["bubble_mode"] = "Filter By",
    ["historical"] = "Historical",
    ["l4proto"] = "Protocol",
    ["live"] = "Live",
    ["max_entries"] = "Only 35 flows with the most traffic are displayed due to the huge number of flows",
    ["no_data"] = "No flows detected",
    ["notes"] = "<b style='color: #d62728;'>Important</b>: At most 35 links with the most traffic are going to be displayed in order to have a readable chart.<li>The above chart represents the top server ports used on each VLAN.<li>If flow storage is enabled, historical flow ports can be reported.<li>The VLANs, ports and application protocols are clickable, sending the user to the corresponding live or historical flow page.",
    ["server_ports"] = "Server Ports Analysis",
    ["timeframe"] = "Timeframe",
    ["title"] = "Ports Analysis",
    ["vlan"] = "VLAN",
  },
  ["ports_page"] = {
    ["active_server_ports"] = "Active Server Ports",
    ["active_server_tcp_ports"] = "Active TCP Server Ports",
    ["active_server_udp_ports"] = "Active UDP Server Ports",
    ["client_contacted_server_ports"] = "Client Contacted Server Ports",
    ["client_contacted_server_tcp_ports"] = "Contacted Server TCP Ports",
    ["client_contacted_server_udp_ports"] = "Contacted Server UDP Ports",
    ["client_ports"] = "Client Ports",
    ["server_ports"] = "Server Ports",
  },
  ["prefs"] = {
    ["active_local_host_cache_interval_description"] = "Interval between consecutive active local hosts cache dumps. Default: 1 hour.",
    ["active_local_host_cache_interval_title"] = "Active Local Host Cache Interval",
    ["admin_group_description"] = "Group name to which user has to belong in order to authenticate as an administrator. Example: \"admin\"",
    ["admin_group_title"] = "LDAP Admin Group",
    ["advanced_view"] = "Advanced View",
    ["aggregated_flows_data_retention_descr"] = "Number of days to keep aggregated flows informations (it must be larger than unaggregated flows retention). Default: 60 days.",
    ["aggregated_flows_data_retention_title"] = "ClickHouse Aggregated Flows Data Retention",
    ["alert_entity"] = "Alert Entity",
    ["alerts_notifications"] = "Endpoints",
    ["alerts_page_refresh_rate__title"] = "Alert Refresh Rate",
    ["alerts_page_refresh_rate_description"] = "Set the refresh rate timer (> 0, to be effective).",
    ["alerts_retention"] = "Alerts Retention",
    ["alerts_settings"] = "Alerts Settings",
    ["all"] = "All",
    ["assets_inventory"] = "Assets Inventory",
    ["auth_methods_order"] = "The authentication methods check order is the same as the listing order above, e.g. if both LDAP and local auth are enabled, LDAP will be checked first and, if authentication fails, local auth will be checked next.",
    ["authentication"] = "Authentication",
    ["authentication_duration"] = "Authentication Duration",
    ["authentication_duration_descr"] = "Amount of time before the session of an authenticated user is terminated and re-authentication is necessary. Changes will affect newly-created sessions only.",
    ["authentication_duration_title"] = "Authenticated Session Duration",
    ["authentication_midnight_expiration_descr"] = "Toggles the termination of sessions at midnight, forcing all authenticated users to re-authenticate after midnight.",
    ["authentication_midnight_expiration_title"] = "Authenticated Session Termination at Midnight",
    ["behavior_timeseries"] = "Behaviour Timeries",
    ["behaviour"] = "Behaviour Analysis",
    ["behaviour_analysis_learning_period_description"] = "Configure the learning period duration for Service Map.",
    ["behaviour_analysis_learning_period_title"] = "Learning Period Duration",
    ["behaviour_analysis_status_during_learning_description"] = "The default status of a newly discovered service during the Service Map's learning period.<br> With <b>Unauthorized</b> status selected, when a new service is discovered, an alert will be triggered.",
    ["behaviour_analysis_status_during_learning_title"] = "Status During Learning Period",
    ["behaviour_analysis_status_post_learning_description"] = "The default status of a newly discovered service at the end of the Service Map's learning period.<br> With <b>Unauthorized</b> status selected, when a new service is discovered, an alert will be triggered.",
    ["behaviour_analysis_status_post_learning_title"] = "Status Post Learning Period",
    ["bind_dn_description"] = "Bind Distinguished Name of LDAP server. Example:",
    ["bind_dn_title"] = "LDAP Bind DN",
    ["bind_pwd_description"] = "Bind password used for authenticating with the LDAP server.",
    ["bind_pwd_title"] = "LDAP Bind Authentication Password",
    ["both"] = "Both",
    ["cache_settings"] = "Cache Settings",
    ["captive_portal_informative_url_description"] = "The URL of the page shown to the clients as captive portal (informative captive portal only).",
    ["captive_portal_informative_url_title"] = "External Informative Page URL",
    ["captive_portal_url_description"] = "The URL your clients will be redirected to after a successful captive portal authentication.",
    ["captive_portal_url_title"] = "Redirection URL",
    ["chap"] = "CHAP",
    ["clickhouse"] = "ClickHouse",
    ["client_x509_auth"] = "HTTPS Client Authentication",
    ["client_x509_auth_descr"] = "Toggle the authentication of clients on the basis of their X.509 certificate. When the client X.509 Common Name (CN) equals one of the %{product} users, then the client is authenticated as the %{product} user. Changes to this setting requires a %{product} restart.",
    ["client_x509_auth_title"] = "Client X.509 Certificate Authentication",
    ["connectivity_check"] = "Connectivity Check",
    ["connectivity_check_url_description"] = "Set the URL which is contacted by ntopng to check Internet connectivity, this overwrites the default URL (https://github.com). When the provided URL is unreachable, ntopng runs in Offline mode. In case ntopng is behind a proxy, please also <a href='https://github.com/ntop/ntopng/blob/dev/doc/README.md#using-ntopng-with-a-https-proxy' target='_blank'>configure the proxy</a>.",
    ["connectivity_check_url_title"] = "Connectivity Check URL",
    ["could_not_contact_influxdb"] = "Could not contact the InfluxDB database: %{msg}",
    ["data_retention"] = "Data Retention",
    ["default_snmp_community_description"] = "The default SNMP community is used when trying to walk the SNMP MIB of a selected local host that has not been configured through the SNMP devices page.",
    ["default_snmp_community_title"] = "Default SNMP Community",
    ["default_snmp_proto_version_description"] = "The default SNMP protocol version.",
    ["default_snmp_proto_version_title"] = "Default SNMP Version",
    ["default_snmp_timeout_description"] = "SNMP agent response timeout (seconds).",
    ["default_snmp_timeout_title"] = "SNMP Agent Response Timeout",
    ["device_identifier"] = "Device Identifier",
    ["device_identifier_descr"] = "Usually devices are identified by MAC address. However, if devices are behind a router, IP identification is desiderable instead.",
    ["devices_behaviour"] = "Device/MAC Address Tracking",
    ["devices_learning_period_description"] = "Configure the learning period duration for Device/MAC Address Tracking.",
    ["devices_learning_period_title"] = "Learning Period Duration",
    ["devices_status_during_learning_description"] = "The default status of a newly discovered device during the Device/MAC Address Tracking learning period.<br> With <b>Unauthorized</b> status selected, when a new device is discovered, an alert will be triggered.",
    ["devices_status_during_learning_title"] = "Status During Learning Period",
    ["devices_status_post_learning_description"] = "The default status of a newly discovered device at the end of the Device/MAC Address Tracking learning period.<br> With <b>Unauthorized</b> status selected, when a new device is discovered, an alert will be triggered.",
    ["devices_status_post_learning_title"] = "Status Post Learning Period",
    ["disable_alerts_generation_description"] = "Emit alerts to the internal database and to notification recipients.",
    ["disable_alerts_generation_title"] = "Emit Alerts",
    ["dns"] = "DNS",
    ["dns_service"] = "Service",
    ["dump_frequency_description"] = "The frequency of flow dump to Elasticsearch.",
    ["dump_frequency_title"] = "Elasticsearch Flow Dump Frequency",
    ["dump_settings"] = "Flows Dump",
    ["duration"] = "Duration",
    ["dynamic_interfaces_creation_description"] = "ntopng can use a criterion to disaggregate incoming traffic. When a disaggregation criterion is selected, ntopng will use the criterion value to divert incoming traffic to dynamically-created interfaces. For example, when the 'VLAN Id' criterion is selected, a dynamic interface will be created for each VLAN Id observed, and the incoming traffic will be diverted to one dynamic interface depending the VLAN Id value. ",
    ["dynamic_interfaces_creation_note_0"] = "'VLAN Id' disaggregation is supported both for physical interfaces as well as for flows received over ZMQ. The other disaggregation criteria are only supported for ZMQ flows and will be ineffective for physical interfaces.",
    ["dynamic_interfaces_creation_note_1"] = "Criterion changes will not affect existing interfaces. <b>A restart of ntopng is required for the change to have effect</b>.",
    ["dynamic_interfaces_creation_note_2"] = "When using the 'Ingress Interface' criterion on non-sflow probes, %%INPUT_SNMP must appear into the nprobe template.",
    ["dynamic_interfaces_creation_note_3"] = "'Interface' disaggregation criterion adds any flow to two dynamic interfaces. The value of %%INPUT_SNMP is used to select the first dynamic interface, whereas the value of %%OUTPUT_SNMP is used to select the second.",
    ["dynamic_interfaces_creation_note_4"] = "A custom traffic disaggregation by means of BPF-like filters is also available by disabling Dynamic Traffic Disaggregation (set it to 'None') through the Custom Traffic Disaggregation tab.",
    ["dynamic_interfaces_creation_title"] = "Dynamic Traffic Disaggregation",
    ["dynamic_network_interfaces"] = "Dynamic Network Interfaces",
    ["elasticsearch_notification"] = "Elasticsearch Notification",
    ["elasticsearch_send_error"] = "Cannot connect to Elasticsearch. [Response code: %{code}][Response: %{resp}].",
    ["elasticsearch_sent_successfully"] = "Elasticsearch connection is working.",
    ["elasticsearch_unable_to_send_alerts"] = "Unable to send alerts to the Elasticsearch",
    ["elasticsearch_unsupported_version"] = "Unsupported Elasticsearch version %{version}. Need at least version 7.",
    ["elephant_flow_local_to_remote_bytes_description"] = "The amount of data a flow can upload before being considered an Elephant Flow.",
    ["elephant_flow_local_to_remote_bytes_title"] = "Elephant Flows Threshold (Local To Remote)",
    ["elephant_flow_remote_to_local_bytes_description"] = "The amount of data a flow can download before being considered an Elephant Flow.",
    ["elephant_flow_remote_to_local_bytes_title"] = "Elephant Flows Threshold (Remote To Local)",
    ["email_notification"] = "Email Notification",
    ["email_notification_password_description"] = "The SMTP server password for authentication (optional).",
    ["email_notification_password_title"] = "Password",
    ["email_notification_recipient_description"] = "The recipient email address.",
    ["email_notification_recipient_title"] = "Recipient",
    ["email_notification_sender_description"] = "The sender email address.",
    ["email_notification_sender_title"] = "Sender",
    ["email_notification_server_description"] = "<b>NOTES</b>:<ul><li>GMail users need to specify <i>smtps://smtp.gmail.com</i> as SMTP Server.</li><li>GMail also requires the <a href=\"https://myaccount.google.com/lesssecureapps\">Access for less secure apps</a> to be enabled.</li></ul>",
    ["email_notification_server_title"] = "SMTP Server",
    ["email_notification_username_description"] = "The SMTP server username for authentication (optional).",
    ["email_notification_username_title"] = "Username",
    ["email_send_error"] = "Email send error: %{msg}. Please see the <a href='%{url}'>online documentation</a>.",
    ["email_sent_successfully"] = "Email sent successfully",
    ["enable_alerts_refresh_description"] = "Enable to refresh periodically the alerts when a user is looking at the alert page.",
    ["enable_alerts_refresh_title"] = "Alert Refresh",
    ["errors"] = "Errors",
    ["errors_and_warnings"] = "Errors and Warnings",
    ["ewma_alpha_percent_description"] = "Exponentially Weighted Moving Average (EWMA) alpha coefficient, expressed as a percentage. Used to estimate Autonomous Systems round-trip time.",
    ["ewma_alpha_percent_title"] = "EWMA alpha coefficient (percent)",
    ["expert_view"] = "Expert View",
    ["exporter_timeseries"] = "Exporter Timeseries",
    ["featured_dns_description"] = "The following is a list of secure DNS servers. You can use them as a global DNS servers or as as Child Safe provider.",
    ["featured_dns_title"] = "Featured DNS Servers",
    ["flow_interface"] = "Interface",
    ["flow_max_idle_description"] = "Inactivity time after which a flow is considered idle. Only effective for packet interfaces. For ZMQ interfaces the timeout is determined automatically. Default: 1 min.",
    ["flow_max_idle_title"] = "Flow Idle Timeout",
    ["flow_table"] = "Flow Table",
    ["flow_table_begin_epoch_description"] = "Add/Remove the Begin column from flow table. Represents the first seen of the flow and it can be sorted.",
    ["flow_table_begin_epoch_title"] = "Flow Table Begin Column",
    ["flow_table_probe_order_description"] = "Order the probe filter by IP or Name (Useful only if at least one probe is available)",
    ["flow_table_probe_order_title"] = "Flow Table Probe Order",
    ["flow_table_time_description"] = "Time of the flow displayed into the flow table graph. Choose between the duration of the flow and the last time you saw the flow",
    ["flow_table_time_title"] = "Flow Table Time",
    ["flows_and_alerts_data_retention"] = "ClickHouse Flows/Alerts Data Retention",
    ["flows_and_alerts_data_retention_descr"] = "Number of days to keep raw (unaggregated) flows (if enabled) and alerts. Default: 30 days.",
    ["flows_dump"] = "Flows Dump",
    ["flows_dump_limited_days"] = "The Flow dump is limited to %{days} days in this ntopng version. Upgrade to the enterprise version to remove this limit.",
    ["global_dns_description"] = "A DNS server to redirect the clients DNS requests to for non Child Safe host pools. If empty, the redirection is disabled and the default DNS is used.",
    ["global_dns_title"] = "Global Primary DNS",
    ["gui"] = "User Interface",
    ["host_analysis"] = "Host Analysis",
    ["host_mask"] = "Mask Host IP Addresses",
    ["host_port_learning_period_description"] = "Configure the learning period duration for local hosts server ports used to trigger server port usagealert",
    ["host_port_learning_period_title"] = "Server Port Learning Period",
    ["http_auth"] = "HTTP Authentication",
    ["http_auth_server_description"] = "The URL of the HTTP server to use to authenticate users.",
    ["http_auth_server_log_description"] = "To log HTTP authentication successful events.",
    ["http_auth_server_log_title"] = "HTTP Authentication Log",
    ["http_auth_server_title"] = "HTTP Server",
    ["idle_timeout_settings"] = "Idle Timeout Settings",
    ["iec60870_learning_period_description"] = "Configure the learning period for IEC60870 traffic analysis. Default: 6 hours.",
    ["iec60870_learning_period_title"] = "IEC60870 Learning Period",
    ["ignored_interfaces_description"] = "When 'Ingress Interface' is selected as disaggregation criterion, do not add to a dynamic interface any flow having its %%INPUT_SNMP in this list. When 'Interface' disaggregation is selected, do not add to the first (second) dynamic interface any flow having its %%INPUT_SNMP (%%OUTPUT_SNMP) in this list. Specify one or more comma-separated SNMP interface ids. Changes require %{product} restart.",
    ["ignored_interfaces_title"] = "Ignored interfaces",
    ["incompatible_influxdb_version_found"] = "Incompatible InfluxDB version: required \"%{required}\", found \"%{found}\". Please install an updated version from the <a href='%{url}'>official site</a>.",
    ["influxdb_auth_description"] = "Enable InfluxDB authentication.",
    ["influxdb_auth_title"] = "InfluxDB Authentication",
    ["influxdb_create_error"] = "Could not create \"%{db}\" database: %{msg}",
    ["influxdb_dbname_description"] = "The database to use for timeseries storage. Existing data will not be migrated. In case an  InfluxDB v.2 with a compatible v.1 bucket, put the bucket name.",
    ["influxdb_dbname_title"] = "InfluxDB Database",
    ["influxdb_password_description"] = "The password to authenticate with the InfluxDB database.",
    ["influxdb_query_timeout_description"] = "Maximum duration in seconds for the InfluxDB queries. Queries exeeding this duration will be aborted.",
    ["influxdb_query_timeout_title"] = "Query Timeout",
    ["influxdb_retention_error"] = "Could not set retention policy on database \"%{db}\": %{msg}",
    ["influxdb_storage_note"] = "<b>NOTE</b>: data will be purged at intervals of %{interval}, which corresponds to the InfluxDB <a href='%{url}'>shard duration</a>.",
    ["influxdb_url_description"] = "The URL pointing to a running InfluxDB instance.",
    ["influxdb_url_title"] = "InfluxDB URL",
    ["influxdb_username_description"] = "The username to authenticate with the InfluxDB database.",
    ["ingress_egress_flow_interface"] = "Ingress/Egress Interface",
    ["ingress_flow_interface"] = "Ingress-only Interface",
    ["ingress_vrf_id"] = "Ingress VRF Id",
    ["interfaces_timeseries"] = "Interfaces Timeseries",
    ["internal_log"] = "Internal Log",
    ["ip_order"] = "IP",
    ["is_influxdb_running"] = "Is InfluxDB running?",
    ["l2_devices_timeseries"] = "Devices Timeseries",
    ["last_seen"] = "Last Seen",
    ["ldap_authentication"] = "LDAP Authentication",
    ["ldap_server_address_description"] = "IP address and port of the LDAP server. Default: \"ldap://localhost:389\"",
    ["ldap_server_address_title"] = "LDAP Server Address",
    ["learning_period_description"] = "Time, in hours, spent in learning the periodic services. Default: 1 hour.",
    ["learning_period_title"] = "Service Learning Period",
    ["license"] = "License",
    ["local_auth"] = "Local Authentication",
    ["local_host_cache_duration_description"] = "Time after which a cached local host is deleted from the cache. Default: 1 hour.",
    ["local_host_cache_duration_title"] = "Local Hosts Cache Duration",
    ["local_host_mask"] = "Mask Local Hosts",
    ["local_host_max_idle_description"] = "Inactivity time after which a local host is considered idle (sec). Idle local hosts are dumped to a cache so their counters can be restored in case they become active again. Counters include, but are not limited to, packets and bytes total and per Layer-7 application. Default: 5 min.",
    ["local_host_max_idle_title"] = "Local Host Idle Timeout",
    ["local_hosts_cache_settings"] = "Local Hosts Cache Settings",
    ["local_hosts_timeseries"] = "Local Hosts Timeseries",
    ["logging"] = "Logging",
    ["longlived_flow_duration_description"] = "The minimum duration for a flow to be considered a Long-Lived Flow.",
    ["longlived_flow_duration_title"] = "Long-Lived Flows Duration",
    ["max_config_save_backups_description"] = "The maximum number of configurations backup saved on Redis",
    ["max_config_save_backups_title"] = "Maximum Number of Configurations Backup Saved",
    ["max_entity_alerts_description"] = "The maximum number of alerts per family (hosts, networks, interfaces, etc). Alerts are checked periodically and, in case the actual number of alerts exceeds the maximum number, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number.",
    ["max_entity_alerts_title"] = "Maximum Number of Alerts",
    ["max_num_bytes_per_tiny_flow_description"] = "The maximum number of bytes a flow must have to be considered a tiny flow. Default: 64.",
    ["max_num_bytes_per_tiny_flow_title"] = "Maximum Number of Bytes per Tiny Flow",
    ["max_num_packets_per_tiny_flow_description"] = "The maximum number of packets a flow must have to be considered a tiny flow. Default: 3.",
    ["max_num_packets_per_tiny_flow_title"] = "Maximum Number of Packets per Tiny Flow",
    ["max_num_secs_before_delete_alert_description"] = "The maximum number of days before an alert is deleted. All the alerts older then that period will be automatically deleted both at startup and periodically by ntopng",
    ["max_num_secs_before_delete_alert_title"] = "Maximum Number of Days Before Delete",
    ["max_ui_strlen_description"] = "Shorten strings longer than the specified maximum number of characters.",
    ["max_ui_strlen_title"] = "Maximum Displayed String Length",
    ["menu_entries"] = "Menu Entries",
    ["message_broker"] = "Message Broker",
    ["message_broker_password_description"] = "The message broker password",
    ["message_broker_topics_list_description"] = "The list of topics to send to the broker",
    ["message_broker_url_description"] = "The message broker URL (e.g. nats://0.0.0.0:4222)",
    ["message_broker_url_title"] = "URL",
    ["message_broker_username_description"] = "The message broker username",
    ["message_brokers_description"] = "Select the message broker to use. This broker is going to be used to export informations regarding ntopng",
    ["message_brokers_title"] = "Broker",
    ["mgmt_acl_description"] = "A comma-separated list of IPv4 networks. Each network must be explicitly allowed or disallowed with a leading \"+\" or \"-\" sign, respectively. The longest-match principle is used with overlapping networks. Examples: \"+127.0.0.0/8\" makes the interface accessible only from localhost, \"+0.0.0.0/0,-192.168.0.0/16\", makes the interface accessible for everybody except 192.168.0.0/16. Must restart %{product} for changes to have effect.",
    ["mgmt_acl_title"] = "Access Control List",
    ["misc"] = "Misc",
    ["modbus_learning_period_description"] = "Configure the learning period for ModbusTCP traffic analysis. Default: 6 hours.",
    ["modbus_learning_period_title"] = "ModbusTCP Learning Period",
    ["mqtt"] = "MQTT",
    ["multiple_ldap_account_type_description"] = "Choose your account type",
    ["multiple_ldap_account_type_title"] = "LDAP Accounts Type",
    ["multiple_timeseries_database_description"] = "The driver used for storing and retrieving timeseries data.<br><b>Note:</b> It's possible to use InfluxDB v.2 with a compatible v.1 bucket, however the Retention and the Buckets have to be managed by the InfluxDB GUI.<br>Minimum InfluxDB version supported: <b>1.5.1</b>",
    ["multiple_timeseries_database_title"] = "Timeseries Driver",
    ["mysql"] = "MySQL",
    ["n2disk_license_description"] = "Continuous traffic recording requires a n2disk license, purchase one at <a href=\"%{purchase_url}\">e-shop</a>. If you are no-profit, research or an education institution please read <a href=\"%{universities_url}\">this</a>. ",
    ["n2disk_license_description_enterprise_l"] = "ntopng Enterprise L Bundle already unlocks n2disk 1G, thus no additional license is required in that case.",
    ["n2disk_license_systemid"] = "SystemID: %{systemid}",
    ["n2disk_license_title"] = "n2disk License Key",
    ["n2disk_license_version"] = "n2disk version: %{version}",
    ["name_order"] = "Name",
    ["names"] = "Names",
    ["nats"] = "NATS",
    ["netbox_activation_url_description"] = "NetBox Activation URL",
    ["netbox_activation_url_title"] = "NetBox URL",
    ["netbox_default_site"] = "NetBox Default Site",
    ["netbox_default_site_description"] = "Select Default Site for Netbox",
    ["netbox_personal_access_token_description"] = "NetBox Personal Access",
    ["netbox_personal_access_token_title"] = "NetBox Personal Access Token",
    ["network_discovery"] = "Network Discovery",
    ["network_discovery_interval_description"] = "Interval between consecutive discoveries of networks. Default: 15 min.",
    ["network_discovery_interval_title"] = "Active Network Discovery Interval",
    ["network_discovery_running"] = "Network Discovery Running",
    ["network_interfaces"] = "Network Interfaces",
    ["no_host_mask"] = "Don't Mask Hosts",
    ["non_local_host_max_idle_description"] = "Inactivity time after which a remote host is considered idle. Default: 1 min.",
    ["non_local_host_max_idle_title"] = "Remote Host Idle Timeout",
    ["none"] = "None",
    ["note_timeseries_resolution_disabled"] = "<b>NOTE</b>: this is disabled because \"%{pref}\" is not set to the default value.",
    ["note_update_frequency_disabled"] = "<b>NOTE</b>: this is disabled because of the \"%{pref}\" requirements.",
    ["ntopng_host_address_description"] = "ntopng hostname or public IP address used to reach the Web User Interface. This is used to generate external links (e.g. for reports). Optionally protocol scheme and port can also be provided (e.g. http://my.ntopng.org:3000).",
    ["ntopng_host_address_title"] = "Host Address",
    ["ntopng_instance_name_description"] = "The instance name is the value of the '-N' parameter, and it is also used in the subject of email notifications.",
    ["ntopng_instance_name_title"] = "Instance Name",
    ["observation_points"] = "Observation Points",
    ["ot_protocols"] = "OT Protocols",
    ["other_timeseries"] = "Other Timeseries",
    ["pap"] = "PAP",
    ["per_category"] = "Per Category",
    ["per_protocol"] = "Per Application",
    ["policy_target_type"] = "Policy Target Type",
    ["policy_target_type_description"] = "Specify what kind of policy target you wish to apply.",
    ["posix"] = "Posix",
    ["preferences"] = "Preferences",
    ["primary_dns"] = "Primary DNS",
    ["probe_ip_address"] = "Probe IP",
    ["probe_ip_and_ingress_iface_idx"] = "Probe IP + Ingress Interface",
    ["protocols"] = "Applications",
    ["radius_accounting_server_description"] = "Host and port of the RADIUS accounting server (e.g. %{example}).",
    ["radius_accounting_server_title"] = "Radius Accounting Server",
    ["radius_admin_group_description"] = "GUI users are authenticated as Administrator when the value for the <i>Filter-Id</i> RADIUS attribute matches the one specified in this field. Unprivileged otherwise.",
    ["radius_admin_group_title"] = "RADIUS Administrator Group",
    ["radius_auth"] = "RADIUS Authentication",
    ["radius_auth_proto_description"] = "The authentication protocol used by the radius server.",
    ["radius_auth_proto_title"] = "Radius Auth. Protocol",
    ["radius_secret_descroption"] = "The secret shared with the RADIUS server.",
    ["radius_secret_title"] = "RADIUS Secret",
    ["radius_server_description"] = "Host and port of the RADIUS server (e.g. %{example}).",
    ["radius_server_title"] = "RADIUS Server Address",
    ["radius_unpriv_capabilties_group_description"] = "GUI users which are Non-Administrator can have additional capabilities (e.g. pcap download and historical flow access) when the value for the <i>Filter-Id</i> RADIUS attribute matches the one specified in this field. In case of no match, limited capabilites are set for unprivileged users.",
    ["radius_unpriv_capabilties_group_title"] = "RADIUS Unprivileged Users Capabilities Group",
    ["recording"] = "Traffic Recording",
    ["remote_host_mask"] = "Mask Remote Hosts",
    ["report"] = "Report",
    ["reports"] = "Reports",
    ["reports_data_retention_time_descr"] = "Number of days to keep traffic reports on disk. Default: 30 days.",
    ["reports_data_retention_time_title"] = "Reports Data Retention",
    ["restart_needed"] = "Please restart %{product} in order to apply the changes",
    ["runtime_prefs"] = "Runtime Preferences",
    ["safe_search_dns_description"] = "The DNS server to be used to perform <a href='%{url}'>Child Safe</a> queries.<br>Child Safe can be enabled for individual host pools from the host pools configuration page. Default: 208.67.222.123.",
    ["safe_search_dns_title"] = "Child Safe DNS",
    ["samaccount"] = "sAMAccount",
    ["search_path_description"] = "Root path used to search the users. Example: \"dc=example,dc=com\"",
    ["search_path_title"] = "LDAP Search Path",
    ["search_preferences"] = "Search Preferences",
    ["secondary_dns"] = "Secondary DNS",
    ["secondary_dns_description"] = "A fallback DNS server to use when the global primary DNS server is not available.",
    ["secondary_dns_title"] = "Global Secondary DNS",
    ["security_alerts"] = "Security Alerts",
    ["send_test_elasticsearch"] = "Test Connection",
    ["send_test_mail"] = "Send Test Email",
    ["send_test_slack"] = "Send Test Message",
    ["send_test_webhook"] = "Send Test Message",
    ["sender_username_description"] = "Set the username of the sender of slack notifications",
    ["sender_username_title"] = "Notification Sender Username",
    ["service_map"] = "Service Map",
    ["simple_view"] = "Simple View",
    ["slack_channel"] = "Slack Channel",
    ["slack_channel_names"] = "Channel Names",
    ["slack_channel_names_descr"] = "Configure the Slack channels where each alert will be sent. Channels must exist in order to correcly display the alert.",
    ["slack_integration"] = "Slack Integration",
    ["slack_notification_severity_preference_description"] = "Errors (errors only), Errors and Warnings (errors and warnings, no info), All (every kind of alerts will be notified).",
    ["slack_notification_severity_preference_title"] = "Notification Severity",
    ["slack_send_error"] = "Slack message send error.",
    ["slack_sent_successfully"] = "A Slack message has been sent to the #%{channel} channel.",
    ["slack_webhook_description"] = "Send your notification to this slack URL",
    ["slack_webhook_title"] = "Notification Webhook",
    ["snmp"] = "SNMP",
    ["snmp_alerts"] = "SNMP Alerts",
    ["snmp_device_config"] = "Device Configuration",
    ["snmp_port_avg_usage_threshold_description"] = "Set a threshold to trigger alerts when the port percentage usage (in or out traffic) exceeds the specified limit (on a 5-min average).",
    ["snmp_port_avg_usage_threshold_title"] = "Interface Avg Usage Threshold",
    ["snmp_port_load_threshold_description"] = "Set a threshold (as percentage of the port speed) to trigger alerts when the port load exceeds the specified limit (on a 5-min average).",
    ["snmp_port_load_threshold_title"] = "Interface Load Threshold",
    ["snmp_port_too_many_macs_description"] = "Trigger an alert when the number of MACs detected on a non-trunk port exceeds the configured threshold",
    ["snmp_port_too_many_macs_title"] = "Too Many MACs on Non-Trunk",
    ["snmp_timeseries_config_link"] = "SNMP timeseries can be enabled from the <a href=\"%{url}\">SNMP section</a>.",
    ["stats_reset"] = "Stats Reset",
    ["status_alerts"] = "Status Alerts",
    ["successfully_connected_influxdb"] = "Successfully initialized database \"%{db}\" on InfluxDB(%{version})",
    ["syslog_alert_format_description"] = "Chose the syslog alerts output format.",
    ["syslog_alert_format_json"] = "JSON",
    ["syslog_alert_format_plaintext"] = "Plain Text",
    ["syslog_alert_format_title"] = "Syslog Alerts Format",
    ["syslog_notification"] = "Syslog Notification",
    ["syslog_sent_successfully"] = "A message has been logged",
    ["system_probes_timeseries"] = "Probes Timeseries",
    ["teams_send_error"] = "Error sending message to Microsoft Teams.",
    ["teams_sent_successfully"] = "A message has been sent to Microsoft Teams",
    ["telemetry"] = "Telemetry",
    ["telemetry_contribute"] = "Contribute",
    ["telemetry_do_not_contribute"] = "Do not contribute",
    ["telemetry_email_description"] = "Provide an email address if you want to be contacted by the ntop team in case anomalies in the telemetry data are detected. ntop will not be able to identify you if you do not provide this address.",
    ["telemetry_email_title"] = "Contact",
    ["timeseries"] = "Timeseries",
    ["timeseries_database"] = "Timeseries Database",
    ["timeseries_resolution_resolution_description_2"] = "The interval between consecutive timeseries data points for local hosts",
    ["timeseries_resolution_resolution_title"] = "Timeseries Resolution",
    ["toggle_access_log_description"] = "Toggle the creation of HTTP access log in the data dump directory. Settings will have effect at next %{product} startup.",
    ["toggle_access_log_title"] = "Enable HTTP Access Log",
    ["toggle_active_configurations_backup_description"] = "Enable the daily auto backup of admin configurations.",
    ["toggle_active_configurations_backup_title"] = "Auto Backup Configurations",
    ["toggle_active_local_host_cache_enabled_description"] = "Toggle the creation of cache entries for active local hosts. Caching active local hosts periodically can be useful to protect host counters against failures (e.g., power losses). This is particularly important for local hosts that seldomly go idle as it guarantees that their counters will be cached after the specified time interval.",
    ["toggle_active_local_host_cache_enabled_title"] = "Active Local Hosts Cache",
    ["toggle_active_monitoring_description"] = "Toggle the Active Monitoring",
    ["toggle_active_monitoring_title"] = "Active Monitoring",
    ["toggle_alert_syslog_description"] = "Toggle alerts logging to system syslog.",
    ["toggle_alert_syslog_title"] = "Toggle Syslog Notification",
    ["toggle_alerts_notifications_description"] = "Toggle the reporting of alert to third-party endpoints.",
    ["toggle_alerts_notifications_title"] = "Alerts to Third-Party Endpoints",
    ["toggle_asn_rrds_description"] = "Toggle the creation of bytes and application timeseries for autonomous systems.",
    ["toggle_asn_rrds_title"] = "Autonomous Systems",
    ["toggle_autologout_description"] = "Toggle the automatic logout of web interface users with expired sessions.",
    ["toggle_autologout_title"] = "Auto Logout",
    ["toggle_autoupdates_description"] = "Toggle overnight automatic %{product} updates. Please note that %{product} is automatically restarted after a successfull update.",
    ["toggle_autoupdates_title"] = "Automatic Updates",
    ["toggle_behaviour_analysis_description"] = "Enable host and interface behavior traffic analysis. <b>Restart is required</b> in order this preference to have effect.",
    ["toggle_behaviour_analysis_title"] = "Enable Traffic Behaviour Analysis",
    ["toggle_captive_portal_description"] = "Enable the web captive portal for authenticating network users.",
    ["toggle_captive_portal_title"] = "Captive Portal",
    ["toggle_country_rrds_description"] = "Toggle the creation of bytes timeseries for countries.",
    ["toggle_country_rrds_title"] = "Countries",
    ["toggle_date_type_description"] = "Switch between different <A class='ntopng-external-link'  target='_blank' HREF='https://en.wikipedia.org/wiki/Date_format_by_country'>format for date representation</A>.",
    ["toggle_date_type_title"] = "Date Format",
    ["toggle_dst_with_post_nat_dst_description"] = "Replace IPv4 destination addresses (%%IPV4_DST_ADDR) and ports (%%L4_DST_PORT) with their post-nat values (%%POST_NAT_DST_IPV4_ADDR and %%POST_NAT_DST_TRANSPORT_PORT).",
    ["toggle_dst_with_post_nat_dst_title"] = "Use Post-Nat Destination IPv4 Addresses and Ports",
    ["toggle_elasticsearch_notification_description"] = "Toggle alerts notifications to Elasticsearch.",
    ["toggle_elasticsearch_notification_title"] = "Toggle Elasticsearch Notification",
    ["toggle_elephant_flows_alerts_description"] = "Toggle alerts generated when an elephant flow has been detected. This is useful to detect unwanted behaviours (e.g. data exfiltration).",
    ["toggle_elephant_flows_alerts_title"] = "Elephant Flows Alerts",
    ["toggle_email_notification_description"] = "Toggle alerts notifications via email.",
    ["toggle_email_notification_title"] = "Toggle Email Notification",
    ["toggle_emit_flow_alerts_description"] = "You can disable the generation of flow alerts in order to save CPU cycles. In this case the score will be updated but no flow alert will be triggered.",
    ["toggle_emit_flow_alerts_title"] = "Emit Flow Alerts",
    ["toggle_emit_host_alerts_description"] = "You can disable the generation of host alerts in order to save CPU cycles. In this case the score will be updated but no host alert will be triggered.",
    ["toggle_emit_host_alerts_title"] = "Emit Host Alerts",
    ["toggle_enable_automatic_reports_descr"] = "Toggle the generation of periodic (daily) reports. Reports are generated for all the interfaces and can be disabled individually in the interface settings page.",
    ["toggle_enable_automatic_reports_title"] = "Daily Reports Generation",
    ["toggle_enable_runtime_flows_dump_description"] = "Toggle the dump of flows towards the configured database.",
    ["toggle_enable_runtime_flows_dump_title"] = "Flows Dump",
    ["toggle_exporter_interface_usage_timeseries_description"] = "Toggle the creation of timeseries for interfaces usage of Exporters.",
    ["toggle_exporter_interface_usage_timeseries_title"] = "Interface Usage",
    ["toggle_external_auth_captive_portal_description"] = "Authenticate and authorize the user using an external service running at Informative Page URL. The external service must add the device, which is not assigned by default, to the proper nEdge user to authorize it.",
    ["toggle_external_auth_captive_portal_title"] = "External Authentication/Authorization",
    ["toggle_fingerprint_stats_description"] = "Toggle host fingerprint statistics",
    ["toggle_fingerprint_stats_title"] = "Fingerprint Statistics",
    ["toggle_flow_aggregated_alerted_flows_description"] = "Include all alerted flows in aggregated flows.",
    ["toggle_flow_aggregated_alerted_flows_title"] = "Include Alerted Flows",
    ["toggle_flow_aggregated_limit_description"] = "Number of maximum aggregated flow entries to insert every hourly dump.",
    ["toggle_flow_aggregated_limit_title"] = "ClickHouse Limit Aggregated Flows",
    ["toggle_flow_aggregated_traffic_limit_description"] = "Discard aggregated flows whose size is less that the specified value (in KBytes).",
    ["toggle_flow_aggregated_traffic_limit_title"] = "ClickHouse Minimum Aggregated Flow Traffic",
    ["toggle_flow_rrds_description"] = "Toggle the creation of bytes timeseries for each port of the remote flow exporter device as received through ZMQ (e.g. sFlow/NetFlow/SNMP).<br>For non sFlow probes, %%INPUT_SNMP and %%OUTPUT_SNMP must appear into the nprobe template.",
    ["toggle_flow_rrds_title"] = "Flow Exporters and Probes",
    ["toggle_host_mask_description"] = "For privacy reasons it might be necessary to mask hosts IP addresses. For instance if you are an ISP you are not supposed to know which local addresses are accessing remote hosts.",
    ["toggle_host_mask_title"] = "Mask Host IP Addresses",
    ["toggle_host_pools_log_description"] = "Toggle the creation of logs related to host pools. Logs include associations and disassociations of hosts to their host pools.",
    ["toggle_host_pools_log_title"] = "Enable Host Pool Events Log",
    ["toggle_host_tskey_description"] = "The key to use for data and timeseries dump for hosts in the local broadcast domain. In a DHCP network it's usually desiderable to choose 'MAC Address'.",
    ["toggle_host_tskey_title"] = "Local Broadcast Domain Hosts Identifier",
    ["toggle_http_auth"] = "Toggle HTTP Authentication",
    ["toggle_http_auth_descr"] = "Toggle gui authentication via an HTTP authenticator.",
    ["toggle_ids_alert_description"] = "Toggle alerts generated by Intrusion Detection Systems. See the Suricata integration through syslog.",
    ["toggle_ids_alert_title"] = "IDS Alerts",
    ["toggle_informative_captive_portal_description"] = "Do not authenticate users. Show only an informative page before letting users access the Internet.",
    ["toggle_informative_captive_portal_title"] = "Informative",
    ["toggle_interface_name_only_description"] = "If enabled, show the interface name only into the dropdown menu.",
    ["toggle_interface_name_only_title"] = "Interface Name Only",
    ["toggle_internals_rrds_description"] = "Toggle the creation of <a href=\"%{url}\">internals</a> timeseries, e.g., hash tables entries, periodic activities duration and number of timeseries points written, scripts duration and number of calls.",
    ["toggle_internals_rrds_title"] = "Internals",
    ["toggle_intranet_traffic_rrds_description"] = "Toggle the creation of timeseries traffic between networks.<br><b>Note:</b> These timeseries are going to be available only if the Local Network timeseries are enabled and they can be found under the Network timeseries tab (e.g. 192.168.2.1/24 -> 172.10.1.1/24).",
    ["toggle_intranet_traffic_rrds_title"] = "Network Traffic Matrix",
    ["toggle_ldap_anonymous_bind_description"] = "Enable anonymous binding.",
    ["toggle_ldap_anonymous_bind_title"] = "LDAP Anonymous Binding",
    ["toggle_ldap_auth"] = "Toggle LDAP Authentication",
    ["toggle_ldap_auth_descr"] = "Toggle gui authentication via LDAP.",
    ["toggle_ldap_referrals_description"] = "Specifies if the client should automatically follow referrals returned by LDAP servers.",
    ["toggle_ldap_referrals_title"] = "Follow Referrals",
    ["toggle_local_auth"] = "Toggle Local Authentication",
    ["toggle_local_auth_descr"] = "Toggle gui authentication according to %{product} defined users.",
    ["toggle_local_host_cache_enabled_description"] = "Toggle the creation of cache entries for idle local hosts. Cached local hosts counters are restored automatically to their previous values  upon detection of additional host traffic.",
    ["toggle_local_host_cache_enabled_title"] = "Idle Local Hosts Cache",
    ["toggle_local_hosts_one_way_ts_description"] = "Toggle the creation of timeseries for one-way traffic. One-way traffic is often generated by remote hosts performing probing, so it is advisable to keep this disabled.",
    ["toggle_local_hosts_one_way_ts_title"] = "One-Way Traffic Timeseries",
    ["toggle_local_hosts_ts_creation_description"] = "Enable full host timeseries creation (full), limit it to bytes and score (light), or turn it off.",
    ["toggle_local_hosts_ts_creation_title"] = "Host Timeseries",
    ["toggle_log_to_file_description"] = "Toggle the creation of ntopng.log in the data dump directory instead of using syslog. Settings will have effect at next %{product} startup.",
    ["toggle_log_to_file_title"] = "Enable Trace Log",
    ["toggle_logging_level_description"] = "Choose the runtime logging level.",
    ["toggle_logging_level_title"] = "Log level",
    ["toggle_longlived_flows_alerts_description"] = "Toggle alerts generated when a long-lived flow has been detected. This is useful to detect unwanted behaviours (e.g. data exfiltration).",
    ["toggle_longlived_flows_alerts_title"] = "Long-Lived Flows Alerts",
    ["toggle_mdns_repeater_description"] = "Forward MDNS (multicast) requests/responses between LAN interfaces even with different subnets.",
    ["toggle_mdns_repeater_title"] = "MDNS Forwarding",
    ["toggle_menu_entry_developer_description"] = "Enabled menu entry with developer utility pages.",
    ["toggle_menu_entry_developer_title"] = "Developer Menu Entry",
    ["toggle_menu_entry_help_description"] = "Enabled menu entry with helper pages.",
    ["toggle_menu_entry_help_title"] = "Help Menu Entry",
    ["toggle_message_broker_description"] = "Enable sending statistics and informations to a message broker.",
    ["toggle_message_broker_title"] = "Enable Broker",
    ["toggle_midnight_stats_reset_description"] = "Toggle the automatic stats reset at midnight. This includes Hosts and MAC addresses stats.",
    ["toggle_midnight_stats_reset_title"] = "Midnight Stats Reset",
    ["toggle_mysql_check_open_files_limit_description"] = "Enable MySQL alerts generations due to periodic checks of MySQL open_files_limit.<br>The open_files_limit check is useful to detect when the number of open MySQL files is high, which could lead to database insertion errors.",
    ["toggle_mysql_check_open_files_limit_title"] = "Enable MySQL alerts",
    ["toggle_ndpi_flows_rrds_description"] = "Toggle the creation of timeseries for the number of total flows per Layer-7 application.",
    ["toggle_ndpi_flows_rrds_title"] = "Layer-7 Total Flows",
    ["toggle_ndpi_timeseries_creation_description"] = "Toggle the creation of Layer-7 application timeseries. Creating a timeseries per application requires more disk space and extra I/O and, in general, it is not needed.",
    ["toggle_ndpi_timeseries_creation_title"] = "Layer-7 Applications",
    ["toggle_netbox_description"] = "Toggle NetBox integration",
    ["toggle_netbox_title"] = "NetBox",
    ["toggle_network_discovery_debug_description"] = "Toggle the debugging of Network Discovery. Enabling this will print extra information out to the ntopng logs.",
    ["toggle_network_discovery_debug_title"] = "Network Discovery Debug",
    ["toggle_network_discovery_description"] = "Toggle the periodic discovery of network devices using multiple techniques that include ARP scan, MDNS and SSDP.<p><b><b>NOTE</b>:</b> discovery can be <u>only</u> enabled on physical interfaces  (i.e. no ZMQ) where we can send/receive traffic to the network (i.e. read-only interfaces such as those connected to port mirrors won't work). ",
    ["toggle_network_discovery_title"] = "Active Network Discovery",
    ["toggle_ntopng_assets_inventory_description"] = "Enable built-in assets inventory database",
    ["toggle_ntopng_assets_inventory_title"] = "Built-in Assets Inventory",
    ["toggle_observation_points_rrd_creation_description"] = "Toggle the creation of bytes and flows timeseries for the Observation Points available.",
    ["toggle_observation_points_rrds_description"] = "Toggle Observation Points timeseries. No timeseries is created if there are no observation points.<br><b>Note:</b> The Observation Point timeseries L7 applications preferences are the same of the Interface; so if no timeseries is created for the interface L7 applications then no timeseries is created for the Observation Points L7 applications.",
    ["toggle_observation_points_rrds_title"] = "Observation Points",
    ["toggle_os_rrds_description"] = "Toggle the creation of bytes timeseries for Operating Systems.",
    ["toggle_os_rrds_title"] = "Operating Systems",
    ["toggle_pools_rrds_description"] = "Toggle the creation of bytes and applications timeseries for defined host pools.",
    ["toggle_pools_rrds_title"] = "Host Pools",
    ["toggle_radius_accounting"] = "Toggle RADIUS Accounting",
    ["toggle_radius_accounting_descr"] = "Toggle traffic accounting via RADIUS server.",
    ["toggle_radius_auth"] = "Toggle RADIUS Authentication",
    ["toggle_radius_auth_descr"] = "Toggle GUI authentication via RADIUS server.",
    ["toggle_radius_external_auth_for_local_users"] = "Toggle RADIUS Authentication of Local Users",
    ["toggle_radius_external_auth_for_local_users_descr"] = "Toggle authentication of local users via RADIUS (remote authentication, local authorization).",
    ["toggle_send_telemetry_data_description"] = "Contribute to the project by sending encrypted, <a href=\"%{url}\">anonymous telemetry data</a> to <a href=\"%{ntop_org}\">ntop.org</a>. Data only involves the status of %{product} (e.g., uptime, status, crash reports). Nothing regarding the monitored traffic will ever be sent.",
    ["toggle_send_telemetry_data_title"] = "Telemetry Data",
    ["toggle_shaping_directions_description"] = "Enable this option to be able to set different shaping policies for ingress and egress traffic.",
    ["toggle_shaping_directions_title"] = "Split Shaping Directions",
    ["toggle_slack_notification_description"] = "Toggle alerts notifications via slack. See integration instructions <a href='%{url}'>here</a>.",
    ["toggle_slack_notification_title"] = "Toggle <a href=\"%{url}\">Slack</a> Notification",
    ["toggle_snmp_alerts_port_duplexstatus_change_description"] = "Toggle alerts generated when an interface duplex status changes",
    ["toggle_snmp_alerts_port_duplexstatus_change_title"] = "Interface Duplex Status Change Alerts",
    ["toggle_snmp_alerts_port_errors_description"] = "Toggle alerts generated when the discards or errors counters on an interface increase",
    ["toggle_snmp_alerts_port_errors_title"] = "Interface Discards/Errors Alerts",
    ["toggle_snmp_alerts_port_status_change_description"] = "Toggle alerts generated when an interface operational state changes",
    ["toggle_snmp_alerts_port_status_change_title"] = "Interface Operational Status Change Alerts",
    ["toggle_snmp_debug_description"] = "Toggle the debugging of SNMP devices. Enabling this will print extra information out to the ntopng logs.",
    ["toggle_snmp_debug_title"] = "SNMP Debug",
    ["toggle_snmp_polling_description"] = "Toggle the polling of SNMP devices.",
    ["toggle_snmp_polling_title"] = "SNMP Polling",
    ["toggle_snmp_port_admin_status_description"] = "Toggle interface admin status. Toggle is immediate but actual status shown is refreshed during the next poll.",
    ["toggle_snmp_port_admin_status_title"] = "Interface Admin Status",
    ["toggle_snmp_port_qos_mib_polling_description"] = "Toggle the QoS MIB Polling of a device interface.",
    ["toggle_snmp_port_qos_mib_polling_title"] = "Interface QoS MIB Polling",
    ["toggle_snmp_rrds_description"] = "Toggle the creation of bytes timeseries for each port of the SNMP devices. For each device port will be created a timeseries with ingress/egress bytes.",
    ["toggle_snmp_rrds_title"] = "SNMP Devices Timeseries",
    ["toggle_snmp_trap_description"] = "Toggle SNMP Trap collection on port UDP:162.",
    ["toggle_snmp_trap_title"] = "SNMP Trap Collection",
    ["toggle_src_with_post_nat_src_description"] = "Replace IPv4 source addresses (%%IPV4_SRC_ADDR) and ports (%%L4_SRC_PORT) with their post-nat values (%%POST_NAT_SRC_IPV4_ADDR and %%POST_NAT_SRC_TRANSPORT_PORT).",
    ["toggle_src_with_post_nat_src_title"] = "Use Post-Nat Source IPv4 Addresses and Ports",
    ["toggle_system_probes_timeseries_description"] = "Toggle the creation of timeseries for system probes such as the Active Monitoring and the Redis monitor.",
    ["toggle_system_probes_timeseries_title"] = "Probes",
    ["toggle_theme_description"] = "Toggle betweens themes.",
    ["toggle_theme_title"] = "Theme",
    ["toggle_thpt_content_description"] = "Select the throughput unit to be displayed in traffic reports.",
    ["toggle_thpt_content_title"] = "Throughput Unit",
    ["toggle_tiny_flows_dump_description"] = "Toggle the dump of tiny flows, that are flows with few packets or bytes. Reduces flow cardinality in databases, speeds-up inserts and searches. Tuning tiny flows can help to limit flow cardinality while not reducing visibility on dumped information.",
    ["toggle_tiny_flows_dump_title"] = "Tiny Flows Dump",
    ["toggle_tls_quic_hostnaming_description"] = "Use the requested TLS/QUIC SNI as hostname. Enabling it makes host naming more effective, but it can introduce false positives in host names.",
    ["toggle_tls_quic_hostnaming_title"] = "TLS & QUIC hostnames",
    ["toggle_top_sites_description"] = "Toggle the creation of top visited web sites for local hosts. Top sites are created using an <a href=\"%{url}\">heuristic</a> that maintain no more than 20 sites per local host. The heuristic fully operates in memory and does not require any interaction with the disk. Top sites are cleared every 5 minutes. An historical archive of top visited web sites can be created, for each local host, by periodically polling the JSON <i class=\"fas fa-download fa-sm\"></i> download link accessible from host details page. The application protocols of these sites are: TLS, QUIC, HTTP and DNS",
    ["toggle_top_sites_title"] = "Top Visited Sites",
    ["toggle_traffic_rrd_creation_description"] = "Toggle the creation of bytes and packets timeseries.",
    ["toggle_traffic_rrd_creation_title"] = "Traffic",
    ["toggle_use_mac_in_flow_key_description"] = "Use the MAC Address to generate the flow key. This is suggested in case the same IP can be seen using different MAC Addresses (e.g. a load balancer).",
    ["toggle_use_mac_in_flow_key_title"] = "Use MAC Address in Flow Key",
    ["toggle_users_rrds_description"] = "Toggle the creation of bytes and applications timeseries for defined users.",
    ["toggle_users_rrds_title"] = "Users",
    ["toggle_vlan_rrds_description"] = "Toggle the creation of bytes and applications timeseries for VLANs.",
    ["toggle_vlan_rrds_title"] = "VLANs",
    ["toggle_webhook_notification_description"] = "Toggle alerts notifications via webhook (HTTP).",
    ["toggle_webhook_notification_title"] = "Toggle Webhook Notification",
    ["topics"] = "Topics",
    ["topk_heuristic_precision_description"] = "Use an heuristic when aggregating historical top hosts, countries, etc, to build traffic reports. Useful when building reports over long-periods.",
    ["topk_heuristic_precision_title"] = "Top-K Heuristic",
    ["traffic_behaviour"] = "Traffic Behaviour",
    ["traffic_bridging"] = "Traffic Bridging",
    ["traffic_shaping"] = "Traffic Shaping",
    ["ts_and_stats_data_retention"] = "Timeseries/Stats Data Retention",
    ["ts_and_stats_data_retention_descr"] = "Number of days to keep timeseries and stats (e.g. Top Talkers). Default: 30 days.<br><b>Note:</b> If InfluxDB is currently used, to change the retention policy correctly, ntopng restart is needed.<br><b>Note:</b> If InfluxDB v.2 with a compatible v.1 bucket is used, the retention policy does not work.",
    ["ts_resolution_note2"] = "Lowering the resolution can create gaps in the existing data. It is advisable to <a target=_blank title=\"%{url}\">delete the database %{external_icon}</a>.",
    ["updates"] = "Updates",
    ["user_authentication"] = "User Authentication",
    ["user_group_description"] = "Group name to which user has to belong in order to authenticate as unprivileged user. Example: \"staff\"",
    ["user_group_title"] = "LDAP User Group",
    ["vlan"] = "VLAN Id",
    ["vs_concurrently_scan_number_descr"] = "Maximum number of scans executed simultaneously (more scans require more resources). Default: 4; Min value: 1; Max value: 16.",
    ["vs_concurrently_scan_number_title"] = "Maximum Concurrent Vulnerability Scans",
    ["vs_slow_mode_description"] = "To enable slow mode for the execution of scans.",
    ["vs_slow_mode_title"] = "Slow Mode",
    ["vulnerability_scan"] = "Vulnerability Scan",
    ["web_user_interface"] = "Web User Interface",
    ["webhook_notification"] = "Webhook Notification",
    ["webhook_notification_severity_preference_description"] = "Errors (errors only), Errors and Warnings (errors and warnings, no info), All (every kind of alerts will be notified).",
    ["webhook_notification_severity_preference_title"] = "Notification Severity",
    ["webhook_password_description"] = "The password to be used in case of HTTP authentication (optional).",
    ["webhook_send_error"] = "Error sending message to the webhook.",
    ["webhook_sent_successfully"] = "A message has been sent to the webhook",
    ["webhook_sharedsecret_description"] = "Set a (user-defined) secret to be validated by the receiver (optional).",
    ["webhook_sharedsecret_title"] = "Shared Secret",
    ["webhook_url_description"] = "Send notification to this URL in JSON format.",
    ["webhook_url_title"] = "Notification URL",
    ["webhook_username_description"] = "The username to be used in case of HTTP authentication (optional).",
    ["wifi"] = "Wireless",
    ["zmq_interfaces"] = "ZMQ Interfaces",
    ["geo_map"] = {
      ["geo_map"] = "Geo Map",
      ["geo_map_customization"] = "Geo Map Customization",
      ["toggle_geo_map_alerted_flows_title"] = "Num. Alerted Flows",
      ["toggle_geo_map_asname_title"] = "Autonomous System Name",
      ["toggle_geo_map_blacklisted_flows_title"] = "Num. Blacklisted Flows",
      ["toggle_geo_map_custom_description"] = "Toggle the specified extra info into the Geo Map host view",
      ["toggle_geo_map_host_name_title"] = "Host Name",
      ["toggle_geo_map_num_flows_title"] = "Num. Flows",
      ["toggle_geo_map_rxtx_data_title"] = "Rx/Tx data",
      ["toggle_geo_map_score_title"] = "Score",
    },
  },
  ["processes_stats"] = {
    ["active_processes_title"] = "Active Processes: Realtime View",
    ["active_since"] = "Active Since",
    ["bytes_count"] = "Bytes Count",
    ["legend"] = "Legend",
    ["lines"] = "Lines",
    ["missing_pid_name_message"] = "Missing pid name",
    ["no_traffic_detected"] = "No traffic detected for this process, flow process expired, or process terminated.",
    ["processes_timeline_title"] = "Processes Timeline",
    ["stack"] = "Stack",
    ["timeline"] = "Timeline",
    ["top_hosts"] = "Top Hosts",
    ["top_hosts_traffic"] = "Top Hosts Traffic",
    ["traffic_rcvd"] = "Traffic Rcvd",
    ["traffic_sent"] = "Traffic Sent",
    ["type"] = "Type",
  },
  ["queries"] = {
    ["alerted_domains"] = "Alerted Domains",
    ["clients"] = "Clients",
    ["custom_query"] = "Custom Query",
    ["l7_contacts"] = "L7 Contacts",
    ["queries"] = "Queries",
    ["raw_flows"] = "Flows",
    ["raw_flows_bytes"] = "Flows (Bytes Chart)",
    ["raw_flows_records"] = "Flows (Num. Flows Chart)",
    ["raw_flows_score"] = "Flows (Score Chart)",
    ["raw_flows_thpt"] = "Flows (Throughput Chart)",
  },
  ["queue"] = {
    ["activeFlowsToDump"] = "Active flows dump",
    ["hookFlowEnd"] = "flowEnd flow user script hook",
    ["hookPeriodicUpdate"] = "periodicUpdate flow user script hook",
    ["hookProtocolDetected"] = "protocolDetected flow user script hook",
    ["idleFlowsToDump"] = "Idle flows dump",
  },
  ["queue_description"] = {
    ["activeFlowsToDump"] = "Queue holding active flows waiting to be dumped",
    ["hookFlowEnd"] = "Idle flows enqueued waiting to have their flowEnd user script hook executed",
    ["hookPeriodicUpdate"] = "Active flows waiting to have their periodicUpdate user script hook",
    ["hookProtocolDetected"] = "New flows waiting to have their protocolDetected user script hook executed",
    ["idleFlowsToDump"] = "Queue holding idle flows waiting to be dumped",
  },
  ["report"] = {
    ["application_breakdown"] = "Application Breakdown",
    ["applications"] = "L7 Protocol",
    ["approximated_data"] = "Minor data approximation can be performed when selecting very large intervals of time.",
    ["begin_date_time"] = "Begin Date/Time",
    ["date"] = "%{month}-%{day}-%{year}",
    ["end_date_time"] = "End Date/Time",
    ["file"] = "Report File",
    ["filter_report"] = "Filter Report",
    ["generate"] = "Generate",
    ["invalid_begin"] = "Invalid Begin",
    ["invalid_begin_date"] = "Invalid Begin Date",
    ["invalid_begin_end"] = "Invalid Begin/End",
    ["invalid_to"] = "Invalid To",
    ["local_networks"] = "Local Networks",
    ["local_remote"] = "Local/Remote",
    ["network_interface"] = "Network Interface",
    ["new_report_available_description"] = "There is a new %{periodicity} report %{name} available in ntopng for interface %{ifname} under the Reports section.",
    ["new_report_available_link"] = "Go to Report",
    ["new_report_available_note"] = "A retention time of %{retention_days} days is configured in the ntopng Preferences, it is recommended to downlaod and backup the report.",
    ["new_report_available_title"] = "New Report Available",
    ["period"] = "Interval",
    ["please_check_format"] = "please check its format",
    ["please_choose_valid"] = "please choose a valid begin/end date and time",
    ["please_choose_valid_date_and_time"] = "please choose a valid date and time",
    ["receivers"] = "Receivers",
    ["remote_local"] = "Remote/Local",
    ["report_for_subject"] = "Report - %{num_min} - for %{subject} starting %{dt}",
    ["report_name"] = "Report Name",
    ["reports"] = "Traffic Reports",
    ["reports_deprecated"] = "A new report page is available in ntopng Enterprise with ClickHouse enabled. This report page is deprecated and it will be no longer available in future releases.",
    ["reports_professional_only"] = "Reports are only available in the Professional version",
    ["score_distribution"] = "Score Distribution",
    ["senders"] = "Senders",
    ["starting"] = "Starting",
    ["submit_filter"] = "Submit Filter",
    ["symbolic_host_name_at_visualization"] = "Symbolic host names are resolved during the visualization.",
    ["toggle_all"] = "Toggle All",
    ["top_asn"] = "Top Autonomous Systems",
    ["top_countries"] = "Top Countries",
    ["top_local_hosts"] = "Top Local Hosts",
    ["top_local_os"] = "Top Local OS",
    ["top_mitre_id_flows"] = "Top Mitre Attacks (Flows)",
    ["top_mitre_id_hosts"] = "Top Mitre Attacks (Hosts)",
    ["top_mitre_subtechnique_flows"] = "Top Mitre Sub-Techniques (Flows)",
    ["top_mitre_subtechnique_hosts"] = "Top Mitre Sub-Techniques (Hosts)",
    ["top_mitre_tactic_flows"] = "Top Mitre Tactics (Flows)",
    ["top_mitre_tactic_hosts"] = "Top Mitre Tactics (Hosts)",
    ["top_mitre_technique_flows"] = "Top Mitre Techniques (Flows)",
    ["top_mitre_technique_hosts"] = "Top Mitre Techniques (Hosts)",
    ["top_networks"] = "Top Networks",
    ["top_non_local_os"] = "Top Non-Local OS",
    ["top_receiver_as"] = "Top Receiver AS",
    ["top_receiver_countries"] = "Top Receiver Countries",
    ["top_receiver_networks"] = "Top Receiver Networks",
    ["top_remote_hosts"] = "Top Remote Hosts",
    ["top_sender_as"] = "Top Sender AS",
    ["top_sender_countries"] = "Top Sender Countries",
    ["top_sender_networks"] = "Top Sender Networks",
    ["top_talkers"] = "Top Talkers",
    ["total_traffic"] = "Total Traffic",
    ["traffic_anomalies"] = "Traffic Anomalies",
    ["traffic_anomalies_local_hosts"] = "Local Hosts Anomalies",
    ["traffic_anomalies_remote_hosts"] = "Remote Hosts Anomalies",
    ["traffic_report"] = "Traffic Report",
    ["unable_to_open"] = "Unable to open report (not found)",
    ["use_server_timezone"] = "Use Server Timezone",
  },
  ["rest_consts"] = {
    ["ADD_POOL_FAILED"] = "Unable to add a pool with the submitted params",
    ["ADD_POOL_FAILED_TOO_MANY_POOLS"] = "Too many pools created. Consider upgrading ntopng to Enterprise M or above to create additional pools.",
    ["ADD_POOL_FAILED_TOO_MANY_POOLS_ENTERPRISE"] = "Too many pools created.",
    ["BAD_CONTENT"] = "Bad content",
    ["BAD_FORMAT"] = "Bad format",
    ["BIND_POOL_MEMBER_ALREADY_BOUND"] = "Unable to bind member which is already bound to another pool",
    ["BIND_POOL_MEMBER_FAILED"] = "Unable to bind the sumbitted member to the pool",
    ["CONFIGURATION_FILE_MISMATCH"] = "The uploaded file is not a valid configuration file!",
    ["DELETE_POOL_FAILED"] = "Unable to delete a pool with the submitted params",
    ["DHCP_ACTIVE_LEASES_NOT_NEDGE"] = "Build is not nEdge.",
    ["DHCP_ACTIVE_LEASES_NOT_ROUTING_MODE"] = "Listing DHCP leases is only available in routing mode.",
    ["EDIT_POOL_FAILED"] = "Unable to edit a pool with the submitted params",
    ["INFRASTRUCTURE_INSTANCE_ALREADY_EXISTING"] = "Duplicated instance.",
    ["INFRASTRUCTURE_INSTANCE_CHECK_AUTH_FAILED"] = "Authorization failed. Invalid token",
    ["INFRASTRUCTURE_INSTANCE_CHECK_FAILED"] = "Unable to perform the request. Destination unreachable.",
    ["INFRASTRUCTURE_INSTANCE_CHECK_INVALID_RESPONSE"] = "Invalid response received. Expected JSON",
    ["INFRASTRUCTURE_INSTANCE_CHECK_NOT_FOUND"] = "Not found",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_ALIAS"] = "The name of the instance cannot be empty.",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_BANDWIDTH_THRESHOLD"] = "The bandwidth threshold cannot be empty!",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_ID"] = "The ID of the instance cannot be empty.",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_RTT_THRESHOLD"] = "The RTT threshold cannot be empty!",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_TOKEN"] = "The token of the instance cannot be empty.",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_URL"] = "An URL of the instance must be defined.",
    ["INFRASTRUCTURE_INSTANCE_SAME_ALIAS"] = "An instance with this alias already exists.",
    ["INFRASTRUCTURE_INSTANCE_SAME_TOKEN"] = "An instance is already bound with this token.",
    ["INFRASTRUCTURE_INSTANCE_SAME_URL"] = "An instance with this URL is already defined",
    ["INTERNAL_ERROR"] = "Internal error",
    ["INVALID_ARGUMENTS"] = "Invalid arguments",
    ["INVALID_HOST"] = "Invalid host",
    ["INVALID_INTERFACE"] = "Invalid interface",
    ["MAX_SNMP_DEVICES_NUM_REACHED"] = "Reached the maximum limit of configurable devices",
    ["NAME_RESOLUTION_FAILED"] = "Unable to resolve host name to an IP address",
    ["NOT_FOUND"] = "Not found",
    ["NOT_GRANTED"] = "Not authorized",
    ["NO_SNMP_DEVICE_DISCOVERED"] = "No SNMP device discovered",
    ["OK"] = "Success",
    ["PARTIAL_IMPORT"] = "The configuration has been imported successfully, but some elements were already present and haven't be replaced.",
    ["POOL_ADDED_SUCCESSFULLY"] = "Pool added successfully",
    ["POOL_DELETED_SUCCESSFULLY"] = "Pool deleted successfully",
    ["POOL_EDITED_SUCCESSFULLY"] = "Pool edited successfully",
    ["POOL_MEMBER_BOUND_SUCCESSFULLY"] = "Pool member bound successfully",
    ["POOL_NOT_FOUND"] = "Pool not found",
    ["SNMP_DEVICE_ADDED_SUCCESSFULLY"] = "SNMP device added successfully",
    ["SNMP_DEVICE_ALREADY_ADDED"] = "SNMP device already added",
    ["SNMP_DEVICE_DELETED_SUCCESSFULLY"] = "SNMP device deleted successfully",
    ["SNMP_DEVICE_EDITED_SUCCESSFULLY"] = "SNMP device edited successfully",
    ["SNMP_DEVICE_INTERFACE_STATUS_CHANGE_FAILED"] = "SNMP device interface status change has failed",
    ["SNMP_DEVICE_UNREACHABLE"] = "No answer from the SNMP device",
    ["WIDGETS_MISSING_DATASOURCES"] = "Missing datasources",
    ["WIDGETS_MISSING_DATASOURCE_PARAMS"] = "Missing datasource params",
    ["WIDGETS_MISSING_DATASOURCE_TYPE"] = "Missing datasource type",
    ["WIDGETS_MISSING_TRANSFORMATION"] = "Missing transformation",
    ["WIDGETS_UNKNOWN_DATASOURCE_TYPE"] = "Unknown datasource type",
  },
  ["restart"] = {
    ["confirm"] = "Do you want to restart %{product} now?",
    ["just_started"] = "Starting up. Traffic statistics will be first computed in <span>%{when}</span>  <a target='_blank' href='%{url}'><i class='fas fa-info-circle'></i></a>.",
    ["restart"] = "Restart",
    ["restart_now"] = "Restart now",
    ["restart_product"] = "Restart %{product}",
    ["restart_required"] = "Restart Required",
    ["restarting"] = "Restarting %{product}... (this should take a few seconds)",
  },
  ["rtp"] = {
    ["audio"] = "Audio Stream",
    ["audio_video"] = "Multimedia Stream",
    ["screen_share"] = "Screen Sharing Stream",
    ["video"] = "Video Stream",
  },
  ["scripts_list"] = {
    ["alert_severity"] = "Alert Severity",
    ["all"] = "All",
    ["are_you_sure"] = "Your edits are not saved yet! Do you really want to close this dialog?",
    ["attention"] = "Attention",
    ["back_scripts_page"] = "Back to Scripts",
    ["blacklisted_country"] = "Please write country code values separated by comma. (i.e.: IT,FR,DE,UK)",
    ["config"] = "Config",
    ["exclusion_list"] = "Comma separated list of IP addresses. This alert won't be triggered for hosts inside this list.",
    ["exclusion_list_title"] = "Excluded Hosts",
    ["filter_dropdown"] = "Filter Categories",
    ["items_list_comma"] = "Special characters are not allowed except for ,",
    ["missing_configset"] = "The requested config set was not found!",
    ["note_packet_interface"] = "Check available for packet interfaces",
    ["note_zmq_interface"] = "Check available for ZMQ interfaces",
    ["previous_page"] = "Click here to return to the previous page!",
    ["reset_default"] = "Reset to Factory Value",
    ["script_search"] = "Search Script:",
    ["scripts_x"] = "Scripts %{subdir} - %{config}",
    ["select_operator"] = "Please select an operator!",
    ["template_not_found"] = "The template was not found!",
    ["actions"] = {
      ["edit"] = "Edit",
      ["edit_script"] = "Edit Script",
      ["view"] = "View",
      ["view_src_script"] = "View Source Script",
    },
    ["templates"] = {
      ["blacklisted_country_list"] = "Blacklisted Countries list",
      ["elephant_flows_l2r"] = "Elephant Flows Threshold (Local To Remote)",
      ["elephant_flows_r2l"] = "Elephant Flows Threshold (Remote To Local)",
      ["excluded_applications"] = "Excluded applications and categories",
      ["flow_duration_threshold"] = "Flow Duration Threshold",
      ["template_not_implemented"] = "The template  was not implemented yet!",
    },
  },
  ["scripts_overview"] = {
    ["action_view"] = "Open the user script source in the code editor",
    ["alert_key"] = "Alert Key",
    ["alert_key_string"] = "Alert Key String",
    ["alert_name"] = "Alert Name",
    ["edition_only"] = "%{edition} Only",
    ["filtered"] = "Filtered",
    ["filters"] = "Filters",
    ["has_attacker"] = "Known Attacker",
    ["has_victim"] = "Known Victim",
    ["hooks"] = "Hooks",
    ["loaded_scripts"] = "Loaded Scripts",
    ["reload_scripts"] = "Reload Scripts",
    ["script"] = "Script",
    ["source_location"] = "Source Location",
    ["status_key"] = "Flow Status Key",
    ["total_elapsed_time"] = "Tot Exec Time",
    ["type"] = "Type",
  },
  ["severity_groups"] = {
    ["group_critical"] = "Critical",
    ["group_emergency"] = "Emergency",
    ["group_error"] = "Error",
    ["group_none"] = "None",
    ["group_notice_or_lower"] = "Notice or Lower",
    ["group_warning"] = "Warning",
  },
  ["sflows_stats"] = {
    ["active_flows"] = "Live Flows",
    ["client_peer"] = "Client Peer",
    ["client_process"] = "Client Process",
    ["server_peer"] = "Server Peer",
    ["server_process"] = "Server Process",
    ["total_bytes"] = "Total Bytes",
  },
  ["shaping"] = {
    ["applied_to"] = "Applied to",
    ["bandwidth_manager"] = "Bandwidth Manager",
    ["confirm_delete_all_policies"] = "Do you really want ot delete all the \"%{pool_name}\" pool policies",
    ["confirm_delete_policy"] = "Do you really want to delete",
    ["confirm_delete_shaper"] = "Do you really want to delete shaper ",
    ["daily_time"] = "Time (Current / Quota)",
    ["daily_time_quota"] = "Daily Time Quota",
    ["daily_traffic"] = "Traffic (Current / Quota)",
    ["daily_traffic_quota"] = "Daily Traffic Quota",
    ["delete_all_policies"] = "Delete all Policies",
    ["delete_policy"] = "Delete Policy",
    ["delete_shaper"] = "Delete Shaper",
    ["for_dropping_all_traffic"] = "for dropping all traffic",
    ["for_no_shaping"] = "for no shaping",
    ["initial_clone_protocols"] = "Initial application rules will be cloned",
    ["initial_empty_protocols"] = "Initial applications rules will be empty",
    ["manage_policies"] = "Manage Policies",
    ["monthly_time_quota"] = "Monthly Time Quota",
    ["monthly_traffic_quota"] = "Monthly Traffic Quota",
    ["no_quota_applied"] = "No Quota",
    ["no_quota_data"] = "No quota set",
    ["no_quota_traffic"] = "No quota related traffic so far",
    ["no_shapers_available"] = "No shapers available",
    ["note_default_pool_config"] = "Policies and quotas only apply to user-defined host pools. Select a different pool or create a new one <a href='%{url}'>here</a>.",
    ["note_drop_core"] = "Dropping some core protocols can have side effects on other protocols. For instance if you block DNS,<br>symbolic host names are no longer resolved, and thus only communication with numeric IPs work.",
    ["note_quota_unlimited"] = "Set Traffic and Time Quota to 0 for unlimited traffic.",
    ["note_target_type"] = "You can modify what to show into the Target column via the Policy Target Type field in the <a href=\"%{url}\">Traffic Bridging preferences</a> expert view.",
    ["note_traffic_categories"] = "You can configure the Categories from the <a href=\"%{url}\">applications page</a>.",
    ["notes"] = "NOTES",
    ["policy_from_pool"] = "policy from pool",
    ["protocol_families"] = "Application Families",
    ["protocol_policy"] = "Traffic Policy",
    ["protocols"] = "Applications",
    ["protocols_policies"] = "Applications Policies",
    ["see_quotas_here"] = "Visit the host pool <a href='%{url}'>quotas page</a> for the full overview of the active host pool quotas.",
    ["select_to_clone"] = "Select an existing network to clone the application rules from",
    ["set_max_rate_to"] = "Set max rate to",
    ["shaper0_message"] = "Shaper 0 is the default shaper used for local hosts that have no shaper defined",
    ["shaper_id"] = "Shaper Id",
    ["shapers_in_use_message"] = "Shapers can be deleted only if they are not applied to any network",
    ["traffic_from"] = "Traffic from",
    ["traffic_to"] = "Traffic to",
    ["weekly_time_quota"] = "Weekly Time Quota",
    ["weekly_traffic_quota"] = "Weekly Traffic Quota",
  },
  ["show_alerts"] = {
    ["1_day"] = "1 Day",
    ["1_hour"] = "1 Hour",
    ["1_month"] = "1 Month",
    ["1_week"] = "1 Week",
    ["1_year"] = "1 Year",
    ["30_min"] = "30 Minutes",
    ["5_min"] = "5 Minutes",
    ["6_months"] = "6 Months",
    ["acknowledge_alert"] = "Acknowledge Alert",
    ["acknowledged"] = "Acknowledged",
    ["add_a_comment"] = "Comment",
    ["alarmable"] = "Alarmable",
    ["alert_actions"] = "Actions",
    ["alert_count"] = "Count",
    ["alert_counts"] = "Counts",
    ["alert_datetime"] = "Date/Time",
    ["alert_description"] = "Description",
    ["alert_duration"] = "Duration",
    ["alert_family"] = "Family",
    ["alert_severity"] = "Severity",
    ["alert_severity_and_type"] = "Severity and Type",
    ["alert_type"] = "Alert Type",
    ["alerts"] = "Alerts",
    ["alerts_are_disabled_message"] = "Alerts are disabled. Please check the preferences page to enable them.",
    ["alerts_info"] = "An alert is <i>Engaged</i> when it is currently active (triggered and not yet released). Alerts that <i>Require Attention</i> should be manually analysed and then acknowledged using the Actions menu. All alerts, both those requiring attention and those acknowledged (manually or by the system) are present in the <i>All</i> box.",
    ["alerts_queries"] = "Alerts Queries",
    ["alerts_to_purge"] = "Alerts to Purge",
    ["alerts_to_purge_x"] = "%{filter} alert(s) to purge",
    ["cli_country"] = "Client Country",
    ["confirm_acknowledge_alert"] = "Do you really want to acknowledge the specified alert?",
    ["confirm_acknowledge_alerts"] = "Stored alerts matching the specified criteria will be acknowledged. Continue?",
    ["confirm_delete_alert"] = "Do you really want to delete the specified alert",
    ["confirm_delete_alerts"] = "Stored alerts matching the specified criteria will be deleted. Continue?",
    ["confirm_delete_filtered_alerts"] = "Stored alerts matching the specified disable criteria be deleted.",
    ["confirm_external_link"] = "You are being redirected to: ",
    ["confirm_filter_alert"] = "Checks matching the specified exclusion criteria will not be run and alerts will not be triggered.",
    ["confirm_label_alert"] = "Do you really want to label the specified alert?",
    ["confirm_label_alerts"] = "Stored alerts matching the specified criteria will be labelled. Continue?",
    ["confirm_release_alert"] = "Do you really want to release the specified alert?",
    ["daily"] = "Daily",
    ["delete_alert"] = "Delete Alert",
    ["delete_alerts_configuration"] = "Delete Configuration",
    ["delete_all"] = "Delete All",
    ["delete_config_btn"] = "Delete %{conf}s Common Configuration",
    ["delete_config_message"] = "Do you really want to delete the common %{granularity} configuration of %{conf}s",
    ["detected_alerts"] = "Detected Alerts",
    ["disable_alerts"] = "Disable",
    ["disable_alerts_message"] = "Do you really want to disable \"%{type}\" alerts on %{entity_value}?",
    ["disable_alerts_title"] = "Exclude Checks",
    ["disabled_alerts"] = "Disabled Alerts",
    ["disabled_alerts_not_available"] = "This feature is only available on ntopng Pro or above.",
    ["download_alerts"] = "Download Alerts",
    ["dropped_alerts"] = "Dropped Alerts",
    ["enable_alerts"] = "Enable",
    ["enable_alerts_message"] = "Do you really want to enable \"%{type}\" alerts on %{entity_value}?",
    ["enable_alerts_title"] = "Enable Alerts",
    ["engaged"] = "Engaged",
    ["engaged_alerts"] = "Engaged Alerts",
    ["engaged_notes"] = "Badges in the tab name indicate the number of engaged alerts for the corresponding alert family. This is the total number of engaged alerts, regardless of what is actually displayed in the table (data is filtered based on the selected time interval).",
    ["exclude_alert_err"] = "Error while excluding the alert, check the parameters and try again",
    ["expand_action"] = "Expand",
    ["explorer"] = "Explore",
    ["filter_alert"] = "Exclude Checks",
    ["filter_disable_check"] = "Any host (disable check)",
    ["filters"] = "Filters",
    ["five_minutes"] = "Five minutes",
    ["flow_alerts"] = "Flow Alerts",
    ["flow_checks_drops_descr"] = "Trigger an alert when some <a href='%{url}'>Flows checks</a> are not executed.",
    ["flow_checks_drops_title"] = "Flows Checks Drops Alert",
    ["flush_data"] = "Flush Data",
    ["host_delete_config_btn"] = "Delete Host %{host} Configuration",
    ["host_delete_config_confirm"] = "Do you really want to delete the %{granularity} configuration for host",
    ["host_pool_rule_threshold_cross"] = "Threshold Crossed",
    ["host_rules_percentage"] = "Symbol '>' means a positive percentage threshold, otherwise '<' means a negative percentage threshold.",
    ["host_rules_percentage_absolute"] = "The threshold value must be: 0 <= threshold <= 100.",
    ["hourly"] = "Hourly",
    ["ids_ips_log"] = "Intrusion Detection and Prevention Log",
    ["ids_ips_log_descr"] = "Logs intrusion detection and prevention events, such as when an host has been added to (or removed from) the jailed hosts pool. Logged events are stored as alerts under system interface alerts.",
    ["iface_delete_config_btn"] = "Delete Interface %{iface} Configuration",
    ["iface_delete_config_confirm"] = "Do you really want to delete the %{granularity} configuration for interface",
    ["iface_engaged_dropped_alerts"] = "Engaged vs Dropped alerts",
    ["in_the_selected_time_frame"] = "in the selected time period",
    ["interface_drops_threshold"] = "Interface Packets Drops",
    ["interface_drops_threshold_descr"] = "The maximum percentage of dropped packets over the total number of interface observed packets",
    ["label_alert"] = "Label Alert",
    ["last_day"] = "Last Day",
    ["last_hour"] = "Last Hour",
    ["last_minute"] = "Last Minute",
    ["last_week"] = "Last Week",
    ["minute"] = "Minute",
    ["network_delete_config_btn"] = "Delete Network %{network} Configuration",
    ["network_delete_config_confirm"] = "Do you really want to delete the %{granularity} configuration for network",
    ["network_interface_rule_threshold_cross"] = "Threshold Crossed",
    ["network_rule_threshold_crossed"] = "Threshold Crossed",
    ["no_recorded_alerts_message"] = "No recorded alerts",
    ["num_ignored_alerts"] = "Ignored Alerts",
    ["older_1_day_ago"] = " older than 1 day ago",
    ["older_1_hour_ago"] = "older than 1 hour ago",
    ["older_1_month_ago"] = "older than 1 month ago",
    ["older_1_week_ago"] = "older than 1 week ago",
    ["older_1_year_ago"] = "older than 1 year ago",
    ["older_30_minutes_ago"] = "older than 30 minutes ago",
    ["older_5_minutes_ago"] = "older than 5 minutes ago",
    ["older_6_months_ago"] = "older than 6 months ago",
    ["older_than"] = "older than",
    ["older_then_a_week"] = "Older",
    ["past"] = "Past",
    ["past_alerts"] = "Past Alerts",
    ["past_flow"] = "Past Flow",
    ["purge_all_alerts"] = "Purge All Alerts",
    ["purge_num_alerts"] = "Purge [%{num_alerts} alerts]",
    ["purge_subj_alerts"] = "Purge %{subj} Alerts",
    ["purge_subj_alerts_confirm"] = "Do you really want to purge all the %{subj} alerts?",
    ["release_alert"] = "Release Alert",
    ["release_alert_action"] = "Release",
    ["remove_filters"] = "Remove Filters",
    ["reset_alert_database"] = "Flush Alerts Data",
    ["reset_alert_database_message"] = "This action will remove any alerts related data, including<ul><li>Runtime alerts status</li><li>Persistent alerts SQLite storage</li></ul>Please go to the Checks settings if you want to reset also the alerts configuration.<br><br>Do you really want to proceed",
    ["short_ack"] = "Ack",
    ["srv_country"] = "Server Country",
    ["startup"] = "Startup",
    ["stored_alerts"] = "Stored Alerts",
    ["trigger_alert_descr"] = "Enable alerts triggering on this alarmable",
    ["trigger_host_alert_descr"] = "Trigger alerts generated by %{host}",
    ["trigger_iface_alert_descr"] = "Trigger alerts generated by %{iface}",
    ["trigger_network_alert_descr"] = "Trigger alerts generated by %{network}",
    ["presets"] = {
      ["10_min"] = "Last 10 Mins",
      ["12_hours"] = "Last 12 Hours",
      ["2_hours"] = "Last 2 Hours",
      ["30_min"] = "Last 30 Mins",
      ["5_min"] = "Last 5 Mins",
      ["6_hours"] = "Last 6 Hours",
      ["all"] = "All Time",
      ["custom"] = "Custom",
      ["day"] = "Last Day",
      ["hour"] = "Last Hour",
      ["month"] = "Last Month",
      ["presets"] = "Presets",
      ["week"] = "Last Week",
      ["year"] = "Last Year",
    },
  },
  ["sites_page"] = {
    ["contacts"] = "Contacts",
    ["current_sites"] = "Current Sites",
    ["last_5_minutes_sites"] = "Last 5 Minute Sites",
    ["sites"] = "Sites",
    ["time_range"] = "Time Range:",
    ["top_sites_not_enabled_message"] = "To keep track of visited sites, enable the creation of top visited web sites for local hosts from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>.",
    ["top_sites_not_seen"] = "Current local host has not visited any website yet.",
    ["top_visited_sites"] = "Top Visited Sites",
  },
  ["snapshots"] = {
    ["add"] = "Add Snapshot",
    ["apply"] = "Apply Snapshot",
    ["apply_time"] = "Apply current time interval %begin_time - %end_time",
    ["date"] = "Snapshot Date",
    ["delete"] = "Delete Snapshot",
    ["delete_all"] = "Delete All Snapshots",
    ["manage"] = "Manage Snapshots",
    ["name"] = "Name",
    ["order_by"] = "Order By",
    ["save_time"] = "Save time interval %begin_time - %end_time",
    ["select"] = "Select Snapshot",
  },
  ["snmp"] = {
    ["AlertDescription"] = "Alert Description",
    ["ConsoleDisplayBufferText"] = "Display Text",
    ["GeneralSerialNumber"] = "Serial Number",
    ["InputCurrentLevel"] = "Current Level",
    ["InputDimUnit"] = "Dim Unit",
    ["InputMaxCapacity"] = "Max Capacity",
    ["InputMediaDimFeedDirDeclared"] = "InputMediaDimFeedDirDeclared",
    ["InputMediaDimXFeedDirDeclared"] = "InputMediaDimXFeedDirDeclared",
    ["InputName"] = "InputName",
    ["MarkerColorantValue"] = "Marker Colorant",
    ["MarkerLifeCount"] = "Marker Life Count",
    ["MarkerSuppliesDescription"] = "Marker Supplies Description",
    ["MarkerSuppliesLevel"] = "Marker Supplies Level",
    ["MarkerSuppliesMaxCapacity"] = "Marker Supplies Max Capacity",
    ["PrinterCurrentStatus"] = "Current Status",
    ["PrinterOperationalStatus"] = "Operational Status",
    ["absolute_stats"] = "Stats Since Boot",
    ["actual_stats"] = "Stats Since Last Poll",
    ["add_device"] = "Add",
    ["add_devices"] = "Add Devices",
    ["add_snmp_devices"] = "Add SNMP Device(s)",
    ["alert_topology"] = "There are no nodes to show!",
    ["alerted_interfaces"] = "Interfaces With Errors",
    ["all_interfaces"] = "All Interfaces",
    ["all_snmp_interface_types"] = "All Types",
    ["all_snmp_statuses"] = "All Statuses",
    ["and_one_more_interface"] = "and <a href='%{url}'>1 more interface</a>",
    ["authentication_passphrase"] = "Authentication PassPhrase",
    ["authentication_protocol"] = "Authentication Protocol",
    ["average_downlink"] = "Average Downlink (In)",
    ["average_uplink"] = "Average Uplink (Out)",
    ["bound_interface_description"] = "Binding a network interface to an SNMP interface is useful to compare network traffic monitored by ntopng with that reported by SNMP",
    ["caching_in_progress"] = "Device SNMP walk in progress. This may take up to 5 minutes. The page will refresh periodically.",
    ["cdp"] = "CDP",
    ["chart_congestion_configuration"] = "The usage of an Interface is based on the Traffic captured by SNMP and Interface Speed configured (by default the one seen by SNMP), to change the Interface Speed click on the Actions (table) -> Configuration",
    ["chart_congestion_link"] = "By clicking on a bar of the chart or by clicking on the Actions (table) -> Timeseries, a user can jump directly to the interested Timeseries",
    ["chart_congestion_rate_color"] = "Each bar in the chart can have 4 different colors: <br><div class='d-inline-flex justify-content' style='background-color: rgb(144, 238, 144); height: 8px; width: 8px;'></div>: Congestion rate between 0 and 24<br><div class='d-inline-flex justify-content' style='background-color: rgb(25, 135, 84); height: 8px; width: 8px;'></div>: Congestion rate between 25 and 49<br><div class='d-inline-flex justify-content' style='background-color: rgb(255, 193, 7); height: 8px; width: 8px;'></div>: Congestion rate between 50 and 74<br><div class='d-inline-flex justify-content' style='background-color: rgb(220, 53, 69); height: 8px; width: 8px;'></div>: Congestion rate between 75 and 100",
    ["chart_congestion_rate_note"] = "The chart shows the congestion rate of the various Interfaces (In and Out separated). Calculated by dividing the number of points with usage higher or equal than 75% and the number of total points",
    ["contact"] = "Contact",
    ["cpuIdle"] = "CPU Idle",
    ["cpuSystem"] = "CPU System",
    ["cpuUser"] = "CPU User",
    ["delete_all_devices"] = "Delete All",
    ["delete_unresponsive_devices"] = "Delete Unresponsive",
    ["device_example"] = "Example: %{example}",
    ["device_ip"] = "Device IP",
    ["device_model"] = "Device Model",
    ["device_name"] = "Device Name",
    ["device_polling"] = "Device Polling",
    ["device_polling_desc"] = "Perform periodic SNMP walks to collect device data, including device interfaces traffic and status.",
    ["device_responsiveness"] = "Device Filter",
    ["device_status"] = "Device Status",
    ["devices_added"] = "Device(s) Added",
    ["disable_port_monitor"] = "Disable Port Monitor",
    ["discover_devices"] = "Discover Devices",
    ["edit_device"] = "Edit",
    ["edit_snmp_devices"] = "Edit SNMP Device",
    ["enable_port_monitor"] = "Enable Port Monitor",
    ["errors_filter"] = "Errors Filter",
    ["export_devices"] = "Export SNMP Device(s)",
    ["ifName"] = "Name",
    ["ifindex"] = "Interface Index",
    ["import_devices"] = "Import SNMP Device(s)",
    ["in_bytes"] = "In Bytes",
    ["in_discards"] = "In Discards",
    ["in_errors"] = "In Errors",
    ["interface"] = "Interface",
    ["interface_alias"] = "Alias",
    ["interface_device"] = "Interface %{interface} [ %{device} ]",
    ["interface_device_2"] = "%{interface}",
    ["interface_similarity"] = "Interface Similarity",
    ["interfaces_with_discards"] = "Interfaces With Discards",
    ["interfaces_with_errors"] = "Interfaces With Errors",
    ["interfaces_with_errors_or_discards"] = "Interfaces With Errors/Discards",
    ["last_change"] = "Last Change",
    ["last_value_downlink"] = "Last Value Downlink (In)",
    ["last_value_uplink"] = "Last Value Uplink (Out)",
    ["lldp"] = "LLDP",
    ["lldpRemChassisId"] = "Remote Device",
    ["lldpRemPortDesc"] = "Remote Port Descr.",
    ["lldpRemPortId"] = "Remote Port ID",
    ["lldpRemSysDesc"] = "Remote System Descr.",
    ["lldpRemSysName"] = "Remote System",
    ["lldp_topology_changed"] = "LLDP/CDP Topology changed",
    ["lldp_topology_changed_description"] = "Detects changes in the SNMP network topology and triggers alerts",
    ["lldp_topology_changed_title"] = "LLDP/CDP Topology Monitor",
    ["low_port_speed"] = "Low port speed",
    ["max_downlink"] = "Max Downlink (In)",
    ["max_uplink"] = "Max Uplink (Out)",
    ["memAvailReal"] = "Available Memory",
    ["memTotalReal"] = "Total Memory",
    ["memTotalSwap"] = "Total Swap",
    ["min_downlink"] = "Min Downlink (In)",
    ["min_uplink"] = "Min Uplink (Out)",
    ["multiple_macs_non_trunk"] = "Multiple MACs on non-trunk port",
    ["no_answer"] = "No answer from host %{host}: please check that SNMP is up and the community is set to the correct value",
    ["no_host_discovered"] = "No host discovered in %{host}/%{cidr}",
    ["no_polling_yet"] = "Never polled",
    ["none"] = "None",
    ["note"] = "NOTE",
    ["object_id"] = "ObjectID",
    ["out_bytes"] = "Out Bytes",
    ["per_interface_settings"] = "These settings only affect interface \"%{iface}\". Check out <a href=\"%{url}\">%{global}</a> for a global configuration.",
    ["ping_all_snmp_devices"] = "Ping All SNMP Devices",
    ["ping_all_snmp_devices_confirm"] = "Do you really want to ping all the SNMP devices?",
    ["ping_devices"] = "Ping Devices",
    ["port_macs"] = "MAC Addresses",
    ["port_macs_short"] = "MACs",
    ["printer"] = "Printer",
    ["privacy_passphrase"] = "Privacy PassPhrase",
    ["privacy_protocol"] = "Privacy Protocol",
    ["prune_unresponsive_snmp_devices"] = "Remove Unresponsive SNMP Devices",
    ["prune_unresponsive_snmp_devices_confirm"] = "Do you really want to delete all unresponsive SNMP devices?",
    ["qos"] = "QoS",
    ["remove_all_snmp_devices"] = "Remove All SNMP Devices",
    ["remove_all_snmp_devices_confirm"] = "Do you really want to delete all the SNMP devices?",
    ["remove_snmp_device"] = "Remove SNMP Device",
    ["remove_snmp_device_confirm"] = "Do you really want to delete the SNMP device",
    ["responsiveness_all"] = "All Devices",
    ["responsiveness_responsive"] = "Responsive Devices",
    ["responsiveness_unresponsive"] = "Unresponsive Devices",
    ["select_pool"] = "Select a pool",
    ["similarity"] = "Similarity Score",
    ["snmp_all_interfaces"] = "All Interfaces",
    ["snmp_also_seen_on"] = "Also seen on",
    ["snmp_and_n_more_interfaces"] = "and <a href='%{url}'>%{count} more interfaces</a>",
    ["snmp_authnopriv"] = "Auth. w/o Privacy",
    ["snmp_authpriv"] = "Auth. with Privacy",
    ["snmp_avg_traffic"] = "Average Traffic",
    ["snmp_community"] = "Community",
    ["snmp_device"] = "SNMP Device",
    ["snmp_device_does_not_respond"] = "The SNMP device is unresponsive.",
    ["snmp_device_last_poll"] = "Time Since Last Poll",
    ["snmp_device_last_poll_duration"] = "Last Poll Duration",
    ["snmp_device_polling_disabled"] = "Periodic device polling is disabled. Information shown may be missing or outdated. Polling can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>.",
    ["snmp_device_x"] = "%{device} (%{ip})",
    ["snmp_devices"] = "SNMP Devices",
    ["snmp_devices_rules"] = "Rules",
    ["snmp_devices_rules_active_alert_warning"] = "The SNMP Threshold Crossed alert must be enabled to receive alerts on rules not respected.",
    ["snmp_error_unable_to_set_interface_admin_status"] = "Unable to toggle the admin status. Make sure the SNMP device has a (valid) write community configured.",
    ["snmp_host"] = "Host",
    ["snmp_import_devices"] = "Check the <a href='https://www.ntop.org/guides/ntopng/snmp/configuration.html#snmp-import-file'>documentation</a> regarding the CSV / JSON format ",
    ["snmp_import_devices_issues"] = "In case the format is not respected, unknown issue could arise",
    ["snmp_interface"] = "SNMP Interface",
    ["snmp_interface_type"] = "Interface Type",
    ["snmp_interface_x"] = "Interface %{interface}",
    ["snmp_interfaces"] = "Interfaces",
    ["snmp_last_poll_errors"] = "Interfaces with Errors (lLast Poll)",
    ["snmp_level"] = "Security Level",
    ["snmp_lldp_cdp_descr"] = "Device topology information is available when the <A HREF=\"https://en.wikipedia.org/wiki/Link_Layer_Discovery_Protocol\">LLDP</A> / <A HREF=\"https://en.wikipedia.org/wiki/Cisco_Discovery_Protocol\">CDP</A> MIB is present on the monitored device.",
    ["snmp_lldp_cdp_no_node"] = "The selected node has not been polled via SNMP",
    ["snmp_lldp_cdp_node_color"] = "The node color represents the status of the interface.<br><ul><li><span style='color:green'>Up</span></li><li><span style='color:red'>Down</span></li><li><span style='color:blue'>Up in use</span></li><li><span style='color:#495057'>Unknown</span></li>",
    ["snmp_lldp_cdp_zoom_descr"] = "Click on a node to explore the device, use the mouse wheel to zoom, drag clicking on an empty area.",
    ["snmp_monitor_disable_confirm"] = "Do you really want to disable port status monitoring on SNMP device %{device}?",
    ["snmp_monitor_enable_confirm"] = "Do you really want to enable port status monitoring on SNMP device %{device}? Alerts will be generated whenever a port changes state.",
    ["snmp_netsnmp"] = "CPU/Memory",
    ["snmp_noauthnopriv"] = "None",
    ["snmp_note_avg_usage"] = "The Avg In/Out Usage is a percentage calculated as the average of in/out traffic relative to the downlink/uplink speed of the interface.",
    ["snmp_note_bridge_mib"] = "Periodic SNMP walks on the Bridge MIB are performed to populate the table.",
    ["snmp_note_bridge_mib_status"] = "Shown status is the dot1qTpFdbStatus Bridge MIB status associated to the MAC address.",
    ["snmp_note_periodic_interfaces_polling"] = "Periodic SNMP walks are performed to update interfaces at regular 5-minute intervals.",
    ["snmp_note_thpt_calc"] = "The throughput accounts for the total traffic (in + out) over the two most recent consecutive SNMP walks.",
    ["snmp_note_thpt_span"] = "The two most recent consecutive SNMP walks were perfrormed at %{last} and %{prev}.",
    ["snmp_pool"] = "Pool",
    ["snmp_port_monitor"] = "SNMP Port Monitor",
    ["snmp_printer"] = "Printer",
    ["snmp_qos_info_not_polled"] = "QoS MIBs not polled yet...",
    ["snmp_read_community"] = "Read Community",
    ["snmp_similarity_note"] = "The <b>higher</b> is the similarity column value, the <b>more similar</b> are the network interfaces.",
    ["snmp_similarity_time_note"] = "Similarity is based on interface traffic (RX + TX) of the last 24 hours.",
    ["snmp_timeseries_descr"] = "SNMP devices timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fas fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
    ["snmp_topology"] = "Topology",
    ["snmp_username"] = "Username",
    ["snmp_version"] = "Version",
    ["snmp_write_community"] = "Write Community",
    ["stats_since"] = "Stats Since",
    ["status_dormant"] = "Dormant",
    ["status_down"] = "Down",
    ["status_lowerlayerdown"] = "Lower Layer Down",
    ["status_notpresent"] = "Not Present",
    ["status_unknown"] = "Unknown",
    ["status_up"] = "Up",
    ["status_up_in_use"] = "Up (in use)",
    ["testing"] = "Testing",
    ["top"] = "Top",
    ["top_congested_devices"] = "Top Congested Interfaces",
    ["topology_map"] = "Topology Map",
    ["tp_fbd_status_invalid"] = "invalid",
    ["tp_fbd_status_learned"] = "learned",
    ["tp_fbd_status_mgmt"] = "mgmt",
    ["tp_fbd_status_other"] = "other",
    ["tp_fbd_status_self"] = "self",
    ["traffic_similarity"] = "Network Interfaces Traffic Similarity",
    ["trunk"] = "Trunk",
    ["unable_to_delete_snmp_device"] = "Unable to delete SNMP device %{device}",
    ["unresponsive_device"] = "The SNMP walk is too slow. Displayed data may be outdated or missing. Check network connectivity and device responsiveness. A new scan attempt will be performed in 15 minutes.",
    ["view_device"] = "View Device",
    ["descriptions"] = {
      ["add_pool"] = "New SNMP Pool",
      ["authentication_passphrase"] = "SNMPv3 authentication passphrase",
      ["authentication_protocol"] = "SNMPv3 authentication protocol",
      ["host"] = "SNMP agent IP address",
      ["level"] = "SNMPv3 security level",
      ["pool"] = "SNMP Pool to bind",
      ["privacy_passphrase"] = "SNMPv3 encryption passphrase",
      ["privacy_protocol"] = "SNMPv3 encryption protocol",
      ["read_community"] = "SNMP v1/v2c read-only community",
      ["username"] = "SNMPv3 authentication username",
      ["version"] = "SNMP protocol version",
      ["write_community"] = "SNMP v1/v2c write community",
    },
    ["snmp_devices_rules_metrics"] = {
      ["bytes"] = "Bytes (RX + TX)",
      ["errors"] = "Errors (Packets Errors + Discards)",
      ["usage"] = "Usage (RX + TX)",
    },
    ["validation"] = {
      ["abort_add_snmp_devices"] = "Abort add new SNMP Device?",
      ["abort_edit_snmp_devices"] = "Abort edit SNMP Device?",
      ["invalid_host"] = "Please type an IPv4 address, or a IPv6 address.",
      ["read_community_empty"] = "The Read Community cannot be left empty.",
    },
  },
  ["snmp_page"] = {
    ["guide_snmp_page_message"] = "Visit page <a href='%{url}'> SNMP</a> to add this host to the list of configured SNMP devices.",
    ["ip_associated"] = "IP Associated",
    ["multiple_macs"] = "<a href='%{num_mac_href}'>%{mac} and %{num_mac} more macs</a>",
    ["not_configured_as_snmp_device_message"] = "Host %{host_ip} has not been configured as an SNMP device.",
    ["showing_snmp_mib_info_default_community_message"] = "Showing SNMP MIB information retrieved using the default community '%{community}'",
    ["single_mac"] = "<a href='%{num_mac_href}'>%{mac}</a>",
    ["snmp_device_interface_not_found"] = "SNMP device \"%{host}\" interface \"%{iface}\" cannot be found.",
    ["snmp_device_not_found"] = "SNMP device \"%{host}\" cannot be found.",
    ["trying_to_retrive_message"] = "Trying to retrieve host SNMP MIB using the default community '%{community}'",
    ["unable_to_retrive_snmp_default_community_message"] = "Unable to retrieve host SNMP MIB using the default community '%{community}'.",
  },
  ["snmp_ratio_errors"] = {
    ["flowdevice_timeseries_not_existing"] = "Not available.",
    ["flowdevice_timeseries_query_failed"] = "Timeseries unreadable",
    ["nan_ratio"] = "Ratio is not a number.",
    ["negative_ratio"] = "Negative ratio.",
    ["ok"] = "OK",
    ["snmp_timeseries_not_enabled"] = "Timeseries disabled.",
    ["snmp_timeseries_not_existing"] = "Not available.",
    ["snmp_timeseries_query_failed"] = "Timeseries unreadable.",
    ["snmp_timeseries_zero_total"] = "No data.",
    ["timeseries_start_time_mismatch"] = "Timeseries not aligned.",
  },
  ["sonicwall_collector"] = {
    ["description"] = "Collect logs from SonicWALL firewalls: handle Identity Management (user correlation) and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "SonicWALL",
  },
  ["sophos_collector"] = {
    ["description"] = "Collect logs from Sophos firewalls: handle Identity Management (user correlation) and trigger alerts according to the configured severity level (0 for min verbosity, 7 for max).<br />Supported severity levels:<ul><li><b>1</b>: Alert/Emergency</li><li><b>2</b>: Critical</li><li><b>3</b>: Error</li><li><b>4</b>: Warning</li><li><b>5</b>: Notice</li><li><b>6</b>: Info</li><li><b>7</b>: Debug</li></ul>",
    ["title"] = "Sophos",
  },
  ["sprobe_page"] = {
    ["active_memory"] = "Active memory",
    ["latency"] = "Latency",
    ["processes"] = "Processes",
    ["processes_traffic_tree"] = "Processes Traffic Tree",
    ["show_more_info"] = "Mouse over to show the process information or double click to show more information.",
    ["system_interactions"] = "System Interactions",
    ["top_processes"] = "Top Processes",
    ["top_users"] = "Top Users",
    ["tree"] = "Tree",
    ["users"] = "Users",
  },
  ["sub_interfaces"] = {
    ["add_sub_if"] = "Add Sub-Interface",
    ["add_sub_if_success"] = "Sub-Interface created successfully. A restart of ntopng is required for the change to have effect.",
    ["collection_filter_description"] = "NetFlow fields can also be used, including INPUT_SNMP, OUTPUT_SNMP, SRC_VLAN, DST_VLAN. Non-numeric values should be provided with single quotes.",
    ["confirm_delete"] = "Are you sure you want to delete ",
    ["delete"] = "Delete Sub-Interface",
    ["disaggregation"] = "Custom Traffic Disaggregation",
    ["edit_sub_if"] = "Edit Sub-Interface",
    ["edit_sub_if_success"] = "Sub-interface has been edited successfully. A restart of ntopng is required for the change to have effect.",
    ["empty_filter"] = "Filter not specified",
    ["filter_description"] = "An extended nBPF format is supported. In addition to the standard BPF syntax, it is possible to use special keyworks like <i>local</i> and <i>remote</i> (combined with <i>src</i> and <i>dst</i> qualifiers).",
    ["filter_examples"] = "Filter examples",
    ["invalid_name_format"] = "Interface name must contain only letters, numbers, dashes.",
    ["invalid_name_length"] = "Interface name too short (5 or more characters)",
    ["invalid_xnbpf"] = "Invalid nBPF filter",
    ["note"] = "ntopng can use BPF-like filters to disaggregate incoming traffic, diverting it to logical sub-interfaces. The same traffic can be diverted to multiple interfaces in case of overlapping in the filters.",
    ["sub_if_name"] = "Sub-Interface Name",
    ["traffic_filter_nbpf"] = "Traffic Filter (nBPF Format)",
    ["traffic_filter_xnbpf"] = "Traffic Filter (Extended nBPF Format)",
  },
  ["suricata_collector"] = {
    ["description"] = "Collect alerts and metadata from Suricata",
    ["statistics"] = "Suricata Statistics",
    ["title"] = "Suricata",
  },
  ["syslog"] = {
    ["add"] = "Add Log Producer",
    ["bad_action_param"] = "Bad \"action\" paramater",
    ["confirm_delete"] = "Do you really want to remove this producer?",
    ["edit"] = "Edit Log Producer",
    ["empty_action"] = "Something went wrong (empty action). Reload the page and try again.",
    ["host_add_ok"] = "Host %{host} was successfully added !",
    ["host_delete_ok"] = "Host %{host} was successfully deleted !",
    ["host_edit_ok"] = "Host %{host} was successfully edited !",
    ["host_exists"] = "Host \"%{host}\" already exists",
    ["host_not_exists"] = "Host \"%{host}\" not found",
    ["ip_or_device"] = "IP or Device Name",
    ["ip_or_device_note"] = "The Log Producer IP should match the IP or the Device Name as it appears in the syslog message. Example:<br />Thu Apr 10 16:30:00 2020;<strong>10.0.0.1</strong>; <181>Thu Apr 10 16:30:00 <strong>sslvpn-device-01</strong> logserver: ...",
    ["producer_host"] = "Log Producer IP",
    ["producer_type"] = "Log Producer Type",
    ["producers"] = "Syslog Log Producers",
    ["syslog"] = "Syslog",
  },
  ["system_alerts_stats"] = {
    ["internal_alerts_queue"] = "Internal Queue",
    ["notes_enq_deq"] = "'Fill Level' is the fraction of queued alerts, with reference to the queue size. 'Dropped' is the fraction of alerts dropped due to queue full, with reference to the total number of alerts",
    ["notes_internal_alerts_queue"] = "The Internal Queue is used in combination with SQLite to handle alerts generated in the core and show them inside the UI",
    ["queues_status"] = "Fill Level / Dropped",
  },
  ["system_interfaces_stats"] = {
    ["local_hosts"] = "Local Hosts",
    ["remote_hosts"] = "Remote Hosts",
  },
  ["system_stats"] = {
    ["clickhouse_import_queue"] = "Batch Import Queue",
    ["clickhouse_imports"] = "Batch Imports",
    ["clickhouse_last_import_duration"] = "Last import lasted ",
    ["cpu_states_monitor"] = "CPU States Monitor",
    ["cpu_states_monitor_description"] = "Monitors the states of the CPU (e.g., user, system, idle and iowait)",
    ["disk_monitor"] = "Disk Monitor",
    ["disk_monitor_description"] = "Monitors free disk space",
    ["dropped_points"] = "Dropped Points",
    ["export_failures"] = "Failed Exports",
    ["export_retries"] = "Retried Exports",
    ["exported_points"] = "Total Points",
    ["exported_vs_dropped_points"] = "Total vs Dropped Points",
    ["exports"] = "Total Exports",
    ["exports_label"] = "Exports",
    ["health"] = "Health",
    ["high_series_cardinality"] = "An high cardinality can cause database slowdowns",
    ["infludb_retried_vs_failed_exports"] = "Retried/Failed exports",
    ["influxdb_health_green"] = "OK",
    ["influxdb_health_green_descr"] = "Export to InfluxDB is working OK.",
    ["influxdb_health_red"] = "Failing to export",
    ["influxdb_health_red_descr"] = "InfluxDB unreachable or too slow, unable to keep up with it. Dropping points.",
    ["influxdb_health_yellow"] = "Temporarily unable to export",
    ["influxdb_health_yellow_descr"] = "Currently unable to export to InfluxDB. Retry in progress.",
    ["influxdb_note_docs"] = "Documentation with detailed descriptions of all the fields shown is available in the ntopng <a target='_blank' href='%{url}'>User's guide</a>.",
    ["influxdb_storage"] = "Storage (%{dbname})",
    ["last_ip"] = "Last IP",
    ["series_cardinality"] = "Series Cardinality",
    ["short_desc_influxdb_cardinality"] = "An indication of how challenging is for InfluxDB to handle written points.",
    ["short_desc_influxdb_dropped_points"] = "Total number of points dropped due to InfluxDB write failures.",
    ["short_desc_influxdb_exported_points"] = "Total number of points successfully written into InfluxDB.",
    ["short_desc_influxdb_exports"] = "Total number of successful writes into InfluxDB.",
    ["short_desc_influxdb_health"] = "Current InfluxDB export health.",
    ["short_desc_influxdb_ram_memory"] = "Total memory InfluxDB has obtained from the operating system.",
    ["short_desc_influxdb_storage_utilization"] = "Total disk space used by InfluxDB.",
    ["value"] = "Value",
    ["write_througput"] = "Write Througput",
    ["clickhouse"] = {
      ["clickhouse_alert_size"] = "Alert Tables Size",
      ["clickhouse_alerts_number"] = "Alerts",
      ["clickhouse_flow_size"] = "Flows Table Size",
      ["clickhouse_flows_number"] = "Flows",
      ["clickhouse_health_green"] = "OK",
      ["clickhouse_health_green_descr"] = "ClickHouse is working OK.",
      ["clickhouse_health_red"] = "Persistence Issues",
      ["clickhouse_health_red_descr"] = "Unable to query ClickHouse. Expect %{product} to malfunction.",
      ["clickhouse_hourly_flows_number"] = "Hourly Flows",
      ["clickhouse_hourly_flows_size"] = "Hourly Flows Table Size",
      ["clickhouse_monitor"] = "ClickHouse Monitor",
      ["clickhouse_monitor_description"] = "Monitor the ClickHouse health",
      ["clickhouse_records_info"] = "Database Table Records:",
      ["clickhouse_system_errors"] = "Last Errors",
      ["clickhouse_system_errors_no_error"] = "No error detected.",
      ["command_hits"] = "%{cmd} Calls",
      ["commands"] = "Commands",
      ["short_desc_clickhouse_alert_size"] = "Total size of the ClickHouse alert tables.",
      ["short_desc_clickhouse_flows_size"] = "Total size of the ClickHouse flows table.",
      ["short_desc_clickhouse_health"] = "Current ClickHouse health.",
      ["short_desc_clickhouse_import_queue"] = "Number of files waiting to be imported.",
      ["short_desc_clickhouse_imports"] = "Batched flows/alerts imports in ClickHouse.",
      ["short_desc_version"] = "ClickHouse Server Version",
      ["tables_size"] = "Tables Size",
      ["tables_size_descr"] = "Total size of ClickHouse tables",
      ["top_clickhouse_commands"] = "Top Commands Calls",
      ["tot_calls"] = "Total Calls",
      ["version"] = "Version",
    },
    ["redis"] = {
      ["command_hits"] = "%{cmd} Calls",
      ["commands"] = "Commands",
      ["redis_health_green"] = "OK",
      ["redis_health_green_descr"] = "Redis is working OK.",
      ["redis_health_red"] = "Persistence Issues",
      ["redis_health_red_descr"] = "Redis is unable to persist data. Expect %{product} to malfunction.",
      ["redis_keys"] = "Database Keys",
      ["redis_monitor"] = "Redis Monitor",
      ["redis_monitor_description"] = "Monitor the Redis health",
      ["short_desc_redis_health"] = "Current Redis health.",
      ["short_desc_redis_keys"] = "Total keys in the Redis database.",
      ["short_desc_redis_ram_memory"] = "Total memory Redis has obtained from the operating system.",
      ["top_redis_commands"] = "Top Commands Calls",
      ["tot_calls"] = "Total Calls",
    },
  },
  ["table"] = {
    ["autorefresh"] = "Enable table autorefresh each %time seconds",
  },
  ["telemetry_page"] = {
    ["crash_report"] = "Crash Report",
    ["crash_report_descr"] = "A crash report is sent upon %{product} anomalous termination. Crash report contains %{product} information such as version, build architecture, operating system and startup options. Nothing regarding the monitored traffic is ever sent. Following is an example of a crash report:",
    ["last_data_sent"] = "Last Data Sent",
    ["send_telemetry_data"] = "Contribute by sending telemetry data",
    ["telemetry_data"] = "Telemetry Data",
    ["telemetry_data_change_preference"] = "<a href='%{url}'>change</a>",
    ["telemetry_data_no_consent"] = "No preference expressed",
  },
  ["top_host_sites"] = {
    ["0"] = "0:00 - 0:59",
    ["1"] = "1:00 - 1:59",
    ["10"] = "10:00 - 10:59",
    ["11"] = "11:00 - 11:59",
    ["12"] = "12:00 - 12:59",
    ["13"] = "13:00 - 13:59",
    ["14"] = "14:00 - 14:59",
    ["15"] = "15:00 - 15:59",
    ["16"] = "16:00 - 16:59",
    ["17"] = "17:00 - 17:59",
    ["18"] = "18:00 - 18:59",
    ["19"] = "19:00 - 19:59",
    ["2"] = "2:00 - 2:59",
    ["20"] = "20:00 - 20:59",
    ["21"] = "21:00 - 21:59",
    ["22"] = "22:00 - 22:59",
    ["23"] = "23:00 - 23:59",
    ["3"] = "3:00 - 3:59",
    ["4"] = "4:00 - 4:59",
    ["5"] = "5:00 - 5:59",
    ["6"] = "6:00 - 6:59",
    ["7"] = "7:00 - 7:59",
    ["8"] = "8:00 - 8:59",
    ["9"] = "9:00 - 9:59",
    ["current"] = "Current",
    ["day"] = "Previous day",
    ["last_5_min"] = "Last 5 minutes",
    ["note_protocol_used"] = "Application Protocols providing info: HTTP, TLS, QUIC, DNS.",
    ["note_time_range"] = "The Time Range is ordered from the current data to the oldest data known.",
    ["note_tot_entries"] = "Maximum 20 records are provided per host.",
    ["note_yesterday_data"] = "The data are stored at most for 24 hours, meaning that at most you can see yesterday datas. For this reason any hour into the menu that is subsequent to the current time is from yesterday data.",
  },
  ["top_hosts"] = {
    ["note"] = "This page will refresh every few seconds to report top hosts activities.<p>When a host makes traffic a vertical bar is displayed so that you can see the most active hosts.",
    ["top_hosts_local"] = "Top Hosts (Local)",
  },
  ["topk_heuristic"] = {
    ["precision"] = {
      ["aggressive"] = "Aggressive",
      ["disabled"] = "Disabled",
      ["less_accurate"] = "Less Accurate",
      ["more_accurate"] = "More Accurate",
    },
  },
  ["traffic_behaviour"] = {
    ["allowed"] = "Authorized",
    ["denied"] = "Unauthorized",
    ["learning"] = "Learning",
    ["undecided"] = "Undecided",
  },
  ["traffic_labels"] = {
    ["breakdown"] = "Breakdown",
    ["bytes_rcvd"] = "Bytes Received",
    ["bytes_sent"] = "Bytes Sent",
    ["cli2srv_bytes"] = "Cli to Srv Bytes",
    ["srv2cli_bytes"] = "Srv to Cli Bytes",
    ["total_bytes"] = "Total (Bytes)",
    ["total_percentage"] = "Total (%)",
  },
  ["traffic_page"] = {
    ["bytes_rcvd"] = "Bytes Received",
    ["bytes_sent"] = "Bytes Sent",
    ["bytes_sent_vs_rcvd"] = "Bytes Sent VS Rcvd",
    ["contacts"] = "Host Contacts",
    ["flow_distribution"] = "Flow Distribution",
    ["flow_duration"] = "Total Flow Duration",
    ["flow_frequency"] = "New Flow Creation Frequency",
    ["hosts_contacts_cardinality"] = "Total Unique Hosts Contacts",
    ["l4_proto_overview"] = "Protocol Overview",
    ["no_traffic_observed_message"] = "No traffic has been observed for the specified host",
    ["num_contacted_hosts_as_client"] = "Hosts Contacted (as Client)",
    ["num_contacted_hosts_as_server"] = "Hosts Contacts (as Server)",
    ["rcvd"] = "Rcvd",
  },
  ["traffic_profiles"] = {
    ["advanced_filter_examples"] = "Advanced Filters Examples",
    ["all_profiles"] = "All Profiles",
    ["confirm_delete_profile"] = "Do you really want to delete the profile",
    ["delete_profile"] = "Delete Profile",
    ["destination_network"] = "Destination network",
    ["duplicate_profile"] = "Duplicate profile name",
    ["edit_traffic_profiles"] = "Traffic Profiles",
    ["enter_profile_filter"] = "Enter the profile filter",
    ["enter_profile_name"] = "Enter a profile name",
    ["facebook_traffic"] = "Facebook",
    ["host_http_https"] = "Host HTTP/HTTPS",
    ["host_traffic"] = "Host",
    ["http_traffic"] = "HTTP",
    ["invalid_bpf"] = "Invalid BPF filter",
    ["max_profiles_num"] = "With this version of ntopng you can only create %{maxnum} profiles. Upgrade to the Enterprise version to remove this limit",
    ["no_profiles"] = "No profiles set",
    ["note"] = "Note",
    ["note_0"] = "Traffic profile names allow alpha-numeric characters, spaces, and underscores",
    ["note_1"] = "Traffic profiles are applied to flows. Each flow can have up to one profile, thus in case of multiple profile matches, only the first one is selected",
    ["profile_name"] = "Profile Name",
    ["see_ndpi_protos"] = "(both protocol ID and name are supported, use %{option} to print all nDPI supported protocols)",
    ["simple_filter_examples"] = "Simple Filters Examples",
    ["source_ethernet"] = "Source MAC address",
    ["traffic_between"] = "Traffic between hosts",
    ["traffic_filter_bpf"] = "Traffic Filter (nBPF Format)",
    ["traffic_from_to"] = "Traffic from an host to another",
    ["traffic_profiles"] = "Traffic Profiles",
  },
  ["traffic_recording"] = {
    ["about_to_download_flow"] = "About to extract and download a PCAP matching the selected traffic from <b>%{date_begin}</b> to <b>%{date_end}</b>. %{extra_info}",
    ["about_to_download_smart"] = "Traffic will be extracted from the Smart storage, some data may be missing.",
    ["about_to_extract"] = "About to extract traffic from <b>%{date_begin}</b> to <b>%{date_end}</b>",
    ["active_since"] = "Active Since",
    ["archive"] = "Archive",
    ["capture_filter_bpf"] = "Capture Filter",
    ["capture_filter_bpf_note"] = "Capture filters are in nBPF format. Syntax description and examples are available in the <a href=\"https://www.ntop.org/guides/n2disk/filters.html#capture-filters\" target=\"_blank\">n2disk User's Guide</a>.",
    ["completed"] = "Completed",
    ["continuous_recording"] = "Continuous Traffic Recording",
    ["continuous_recording_and_flows"] = "Continuous Traffic Recording and Flow Visibility",
    ["delete_all_jobs"] = "Delete All Jobs",
    ["delete_all_jobs_confirm"] = "Do you really want to delete all the extraction jobs? Active jobs will be stopped.",
    ["delete_job"] = "Delete Job",
    ["delete_job_confirm"] = "Do you really want to delete Job %{job_id} and the related PCAP files?",
    ["disabled"] = "Disabled",
    ["disk_space"] = "Max Disk Space",
    ["disk_space_note"] = "Maximum disk space used for recorded traffic on disk.",
    ["disk_space_note_in_use"] = "%{in_use} GB are already in use by this instance.",
    ["download"] = "Download",
    ["download_nth_pcap"] = "Download PCAP #{0}",
    ["dump_window"] = "Dump Window",
    ["edit_filter"] = "Edit Filter",
    ["err_alloc"] = "memory allocation error",
    ["err_filter"] = "unsupported filter",
    ["err_open"] = "unable to open dump",
    ["err_stuck"] = "stuck or interrupted",
    ["err_unknown"] = "unexpected error",
    ["export_flows"] = "Flow Export",
    ["export_flows_note"] = "Enable flow export while recording raw traffic using n2disk, to have traffic visibility in ntopng (as an alternative to nProbe).",
    ["ext_interface"] = "External Interface",
    ["extract_action"] = "Extract",
    ["extract_now"] = "Extract now",
    ["extracted_bytes"] = "Extracted Bytes",
    ["extracted_packets"] = "Extracted Packets",
    ["extraction_scheduled"] = "A new extraction job has been scheduled, please check the %{page} page to download the PCAP as soon as the file is ready. The job ID for this extraction is ",
    ["failed"] = "Failed",
    ["failure"] = "Failure",
    ["failure_note"] = "Please check the log trace and try restarting the service.",
    ["filter_bpf"] = "Filter (nBPF Format)",
    ["filter_examples"] = "Filter Examples",
    ["global_settings_note"] = "Global settings (e.g. the license key) can be configured from the <a href=\"%{url}\">Traffic Recording preferences</a>.",
    ["invalid_bpf"] = "Invalid filter",
    ["job_date_time"] = "Job Creation Date/Time",
    ["job_id"] = "Job ID",
    ["jobs"] = "Jobs",
    ["logs"] = "Traffic Recording Logs",
    ["max_extracted_pcap_bytes_description"] = "Maximum size for PCAP files extracted from recorded data. In case of extractions exceeding this size, the output will be split into multiple files.",
    ["max_extracted_pcap_bytes_title"] = "Max Extracted File Size",
    ["missing_data_msg"] = "Traffic recording has been stopped or restarted. Some data may be missing.",
    ["missing_parameters"] = "Mandatory parameters are missing",
    ["msg_err_missing_timeline"] = "Unable to determine the timeline of the currently running n2disk. Extractions can only be performed when n2disk is up-to-date and run with option --timeline-dir.",
    ["msg_err_timeline_path_not_existing"] = "Timeline path not found in the system.",
    ["msg_err_unable_to_access_timeline"] = "Unable to read recorded data. Insufficient permissions. Make sure the user running ntopng is in the same group of the user running n2disk.",
    ["msg_err_unknown"] = "Unknown status.",
    ["msg_external_providers_detected"] = "External traffic recording providers detected. ntopng can automatically bind this interface to an external provider. You can let ntopng take care of the recording using this page, or you can <a href=\"%{url}\"><i class=\"fas fa-cog\"></i> configure</a> an external traffic recording provider.",
    ["msg_ok"] = "Ready to extract",
    ["multiple_extracted_files"] = "Traffic extraction generated multiple PCAP files of %{mb} MB, it is possible to change this limit from Preferences. Click on the links below to download the PCAP files.",
    ["no_data_in_interval"] = "There is no (or partial) PCAP data on disk for the selected time interval. Please note that PCAP data is dumped every minute (latest minute is not available) and old data is deleted (please check the current dump window in the <A HREF=\"%{page}\">status page</A>). Please try selecting a different time interval.",
    ["no_file"] = "No files dumped yet",
    ["no_recorded_data"] = "No recorded data in the specified time frame. Traffic recorder needs some time to write recent data and deletes old data according to the configured data retention.",
    ["not_found"] = "File not found",
    ["not_granted"] = "Request not granted",
    ["note_dump"] = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble, start of frame, CRC, IFG]. Such overhead is accounted to the interface traffic, but it is not added to the traffic being dumped on disk. For this reason the number of bytes in this page may differ from those reported in the interface chart.",
    ["packet_dumps"] = "Packet Dumps",
    ["pcap_download"] = "Download PCAP",
    ["pcap_download_message"] = "Start the extraction and check the %{page} page to download the PCAP as soon as the file is ready.",
    ["pcap_extract"] = "Extract PCAP",
    ["processing"] = "Processing",
    ["queue_as_job"] = "Queue as a Job",
    ["recording"] = "Recording",
    ["restart"] = "Restart",
    ["restart_service"] = "Restart the service",
    ["settings"] = "Settings",
    ["smart_continuous_recording"] = "Smart Continuous Traffic Recording",
    ["smart_disk_space"] = "Max Smart Disk Space",
    ["smart_disk_space_note"] = "Maximum disk space used for recording event's traffic (Smart Recording) on disk.",
    ["smart_storage_dir"] = "Smart Storage Directory",
    ["smart_traffic_recording"] = "Smart Traffic Recording",
    ["smart_traffic_recording_note"] = "Move recorded traffic matching selected events (e.g. alerts) to a secondary storage for longer data retention.",
    ["smart_window"] = "Smart Window",
    ["start_extraction"] = "Start Extraction",
    ["stop_job"] = "Stop Job",
    ["stop_job_confirm"] = "Do you really want to stop Job %{job_id}?",
    ["stopped"] = "Stopped",
    ["storage"] = "Storage",
    ["storage_dir"] = "Storage Directory",
    ["storage_directory_config"] = "The Storage Directory path can be changed by specifing the <i>%{option}</i> option into the %{product} configuration file.",
    ["storage_utilization"] = "Storage Utilization",
    ["storage_utilization_pcap"] = "PCAP Storage Utilization",
    ["traffic_extraction_jobs"] = "Traffic Extraction Jobs",
    ["traffic_extractions"] = "Extractions",
    ["traffic_on_disk"] = "Traffic On Disk",
    ["traffic_recording"] = "Traffic Recording",
    ["traffic_recording_note"] = "Enable continuous recording of raw traffic using n2disk.",
    ["traffic_recording_provider"] = "Traffic Recording Provider",
    ["traffic_recording_settings"] = "Traffic Recording Settings",
    ["traffic_recording_status"] = "Traffic Recording Status",
    ["unsupported_fields"] = "Note that the selected chart provides a view of the traffic not fully supported by the extraction tool, extracted traffic will contain more traffic than expected.",
    ["waiting"] = "Waiting",
    ["waiting_nospace"] = "Waiting (No Space On Disk)",
  },
  ["traffic_report"] = {
    ["current_day"] = "Current Day",
    ["current_month"] = "Current Month",
    ["current_week"] = "Current Week",
    ["daily"] = "Daily",
    ["header_daily"] = "Daily report",
    ["header_monthly"] = "Monthly report",
    ["header_weekly"] = "Weekly report",
    ["monthly"] = "Monthly",
    ["previous_day"] = "Previous Day",
    ["previous_month"] = "Previous Month",
    ["previous_week"] = "Previous Week",
    ["weekly"] = "Weekly",
  },
  ["tree_map"] = {
    ["hosts_treemap"] = "Hosts Tree Map",
  },
  ["unknown_devices"] = {
    ["active_only"] = "Active Only",
    ["all_devices"] = "All Devices",
    ["assign_device_pool"] = "Assign Device to a Pool",
    ["assign_pool"] = "Assign To Pool",
    ["device_name"] = "Device Name",
    ["devices_only_note"] = "A device is considered unassigned if there are no pool members defined with such MAC address. IP-based member addresses do not apply here.",
    ["filter_devices"] = "Filter Devices",
    ["first_seen"] = "First Seen",
    ["inactive_only"] = "Inactive Only",
    ["last_seen"] = "Last Seen",
    ["no_pools"] = "An host pool must be created in order to assign unknown devices to.",
    ["select_pool"] = "Please select an host pool from the dropdown below to assign '%{mac}' to:",
    ["unassigned_devices"] = "Unassigned Host Pool Devices",
  },
  ["updates"] = {
    ["available"] = "New",
    ["check"] = "Check for updates",
    ["checking"] = "Checking for updates..",
    ["install"] = "Install update",
    ["install_confirm"] = "Do you want to update and restart ntopng now?",
    ["installing"] = "Installing update..",
    ["maintenance_expired"] = "Please note that maintenance for this product has expired, you need to renew the license after the upgrade.",
    ["no_updates"] = "No updates available",
    ["update_failure_message"] = "Something went wrong during the update, please retry or try manually",
  },
  ["user_activity"] = {
    ["add_ntopng_user"] = "User '%{user}' added new user %{new_user}.",
    ["add_pool"] = "User '%{user}' created new pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["alerts_deleted"] = "User '%{user}' purged '%{status}' alerts.",
    ["bind_pool_member"] = "User '%{user}' added member %{member} to pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["changed_preference"] = "User '%{user}' changed settings for %{pref}.",
    ["delete_ntopng_user"] = "User '%{user}' deleted user %{old_user}.",
    ["delete_pool"] = "User '%{user}' deleted pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["deleted_all_interfaces_data"] = "User '%{user}' deleted data for all interfaces.",
    ["deleted_host_data"] = "User '%{user}' deleted data for host %{host} on interface %{ifname}.",
    ["deleted_inactive_interfaces_data"] = "User '%{user}' deleted data for all inactive interfaces.",
    ["deleted_interface_data"] = "User '%{user}' deleted data for interface %{ifname}.",
    ["deleted_network_data"] = "User '%{user}' deleted data for network %{network} on interface %{ifname}.",
    ["disabled_preference"] = "User '%{user}' disabled preference %{pref}.",
    ["edit_pool"] = "User '%{user}' edited pool <a href=\"%{pool_url}\">%{pool_name}</a>.",
    ["enabled_preference"] = "User '%{user}' enabled preference %{pref}.",
    ["exported_data"] = "User '%{user}' exported JSON data for '%{mode}' hosts.",
    ["exported_data_host"] = "User '%{user}' exported JSON data for '%{mode}' host %{host}.",
    ["file_downloaded"] = "User '%{user}' downloaded file '%{file}'.",
    ["flows_downloaded"] = "User '%{user}' downloaded flows data from %{from} to %{to}.",
    ["host_json_downloaded"] = "User '%{user}' downloaded JSON data for host %{host}.",
    ["live_capture"] = "User '%{user}' captured live traffic on interface %{ifname}.",
    ["live_capture_host"] = "User '%{user}' captured live traffic for host %{host} on interface %{ifname}.",
    ["live_capture_host_with_filter"] = "User '%{user}' captured live traffic for host %{host} matching filter '%{filter}' on interface %{ifname}.",
    ["live_capture_with_filter"] = "User '%{user}' captured live traffic matching filter '%{filter}' on interface %{ifname}.",
    ["live_extraction"] = "User '%{user}' downloaded traffic from interface %{ifname} from %{from} to %{to}.",
    ["live_extraction_with_filter"] = "User '%{user}' downloaded traffic from interface %{ifname} from %{from} to %{to} matching filter '%{filter}'.",
    ["login_not_authorized"] = "Login denied for user '%{user}'.",
    ["login_successful"] = "User '%{user}' logged in.",
    ["password_changed"] = "Password for user '%{pwd_user}' changed by '%{user}' with ip '%{ip}'.",
    ["recording_disabled"] = "User '%{user}' disabled Traffic Recording on interface %{ifname}.",
    ["recording_enabled"] = "User '%{user}' enabled Traffic Recording on interface %{ifname}.",
    ["set_host_alias"] = "User '%{user}' set alias for host %{host} to %{alias}.",
    ["set_pool_config"] = "User '%{user}' imported pool configuration.",
    ["set_scripts_config"] = "User '%{user}' imported checks configuration.",
    ["snmp_device_added"] = "User '%{user}' added SNMP device %{ip}.",
    ["snmp_device_deleted"] = "User '%{user}' deleted SNMP device %{ip}.",
    ["unknown_activity"] = "User '%{user}' did some unknown activity (%{scope}), please report this.",
    ["unknown_activity_function"] = "User '%{user}' did some unknown activity (%{name}), please report this.",
    ["user_added"] = "User '%{add_user}' added by '%{user}'.",
    ["user_deleted"] = "User '%{del_user}' deleted by '%{user}'.",
  },
  ["user_info"] = {
    ["missing_user_name_message"] = "Missing user name",
    ["processes"] = "Processes",
    ["processes_overview"] = "Processes Overview",
    ["top_l4_protocols"] = "Top Protocols",
    ["top_l7_protocols"] = "Top Applications",
  },
  ["users"] = {
    ["add_new_user"] = "Add New User",
    ["add_user"] = "Add User",
    ["assigned_devices"] = "Assigned Devices",
    ["cat_protocols"] = "%{cat} Applications",
    ["categories"] = "Categories",
    ["client_policy"] = "Device As Client",
    ["confirm_delete_user"] = "Do you really want to delete user \"%{user}\"?",
    ["delete_user"] = "Delete User",
    ["delete_user_error"] = "Could not delete the user. Please check out the program log for more details.",
    ["devices"] = "Devices",
    ["edit"] = "Edit",
    ["edit_global_policies"] = "Edit Default Policies",
    ["fallback_policy"] = "Fallback Policy",
    ["full_name"] = "Full Name",
    ["global"] = "Global",
    ["global_policies"] = "Default Policies",
    ["no_users"] = "No users",
    ["num_protocols"] = "Num Applications",
    ["policy"] = "Policy",
    ["protocols"] = "Applications",
    ["reset_to_defaults"] = "Reset To Defaults",
    ["reset_to_defaults_confirm"] = "Do you really want to reset the device type \"%{devtype}\" policies to to the defaults?",
    ["server_policy"] = "Device As Server",
    ["settings"] = "Settings",
    ["total_daily_time_quota"] = "Total Daily Time Quota",
    ["total_daily_traffic_quota"] = "Total Daily Traffic Quota",
    ["unchanged"] = "Unchanged",
    ["user_exists"] = "User \"%{user}\" already exists",
    ["user_x"] = "User: %{user}",
    ["users"] = "Users",
    ["shapers"] = {
      ["default"] = "Default",
      ["drop"] = "Drop",
      ["pass"] = "Pass",
      ["slow"] = "Slow Pass",
      ["slower"] = "Slower Pass",
    },
  },
  ["validation"] = {
    ["FAILED_HTTP_REQUEST"] = "The request failed, please try later.",
    ["empty_name"] = "Please insert a name.",
    ["invalid_input"] = "Please respect the input pattern.",
    ["missing_field"] = "Please fill the input.",
  },
  ["vlan_details"] = {
    ["no_available_stats_for_vlan_message"] = "No available stats for VLAN %{vlan_id}. Please wait a few minutes to allow %{product} to harvest new statistics.",
    ["vlan_alias"] = "VLAN Alias",
    ["vlan_id_parameter_missing_or_invalid_message"] = "VLAN_Id parameter is missing or is not valid",
  },
  ["vlan_stats"] = {
    ["vlan_id"] = "VLAN ID",
    ["vlans"] = "VLANs",
  },
  ["vulnerability_scan"] = {
    ["and_other_n"] = "and other %{n}",
    ["host_alert"] = "%{msg} on <b><a href='%{url}'>%{host}</a></b> using %{scan_type}.",
    ["host_down_case"] = "Host %{host} is not reachable.",
    ["host_not_configured"] = "Host %{host} was not configured.",
    ["new_issues"] = "CVEs changed from %{num_issues} to %{new_cve}",
    ["ports_changed"] = "Open ports changed from %{old_num_ports} to %{new_num_ports}",
    ["report"] = "Vulnerability Scan Report",
    ["solved_issues"] = " %{num_issues} CVEs, %{cve_solved} solved",
    ["ports_changed_cases"] = {
      ["cve_scan_case"] = "TCP Ports changes detected",
      ["new_ports"] = "%{open_ports_num} new %{protocol} open port(s) (%{open_ports})",
      ["ports_closed"] = "%{closed_ports_num} %{protocol} port(s) (%{closed_ports}) is/are now closed",
      ["ports_open_and_closed"] = "%{protocol} (%{open_ports}) and %{protocol} (%{closed_ports}) port(s) is/are now closed",
    },
  },
  ["widgets_page"] = {
    ["actions"] = "Actions",
    ["begin_time"] = "Begin Time",
    ["datasource"] = "Datasource",
    ["end_time"] = "Begin Time",
    ["interface"] = "Interface",
    ["key"] = "Key",
    ["name"] = "Name",
    ["params"] = "Parameters",
    ["type"] = "Type",
    ["widgets"] = "Widgets",
    ["modal"] = {
      ["add_widget"] = "Add Widget",
      ["delete_description"] = "Are you really sure to remove the <b>%{widget}</b>? The widgets in the page will be disabled as well!",
      ["delete_widget"] = "Delete Widget: %{widget}",
      ["edit_widget"] = "Edit Widget: %{widget}",
      ["embed_widget"] = "Embed Widget Tag",
      ["embed_widget_desc_1"] = "Copy and paste this <b>HTML</b> tag in your page",
      ["embed_widget_desc_2"] = " Please be sure to have included the ntop widget script <code>ntop-widgets.js</code> in your page.",
    },
    ["validation"] = {
      ["abort_add"] = "Abort add of a Widget?",
      ["abort_edit"] = "Abort edit of a Widget?",
    },
  },
}

return lang
