#! /usr/pkg/bin/perl

# $NetBSD$

# Copyright (c) 2016 Alistair Crooks <agc@NetBSD.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

use strict;

use ExtUtils::testlib;
use Getopt::Long;

use Netpgp::Verify;

my $keyring = "pubring.gpg";
my $ssh_key = undef;
my $cmd = "verify";

GetOptions("c|cmd=s" => \$cmd,
	   "k|keyring=s" => \$keyring,
           "S|ssh=s" => \$ssh_key);

my $verify = Netpgp::Verify->new();

# read the correct type of keys
if ($ssh_key) {
	$verify->read_ssh_key($ssh_key) || die "can't read ssh key $ssh_key";
} else {
	$verify->read_pubring($keyring) || die "can't read pgp key $keyring";
}

# get the file name to be verified
my $file = $ARGV[$#ARGV - 1];

# ... and do it...
if ($cmd eq "cat") {
	my $out = $verify->cat($file) || die "can't cat $file";
	print $out;
} elsif ($cmd eq "dump") {
	my $out = $verify->dump($file) || die "can't dump $file";
	print $out;
} elsif ($cmd eq "verify") {
	$verify->verify($file) || die "can't verify $file";
}
