/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.LogPanelCellRenderer;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanel;
import org.parosproxy.paros.view.View;

public class LogPanel
extends AbstractPanel
implements Runnable {
    private JScrollPane scrollLog = null;
    private JList listLog = null;
    private HttpPanel requestPanel = null;
    private HttpPanel responsePanel = null;
    private ExtensionHistory extension = null;
    private Vector displayQueue = new Vector();
    private Thread thread = null;
    private LogPanelCellRenderer logPanelCellRenderer = null;

    public LogPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(600, 200);
        this.add((Component)this.getScrollLog(), "Center");
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private JScrollPane getScrollLog() {
        if (this.scrollLog == null) {
            this.scrollLog = new JScrollPane();
            this.scrollLog.setViewportView(this.getListLog());
            this.scrollLog.setHorizontalScrollBarPolicy(31);
            this.scrollLog.setVerticalScrollBarPolicy(22);
            this.scrollLog.setPreferredSize(new Dimension(800, 200));
            this.scrollLog.setName("scrollLog");
        }
        return this.scrollLog;
    }

    public JList getListLog() {
        if (this.listLog == null) {
            this.listLog = new JList();
            this.listLog.setDoubleBuffered(true);
            this.listLog.setCellRenderer(this.getLogPanelCellRenderer());
            this.listLog.setSelectionMode(1);
            this.listLog.setName("ListLog");
            this.listLog.setFont(new Font("Default", 0, 12));
            this.listLog.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() > 1) {
                        LogPanel.this.requestPanel.setTabFocus();
                        return;
                    }
                }
            });
            this.listLog.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (LogPanel.this.listLog.getSelectedValue() == null) {
                        return;
                    }
                    HistoryReference historyReference = (HistoryReference)LogPanel.this.listLog.getSelectedValue();
                    LogPanel.this.readAndDisplay(historyReference);
                }
            });
        }
        return this.listLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndDisplay(HistoryReference historyReference) {
        Vector vector = this.displayQueue;
        synchronized (vector) {
            if (!(ExtensionHistory.isEnableForNativePlatform() && this.extension.getBrowserDialog().isVisible() || this.displayQueue.size() <= 0)) {
                this.displayQueue.clear();
            }
            this.displayQueue.add(historyReference);
        }
        if (this.thread != null && this.thread.isAlive()) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.setPriority(5);
        this.thread.start();
    }

    public void setDisplayPanel(HttpPanel httpPanel, HttpPanel httpPanel2) {
        this.requestPanel = httpPanel;
        this.responsePanel = httpPanel2;
    }

    private void displayMessage(HttpMessage httpMessage) {
        if (httpMessage.getRequestHeader().isEmpty()) {
            this.requestPanel.setMessage(null, true);
        } else {
            this.requestPanel.setMessage(httpMessage, true);
        }
        if (httpMessage.getResponseHeader().isEmpty()) {
            this.responsePanel.setMessage(null, false);
        } else {
            this.responsePanel.setMessage(httpMessage, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HistoryReference historyReference = null;
        int n = 0;
        while (true) {
            Object object = this.displayQueue;
            synchronized (object) {
                n = this.displayQueue.size();
                if (n == 0) {
                    break;
                }
                historyReference = (HistoryReference)this.displayQueue.get(0);
                this.displayQueue.remove(0);
            }
            try {
                object = historyReference;
                final HttpMessage httpMessage = historyReference.getHttpMessage();
                EventQueue.invokeAndWait(new Runnable((HistoryReference)object){
                    private final /* synthetic */ HistoryReference val$finalRef;
                    {
                        this.val$finalRef = historyReference;
                    }

                    public void run() {
                        LogPanel.this.displayMessage(httpMessage);
                        LogPanel.this.checkAndShowBrowser(this.val$finalRef, httpMessage);
                        LogPanel.this.listLog.requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    private void checkAndShowBrowser(HistoryReference historyReference, HttpMessage httpMessage) {
        if (!ExtensionHistory.isEnableForNativePlatform() || !this.extension.getBrowserDialog().isVisible()) {
            return;
        }
        this.extension.browserDisplay(historyReference, httpMessage);
    }

    private LogPanelCellRenderer getLogPanelCellRenderer() {
        if (this.logPanelCellRenderer == null) {
            this.logPanelCellRenderer = new LogPanelCellRenderer();
            this.logPanelCellRenderer.setSize(new Dimension(328, 21));
            this.logPanelCellRenderer.setBackground(Color.white);
            this.logPanelCellRenderer.setFont(new Font("MS Sans Serif", 0, 12));
        }
        return this.logPanelCellRenderer;
    }
}

