<?php
/**
 * @entity asp.DownloadAppLog
 */
abstract class DownloadAppLogDAO extends AppSOY2DAO{

	abstract function insert(DownloadAppLog $bean);

	/**
	 * @final
	 */
	function getLogs(){
//		$this->Toriaezu();
/*
		$sql = "select * from download_app_log";
		$res = $this->executeQuery($sql,array());
		var_dump($res);
*/
		$sql = "select distinct app_name from download_app_log";
		foreach($this->executeQuery($sql,array()) as $app)
		{


			$today  = mktime(0, 0, 0, date("m")  , date("d"), date("Y"));

			$sql = "select app_name,version,count(version) as total_count " .
					" from download_app_log where app_name = :app_name group by version order by version desc";
			try{
				$tmp_res = $this->executeQuery($sql,array(
					":app_name" => $app['app_name']
				));
				foreach($tmp_res as &$version)
				{
					$sql = "select count(version) as today_count from download_app_log where app_name = :app_name and version = :app_version and download_date >= :today_time";
					$tmp = $this->executeQuery($sql,array(
						":app_name" => $app['app_name'],
						":app_version" => $version['version'],
						":today_time" => $today
					));
					$version['today_count'] = $tmp[0]['today_count'];
				}
				//バージョンごとに降順に並び替え
				for($i = 0;$i < count($tmp_res)-1;$i++)
				{
					for($j = count($tmp_res)-1;$j > 0;$j--)
					{
						if(version_compare($tmp_res[$j]['version'],$tmp_res[$j-1]['version']) === 1)
						{

							$temporary = $tmp_res[$j-1];
							$tmp_res[$j-1] = $tmp_res[$j];
							$tmp_res[$j] = $temporary;
						}
					}
				}
			}catch(SOY2DAOException $e){
				echo "<pre>";
				echo $e->getPDOExceptionMessage();
				echo "</pre><hr>";
			}
			$res[$tmp_res[0]['app_name']] = $tmp_res;
		}
//		var_dump($res);
		return $res;
	}


	/**
	 * @columns download_file as file, count(id) as download
	 * @group download_file
	 * @query ip_address <> :ipAddress
	 * @return array
	 */
	abstract function getTotalStatistics($ipAddress);

	/**
	 * @columns download_file as file, count(id) as download
	 * @group download_file
	 * @query ip_address <> :ipAddress AND download_date >= :start AND download_date <= :end
	 * @return array
	 */
	abstract function getStatistics($ipAddress,$start,$end);
	function Toriaezu()
	{
		$log = new DownloadAppLog();
		$log->setDownloadDate(time());
		$log->setDownloadFile("soyboard_100.4.0.zip");
		$log->setIpAddress("192.168.125.2");
		$log->setUserAgenet("TeNyuRyoKu");
		$log->setAppName("soyboard");
		$log->setVersion("5.4.0");
		$this->insert($log);

	}

	abstract function get();

	abstract function getByAppName($appName);

	/**
	 * @columns download_date
	 * @query app_name = :appName
	 * @order download_date asc
	 */
	abstract function getByName($appName);

	/**
	 * @columns download_date
	 * @query app_name = :appName and version = :version
	 * @order download_date asc
	 */
	abstract function getByNameAndVersion($appName, $version);

	/**
	 * @columns download_date
	 * @order download_date asc
	 */
	abstract function getAll();



}
?>