require 'test/unit'

module Borges;end
require 'Borges/Callback/Callback'
require 'Borges/Callback/ValueCallback'
require 'Borges/Callback/CallbackStore'

class ValueCallbackTest < Test::Unit::TestCase

  def setup
    @callback = Borges::ValueCallback.new do
      "called"
    end
  end

  def test_value_callback?
    assert @callback.value_callback?, "Is a value callback"
  end

  def test_evaluate
    assert_equal "called",
                 @callback.evaluate("value", nil),
                 "Callback is called"
  end

  def test_evaluate_with_value
    @callback = Borges::ValueCallback.new do |value|
      "called with #{value}"
    end

    assert_equal "called with value",
                 @callback.evaluate("value", nil),
                 "Value is passed to callback"
  end

end # class ValueCallbackTest


