/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import writer2latex.util.Misc;

public class LaTeXDocumentPortion {
    private Vector nodes;
    private StringBuffer curText;
    private boolean bEmpty;
    private boolean bWrap;

    public LaTeXDocumentPortion(boolean bWrap) {
        this.bWrap = bWrap;
        this.nodes = new Vector();
        this.curText = new StringBuffer();
        this.bEmpty = true;
    }

    public LaTeXDocumentPortion append(LaTeXDocumentPortion ldp) {
        if (!this.bEmpty) {
            this.nodes.add(this.curText);
            this.curText = new StringBuffer();
            this.bEmpty = true;
        }
        this.nodes.add(ldp);
        return this;
    }

    public LaTeXDocumentPortion append(String s) {
        this.curText.append(s);
        this.bEmpty = false;
        return this;
    }

    public LaTeXDocumentPortion nl() {
        this.curText.append("\n");
        this.bEmpty = false;
        return this;
    }

    private void writeSegment(String s, int nStart, int nEnd, OutputStreamWriter osw) throws IOException {
        int i = nStart;
        while (i < nEnd) {
            osw.write(s.charAt(i));
            ++i;
        }
    }

    private void writeBuffer(StringBuffer text, OutputStreamWriter osw, int nLineLen, String sNewline) throws IOException {
        String s = text.toString();
        int nLen = s.length();
        int[] nBreakPoints = new int[100];
        int nLastBPIndex = 99;
        int nStart = 0;
        while (nStart < nLen) {
            int nBPIndex = 0;
            boolean bEscape = false;
            boolean bComment = false;
            int nNewline = nStart;
            while (nNewline < nLen) {
                char c;
                if (nBPIndex == nLastBPIndex) {
                    nBreakPoints = Misc.doubleIntArray(nBreakPoints);
                    nLastBPIndex = nBreakPoints.length - 1;
                }
                if ((c = s.charAt(nNewline)) == '\n') {
                    nBreakPoints[nBPIndex++] = nNewline;
                    break;
                }
                if (bEscape) {
                    bEscape = false;
                } else if (c == '\\') {
                    bEscape = true;
                } else if (c == '%') {
                    bComment = true;
                } else if (!bComment && c == ' ') {
                    nBreakPoints[nBPIndex++] = nNewline;
                }
                ++nNewline;
            }
            if (nBPIndex == nLastBPIndex) {
                nBreakPoints = Misc.doubleIntArray(nBreakPoints);
                nLastBPIndex = nBreakPoints.length - 1;
            }
            if (nNewline == nLen) {
                nBreakPoints[nBPIndex++] = nNewline;
            }
            int nCurLineLen = nBreakPoints[0] - nStart;
            this.writeSegment(s, nStart, nBreakPoints[0], osw);
            int i = 0;
            while (i < nBPIndex - 1) {
                int nSegmentLen = nBreakPoints[i + 1] - nBreakPoints[i];
                if (nSegmentLen + nCurLineLen > nLineLen) {
                    osw.write(sNewline);
                    nCurLineLen = nSegmentLen;
                } else {
                    osw.write(" ");
                    nCurLineLen += nSegmentLen;
                }
                this.writeSegment(s, nBreakPoints[i] + 1, nBreakPoints[i + 1], osw);
                ++i;
            }
            osw.write(sNewline);
            nStart = nNewline + 1;
        }
    }

    private void writeBuffer(StringBuffer text, OutputStreamWriter osw, String sNewline) throws IOException {
        String s = text.toString();
        int nLen = s.length();
        int nStart = 0;
        while (nStart < nLen) {
            int nNewline = nStart;
            while (nNewline < nLen) {
                if (s.charAt(nNewline) == '\n') break;
                ++nNewline;
            }
            this.writeSegment(s, nStart, nNewline, osw);
            osw.write(sNewline);
            nStart = nNewline + 1;
        }
    }

    public void write(OutputStreamWriter osw, int nLineLen, String sNewline) throws IOException {
        int n = this.nodes.size();
        int i = 0;
        while (i < n) {
            if (this.nodes.get(i) instanceof LaTeXDocumentPortion) {
                ((LaTeXDocumentPortion)this.nodes.get(i)).write(osw, nLineLen, sNewline);
            } else if (this.bWrap && nLineLen > 0) {
                this.writeBuffer((StringBuffer)this.nodes.get(i), osw, nLineLen, sNewline);
            } else {
                this.writeBuffer((StringBuffer)this.nodes.get(i), osw, sNewline);
            }
            ++i;
        }
        if (!this.bEmpty) {
            if (this.bWrap && nLineLen > 0) {
                this.writeBuffer(this.curText, osw, nLineLen, sNewline);
            } else {
                this.writeBuffer(this.curText, osw, sNewline);
            }
        }
    }
}

