/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.content.StarMathConverter;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public final class MathmlConverter
extends ConverterHelper {
    private StarMathConverter smc;
    private boolean bContainsFormulas = false;

    public MathmlConverter(Config config, ConverterPalette palette) {
        super(config, palette);
        this.smc = new StarMathConverter(palette.getI18n(), config);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bContainsFormulas) {
            if (this.config.useOoomath()) {
                pack.append("\\usepackage{ooomath}").nl();
            } else {
                this.smc.appendDeclarations(pack, decl);
            }
            decl.append("\\everymath{\\displaystyle}").nl();
        }
    }

    public String convert(Node settings, Node formula) {
        Element annotation;
        Element semantics = Misc.getChildByTagName(formula, "math:semantics");
        if (semantics != null && (annotation = Misc.getChildByTagName(semantics, "math:annotation")) != null) {
            String sStarMath = "";
            if (annotation.hasChildNodes()) {
                NodeList anl = annotation.getChildNodes();
                int nLen = anl.getLength();
                int i = 0;
                while (i < nLen) {
                    if (anl.item(i).getNodeType() == 3) {
                        sStarMath = sStarMath + anl.item(i).getNodeValue();
                    }
                    ++i;
                }
                this.bContainsFormulas = true;
                return this.smc.convert(sStarMath);
            }
        }
        return "\\text{Warning: No StarMath annotation}";
    }
}

