/*
 * Decompiled with CFR 0.152.
 */
package sax.helpers;

import org.xml.sax.AttributeList;

public class AttributeListImpl
implements AttributeList {
    private ListNode head;
    private ListNode tail;
    private int length;

    public void addAttribute(String string, String string2, String string3) {
        ListNode listNode = new ListNode(string, string2, string3);
        if (this.length == 0) {
            this.head = listNode;
        } else {
            this.tail.next = listNode;
        }
        this.tail = listNode;
        ++this.length;
    }

    public int getLength() {
        return this.length;
    }

    public String getName(int n) {
        ListNode listNode = this.getNodeAt(n);
        return listNode != null ? listNode.name : null;
    }

    private ListNode getNodeAt(int n) {
        ListNode listNode = this.head;
        while (listNode != null) {
            if (--n == -1) {
                return listNode;
            }
            listNode = listNode.next;
        }
        return null;
    }

    private ListNode getNodeAt(String string) {
        if (string != null) {
            ListNode listNode = this.head;
            while (listNode != null) {
                if (listNode.name.equals(string)) {
                    return listNode;
                }
                listNode = listNode.next;
            }
        }
        return null;
    }

    public String getType(int n) {
        ListNode listNode = this.getNodeAt(n);
        return listNode != null ? listNode.type : null;
    }

    public String getType(String string) {
        ListNode listNode = this.getNodeAt(string);
        return listNode != null ? listNode.type : null;
    }

    public String getValue(int n) {
        ListNode listNode = this.getNodeAt(n);
        return listNode != null ? listNode.value : null;
    }

    public String getValue(String string) {
        ListNode listNode = this.getNodeAt(string);
        return listNode != null ? listNode.value : null;
    }

    public void insertAttributeAt(int n, String string, String string2, String string3) {
        if (this.length == 0 || n >= this.length) {
            this.addAttribute(string, string2, string3);
            return;
        }
        ListNode listNode = new ListNode(string, string2, string3);
        if (n < 1) {
            listNode.next = this.head;
            this.head = listNode;
        } else {
            ListNode listNode2 = this.getNodeAt(n - 1);
            listNode.next = listNode2.next;
            listNode2.next = listNode;
        }
        ++this.length;
    }

    public void removeAttributeAt(int n) {
        if (this.length == 0) {
            return;
        }
        if (n == 0) {
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
            --this.length;
        } else {
            ListNode listNode = this.getNodeAt(n - 1);
            ListNode listNode2 = this.getNodeAt(n);
            if (listNode2 != null) {
                listNode.next = listNode2.next;
                if (listNode2 == this.tail) {
                    this.tail = listNode;
                }
                --this.length;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append("len=");
        stringBuffer.append(this.length);
        stringBuffer.append(", {");
        ListNode listNode = this.head;
        while (listNode != null) {
            stringBuffer.append(listNode.name);
            if (listNode.next != null) {
                stringBuffer.append(", ");
            }
            listNode = listNode.next;
        }
        stringBuffer.append("}]");
        return stringBuffer.toString();
    }

    static class ListNode {
        public String name;
        public String type;
        public String value;
        public ListNode next;

        public ListNode(String string, String string2, String string3) {
            this.name = string;
            this.type = string2;
            this.value = string3;
        }
    }
}

